/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/BaseController","sap/ui/thirdparty/URI","sap/base/Log","sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil","sap/ui/documentation/sdk/util/Resources"],function(e,t,i,n,r){"use strict";var a=sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl"),o=sap.ui.require.toUrl("sap/ui/demo/mock");return e.extend("sap.ui.documentation.sdk.controller.SampleBaseController",{_aMockFiles:["products.json","supplier.json","img.json"],fetchSourceFile:function(e,t,r){return n.fetch(e,t,r).catch(function(e){i.warning(e);return"File not loaded"})},onDownload:function(){sap.ui.require(["sap/ui/thirdparty/jszip"],function(e){var t=new e,i=r.getResourceOriginPath(sap.ui.require.toUrl(this._sId.replace(/\./g,"/"))),n=this.oModel.getData(),s=n.includeInDownload||[],l,u,p=n.customIndexHTML,c=n.files.find(function(e){return e.name.includes("package.json")}),m=n.files.find(function(e){return e.name.includes("ui5.yaml")}),h=[],f=function(e){var i=[];for(var n=0;n<this._aMockFiles.length;n++){var r=this._aMockFiles[n];if(typeof e==="string"&&e.indexOf(r)>-1){i.push(this._addFileToZip({name:this._formatWebAppPath("mockdata/"+r),url:o+"/"+r,formatter:this._formatMockFile},t))}}return Promise.all(i)};for(var d=0;d<n.files.length;d++){var g=n.files[d],_=i+"/"+g.name,I=g.name&&(g.name===n.iframe||g.name.split(".").pop()==="html");if(g.name==="manifest.json"){l=JSON.parse(g.raw);h.push(this._addFileToZip({name:this._formatWebAppPath(g.name),url:_,formatter:this._formatManifestJsFile},t));continue}else if(this._isRootLevelFile(g.name)){continue}else{h.push(this._addFileToZip({name:this._formatWebAppPath(g.name.replace(new RegExp(/(\.\.\/)+/g),"./")),url:_,formatter:I&&!p?this._rewriteRelativeURLs.bind(this):undefined},t));h.push(this.fetchSourceFile(_).then(f.bind(this)))}}if(!n.iframe||r.getHasProxy()){u=n.files.some(function(e){return e.name==="manifest.json"});h.push(this._addFileToZip({name:this._formatWebAppPath("Component.js"),url:i+"/"+"Component.js"},t));if(!p){var v=this._formatWebAppPath("index.html");h.push(this._addFileToZip({name:v,url:a+"/"+(u?"indexevo.html.tmpl":"index.html.tmpl"),formatter:function(e){return this._rewriteRelativeURLs(this._formatIndexHtmlFile(e,n,l),v)}.bind(this)},t,true))}if(!u){var b=this._formatWebAppPath("index.js");h.push(this._addFileToZip({name:b,url:a+"/"+"index.js.tmpl",formatter:function(e){return this._rewriteRelativeURLs(this._formatIndexJsFile(e,n),b)}.bind(this)},t,true))}}s.forEach(function(e){h.push(this._addFileToZip({name:this._formatWebAppPath(e),url:i+"/"+e},t))}.bind(this));
// add generic license file
h.push(this._addFileToZip({name:"LICENSE.txt",url:"LICENSE.txt"},t));h.push(this._addFileToZip({name:"ui5.yaml",url:m?i+"/"+m.name:a+"/ui5.yaml.tmpl",formatter:function(e){return m?this._formatCustomUI5Yaml(e):this._formatUI5Yaml(e,n,l)}.bind(this)},t,true));h.push(this._addFileToZip({name:"package.json",url:c?i+"/"+c.name:a+"/package.json.tmpl",formatter:function(e){return c?e:this._formatPackageJson(e,n)}.bind(this)},t,true));Promise.all(h).then(function(){var e=t.generate({type:"blob"});this._openGeneratedFile(e,this._sId)}.bind(this))}.bind(this))},_openGeneratedFile:function(e,t){sap.ui.require(["sap/ui/core/util/File"],function(i){i.save(e,t,"zip","application/zip")})},_addFileToZip:function(e,t,i){var n=e.name.replace(new RegExp(/(\.+\/)+/g),""),r=e.url,a=e.formatter;return this.fetchSourceFile(r,i).then(function(e){if(e==="File not loaded"){return;// ignore 404 responses, e.g. for Apache license text file in SAPUI5 environment
}if(a){e=a(e,n)}t.file(n,e)})},_formatNameToNpmSpec:function(e){var t;var i=/[^\w_\-\.]+/gi;e=e.replace(i,"").replaceAll(".","-");t=e.split(/(?=[A-Z])/);return t.map(function(e){return e.toLowerCase()}).join("-")},_formatPackageJson:function(e,t){var i=e.replace(/{{TITLE}}/g,t.title).replace(/{{SAMPLE_ID}}/g,this._formatNameToNpmSpec(t.id)),n=JSON.parse(i);return JSON.stringify(n,null,2)},_formatUI5Yaml:function(e,t,i){let n=e.replace(/{{SAMPLE_ID}}/g,this._formatNameToNpmSpec(t.id));const r=this.getModel("versionData").getProperty("/isOpenUI5");const a=this.getModel("versionData").getProperty("/fullVersion");n=n.replace(/{{UI5_KIND}}/g,r?"OpenUI5":"SAPUI5");n=n.replace(/{{UI5_VERSION}}/g,a);if(this._isOpenUI5NightlySDK()){n=n.replace(/libraries:/g,"libraries:"+this._getSnapshotNote())}if(i){const e=i["sap.ui5"];const t=e&&e.dependencies;if(t&&t.libs){Object.keys(t.libs).forEach(function(e){n+="\n    - name: "+e})}}return n},_formatCustomUI5Yaml:function(e){const t=this._isOpenUI5NightlySDK()?this._getSnapshotNote():"";return e.replace(/ #MainVersion#/g,t)},_formatManifestJsFile:function(e){return e.replace(new RegExp(/(\.\.\/)+/g),"./")},_formatIndexHtmlFile:function(e,t,i){let n=e.replace(/{{TITLE}}/g,t.name).replace(/{{SAMPLE_ID}}/g,t.id);if(i){const e=i["sap.ui5"];const t=e&&e.dependencies;if(t&&t.libs&&t.libs["sap.ui.fl"]){n=n.replace(/<script id="sap-ui-bootstrap"/g,'<script id="sap-ui-bootstrap"\n\t\tdata-sap-ui-flexibilityServices=\'[{"connector": "LocalStorageConnector"}]\'')}}return n},_formatIndexJsFile:function(e,t){return e.replace(/{{TITLE}}/g,t.name).replace(/{{SAMPLE_ID}}/g,t.id).replace(/{{HEIGHT}}/g,t.stretch?'height : "100%", ':"").replace(/{{SCROLLING}}/g,!t.stretch)},_formatMockFile:function(e){var t="test-resources/sap/ui/documentation/sdk/images/",i="https://sdk.openui5.org/test-resources/sap/ui/documentation/sdk/images/",n=new RegExp(t,"g");return e.replace(n,i)},_rewriteRelativeURLs:function(e,t){const i=/(?<!data-sap-ui-testsuite=)(['"])(?:[a-zA-Z0-9./])*(resources|test-resources)\//g;const n=this._getRelativePathToRoot(t);return e.replaceAll(i,"$1"+n+"$2/")},_getRelativePathToRoot:function(e){const t=e.split("/").length-2;return"../".repeat(t)},_formatWebAppPath:function(e){const t="webapp/";return e.startsWith(t)?e:t+e},_isRootLevelFile:function(e){return["package.json","ui5.yaml"].includes(e)},_isOpenUI5NightlySDK:function(){const e=this.getModel("versionData"),t=e.getProperty("/isDevVersion"),i=e.getProperty("/isDevEnv"),n=e.getProperty("/isOpenUI5");return t&&n&&!i},_getSnapshotNote:function(){return"\n  # Note: Consumption of SNAPSHOT versions is only available to SAP employees from within the corporate network.\n"+"  # If this does not apply to you, please adjust the UI5 version to the latest stable version either manually\n"+'  # or using the command "ui5 use latest".'}})});
//# sourceMappingURL=SampleBaseController.js.map