/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseController","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/controller/util/DocuInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/ResourcesInfo","sap/ui/documentation/sdk/model/libraryData"],function(t,e,a,o,n,i,s){"use strict";var r={API:"api",TOPIC:"topic",RESOURCES:"resources",ENTITY:"entity",DEMO_APPS:"demoApps"};var u={};u[r.API]={getData:e.getIndexJsonPromise,formatNode:function(t){return{name:t.name,href:r.API+"/"+t.name,hidden:t.visibility!=="public"}}};u[r.TOPIC]={getData:function(t){return a.getDocuIndexPromise(t)},formatNode:function(t){return{name:t.text,href:r.TOPIC+"/"+t.key}}};u[r.ENTITY]={getData:n.loadData,formatNode:function(t){return{name:t.id,href:r.ENTITY+"/"+t.id}}};u[r.DEMO_APPS]={getData:s.getDemoAppsData,formatNode:function(t){return{name:t.name,href:t.ref}}};u[r.RESOURCES]={getData:i.getResourcesConfig,formatNode:function(t){return{name:t.text,href:t.href,hidden:!t.href}}};function c(t,e){var a=[],o,n;for(var i=0;i<t.length;i++){o=t[i];n=u[e].formatNode(o);if(n.hidden!==true){a.push(n)}}return a}return t.extend("sap.ui.documentation.sdk.controller.Sitemap",{onInit:function(){this.oPage=this.byId("sitemapPage");this.oModel=new o;this.getView().setModel(this.oModel);this._oData={};this.getRouter().getRoute("sitemap").attachPatternMatched(this._onMatched,this)},_onMatched:function(){this.hideMasterSide();this.oPage.setBusy(true);this._loadResources().then(function(){this.oPage.setBusy(false);this.oModel.setData(this._oData)}.bind(this)).catch(function(){this.onRouteNotFound()}.bind(this));this.appendPageTitle(this.getModel("i18n").getProperty("SITEMAP_TITLE"))},_loadResources:function(){var t=Object.keys(r).map(function(t){var e=r[t];return u[e].getData(this.getConfig()).then(function(t){this._onDataLoaded({data:t,type:e})}.bind(this))},this);return Promise.all(t)},_onDataLoaded:function(t){switch(t.type){case r.API:this._onApiRefData(t.data);break;case r.TOPIC:this._onTopicsData(t.data);break;case r.ENTITY:this._onSamplesData(t.data);break;case r.DEMO_APPS:this._onDemoAppsData(t.data);break;case r.RESOURCES:this._onResourcesData(t.data);break}},_getDocuIndexPromise:function(){return a.getDocuIndexPromise(this.getConfig())},_onApiRefData:function(t){var e=r.API,a;a=t.reduce(function(t,a){if(a.visibility==="public"&&a.nodes){return t.concat(c(a.nodes,e))}return t},[]);this._oData[e]=a},_onTopicsData:function(t){var e=r.TOPIC;this._oData[e]=c(t,e)},_onSamplesData:function(t){var e=r.ENTITY;this._oData[e]=c(t.entities,e)},_onDemoAppsData:function(t){var e=r.DEMO_APPS;this._oData[e]=c(t.demoApps,e)},_onResourcesData:function(t){var e=r.RESOURCES;this._oData[e]=c(t,e)},onNavButtonPress:function(){this.getRouter().myNavBack("welcome")}})});
//# sourceMappingURL=Sitemap.controller.js.map