/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/ResizeHandler","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/DocumentationLoader","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap","sap/ui/documentation/sdk/controller/util/SidyBySideImageMap","sap/m/LightBox","sap/m/LightBoxItem","./util/DataTableHelper","./util/DataTable","sap/m/Button","sap/m/MessageToast","sap/ui/dom/includeStylesheet","sap/ui/dom/includeScript","sap/ui/util/openWindow","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/events/KeyCodes"],function(jQuery,t,e,i,n,s,a,o,r,h,l,c,u,d,g,p,f,m,b,T,y){"use strict";var _="https://sap.github.io/openui5-docs/#/",D={SPECIAL_CHARS:/[\\\/:*\?"<>|]/g,SPACES:/\s+/g};return e.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){var t,e;this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass("docuPage");this.oHtml=this.byId("staticContent");this.aWaitingDatatables=[];this.aResponsiveImageMaps=[];this.oLayout=this.byId("staticContentLayout");this.oHtml.attachEvent("afterRendering",this._onHtmlRendered.bind(this));this._oConfig=e=this.getConfig();this.oMatchedTopicDataTablesConfig={};this.fnOnPageKeyDownListener=this._onPageKeyDown.bind(this);document.addEventListener("keydown",this.fnOnPageKeyDownListener);if(!window.hljs){f("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"})}f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-2.0.1/css/dataTables.jqueryui.css");f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-2.0.1/css/dataTables.jqueryui.css");f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/css/buttons.jqueryui.css");f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/css/buttons.dataTables.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-2.0.1/js/dataTables.js"}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-2.0.1/js/dataTables.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/js/dataTables.buttons.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/js/buttons.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/js/buttons.html5.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-3.0.0/js/buttons.colVis.js"})}).then(function(){t=a.getResourceOriginPath(e.docuPath+"dataTablesConfig.json");return jQuery.ajax({url:t})}).then(function(t){this.oDataTablesConfig=t;this.bDataTablesPluginLoaded=true;this._getDataTableHelper().addMiddlewares();if(this.aWaitingDatatables.length>0){this.aWaitingDatatables.forEach(function(t){this._enableDataTable(t)},this);this.aWaitingDatatables=[]}}.bind(this));this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this.jsonDefModel=new i;this.getView().setModel(this.jsonDefModel)},onBeforeRendering:function(){var e=this.getView().getDomRef();if(e&&this.fnOnPageClickListener){e.removeEventListener("click",this.fnOnPageClickListener)}t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){var e=this.getView().getDomRef();this.fnOnPageClickListener=this._onPageClick.bind(this);if(e){e.addEventListener("click",this.fnOnPageClickListener)}t.register(this.getView().getDomRef(),this._onResize.bind(this));n.orientation.attachHandler(this._onOrientationChange,this)},_getCopyButtons:function(t){var e="Copied to clipboard.";this.aButtonElements=t.querySelectorAll(".copyButton");this.aButtonElements.forEach(function(t){var i=new g({icon:"sap-icon://copy"});i.placeAt(t);t.addEventListener("click",function(){var i=document.createElement("textarea");i.value=t.parentNode.innerText;document.body.appendChild(i);i.select();document.execCommand("copy");document.body.removeChild(i);p.show(e)})})},onExit:function(){this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this);document.removeEventListener("keydown",this.fnOnPageKeyDownListener);if(this.highlighter){this.highlighter.destroy()}},_onResize:function(){this.aResponsiveImageMaps.forEach(function(t){t.resize()})},_onPageClick:function(t){var e=t.target,i=e.classList,n=i.contains("collapsible-icon"),s=i.contains("lightbox-img"),a;if(s){this._onThumbnailClicked(e)}if(n){a=e.parentNode;a.classList.toggle("expanded")}},_onPageKeyDown:function(t){if(t.ctrlKey&&t.which===y.F){this._openAllCodeSamples()}},_onThumbnailClicked:function(t){var e=this._getLightBox(),i=e.getImageContent()[0],n=t.getAttribute("src"),s=t.getAttribute("title"),a=t.getAttribute("alt");i.setImageSrc(n);i.setTitle(s);i.setAlt(a);e.open()},_getLightBox:function(){if(!this._oLightBox){this._oLightBox=new l({imageContent:new c})}return this._oLightBox},_getDataTableHelper:function(){return u.getInstance()},_onHtmlResourceLoaded:function(t){t.bIsPhone=n.system.phone;t.topicURL=this.sTopicURL;if(t.shortdesc){t.shortdesc=t.shortdesc.trim().replace(/(\r\n|\n|\r)/gm," ")}this.jsonDefModel.setData(t);this.oHtml.setContent(t.html);this.oLayout.invalidate();this._scrollContentToTop();this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));this.appendPageTitle(this.getModel().getProperty("/topictitle1"))},_onTopicMatched:function(t){var e=this.getRouter()._decodeDocumentationRouteArguments(t.getParameter("arguments")),i=e.options;this.sTopicId=e.topicId;this.sSubTopicId=e.subTopicId;this.sTopicURL=e.topicURL;this.sQueryFromUrl=i&&i.q?decodeURIComponent(i.q):"";o.getInstance(this._oConfig).fetch(this.sTopicURL).then(this._onHtmlResourceLoaded.bind(this)).catch(this.onRouteNotFound.bind(this))},_onHtmlRendered:function(){this._getDataTableHelper().destroyDatatables();var t,e=this.oPage.$().find("#d4h5-main-container :not(.imagemap_sidebyside)>.imagemap"),i=this.oPage.$().find("#d4h5-main-container .imagemap_sidebyside"),n=this.oPage.$().find("#d4h5-main-container table.datatable"),s=this.oPage.$().find("#d4h5-main-container img"),o=this.oLayout.getDomRef();this._fixExternalLinks(o);this._getCopyButtons(o);this._computeColumnGroupValues(o);if(this.sSubTopicId){t=document.getElementById(this.sSubTopicId);if(t){if(s.length){var r=[];s.each(function(t,e){var i=new Promise(function(t){e.onload=function(){t()};e.onerror=function(){t()}});r.push(i)});Promise.all(r).then(function(){t.scrollIntoView(true)})}t.scrollIntoView(true)}}this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});this.aResponsiveImageMaps=[];if(n.length){n.each(function(t,e){if(this.bDataTablesPluginLoaded){this._enableDataTable(e)}else{this.aWaitingDatatables.push(e)}}.bind(this))}e.each(function(t,e){this._enableImageMap(e)}.bind(this));i.each(function(t,e){this._enableImageMap(e,true)}.bind(this));s.each(function(t,e){var i=e.getAttribute("src");e.setAttribute("src",a.getResourceOriginPath(i))});if(window.hljs){document.querySelectorAll('pre:not([class*="lines"])').forEach(function(t){window.hljs.highlightElement(t)})}var h=this.getOwnerComponent().getModel("searchData");var l=h.getProperty("/topicQuery");if(l){this._updateHighlighting(l)}if(this.sQueryFromUrl){this._openAllCodeSamples();this._updateHighlighting(this.sQueryFromUrl)}},_updateHighlighting:function(t){var e=this.getView().getDomRef();if(this.highlighter){this.highlighter.highlight(t)}else if(t){this.highlighter=new T(e,{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});this.highlighter.highlight(t)}},_openAllCodeSamples:function(){var t=document.querySelectorAll(".collapsible-icon");t.forEach(function(t){var e=t.parentNode;e.classList.add("expanded")})},_enableImageMap:function(t,e){var i=t.querySelector("img"),n,s,a=/<img[^>]+src="([^">]+)/g,o=this;if(i.complete){this._addResponsiveImageMap(t,e)}else{n=new Image;n.onload=function(){o._addResponsiveImageMap(t,e)};s=a.exec(i.outerHTML);if(s){n.src=s&&s[1]}}},_enableDataTable:function(t){var e=t.id,i=Object.assign(this._getDataTableConfig(e)),n;if(i){n=(new d).init(e,t,i);this._getDataTableHelper().addDatatable(n)}},_getDataTableConfig:function(t){var e=this.oDataTablesConfig[this.sSubTopicId]||this.oDataTablesConfig[this.sTopicId]||{};return e[t]},_addResponsiveImageMap:function(t,e){var i=e?h:r;this.aResponsiveImageMaps.push(new i(t))},_fixExternalLinks:function(t){var e=t.querySelectorAll("a.external-link"),i,n,s,a="http://help.sap.com/disclaimer?site=";for(i=0;i<e.length;i++){n=e[i];s=n.getAttribute("href");n.setAttribute("href",a+s);this._addIconToExternalUrl(n,s)}},_computeColumnGroupValues:function(t){var e,i,n,s,a,o=t.querySelectorAll("colgroup");o=[].slice.call(o);o.forEach(function(t){e=0;n=[];a=[].slice.call(t.children);a.forEach(function(t,s){i=parseInt(t.getAttribute("width"));n[s]=i;e+=i});a.forEach(function(t,i){s=n[i]/e*100;t.setAttribute("width",s+"%")})})},_addIconToExternalUrl:function(t,e){var i=this._isSAPHostedUrl(e),n="Information published on "+(i?"":"non ")+"SAP site",s=new Image,a=i?"link-sap":"link-external";s.onload=function(){t.appendChild(s)};s.src="./resources/sap/ui/documentation/sdk/images/"+a+".png";s.setAttribute("title",n);s.className="sapUISDKExternalLink"},_isSAPHostedUrl:function(t){return/^https?:\/\/([\w.]*\.)?(?:sap|hana\.ondemand|sapfioritrial)\.com/.test(t)},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1)}},_formatHTML:function(t){return"<div>"+t+"</div>"},backToSearch:function(t){this.onNavBack()},onToggleFullScreen:function(t){s.updateMode(t,this.getView(),this)},onEditGitHubPress:function(t){b(this.jsonDefModel.getProperty("/mdEditLink"))},_formatToGitHubUrl:function(t,e){var i=e.trim().replace(D.SPECIAL_CHARS,"").replace(D.SPACES,"_");i+="_";i+=t.split("/").pop().substring(0,7);i+=".md";return _+i}})});
//# sourceMappingURL=TopicDetail.controller.js.map