/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/thirdparty/URI","sap/base/Log"],function(e,t,n){"use strict";const i={CONSENT_PREFERENCES_ORIGIN:"https://consent-pref.trustarc.com",BASE_URL:"https://consent.trustarc.com/notice",URL_QUERY:"?domain=ui5.sap.com&c=teconsent&gtm=1&pcookie&js=nj&noticeType=bb&pn=1-0&privacypolicylink=https%3A%2F%2Fwww.sap.com%2Fabout%2Flegal%2Fprivacy.html&text=true&gtm=1",get COMPLETE_URL(){return this.BASE_URL+this.URL_QUERY},CONSENT_BAR_ID:"teconsent",get CONSENT_BAR_HTML(){return`<div id="consent_blackbar" style="position: fixed; bottom: 0px; z-index: 1000000; width: 100%;"></div>\n                    <div id="${this.CONSENT_BAR_ID}"></div>`},CATEGORIES:{REQUIRED_COOKIES:"Required Cookies",FUNCTIONAL_COOKIES:"Functional Cookies",ADVERTISING_COOKIES:"Advertising Cookies"},CONSENT_DECISION:{FOR_CATEGORY:{PENDING:0,REQUIRED_COOKIES_PERMITTED:1,FUNCTIONAL_COOKIES_PERMITTED:2,ADVERTISING_COOKIES_PERMITTED:3},FOR_DOMAIN:{OPTED_OUT:0,OPTED_IN:1,NO_PREFERENCE:2}},DOMAINS:{FOR_DISPLAY_SETTINGS:["ui5.sap.com","openui5.hana.ondemand.com"],FOR_VIDEOS:["youtube.com","www.youtube.com"],OF_THIRD_PARTY_INTEREST:["google.com"]},CONSENT_PREFERENCES_ORIGIN_WHITELIST:["https://consent-pref.trustarc.com",window.origin]};const o={LIST:["ui5.sap.com","sdk.openui5.org"],REGEX:/^(sapui5|openui5)([a-zA-Z0-9]+(\.[a-zA-Z0-9]+)*)?\.hana\.ondemand\.com$/};const s=i.CATEGORIES,r=i.CONSENT_DECISION.FOR_CATEGORY,c=i.CONSENT_DECISION.FOR_DOMAIN;var a=e.extend("sap.ui.documentation.sdk.controller.util.DefaultConsentManager",{constructor:function(e,t){this._oCmponent=e;this._oConfigUtil=e.getConfigUtil();this._sConsentDialogComponentId=t.defaultConsentDialogComponentId;this._oConsentDialogComponent=null;this._oLoadPromise=null;this._load()},_load:function(){if(!this._oLoadPromise){this._oLoadPromise=this._oCmponent.createComponent({usage:"cookieSettingsDialog",id:"cookiesComp-"+this._sConsentDialogComponentId}).then(function(e){this._oConsentDialogComponent=e;e.enable(this._oCmponent.getRootControl())}.bind(this))}return this._oLoadPromise},checkUserAcceptsToPersistDisplaySettings(e){var t=this._oConfigUtil.getCookieValue(this._oConfigUtil.COOKIE_NAMES.ALLOW_FUNCTIONAL_COOKIES)==="1";e(t)},checkUserAcceptsUsageTracking(e){e(false)},showPreferencesDialog:function(e){this._load().then(function(){this._oConsentDialogComponent.openCookieSettingsDialog({showCookieDetails:true},e)}.bind(this))},supportsWaitForPreferencesSubmission(){return false},waitForPreferencesSubmission:function(){throw new Error("Not supported. Check supportsWaitForPreferencesSubmission method first.")},exit:function(){if(this._oConsentDialogComponent){this._oConsentDialogComponent.destroy()}}});var u=a.extend("sap.ui.documentation.sdk.controller.util.ThirdPartyConsentManager",{constructor:function(){this._oGetDecisionPromise=null},checkUserAcceptsToPersistDisplaySettings(e){this.getConsentDecision(function(t){var n=t>=r.FUNCTIONAL_COOKIES_PERMITTED,i=false;if(n){i=!this._areAdditionalPreferencesSpecified(s.FUNCTIONAL_COOKIES)||this._checkAdditionalPreferencesAllowDisplaySettings()}e(i)}.bind(this))},checkUserAcceptsUsageTracking(e){this.getConsentDecision(function(t){var n=t>=r.FUNCTIONAL_COOKIES_PERMITTED,i=false;if(n){i=!this._areAdditionalPreferencesSpecified(s.FUNCTIONAL_COOKIES)||this._checkAdditionalPreferencesAllowUsageTracking()}e(i)}.bind(this))},getConsentDecision:function(e){var t=this._getConsentDecisionSync(),n=t>r.PENDING;if(n){e(t);return}this._getConsentDecisionAsync().then(e)},_checkAdditionalPreferencesAllowUsageTracking:function(){var e=this._getAdditionalPreferencesPerDomain(s.FUNCTIONAL_COOKIES),t=Object.keys(e).filter(this._isDomainForUsageTracking),n=function(t){return parseInt(e[t])===c.OPTED_IN};return t.every(n)},_checkAdditionalPreferencesAllowDisplaySettings:function(){var e=this._getAdditionalPreferencesPerDomain(s.FUNCTIONAL_COOKIES);return i.DOMAINS.FOR_DISPLAY_SETTINGS.every(function(t){return this._isDomainOptedIn(t,e)}.bind(this))},_isDomainOptedIn:function(e,t){return parseInt(t[e])===c.OPTED_IN},_getConsentDecisionSync:function(){return window.truste?.cma?.callApi("getConsentDecision",d())?.consentDecision},_getConsentDecisionAsync:function(){if(!this._oGetDecisionPromise){this._oGetDecisionPromise=new Promise(function(e,t){function n(){var t=this._getConsentDecisionSync();if(t===r.PENDING){this.waitForPreferencesSubmission().then(function(){e(this._getConsentDecisionSync())}.bind(this))}else{e(t)}}if(!this._isTrustArcReady()){this._load().then(this._waitForTrustArcReady.bind(this)).then(n.bind(this))}else{n.call(this)}}.bind(this))}return this._oGetDecisionPromise},_areAdditionalPreferencesSpecified:function(e){var t=this._getAdditionalPreferencesPerDomain(e);return Object.keys(t).length>0},_getAdditionalPreferencesPerDomain:function(e){var t=window.truste?.cma?.callApi("getConsentCategories",d())?.categories,n=t&&t[e],i={};if(n){i=t[e]?.domains;i=Object.assign({},i)}return i},_isTrustArcReady:function(){return typeof truste!=="undefined"&&window.truste.cma},_waitForTrustArcReady:function(){return new Promise(function(e,t){var i=setInterval(function(){if(typeof truste!=="undefined"&&window.truste.cma){clearInterval(i);n.trace("TrustArc API is ready");e()}},100)})},supportsWaitForPreferencesSubmission(){return true},waitForPreferencesSubmission:function(){return new Promise(function(e,t){var n=this._composeApiRequest("getConsentDecision");window.top.postMessage(n,"*");var o=function(t){if(!i.CONSENT_PREFERENCES_ORIGIN_WHITELIST.includes(t.origin)){return}var n=this._convertResponseToObject(t.data);if(n&&n.source==="preference_manager"&&n.message==="submit_preferences"){e();window.removeEventListener("message",o)}}.bind(this);window.addEventListener("message",o,false)}.bind(this))},_composeApiRequest:function(e){const t={PrivacyManagerAPI:{action:e,timestamp:(new Date).getTime(),self:d()}};return JSON.stringify(t)},_convertResponseToObject:function(e){if(e&&typeof e==="object"){return e}if(e&&typeof e==="string"){try{return JSON.parse(e)}catch(e){n.warning("Unknown message format: ",e);return null}}},_load:function(){return new Promise(function(e,t){if(this._isTrustArcScriptIncluded()){e();return}var i=this._appendTrustArcConsentBar(),o=this._createTrustArcScriptElement();o.addEventListener("load",function(){n.trace("TrustArc initialization stript loaded successfully");e()});o.addEventListener("error",function(e){n.error("Error loading TrustArc initialization stript ",e);t()});this._appendDOMElementAfter(o,i)}.bind(this))},_appendTrustArcConsentBar:function(){var e=document.getElementById(i.CONSENT_BAR_ID);if(!e){var t=this._createHTMLforTrustArc();document.body.insertBefore(t,document.body.firstChild);e=document.getElementById(i.CONSENT_BAR_ID)}return e},_createHTMLforTrustArc:function(){var e=document.createElement("div");e.innerHTML=i.CONSENT_BAR_HTML;return e},_appendDOMElementAfter:function(e,t){const n=t.parentNode;if(n.lastChild===t){n.appendChild(e)}else{n.insertBefore(e,t.nextSibling)}},_createTrustArcScriptElement:function(){var e=document.createElement("script");e.src=i.COMPLETE_URL;e.async=true;e.crossOrigin="anonymous";return e},_isTrustArcScriptIncluded:function(){const e=document.getElementsByTagName("script");for(let t=0;t<e.length;t++){const n=e[t].getAttribute("src");if(n&&n.startsWith(i.BASE_URL)){return true}}return false},showPreferencesDialog:function(){this._load().then(function(){var e="#"+i.CONSENT_BAR_ID+" a",t=document.querySelector(e);if(t){this._simulateClick(t)}}.bind(this))},_simulateClick:function(e){var t=new MouseEvent("click",{view:window,bubbles:true,cancelable:true});e.dispatchEvent(t)},_isDomainForUsageTracking:function(e){return!i.DOMAINS.FOR_DISPLAY_SETTINGS.includes(e)&&!i.DOMAINS.FOR_VIDEOS.includes(e)&&!i.DOMAINS.OF_THIRD_PARTY_INTEREST.includes(e)}});function d(){return new t(window.location.href).hostname()}var _={create:function(e,t){if(this._configIncludesUsageTracking()){return new u(e,t)}else{return new a(e,t)}},_configIncludesUsageTracking:function(){var e=new t(window.location.href);if(e.hasQuery("sap-ui-xx-tracking")){var n=e.query(true)["sap-ui-xx-tracking"];if(n==="true"||n==="false"){return n==="true"}}var i=e.hostname();return _._checkHostnameIsTracked(i)},_checkHostnameIsTracked:function(e){return o.LIST.includes(e)||o.REGEX.test(e)}};return _});
//# sourceMappingURL=CookiesConsentManager.js.map