/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/m/Input","sap/m/library","../config/datatable","./datatable/filters/DataTableFilterDropDown","./datatable/filters/DataTableFilterRange","sap/ui/documentation/sdk/controller/util/Highlighter","./DataTableUtil"],function(t,e,i,n,s,o,a,r){"use strict";var l=i.InputType;function h(){this.oColumns=[];this.oChangedFilters=[];this.aShownRows=[];this.API=null}h.DEFAULT_SORTING="0,asc";h.FILTER_CLASS_WRAPPER="sapUiDocumentationDatatableFilterWrapper";h.FILTER_TYPES={REGEX:"REGEX",NORMAL:"NORMAL",NUMBER:"NUMBER",SELECT:"SELECT",CELL_RANGE:"CELL_RANGE",NUMBER_RANGE:"NUMBER_RANGE"};h.prototype.destroy=function(){this.oColumns.forEach(function(t){if(t.highlighter){t.highlighter.destroy();t.highlighter=null}t.aControls.forEach(function(t){t.destroy()});t.aControls=[]});this.oColumns=[];this.API.destroy()};h.prototype.get=function(t){return this.oConfig[t]};h.prototype.init=function(e,i,n){this.sId=e;this.oDomTable=i;this.oConfig=this.getConfig(e,n);var s=t("#"+e).DataTable(Object.assign(this.oConfig,this.getLifeCycleMethods(e,n)));s.on("draw",function(){if(this.get("highlight")){var t=s.search();if(t||this.oChangedFilters.length){this.oColumns.forEach(function(e,i){var n=this.oChangedFilters[i]&&this.oChangedFilters[i].value,s=Array.isArray(n);if(s){n=n.reduce(function(t,e,i){if(e.value){t+=" "+e.text}return t},"")}if(n&&!(typeof n==="object")){if(t){t+=" "+n}else{t=n}}this.highlight(i,t)},this)}else{this.highlight(null,"")}}}.bind(this));s.buttons().container().insertBefore("#"+e+"_length");s.on("column-visibility.dt",function(t,e,i,n){this.onColumnVisibilityChange(i,n)}.bind(this));this.oConfig.columns.forEach(function(t,e){this.onColumnVisibilityChange(e,t.visible)},this);return this};h.prototype.highlight=function(t,e){if(t===null){this.oColumns.forEach(function(t){t.highlighter.highlight(e)});return}this.oColumns[t].highlighter.highlight(e)};h.prototype.onColumnVisibilityChange=function(t,e){var i=this.oColumns[t]&&this.oColumns[t].filterHeader,n=this.oDomTable.querySelector("colgroup"),s;if(n){s=n.children[t];if(s){s.classList.toggle("hidden",!e)}}if(i){i.toggle(e)}};h.prototype.handleSearch=function(t,e,i,n,s){var o,a,r,l,u=[],f;this.oChangedFilters.forEach(function(n,s){o=e[s];r=n.value;l=n.control;if(r===""){return}switch(true){case l.hasStyleClass(h.FILTER_TYPES.REGEX):case l.hasStyleClass(h.FILTER_TYPES.NORMAL):case l.hasStyleClass(h.FILTER_TYPES.ALPHA_NUMERIC):case l.hasStyleClass(h.FILTER_TYPES.NUMBER):f=o.toLowerCase().indexOf(r.toLowerCase())>-1;break;case l.hasStyleClass(h.FILTER_TYPES.NUMBER_RANGE):var c=r.from!==""?r.from:Number.MIN_SAFE_INTEGER,g=r.to!==""?r.to:Number.MAX_SAFE_INTEGER,E=parseFloat(o)||0;f=isNaN(c)&&isNaN(g)||isNaN(c)&&E<=g||c<=E&&isNaN(g)||c<=E&&E<=g;break;case l.hasStyleClass(h.FILTER_TYPES.CELL_RANGE):var p=o.split("-"),C=parseFloat(r);f=p[0]<=C&&p[1]>=C;break;case l.hasStyleClass(h.FILTER_TYPES.SELECT):var d=r.some(function(t){return t.value});f=!d||r.findIndex(function(e){a=t.aoData[i].anCells[s].querySelectorAll("li");var n=[];if(a.length){for(var r=0;r<a.length;r++){n[r]=a[r].textContent}}else{n.push(o)}return e.value&&n.indexOf(e.text)>-1},this)>-1;break;default:f=true}u.push(f)},this);return u.indexOf(false)<0};h.prototype.getConfig=function(t,e){var i=[],s=JSON.parse(JSON.stringify(n.getPreset()));s.sapTableId=t;s.columnDefs=[];if(e){s.save=e["save"]!==false;s.searching=e["search"]!==false;s.highlight=e["highlight"]!==false;if(e["excel_export"]){s.buttons.push("csv")}if(e["paginate"]){var o=parseInt(e["paginate"]);s.pageLength=o>0?o:-1}s.columns=e.columns.map(function(t,e){var i={visible:true};i.visible=t.visible!==false;if(t.sort){var n=s.columnDefs.find(function(e){return e.type===t.sort});if(n){n.targets.push(e)}else{s.columnDefs.push({type:t.sort,targets:[e]})}}return i});e["initial_sort"]=e["initial_sort"]||h.DEFAULT_SORTING;if(e["initial_sort"]!=="none"){i=e["initial_sort"].split(";");i=i.map(function(t){return t.split(",")})}s.order=i}return s};h.prototype.onFilterChange=function(t,e){this.oChangedFilters[t]={control:e.control,value:e.value};this.API.columns(t).draw()};h.prototype.getSelectOptions=function(e){var i=[];this.API.columns(e).data().unique().sort()[0].forEach(function(e){var n;if(i.indexOf(e)>-1){return}try{n=t(e)}catch(t){n=null}if(n&&n.is("p")){var s=n.text();if(i.indexOf(s)<0){i.push(s)}}else if(n&&n.length>0){n.find("li").each(function(t,e){if(i.indexOf(e.textContent)<0){i.push(e.textContent)}})}else{e&&i.push(e)}});i.sort(r.sortAlphaNumeric);return i};h.prototype.getLifeCycleMethods=function(e,i){var n=this;return{initComplete:function(){n.API=this.api();var s=t("#"+e+" > thead"),o=t("<tr/>"),r,l,u=0;this.api().columns().every(function(){var e=u,s=i.columns[u],f=[],c,g=s.filter==="select";r=t("<th/>");r.addClass(h.FILTER_CLASS_WRAPPER);n.oColumns[u]={};n.oColumns[u].aControls=[];n.oColumns[u].filterHeader=r;if(n.get("highlight")){l=new a([].slice.call(this.nodes()),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});n.oColumns[u].highlighter=l}if(g){f=n.getSelectOptions(u)}c=h.getFilterByType(s.filter,f);if(c.control){n.oColumns[u].aControls.push(c.control);c.control.attachEvent(c.event,function(t){n.onFilterChange(e,{value:t.getParameter("value"),control:c.control})});c.control.placeAt(r[0])}o.append(r);u++});s.append(o)}}};h.getFilterByType=function(t,i){var n,a="liveChange";switch(t){case"number-range":n=new o({from:new e({type:l.Number,placeholder:"From"}),to:new e({type:l.Number,placeholder:"To"})}).addStyleClass(h.FILTER_TYPES.NUMBER_RANGE);break;case"select":a="change";n=new s({options:i}).addStyleClass(h.FILTER_TYPES.SELECT);break;case"none":n="";break;default:var r=h.FILTER_TYPES.NORMAL,u=l.Text;if(t==="regex"){r=h.FILTER_TYPES.REGEX}else if(t==="cell-range"){r=h.FILTER_TYPES.CELL_RANGE;u=l.Number}else if(t==="number"){r=h.FILTER_TYPES.NUMBER;u=l.Number}n=new e({type:u,placeholder:"Filter"}).addStyleClass(r)}return{control:n,event:a}};return h});
//# sourceMappingURL=DataTable.js.map