/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/i18n/Localization","./DocuInfo","sap/base/Log"],function(t,e,o,a){"use strict";var i;const n={openui5:"oui5",sapui5:"ui5"};const s=["sap.ui.documentation.sdk.view.NotFound","sap.ui.documentation.sdk.view.SampleNotFound"];var r=function(t,e,o,a){o=o||window.location.href;a=a||document.referrer;const n=new URL(o),s=e.getRouteTopLevelTitle(t);this.url=o;this.name=n.pathname+n.hash;this.section=s||"/";this.title=undefined;this.language=i.language;this.country=i.region;this.referrer=document.referrer};r.prototype.toObject=function(){var t={};for(var e in this){if(this.hasOwnProperty(e)&&this[e]!==undefined){t[e]=this[e]}}return t};const u={DOCUMENTATION_TOPIC:"topicId",API_REFERENCE:"apiSpecialRoute",GLOBAL_SEARCH:"search"};const h={code:"Source code for sample",sample:"Sample",experimental:"Experimental APIs",deprecated:"Deprecated APIs",since:"Index By Version",news:"News",releaseNotes:"Change Log",ReleaseNotesLegacyRoute:"Change Log"};var g=t.extend("sap.ui.documentation.sdk.controller.util.UsageTracker",{constructor:function(t){this._oComponent=t;this._oRouter=t.getRouter();this._oConfig=t.getConfig();this._oLastRouteParameters=null;this._isStarted=false},start:function(t,o){if(this._isStarted){return}this._initRemoteServiceConnector(t);this._attachListenersForUserNavigations();this._updateLanguageTag();e.attachChange(this._updateLanguageTag);this._logPrecedingRouteVisits(o);this._isStarted=true},stop:function(){if(!this._isStarted){return}this._detachListenersForUserNavigations();e.detachChange(this._updateLanguageTag);this._isStarted=false;this._oLastRouteParameters=null},_initRemoteServiceConnector:function(t){window.adobeDataLayer=window.adobeDataLayer||[];var e=this._getSiteName(t);this._logSessionStarted(e)},_logPrecedingRouteVisits:function(t){if(t){t.forEach(function(t){switch(t.eventId){case"routeMatched":{this._logRouteMatched(t);break}case"bypassed":{this._logRouteNotFound(t);break}case"_navToWithoutHash":{this._logNavToWithoutHash(t);break}}},this)}},_onRouteMatched:function(t){this._logRouteMatched(t.getParameters())},_logRouteMatched:function(t){if(this._areEqualRoutes(t,this._oLastRouteParameters)){return}if(this._isLegacyRoute(t)){return}this._oLastRouteParameters=t;this._getPageInfoFromRoute(t,function(t){this._logPageVisit(t);this._publishLoggedInfo(true)}.bind(this))},_onRouteNotFound:function(t){this._logRouteNotFound(t.getParameters())},_logRouteNotFound:function(t){this._logPageNotFound(t.hash);this._publishLoggedInfo(true)},_onNavToWithoutHash:function(t){this._logNavToWithoutHash(t.getParameters())},_logNavToWithoutHash:function(t){var e=t.viewName;if(s.includes(e)){this._logPageDataNotFound();this._publishLoggedInfo(true)}},_areEqualRoutes:function(t,e){return t?.name===e?.name&&JSON.stringify(t?.arguments)===JSON.stringify(e?.arguments)},_isLegacyRoute:function(t){return t.name.toLowerCase().includes("legacy")},_getPageInfoFromRoute:function(t,e){var o=t.config,a=new r(o,this._oRouter);this._getPageTitleFromRoute(t,function(t){a.title=t;e(a)})},_getPageTitleFromRoute:function(t,e){var a=t.name,i=t.arguments,n;if(a===u.DOCUMENTATION_TOPIC){var s=i.id;o.getDocumentTitle(s,this._oConfig).then(e).catch(e)}else if(a===u.API_REFERENCE){n=this._oRouter._decodeSpecialRouteArguments(i).id;e(n)}else if(a===u.GLOBAL_SEARCH){n=this._composeSearchPageTitleFromRoute(t);e(n)}else{n=this._composeDefaultPageTitleFromRoute(t);e(n)}},_composeSearchPageTitleFromRoute:function(t){var e='Global Search Resuls for "'+this._getAllStringValues(t.arguments)+'"',o=t.arguments["?options"]?.category,a={apiref:"API Reference",entity:"Samples",topics:"Documentation",external:"External Resources"}[o];return a?e+" in "+a:e},_composeDefaultPageTitleFromRoute:function(t){var e=[],o=this._getRouteTitle(t),a=this._getAllStringValues(t.arguments).join(" ");if(o){e.push(o)}if(a){e.push(a)}return e.join(" ")||t.name},_getRouteTitle:function(t){return h[t.name]||this._oRouter.getRouteTopLevelTitle(t.config)},_getAllStringValues:function(t){return Object.values(t).filter(function(t){return typeof t==="string"})},_logSessionStarted:function(t){this._addToLogs({event:"globalDL",site:{name:t},user:{loginStatus:"no"}})},_addToLogs:function(t){window.adobeDataLayer.push(t)},_logPageVisit:function(t){this._addToLogs({event:"pageView",page:t.toObject()})},_logPageNotFound:function(t){this._addToLogs({event:"errorPage",page:{name:"notFound",section:"errorPage"},error:{type:404,pageUrl:window.location.href,pageName:t,description:"page not found"}})},_logPageDataNotFound:function(){var t;if(this._oLastRouteParameters){var e=this._oRouter.getRouteConfig(this._oLastRouteParameters.name);t=new r(e,this._oRouter)}else{var o=new URL(window.location.href);t={url:window.location.href,name:o.pathname+o.hash,section:"/"}}this._addToLogs({event:"errorPage",page:{name:"notFound",section:"errorPage"},error:{type:404,pageUrl:t.url,pageName:t.name,pageSection:t.section,description:"page data not found"}});this._oLastRouteParameters=null},_publishLoggedInfo:function(t){this._addToLogs({event:t?"stBeaconReady":"stlBeaconReady"})},_updateLanguageTag:function(){i=e.getLanguageTag()},_getSiteName:function(t){if(t.toLowerCase().startsWith("openui5")){return n.openui5}else if(t.toLowerCase().startsWith("sapui5")){return n.sapui5}return t},_attachListenersForUserNavigations:function(){this._oRouter.attachRouteMatched(this._onRouteMatched,this);this._oRouter.attachBypassed(this._onRouteNotFound,this);this._oRouter.attachEvent("_navToWithoutHash",this._onNavToWithoutHash,this)},_detachListenersForUserNavigations(){this._oRouter.detachRouteMatched(this._onRouteMatched,this);this._oRouter.detachBypassed(this._onRouteNotFound,this);this._oRouter.detachEvent("_navToWithoutHash",this._onNavToWithoutHash)},exit:function(){this.stop();this._oRouter=null}});return g});
//# sourceMappingURL=UsageTracker.js.map