/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../util/FileUtils","sap/base/util/extend","sap/m/IconTabHeader","sap/m/IconTabFilter","sap/m/Image","sap/m/MessageStrip","sap/ui/codeeditor/CodeEditor","sap/ui/core/Control"],function(e,t,i,r,s,n,o,a){"use strict";var l=a.extend("sap.ui.documentation.sdk.controls.FileEditor",{metadata:{library:"sap.ui.documentation",properties:{files:{type:"object[]",defaultValue:[]},editable:{type:"boolean",defaultValue:true}},aggregations:{_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_editor:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_readOnlyWarningStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_errorsStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_schemaErrorsStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_image:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{beforeFileChange:{parameters:{sFile:{type:"string"}}},fileChange:{},fileSwitch:{parameters:{editable:{type:"boolean"}}}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiFileEditor").style("height","100%").openEnd();e.openStart("div").class("sapUiFileEditorHeader").openEnd();e.renderControl(t._getErrorsStrip());e.renderControl(t._getSchemaErrorsStrip());e.renderControl(t._getReadOnlyWarningStrip());if(t.getFiles().length>1){e.renderControl(t._getHeader())}e.close("div");e.openStart("div").class("sapUiFileEditorContent").openEnd();e.renderControl(t._getImage());e.renderControl(t._getEditor());e.close("div");e.close("div")}}});l.prototype.init=function(){this._bFetch=false;this._aFiles=[]};l.prototype.onBeforeRendering=function(){if(!this._bFetch){return}this._bFetch=false;this._fetchContents()};l.prototype.setFiles=function(e){this._getHeader().destroyItems();this._bFetch=true;this._bFirstRefresh=2;this._createInternalFiles(e);return this.setProperty("files",e)};l.prototype._getHeader=function(){var e=this.getAggregation("_header");if(!e){e=new i(this.getId()+"-header",{select:this._onFileSwitch.bind(this)});this.setAggregation("_header",e)}return e};l.prototype._getEditor=function(){var e=this.getAggregation("_editor");if(!e){e=new o(this.getId()+"-editor",{liveChange:this._onFileEdit.bind(this),syntaxHints:false});e._oEditor.session.on("changeAnnotation",this._onSyntaxError.bind(this));e._oEditor.completers=[];this.setAggregation("_editor",e)}return e};l.prototype._getReadOnlyWarningStrip=function(){var e=this.getAggregation("_readOnlyWarningStrip");if(!e){e=new n({showIcon:true,type:"Information",text:"This file is read-only.",visible:false});this.setAggregation("_readOnlyWarningStrip",e)}return e};l.prototype._getErrorsStrip=function(){var e=this.getAggregation("_errorsStrip");if(!e){e=new n({showIcon:true,type:"Error",visible:false});this.setAggregation("_errorsStrip",e)}return e};l.prototype._getSchemaErrorsStrip=function(){var e=this.getAggregation("_schemaErrorsStrip");if(!e){e=new n({showIcon:true,type:"Error",visible:false});this.setAggregation("_schemaErrorsStrip",e)}return e};l.prototype._getImage=function(){var e=this.getAggregation("_image");if(!e){e=new s(this.getId()+"-image",{width:"100%"});this.setAggregation("_image",e)}return e};l.prototype._update=function(){var t=this._getHeader().getSelectedKey(),i=t.split(".").pop(),r=this._aFiles.findIndex(function(e){return e.key===t}),s=this._aFiles[r],n=s.editable;switch(i){case"js":i="javascript";break;case"cds":i="red";break;default:break}this._getReadOnlyWarningStrip().setVisible(!n);this._getErrorsStrip().setVisible(false);this._getSchemaErrorsStrip().setVisible(false);if(e.isBlob(t)){this._getImage().setSrc(s.content).setVisible(true);this._getEditor().setVisible(false)}else{this._bPreventLiveChange=true;this._getEditor().setEditable(n).setType(i).setValue(s.content).setVisible(true);this._bPreventLiveChange=false;this._getImage().setVisible(false)}this.fireFileSwitch({editable:n})};l.prototype._createIconTabFilters=function(){this._getHeader().destroyItems();this._aFiles.forEach(function(e){this._getHeader().addItem(new r({key:e.key,text:e.name}))}.bind(this))};l.mimetypes={js:"text/javascript",json:"application/json",html:"text/html",properties:"text/plain"};l.prototype._fetchContents=function(){var t=this._aFiles.map(function(t){var i=t.url,r=i.substring(t.url.lastIndexOf(".")+1);t._type=l.mimetypes[r]||"text/plain";t.promise=e.fetch(i);return t.promise});Promise.all(t).then(function(e){e.map(function(e,t){this._aFiles[t]._url=URL.createObjectURL(new Blob([e],{type:this._aFiles[t]._type}));this._aFiles[t].content=e}.bind(this));this._getHeader().setSelectedKey(this._aFiles[0].key);this._createIconTabFilters();this._update();window.postMessage("sampleLoaded")}.bind(this)).catch(function(e){this._getErrorsStrip().setVisible(true).setText(e)}.bind(this))};l.prototype._onFileSwitch=function(e){this._update()};l.prototype._onFileEdit=function(e){if(this._bFirstRefresh>0&&e.mParameters.editorEvent.action==="insert"){this._bFirstRefresh--;return}if(this._bPreventLiveChange){return}if(e.getParameter("value")===""){return}if(this._bClearButtonPressed&&e.getParameter("value")===""){this._bClearButtonPressed=false;return}var t=this.getAggregation("_header").getSelectedKey();var i=this._aFiles;var r=i.find(function(e){return e.key===t});if(!r||r.content===e.getParameter("value")){return}this.fireBeforeFileChange({sFile:t});r.content=e.getParameter("value");var s=this;fetch(r.url,{method:"POST",body:r.content}).then(function(e){return e.text()}).then(function(e){s.fireFileChange()}).catch(function(e){})};l.prototype._setClearButtonPressed=function(e){this._bClearButtonPressed=true};l.prototype._findIndex=function(e){return this._aFiles.findIndex(function(t){return t.key===e})};l.prototype._onSyntaxError=function(){var e=this._getEditor()._oEditor.session.$annotations,t="";if(e&&e.length){e.forEach(function(e){t+="Line "+String(e.row)+": "+e.text+"\n"});this._getErrorsStrip().setVisible(true).setText(t)}else{this._getErrorsStrip().setVisible(false)}};l.prototype._createInternalFiles=function(e){this._aFiles=e.map(function(e){return t({},e,{content:"",promise:null})})};l.prototype.hideSchemaErrors=function(){this._getSchemaErrorsStrip().setVisible(false)};l.prototype.getFilesWithContent=function(){var e=this._aFiles.map(function(e){return e.promise});return Promise.all(e).then(function(){return this._aFiles}.bind(this))};l.prototype.showError=function(e){this._getErrorsStrip().setVisible(true).setText(e)};return l});
//# sourceMappingURL=FileEditor.js.map