/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/model/resource/ResourceModel"],function(e,o,i,t,s){"use strict";return o.extend("sap.ui.documentation.sdk.cookieSettingsDialog.controller.CookieSettingsDialog",{constructor:function(){this._oCookiesUtil=null;this._oRootView=null;this._oInitOptions=null;this._oModel=new i},openCookieSettingsDialog:function(e,o,i){this._oInitOptions=e;this._oModel.setData(e,true);if(this._oCookieSettingsDialog){this._oCookieSettingsDialog.open()}else{this._initData(o,i);t.load({name:"sap.ui.documentation.sdk.cookieSettingsDialog.view.CookieSettingsDialog",controller:this}).then(this._initDialog.bind(this)).then(function(e){this._oCookieSettingsDialog=e;this._oCookieSettingsDialog.open()}.bind(this))}},_initDialog:function(o){var i=new s({bundleName:"sap.ui.documentation.sdk.cookieSettingsDialog.i18n.i18n"});o.setModel(this._oModel,"cookieData");o.setModel(i,"i18n");this._oRootView.addDependent(o);o.attachBeforeOpen(function(){this._oCookieSettingsDialog.toggleStyleClass("cookiesDetailedView",this._oModel.getProperty("/showCookieDetails"))},this);o.attachAfterOpen(function(){e.getElementById("btnSetPreferences").focus()});if(!this._bAlreadyRequestedCookiesApproval){o.attachEventOnce("afterClose",function(){this._bAlreadyRequestedCookiesApproval=true;this._oCookiesUtil.setCookie(this._oCookiesUtil.COOKIE_NAMES.APPROVAL_REQUESTED,"1")},this)}return o},formatCookieValue:function(e){return Boolean(Number(e))},onAcceptAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES,true);this._oCookieSettingsDialog.close()},onRejectAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES,false);this._oCookieSettingsDialog.close()},onSaveCookies:function(){var o=e.getElementById("requiredCookiesSwitch").getState();this._saveCookiePreference(this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES,o);this._oCookieSettingsDialog.close()},showCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",true);this._oCookieSettingsDialog.addStyleClass("cookiesDetailedView");this._focusButton(e.getElementById("btnSavePreferences"))},onCancelPress:function(){if(this._oInitOptions.showCookieDetails===true){this.onCancelEditCookies()}else{this.hideCookieDetails()}},hideCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",false);this._oCookieSettingsDialog.removeStyleClass("cookiesDetailedView");this._focusButton(e.getElementById("btnSetPreferences"))},onCancelEditCookies:function(){this._oCookieSettingsDialog.close();e.getElementById("requiredCookiesSwitch").setState(this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES)==="1")},_saveCookiePreference:function(e,o){var i=o?"1":"0";this._oCookiesUtil.setCookie(e,i);this._oModel.setProperty("/"+e,i)},_initData:function(e,o){this._oCookiesUtil=o;this._oRootView=e;this._oCookieNames=this._oCookiesUtil.COOKIE_NAMES;this._bAlreadyRequestedCookiesApproval=this._oCookiesUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)==="1";this._setInitialCookieValues()},_setInitialCookieValues:function(){var e={};if(!this._bAlreadyRequestedCookiesApproval){e[this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES]="1"}else{e[this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES]=this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_FUNCTIONAL_COOKIES)}this._oModel.setData(e,true)},_focusButton:function(e){if(e.getDomRef()){e.focus();return}e.addEventDelegate({onAfterRendering:function(){e.focus();e.removeEventDelegate(this)}})}})});
//# sourceMappingURL=CookieSettingsDialog.controller.js.map