/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/base/ManagedObject","sap/base/util/merge","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/base/security/sanitizeHTML","sap/ui/documentation/sdk/controller/util/URLUtil","sap/base/strings/formatMessage"],function(t,e,r,n,i,a,o){"use strict";var s=/^p\d+$/;var u=t.extend("sap.ui.documentation.sdk.model.formatter"),f={crossLink:function(t){if(t[0]==="#"){t=document.location.href.substring(0,document.location.href.search("demoapps.html"))+t}return t},libraryLink:function(t){if(t&&t.search("sap\\.")===0){return this.formatter.crossLink("api/"+t)}else{return""}},libraryLinkEnabled:function(t){return!!this.formatter.libraryLink.bind(this)(t)},apiRefEntityName:function(t){if(t){return t.replace("module:","")}},apiRefAggregationAltTypes:function(t){return t&&t.join(", ")},formatVisibility:function(t,e){var r=t;if(e&&Array.isArray(e)){r+=" to "+e.join(", ")}return r},formatVersionTitle:async function(t,e){if(e){return this.formatMessage(t,e)}return(await this.getModel("i18n").getResourceBundle()).getText("API_DETAIL_NA_VERSION")},formatSenderLink:function(t,e,r){if(r==="methods"){return t+"#"+e}if(r==="events"){return t+"#events:"+e}if(r==="class"){return t}return""},formatIndexByVersionEntry:function(t,e,r,n,i){var a=this.formatSenderLink(t,e,r),o=this.formatApiHref(t,e,r,n),s=this.formatLinks(i);return'<a href="'+o+'" class="sapMLnk sapMLnkMaxWidth">'+a+"</a>"+s},formatApiHref:function(t,e,r,n){var i;if(n){e=t+"."+e}i="api/"+t;if(r!=="class"){i+="/"+r+"/"+e}return i},formatLinks:function(t){return n.formatTextBlock(t,{linkFormatter:function(t,e){var r;if(t.match("://")){return'<a target="_blank" href="'+t+'" rel="noopener">'+(e||t)+"</a>"}t=t.trim().replace(/\.prototype\./g,"#");r=t.indexOf("#");e=e||t;if(r<0){var n=t.lastIndexOf("."),i=t.substring(0,n),a=t.substring(n+1),o=a;if(o){if(o.static===true){t=i+"/methods/"+i+"."+a}else{t=i+"/methods/"+a}}}if(r===0){return"<code>"+t.slice(1)+"</code>"}if(r>0){t=t.slice(0,r)+"/methods/"+t.slice(r+1)}return'<a href="api/'+t+'" target="_self">'+e+"</a>"}})},filePathToRouteParams:function(t){var e,r={};if(!t){return{}}e=t.split("/");e.forEach(function(t,e){r["p"+ ++e]=t});return r},routeParamsToFilePath:function(t){var e=Object.keys(t),r,n,i=[];for(var a=0;a<e.length;a++){r=s.test(e[a]);n=r&&t[e[a]];if(n){i.push(n)}if(r&&!n){break}}if(i.length){return i.join("/")}},formatHttpHrefForNewWindow:function(t){if(t&&window["sap-ui-documentation-static"]&&!/^https?:\/\//.test(t)){t="#/"+t}return t},formatMessageStripLinks:function(t){var e=window["sap-ui-documentation-static"];if(t){t=i(t,{uriRewriter:function(t){if(e&&a.hasSEOOptimizedFormat(t)){t=a.convertToNonSEOFormat(t).replace(/^\//,"")}return t}})}return t},formatResourceCardVisibility:function(t){if(!t){return false}if(t.hideOnPhone&&this.getOwnerComponent().getModel("device").getProperty("/system/phone")){return false}if(t.isDistributionScope&&this.getOwnerComponent().getModel("versionData").getProperty("/isOpenUI5")){return false}return true},formatVersionStatus:async function(t,e,r){var n=await this.getModel("i18n").getResourceBundle();if(t){return""}var i=n.getText("APP_VERSION_VERSION")+" "+r;if(e){i+=" "+n.getText("APP_VERSION_IN_PROGRESS")}return i},getDemoAppsCategoryTitle:async function(t){var e=await this.getModel("i18n").getResourceBundle();return e.getText("DEMO_APPS_CATEGORY_"+t.toUpperCase())},getDemoAppsCategoryClass:function(t){return"sapUiDemoKitDemoAppsCategory"+t},escapeSettingsValue:e.escapeSettingsValue,getUrlForType:function(t){if(!t){return t}return"api/"+t.replace("[]","")},stringify:function(t){return JSON.stringify(t,null,2)},stringifyJSDocType:function(t,e,r,n){t=u.formatJSDocType(t,e,r,n);return JSON.stringify(t,null,2)},formatJSDocType:function(t,e,r,n){t??=u.convertLegacyJSDocTypes(e,r,n);return t},convertLegacyJSDocTypes:function(t,e,r){if(!t&&!e){return}t||(t=[{value:e,linkEnabled:r}]);if(Array.isArray(t)){const e=[];const r=t.map(({value:t,name:r,linkEnabled:n})=>{const i=t||r;if(n){e.push(i);return`\${${e.length-1}}`}return i}).join(" | ");return{template:r,UI5Types:e}}}};return r(u,f)});
//# sourceMappingURL=formatter.js.map