/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/routing/Router","sap/ui/core/routing/History","sap/ui/thirdparty/hasher","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/URLUtil","sap/ui/thirdparty/URI"],function(t,e,i,n,o,a,r){"use strict";i.raw=true;var s=t.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{constructor:function(){t.prototype.constructor.apply(this,arguments);this._URLSeparator=window["sap-ui-documentation-static"]?"%23":"#";this._fnPopstateHandlerRef=this.popstateHandler.bind(this);this.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"controlProperties"},this._forwardToAPIRef,this);this.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this.getRoute("topicIdLegacyRoute").attachPatternMatched(this._onOldTopicRouteMatched,this);this.getRoute("apiIdLegacyRoute").attachPatternMatched(this._onOldApiRouteMatched,this);this.getRoute("sampleLegacyRoute").attachPatternMatched({routeName:"sample"},this._onOldSampleRouteMatched,this);this.getRoute("codeLegacyRoute").attachPatternMatched({routeName:"code"},this._onOldSampleRouteMatched,this);this.getRoute("codeFileLegacyRoute").attachPatternMatched({routeName:"codeFile"},this._onOldSampleRouteMatched,this);this.getRoute("ReleaseNotesLegacyRoute").attachPatternMatched(function(){this.navTo("releaseNotes")},this)},_removeNonStandardEncoding:function(t){return typeof t==="string"?t.replace(/[\[\]']+/g,""):t},_onOldEntityRouteMatched:function(t){this.navTo("entity",{id:t.getParameter("arguments").id},true)},_forwardToAPIRef:function(t,e){e||(e={});e["id"]=t.getParameter("arguments").id;this.navTo("apiId",e)},_onOldSampleRouteMatched:function(t,e){var i=t.getParameter("arguments"),n=i.id;o.loadData().then(function(t){var o=t.samples[n],a;if(!o){this.onRouteNotFound()}a={entityId:o.contexts?Object.keys(o.contexts)[0]:o.entityId,sampleId:n};if(e.routeName==="codeFile"){a["fileName"]=decodeURIComponent(i.fileName)}this.navTo(e.routeName,a,true)}.bind(this))},_onOldTopicRouteMatched:function(t){this.navTo("topicId",{id:t.getParameter("arguments").id.replace(/.html$/,"")},true)},_onOldApiRouteMatched:function(t){var e,i,n,o=t.getParameter("arguments").id;if(o){n=o.split("#");if(n.length===2){o=n[0];e=n[1];n=e.split(":");if(n.length===2){e=n[0];i=n[1]}}o=o.replace(/.html$/,"");if(e==="event"){e="events"}}this.navTo("apiId",{id:o,entityType:e,entityId:i},true)},myNavBack:function(t,i){var n=e.getInstance();var o=n.getPreviousHash();if(o!==undefined){window.history.go(-1)}else{var a=true;this.navTo(t,i,a)}},myNavToWithoutHash:function(t,e,i,n){var o=this._getOwnerComponent(),a=o.byId(o.getManifestEntry("/sap.ui5/rootView").id);a.loaded().then(function(o){var a=o.byId("splitApp"),r=this.getView(t,e);a.addPage(r,i);a.toDetail(r.getId(),"show",n);this.fireEvent("_navToWithoutHash",{viewName:t,viewType:e,master:i,data:n})}.bind(this))},_getOwnerComponent:function(){return this._oOwner},_destroySampleComponent:function(){var t=this._getOwnerComponent()._oCurrentOpenedSample;if(t){t.getDomRef().contentWindow.postMessage({type:"EXIT",data:{msg:"Destroy the container"}},this._getOwnerComponent()._sSampleIframeOrigin)}}});s.prototype.linkClickHandler=function(t){if(t.defaultPrevented){t.preventDefault();return}var e=t.target,i,n,o=t.ctrlKey||t.metaKey,a;if(!e){return}if(o){return}i=d(e,true);if(!i){return}a=p(i);if(a==="javascript:void(0)"){return}n=/^blob:/.test(a)||/^https?:\/\//.test(a)||/^test-resources\//.test(a)||/^resources\//.test(a)||/^tel:/.test(a)||/^mailto:/.test(a);if(a&&!n){if(t.preventDefault){t.preventDefault()}this.parsePath(a)}};s.prototype.parsePath=function(t){if(t==="#"){t=""}if(window["sap-ui-documentation-static"]&&this.shouldConvertHash(t)){t=t.replace("#","%23")}t=this._removeNonStandardEncoding(t);this.parse(t);if(t&&window["sap-ui-documentation-static"]&&!t.startsWith("#/")){t="#/"+t}window.history.pushState({},undefined,t)};s.prototype.mouseDownClickHandler=function(t){var e=t.buttons,i=t.target,n=d(i),o=t.ctrlKey||t.metaKey,s,h,c;if(n){s=this._removeNonStandardEncoding(p(n));h=o||!u(n)}if(!s||(c=r(s)).is("absolute")||c.suffix()==="html"){return}if(e===2||e===4||h&&e===1){if(a.hasSEOOptimizedFormat(s)){s=this.convertToStaticFormat(s)}n.setAttribute("href",s)}};s.prototype.popstateHandler=function(){var t=!!window["sap-ui-documentation-static"],e=t?location.hash.replace(/^[#/]/,""):this._processPath(location.pathname);this.parse(e)};s.prototype.attachGlobalLinkHandler=function(){if(!this._bGlobalHandlerAttached){document.body.addEventListener("click",this.linkClickHandler.bind(this));window["sap-ui-documentation-static"]&&document.body.addEventListener("mousedown",this.mouseDownClickHandler.bind(this),true);this._bGlobalHandlerAttached=true}};s.prototype.attachPopstateHandler=function(){if(!this._bPopstateHandlerAttached){window.addEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=true}};s.prototype.detachPopstateHandler=function(){if(this._bPopstateHandlerAttached){window.removeEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=false}};s.prototype._decodeSpecialRouteArguments=function(t){var e=[],i,n=[],o;if(t.p1===undefined){if(t.id.indexOf(this._URLSeparator)>-1){o=t.id.split(this._URLSeparator);t.id=o[0];t.p1=o[1]}return{id:decodeURIComponent(t.id),entityId:undefined,entityType:t.p1}}if(/^module:\S+$/.test(t.id)){Object.keys(t).forEach(function(o){var a=t[o],r;if(!a){return}if(!i&&a.indexOf(this._URLSeparator)!==-1){r=a.split(this._URLSeparator);e.push(r[0]);i=r[1];return}if(!i){e.push(a)}else{n.push(a)}}.bind(this));if(!i&&e.includes("methods")){var a=e.indexOf("methods");i="methods";n=e.slice(a+1);e=e.slice(0,a)}return{id:e.join("/"),entityId:n.length?n.join("/"):undefined,entityType:i}}if(t.id.indexOf(this._URLSeparator)!==-1){o=t.id.split(this._URLSeparator);t.p2=t.p1;t.id=o[0];t.p1=o[1]}return{id:decodeURIComponent(t.id),entityType:t.p1,entityId:t.p2?decodeURIComponent(t.p2):undefined}};s.prototype._decodeDocumentationRouteArguments=function(t){var e=decodeURIComponent(t.id),i=e.split("#"),o=i[0],a=t.subId||i[1],r=t["?options"];return{topicId:o.replace(".html",""),subTopicId:a,options:r,topicURL:n.getResourceOriginPath(this.getAppConfig().docuPath+o+(o.match(/\.html/)?"":".html"))}};s.prototype.getAppConfig=function(){if(!this._oAppConfig){this._oAppConfig=this._getOwnerComponent().getConfig()}return this._oAppConfig};s.prototype.getConfig=function(){return this._getOwnerComponent().getManifestEntry("/sap.ui5/routing")};s.prototype.getRouteConfig=function(t){return this.getConfig().routes.find(e=>e.name===t)};s.prototype.getTargetConfig=function(t){return this.getConfig().targets[t]};s.prototype.getRouteTopLevelTitle=function(t){var e=t.titleTarget||this._getLastTargetForRoute(t);return this.getTargetConfig(e)?.title};s.prototype._getLastTargetForRoute=function(t){var e=t.target;if(e&&e.length){return e[e.length-1]}};s.prototype.navTo=function(t,e,i){var n;var o=i?"replaceState":"pushState";this._destroySampleComponent();if(t==="apiId"){if(e.id){e.id=encodeURIComponent(e.id)}if(e.entityId){e.entityId=encodeURIComponent(e.entityId)}}n=this.getURL(t,e);if(t==="apiId"){n=n.replace(/#$/,"");n=decodeURIComponent(n)}this.parse(n);if(window["sap-ui-documentation-static"]){window.history[o]({},undefined,"#/"+n.replace("#",this._URLSeparator))}else{window.history[o]({},undefined,n)}return this};if(!window["sap-ui-documentation-static"]){s.prototype._processPath=function(t){var e=document.querySelector("base[href]"),i=e?e.getAttribute("href"):"",n=i.slice(0,i.length-1),o=location.hash,a;if(t.startsWith(i)){t=t.replace(i,"")}else if(t.startsWith(n)){t=t.replace(n,"")}if(o){if(!t&&o.indexOf("module%3A")!==-1){a=o.split("/");o="#"+a[1]+"/"+decodeURIComponent(a[2])+(a[3]?"#"+a[3]:"")+(!a[3]?"/":"")+(a[4]?"/"+decodeURIComponent(a[4]):"")}t+=(t?"#":"")+o.slice(1)}return t};s.prototype.initialize=function(){var t=this._processPath(location.pathname);this.stop();this.parse(t);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};s.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);if(e){window.history.pushState({},undefined,i)}else{window.history.replaceState({},undefined,i)}return this}}else{s.prototype.initialize=function(){this.getRoute("sample").attachPatternMatched(function(){if(window.location.search.includes("dk-sample-standalone")){document.body.style.visibility="hidden"}});t.prototype.initialize.apply(this,arguments);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};s.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);i=i.replace("#",this._URLSeparator);this.stop();hasher.stop();this.detachPopstateHandler();if(e){hasher.setHash(i)}else{hasher.replaceHash(i)}hasher.init();this.initialize(true);this.attachPopstateHandler()}}s.prototype.shouldConvertHash=function(t){return this.getRoute("apiId").match(t)||this.getRoute("apiSpecialRoute").match(t)};s.prototype.convertToStaticFormat=function(t){var e=window.location,i=t;if(this.shouldConvertHash(t)){i=t.replace("#","%23")}i=e.origin+e.pathname+"#/"+i;return i};function d(t,e,i){var n=h(t,e),o=0;i||(i=3);while(!n&&o++<i){t=t&&t.parentElement;n=h(t,e)}return t}function h(t,e){if(t&&t.nodeName==="A"||t.nodeName==="AREA"){return e?u(t):true}return false}function p(t){return t.getAttribute("href")}function u(t){return t.getAttribute("target")!=="_blank"}return s});
//# sourceMappingURL=DocumentationRouter.js.map