/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_curry","sap/base/util/restricted/_difference","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/AggregationOverlay","sap/ui/dt/DesignTimeStatus","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementOverlay","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/SelectionManager","sap/ui/dt/SelectionMode","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/ui/dt/util/ZIndexManager","sap/ui/dt/Util","sap/ui/thirdparty/jquery"],function(e,t,a,r,n,i,s,o,l,g,d,c,h,y,u,p,m,v,f,E,O,_,b,S,jQuery){"use strict";var T=o.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(...e){this._sStatus=d.SYNCED;this._mPendingOverlays={};this._oTaskManager=new O({complete:function(e){if(e.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==d.SYNCED){this._sStatus=d.SYNCED;setTimeout(function(){if(this._sStatus===d.SYNCED){this.fireSynced()}}.bind(this),0)}}}.bind(this),add:function(e){if(e.getSource().count()===1){this._sStatus=d.SYNCING;this.fireSyncing()}}.bind(this)});this._oTaskRunner=new _({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new f;this._aOverlaysCreatedInLastBatch=[];o.apply(this,e);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(e){this._createOverlaysForRootElement(e.getParameter("element"))},this);this.getPlugins().forEach(function(e){e.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("addPlugin",function(e){var t=e.getParameter("plugin");t.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("enabledChanged",function(e){var t=e.getParameter("value");var a=p.getOverlayContainer();a.style.display=t?"block":"none";this.getRootElements().forEach(function(e){var a=m.getOverlay(e);a.setVisible(t);if(t){this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,true),overlayId:a.getId()})}}.bind(this))},this)}});T.prototype._onProcessingStatusChange=function(e){if(e.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}};T.prototype._onApplyStylesRequired=function(e){var t=e.getParameters();var a=e.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,t.bForceScrollbarSync,t.bSkipForceCalculation),overlayId:a.getId()},"overlayId")};T.prototype._removeOverlayFromSyncingBatch=function(e){var t=this._aOverlaysCreatedInLastBatch.indexOf(e);if(t!==-1){this._aOverlaysCreatedInLastBatch.splice(t,1)}};T.prototype._registerElementOverlays=function(){var e=this._aOverlaysCreatedInLastBatch.slice();if(!e.length){return}this._aOverlaysCreatedInLastBatch=[];var t=this._oTaskManager.add({type:"registerElementOverlays"});var a=this.getPlugins();e.forEach(function(e){m.register(e);e.attachBeforeDestroy(function(e){m.deregister(e.getSource())})});e.forEach(function(e){a.forEach(function(t){try{t.callElementOverlayRegistrationMethods(e)}catch(r){var a=S.propagateError(r,"DesignTime#_registerElementOverlays",`registerElementOverlay() method of the plugin ${t.getMetadata().getName()} has failed for overlay with id='${e.getId()}' (element id='${e.getElement().getId()}')`);s.error(S.errorToString(a))}})},this);e.forEach(function(e){try{this.fireElementOverlayCreated({elementOverlay:e})}catch(a){var t=S.propagateError(a,"DesignTime#_registerElementOverlays",`One of the listeners of elementOverlayCreated event failed while processing the overlay with id='${e.getId()}' for element with id='${e.getElement().getId()}'`);s.error(S.errorToString(t))}},this);this._oTaskManager.complete(t)};T.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(e){e.destroy()});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();b.clearState();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending};T.prototype.getSelectionManager=function(){return this._oSelectionManager};T.prototype.getPlugins=function(){return this.getAggregation("plugins")||[]};T.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(e){return e.isBusy()})};T.prototype.waitForBusyPlugins=function(){var e=this.getBusyPlugins();return Promise.all(e.map(function(e){return e.waitForBusyAction()}))};T.prototype.addPlugin=function(e){this.addAggregation("plugins",e);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};T.prototype.insertPlugin=function(e,t){this.insertAggregation("plugins",e,t);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};T.prototype.removePlugin=function(e){this.getPlugins().forEach(function(t){if(t===e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}}.bind(this));this.removeAggregation("plugins",e);return this};T.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}.bind(this));this.removeAllAggregation("plugins");return this};T.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(e){return y.getElementInstance(e)})};T.prototype.getDesignTimeMetadataFor=function(e){var t;if(typeof e==="string"){t=e;s.error("sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance")}else{t=e.getMetadata().getName()}return(this.getDesignTimeMetadata()||{})[t]};T.prototype.addRootElement=function(e){this.addAssociation("rootElements",e);this.fireAddRootElement({element:e})};T.prototype._createOverlaysForRootElement=function(e){var t=this._oTaskManager.add({type:"createOverlay",element:e,root:true});this.createOverlay({element:y.getElementInstance(e),root:true,visible:this.getEnabled()}).then(function(e){jQuery(p.getOverlayContainer()).append(e.render());this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");this._oTaskManager.complete(t);return e}.bind(this),function(a){var r=S.propagateError(a,"DesignTime#_createOverlaysForRootElement",`Initialization failed for root element with id '${e.getId()}'`);s.error(S.errorToString(r));this._oTaskManager.cancel(t);this.fireSyncFailed({error:r})}.bind(this))};T.prototype.removeRootElement=function(e){this.removeAssociation("rootElements",e);this._destroyOverlaysForElement(y.getElementInstance(e));return this};T.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this};T.prototype.getElementOverlays=function(){var e=[];this._iterateRootElements(function(t){e=e.concat(this._getAllElementOverlaysIn(t))},this);return e};function I(e,t){if(e){t.setIsRoot(true)}}T.prototype.createOverlay=function(e){const t={...r(e)?e:{element:e}};const a=this._oTaskManager.add({type:"createOverlay"});if(!t.element||!y.isElementValid(t.element)){this._oTaskManager.cancel(a);return this._rejectCreateOverlay(t.element)}const n=t.element.getId();const i=m.getOverlay(n);if(i){I(t.root,i);this._oTaskManager.complete(a);return Promise.resolve(i)}else if(n in this._mPendingOverlays){this._oTaskManager.complete(a);return this._mPendingOverlays[n]}if(typeof t.root==="undefined"){t.root=true}this._mPendingOverlays[n]=this._createElementOverlay(t).then(function(e){return this._createChildren(e,t).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[n]},this);if(this.bIsDestroyed){e.detachEvent("destroyed",this._onElementOverlayDestroyed,this);e.destroy();this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"))}else if(e.bIsDestroyed){this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"))}this._aOverlaysCreatedInLastBatch.push(e);this._oTaskManager.complete(a);return e}.bind(this))}.bind(this)).catch(function(e){const t=S.propagateError(e,"DesignTime#createOverlay",`Failed attempt to create overlay for element '${n}'`);delete this._mPendingOverlays[n];this._oTaskManager.cancel(a);return Promise.reject(t)}.bind(this));return this._mPendingOverlays[n]};T.prototype._rejectCreateOverlay=function(e){var t;if(!e){t="Cannot create overlay — no element is specified."}else if(e.bIsDestroyed){t="Cannot create overlay — the element is already destroyed."}else if(e instanceof o&&!y.isElementInTemplate(e)){t=`Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='${e.getId()}'. Please report to CA-UI5-FL-RTA component.`}else{t=`Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(e)} was given`}return Promise.reject(S.createError("DesignTime#createOverlay",t))};T.prototype._createAggregationOverlay=function(e,t,a,r){return new g({aggregationName:e,element:t,visible:!r,isPartOfTemplate:r,designTimeMetadata:new l({data:a}),init:function(e){var t=e.getSource();t.attachEvent("destroyed",this._onAggregationOverlayDestroyed,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this),beforeDestroy:function(e){var t=e.getSource();m.deregister(t);t.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this)})};T.prototype._createElementOverlay=function(t){var a=t.element;function r(e){return new h(e)}return new Promise(function(s,o){r({element:a,isRoot:t.root,visible:typeof t.visible!=="boolean"||t.visible,isPartOfTemplate:t.isPartOfTemplate,metadataScope:this.getScope(),designTimeMetadata:this.getDesignTimeMetadataFor(a)instanceof c?this.getDesignTimeMetadataFor(a):e(function(e,t,a,r){r=n({},r,e);this._mMetadataOriginal=r;if(t){r=u.propagateMetadataToElementOverlay(r,t,a)}return r})(this.getDesignTimeMetadataFor(a),t.parentMetadata,a),init:function(e){var t=e.getSource();s(e.getSource());t.attachEvent("destroyed",this._onElementOverlayDestroyed,this);t.attachEvent("elementDestroyed",this._onElementDestroyed,this);t.attachEvent("selectionChange",this._onElementOverlaySelectionChange,this);t.attachEvent("elementModified",this._onElementModified,this);t.attachEvent("editableChange",this._onEditableChanged,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this);if(i.get(["actions","actionsFromResponsibleElement"],t.getDesignTimeMetadata().getData())){var a=this.getSelectionManager().getConnectedElements();var r=t.getElement();var n=t.getDesignTimeMetadata().getResponsibleElement(r);a[r.getId()]=n.getId();a[n.getId()]=r.getId();this.getSelectionManager().setConnectedElements(a)}}.bind(this),initFailed:function(e,t){var a=t.getSource();var r=S.propagateError(t.getParameter("error"),"DesignTime#_createElementOverlay",`Error creating overlay (id='${a.getId()}') for '${e}'`);a.detachEvent("destroyed",this._onElementOverlayDestroyed,this);a.detachEvent("elementDestroyed",this._onElementDestroyed,this);a.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this);a.destroy();o(r)}.bind(this,a.getId())})}.bind(this))};function M(e,t){var a=e.getElement();return t.reduce(function(e,t){var r=y.getAggregationBindingTemplate(a,t);if(r){e[t]=r}return e},{})}T.prototype._destroyChildrenForAggregationBindingTemplate=async function(e,t){await S.waitForSynced(this)();const a=e.getAggregationBindingTemplateOverlays();a.forEach(e=>{if(e.getAggregationName()===t){e.destroy()}});e.getAggregationOverlay(t).destroy()};T.prototype._createChildrenForAggregationBindingTemplate=async function(e,t){await S.waitForSynced(this)();const r=e.getAggregationBindingTemplateOverlays();const n=e.getDesignTimeMetadata().getData();const i=M(e,[t]);const s=[t];const o=[t];if(r.length){await this._destroyChildrenForAggregationBindingTemplate(e,t)}const l=!a(i);await this._createChildrenOverlays(e,n,s,l,i);await this._createChildrenOverlays(e,n,o,false)};T.prototype._createChildren=function(e,r){var n=e.getAggregationNames();var i=r.parentMetadata;var s=M(e,n);var o=Object.keys(s);var l=r.isPartOfTemplate!==undefined;var g=!a(s);var d=g&&!l;var c=d?true:r.isPartOfTemplate;var h=d?false:r.isPartOfTemplate;if(g&&c&&!d){n=t(n,o)}return this._createChildrenOverlays(e,i,o,c,s).then(this._createChildrenOverlays.bind(this,e,i,n,h))};T.prototype._createChildrenOverlays=function(e,t,r,n,i){var o=!a(i);if(o&&!n){return Promise.resolve()}return Promise.all(r.map(function(a){const r=e.getElement();const l=r.getMetadata().getName();const g=u.propagateMetadataToAggregationOverlay(e,a,t);const d=this._createAggregationOverlay(a,r,g,o);m.register(d);let c;if(o){c=[i[a]]}else{c=y[d.isAssociation()?"getAssociationInstances":"getAggregation"](r,a)}return Promise.all(c.map(function(t,i){return this.createOverlay({element:i,root:false,parentMetadata:g,isPartOfTemplate:n}).catch(function(n){const o=this._enrichChildCreationError(n,i,t,a);if(!r.isDestroyed()&&!e.isDestroyed()){s[o.severity](o.message)}return o.errorObject}.bind(this))}.bind(this,l))).then(function(e){e.map(function(e){if(e instanceof h&&!e.bIsDestroyed&&!e.getParent()){d.addChild(e,true)}},this);return d}.bind(this))},this)).then(function(t){t.forEach(function(t){if(e.bIsDestroyed){t.destroy()}else if(o){e.addAggregationBindingTemplateOverlay(t)}else{e.addChild(t,true)}})})};T.prototype._enrichChildCreationError=function(e,t,a,r){var n="error";var i=S.errorToString(e);if(e.message.includes("Cannot create overlay without a valid element")){n="warning";e=S.createError("DesignTime#_createChildren",`Child element in aggregation '${r}' of ${a} must be a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(t)} was given. Consider ignoring aggregation ${r} in the .designtime configuration of the control.`);i=e.toString()}else if(e.message.startsWith("Element is in a bound aggregation")){n="error";i=e.toString()}return{errorObject:e,severity:n,message:i}};T.prototype._destroyOverlaysForElement=function(e){var t=m.getOverlay(e);if(t){t.destroy()}};T.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(e){this._destroyOverlaysForElement(e)},this);p.removeOverlayContainer()};T.prototype._onElementOverlayDestroyed=function(e){if(this._bDestroyPending){return}var t=e.getSource();this._oTaskManager.cancelBy({type:"applyStyles",overlayId:t.getId()},"overlayId");this._removeOverlayFromSyncingBatch(t);var a=t.getAssociation("element");if(a in this._mPendingOverlays){delete this._mPendingOverlays[a];return}if(!m.hasOverlays()){p.destroyMutationObserver();p.removeOverlayContainer()}if(t.isSelected()){this.getSelectionManager().remove(t)}this.fireElementOverlayDestroyed({elementOverlay:t})};T.prototype._onElementDestroyed=function(e){var t=e.getParameter("targetId");this.removeRootElement(t)};T.prototype._onAggregationOverlayDestroyed=function(e){this._oTaskManager.cancelBy({type:"applyStyles",overlayId:e.getSource().getId()},"overlayId");if(!m.hasOverlays()){p.removeOverlayContainer()}};T.prototype._onElementOverlaySelectionChange=function(e){var t=e.getSource();var a=e.getParameter("selected");if(a){if(this.getSelectionManager().getSelectionMode()===E.Multi){this.getSelectionManager().add(t)}else{this.getSelectionManager().set(t)}if(!this.getSelectionManager().get().includes(t)){t.setSelected(false)}}else{this.getSelectionManager().remove(t)}};T.prototype._onElementModified=function(e){var t=n({},e.getParameters());var a=e.getSource();t.type=!t.type?e.getId():t.type;switch(t.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(t.value,t.target,t.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(t.target)}}.bind(this),0);break;case"propertyChanged":t.id=e.getSource().getId();delete t.type;delete t.target;if(this.getStatus()===d.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementPropertyChanged(e[1])}},this)}else{this.fireElementPropertyChanged(t)}break;case"bindAggregation":this._createChildrenForAggregationBindingTemplate(a,t.name);break;case"unbindAggregation":this._destroyChildrenForAggregationBindingTemplate(a,t.name);break;default:break}};T.prototype._onEditableChanged=function(e){var t=n({},e.getParameters());var a=e.getSource();t.id=a.getId();if(this.getStatus()===d.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementOverlayEditableChanged(e[1])}},this)}else{this.fireElementOverlayEditableChanged(t)}};T.prototype._onAddAggregation=function(e,t,a){if(y.isElementValid(e)){var r=m.getOverlay(t);var n=r&&r.getAggregationOverlay(a);if(!n){var i=function(r){var n=r.getParameter("elementOverlay");if(n.getElement().getId()===t.getId()){var s=n.getAggregationOverlay(a);this.detachElementOverlayCreated(i,this);this._addAggregation(e,s)}};this.attachElementOverlayCreated(i,this)}else{this._addAggregation(e,n)}}};T.prototype._addAggregation=function(e,t){var a=m.getOverlay(e);if(!a&&t&&t.getElement()){var r=this._oTaskManager.add({type:"createChildOverlay",element:e});this.createOverlay({element:e,root:false,parentMetadata:t.getDesignTimeMetadata().getData()}).then(function(e){var a=t.insertChild(null,e);if(a===true){this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");var n=t.indexOfAggregation("children",e);this.attachEventOnce("synced",e,function(){if(!e.bIsDestroyed){this.fireElementOverlayAdded({id:e.getId(),targetIndex:n,targetId:t.getId(),targetAggregation:t.getAggregationName()})}},this)}this._oTaskManager.complete(r)}.bind(this)).catch(function(a,n,i){this._oTaskManager.cancel(r);var o=S.propagateError(i,"DesignTime#_onAddAggregation",`Failed to add new element overlay (elementId='${a}') into aggregation overlay (id='${n}')`);if(!e.bIsDestroyed&&!t.bIsDestroyed){s.error(S.errorToString(o))}}.bind(this,e.getId(),t.getId()))}else{if(a&&!this._isElementInRootElements(a)&&a.isRoot()){a.setIsRoot(false)}if(t){t.insertChild(null,a)}else{s.error("No parentAggregationOverlay exists during addAggregation");return}a.setDesignTimeMetadata(u.propagateMetadataToElementOverlay(a._mMetadataOriginal,t.getDesignTimeMetadata().getData(),e));this.fireElementOverlayMoved({id:a.getId(),targetIndex:t.indexOfAggregation("children",a),targetId:t.getId(),targetAggregation:t.getAggregationName()})}};T.prototype._checkIfOverlayShouldBeDestroyed=function(e){var t=m.getOverlay(e);if(!e.bIsDestroyed&&t&&(!this._isElementInRootElements(e)||e.sParentAggregationName==="dependents")){t.destroy()}};T.prototype._isElementInRootElements=function(e){var t=false;this._iterateRootElements(function(a){if(y.hasAncestor(e,a)){t=true;return false}return undefined});return t};T.prototype._iterateRootElements=function(e,t){var a=this.getRootElements();a.forEach(function(a){var r=y.getElementInstance(a);e.call(t||this,r)},this)};T.prototype._getAllElementOverlaysIn=function(e){var t=[];var a=m.getOverlay(e);if(a){v.iterateOverlayElementTree(a,function(e){if(e.getDesignTimeMetadata()){t.push(e)}})}return t};T.prototype.setEnabled=function(e){e=!!e;if(this.getEnabled()!==e){this.setProperty("enabled",e);this.fireEnabledChanged({value:e})}};T.prototype.getStatus=function(){return this._sStatus};return T});
//# sourceMappingURL=DesignTime.js.map