/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil"],function(t,e){"use strict";var i=t.extend("sap.ui.dt.ManagedObjectObserver",{metadata:{abstract:true,library:"sap.ui.dt",properties:{aggregations:{type:"array",defaultValue:null}},associations:{target:{type:"sap.ui.base.ManagedObject"}},events:{modified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},destroyed:{}}}});i.prototype.init=function(){this._fnFireModified=function(t){var e=t.getParameters();if(t.sId==="_change"){t.sId="propertyChanged"}this.fireModified({type:t.sId,name:e.name,value:e.newValue,oldValue:e.oldValue,target:t.getSource()})}.bind(this)};i.prototype.exit=function(){this.unobserve();delete this._fnFireModified};i.prototype.setTarget=function(t){this.unobserve();this.setAssociation("target",t);var e=this.getTargetInstance();if(e){this.observe(e)}return this};i.prototype.observe=function(t){this._bIsObserved=true;t.attachEvent("_change",this._fnFireModified,this);this._fnOriginalDestroy=t.destroy;t.destroy=function(...e){this.unobserve(t);var i=t.destroy(...e);this.fireDestroyed();return i}.bind(this);this._fnOriginalBindProperty=t.bindProperty;t.bindProperty=function(...e){var i=this._fnOriginalBindProperty.apply(t,e);this.fireModified();return i}.bind(this);this._fnOriginalUnBindProperty=t.unbindProperty;t.unbindProperty=function(...e){var i=this._fnOriginalUnBindProperty.apply(t,e);this.fireModified();return i}.bind(this);this._fnOriginalBindAggregation=t.bindAggregation;t.bindAggregation=function(...e){const[i]=e;const a=this._fnOriginalBindAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"bindAggregation",name:i,target:t})}return a}.bind(this);this._fnOriginalUnBindAggregation=t.unbindAggregation;t.unbindAggregation=function(...e){const[i]=e;const a=this._fnOriginalUnBindAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"unbindAggregation",name:i,target:t})}return a}.bind(this);this._fnOriginalSetParent=t.setParent;t.setParent=function(...e){const[i,a]=e;var n=false;if(!t._bInSetParent){n=true;t._bInSetParent=true}var r=t.getParent();var s=this._fnOriginalSetParent.apply(t,e);if(n){t._bInSetParent=false;if(!t.__bSapUiDtSupressParentChangeEvent&&(r!==i||a==="dependents")){this.fireModified({type:"setParent",value:i,oldValue:r,target:t})}}return s}.bind(this);this._fnOriginalAddAggregation=t.addAggregation;t.addAggregation=function(...e){const[i,a]=e;this._sAddOrSetAggregationCall=i;var n=this._fnOriginalAddAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalSetAggregation=t.setAggregation;t.setAggregation=function(...e){const[i,a]=e;this._sAddOrSetAggregationCall=i;var n=this._fnOriginalSetAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAggregation=t.removeAggregation;t.removeAggregation=function(...e){const[i,a]=e;this._sRemoveAggregationCall=i;var n=this._fnOriginalRemoveAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalInsertAggregation=t.insertAggregation;t.insertAggregation=function(...e){const[i,a]=e;this._sInsertAggregationCall=i;var n=this._fnOriginalInsertAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"insertAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAllAggregation=t.removeAllAggregation;t.removeAllAggregation=function(...e){const[i]=e;this._sRemoveAllAggregationCall=i;var a=t.getAggregation(i);var n=this._fnOriginalRemoveAllAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAllAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalDestroyAggregation=t.destroyAggregation;t.destroyAggregation=function(...e){const[i]=e;this._sDestroyAggregationCall=i;var a=t.getAggregation(i);var n=this._fnOriginalDestroyAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"destroyAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalAddAssociation=t.addAssociation;t.addAssociation=function(...e){const[i,a]=e;this._sAddOrSetAssociationCall=i;var n=this._fnOriginalAddAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalSetAssociation=t.setAssociation;t.setAssociation=function(...e){const[i,a]=e;this._sAddOrSetAssociationCall=i;var n=this._fnOriginalSetAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAssociation=t.removeAssociation;t.removeAssociation=function(...e){const[i,a]=e;this._sRemoveAssociationCall=i;var n=this._fnOriginalRemoveAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAllAssociation=t.removeAllAssociation;t.removeAllAssociation=function(...e){const[i]=e;this._sRemoveAllAssociationCall=i;var a=t.getAssociation(i);var n=this._fnOriginalRemoveAllAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAllAggregation",name:i,value:a,target:t})}return n}.bind(this);this._aOriginalAddMutators={};this._aOriginalInsertMutators={};this._aOriginalRemoveMutators={};this._aOriginalRemoveAllMutators={};this._aOriginalDestructors={};var e=t.getMetadata().getAllAggregations();Object.keys(e).forEach(function(i){var a=e[i];var n=t[a._sMutator];this._aOriginalAddMutators[a.name]=n;t[a._sMutator]=function(...e){const[i]=e;delete this._sAddOrSetAggregationCall;var r=n.apply(t,e);if((!this._sAddOrSetAggregationCall||this._sAddOrSetAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"addOrSetAggregation",name:a.name,value:i,target:t})}return r}.bind(this);var r=t[a._sInsertMutator];this._aOriginalInsertMutators[a.name]=r;t[a._sInsertMutator]=function(...e){const[i]=e;delete this._sInsertAggregationCall;var n=r.apply(t,e);if((!this._sInsertAggregationCall||this._sInsertAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"insertAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var s=t[a._sRemoveMutator];this._aOriginalRemoveMutators[a.name]=s;t[a._sRemoveMutator]=function(...e){const[i]=e;delete this._sRemoveAggregationCall;var n=s.apply(t,e);if((!this._sRemoveAggregationCall||this._sRemoveAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var g=t[a._sRemoveAllMutator];this._aOriginalRemoveAllMutators[a.name]=g;t[a._sRemoveAllMutator]=function(...e){delete this._sRemoveAllAggregationCall;var n=this.getAggregation(i);var r=g.apply(t,e);if((!this._sRemoveAllAggregationCall||this._sRemoveAllAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAllAggregation",name:a.name,value:n,target:t})}return r}.bind(this);var o=t[a._sDestructor];this._aOriginalDestructors[a.name]=o;t[a._sDestructor]=function(...e){delete this._sDestroyAggregationCall;var n=this.getAggregation(i);var r=o.apply(t,e);if((!this._sDestroyAggregationCall||this._sDestroyAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"destroyAggregation",name:a.name,value:n,target:t})}return r}.bind(this)}.bind(this),this);var i=t.getMetadata().getAllAssociations();Object.keys(i).forEach(function(e){var a=i[e];var n=t[a._sMutator];this._aOriginalAddMutators[a.name]=n;t[a._sMutator]=function(...e){const[i]=e;delete this._sAddOrSetAssociationCall;var r;r=n.apply(t,e);if((!this._sAddOrSetAssociationCall||this._sAddOrSetAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"addOrSetAggregation",name:a.name,value:i,target:t})}return r}.bind(this);var r=t[a._sRemoveMutator];this._aOriginalRemoveMutators[a.name]=r;t[a._sRemoveMutator]=function(...e){const[i]=e;delete this._sRemoveAssociationCall;var n=r.apply(t,e);if((!this._sRemoveAssociationCall||this._sRemoveAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var s=t[a._sRemoveAllMutator];this._aOriginalRemoveAllMutators[a.name]=s;t[a._sRemoveAllMutator]=function(...i){delete this._sRemoveAllAssociationCall;var n=this.getAssociation(e);var r=s.apply(t,i);if((!this._sRemoveAllAssociationCall||this._sRemoveAllAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAllAggregation",name:a.name,value:n,target:t})}return r}.bind(this)}.bind(this),this)};i.prototype.unobserve=function(t){t||=this.getTargetInstance();if(this._bIsObserved&&t){this._bIsObserved=false;t.destroy=this._fnOriginalDestroy;t.bindProperty=this._fnOriginalBindProperty;t.unbindProperty=this._fnOriginalUnBindProperty;t.bindAggregation=this._fnOriginalBindAggregation;t.unbindAggregation=this._fnOriginalUnBindAggregation;t.setParent=this._fnOriginalSetParent;t.addAggregation=this._fnOriginalAddAggregation;t.removeAggregation=this._fnOriginalRemoveAggregation;t.insertAggregation=this._fnOriginalInsertAggregation;t.setAggregation=this._fnOriginalSetAggregation;t.removeAllAggregation=this._fnOriginalRemoveAllAggregation;t.destroyAggregation=this._fnOriginalDestroyAggregation;t.addAssociation=this._fnOriginalAddAssociation;t.removeAssociation=this._fnOriginalRemoveAssociation;t.setAssociation=this._fnOriginalSetAssociation;t.removeAllAssociation=this._fnOriginalRemoveAllAssociation;var e=t.getMetadata().getAllAggregations();Object.keys(e).forEach(function(i){var a=e[i];t[a._sMutator]=this._aOriginalAddMutators[a.name];t[a._sInsertMutator]=this._aOriginalInsertMutators[a.name];t[a._sRemoveMutator]=this._aOriginalRemoveMutators[a.name];t[a._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[a.name];t[a._sDestructor]=this._aOriginalDestructors[a.name]},this);var i=t.getMetadata().getAllAssociations();Object.keys(i).forEach(function(e){var a=i[e];t[a._sMutator]=this._aOriginalAddMutators[a.name];t[a._sRemoveMutator]=this._aOriginalRemoveMutators[a.name];t[a._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[a.name]},this);t.detachEvent("_change",this._fnFireModified,this)}delete this._fnOriginalDestroy;delete this._fnOriginalBindProperty;delete this._fnOriginalUnBindProperty;delete this._fnOriginalBindAggregation;delete this._fnOriginalUnBindAggregation;delete this._fnOriginalSetParent;delete this._fnOriginalAddAggregation;delete this._fnOriginalRemoveAggregation;delete this._fnOriginalInsertAggregation;delete this._fnOriginalSetAggregation;delete this._fnOriginalRemoveAllAggregations;delete this._fnOriginalDestroyAggregation;delete this._aOriginalAddMutators;delete this._aOriginalInsertMutators;delete this._aOriginalRemoveMutators;delete this._aOriginalRemoveAllMutators;delete this._aOriginalDestructors};i.prototype.getTargetInstance=function(){return e.getElementInstance(this.getTarget())};i.prototype._isAggregationObservable=function(t){return this.getAggregations()===null||this.getAggregations().includes(t)};return i});
//# sourceMappingURL=ManagedObjectObserver.js.map