/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry"],function(e,t,i){"use strict";var n=e.extend("sap.ui.dt.Plugin",{metadata:{abstract:true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});n.prototype._bProcessingCounter=0;n.prototype._oBusyPromise={};n.prototype.init=function(){};n.prototype.exit=function(){this.setDesignTime(null)};n.prototype.setDesignTime=function(e){var t=this.getDesignTime();if(t){this._deregisterOverlays(t)}this.setProperty("designTime",e);if(e){this._registerOverlays(e)}return this};n.prototype._registerOverlays=function(e){if(this.registerElementOverlay||this.registerAggregationOverlay){var t=e.getElementOverlays();this.setProcessingStatus(true);t.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false)}};n.prototype._deregisterOverlays=function(e){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var t=e.getElementOverlays();t.forEach(this._callElementOverlayDeregestrationMethods.bind(this))}};n.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var t=e.getChildren();t.forEach(this.registerAggregationOverlay.bind(this))}};n.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e)}this.callAggregationOverlayRegistrationMethods(e)};n.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e)}if(this.deregisterAggregationOverlay){var t=e.getChildren();t.forEach(this.deregisterAggregationOverlay.bind(this))}};n.prototype._onElementOverlayCreated=function(e){var t=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(t)};n.prototype.getMenuItems=function(){return[]};n.prototype.getActionName=function(){};n.prototype.isBusy=n.prototype.getBusy;n.prototype.setBusy=function(e){if(e&&!this.getBusy()){this._oBusyPromise.promise=new Promise(function(e){this._oBusyPromise.resolveFunction=e}.bind(this))}else if(!e&&this.getBusy()&&this._oBusyPromise.resolveFunction){this._oBusyPromise.resolveFunction()}this.setProperty("busy",e);return this};n.prototype.waitForBusyAction=function(){return this._oBusyPromise.promise||Promise.resolve()};n.prototype.setProcessingStatus=function(e){this._bProcessingCounter=e?this._bProcessingCounter+1:this._bProcessingCounter-1;if(e===true&&this._bProcessingCounter===1||e===false&&this._bProcessingCounter===0){this.fireProcessingStatusChange({processing:e})}};n.prototype.getAction=function(e){return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getAction(this.getActionName(),e.getElement()):null};n.prototype.getPropagatedActionInfo=function(e){return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getPropagatedActionInfo(this.getActionName()):null};n.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get()};n.prototype.getActionText=function(e,i,n,r){const s=i.name;const o=r||e.getElement();if(s){if(typeof s==="function"){return s(o)}return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getLibraryText(o,s):""}return t.getResourceBundleFor("sap.ui.rta").getText(n)};n.prototype.isAvailable=function(){return false};n.prototype.handler=function(){};n.prototype.isEnabled=function(e){if(!Array.isArray(e)||e.length>1){return false}var t=e[0];var i=this.getAction(t);if(!i){return false}var n=t.getElement();if(i.isEnabled===undefined){return true}if(typeof i.isEnabled==="function"){return i.isEnabled(n)}return i.isEnabled};n.prototype._getMenuItems=async function(e,t){var i=this.enhanceItemWithResponsibleElement({id:t.pluginId,handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:t.rank,icon:t.icon},e);var n=i.responsible||e;var r=n[0];if(this._isEditableByPlugin(r)===undefined){await this.evaluateEditable(n,{onRegistration:false})}var s=this.getAction(r);if(!s||!this.isAvailable(n)||!this.isAvailable(e)){return[]}i.additionalInfo=this._getAdditionalInfo(r,s,t);i.text=this.getActionText(r,s,t.pluginId);return[i]};n.prototype._getAdditionalInfo=function(e,i,n){const r=i.additionalInfoKey;const s=n&&n.additionalInfoKey;if(r){const t=e.getDesignTimeMetadata();const i=e.getElement();return t.getLibraryText(i,r)}else if(s){return t.getResourceBundleFor("sap.ui.rta").getText(s)}return undefined};n.prototype.isResponsibleElementActionAvailable=function(e,t){var i=e.getDesignTimeMetadata();if(i){return i.isResponsibleActionAvailable(t||this.getActionName())}return false};n.prototype.getResponsibleElementOverlay=function(e){var t=e.getElement();var n=e.getDesignTimeMetadata();if(n){var r=n.getResponsibleElement(t);if(r){try{return i.getOverlay(r)}catch(t){return e}}}return e};n.prototype.enhanceItemWithResponsibleElement=function(e,t,i){var n=[];var r=i||[this.getActionName()];var s=r.some(function(e){if(this.isResponsibleElementActionAvailable(t[0],e)){n=t.map(this.getResponsibleElementOverlay.bind(this));return true}}.bind(this));return{...e,...s&&{responsible:n}}};return n});
//# sourceMappingURL=Plugin.js.map