/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/dt/SelectionMode","sap/ui/dt/ElementOverlay"],function(t,e,i,r,n){"use strict";var a=t.extend("sap.ui.dt.SelectionManager",{metadata:{events:{change:{parameters:{selection:{type:"sap.ui.dt.ElementOverlay[]"}}}},properties:{connectedElements:{type:"object",defaultValue:{}}}}});function o(t){return i.castArray(t).map(function(t){if(t instanceof n){return t}var i=e.getOverlay(t);if(i){return i}}).filter(function(t,e,i){return t&&i.indexOf(t)===e})}function s(t){return t.every(function(t){return t.isSelectable()})}function l(t,i){var r=this.getConnectedElements()[t.getAssociation("element")];var n=e.getOverlay(r);if(n){var a=i?"addStyleClass":"removeStyleClass";n[a]("sapUiDtOverlaySelected")}}a.prototype.init=function(){this._aSelection=[];this._aValidators=[];this.addValidator(s)};a.prototype.exit=function(){delete this._aSelection;delete this._aValidators};a.prototype.getSelectionMode=function(){return this._aSelection.length>1?r.Multi:r.Single};a.prototype.get=function(){return this._aSelection.slice()};a.prototype.set=function(t){var e=o(t);var i=false;if(this._validate(e)){var r=this.get().filter(function(t){return!e.includes(t)});i=this._remove(r)||i;i=this._add(e)||i;if(i){this.fireChange({selection:this.get()})}}return i};a.prototype._validate=function(t){return this.getValidators().every(function(e){return e(t)})};a.prototype._add=function(t){var e=this.get();t=t.filter(function(t){return!e.includes(t)});if(t.length){var i=e.concat(t);if(this._validate(i)){this._aSelection=i;t.forEach(function(t){t.setSelected(true);l.call(this,t,true)}.bind(this));return true}}return false};a.prototype.add=function(t){if(this._add(o(t))){this.fireChange({selection:this.get()});return true}return false};a.prototype._remove=function(t){var e=this.get();var i=e.filter(function(e){return!t.includes(e)});if(i.length!==e.length){this._aSelection=i;t.forEach(function(t){t.setSelected(false);l.call(this,t,false)}.bind(this));return true}return false};a.prototype.remove=function(t){if(this._remove(o(t))){this.fireChange({selection:this.get()});return true}return false};a.prototype.reset=function(){return this.remove(this.get())};a.prototype.addValidator=function(t){if(typeof t==="function"&&!this._aValidators.includes(t)){this._aValidators=this._aValidators.concat(t)}};a.prototype.removeValidator=function(t){this._aValidators=this._aValidators.filter(function(e){return t!==e})};a.prototype.getValidators=function(){return this._aValidators.slice()};a.prototype.addHover=function(t){o(t).forEach(function(t){t.addStyleClass("sapUiDtOverlayHover")})};a.prototype.removeHover=function(t){o(t).forEach(function(t){t.removeStyleClass("sapUiDtOverlayHover")})};return a});
//# sourceMappingURL=SelectionManager.js.map