/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/enablement/Test","sap/ui/dt/DesignTime","sap/ui/dt/enablement/Util","sap/base/Log","sap/base/util/ObjectPath","sap/ui/dt/ElementOverlay","sap/ui/qunit/utils/waitForThemeApplied","sap/ui/thirdparty/sinon-4"],function(e,t,i,r,s,n,o,a){"use strict";var d=e.extend("sap.ui.dt.test.ElementEnablementTest",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"},create:{type:"any"},timeout:{type:"int",defaultValue:0},groupPostfix:{type:"string"}}}});var l=0;var h;d.prototype.init=function(){this._aAggregatedTestResult=null;this._aAggregatedInfoResult=null;this._sAggregation=null;this._oTestAreaDomRef=null;if(l===0){h=a.stub(n.prototype,"_subscribeToMutationObserver")}l++};d.prototype.exit=function(){if(this._oDesignTime){this._oDesignTime.destroy()}l--;if(l===0){h.restore()}window.clearTimeout(this._iTimeout);this._oElement.destroy();if(this._oTestAreaDomRef){this._oTestAreaDomRef.remove();delete this._oTestAreaDomRef}};d.prototype.run=function(){return this._setup().then(function(){this._mResult=this.createSuite("Element Enablement Test");var e=this.addGroup(this._mResult.children,this.getType(),`Given that a DesignTime is created for ${this.getType()}`);this._testAggregations(e.children);this._mResult=this.aggregate(this._mResult);return this._mResult}.bind(this))};d.prototype._createElement=function(){var e=this.getType();var t=this.getCreate();return new Promise(function(i){if(t){i(t());return}sap.ui.require([e.replace(/\./g,"/")],function(e){i(new e)},function(){r.warning(`[Deprecated] Control ${e} could only be loaded via global name`);var t=s.get(e||"");i(new t)})}).then(function(e){if(e.addStyleClass){e.addStyleClass("minSize")}return e})};d.prototype._getTestArea=function(){if(!this._oTestAreaDomRef){this._oTestAreaDomRef=document.createElement("div");this._oTestAreaDomRef.id=`${this.getId()}--testArea`;this._oTestAreaDomRef.style.height="500px";this._oTestAreaDomRef.style.width="1000px";document.body.append(this._oTestAreaDomRef)}return this._oTestAreaDomRef};d.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNoRenderer=false;this._bErrorDuringRendering=false;return new Promise(function(e){o().then(function(){return this._createElement()}.bind(this)).then(function(i){this._oElement=i;try{this._oElement.getRenderer()}catch(e){this._bNoRenderer=true}if(!this._bNoRenderer){try{this._oElement.placeAt(this._getTestArea())}catch(e){this._bErrorDuringRendering=true}if(!this._bErrorDuringRendering){this._oDesignTime=new t({rootElements:[this._oElement]});this._oDesignTime.attachEventOnce("synced",function(){if(this.getTimeout()){this._iTimeout=window.setTimeout(function(){e()},this.getTimeout())}else{e()}},this)}else{e()}}else{e()}}.bind(this))}.bind(this))};d.prototype._testAggregations=function(t){var r=this.addGroup(t,"Aggregations","Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",this.getGroupPostfix());if(this._bNoRenderer){this.addTest(r.children,true,"Control has no renderer","Control has no renderer, not supported by the element test (requires a special element test)",e.STATUS.UNKNOWN)}else if(this._bErrorDuringRendering){this.addTest(r.children,true,"Error during rendering","Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",e.STATUS.ERROR)}else{var s=i.getAggregationsInfo(this._oElement);for(var n in s){var o=s[n];var a=this.addGroup(r.children,n,o.ignored?"Aggregation ignored":"Aggregation tests");if(!o.ignored){this.addTest(a.children,o.overlayVisible,"Overlay Visible","Overlay domRef is visible in DOM");if(o.domRefDeclared){this.addTest(a.children,o.domRefDeclared,"Dom Ref Declared","DomRef is declared in design time metadata");this.addTest(a.children,o.domRefFound,"Dom Ref Found","Declared DomRef is found in DOM");this.addTest(a.children,o.domRefVisible,"Dom Ref Visible","Declared DomRef is visible")}else if(o.overlayVisible){this.addTest(a.children,o.overlayGeometryCalculatedByChildren,"Overlay Geometry calculated by children","Control might work based on DT Heuristic, but safer with domRefDeclared",e.STATUS.PARTIAL_SUPPORTED)}else{this.addTest(a.children,false,"Overlay Dom Ref","Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",e.STATUS.PARTIAL_SUPPORTED)}if(o.overlayTooSmall){this.addTest(a.children,false,"Overlay too small","Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",e.STATUS.PARTIAL_SUPPORTED)}}}}};return d});
//# sourceMappingURL=ElementEnablementTest.js.map