/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/m/Button","sap/m/FlexBox","sap/m/FormattedText","sap/m/Menu","sap/m/MenuItem","sap/ui/base/DesignTime","sap/ui/dt/util/_createPromise","sap/ui/dt/OverlayRegistry","sap/ui/dt/Plugin","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/Device"],function(e,t,n,o,i,s,r,u,a,c,l,p,h){"use strict";const d=c.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});const f="sapUiDtContextMenu";d.prototype.init=function(){this.oContextMenuControl=new i;this.oContextMenuControl.attachItemSelected(this._onItemSelected,this);this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.addStyleClass(f);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[]};d.prototype.exit=function(){delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.destroy()}};d.prototype.addMenuItem=function(e,t,n){const o={menuItem:e,fromPlugin:!!t,bPersistOneTime:n};this._aMenuItems.push(o)};d.prototype.registerElementOverlay=function(e){e.attachBrowserEvent("click",this._openContextMenu,this);e.attachBrowserEvent("touchstart",this._openContextMenu,this);e.attachBrowserEvent("contextmenu",this._openContextMenu,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("keyup",this._onKeyUp,this)};d.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._openContextMenu,this);e.detachBrowserEvent("touchstart",this._openContextMenu,this);e.detachBrowserEvent("contextmenu",this._openContextMenu,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("keyup",this._onKeyUp,this)};function m(e){const n=new t({id:`${this.sId}-${e.id}-additionalInfo-button`,icon:"sap-icon://hint",visible:!e.submenu,type:"Transparent",ariaLabelledBy:this.getId()});n.setTooltip(e.additionalInfo);return n}function g(e,t){return e.map(e=>{const n=e.getPropagatedActionInfo(t);if(n){const t=a.getOverlay(n.propagatingControl);let o=e.getMenuItems([t]);if(!(o instanceof Promise)){o=Promise.resolve(o)}return new Promise((e,t)=>{o.then(t=>{const o=t.map(e=>{e.propagatingControl=n.propagatingControl;e.propagatingControlName=n.propagatingControlName;return e});e(o)}).catch(t)})}return null}).filter(Boolean)}d.prototype.open=function(e,t,i){let r;function c(t,i){let u=!!i[0]?.propagatingControl;let l=e;let p=r;i.forEach(function(e,i){if(e.propagatingControl){l=a.getOverlay(e.propagatingControl);p=[l]}const r=typeof e.text==="function"?e.text(l):e.text;const h=typeof e.enabled==="function"?e.enabled(p):e.enabled;const d=new s({key:e.id,icon:e.icon,text:r,enabled:h,startsSection:u});t.addItem(d);if(e.propagatingControlName||e.additionalInfo){const t=new n({justifyContent:"SpaceBetween",alignItems:"Center"});if(e.propagatingControlName){t.addItem(new o({htmlText:`<strong>${e.propagatingControlName}</strong>`}))}if(e.additionalInfo){const n=m.call(this,e);t.addItem(n)}d.addEndContent(t)}if(e.submenu){c.call(this,t.getItems()[i],e.submenu)}u=false}.bind(this))}const p=e.getElement();if(this._fnCancelMenuPromise){if(this.getContextElement()===p){return}this._fnCancelMenuPromise();delete this._fnCancelMenuPromise}this.setContextElement(p);this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);r=this.getSelectedOverlays().filter(function(t){return t!==e});r.unshift(e);this._aMenuItems=this._aMenuItems.filter(function(e){if(e.bPersistOneTime){e.bPersistOneTime=false;return true}return!e.fromPlugin});this.oContextMenuControl.destroyItems();let h=Promise.resolve();if(!t){const e=u(function(e,t){l.waitForSynced(this.getDesignTime())().then(e).catch(t)}.bind(this));this._fnCancelMenuPromise=e.cancel;h=e.promise.then(function(){this._aGroupedItems=[];this._aSubMenus=[];const e=[];const t=this.getDesignTime().getPlugins();t.forEach(function(t){let n=t.getMenuItems(r);if(!(n instanceof Promise)){n=Promise.resolve(n)}e.push(n)});let n=[];if(r.length===1){n=g(t,r[0])}const o=u(function(t,o){e.push(...n);Promise.all(e).then(t).catch(o)});this._fnCancelMenuPromise=o.cancel;return o.promise}.bind(this)).then(function(e){return e.reduce(function(e,t){return e.concat(t)})}).then(function(e){e.forEach(function(e){if(e.submenu!==undefined){this._addSubMenu(e)}else{this.addMenuItem(e,true)}}.bind(this));this._addItemGroupsToMenu();delete this._fnCancelMenuPromise}.bind(this))}h.then(function(){const t=this._aMenuItems.map(function(e){return e.menuItem});if(t.length>0){const n=this._sortMenuItems(t.filter(e=>!e.propagatingControl));const o=this._sortMenuItems(t.filter(e=>e.propagatingControl));c.call(this,this.oContextMenuControl,n);c.call(this,this.oContextMenuControl,o,true);this.oContextMenuControl.openAsContextMenu(i,e)}this.fireOpenedContextMenu()}.bind(this)).catch(function(e){throw l.createError("ContextMenu#open",`An error occurred during calling getMenuItems: ${e}`)})};d.prototype._sortMenuItems=function(e){return e.sort(function(e,t){if(!e.rank&&!t.rank){return 0}if(!e.rank&&t.rank){return-1}if(e.rank&&!t.rank){return 1}return e.rank-t.rank})};d.prototype._onItemSelected=function(t){this._ensureSelection(this._oCurrentOverlay);function n(t,n){let o;if(t.propagatingControl){o=[a.getOverlay(t.propagatingControl)]}else{o=t.responsible||this.getSelectedOverlays()||[]}e(o.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");const i={};i.eventItem=n;i.contextElement=this.getContextElement();t.handler(o,i)}const o=t.getParameter("item").getKey();this._aMenuItems.some(function(e){const i=e.menuItem;if(o===e.menuItem.id){n.apply(this,[i,t]);return true}else if(i.submenu){i.submenu.some(function(e){if(o===e.id){n.apply(this,[e,t]);return true}}.bind(this))}},this)};d.prototype._onKeyUp=function(e){const t=a.getOverlay(e.currentTarget.id);if(e.keyCode===p.ENTER&&t.getIgnoreEnterKeyUpOnce()){t.setIgnoreEnterKeyUpOnce(false);e.stopPropagation();e.preventDefault();return}if((e.keyCode===p.SPACE||e.keyCode===p.ENTER)&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}if(e.keyCode===p.F10&&e.shiftKey===true&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}};d.prototype._onKeyDown=function(e){const t=a.getOverlay(e.currentTarget.id);if(e.keyCode===p.SPACE&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(t&&t.isSelectable()&&!this._checkForPluginLock()){t.setSelected(true);e.stopPropagation();e.preventDefault()}}};d.prototype._openContextMenu=function(e){if(e.type==="click"&&r.isDesignModeEnabled()){return}const t=a.getOverlay(e.currentTarget.id);if(t&&t.isSelectable()&&t.getSelected()){this._oCurrentOverlay=t;this.open(t,undefined,e)}};d.prototype._contextMenuClosed=function(){this.fireClosedContextMenu()};d.prototype._onSelectionChanged=function(){this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this)};d.prototype._ensureSelection=function(e){if(e&&!e.isSelected()){e.setSelected(true)}};d.prototype._checkForPluginLock=function(){if(h.os.ios){return false}if(this.getDesignTime().getBusyPlugins().length){return true}return false};d.prototype._addMenuItemToGroup=function(e){const t=this._aGroupedItems.some(function(t){if(t.sGroupName===e.group){t.aGroupedItems.push(e);return true}});if(!t){this._aGroupedItems.push({sGroupName:e.group,aGroupedItems:[e]})}};d.prototype._addSubMenu=function(e){e.submenu.forEach(function(t){t.handler||=e.handler});this._aSubMenus.push({sSubMenuId:e.id,aSubMenuItems:e.submenu});this.addMenuItem(e,true)};d.prototype._addItemGroupsToMenu=function(){this._aGroupedItems.forEach(function(e){if(e.aGroupedItems.length===1){this.addMenuItem(e.aGroupedItems[0],true)}else{this.addMenuItem({id:`${e.sGroupName}-groupItem`,enabled:true,text:e.sGroupName,icon:e.aGroupedItems[0].icon,rank:e.aGroupedItems[0].rank,submenu:e.aGroupedItems},true)}}.bind(this))};return d});
//# sourceMappingURL=ContextMenu.js.map