/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/base/util/Version","sap/ui/core/Element","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave","sap/ui/events/ControlEvents","sap/ui/Device","sap/ui/events/TouchToMouseMapping","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jquery-mobile-custom"],function(e,t,n,o,a,s,i,u,jQuery){"use strict";var r={};var c=t(jQuery.fn.jquery);r.aAdditionalControlEvents=[];r.aAdditionalPseudoEvents=[];r._createSimulatedEvent=function(e,t,n){var o="__"+e+"Handler";var a="sap"+e;this.aAdditionalControlEvents.push(a);this.aAdditionalPseudoEvents.push({sName:e,aTypes:[a],fnCheck:function(e){return true}});jQuery.event.special[a]={add:function(o){var s=this,i=jQuery(this),u={domRef:s,eventName:e,sapEventName:a,eventHandle:o};var r=function(e){n(e,u)};o.__sapSimulatedEventHandler=r;for(var c=0;c<t.length;c++){i.on(t[c],r)}},remove:function(e){var n=jQuery(this);var a=e.__sapSimulatedEventHandler;n.removeData(o+e.guid);for(var s=0;s<t.length;s++){jQuery.event.remove(this,t[s],a)}}}};r._handleMouseToTouchEvent=function(e,t){if(e.isMarked("delayedMouseEvent")){return}var o=jQuery(t.domRef),s=n.closestTo(e.target),i=o.data("__touchstart_control"),u=i&&window.document.getElementById(i);if(e.type==="mouseout"&&!a(e,t.domRef)&&(!u||!a(e,u))){return}var r=jQuery.event.fix(e.originalEvent||e);r.type=t.sapEventName;if(r.isMarked("firstUIArea")){r.setMark("handledByUIArea",false)}var c=[{identifier:1,pageX:r.pageX,pageY:r.pageY,clientX:r.clientX,clientY:r.clientY,screenX:r.screenX,screenY:r.screenY,target:r.target,radiusX:1,radiusY:1,rotationAngle:0}];switch(t.eventName){case"touchstart":if(s){o.data("__touchstart_control",s.getId())}case"touchmove":r.touches=r.changedTouches=r.targetTouches=c;break;case"touchend":r.changedTouches=c;r.touches=r.targetTouches=[];break}if(t.eventName==="touchstart"||o.data("__touch_in_progress")){o.data("__touch_in_progress","X");if(e.type==="mouseout"){r.setMarked("fromMouseout")}if(t.eventName!=="touchstart"&&(!s||s.getId()!==i)){r.setMark("scopeCheckId",i)}if(e.type!=="dragstart"){t.eventHandle.handler.call(t.domRef,r)}if((t.eventName==="touchend"||e.type==="dragstart")&&!r.isMarked("fromMouseout")){o.removeData("__touch_in_progress");o.removeData("__touchstart_control")}}};r._initTouchEventSimulation=function(){this._createSimulatedEvent("touchstart",["mousedown"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchend",["mouseup","mouseout"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchmove",["mousemove","dragstart"],this._handleMouseToTouchEvent)};r._initContextMenuSimulation=function(){var e=function(e,t){var n=jQuery.event.fix(e.originalEvent||e);n.type=t.sapEventName;if(!window.getSelection||!window.getSelection()||window.getSelection().toString()===""){t.eventHandle.handler.call(t.domRef,n)}};this._createSimulatedEvent("contextmenu",["taphold"],e)};r._initMouseEventSimulation=function(){var e=false,t=jQuery.vmouse.moveDistanceThreshold,n,o,a,s;var i=function(e,t,n){var o=jQuery.event.fix(e.originalEvent||e);o.type=t.sapEventName;delete o.touches;delete o.changedTouches;delete o.targetTouches;o.screenX=n.screenX;o.screenY=n.screenY;o.clientX=n.clientX;o.clientY=n.clientY;o.ctrlKey=n.ctrlKey;o.altKey=n.altKey;o.shiftKey=n.shiftKey;o.button=0;return o};var u=function(a,s){if(a.isMarked("handledByTouchToMouse")){return}a.setMarked("handledByTouchToMouse");if(!e){var u=a.originalEvent.touches[0];e=Math.abs(u.pageX-n)>t||Math.abs(u.pageY-o)>t}var r=i(a,s,a.touches[0]);setTimeout(function(){r.setMark("handledByUIArea",false);s.eventHandle.handler.call(s.domRef,r)},0)};var r=function(t,u){if(t.isMarked("handledByTouchToMouse")){return}t.setMarked("handledByTouchToMouse");var r,c,d;function l(){return i(t,u,u.eventName==="mouseup"?t.changedTouches[0]:t.touches[0])}if(t.type==="touchstart"){var h=t.originalEvent.touches[0];e=false;n=h.pageX;o=h.pageY;a=Math.round(h.pageX-jQuery(t.target).offset().left);s=Math.round(h.pageY-jQuery(t.target).offset().top);r=l();setTimeout(function(){r.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,r)},0)}else if(t.type==="touchend"){c=l();d=!e;setTimeout(function(){c.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,c);if(d){c.type="click";c.getPseudoTypes=jQuery.Event.prototype.getPseudoTypes;c.setMark("handledByUIArea",false);c.offsetX=a;c.offsetY=s;u.eventHandle.handler.call(u.domRef,c)}},0)}};this._createSimulatedEvent("mousedown",["touchstart"],r);this._createSimulatedEvent("mousemove",["touchmove"],u);this._createSimulatedEvent("mouseup",["touchend","touchcancel"],r)};r._init=function(t){this.aAdditionalControlEvents.push("swipe","tap","swipeleft","swiperight","scrollstart","scrollstop");this.aAdditionalPseudoEvents.push({sName:"swipebegin",aTypes:["swipeleft","swiperight"],fnCheck:function(t){var n=e.getRTL();return n&&t.type==="swiperight"||!n&&t.type==="swipeleft"}});this.aAdditionalPseudoEvents.push({sName:"swipeend",aTypes:["swipeleft","swiperight"],fnCheck:function(t){var n=e.getRTL();return!n&&t.type==="swiperight"||n&&t.type==="swipeleft"}});if(c.compareTo("1.9.1")<0){t=t.concat(this.aAdditionalControlEvents)}else{t=this.aAdditionalControlEvents.concat(t)}for(var n=0;n<this.aAdditionalPseudoEvents.length;n++){o.addEvent(this.aAdditionalPseudoEvents[n])}return t};if(i.browser.webkit&&/Mobile/.test(navigator.userAgent)&&i.support.touch){u.init(window.document);r.disableTouchToMouseHandling=u.disableTouchToMouseHandling}if(!r.disableTouchToMouseHandling){r.disableTouchToMouseHandling=function(){}}if(i.support.touch){s.events.push("touchstart","touchend","touchmove","touchcancel")}(function e(){r.touchEventMode="SIM";if(i.support.touch){r.touchEventMode="ON";if(c.compareTo("3.0.0")<0){jQuery.event.props.push("touches","targetTouches","changedTouches")}}r._initTouchEventSimulation();if(i.os.ios){r._initContextMenuSimulation()}if(i.support.touch){r.disableTouchToMouseHandling();r._initMouseEventSimulation()}s.events=r._init(s.events)})();return r});
//# sourceMappingURL=EventSimulation.js.map