/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/LayerUtils"],function(e,t,n,r,a,i,o,s,c,f,l,u,p){"use strict";var h=function(t){this._mComponent=t;if(!this._mComponent||!this._mComponent.name){e.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.")}this._oMessagebundle=undefined};h.prototype._deleteNotSavedChanges=function(e,t,n){e.filter(function(e){return!t.some(function(t){return e.getId()===t.getId()})}).forEach(function(e){if(n){this.removeChange(e);i.updateStorageResponse(this._mComponent.name,[{flexObject:e.convertToFileContent(),type:"delete"}])}else{f.deleteFlexObjects({reference:this._mComponent.name,flexObjects:[e]})}}.bind(this))};function g(e,t){var n=e.map(function(e){return e[t]()});var r=n.filter(function(e,t,n){return n.indexOf(e)===t});return r.length===1}function d(e,t,n){var r=false;if(!e||!g(t,"getLayer")){return false}if(n){r=true}else{var a=t[0].getLayer();if([u.CUSTOMER,u.PUBLIC,u.USER].includes(a)){r=true}}var i=new URLSearchParams(window.location.search);if(i.has("sap-ui-xx-condense-changes")){r=i.get("sap-ui-xx-condense-changes")==="true"}return r}function m(){return s.getInstanceOrUndef()?.isCondensingEnabled()}function y(e,t,n,r){this._massUpdateCacheAndDirtyState(t,n);this._deleteNotSavedChanges(e,t,r)}function S(e,r,a,o,s){if(!e.length&&!a){return[]}const c=i.getFlexObjectsDataSelector().get({reference:s}).filter(function(e){if(e instanceof t){return false}if(e.getFlexObjectMetadata().reference!==s){return false}if(o===u.CUSTOMER&&r){return e.getState()===n.LifecycleState.PERSISTED&&r.includes(e.getId())}return e.getState()===n.LifecycleState.PERSISTED&&p.compareAgainstCurrentLayer(e.getLayer(),o)===0});return c.concat(e)}function C(e){if(e.length){var t=b(e);var n=true;if(s.getInstanceOrUndef()&&s.getInstanceOrUndef().hasPersoConnector()){var r=x(e);n=r.length===1}return t.length===1&&n}return true}function v(e,t,r,a,i,o){let s=Promise.resolve();const c=i.filter(e=>e.getState()===n.LifecycleState.DELETED);const f=o.filter(e=>e.getState()!==n.LifecycleState.DELETED);if(c.length){s=this.saveSequenceOfDirtyChanges(c,a,r)}return s.then(function(){if(f.length){return l.write({layer:e,flexObjects:D(f),transport:t,isLegacyVariant:false,parentVersion:r}).then(function(e){y.call(this,i,f,a);return e}.bind(this))}return this._deleteNotSavedChanges(i,o)}.bind(this))}h.prototype.saveDirtyChanges=function(e,t,n,r,i,o,s){const f=this._mComponent.name;const u=n||a.getDirtyFlexObjects(f);const p=u.length&&u[0].getLayer()||s;const h=S(u,i,o,p,f);const g=m()&&d(e,h,o);const _=g?h:u;const x=_.slice(0);const D=b(u);if(C(u)){const n=d(e,x,o)?c.condense(e,x):Promise.resolve(x);return n.then(function(e){const n=D[0];if(g){return l.condense({allChanges:_,condensedChanges:e,layer:p,transport:n,isLegacyVariant:false,parentVersion:r}).then(function(n){y.call(this,_,e,t,true);return n}.bind(this))}return v.call(this,p,n,r,t,_,e)}.bind(this))}return this.saveSequenceOfDirtyChanges(u,t,r)};h.prototype.saveSequenceOfDirtyChanges=async function(e,t,r){var a;if(r){var o=e.filter(function(e){return e.getState()===n.LifecycleState.NEW});a=[].concat(o).shift()}const s={response:[]};for(const n of e){const e=await _(n,a,r);this._updateCacheAndDirtyState(n,t);if(e?.response){s.response.push(...e.response)}}i.getFlexObjectsDataSelector().checkUpdate({reference:this._mComponent.name});return s};function _(e,t,r){switch(e.getState()){case n.LifecycleState.NEW:if(r!==undefined){r=e===t?r:o.Number.Draft}return l.write({layer:e.getLayer(),flexObjects:[e.convertToFileContent()],transport:e.getRequest(),parentVersion:r});case n.LifecycleState.DELETED:return l.remove({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:r});default:return Promise.resolve()}}h.prototype._updateCacheAndDirtyState=function(e,t){if(!t){switch(e.getState()){case n.LifecycleState.NEW:i.updateStorageResponse(this._mComponent.name,[{type:"add",flexObject:e.convertToFileContent()}]);break;case n.LifecycleState.DELETED:i.updateStorageResponse(this._mComponent.name,[{type:"delete",flexObject:e.convertToFileContent()}]);break;case n.LifecycleState.UPDATED:i.updateStorageResponse(this._mComponent.name,[{type:"update",flexObject:e.convertToFileContent()}]);break;default:}e.setState(n.LifecycleState.PERSISTED)}};h.prototype._massUpdateCacheAndDirtyState=function(e,t){e.forEach(function(e){this._updateCacheAndDirtyState(e,t)},this);i.getFlexObjectsDataSelector().checkUpdate({reference:this._mComponent.name})};function b(e){var t=[];e.forEach(function(e){var n=e.getRequest();if(t.indexOf(n)===-1){t.push(n)}});return t}function x(e){var t=[];e.forEach(function(e){var n=e.getLayer();if(t.indexOf(n)===-1){t.push(n)}});return t}function D(e){var t=[];e.forEach(function(e){t.push(e.convertToFileContent())});return t}h.prototype.removeChange=function(e){i.removeDirtyFlexObjects(this._mComponent.name,[e]);this._deleteChangeInMap(e)};h.prototype._deleteChangeInMap=function(e,t){var n=e.getId();r.removeChangeFromMap(a.getLiveDependencyMap(this._mComponent.name),n);if(!t){r.removeChangeFromDependencies(a.getLiveDependencyMap(this._mComponent.name),n)}};return h});
//# sourceMappingURL=ChangePersistence.js.map