/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/Utils"],function(e,n,t,o,r,a,i,s,c){"use strict";let l=c.FakePromise?new c.FakePromise:Promise.resolve();const p={};const d={};function g(t,o,r,a){const i=n(o.join(" "),r);e[t](i,a||"")}async function f(e,n){const t=e.getSelector&&e.getSelector();if(!t||!t.id&&!t.name){throw Error("No selector in change found or no selector ID.")}function o(e){if(c.indexOfObject(n.failedSelectors,e)>-1){throw Error("A change depending on that control already failed, so the current change is skipped")}}const r=await n.modifier.bySelectorTypeIndependent(t,n.appComponent,n.view);if(!r){throw Error("A flexibility change tries to change a nonexistent control.")}o(t);const a=e.getDependentControlSelectorList();a.forEach(e=>{const t=n.modifier.bySelector(e,n.appComponent,n.view);if(!t){throw new Error("A dependent selector control of the flexibility change is not available.")}o(e)});return r}function u(e){return e.modifier.targets==="xmlTree"}function h(e,n,t,o){const i=a.getControlIfTemplateAffected(n,e,t).control;const c=t.modifier;const l=i&&!!r.getAppliedCustomDataValue(i,n,c);const p=i&&r.hasChangeApplyFinishedCustomData(i,n,c);const d=n.isApplyProcessFinished();if(d&&!p){if(!o){s.copyDependenciesFromCompleteDependencyMap(n,t.appComponent)}n.setInitialApplyState()}else if(!d&&p){if(l){n.setRevertData(r.getParsedRevertDataFromCustomData(i,n,c));n.markSuccessful()}else{n.markFailed()}}else if(d&&p){n.markSuccessful()}}function y(e,n){if(u(n)&&e.getJsOnly()){const n="Change cannot be applied in XML. Retrying in JS.";e.setInitialApplyState();throw Error(n)}}async function m(e,n,o,a){if(o instanceof t){n.control=o}if(n.control){await a.modifier.updateAggregation(n.originalControl,e.getContent().boundAggregation)}await r.addAppliedCustomData(n.control,e,a,u(a));const i={success:true};e.markSuccessful(i);return i}async function C(e,n,t,o){const a=u(o);const i={success:false,error:e};const s=n.getId();const c="Change ''{0}'' could not be applied.";const l=e instanceof Error;const p=r.getCustomDataIdentifier(false,l,a);switch(p){case r.notApplicableChangesCustomDataKey:g("info",[c,e.message],[s]);break;case r.failedChangesCustomDataKeyXml:g("warning",[c,"Merge error detected while processing the XML tree."],[s],e.stack);break;case r.failedChangesCustomDataKeyJs:g("error",[c,"Merge error detected while processing the JS control tree."],[s],e.stack);break;default:}await r.addFailedCustomData(t.control,n,o,p);if(a){n.setInitialApplyState()}else{n.markFailed(i)}return i}function A(n,t){const o=t.getChangeType();const r=t.getSelector().id;const a=`${t.getNamespace()+t.getId()}.${t.getFileType()}`;let i="A flexibility change could not be applied.";i+="\nThe displayed UI might not be displayed as intended.";if(n.message){i+=`\n   occurred error message: '${n.message}'`}i+=`\n   type of change: '${o}'`;i+=`\n   LRep location of the change: ${a}`;i+=`\n   id of targeted control: '${r}'.`;e.warning(i,undefined,"sap.ui.fl.apply._internal.changes.Applier")}function w(e,n,t){const r={appComponent:t,modifier:o};const a=o.bySelector(e.originalSelectorToBeAdjusted,t);let i=n.getBindingInfo(e.getContent().boundAggregation).template;if(a.getParent()){const e=[];let n=a;do{e.push({aggregation:n.sParentAggregationName,index:n.getParent().getAggregation(n.sParentAggregationName).indexOf(n)});n=n.getParent()}while(n.getParent());e.reverse();e.forEach(e=>{i=i.getAggregation(e.aggregation)[e.index]})}e.addDependentControl(i,"originalSelector",r)}function S(e,n,t){let o=e.findIndex(e=>e.handler===n);if(o<0){o=e.length;e.push({handler:n,controls:[]})}if(!e[o].controls.includes(t)){e[o].controls.push(t)}}async function b(e,n,t,o){const r=[];const a=e.getId();const s=t.mChanges[a]||[];let l;if(t.mControlsWithDependencies[a]){i.removeControlsDependencies(t,a);l=true}s.forEach(s=>{if(s.originalSelectorToBeAdjusted){w(s,e,o);delete s.originalSelectorToBeAdjusted}if(s._ignoreOnce){delete s._ignoreOnce}else if(s.isApplyProcessFinished()){i.resolveDependenciesForChange(t,s.getId(),a)}else if(!t.mDependencies[s.getId()]){r.push(async()=>{await d.applyChangeOnControl(s,e,n);i.resolveDependenciesForChange(t,s.getId(),a)})}else{const o=d.applyChangeOnControl.bind(d,s,e,n);i.addChangeApplyCallbackToDependency(t,s.getId(),o)}});if(s.length||l){await c.execPromiseQueueSequentially(r);await i.processDependentQueue(t,o,a)}p[a].shift().resolveFunction()}d.addPreConditionForInitialChangeApplying=function(e){l=l.then(()=>e)};d.applyChangeOnControl=async function(e,n,t){const o=a.getControlIfTemplateAffected(e,n,t);try{const n=t.changeHandler||await a.getChangeHandler({flexObject:e,control:o.control,controlType:o.controlType,modifier:t.modifier});y(e,t);if(e.hasApplyProcessStarted()){const n=await e.addPromiseForApplyProcessing();e.markSuccessful();return n}if(!e.isApplyProcessFinished()){e.startApplying();try{const r=await n.applyChange(e,o.control,t);return m(e,o,r,t)}catch(n){return C(n,e,o,t)}}const r={success:true};e.markSuccessful(r);return r}catch(e){return{success:false,error:e}}};d.applyMultipleChanges=async function(e,n){n.modifier=o;for(const t of e){const e=o.bySelector(t.getSelector(),n.appComponent);const r=s.getLiveDependencyMap(n.reference);if(e){h(e,t,n,true);if(!t.isApplyProcessFinished()){t.setQueuedForApply()}let o;try{o=await d.applyChangeOnControl(t,e,n)}catch(e){o={success:false}}if(o.success){i.addRuntimeChangeToMap(t,n.appComponent,r)}}else{i.addChangeAndUpdateDependencies(t,n.appComponent.getId(),r)}}};d.applyAllChangesForControl=async function(e,n,t){const r=s.getLiveDependencyMap(n);const a=t.getId();const i=r.mChanges[a]||[];const d={modifier:o,appComponent:e,view:c.getViewForControl(t)};if(p[a]?.length){await p[a][p[a].length-1].promise}i.forEach(e=>{h(t,e,d);if(!e.isApplyProcessFinished()&&!e._ignoreOnce){e.setQueuedForApply()}});p[a]||=[];const g={};g.promise=new Promise(e=>{g.resolveFunction=e});p[a].push(g);l=l.then(b.bind(undefined,t,d,r,e));return l};d.applyAllChangesForXMLView=async function(n,t){if(!Array.isArray(t)){const o=`No list of changes was passed for processing the flexibility on view: ${n.view}.`;e.error(o,undefined,"sap.ui.fl.apply._internal.changes.Applier");t=[]}const o=[];n.failedSelectors=[];for(const e of t){try{const t=await f(e,n);const r=a.getControlIfTemplateAffected(e,t,n);n.changeHandler=await a.getChangeHandler({flexObject:e,control:r.control,controlType:r.controlType,modifier:n.modifier});e.setQueuedForApply();h(t,e,n,true);if(!e.isApplyProcessFinished()){if(typeof n.changeHandler.onAfterXMLChangeProcessing==="function"){S(o,n.changeHandler,t)}const r=await d.applyChangeOnControl(e,t,n);if(!r.success){throw Error(r.error)}}}catch(t){e.getDependentSelectorList().forEach(e=>{if(c.indexOfObject(n.failedSelectors,e)===-1){n.failedSelectors.push(e)}});A(t,e)}}delete n.failedSelectors;o.forEach(t=>{t.controls.forEach(o=>{try{t.handler.onAfterXMLChangeProcessing(o,n)}catch(n){e.error("Error during onAfterXMLChangeProcessing",n)}})});return n.view};return d});
//# sourceMappingURL=Applier.js.map