/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/deepClone","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/util/restricted/_omit","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,n,a,r,o,i,s,p,u){"use strict";var c=o.extend("sap.ui.fl.apply._internal.flexObjects.FlexObject",{metadata:{properties:{adaptationId:{type:"string"},state:{type:"string",defaultValue:i.LifecycleState.NEW},fileType:{type:"string",defaultValue:"change"},layer:{type:"string"},flexObjectMetadata:{type:"object",defaultValue:{}},supportInformation:{type:"object",defaultValue:{}},content:{type:"any",defaultValue:{}},texts:{type:"object",defaultValue:{}}}},constructor:function(...t){o.apply(this,t);var e=this.getFlexObjectMetadata();var n=e.reference;if(n){e.reference=n.endsWith(".Component")?n.replace(/\.Component(?!.*\.Component)/,""):n;e.namespace||=u.createNamespace({reference:n},this.getFileType());e.projectId||=n}this.setFlexObjectMetadata(e);var a=this.getSupportInformation();a.originalLanguage||=u.getCurrentLanguage();this.setSupportInformation(a)}});c.getMappingInfo=function(){return{"flexObjectMetadata.changeType":"changeType","flexObjectMetadata.reference":"reference","flexObjectMetadata.namespace":"namespace","flexObjectMetadata.creation":"creation","flexObjectMetadata.projectId":"projectId","flexObjectMetadata.packageName":"packageName","flexObjectMetadata.moduleName":"moduleName","supportInformation.generator":"support.generator","supportInformation.clonedFrom":"support.clonedFrom","supportInformation.service":"support.service","supportInformation.sourceSystem":"sourceSystem","supportInformation.sourceClient":"sourceClient","supportInformation.user":"support.user","supportInformation.sapui5Version":"support.sapui5Version","supportInformation.sourceChangeFileName":"support.sourceChangeFileName","supportInformation.compositeCommand":"support.compositeCommand","supportInformation.command":"support.command","supportInformation.oDataInformation":"oDataInformation","supportInformation.originalLanguage":"originalLanguage",adaptationId:"adaptationId",layer:"layer",fileType:"fileType",id:"fileName",content:"content",texts:"texts"}};c.prototype.getMappingInfo=function(){return c.getMappingInfo()};c.prototype.setContent=function(t,e){this.setProperty("content",t);if(!e){this.setState(i.LifecycleState.UPDATED)}return this};c.prototype.getFlexObjectMetadata=function(){return{...this.getProperty("flexObjectMetadata")}};c.prototype.getSupportInformation=function(){return{...this.getProperty("supportInformation")}};function f(t,e){if(!Object.values(i.LifecycleState).includes(t)){return false}if(e===i.LifecycleState.NEW&&t===i.LifecycleState.UPDATED){return false}return true}c.prototype.setState=function(t){var e=this.getState();if(e!==t&&f(t,e)){this._sPreviousState=e;this.setProperty("state",t)}return this};c.prototype.isPersisted=function(){return this.getState()===i.LifecycleState.PERSISTED};c.prototype.markForDeletion=function(){this.setState(i.LifecycleState.DELETED)};c.prototype.restorePreviousState=function(){if(this._sPreviousState){this.setState(this._sPreviousState);delete this._sPreviousState}};c.prototype.isChangeFromOtherSystem=function(){var t=this.getSupportInformation().sourceSystem;var e=this.getSupportInformation().sourceClient;if(!t||!e){return false}var n=p.getInstanceOrUndef();if(!n){return true}var a=n.getSystem();var r=n.getClient();if(!a||!r){return false}return t!==a||e!==r};c.prototype.isValidForDependencyMap=function(){return false};c.prototype.getNamespace=function(){return this.getFlexObjectMetadata().namespace};c.prototype.getChangeType=function(){return this.getFlexObjectMetadata().changeType};c.prototype.isUserDependent=function(){return this.getLayer()===s.USER};c.prototype.getText=function(t){var e=this.getTexts()[t]||{};return e.value||""};c.prototype.setText=function(t,e,n,a){const r={...this.getTexts()};const o={value:e};if(n){o.type=n}r[t]={...r[t],...o};this.setTexts(r);if(!a){this.setState(i.LifecycleState.UPDATED)}return this};c.prototype.setRequest=function(t){this._sRequest=t};c.prototype.getRequest=function(){return this._sRequest||""};c.prototype.getDefinition=function(){return this.convertToFileContent()};c.prototype.getCreation=function(){return this.getFlexObjectMetadata().creation};c.prototype.setCreation=function(t){var e=this.getFlexObjectMetadata();e.creation=t;this.setFlexObjectMetadata(e)};function l(t){return t.length?t.charAt(0).toUpperCase()+t.slice(1):t}function g(t){return typeof this[t]==="function"?this[t].bind(this):function(){throw new Error(`${t} is not a valid mutator`)}}function h(e){var n=e.split(".");n[0]=l(n[0]);var r=n.shift();var o=g.call(this,`get${r}`);var i=g.call(this,`set${r}`);return{getValue(){var e=t(o());if(n.length>0){return a.get(n,e)}return e},setValue:function(e){var r=t(o());if(n.length>0){a.set(n,e,r)}else{r=e}i(r);return this}.bind(this)}}c.prototype.convertToFileContent=function(){var t={};Object.entries(this.getMappingInfo()).forEach(function(e){var n=h.call(this,e[0]).getValue();if(n!==undefined){a.set(e[1],n,t)}}.bind(this));return t};function d(t,e){var n=h.call(this,t);var a=n.getValue();if(a!==e){n.setValue(e)}}c.mapFileContent=function(e,a){var r=Object.values(a);var o={};var i=function(t,e,s){var p=s?`${s}.${t}`:t;var u=r.indexOf(p);if(u>=0){var c=Object.keys(a)[u];o[c]=e}else if(n(e)){Object.entries(e).forEach(function(t){i(t[0],t[1],p)})}};Object.entries(t(e,15)).forEach(function(t){i(t[0],t[1])});return o};c.prototype.update=function(t){var e=r(t,["fileName"]);var n=c.mapFileContent(e,this.getMappingInfo());Object.entries(n).forEach(function(t){d.call(this,t[0],t[1])}.bind(this))};c.prototype.setResponse=function(t){if(!t||e(t)){return}this.update(t);this.setState(i.LifecycleState.PERSISTED)};c.prototype.cloneFileContentWithNewId=function(){var t=this.convertToFileContent();t.fileName=u.createDefaultFileName(t.fileName.split("_").pop());t.support.clonedFrom=this.getId();return t};c.prototype.getIdForCondensing=function(){throw new Error("Method getIdForCondensing must be implemented")};c.prototype.canBeCondensed=function(){return false};c.prototype.canBeVisualized=function(){return false};return c});
//# sourceMappingURL=FlexObject.js.map