/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Utils"],function(e,t,s,r,o,n){"use strict";var i=r.extend("sap.ui.fl.apply._internal.flexObjects.UIChange",{metadata:{properties:{selector:{type:"object",defaultValue:{}},dependentSelectors:{type:"object",defaultValue:{}},applyState:{type:"string",defaultValue:o.ApplyState.NEW},jsOnly:{type:"boolean"},variantReference:{type:"string"},isChangeOnStandardVariant:{type:"boolean"},savedToVariant:{type:"boolean"},revertData:{type:"any",defaultValue:null}},aggregations:{},associations:{},events:{}},constructor:function(...e){r.apply(this,e);this._oChangeProcessingPromises={};this.setInitialApplyState()}});i.getMappingInfo=function(){return{...r.getMappingInfo(),selector:"selector",dependentSelectors:"dependentSelector",jsOnly:"jsOnly",variantReference:"variantReference",isChangeOnStandardVariant:"isChangeOnStandardVariant"}};i.prototype.getMappingInfo=function(){return i.getMappingInfo()};i.prototype.setQueuedForRevert=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==o.Operations.REVERT){this._aQueuedProcesses.unshift(o.Operations.REVERT)}};i.prototype.isQueuedForRevert=function(){return this._aQueuedProcesses.indexOf(o.Operations.REVERT)>-1};i.prototype.setQueuedForApply=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==o.Operations.APPLY){this._aQueuedProcesses.unshift(o.Operations.APPLY)}};i.prototype.isQueuedForApply=function(){return this._aQueuedProcesses.indexOf(o.Operations.APPLY)>-1};i.prototype.setInitialApplyState=function(){this._aQueuedProcesses=[];delete this._ignoreOnce;this.setApplyState(o.ApplyState.INITIAL);this._oChangeProcessedPromise={};this._oChangeProcessedPromise.promise=new Promise(function(e){this._oChangeProcessedPromise.resolveFunction={resolve:e}}.bind(this))};i.prototype.isInInitialState=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()===o.ApplyState.INITIAL};i.prototype.isValidForDependencyMap=function(){return!!this.getSelector().id};i.prototype.startApplying=function(){this.setApplyState(o.ApplyState.APPLYING)};i.prototype.markFinished=function(e,t){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(o.Operations.APPLY,e);var s=t!==false?o.ApplyState.APPLY_SUCCESSFUL:o.ApplyState.APPLY_FAILED;this.setApplyState(s)};i.prototype.markSuccessful=function(e){this.markFinished(e,true)};i.prototype.markFailed=function(e){this.markFinished(e,false)};i.prototype.startReverting=function(){this.setApplyState(o.ApplyState.REVERTING)};i.prototype.markRevertFinished=function(e){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(o.Operations.REVERT,e);this.setApplyState(o.ApplyState.REVERT_FINISHED)};i.prototype.hasApplyProcessStarted=function(){return this.getApplyState()===o.ApplyState.APPLYING};i.prototype.isSuccessfullyApplied=function(){return this.getApplyState()===o.ApplyState.APPLY_SUCCESSFUL};i.prototype.hasApplyProcessFailed=function(){return this.getApplyState()===o.ApplyState.APPLY_FAILED};i.prototype.isApplyProcessFinished=function(){return this.isSuccessfullyApplied()||this.hasApplyProcessFailed()};i.prototype.hasRevertProcessStarted=function(){return this.getApplyState()===o.ApplyState.REVERTING};i.prototype.isRevertProcessFinished=function(){return this.getApplyState()===o.ApplyState.REVERT_FINISHED};i.prototype.isCurrentProcessFinished=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()!==o.ApplyState.INITIAL};i.prototype.addChangeProcessingPromise=function(e){if(!this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e]={};this._oChangeProcessingPromises[e].promise=new Promise(function(t){this._oChangeProcessingPromises[e].resolveFunction={resolve:t}}.bind(this))}return this._oChangeProcessingPromises[e].promise};i.prototype.addChangeProcessingPromises=function(){var e=[];if(this.getApplyState()===o.ApplyState.INITIAL&&this._oChangeProcessedPromise){e.push(this._oChangeProcessedPromise.promise)}this._aQueuedProcesses.forEach(function(t){e.push(this.addChangeProcessingPromise(t))},this);return e};i.prototype.addPromiseForApplyProcessing=function(){return this.addChangeProcessingPromise(o.Operations.APPLY)};i.prototype._resolveChangeProcessingPromiseWithError=function(e,t){if(this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e].resolveFunction.resolve(t);delete this._oChangeProcessingPromises[e]}if(this._oChangeProcessedPromise){this._oChangeProcessedPromise.resolveFunction.resolve(t);this._oChangeProcessedPromise=null}};i.prototype.hasRevertData=function(){return this.getRevertData()!==null};i.prototype.resetRevertData=function(){this.setRevertData(null)};i.prototype.setDependentSelectors=function(e){this.setProperty("dependentSelectors",e);delete this._aDependentSelectorList};i.prototype.addDependentControl=function(t,s,r,o){if(!t){throw new Error("Parameter vControl is mandatory")}if(!s){throw new Error("Parameter sAlias is mandatory")}if(!r||e(r)){throw new Error("Parameter mPropertyBag is mandatory")}var n={...this.getDependentSelectors()};if(n[s]){throw new Error(`Alias '${s}' already exists in the change.`)}var i=r.modifier;var a=r.appComponent;if(Array.isArray(t)){var p=[];t.forEach(function(e){p.push(i.getSelector(e,a,o))});n[s]=p}else{n[s]=i.getSelector(t,a,o)}this.setDependentSelectors(n);delete this._aDependentSelectorList};i.prototype.getDependentControl=function(e,t){var s=[];if(!e){throw new Error("Parameter sAlias is mandatory")}if(!t){throw new Error("Parameter mPropertyBag is mandatory")}var r=t.modifier;var o=t.appComponent;var n=this.getDependentSelectors()[e];if(Array.isArray(n)){n.forEach(function(e){s.push(r.bySelector(e,o,t.view))});return s}return r.bySelector(n,o,t.view)};i.prototype.getDependentSelectorList=function(){var e=[this.getSelector()];if(!this._aDependentSelectorList){if(!this.getOriginalSelector()){Object.entries(this.getDependentSelectors()).some(function(t){var s=t[1];if(!Array.isArray(s)){s=[s]}s.forEach(function(t){if(t&&n.indexOfObject(e,t)===-1){e.push(t)}})})}this._aDependentSelectorList=e}return this._aDependentSelectorList};i.prototype.getDependentControlSelectorList=function(){var e=this.getDependentSelectorList().concat();if(e.length>0){var t=this.getSelector();var s=n.indexOfObject(e,t);if(s>-1){e.splice(s,1)}}return e};i.prototype.getOriginalSelector=function(){return this.getDependentSelectors().originalSelector};i.prototype.setExtensionPointInfo=function(e){this._oExtensionPointInfo=e};i.prototype.getExtensionPointInfo=function(){if(t(this._oExtensionPointInfo)){return{...this._oExtensionPointInfo}}return this._oExtensionPointInfo};i.prototype.getIdForCondensing=function(e,t){return e!==undefined?e.affectedControl:s.getControlIdBySelector(this.getSelector(),t)};i.prototype.canBeCondensed=function(){return this.isSuccessfullyApplied()};i.prototype.canBeVisualized=function(){return this.getSelector()&&!e(this.getSelector())};return i});
//# sourceMappingURL=UIChange.js.map