/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/Utils"],function(e,t,n,a,r,o){"use strict";var i="$FlexVariants";function l(e){var t=e.getModel(i);if(t){return Promise.resolve(t)}return new Promise(function(n){function a(){t=e.getModel(i);if(t){e.detachModelContextChange(a);n(t)}}e.attachModelContextChange(a)})}var c={getVariantModelName(){return i},getVariantModel(e){return l(e)},clearVariantParameterInURL(t){var n;var r=o.getAppComponentForControl(t.control);var l=r&&r.getModel(i);if(!l){e.error("Variant model could not be found on the provided control");return}if(t.control.isA("sap.ui.fl.variants.VariantManagement")){var c=l.getLocalId(t.control.getId(),r);var d=a.removeURLParameterForVariantManagement({model:l,vmReference:c});n=d.parameters}a.update({parameters:n||[],updateURL:true,updateHashEntry:!!l,model:l||{},silent:!l})},async activateVariant(a){function l(t){e.error(t);return Promise.reject(t)}let c;if(typeof a.element==="string"){c=t.getComponentById(a.element);if(!(c instanceof t)){c=n.getElementById(a.element);if(!(c instanceof n)){return l(Error("No valid component or control found for the provided ID"))}}}else if(a.element instanceof t||a.element instanceof n){c=a.element}const d=o.getAppComponentForControl(c);if(!d){return l(Error("A valid variant management control or component (instance or ID) should be passed as parameter"))}const s=d.getModel(i);if(!s){return l(Error("No variant management model found for the passed control or application component"))}if(a.standardVariant&&!c.isA("sap.ui.fl.variants.VariantManagement")){return l(Error("With using standardVariant and no variantReference, a variant management control must be passed as element"))}const m=a.standardVariant?s.getVariantManagementReferenceForControl(a.element):a.variantReference;if(!s.getVariantManagementReference(m).variantManagementReference){try{await r.loadVariant({reference:s.sFlexReference,variantReference:m})}catch(e){return l(Error(`Variant with reference '${m}' could not be found`))}}const p=s.getVariantManagementReference(m).variantManagementReference;if(!p){return l(Error("A valid control or component, and a valid variant/ID combination are required"))}await s.waitForVMControlInit(p);try{return s.updateCurrentVariant({variantManagementReference:p,newVariantReference:m,appComponent:d})}catch(t){e.error(t);throw t}},attachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var a=o.getAppComponentForControl(t);l(a).then(function(n){n.attachVariantApplied({vmControlId:e.vmControlId,control:t,callback:e.callback,callAfterInitialVariant:e.callAfterInitialVariant})})},detachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var a=o.getAppComponentForControl(t);l(a).then(function(n){n.detachVariantApplied(e.vmControlId,t.getId())})}};return c});
//# sourceMappingURL=ControlVariantApplyAPI.js.map