/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";const o={};o.SOURCE_ALIAS="source";o.TARGET_ALIAS="target";o.MOVED_ELEMENTS_ALIAS="movedElements";function r(e,t,o,r){if(!e){throw new Error("No change instance")}const n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!n.source||!n.source.selector){throw new Error("No source supplied for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.source.selector,r,o)){throw new Error("Move source parent not found")}if(!t.bySelector(n.target.selector,r,o)){throw new Error("Move target parent not found")}if(!n.source.selector.aggregation){throw new Error("No source aggregation supplied for move")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function n(e,t,o,r){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}const n=await t.bySelector(e.selector||e.id,o,r);if(!n){throw new Error(`Control to move was not found. Id: '${e.selector.id}'`)}return n}function a(e){if(!e.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required")}if(e.movedElements.length===0){throw new Error("MovedElements array is empty")}e.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute")}if(typeof e.sourceIndex!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number")}if(typeof e.targetIndex!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number")}})}async function s(e,t,o){delete t.source.publicAggregation;delete t.target.publicAggregation;const r=t.source.parent||await e.bySelector(t.source.id,o);const n=t.target.parent||await e.bySelector(t.target.id,o);const a=t.source.aggregation;const s=t.target.aggregation;const g={aggregation:t.source.aggregation,type:e.getControlType(r)};const c={aggregation:t.target.aggregation,type:e.getControlType(n)};const i={source:{id:r.getId(),aggregation:a,type:g.type,selector:e.getSelector(t.source.id,o,g)},target:{id:n.getId(),aggregation:s,type:c.type,selector:e.getSelector(t.target.id,o,c)},movedElements:t.movedElements};return i}o.applyChange=async function(e,t,o){const a=o.modifier;const s=o.view;const g=o.appComponent;const c=e.getContent();const i=[];let l=false;r(e,a,s,g);for(const e of c.movedElements){const t=await n(e,a,g,s);let r=a.getParent(t);let d=o.sourceAggregation||await a.getParentAggregationName(t,r);const u=await a.bySelector(c.target.selector,g,s);const m=o.targetAggregation||c.target.selector.aggregation;let f=await a.findIndexInParentAggregation(t);const E=e.targetIndex;if(f>-1){if(f===E&&d===m&&a.getParent(t)===u){f=e.sourceIndex;d=o.sourceAggregation||c.source.selector.aggregation;l=true;r=await a.bySelector(c.source.selector,g,s)||r}}if(f>-1){i.unshift({index:f,aggregation:d,sourceParent:a.getSelector(r,g)})}if(!l){await a.moveAggregation(r,d,u,m,t,E,s)}}e.setRevertData(i)};o.revertChange=async function(e,t,o){const a=o.modifier;const s=o.view;const g=o.appComponent;const c=e.getContent();r(e,a,s,g);let i=await a.bySelector(c.source.selector,g,s);const l=await a.bySelector(c.target.selector,g,s);let d=c.source.selector.aggregation;const u=c.target.selector.aggregation;const m=e.getRevertData();c.movedElements.reverse();let f=0;for(const e of c.movedElements){const t=await n(e,a,g,s);if(!t){throw new Error("Element to move not found")}let o=e.sourceIndex;if(m){const e=m[f];d=e.aggregation;o=e.index;i=await a.bySelector(e.sourceParent,g,s)||i}await a.moveAggregation(l,u,i,d,t,o,s);f++}e.resetRevertData()};o.completeChangeContent=async function(e,t,r){const n=r.modifier;const g=r.appComponent;const c=t.content||t;a(c);const i=await s(n,c,g);const l={movedElements:[],source:{selector:i.source.selector},target:{selector:i.target.selector}};for(const t of i.movedElements){const a=t.element||await n.bySelector(t.id,g);l.movedElements.push({selector:n.getSelector(a,g),sourceIndex:t.sourceIndex,targetIndex:t.targetIndex});e.addDependentControl(i.source.id,o.SOURCE_ALIAS,r);e.addDependentControl(i.target.id,o.TARGET_ALIAS,r);e.addDependentControl(i.movedElements.map(function(e){return e.id}),o.MOVED_ELEMENTS_ALIAS,r)}e.setContent(l)};o.getCondenserInfo=function(e){const o=e.getContent();const r=e.getRevertData()[0];return{affectedControl:o.movedElements[0].selector,classification:t.Move,sourceContainer:r.sourceParent,targetContainer:o.target.selector,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:o.target.selector.aggregation,setTargetIndex(e,t){const o=e.getContent();o.movedElements[0].targetIndex=t;e.setContent(o)},getTargetIndex(e){return e.getContent().movedElements[0].targetIndex},setIndexInRevertData(e,t){const o=e.getRevertData();o[0].index=t;e.setRevertData(o)}}};o.getChangeVisualizationInfo=function(e){const t=e.getContent();const o=e.getRevertData()[0];return{affectedControls:[t.movedElements[0].selector],dependentControls:[t.source.selector],descriptionPayload:{sourceContainer:o.sourceParent,targetContainer:t.target.selector}}};return o});
//# sourceMappingURL=MoveControls.js.map