//@ui5-bundle sap/ui/fl/library-preload-apply.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil", ["sap/ui/thirdparty/URI"],function(r){"use strict";var e={formatBundleName(e,t){if(t.startsWith("/")){throw Error("Absolute paths are not supported")}var a=new r(`${e}/${t}`).normalize().path();return a.replace(/\//g,".").replace("..",".").replace(/.properties$/g,"")}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Registration", ["sap/ui/fl/requireAsync"],function(e){"use strict";var a={appdescr_ui5_addLibraries:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary"),appdescr_app_setTitle:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle"),appdescr_app_setDescription:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/SetDescription"),appdescr_ovp_changeCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard"),appdescr_ovp_addNewCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard"),appdescr_ovp_removeCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard"),appdescr_ui_generic_app_addNewObjectPage:e.bind(this,"sap/suite/ui/generic/template/manifestMerger/AddNewObjectPage"),appdescr_ui_generic_app_changePageConfiguration:e.bind(this,"sap/suite/ui/generic/template/manifestMerger/ChangePageConfiguration"),appdescr_fe_changePageConfiguration:e.bind(this,"sap/fe/core/manifestMerger/ChangePageConfiguration"),appdescr_fe_addNewPage:e.bind(this,"sap/fe/core/manifestMerger/AddNewPage")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild", ["sap/ui/fl/requireAsync","sap/ui/fl/apply/_internal/changes/descriptor/Registration"],function(a,p){"use strict";const e={appdescr_app_changeDataSource:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource"),appdescr_ui5_addNewModelEnhanceWith:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith"),appdescr_ui5_addComponentUsages:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages"),appdescr_ui5_changeModel:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/ChangeModel"),appdescr_ui5_setMinUI5Version:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version"),appdescr_fiori_setRegistrationIds:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds"),appdescr_ui5_setFlexExtensionPointEnabled:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled"),appdescr_ui5_addNewModel:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel"),appdescr_app_addAnnotationsToOData:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData"),appdescr_app_removeAllInboundsExceptOne:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne"),appdescr_app_changeInbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound"),appdescr_app_changeOutbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeOutbound"),appdescr_app_addNewInbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound"),appdescr_app_addNewOutbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewOutbound"),appdescr_app_addNewDataSource:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewDataSource"),appdescr_app_setAch:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/SetAch"),appdescr_app_addTechnicalAttributes:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddTechnicalAttributes"),appdescr_fiori_setAbstract:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract"),appdescr_fiori_setCloudDevAdaptationStatus:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetCloudDevAdaptationStatus")};return{...p,...e}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData", ["sap/ui/fl/util/DescriptorChangeCheck"],function(t){"use strict";var n=["BEGINNING","END"];function e(t,n){return Object.keys(t).indexOf(n)>=0}function a(t,n){return!t[n].type||t[n].type==="OData"}function o(t,n,e){return t[e]&&t[e].type==="ODataAnnotation"||n[e]}function r(t,n){return t[n].type&&t[n].type==="ODataAnnotation"}function i(t,n){return t.indexOf(n)>=0}function s(t,n){if(n){if(Object.keys(t).length>0){if(!e(t,n)){throw new Error(`There is no dataSource '${n}' existing in the manifest. You can only add annotations to already existing dataSources in the manifest`)}if(!a(t,n)){throw new Error(`The dataSource '${n}' is existing in the manifest but is not type of 'OData'. The type of the dataSource in the manifest is '${t[n].type}'`)}}else{throw new Error("There are no dataSources in the manifest at all")}}else{throw new Error("Invalid change format: The mandatory 'dataSourceId' is not defined. Please define the mandatory property 'dataSourceId' and refer it to an existing OData")}}function f(t){if(t){if(t.length===0){throw new Error("Invalid change format: The 'annotations' array property is empty")}}else{throw new Error("Invalid change format: The mandatory 'annotations' array property is not defined. Please define the 'annotations' array property")}}function c(t){if(!(n.indexOf(t)>=0)&&!(t===undefined)){throw new Error(`The defined insert position '${t}' is not supported. The supported insert positions are: ${n.join("|")}`)}}function d(n,e,a){if(n){if(Object.keys(n).length===0){throw new Error("The 'dataSource' object is empty")}Object.keys(n).forEach(function(o){t.checkIdNamespaceCompliance(o,a);if(!r(n,o)){throw new Error(`The dataSource annotation '${o}' is type of '${n[o].type}'. Only dataSource annotations of type 'ODataAnnotation' is supported`)}if(!i(e,o)){throw new Error(`The annotation '${o}' is not part of 'annotations' array property. Please add the annotation '${o}' in the 'annotations' array property`)}})}else{throw new Error("Invalid change format: The mandatory 'dataSource' object is not defined. Please define the mandatory 'dataSource' object")}}function p(t,n,e,a,o){h(t[n],e,a);u(t,o)}function h(t,n,e){t.settings||={};t.settings.annotations||=[];var a=t.settings.annotations.filter(function(t){return n.indexOf(t)<0});t.settings.annotations=a;if(e==="END"){t.settings.annotations=t.settings.annotations.concat(n)}else{t.settings.annotations=n.concat(t.settings.annotations)}}function u(t,n){Object.assign(t,n)}function y(t,n,e){e.forEach(function(e){if(!o(t,n,e)){throw new Error(`The annotation '${e}' is part of 'annotations' array property but does not exists in the change property 'dataSource' and in the manifest (or it is not type of 'ODataAnnotation' in the manifest)`)}})}var g={applyChange(t,n){var e=n.getContent().dataSourceId;var a=n.getContent().annotations;var o=n.getContent().annotationsInsertPosition;var r=n.getContent().dataSource;s(t["sap.app"].dataSources,e);f(a);c(o);d(r,a,n);y(t["sap.app"].dataSources,r,a);p(t["sap.app"].dataSources,e,a,o,r);return t}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewDataSource", ["sap/ui/fl/util/DescriptorChangeCheck"],function(t){"use strict";const n=["uri"];const a=[...n,"type","settings","customType"];const o={type:"^(OData|ODataAnnotation|INA|XML|JSON|FHIR|WebSocket|http)$",customType:"^false$"};const e={uri:typeof"string",type:typeof"string",settings:typeof{},dataSourceCustom:typeof false,annotations:typeof[]};function s(t,n){return Object.keys(t).includes(n)}function i(t){return t.type||"OData"}function r(t,n){const[a]=Object.entries(t).find(([,t])=>i(t)===n)||[];return a}function c(t,n,a){a.forEach(function(a){if(!s(t,a)){throw new Error(`Referenced annotation '${a}' in the annotation array of data source '${n}' does not exist in the manifest.`)}})}function u(t,n){const a=r(n,"OData");const o=r(n,"ODataAnnotation");if(!(a&&o)){throw new Error("When adding two data sources it is only allwoed to add a data source with type 'OData' and the other one must be of type 'ODataAnnotation'.")}if(!n[a]?.settings?.annotations?.includes(o)){throw new Error(`Data source '${a}' does not include annotation '${o}' under 'settings/annotations' array.`)}const e=n[a].settings.annotations.filter(function(t){return t!==o});c(t,a,e)}function f(t,n){const a=r(n,"OData");if(n[a].settings?.annotations){c(t,a,n[a].settings.annotations)}}function p(t,n,a){a.forEach(function(a){if(s(t,a)){throw new Error(`There is already a dataSource '${a}' existing in the manifest.`)}d(n,a)});if(a.length===1){f(t,n)}if(a.length===2){u(t,n)}}function d(t,n){const a=i(t[n]);if(t[n].settings?.annotations){if(a!=="OData"){throw new Error(`Data source '${n}' which is of type '${a}' contains the annotations array. Only data sources with type 'OData' could contain the 'settings/annotations' array.`)}if(!Array.isArray(t[n].settings.annotations)){throw new Error("Property 'annotations' must be of type 'array'.")}}}const h={applyChange(s,i){s["sap.app"].dataSources||={};const r=i.getContent();const c=t.getAndCheckContentObject(r,"dataSource",i.getChangeType(),n,a,o,e);c.forEach(function(n){t.checkIdNamespaceCompliance(n,i)});p(s["sap.app"].dataSources,r.dataSource,c);Object.assign(s["sap.app"].dataSources,r.dataSource);return s}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound", ["sap/ui/fl/util/DescriptorChangeCheck"],function(n){"use strict";const t=["semanticObject","action"];const e=[...t,"hideLauncher","icon","title","shortTitle","subTitle","info","indicatorDataSource","deviceTypes","displayMode","signature"];const i={semanticObject:"^[\\w\\*]{0,30}$",action:"^[\\w\\*]{0,60}$"};const a={applyChange(a,s){a["sap.app"].crossNavigation||={};a["sap.app"].crossNavigation.inbounds||={};const o=s.getContent();const c=n.getAndCheckContentObject(o,"inbound",s.getChangeType(),t,e,i);const p=a["sap.app"].crossNavigation.inbounds[c];if(!p){n.checkIdNamespaceCompliance(c,s);a["sap.app"].crossNavigation.inbounds[c]=o.inbound[c]}else{throw new Error(`Inbound with ID "${c}" already exist.`)}return a}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewOutbound", ["sap/ui/fl/util/DescriptorChangeCheck"],function(t){"use strict";const a=["semanticObject","action"];const o=[...a,"additionalParameters","parameters"];const e={semanticObject:"^[\\w\\*]{0,30}$",action:"^[\\w\\*]{0,60}$",additionalParameters:"^(ignored|allowed|notallowed)$"};const n={applyChange(n,s){n["sap.app"].crossNavigation||={};n["sap.app"].crossNavigation.outbounds||={};const i=s.getContent();const c=t.getAndCheckContentObject(i,"outbound",s.getChangeType(),a,o,e);const r=n["sap.app"].crossNavigation.outbounds[c];if(!r){t.checkIdNamespaceCompliance(c,s);n["sap.app"].crossNavigation.outbounds[c]=i.outbound[c]}else{throw new Error(`Outbound with ID "${c}" already exist.`)}return n}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddTechnicalAttributes", [],function(){"use strict";const t=new RegExp("^[A-Z0-9_\\-\\/]+$");const e={applyChange(e,r){e["sap.app"]||={};e["sap.app"].tags||={};const n=e["sap.app"].tags;n.technicalAttributes||=[];const s=n.technicalAttributes;const a=r.getContent().technicalAttributes;if(!r.getContent().hasOwnProperty("technicalAttributes")){throw new Error("Property 'technicalAttributes' in change content is not provided")}if(!Array.isArray(a)){throw new Error(`The property 'technicalAttributes' has type '${typeof a}'. Only allowed types for property 'technicalAttributes' is 'array'`)}if(!a.every(t=>typeof t==="string")){throw new Error("The array for the property 'technicalAttributes' does not only consist of strings. Only allowed values for the array is string")}if(!a.every(e=>t.test(e))){throw new Error(`The array contains disallowed values. Supported values for 'technicalAttributes' should adhere to the regular expression ${t}`)}n.technicalAttributes=Array.from(new Set(s.concat(a)));return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(e,a){"use strict";var t=["UPDATE","UPSERT"];var r=["uri","settings/maxAge"];var n={};var o={applyChange(o,i){var u=o["sap.app"].dataSources;var s=i.getContent();a.checkEntityPropertyChange(s,r,t,n);if(u){var p=u[s.dataSourceId];if(p){e(s.entityPropertyChange,p)}else{throw new Error(`Nothing to update. DataSource with ID "${s.dataSourceId}" does not exist.`)}}else{throw Error("No sap.app/dataSource found in manifest.json")}return o}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(n,t){"use strict";const e=["UPDATE","UPSERT","DELETE","INSERT"];const o=["semanticObject","action","hideLauncher","icon","title","shortTitle","subTitle","info","indicatorDataSource","deviceTypes","displayMode","signature/parameters/*"];const i=["semanticObject","action"];const s={semanticObject:"^[\\w\\*]{0,30}$",action:"^[\\w\\*]{0,60}$"};const a={applyChange(a,c){const r=a["sap.app"].crossNavigation;const p=c.getContent();t.checkEntityPropertyChange(p,o,e,s,i);if(r&&r.inbounds){const t=r.inbounds[p.inboundId];if(t){n(p.entityPropertyChange,t)}else{throw new Error(`Nothing to update. Inbound with ID "${p.inboundId}" does not exist.`)}}else{throw new Error("sap.app/crossNavigation or sap.app/crossNavigation/inbounds sections have not been found in manifest.json")}return a}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeOutbound", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(t,o){"use strict";const n=["UPDATE","UPSERT","DELETE","INSERT"];const e=["semanticObject","action","additionalParameters","parameters/*"];const a=["semanticObject","action"];const s={semanticObject:"^[\\w\\*]{0,30}$",action:"^[\\w\\*]{0,60}$",additionalParameters:"^(ignored|allowed|notallowed)$"};const i={applyChange(i,r){const c=i["sap.app"].crossNavigation;const u=r.getContent();o.checkEntityPropertyChange(u,e,n,s,a);if(c&&c.outbounds){const o=c.outbounds[u.outboundId];if(o){t(u.entityPropertyChange,o)}else{throw new Error(`Nothing to update. outbound with ID "${u.outboundId}" does not exist.`)}}else{throw new Error("sap.app/crossNavigation or sap.app/crossNavigation/outbounds sections have not been found in manifest.json")}return i}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne", [],function(){"use strict";function n(n){if(!n["sap.app"].hasOwnProperty("crossNavigation")){throw new Error("No sap.app/crossNavigation path exists in the manifest")}if(!n["sap.app"].crossNavigation.hasOwnProperty("inbounds")){throw new Error("No sap.app/crossNavigation/inbounds path exists in the manifest")}}function o(n){var o=n.inboundId;if(o===""){throw new Error("The ID of your inbound is empty")}if(typeof o!=="string"){throw new Error("The type of your inbound ID must be string")}return o}function i(n,o){var i={};i[o]=n["sap.app"].crossNavigation.inbounds[o];n["sap.app"].crossNavigation.inbounds=i}var s={applyChange(s,r){n(s);var a=o(r.getContent());if(s["sap.app"].crossNavigation.inbounds[a]){i(s,a)}else{throw new Error(`No inbound exists with the ID "${a}" in sap.app/crossNavigation/inbounds`)}return s}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/SetAch", ["sap/base/util/ObjectPath"],function(e){"use strict";const t=new RegExp("^([a-zA-Z0-9]{2,3})(-[a-zA-Z0-9]{1,6})*$");const r={applyChange(r,n){if(!n.getContent().hasOwnProperty("ach")){throw new Error("No 'Application Component Hierarchy' (ACH) in change content provided")}if(typeof n.getContent().ach!=="string"){throw new Error(`The current change value type of property ach is '${typeof n.getContent().ach}'. Only allowed type for poperty ach is string`)}if(!t.test(n.getContent().ach)){throw new Error(`The current change value of property ach is '${n.getContent().ach}'. Supported values for property ach is the regular expression ${t}`)}e.set(["sap.app","ach"],n.getContent().ach,r);return r}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/SetDescription", [],function(){"use strict";const p={applyChange(p){p["sap.app"].description=`{{${p["sap.app"].id}_sap.app.description}}`;return p}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";var n={applyChange(e){e["sap.app"].title=`{{${e["sap.app"].id}_sap.app.title}}`;return e},getCondenserInfo(){return{classification:e.LastOneWins,uniqueKey:"manifestSetTitle"}}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract", ["sap/base/util/ObjectPath"],function(t){"use strict";var e={applyChange(e,a){if(!a.getContent().hasOwnProperty("abstract")){throw new Error("No abstract in change content provided")}if(a.getContent().abstract!==false){throw new Error(`The current change value of property abstract is '${a.getContent().abstract}'. Only allowed value for property abstract is boolean 'false'`)}t.set(["sap.fiori","abstract"],a.getContent().abstract,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetCloudDevAdaptationStatus", ["sap/base/util/ObjectPath"],function(t){"use strict";const e=["released","deprecated","obsolete"];var o={applyChange(o,a){if(!a.getContent().hasOwnProperty("cloudDevAdaptationStatus")){throw new Error("No cloudDevAdaptationStatus in change content provided")}if(typeof a.getContent().cloudDevAdaptationStatus!=="string"){throw new Error(`The current change value type of property cloudDevAdaptationStatus is '${typeof a.getContent().cloudDevAdaptationStatus}'. Only allowed type for poperty cloudDevAdaptationStatus is string`)}if(!e.includes(a.getContent().cloudDevAdaptationStatus)){throw new Error(`The current change value of property cloudDevAdaptationStatus is '${a.getContent().cloudDevAdaptationStatus}'. Supported values for property cloudDevAdaptationStatus are ${e.join("|")}`)}t.set(["sap.fiori","cloudDevAdaptationStatus"],a.getContent().cloudDevAdaptationStatus,o);return o}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds", ["sap/base/util/ObjectPath"],function(t){"use strict";var e={applyChange(e,i){t.set(["sap.fiori","registrationIds"],i.getContent().registrationIds,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard", [],function(){"use strict";var r={applyChange(r,e){var a=e.getContent();var n=r["sap.ovp"].cards;if("card"in a&&Object.keys(a.card).length>0&&!(Object.keys(a.card)in n)){Object.assign(n,a.card)}else{throw Error("No new card found")}return r}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard", ["sap/base/util/ObjectPath"],function(r){"use strict";var t={applyChange(t,e){var a=e.getContent();var o=a.entityPropertyChange.operation==="UPSERT";var n=t["sap.ovp"].cards;var p=a.entityPropertyChange;if(Array.isArray(p)){throw Error("Expected value for oPropertyChange was an object")}if(!o){throw Error("This Operation is not supported")}if(a.cardId in n&&"propertyPath"in p){r.set([a.cardId,p.propertyPath],p.propertyValue,n)}else{throw Error("Change card settings was not found")}return t}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard", [],function(){"use strict";var e={applyChange(e,r){var t=r.getContent();var a=e["sap.ovp"].cards;if(t.cardId in a){delete a[t.cardId]}else{throw Error("The card to be deleted was not found")}return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages", [],function(){"use strict";var e={applyChange(e,n){var s=n.getContent().componentUsages;e["sap.ui5"].componentUsages||={};var t=e["sap.ui5"].componentUsages;Object.keys(s).forEach(function(e){if(t[e]){throw new Error(`Component usage '${e}' already exists`)}else{t[e]=s[e]}});return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary", ["sap/base/util/Version"],function(e){"use strict";function i(i,n){var r={};if(n.minVersion){var s=new e(i.minVersion);r.minVersion=s.compareTo(n.minVersion)>=0?i.minVersion:n.minVersion}if(n.lazy){r.lazy=i.lazy===n.lazy===true}return r}var n={applyChange(e,n){e["sap.ui5"].dependencies.libs||={};var r=e["sap.ui5"].dependencies.libs;var s=n.getContent().libraries;Object.keys(s).forEach(function(e){if(r[e]){r[e]=i(r[e],s[e])}else{r[e]=s[e]}});return e}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel", [],function(){"use strict";var e=["OData","INA","XML","JSON","FHIR","http","WebSocket"];var t=e.concat(["ODataAnnotation"]);function n(e,t,n){return!e[t].type||n.indexOf(e[t].type)>=0}function r(e,t){return s(e).some(function(e){return(!e.type||e.type==="OData")&&e.settings.annotations.indexOf(t)>=0})}function o(t,n,r){return a(n,r,e)||i(t,r)}function a(e,t,r){return u(e,t)&&n(e,t,r)}function i(e,t){if(u(e,t)){if(e[t].type&&e[t].type==="ODataAnnotation"){throw new Error(`The already existing dataSource '${t}' in the manifest is type of 'ODataAnnotation'. A model must not reference to a dataSource which is of type 'ODataAnnotation'`)}return true}return false}function u(e,t){return e&&Object.keys(e).indexOf(t)>=0}function c(e,t,n){if(t){Object.keys(t).forEach(function(r){if(e[r]){throw new Error(`The ${n} '${r}' already exists`)}e[r]=t[r]})}}function d(e,t,n,r,o){e[n][r]||={};c(e[n][r],t.getContent()[o],o);return e[n][r]}function f(e,t,n){if(e[n].type==="ODataAnnotation"){return true}return s(t).some(function(e){return e.dataSource&&e.dataSource===n})}function h(e,t){return e[t].type||e[t].dataSource}function s(e){return Object.keys(e).map(function(t){return e[t]})}var y={applyChange(a,i){var u=i.getContent().model;var c=i.getContent().dataSource;if(u){if(Object.keys(u).length!==1){throw new Error(`There are currently '${Object.keys(u).length}' models in the change. Currently it is only allowed to add '1' model`)}Object.keys(u).forEach(function(t){if(!h(u,t)){throw new Error(`There is no 'dataSource' or 'type' in the change model defined. Please define either 'type' or 'dataSource' in property '${t}'`)}if(u[t].dataSource){if(!o(a["sap.app"].dataSources,c,u[t].dataSource)){throw new Error(`The defined dataSource '${u[t].dataSource}' in the model does not exists as dataSource or must be allowed type of ${e.join("|")}`)}}})}else{throw new Error("No model defined")}if(c){Object.keys(c).forEach(function(e){if(!n(c,e,t)){throw new Error(`The dataSource '${e}' has the type '${c[e].type}', but only dataSources with the follwing types are supported: ${t.join("|")}`)}if(!f(c,u,e)){throw new Error(`The dataSource in the change '${e}' is not used by any model in the change. A dataSource in the change must be used by model in the change`)}if(c[e].type==="ODataAnnotation"){if(!r(c,e)){throw new Error(`There is no dataSource with type 'OData' defined which includes the annotation '${e}'`)}}})}d(a,i,"sap.ui5","models","model");d(a,i,"sap.app","dataSources","dataSource");return a}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith", ["sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil","sap/base/util/ObjectPath"],function(e,t){"use strict";function n(e){const t="A schema violation has been identified. Either bundleName or bundleUrl property must be used.";if(e.bundleUrl){if(e.bundleName){throw Error(t)}return true}return false}function s(t,s){const i=Object.keys(t.terminologies||{});if(i.length>0){i.forEach(i=>{const l=t.terminologies[i];if(n(l)){l.bundleName=e.formatBundleName(s,l.bundleUrl);delete l.bundleUrl}})}}const i={applyChange(i,l){const r=l.getContent();const o=r.modelId;const u=i["sap.ui5"].models[o];if(u){if(u.type&&u.type==="sap.ui.model.resource.ResourceModel"){if(!(u.settings&&u.settings.enhanceWith)){t.set("settings.enhanceWith",[],u)}const o=i["sap.app"].id;const a=l.getTexts()?.i18n;const d=u.settings.enhanceWith;if(a){d.push({bundleName:e.formatBundleName(o,a)});return i}if(n(r)){r.bundleName=e.formatBundleName(o,r.bundleUrl);delete r.bundleUrl}s(r,o);delete r.modelId;if(Object.keys(r).length>0){d.push(r)}}}return i},skipPostprocessing:true};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/ChangeModel", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(e,t){"use strict";const o=["UPDATE","UPSERT","DELETE","INSERT"];const n=["settings/*"];const s={settings:typeof{}};const r="sap.ui.model.resource.ResourceModel";const i={applyChange(i,l){const a=i["sap.ui5"].models;const u=l.getContent();t.checkEntityPropertyChange(u,n,o,null,null,s);if(a){const t=a[u.modelId];if(t){if(t.type===r){throw new Error(`Model '${u.modelId}' is of type '${r}'. Changing models of type '${r}' are not supported.`)}e(u.entityPropertyChange,t)}else{throw new Error(`Nothing to update. Model with ID "${u.modelId}" does not exist in the manifest.json.`)}}else{throw new Error("sap.ui5/models section have not been found in manifest.json.")}return i}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled", ["sap/base/util/ObjectPath"],function(n){"use strict";var e={applyChange(e,t){if(!t.getContent().flexExtensionPointEnabled){throw new Error("No flexExtensionPointEnabled in change content provided")}n.set(["sap.ui5","flexExtensionPointEnabled"],t.getContent().flexExtensionPointEnabled,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version", ["sap/base/util/Version"],function(n){"use strict";var e={applyChange(e,r){var i=r.getContent().minUI5Version;if(!i){throw new Error("No minUI5Version in change content provided")}if(typeof i==="string"){i=[i]}const o={};i.forEach(function(e){const r=new n(e);if(o[r.getMajor()]){throw new Error("Each major version can only be provided once in minUI5Version of change content")}o[r.getMajor()]=[e,r]});var{minUI5Version:t}=e["sap.ui5"].dependencies;if(!t){throw new Error("sap.ui5/dependencies/minUI5Version missing in base manifest")}if(typeof t==="string"){t=[t]}t=t.map(function(e){const r=new n(e);const i=o[r.getMajor()];if(!i){return null}const[t,s]=i;return r.compareTo(s)<=0?t:e}).filter(n=>n);if(t.length===0){throw new Error("Upgrade/Downgrade for different major version not possible")}e["sap.ui5"].dependencies.minUI5Version=t.length===1?t[0]:t;return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector", ["sap/base/util/merge","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/interfaces/BaseLoadConnector"],function(e,t,n,r){"use strict";function a(e){var n=[];return t.forEachObjectInStorage(e,function(e){n.push(e.changeDefinition)}).then(function(){return n})}var o=e({},r,{oStorage:undefined,layers:["ALL"],loadFlexData(e){return a({storage:this.oStorage,reference:e.reference}).then(function(e){var t=n.getGroupedFlexObjects(e);return n.filterAndSortResponses(t)})}});o.storage=o.oStorage;return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils", [],function(){"use strict";var e="sap.ui.fl";return{forEachObjectInStorage(r,t){var n=r.storage.getItems&&r.storage.getItems()||r.storage;return Promise.resolve(n).then(function(n){var a=Object.keys(n).map(function(a){var i=a.includes(e);if(!i){return}var s=n[a];var c=r.storage._itemsStoredAsObjects?s:JSON.parse(s);var o=true;if(r.reference){o=this.isSameReference(c,r.reference)}var u=true;if(r.layer){u=c.layer===r.layer}if(!o||!u){return}return t({changeDefinition:c,key:a})}.bind(this));return Promise.all(a)}.bind(this))},getAllFlexObjects(e){var r=[];return this.forEachObjectInStorage(e,function(e){r.push(e)}).then(function(){return r})},createFlexKey(r){if(r){return`${e}.${r}`}},createFlexObjectKey(e){return this.createFlexKey(e.fileName)},isSameReference(e,r){var t=r.endsWith(".Component")?r.replace(/\.Component$/,""):`${r}.Component`;return e.reference===r||e.reference===t}}});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/apply/_internal/extensionPoint/Processor", ["sap/base/util/merge","sap/ui/base/DesignTime","sap/ui/base/SyncPromise","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/extensionPoint/Registry","sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/Utils"],function(e,n,t,i,r,o,a,s,u){"use strict";var f;function l(e,n,t,i,r){return r(e,true).then(function(r){r.forEach(function(e,r){n.splice(t+r+i,0,e)});e.index+=i;return r.length-1})}function g(e,n,i){var r=[];var o=[];var a=0;var s;i.forEach(function(t,i){if(t._isExtensionPoint){t.targetControl=e.targetControl;t.aggregationName=e.aggregationName;t.fragmentId=e.fragmentId;t.index=i;if(s){s._nextSibling=t}s=t;t.referencedExtensionPoint=e;r.push(function(){return l(t,o,i,a,n).then(function(e){a+=e})})}else{o.push(t)}});if(r.length>0){return r.reduce(function(e,n){return e.then(n)},t.resolve()).then(function(){return o})}return t.resolve(o)}function d(n,t){var r=u.getAppComponentForControl(n.targetControl);var o={};var l=e({defaultContent:[]},n);o.appComponent=r;o.modifier=i;o.viewId=n.view.getId();o.componentId=r.getId();o.reference=s.getFlexReferenceForControl(r);return f.registerExtensionPoint(l).then(a.enhanceExtensionPointChanges.bind(a,o,n)).then(f.createDefaultContent.bind(this,n,t,d)).then(f.addDefaultContentToExtensionPointInfo.bind(this,l,t))}f={oExtensionPointRegistry:undefined,oRegistryPromise:Promise.resolve(),registerExtensionPoint(e){if(n.isDesignModeEnabled()){o.registerExtensionPoint(e)}return t.resolve()},createDefaultContent(e,n,r,o){if(o.length===0){return e.createDefault().then(g.bind(undefined,e,r)).then(function(t){if(!n){t.forEach(function(n,t){i.insertAggregation(e.targetControl,e.aggregationName,n,e.index+t,e.view)});e.ready(t)}return t})}return t.resolve([])},addDefaultContentToExtensionPointInfo(e,n,t){if(!n){e.defaultContent=e.defaultContent.concat(t)}return t},applyExtensionPoint(e){var n=d(e,false);r.addPreConditionForInitialChangeApplying(n);return n}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState", ["sap/ui/fl/apply/_internal/flexState/FlexState"],function(e){"use strict";var t={};t.getPersonalization=function(t,n,i){var r=e.getUI2Personalization(t);if(!r||!r[n]){return i?undefined:[]}if(!i){return r[n]}return r[n].filter(function(e){return e.itemName===i})[0]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState", ["sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/Utils"],(e,t,n,a,i,o,r,s,l,c,g,p,f)=>{"use strict";const d={};function u(e,t){if(t.fragmentId){const n=e.getExtensionPointInfo&&e.getExtensionPointInfo();if(n){return t.fragmentId!==n.fragmentId}return true}return false}function C(e,n,a){let i=e.getSelector();if(n.closestAggregationBindingCarrier&&n.closestAggregationBinding){i=t(i,{id:n.closestAggregationBindingCarrier,idIsLocal:false});const o={id:n.targetControl.getId(),idIsLocal:false};if(a){e.originalSelectorToBeAdjusted=o}else{e.setDependentSelectors({originalSelector:o})}e.setContent({boundAggregation:n.closestAggregationBinding})}else{i=t(i,{id:n.targetControl.getId(),idIsLocal:false})}e.setSelector(i)}function m(e){const t=o.createUIChange(e.changeSpecificData);return p.getChangeHandler(t.getChangeType(),e.controlType,e.selector,a,t.getLayer()).then(n=>n.completeChangeContent(t,e.changeSpecificData,{modifier:a,appComponent:e.appComponent,view:f.getViewForControl(e.selector)})).then(()=>{t.setState(r.LifecycleState.NEW);return t})}function h(e){if(e.selector.name&&e.selector.view){const t=f.getAppComponentForSelector(e.selector.view);const n=e.selector.appId||g.getFlexReferenceForControl(t);e.appComponent=t;e.changeSpecificData.reference=n;e.changeSpecificData.selector={name:e.selector.name,viewSelector:a.getSelector(e.selector.view.getId(),t)};return m(e)}return undefined}d.getChangesForExtensionPoint=function(e,t){if(!t.extensionPointName){n.error("Missing name from extension point info!");return[]}const a=l.getAllApplicableUIChanges(e);return a.filter(e=>{if(e.getSelector().name!==t.extensionPointName){return false}return i.isChangeInView(t,e)})};d.enhanceExtensionPointChanges=function(t,n){t.extensionPointName=n.name;const a=g.getFlexReferenceForControl(n.targetControl);const i=d.getChangesForExtensionPoint(a,t);const o=[];i.forEach(function(i){if(i.isInInitialState()&&!(i.getExtensionPointInfo&&i.getExtensionPointInfo())){i.setExtensionPointInfo(n);C(i,n,false);if(c.isInitialized(t)){s.addChangeAndUpdateDependencies(i,t.appComponent,l.getLiveDependencyMap(a))}}else if(u(i,n)){const r=i.convertToFileContent();const c=e(r,["dependentSelector","fileName","selector","adaptationId"]);c.support.sourceChangeFileName=i.getId()||"";o.push(h({changeSpecificData:c,selector:{view:n.view,name:n.name}}).then(function(e){C(e,n,true);e.setExtensionPointInfo(n);const r=e.getFlexObjectMetadata();r.moduleName=i.getFlexObjectMetadata().moduleName;e.setFlexObjectMetadata(r);e.setCreation(i.getCreation());s.insertChange(e,l.getLiveDependencyMap(a),i);s.addChangeAndUpdateDependencies(e,t.appComponent,l.getLiveDependencyMap(a));o.push(e)}))}});return Promise.all(o).then(function(){return i})};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/AnnotationChangeHandlerAPI", ["sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration"],function(e){"use strict";const n={registerAnnotationChangeHandler(n){if(!n.changeType||!n.changeHandler){throw new Error("'changeType' and 'changeHandler' properties are required for registration!")}if(n.isDefaultChangeHandler){throw new Error("The API is not allowed to register default change handlers!")}e.registerAnnotationChangeHandler(n)},getAnnotationChangeHandler(n){if(!n.changeType){throw new Error("'changeType' property is required!")}return e.getAnnotationChangeHandler(n)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/SmartVariantManagementApplyAPI", ["sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantManagementState","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,a,n,r,i,s){"use strict";function l(e){var t=e.control;var a=t.getVariantManagement?.()||t;var r=a.getId();return n.initialize({reference:e.reference,componentData:{},manifest:s.getAppDescriptor(t),componentId:s.getAppComponentForControl(t).getId()}).then(function(){var t=n.getCompVariantsMap(e.reference);n.setInitialNonFlCompVariantData(e.reference,e.persistencyKey,e.standardVariant,e.variants,r);return t._initialize(e.persistencyKey,e.variants,r)})}var p={async loadVariants(n){n.reference=r.getFlexReferenceForControl(n.control);n.persistencyKey=a.getPersistencyKey(n.control);const i=await l(n);const s=t.merge(n.persistencyKey,i,n.standardVariant,n.control);s.defaultVariantId=e.getDefaultVariantId({persistencyKey:n.persistencyKey,reference:n.reference,variants:s.variants});return s}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/UI2PersonalizationApplyAPI", ["sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils"],function(e,t,a){"use strict";var n={async load(n){n.reference=a.getFlexReferenceForSelector(n.selector);if(!n.reference||!n.containerKey){throw new Error("not all mandatory properties were provided for the loading of the personalization")}await t.initialize({componentId:n.selector.getId()});return e.getPersonalization(n.reference,n.containerKey,n.itemName)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/transport/TransportDialog", ["sap/ui/fl/write/_internal/transport/TransportDialog"],function(r){"use strict";var a=r.extend("sap.ui.fl.transport.TransportDialog",{metadata:{library:"sap.ui.fl",deprecated:true},renderer:{apiVersion:2}});return a});
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/transport/TransportSelection", ["sap/ui/fl/write/_internal/transport/TransportSelection"],function(t){"use strict";return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/DescriptorChangeCheck", ["sap/ui/fl/Layer"],function(r){"use strict";function e(r,e,t,o,n,i){e.forEach(function(e){const p=new Set(Object.keys(r[e]));if(t){t.forEach(function(r){if(!p.has(r)){const e=t.length>1?"properties are":"property is";throw new Error(`Mandatory property '${r}' is missing. Mandatory ${e} ${t.join("|")}.`)}})}if(o){const r=[];p.forEach(function(e){if(!o.includes(e)){r.push(e)}});if(r.length>0){const e=r.length>1?`Properties ${r.join("|")} are not supported. `:`Property ${r.join("|")} is not supported. `;const t=o.length>1?`Supported properties are ${o.join("|")}.`:`Supported property is $${o.join("|")}.`;throw new Error(e+t)}}if(i){p.forEach(function(t){if(i[t]){if(String(typeof r[e][t])!==i[t]){throw new Error(`The property '${t}' is type of '${typeof r[e][t]}'. Supported type for property '${t}' is '${i[t]}'`)}}})}if(n){p.forEach(function(t){if(n[t]){const o=new RegExp(n[t]);if(!o.test(r[e][t])){throw new Error(`The property has disallowed values. Supported values for '${t}' should adhere to regular expression ${o}.`)}}})}})}function t(r,t,o,n,i,p,a){const s=Object.keys(r);if(s.length>1){throw new Error("It is not allowed to add more than one object under change object 'content'.")}if(s.length<1){throw new Error(`The change object 'content' cannot be empty. Please provide the necessary property, as outlined in the change schema for '${o}'.`)}if(s[0]!==t){throw new Error(`The provided property '${s[0]}' is not supported. Supported property for change '${o}' is '${t}'.`)}const h=Object.keys(r[t]);if(h.length>1){if(t==="dataSource"){if(h.length!==2){throw new Error("It is not allowed to add more than two data sources to manifest.")}}else{throw new Error(`It is not allowed to add more than one ${t}: ${h.join(", ")}.`)}}if(h.length<1){throw new Error(`There is no ${t} provided. Please provide an ${t}.`)}if(h.includes("")){throw new Error(`The ID of your ${t} is empty.`)}e(r[t],h,n,i,p,a);return t!=="dataSource"?h[h.length-1]:h}function o(r,e,t,o,n,i){const a=Array.isArray(r)?r:[r];a.forEach(function(r){p(r,e,t,n,i);d(r,o)})}function n(r){var e=[];var t=r.filter(function(r){return r.endsWith("/*")});t.forEach(function(r){var t=r.replaceAll("/*","");if(t){e.push(t)}});return e}function i(r,e){const t=n(r);let o=false;t.forEach(function(r){if(e.startsWith(r)){const t=e.replace(r,"");if(t.startsWith("/")||t===""){o=true}}});return o}function p(r,e,t,o,n){if(!r.propertyPath){throw new Error("Invalid change format: The mandatory 'propertyPath' is not defined. Please define the mandatory property 'propertyPath'")}if(!r.operation){throw new Error("Invalid change format: The mandatory 'operation' is not defined. Please define the mandatory property 'operation'")}const p=r.operation.toUpperCase();if(p==="DELETE"){if(o){if(o.includes(r.propertyPath)){throw new Error(`The property '${r.propertyPath}' was attempted to be deleted. The mandatory properties ${o.join("|")} cannot be deleted.`)}}if(r.hasOwnProperty("propertyValue")){throw new Error("The property 'propertyValue' must not be provided in a 'DELETE' operation. Please remove 'propertyValue'.")}}if(p!=="DELETE"){if(!r.hasOwnProperty("propertyValue")){throw new Error("Invalid change format: The mandatory 'propertyValue' is not defined. Please define the mandatory property 'propertyValue'")}if(!e.includes(r.propertyPath)&&!i(e,r.propertyPath)){throw new Error(`Changing ${r.propertyPath} is not supported. The supported 'propertyPath' is: ${e.join("|")}`)}if(n){const e=r.propertyPath.split("/");const t=e[e.length-1];if(n[t]){if(String(typeof r.propertyValue)!==n[t]){throw new Error(`The property '${t}' is type of '${typeof r.propertyValue}'. Supported type for property '${t}' is '${n[t]}'.`)}}}}if(!t.includes(p)){throw new Error(`Operation ${p} is not supported. The supported 'operation' is ${t.join("|")}`)}}function a(r,e,t,n,i,p){var a=Object.keys(r).filter(function(r){return r.endsWith("Id")}).shift();if(!r[a]){throw new Error(`Mandatory "${a}" parameter is not provided.`)}if(!r.entityPropertyChange){throw new Error(`Changes for "${r[a]}" are not provided.`)}o(r.entityPropertyChange,e,t,n,i,p)}var s={};s[r.CUSTOMER]="customer.";s[r.CUSTOMER_BASE]="customer.";s[r.PARTNER]="partner.";s[r.VENDOR]=null;function h(r,e){var t=e.getLayer();if(!t){throw new Error("Mandatory layer parameter is not provided.")}var o=f(t);if(o===null){Object.keys(s).forEach(function(e){if(s[e]&&r.startsWith(s[e])){throw new Error(`Id ${r} must not start with reserved ${s[e]}`)}})}else if(!r.startsWith(o)){throw new Error(`Id ${r} must start with ${o}`)}}function f(r){var e=s[r];if(e===undefined){throw new Error(`Layer ${r} not supported.`)}return e}function d(r,e){if(e){if(!Object.keys(e).includes(r.propertyPath)){return}if(!r.propertyValue.match(e[r.propertyPath])){throw new Error(`Not supported format for propertyPath ${r.propertyPath}. `+`The supported pattern is ${e[r.propertyPath]}`)}}}return{checkEntityPropertyChange:a,checkIdNamespaceCompliance:h,getNamespacePrefixForLayer:f,getClearedGenericPath:n,isGenericPropertyPathSupported:i,getAndCheckContentObject:t}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrame.flexibility", ["sap/ui/fl/changeHandler/UpdateIFrame"],function(e){"use strict";return{updateIFrame:e,hideControl:"default",unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/changePropertyValueByPath", ["sap/base/util/ObjectPath"],function(t){"use strict";function e(t){const e=t.replaceAll("\\/","*");const r=e.split("/");return r.map(t=>t.replaceAll("*","/"))}function r(t,e){for(let r=0;r<t.length-1;r++){e=e[t[r]]}delete e[t[t.length-1]]}function o(o,a){let n;if(o.propertyPath.includes("\\")){n=e(o.propertyPath)}else{n=o.propertyPath.split("/")}const i=t.get(n,a);if(i&&o.operation==="INSERT"){throw new Error("Path has already a value. 'INSERT' operation is not appropriate.")}if(!i&&o.operation==="UPDATE"){throw new Error("Path does not contain a value. 'UPDATE' operation is not appropriate.")}if(o.operation==="DELETE"){r(n,a)}else{t.set(n,o.propertyValue,a)}}return function(t,e){if(Array.isArray(t)){t.forEach(function(t){o(t,e)})}else{o(t,e)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/Utils", ["sap/ui/fl/initial/_internal/connectors/Utils"],function(n){"use strict";function t(t,e,i){if(t.initialConnector){delete t.initialConnector.xsrfToken}return n.sendRequest(t.tokenUrl,"HEAD",{initialConnector:t.initialConnector}).then(n.sendRequest.bind(undefined,e,i,t))}function e(n,t,i){if(!t[i]){t[i]=n[i];return}if(Array.isArray(t[i])){t[i]=t[i].concat(n[i]);return}if(typeof t[i]==="object"){Object.keys(n[i]).forEach(function(r){e(n[i],t[i],r)})}t[i]=n[i]}return{getRequestOptions(n,t,e,i,r){var o={tokenUrl:t,initialConnector:n};if(e){o.payload=JSON.stringify(e)}if(i){o.contentType=i}if(r){o.dataType=r}return o},sendRequest(e,i,r){if(!r.initialConnector||!r.initialConnector.xsrfToken&&!(i==="GET")&&!(i==="HEAD")){return t(r,e,i)}return n.sendRequest(e,i,r).then(function(n){return n}).catch(function(n){if(n.status===403){return t(r,e,i)}throw n})},mergeResults(n){var t={};n.forEach(function(n){Object.keys(n).forEach(function(i){e(n,t,i)})});return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportDialog", ["sap/m/List","sap/m/InputListItem","sap/m/Button","sap/m/ComboBox","sap/m/Dialog","sap/m/Input","sap/m/MessageToast","sap/ui/core/ListItem","sap/ui/core/Lib","sap/ui/fl/write/_internal/transport/Transports","sap/ui/core/library"],function(t,e,s,o,r,a,i,n,l,p,u){"use strict";var{ValueState:c}=u;var h=r.extend("sap.ui.fl.write._internal.transport.TransportDialog",{metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},localObjectVisible:{type:"boolean",group:"Misc",defaultValue:true},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},renderer:{apiVersion:2}});h.prototype.init=function(){r.prototype.init.apply(this);this._oResources=l.getResourceBundleFor("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(t){this.fireCancel();t.resolve()}.bind(this))};h.prototype._createContentList=function(){this._oPackageListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new t({items:[this._oPackageListItem,this._oTransportListItem]})};h.prototype._createButtons=function(){var t=this;this._oLocalObjectButton=new s({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press(){t._onLocal()}});this.addButton(this._oLocalObjectButton);this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press(){t._onOkay()}}));this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press(){t.fireCancel();t.close();t.destroy()}}))};h.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy()};h.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy()}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(c.Error);this._oTransport.setValueStateText(this.getTitle())}};h.prototype._checkOkay=function(t){if(t){return true}return false};h.prototype._createTransportCombo=function(){var t=this;return new o({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(c.None)},change(e){var s=function(t){if(t&&e.mParameters.newValue!==t.getText()||!t){return true}return false};if(e&&e.mParameters&&e.mParameters.newValue){if(s(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(c.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"))}}}})};h.prototype._createPackageField=function(){var t=this;return new a({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change(){var e;var s;s=t._createObjectInfo();e=p.getTransports(s);e.then(function(e){t._onPackageChangeSuccess(e)},function(e){t._onPackageChangeError(e)})},liveChange(e){if(e.mParameters.liveValue&&e.mParameters.liveValue.length>3){t._oTransport.setEnabled(true)}}})};h.prototype._createObjectInfo=function(){var t;var e={package:this._oPackage.getValue()||""};t=this.getProperty("lrepObject");if(t){if(t.name){e.name=t.name}if(t.type){e.type=t.type}if(t.namespace){e.namespace=t.namespace}}return e};h.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true)}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t)}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(c.Error);this._oPackage.setValueStateText(this._oResources.getText(`TRANSPORT_DIALOG_${t.errorCode}`));this._setTransports(t)}else{i.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"))}}};h.prototype._setTransports=function(t){var e;var s;e=this._hasLock(t.transports);if(e){s=[e]}else{s=t.transports}this.setTransports(s);if(s&&s.length===1){this._oTransport.setValue(s[0].description,true);this.getButtons()[1].setEnabled(true)}if(!s||s.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(c.None);this.getButtons()[1].setEnabled(false)}};h.prototype._onPackageChangeError=function(t){i.show(t);this.setTransports([])};h.prototype._hasLock=function(t){var e;var s=t.length;while(s--){e=t[s];if(e.locked){return e}}return null};h.prototype.setLocalObjectVisible=function(t){this._oLocalObjectButton.setVisible(t);this.setProperty("localObjectVisible",t)};h.prototype.setPkg=function(t){if(t&&!this.getProperty("pkg")){this.setProperty("pkg",t);this._oPackage.setValue(t);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false)}return this};h.prototype.setTransports=function(t){var e;var s=0;var o;if(t){this.setProperty("transports",t);this._oTransport.removeAllItems();s=t.length;for(e=0;e<s;e++){o=t[e];this._oTransport.addItem(new n({key:o.transportId,text:o.transportId,additionalText:o.description}))}if(s===1){this._oTransport.setSelectedKey(t[0].transportId);this.getButtons()[1].setEnabled(true)}if(s>0){this._oTransport.setEnabled(true)}}return this};h.prototype.setLrepObject=function(t){if(t&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",t)}return this};h.prototype.setHidePackage=function(t){this.setProperty("hidePackage",t);this._oPackageListItem.setVisible(!t);if(t){this.getButtons()[0].setEnabled(t);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"))}return this};return h},true);
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportSelection", ["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/_internal/transport/Transports","sap/ui/fl/write/_internal/transport/TransportDialog","sap/ui/fl/registry/Settings","sap/ui/core/BusyIndicator"],function(e,t,a,r,n,s,o){"use strict";var i=function(){};i.prototype.selectTransport=function(n,o,i,c,p,l,u){if(!e.getLrepUrl()){o(this._createEventObject(n,{transportId:""}));return}var f=function(e,a,n,s,o,i){r.getTransports(e).then(function(r){if(this._checkDialog(r,i)){this._openDialog({hidePackage:!t.doesCurrentLayerRequirePackage(),pkg:e.package,transports:r.transports,localObjectVisible:u,lrepObject:this._toLREPObject(e)},a,n,s,o)}else{var c=!r.localonly&&i?{transportId:"ATO_NOTIFICATION"}:this._getTransport(r);a(this._createEventObject(e,c))}}.bind(this),function(e){n(e)})};var g=t.getCurrentLayer();if(g&&(g===a.CUSTOMER||g===a.CUSTOMER_BASE)){s.getInstance().then(function(e){if(e.isAtoEnabled()){if(!(n&&n.name&&n.namespace&&n.type)){var t={transportId:"ATO_NOTIFICATION"};o(this._createEventObject(n,t))}else{f.apply(this,[n,o,i,c,l,true])}}else{f.apply(this,[n,o,i,c,l,false])}}.bind(this))}else{f.apply(this,[n,o,i,c,l,false])}};i.prototype._createEventObject=function(e,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:e.package,dialog:false},getParameters(){return this.mParameters},getParameter(e){return this.mParameters[e]}}};i.prototype._toLREPObject=function(e){var t={};if(e.namespace){t.namespace=e.namespace}if(e.name){t.name=e.name}if(e.type){t.type=e.type}return t};i.prototype._openDialog=function(e,t,a,r,s){var i=new n(e);i.attachOk(t);i.attachCancel(a);i.addStyleClass(s);if(r){i.addStyleClass("sapUiSizeCompact")}else{i.removeStyleClass("sapUiSizeCompact")}i.open();o.hide();return i};i.prototype._getTransport=function(e){var t;if(!e.localonly){t=this._hasLock(e.transports)}else{t={transportId:""}}return t};i.prototype._checkDialog=function(e,t){if(e){if(e.localonly||this._hasLock(e.transports)||!e.localonly&&t){return false}}return true};i.prototype._hasLock=function(e){var t=e.length;while(t--){var a=e[t];if(a.locked){return a}}return false};i.prototype.setTransports=function(e,t){var a=e.length-1;var r=this;var n=function(e,t,a,s,o){if(t>=0){var i=e[t];if(o===true){if(i.getFlexObjectMetadata().packageName!=="$TMP"){i.setRequest(s)}t--;return n(e,t,a,s,o)}if(i.getFlexObjectMetadata().packageName!=="$TMP"){var c={name:i.getId(),type:i.getFileType(),package:i.getFlexObjectMetadata().packageName,namespace:i.getNamespace()};return r.openTransportSelection(c,a).then(function(r){if(r==="cancel"){return Promise.reject("cancel")}i.setRequest(r.transport);if(r.fromDialog===true){s=r.transport;o=true}t--;return n(e,t,a,s,o)},function(){return null})}t--;return n(e,t,a,s,o)}return Promise.resolve()};return n(e,a,t)};i.prototype.openTransportSelection=function(e,t,a,r){var n=this;return new Promise(function(s,o){var i=function(e){if(e&&e.getParameters){var t=e.getParameters().selectedTransport;var a=e.getParameters().selectedPackage;var r=e.getParameters().dialog;var n={transport:t,packageName:a,fromDialog:r};s(n)}else{s({})}};var c=function(e){if(e.sId==="cancel"){s(e.sId)}else{o(e)}};n.selectTransport(e||{},i,c,false,t,a,r)})};i.prototype.checkTransportInfo=function(e){return e&&e.transport&&e.packageName!=="$TMP"};i.prototype._prepareChangesForTransport=function(e,t,a,n){var s=r.convertToChangeTransportData(t,a);var o={};o.package=e.packageName;o.transportId=e.transport;o.changeIds=s;o.reference=n.reference;o.layer=n.layer;return r.makeChangesTransportable(o).then(function(){t.forEach(function(t){var a=t.getFlexObjectMetadata();if(a.packageName==="$TMP"){a.packageName=e.packageName;t.setFlexObjectMetadata(a)}})})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/Transports", ["sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(e,r,t,n){"use strict";var a={ACTION_GET_TRANSPORTS:"/actions/gettransports/",ACTION_MAKE_CHANGE_TRANSPORTABLE:"/actions/make_changes_transportable/",ACTION_GET_TOKEN:"/actions/getcsrftoken/"};return{getTransports(e){if(r.getClient()){e["sap-client"]=r.getClient()}var n=t.getUrl(a.ACTION_GET_TRANSPORTS,{url:r.getLrepUrl()},e);n=decodeURIComponent(n);return t.sendRequest(n,"GET").then(function(e){if(e.response){e.response.localonly||=false;e.response.errorCode||="";return Promise.resolve(e.response)}return Promise.reject("response is empty")})},makeChangesTransportable(s){if(!s.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"))}if(!s.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"))}if(!s.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}var i=r.getClient()?{"sap-client":r.getClient()}:{};var o=t.getUrl(a.ACTION_MAKE_CHANGE_TRANSPORTABLE,{url:r.getLrepUrl()},i);var l=t.getUrl(a.ACTION_GET_TOKEN,{url:r.getLrepUrl()});var p=n.getRequestOptions(e,l,s,"application/json; charset=utf-8","json");return n.sendRequest(o,"POST",p)},convertToChangeTransportData(e,r){var t=[];var n;if(r&&r.length){for(n=0;n<r.length;n++){var a=r[n];var s={};s.namespace=a.getNamespace();s.fileName=a.getDefinition().fileName;s.fileType=a.getDefinition().fileType;t.push(s)}}var i=e.length;for(n=0;n<i;n++){var o=e[n];var l={};l.namespace=o.getNamespace();l.fileName=o.getId();l.fileType=o.getFileType();t.push(l)}return t}}});
//# sourceMappingURL=library-preload-apply.js.map
