//@ui5-bundle sap/ui/fl/library-preload-write.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnector", ["sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils","sap/ui/fl/write/_internal/connectors/ObjectPathConnector"],function(e,t,r,i){"use strict";var n={};var a="sap.ui.fl";n.prototype={};n.enableFakeConnector=function(e){this.setFlexibilityServicesAndClearCache("LocalStorageConnector",e)};n.setFlexibilityServicesAndClearCache=function(r,n){this._oFlexibilityServices=e.getFlexibilityServices();var a=[];if(n){i.setJsonPath(n);a.push({connector:"ObjectPathConnector"})}a.push({connector:r});e.setFlexibilityServices(a);t.clearState()};n.disableFakeConnector=function(){n.prototype={};t.clearState();if(this._oFlexibilityServices){e.setFlexibilityServices(this._oFlexibilityServices);delete this._oFlexibilityServices}};n.forTesting={getNumberOfChanges(e,t){return e.loadFlexData({reference:t}).then(function(e){return e.reduce(function(e,t){return e+t.changes.length},0)})},spyMethod(e,t,r,i){var n=e.spy(r,i);return function(e,r){r||=0;var a=n.getCall(r).args[0].flexObjects.length;t.equal(a,e,`${i} was called ${e} times`)}},clear(e,r){t.clearState();return e.reset(r)},setStorage(e,t){e.storage=t},synchronous:{clearAll(e){var t=function(t){var r=t.includes(a);if(!r){return}e.removeItem(t)};Object.keys(e).map(t)},store(e,t,i){var n=r.createFlexKey(t);var a=JSON.stringify(i);e.setItem(n,a)},getNumberOfChanges(e,t){return Object.keys(e).filter(function(i){return i.includes(a)&&r.isSameReference(JSON.parse(e.getItem(i)),t)}).length}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnectorLocalStorage", ["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/LocalStorageConnector"],function(e,n){"use strict";return{enableFakeConnector(n){var o=n?n.sInitialComponentJsonPath:undefined;e.setFlexibilityServicesAndClearCache("LocalStorageConnector",o)},disableFakeConnector(){e.disableFakeConnector()},forTesting:{spyWrite(o,r){return e.forTesting.spyMethod(o,r,n,"write")},getNumberOfChanges(o){return e.forTesting.getNumberOfChanges(n,o)},synchronous:{clearAll(){e.forTesting.synchronous.clearAll(window.localStorage)},store(n,o){e.forTesting.synchronous.store(window.localStorage,n,o)}}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnectorSessionStorage", ["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/SessionStorageConnector"],function(e,n){"use strict";return{enableFakeConnector(n){var r=n?n.sInitialComponentJsonPath:undefined;e.setFlexibilityServicesAndClearCache("SessionStorageConnector",r)},disableFakeConnector(){e.disableFakeConnector()},forTesting:{spyWrite(r,t){return e.forTesting.spyMethod(r,t,n,"write")},getNumberOfChanges(r){return e.forTesting.getNumberOfChanges(n,r)},clear(r){return e.forTesting.clear(n,r)},setStorage(r){e.forTesting.setStorage(n,r)},synchronous:{clearAll(){e.forTesting.synchronous.clearAll(window.sessionStorage)},getNumberOfChanges(r){return e.forTesting.synchronous.getNumberOfChanges(n.storage,r)}}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepLocalStorage", ["sap/ui/fl/FakeLrepConnectorLocalStorage"],function(e){"use strict";return{deleteChanges(){return e.forTesting.synchronous.clearAll()}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/Utils", [],function(){"use strict";var e=function(){};e.prototype.getNameAndNameSpace=function(e,t){return{fileName:"manifest",namespace:`apps/${t}/appVariants/${e}/`}};e.prototype.checkChildPageChange=function(e){this.checkParameterAndType(e,"childPage","object");if(e.childPage instanceof Array){for(var t=0;t<e.childPage.length;t++){var r=e.childPage[t];this.checkChildPageChangeContent(r)}}else if(e.childPage instanceof Object){this.checkChildPageChangeContent(e.childPage)}};e.prototype.checkChildPageChangeContent=function(e){this.checkParameterAndType(e,"id","string");this.checkParameterAndType(e,"definition","object");this.checkParameterAndType(e.definition,"navigationProperty","string");this.checkParameterAndType(e.definition,"entitySet","string")};e.prototype.checkEntityPropertyChange=function(e){this.checkParameterAndType(e,"entityPropertyChange","object");if(e.entityPropertyChange instanceof Array){for(var t=0;t<e.entityPropertyChange.length;t++){var r=e.entityPropertyChange[t];this.checkEntityPropertyChangeContent(r)}}else if(e.entityPropertyChange instanceof Object){this.checkEntityPropertyChangeContent(e.entityPropertyChange)}};e.prototype.checkEntityPropertyChangeContent=function(e){this.checkParameterAndType(e,"propertyPath","string");this.checkParameterAndType(e,"operation","string");if(["INSERT","UPDATE","UPSERT","DELETE"].indexOf(e.operation)===-1){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'")}if(e.propertyValue===undefined&&e.operation!=="DELETE"){throw new Error('No parameter "entityPropertyChange.propertyValue" provided')}};e.prototype.checkParameterAndType=function(e,t,r){if(typeof r==="string"){r=[r]}var n;r.forEach(function(r){if(r==="array"){if(e!==undefined&&e[t]!==undefined&&Array.isArray(e[t])){n=true}}else if(e!==undefined&&e[t]!==undefined&&typeof e[t]===r){n=true}});if(!n){throw new Error(`No parameter "${t}" of type ${r} provided`)}};e.prototype.checkTexts=function(e){if(e!==undefined&&typeof e!=="object"){throw new Error('Wrong format for provided "texts" parameter')}};e.prototype.checkTransportRequest=function(e){if(!/^[A-Z0-9]{1,20}$/.test(e)&&e!=="ATO_NOTIFICATION"){throw new Error('Wrong format for provided "sTransportRequest" parameter')}};e.prototype.checkPackage=function(e){if(!/^[A-Z0-9/_$-]{1,30}$/.test(e)&&e!=="$TMP"){throw new Error(`Wrong format for provided "sPackage" parameter. '${e}' as package name is not allowed.`)}};return new e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorChange", ["sap/base/util/merge","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils"],function(e,t,n,i,s){"use strict";const r=function(e,t){this._mChangeFile=e;this._mChangeFile.packageName="";this._oInlineChange=t};r.prototype.submit=function(){this.store();const e=this._getChangePersistence(this._mChangeFile.reference);return e.saveDirtyChanges()};r.prototype.store=function(){const e=this._mChangeFile.reference;const t=s.getComponentForControl(this._mChangeFile.selector);const i=this._getChangeToSubmit();n.addDirtyChanges(e,[i],t);return i};r.prototype._getChangePersistence=function(e){return i.getChangePersistenceForComponent(e)};r.prototype._getChangeToSubmit=function(){return t.createAppDescriptorChange(this._getMap())};r.prototype._getMap=function(){var e=this._oInlineChange.getMap();this._mChangeFile.content=e.content;this._mChangeFile.texts=e.texts;return this._mChangeFile};r.prototype.getJson=function(){return e({},this._getMap())};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory", ["sap/ui/fl/descriptorRelated/api/DescriptorChange"],function(e){"use strict";var t=function(){};t.prototype.createNew=function(t,r,a,n,o){if(r.setHostingIdForTextKey){r.setHostingIdForTextKey(t)}var i={};const p=r.getMap();i.changeType=p.changeType;i.fileName=r.fileName;i.componentName=t;i.reference=t;i.generator=o;i.support=p.support;i.adaptationId=p.adaptationId;i.layer=a||"CUSTOMER";return Promise.resolve(new e(i,r))};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/base/util/merge"],function(e,a,r){"use strict";function t(e,a,t){var n=r({},{changeType:e},{content:a});if(t){n.texts=t}return n}var n={};n.getDescriptorChangeTypes=function(){return a.getChangeTypes()};n.getCondensableDescriptorChangeTypes=function(){return a.getCondensableChangeTypes()};n.createNew=function(a,r,n){var p=t(a,r,n);return e.createNew(p)};n.createDescriptorInlineChange=function(a,r,n){var p=t(a,r,n);return e.createDescriptorInlineChange(p)};n.create_ovp_addNewCard=function(a,r){var n=t("appdescr_ovp_addNewCard",a,r);return e.create_ovp_addNewCard(n)};n.create_ovp_removeCard=function(a){var r=t("appdescr_ovp_removeCard",a);return e.create_ovp_removeCard(r)};n.create_ovp_changeCard=function(a,r){var n=t("appdescr_ovp_changeCard",a,r);return e.create_ovp_changeCard(n)};n.create_app_addNewInbound=function(a,r){var n=t("appdescr_app_addNewInbound",a,r);return e.create_app_addNewInbound(n)};n.create_app_removeInbound=function(a){var r=t("appdescr_app_removeInbound",a);return e.create_app_removeInbound(r)};n.create_app_removeAllInboundsExceptOne=function(a){var r=t("appdescr_app_removeAllInboundsExceptOne",a);return e.create_app_removeAllInboundsExceptOne(r)};n.create_app_changeInbound=function(a,r){var n=t("appdescr_app_changeInbound",a,r);return e.create_app_changeInbound(n)};n.create_app_addNewOutbound=function(a){var r=t("appdescr_app_addNewOutbound",a);return e.create_app_addNewOutbound(r)};n.create_app_removeOutbound=function(a){var r=t("appdescr_app_removeOutbound",a);return e.create_app_removeOutbound(r)};n.create_app_changeOutbound=function(a){var r=t("appdescr_app_changeOutbound",a);return e.create_app_changeOutbound(r)};n.create_app_addNewDataSource=function(a){var r=t("appdescr_app_addNewDataSource",a);return e.create_app_addNewDataSource(r)};n.create_app_removeDataSource=function(a){var r=t("appdescr_app_removeDataSource",a);return e.create_app_removeDataSource(r)};n.create_app_changeDataSource=function(a){var r=t("appdescr_app_changeDataSource",a);return e.create_app_changeDataSource(r)};var p={BEGINNING:"BEGINNING",END:"END"};n.create_app_addAnnotationsToOData=function(a){var r=t("appdescr_app_addAnnotationsToOData",a);return e.create_app_addAnnotationsToOData(r)};n.create_app_setTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setTitle",a,r);return e.create_app_setTitle(n)};n.create_app_setSubTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setSubTitle",a,r);return e.create_app_setSubTitle(n)};n.create_app_setShortTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setShortTitle",a,r);return e.create_app_setShortTitle(n)};n.create_app_setDescription=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setDescription",a,r);return e.create_app_setDescription(n)};n.create_app_setInfo=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setInfo",a,r);return e.create_app_setInfo(n)};n.create_app_setAch=function(a){var r=t("appdescr_app_setAch",a);return e.create_app_setAch(r)};n.create_app_setDestination=function(a){var r=t("appdescr_app_setDestination",a);return e.create_app_setDestination(r)};n.create_app_setKeywords=function(a,r){var n=t("appdescr_app_setKeywords",a,r);return e.create_app_setKeywords(n)};n.create_app_addTechnicalAttributes=function(a){var r=t("appdescr_app_addTechnicalAttributes",a);return e.create_app_addTechnicalAttributes(r)};n.create_app_removeTechnicalAttributes=function(a){var r=t("appdescr_app_removeTechnicalAttributes",a);return e.create_app_removeTechnicalAttributes(r)};n.create_app_addCdsViews=function(a){var r=t("appdescr_app_addCdsViews",a);return e.create_app_addCdsViews(r)};n.create_app_removeCdsViews=function(a){var r=t("appdescr_app_removeCdsViews",a);return e.create_app_removeCdsViews(r)};n.create_flp_setConfig=function(a){var r=t("appdescr_flp_setConfig",a);return e.create_flp_setConfig(r)};n.create_ui5_addNewModel=function(a){var r=t("appdescr_ui5_addNewModel",a);return e.create_ui5_addNewModel(r)};n.create_ui5_removeModel=function(a){var r=t("appdescr_ui5_removeModel",a);return e.create_ui5_removeModel(r)};n.create_ui5_addNewModelEnhanceWith=function(a,r){var n=t("appdescr_ui5_addNewModelEnhanceWith",a,r);return e.create_ui5_addNewModelEnhanceWith(n)};n.create_ui5_replaceComponentUsage=function(a){var r=t("appdescr_ui5_replaceComponentUsage",a);return e.create_ui5_replaceComponentUsage(r)};n.create_ui5_addLibraries=function(a){var r=t("appdescr_ui5_addLibraries",a);return e.create_ui5_addLibraries(r)};n.create_ui5_setMinUI5Version=function(a){var r=t("appdescr_ui5_setMinUI5Version",a);return e.create_ui5_setMinUI5Version(r)};n.create_smb_addNamespace=function(a){var r=t("appdescr_smb_addNamespace",a);return e.create_smb_addNamespace(r)};n.create_smb_changeNamespace=function(a){var r=t("appdescr_smb_changeNamespace",a);return e.create_smb_changeNamespace(r)};n.create_ui_generic_app_setMainPage=function(a,r){var n=t("appdescr_ui_generic_app_setMainPage",a,r);return e.create_ui_generic_app_setMainPage(n)};n.create_ui_setIcon=function(a){var r=t("appdescr_ui_setIcon",a);return e.create_ui_setIcon(r)};n.create_ui_setDeviceTypes=function(a){var r=t("appdescr_ui_setDeviceTypes",a);return e.create_ui_setDeviceTypes(r)};n.create_url_setUri=function(a){var r=t("appdescr_url_setUri",a);return e.create_url_setUri(r)};n.create_fiori_setRegistrationIds=function(a){var r=t("appdescr_fiori_setRegistrationIds",a);return e.create_fiori_setRegistrationIds(r)};n.create_ui5_setFlexExtensionPointEnabled=function(a){var r=t("appdescr_ui5_setFlexExtensionPointEnabled",a);return e.create_ui5_setFlexExtensionPointEnabled(r)};n.create_fiori_setAbstract=function(a){var r=t("appdescr_fiori_setAbstract",a);return e.create_fiori_setAbstract(r)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariantFactory"],function(e){"use strict";var r={};r.createNew=function(e){return r.createAppVariant(e)};r.createAppVariant=function(r){return e.prepareCreate(r)};r.createForExisting=function(r){return e.prepareUpdate({id:r})};r.createDeletion=function(r){return e.prepareDelete({id:r})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/resolveBinding", ["sap/ui/base/ManagedObject","sap/ui/fl/Utils"],function(e,t){"use strict";var n=e.extend("sap.ui.fl.util.HelperControl",{metadata:{library:"sap.ui.fl",properties:{resolved:{type:"any"}}}});return function(i,o){const r=t.getViewForControl(o);const s=r&&r.getController();if(!t.isBinding(i,s)){return undefined}const d=typeof i==="string"?e.bindingParser(i,s):{...i};if(!d){return undefined}const l=new n;const a=d.parts||[d];a.forEach(function(e){const t=e.model;if(t){l.setModel(o.getModel(t),t);l.setBindingContext(o.getBindingContext(t),t)}else{l.setModel(o.getModel());l.setBindingContext(o.getBindingContext())}});l.bindProperty("resolved",d);const u=l.getResolved();l.destroy();return u}});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/VariantManager", ["sap/base/util/restricted/_difference","sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/_internal/controlVariants/ControlVariantWriteUtils","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,a,n,t,r,i,o,c,l,s,f,p,g,u,d,v,m,C){"use strict";var h={};function y(e){const a=C.getAppComponentForControl(e);return a.getModel(p.getVariantModelName())}async function R(e){var a=e.model._getDirtyChangesFromVariantChanges(e.changes);a=a.reverse();if(e.revert){await o.revertMultipleChanges(a,{appComponent:e.model.oAppComponent,modifier:t,reference:e.model.sFlexReference})}d.deleteFlexObjects({reference:e.model.sFlexReference,flexObjects:a})}function V(e,a){a._oVariantSwitchPromise=a._oVariantSwitchPromise.catch(function(){}).then(e);s.setVariantSwitchPromise(a.sFlexReference,a._oVariantSwitchPromise);return a._oVariantSwitchPromise}async function x(e,a,n,t,r){if(!r._bDesignTimeMode){const i=await e.saveSequenceOfDirtyChanges(a,t);if(i){const e=i.response.find(e=>e.fileType==="ctrl_variant");const a=r.oData[n].variants.find(a=>a.key===e.fileName);const t=a.instance.getSupportInformation();t.user=e.support.user;a.instance.setSupportInformation(t)}r.invalidateMap()}}function F(e,a,n){var t={layer:e,control:a,reference:n};var r=v.hasAdaptationsModel(t);return r&&v.getDisplayedAdaptationId(t)}h.handleSelectVariant=function(e,a){return V(async function(e,a){var t=a.model;var r=a.vmReference;var i=false;var o=n.get([r,"modified"],t.oData);var c=e.key;var l=e.key;if(n.get([r,"currentVariant"],t.oData)&&t.oData[r].currentVariant!==c){l=t.oData[r].currentVariant;i=true;await t.updateCurrentVariant({variantManagementReference:r,newVariantReference:c,appComponent:t.oAppComponent,internallyCalled:true})}if(o){var f=s.getControlChangesForVariant({reference:t.sFlexReference,vmReference:r,vReference:l});await R({changes:f,vmReference:r,vReference:l,revert:!i,model:t})}if(!i){t.callVariantSwitchListeners(r,t.oData[r].currentVariant)}}.bind(null,e.getParameters(),a),a.model)};h.handleManageEvent=async function(a,n,t){const r=n.variantManagementReference;if(!t.oFlexController||!t.getData()){return}const{changes:i,variantsToBeDeleted:o}=t._collectModelChanges(r,m.USER,a);if(!i.length&&!o.length){return}if(i.some(e=>e.visible===false&&e.variantReference===t.getCurrentVariantReference(r))){await t.updateCurrentVariant({variantManagementReference:r,newVariantReference:r})}i.forEach(function(e){e.appComponent=t.oAppComponent});const c=h.addVariantChanges(r,i);const f=o.map(e=>{const a=s.getVariant({reference:t.sFlexReference,vmReference:r,vReference:e});if(a.layer===m.USER){return g.deleteVariant(t.sFlexReference,r,e)}return[]}).flat();const p=[...e(c,f),...f.filter(e=>e.getState()!==l.LifecycleState.NEW)];const u=Object.values(m).reverse();for(const e of u){const a=p.filter(a=>a.getLayer()===e);if(a.length>0){await t.oChangePersistence.saveDirtyChanges(t.oAppComponent,false,a)}}};h.handleSaveEvent=async function(e,n,r){var i=C.getAppComponentForControl(e);var o=r.getLocalId(e.getId(),i);var l;await V(async function(e,n,i){var o=r.getCurrentVariantReference(e);var f=s.getControlChangesForVariant({reference:r.sFlexReference,vmReference:e,vReference:o});if(i.overwrite){l=r._getDirtyChangesFromVariantChanges(f);if(r.getVariant(o,e).layer===m.PUBLIC){l.forEach(e=>e.setLayer(m.PUBLIC))}const a=r.oFlexController.saveSequenceOfDirtyChanges(l,n);r.invalidateMap();return a}var p=i.layer||(i.public?m.PUBLIC:m.USER);var g=i.layer||m.USER;var u=i.newVariantReference||C.createDefaultFileName("flVariant");var d={variantManagementReference:e,appComponent:n,layer:p,title:i.name,contexts:i.contexts,sourceVariantReference:o,newVariantReference:u,generator:i.generator,additionalVariantChanges:[],adaptationId:F(g,n,r.sFlexReference),executeOnSelection:i.execute};var v={content:{},reference:r.sFlexReference,generator:d.generator,layer:g,adaptationId:d.adaptationId};if(i.def){var y=a({changeType:"setDefault",content:{defaultVariant:u},fileType:"ctrl_variant_management_change",selector:t.getSelector(e,d.appComponent)},v);d.additionalVariantChanges.push(c.createVariantManagementChange(y))}const V=await h.copyVariant(d);l=V;await R({changes:f,vmReference:e,vReference:o,model:r});return x(r.oFlexController,l,e,n,r)}.bind(r,o,i,n),r);return l};h.addAndApplyChangesOnVariant=function(e,a){const n=y(a);const o=u.addDirtyChanges(n.sFlexReference,e,n.oAppComponent);return o.reduce(async function(e,a){await e;const o=r.getElementById(t.getControlIdBySelector(a.getSelector(),n.oAppComponent));const c=await i.applyChangeOnControl(a,o,{modifier:t,appComponent:n.oAppComponent,view:C.getViewForControl(o)});if(!c.success){var l=c.error||new Error("The change could not be applied.");d.deleteFlexObjects({reference:n.sFlexReference,flexObjects:[a]});throw l}},Promise.resolve())};h.eraseDirtyChangesOnVariant=async function(e,a,n){const t=y(n);var r=s.getControlChangesForVariant({reference:t.sFlexReference,vmReference:e,vReference:a});var i=t._getDirtyChangesFromVariantChanges(r);await R({changes:r,vmReference:e,vReference:a,model:t,revert:true});return i};h.copyVariant=async function(e){const a=y(e.appComponent);var n=a._duplicateVariant(e);n.generator=e.generator;a.oData[e.variantManagementReference].variants.push({key:n.instance.getId(),rename:true,change:true,remove:true,sharing:e.layer===m.USER?a.sharing.PRIVATE:a.sharing.PUBLIC});var t=[];if(e.layer===m.PUBLIC){n.instance.setFavorite(false);var r={variantId:e.newVariantReference,changeType:"setFavorite",fileType:"ctrl_variant_change",generator:e.generator,layer:m.USER,reference:a.sFlexReference,content:{favorite:true}};t.push(c.createVariantChange(r))}t=d.addDirtyFlexObjects(a.sFlexReference,t.concat([n.instance].concat(n.controlChanges).concat(e.additionalVariantChanges)));await a.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:n.instance.getId(),appComponent:e.appComponent,internallyCalled:true,scenario:"saveAs"});return t};h.removeVariant=async function(e){const a=y(e.appComponent);var n=f.getDirtyFlexObjects(a.sFlexReference).filter(function(a){return a.getVariantReference&&a.getVariantReference()===e.variant.getId()||a.getId()===e.variant.getId()});await a.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:e.sourceVariantReference,appComponent:e.component});d.deleteFlexObjects({reference:a.sFlexReference,flexObjects:n})};h.addVariantChange=function(e,a){const n=y(a.appComponent);var t=h.createVariantChange(e,a);d.addDirtyFlexObjects(n.sFlexReference,[t]);return t};h.addVariantChanges=function(e,a){const n=y(a[0].appComponent);var t=a.map(function(a){return h.createVariantChange(e,a)});d.addDirtyFlexObjects(n.sFlexReference,t);return t};h.deleteVariantChange=function(e,a,n){const t=y(a.appComponent);t.setVariantProperties(e,a);d.deleteFlexObjects({reference:t.sFlexReference,flexObjects:[n]})};h.createVariantChange=function(e,a){const n=y(a.appComponent);var r=n.setVariantProperties(e,a);var i={changeType:a.changeType,layer:a.layer,generator:a.generator,reference:n.sFlexReference};if(a.adaptationId!==undefined){i.adaptationId=a.adaptationId}else{i.adaptationId=F(a.layer,a.appComponent,n.sFlexReference)}let o;if(a.changeType==="setDefault"){i.fileType="ctrl_variant_management_change";i.selector=t.getSelector(e,a.appComponent);o=c.createVariantManagementChange(i)}else{i.fileType="ctrl_variant_change";i.variantId=a.variantReference;o=c.createVariantChange(i)}o.setContent(r);if(a.changeType==="setTitle"){o.setText("title",a.title,"XFLD")}return o};h.manageVariants=function(e,a,n,t,r){const i=y(e);return new Promise(function(o){e.attachEventOnce("manage",{resolve:o,variantManagementReference:a,layer:n},i.fnManageClickRta,i);e.openManagementDialog(true,t,r)})};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/SaveAs", ["sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/Log","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,t,r,n,a,i,c,o,s,u,l,p,f,g){"use strict";function h(e){return o.getInstance().then(function(t){if(!e.package&&(e.layer===f.VENDOR||e.layer===f.CUSTOMER_BASE&&!t.isAtoEnabled())){return Promise.reject("Package must be provided or is valid")}if(e.isForSmartBusiness&&(e.package!=="$TMP"&&e.package!=="")&&!e.transport&&!t.isAtoEnabled()){return Promise.reject("Transport must be provided")}if(e.isForSmartBusiness&&e.transport||e.package==="$TMP"){return Promise.resolve({packageName:e.package,transport:e.transport})}return Promise.resolve({packageName:"",transport:""})})}function d(e,t){var r=t.transport?e.setTransportRequest(t.transport):Promise.resolve();return r.then(function(){if(t.packageName){return e.setPackage(t.packageName)}return Promise.resolve()})}function m(e){var t=[];e.forEach(function(e){var r={changeType:e.getChangeType(),content:e.getContent()};if(e.getTexts()){r.texts=e.getTexts()}t.push(u.createNew(r))});return Promise.all(t)}function A(e,t){var r={reference:t.getId()};var n=g.createNamespace(r,"changes");var a=e.getFlexObjectMetadata();a.namespace=n;a.reference=t.getId();e.setFlexObjectMetadata(a)}function y(e,t){var r=[];e.forEach(function(e){e.replaceHostingIdForTextKey(t.getId(),t.getReference(),e.getContent(),e.getTexts());r.push(t.addDescriptorInlineChange(e))});return Promise.all(r)}function v(e){const t=i.getFlexReferenceForSelector(e);return a.getDirtyFlexObjects(t).filter(function(e){return n.getChangeTypes().includes(e.getChangeType())})}function F(e){const t=i.getFlexReferenceForSelector(e);return a.getDirtyFlexObjects(t).slice()}function _(e){const t=i.getFlexReferenceForSelector(e);var r=[];v(e).forEach(function(e){if(n.getChangeTypes().includes(e.getChangeType())){r.push(e)}});l.deleteFlexObjects({reference:t,flexObjects:r})}function P(e,t){if(!e){throw new Error(`App variant with ID: ${t.id}does not exist`)}t.package=e.getPackage();t.layer=e.getDefinition().layer;return h(t).then(function(t){return d(e,t)}).then(function(){return e})}var T={saveAs(e){var a;var i;return s.prepareCreate(e).then(function(r){a=t({},r);return h(e)}).then(function(e){return d(a,e)}).then(function(){var t=[];F(e.selector).forEach(function(e){if(n.getChangeTypes().includes(e.getChangeType())){t.push(e)}else{A(e,a)}});return m(t)}).then(function(e){return y(e,a)}).then(function(){return a.submit().catch(function(e){e.messageKey="MSG_SAVE_APP_VARIANT_FAILED";throw e})}).then(function(r){i=t({},r);_(e.selector);var n=p.createForSelector(e.selector);var a=F(e.selector);if(a.length){return n.saveAll(g.getAppComponentForSelector(e.selector),true).then(function(){const t=c.getFlexReference({element:e.selector});l.removeDirtyFlexObjects({reference:t})}).catch(function(t){return this.deleteAppVariant({id:e.id}).then(function(){t.messageKey="MSG_COPY_UNSAVED_CHANGES_FAILED";throw t})}.bind(this))}return Promise.resolve()}.bind(this)).then(function(){return i}).catch(function(t){if(v(e.selector).length){_(e.selector)}r.error("the app variant could not be created.",t.message||t);throw t})},updateAppVariant(a){var i;var c;return s.prepareUpdate(e(a,"selector")).catch(function(e){e.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw e}).then(function(e){if(!e){throw new Error(`App variant with ID: ${a.id}does not exist`)}i=t({},e);a.package=i.getPackage();a.layer=i.getDefinition().layer;return h(a)}).then(function(e){return d(i,e)}).then(function(){var e=[];v(a.selector).forEach(function(t){if(n.getChangeTypes().includes(t.getChangeType())){e.push(t)}});return m(e)}).then(function(e){return y(e,i)}).then(function(){return i.submit().catch(function(e){if(a.isForSmartBusiness){_(a.selector);throw e}e.messageKey="MSG_UPDATE_APP_VARIANT_FAILED";throw e})}).then(function(e){c=t({},e);_(a.selector);return c}).catch(function(e){if(v(a.selector).length){_(a.selector)}r.error("the app variant could not be updated.",e.message||e);throw e})},deleteAppVariant(t){return s.prepareDelete(e(t,"selector")).catch(function(e){e.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw e}).then(function(e){return t.isForSmartBusiness?Promise.resolve(e):P(e,t)}).then(function(e){return e.submit().catch(function(e){if(e==="cancel"){return Promise.reject("cancel")}e.messageKey="MSG_DELETE_APP_VARIANT_FAILED";throw e})}).catch(function(e){if(e==="cancel"){return Promise.reject("cancel")}r.error("the app variant could not be deleted.",e.message||e);throw e})}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariant", ["sap/ui/base/ManagedObject","sap/ui/fl/descriptorRelated/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge","sap/base/Log","sap/base/util/isPlainObject"],function(e,i,t,n,o,r){"use strict";var s=e.extend("sap.ui.fl.write._internal.appVariant.AppVariant",{constructor:function(i){e.apply(this);if(!r(i)){o.error("Constructor : sap.ui.fl.write._internal.appVariant.AppVariant: mPropertyBag is not defined")}this._oDefinition=i;return this},metadata:{library:"sap.ui.fl",properties:{mode:{type:"string"}}}});s.modes={NEW:"NEW",EXISTING:"EXISTING",DELETION:"DELETION"};s.prototype._isValidMode=function(e){var i=false;Object.keys(s.modes).some(function(t){if(s.modes[t]===e){i=true}});return i};s.prototype.setMode=function(e){if(this._isValidMode(e)){this.setProperty("mode",e)}else{throw new Error("Provide a correct operation mode")}};s.prototype.setTransportRequest=function(e){try{i.checkTransportRequest(e)}catch(e){return Promise.reject(e)}this._oDefinition.transport=e;return Promise.resolve()};s.prototype.setReference=function(e){if(e===undefined||typeof e!=="string"){throw new Error("No parameter sReference of type string provided")}this._oDefinition.reference=e};s.prototype.setPackage=function(e){try{i.checkPackage(e)}catch(e){return Promise.reject(e)}this._oDefinition.packageName=e;return Promise.resolve()};s.prototype.getDefinition=function(){return this._oDefinition};s.prototype.getId=function(){return this._oDefinition.id};s.prototype.getNamespace=function(){return this._oDefinition.namespace||i.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).namespace};s.prototype.getFileName=function(){return this._oDefinition.fileName||i.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).fileName};s.prototype.getReference=function(){return this._oDefinition.reference};s.prototype.getPackage=function(){return this._oDefinition.packageName};s.prototype.getVersion=function(){return this._oDefinition.version};s.prototype.getTransportRequest=function(){return this._oDefinition.transport};s.prototype.getJson=function(){return n({},this._getMap())};s.prototype._getMap=function(){var e={};switch(this.getMode()){case s.modes.NEW:e={fileName:this.getFileName(),fileType:"appdescr_variant",namespace:this.getNamespace(),layer:this._oDefinition.layer,packageName:this._oDefinition.packageName?this._oDefinition.packageName:"",reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content||[]};if(this._oDefinition.referenceVersion){e.referenceVersion=this._oDefinition.referenceVersion}if(this._oDefinition.version){e.version=this._oDefinition.version}break;case s.modes.EXISTING:e={fileName:this._oDefinition.fileName,fileType:this._oDefinition.fileType,namespace:this._oDefinition.namespace,layer:this._oDefinition.layer,packageName:this._oDefinition.packageName,reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content};if(this._oDefinition.referenceVersion){e.referenceVersion=this._oDefinition.referenceVersion}if(this._oDefinition.version){e.version=this._oDefinition.version}break;case s.modes.DELETION:e={id:this._oDefinition.id};break;default:}return e};s.prototype.addDescriptorInlineChange=function(e){return new Promise(function(i){var t=function(e,i){if(e.setHostingIdForTextKey){e.setHostingIdForTextKey(i)}};t(e,this.getId());this._oDefinition.content.push(e.getMap());i(null)}.bind(this))};s.prototype.submit=function(){var e=this._getMap();var i={flexObject:{},appVariant:this};if(this._oDefinition.transport){i.transport=this._oDefinition.transport}if(this._oDefinition.skipIam){i.skipIam=this._oDefinition.skipIam}if(this._oDefinition.isForSmartBusiness){i.isForSmartBusiness=this._oDefinition.isForSmartBusiness}if(this._oDefinition.parentVersion){i.parentVersion=this._oDefinition.parentVersion}if(e.layer){i.layer=e.layer}i.url="/sap/bc/lrep";var n;switch(this.getMode()){case s.modes.NEW:Object.assign(i.flexObject,e);n=t.appVariant.create(i);break;case s.modes.EXISTING:i.reference=e.id;Object.assign(i.flexObject,e);n=t.appVariant.update(i);break;case s.modes.DELETION:i.reference=e.id;n=t.appVariant.remove(i);break;default:return Promise.reject("Please provide a valid operation.")}return n.then(function(e){return e})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariantFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariant","sap/ui/fl/Layer","sap/ui/fl/descriptorRelated/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge","sap/base/util/isPlainObject"],function(e,r,n,t,a,i){"use strict";function s(e){e.url||="/sap/bc/lrep";return t.appVariant.load(e)}var o={};o.load=function(r){if(r.id===undefined||typeof r.id!=="string"){throw new Error(`Parameter ${r.id} must be provided of type string`)}return s({reference:r.id}).then(function(n){var t=n.response;if(!i(t)){t=JSON.parse(t)}r=a({},r,t);return new e(r)})};o.prepareCreate=function(t){try{n.checkParameterAndType(t,"reference","string");n.checkParameterAndType(t,"id","string");if(t.version){n.checkParameterAndType(t,"version","string")}if(!t.layer){t.layer=r.CUSTOMER}else{n.checkParameterAndType(t,"layer","string")}if(t.skipIam){n.checkParameterAndType(t,"skipIam","boolean")}if(t.transport){n.checkTransportRequest(t.transport)}if(t.package){n.checkPackage(t.package)}}catch(e){return Promise.reject(e)}t.content=[];var a=new e(t);a.setMode("NEW");return Promise.resolve(a)};o.prepareUpdate=function(e){return o.load(e).then(function(e){e.setMode("EXISTING");return e})};o.prepareDelete=function(r){return(r.isForSmartBusiness?Promise.resolve(new e(r)):o.load(r)).then(function(e){e.setMode("DELETION");return e})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange", ["sap/ui/base/ManagedObject","sap/ui/fl/descriptorRelated/Utils","sap/base/Log","sap/base/util/isPlainObject"],function(t,i,e,n){"use strict";var o=t.extend("sap.ui.fl.write._internal.appVariant.AppVariantInlineChange",{metadata:{library:"sap.ui.fl"},constructor:function(o){t.apply(this);if(!n(o)){e.error("Constructor : sap.ui.fl.write._internal.appVariant.AppVariantInlineChange: mPropertyBag is not defined")}i.checkTexts(o.texts);this._oDefinition=o;return this}});o.prototype._getChangeType=function(){return this._oDefinition.changeType};o.prototype.getMap=function(){return this._oDefinition};o.prototype.getContent=function(){return this._oDefinition.content};o.prototype.getTexts=function(){return this._oDefinition.texts};o.prototype.getHostingIdSuffix=function(){return this._sHostingIdSuffix};o.prototype.setHostingIdSuffix=function(t){this._sHostingIdSuffix=t};o.prototype.replaceHostingIdForTextKey=function(t,i,e,n){var o=JSON.stringify(e);if(n){Object.keys(n).forEach(function(e){var n;if(e.indexOf(i)===0){n=t+e.substring(i.length);this._oDefinition.texts[n]=this._oDefinition.texts[e];delete this._oDefinition.texts[e];o=o.split(`{{${e}}}`).join(`{{${n}}}`)}},this);this._oDefinition.content=JSON.parse(o)}};o.prototype.setHostingIdForTextKey=function(t){if(this.getHostingIdSuffix()){var i=t+this.getHostingIdSuffix();if(this._oDefinition.texts){this._oDefinition.texts[i]=this._oDefinition.texts[""];delete this._oDefinition.texts[""]}}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory", ["sap/ui/fl/descriptorRelated/Utils","sap/ui/fl/Utils","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange"],function(e,t,n){"use strict";function r(e){if(!e.texts){e.texts={"":e.content};e.content={}}}function c(e){var t=new n(e);return Promise.resolve(t)}var a={};a.createNew=function(e){var t=new n(e);return Promise.resolve(t)};a.createDescriptorInlineChange=function(e){var t=e.changeType.replace("appdescr","create");if(!this[t]){throw new Error(`Change type '${e.changeType}' is not supported`)}return this[t](e)};a.create_ovp_addNewCard=function(t){e.checkParameterAndType(t.content,"card","object");return c(t)};a.create_ovp_removeCard=function(t){e.checkParameterAndType(t.content,"cardId","string");return c(t)};a.create_ovp_changeCard=function(t){e.checkParameterAndType(t.content,"cardId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewInbound=function(t){e.checkParameterAndType(t.content,"inbound","object");return c(t)};a.create_app_removeInbound=function(t){e.checkParameterAndType(t.content,"inboundId","string");return c(t)};a.create_app_removeAllInboundsExceptOne=function(t){e.checkParameterAndType(t.content,"inboundId","string");return c(t)};a.create_app_changeInbound=function(t){e.checkParameterAndType(t.content,"inboundId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewOutbound=function(t){e.checkParameterAndType(t.content,"outbound","object");return c(t)};a.create_app_removeOutbound=function(t){e.checkParameterAndType(t.content,"outboundId","string");return c(t)};a.create_app_changeOutbound=function(t){e.checkParameterAndType(t.content,"outboundId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewDataSource=function(t){e.checkParameterAndType(t.content,"dataSource","object");return c(t)};a.create_app_removeDataSource=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");return c(t)};a.create_app_changeDataSource=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");e.checkEntityPropertyChange(t.content);return c(t)};var o={BEGINNING:"BEGINNING",END:"END"};a.create_app_addAnnotationsToOData=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");e.checkParameterAndType(t.content,"annotations","array");e.checkParameterAndType(t.content,"dataSource","object");return c(t)};a.create_app_setTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.title");return e})};a.create_app_setSubTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.subTitle");return e})};a.create_app_setShortTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.shortTitle");return e})};a.create_app_setDescription=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.description");return e})};a.create_app_setInfo=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.info");return e})};a.create_app_setAch=function(t){e.checkParameterAndType(t.content,"ach","string");return c(t)};a.create_app_setDestination=function(t){e.checkParameterAndType(t.content,"destination","object");return c(t)};a.create_app_setKeywords=function(t){e.checkParameterAndType(t.content,"keywords","array");return c(t)};a.create_app_addTechnicalAttributes=function(t){e.checkParameterAndType(t.content,"technicalAttributes","array");return c(t)};a.create_app_removeTechnicalAttributes=function(t){e.checkParameterAndType(t.content,"technicalAttributes","array");return c(t)};a.create_app_addCdsViews=function(t){e.checkParameterAndType(t.content,"cdsViews","array");return c(t)};a.create_app_removeCdsViews=function(t){e.checkParameterAndType(t.content,"cdsViews","array");return c(t)};a.create_flp_setConfig=function(t){e.checkParameterAndType(t.content,"config","object");return c(t)};a.create_ui5_addNewModel=function(t){e.checkParameterAndType(t.content,"model","object");return c(t)};a.create_ui5_removeModel=function(t){e.checkParameterAndType(t.content,"modelId","string");return c(t)};a.create_ui5_addNewModelEnhanceWith=function(t){e.checkParameterAndType(t.content,"modelId","string");return c(t)};a.create_ui5_replaceComponentUsage=function(t){e.checkParameterAndType(t.content,"componentUsageId","string");e.checkParameterAndType(t.content,"componentUsage","object");return c(t)};a.create_ui5_addLibraries=function(t){e.checkParameterAndType(t.content,"libraries","object");return c(t)};a.create_ui5_addComponentUsages=function(t){e.checkParameterAndType(t.content,"componentUsages","object");return c(t)};a.create_ui5_setMinUI5Version=function(t){e.checkParameterAndType(t.content,"minUI5Version",["string","array"]);return c(t)};a.create_smb_addNamespace=function(t){e.checkParameterAndType(t.content,"smartBusinessApp","object");return c(t)};a.create_smb_changeNamespace=function(t){e.checkParameterAndType(t.content,"smartBusinessApp","object");return c(t)};a.create_ui_generic_app_setMainPage=function(t){e.checkParameterAndType(t.content,"page","object");return c(t)};a.create_ui_setIcon=function(t){e.checkParameterAndType(t.content,"icon","string");return c(t)};a.create_ui_setDeviceTypes=function(t){e.checkParameterAndType(t.content,"deviceTypes","object");return c(t)};a.create_url_setUri=function(t){e.checkParameterAndType(t.content,"uri","string");return c(t)};a.create_fiori_setRegistrationIds=function(t){e.checkParameterAndType(t.content,"registrationIds","array");return c(t)};a.create_ui5_setFlexExtensionPointEnabled=function(t){e.checkParameterAndType(t.content,"flexExtensionPointEnabled","boolean");e.checkParameterAndType(t,"changeType","string");return c(t)};a.create_ui5_changeModel=function(t){e.checkParameterAndType(t.content,"modelId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_fiori_setAbstract=function(t){e.checkParameterAndType(t.content,"abstract","boolean");e.checkParameterAndType(t,"changeType","string");return c(t)};a.create_fe_changePageConfiguration=function(t){e.checkParameterAndType(t.content,"page","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_fe_addNewPage=function(t){e.checkParameterAndType(t.content.sourcePage,"id","string");e.checkParameterAndType(t.content.sourcePage,"navigationSource","string");e.checkParameterAndType(t.content.targetPage,"id","string");e.checkParameterAndType(t.content.targetPage,"type","string");e.checkParameterAndType(t.content.targetPage,"name","string");e.checkParameterAndType(t.content.targetPage,"routePattern","string");e.checkParameterAndType(t.content.targetPage,"settings","object");e.checkParameterAndType(t.content.targetPage.settings,"contextPath","string");e.checkParameterAndType(t.content.targetPage.settings,"pageLayout","string");e.checkParameterAndType(t.content.targetPage.settings,"controlConfiguration","object");return c(t)};a.create_ui_generic_app_changePageConfiguration=function(n){e.checkParameterAndType(n.content,"parentPage","object");e.checkEntityPropertyChange(n.content);return c(n).then(function(e){e.fileName=t.createDefaultFileName("appdescr_ui_gen_app_changePageConfig");return Promise.resolve(e)})};a.create_ui_generic_app_addNewObjectPage=function(t){e.checkParameterAndType(t.content,"parentPage","object");e.checkChildPageChange(t.content);return c(t)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/BackendConnector", ["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(e,t,n,r,i,s){"use strict";function a(e){var t={};if(e.parentVersion!==undefined){t.parentVersion=e.parentVersion}if(this.isLanguageInfoRequired){r.addLanguageInfo(t)}var n=r.getUrl(this.ROUTES.CHANGES,e,t);delete e.fileName;delete t["sap-language"];var s=r.getUrl(this.ROUTES.TOKEN,e,t);var a=i.getRequestOptions(this.initialConnector,s,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return i.sendRequest(n,e.method,a)}function o(e){e.fileName=e.flexObject.fileName;return a.call(this,e)}var l=e({},t,{xsrfToken:null,reset(e){var t=["reference","generator","layer"];var n=s(e,t);if(e.selectorIds){n.selector=e.selectorIds}if(e.changeTypes){n.changeType=e.changeTypes}delete e.reference;var a=r.getUrl(this.ROUTES.CHANGES,e,n);var o=r.getUrl(this.ROUTES.TOKEN,e);var l=i.getRequestOptions(this.initialConnector,o);return i.sendRequest(a,"DELETE",l)},write(e){e.method="POST";return a.call(this,e).then(function(e){if(e.response&&!Array.isArray(e.response)){e.response=[e.response]}return e})},update(e){e.method="PUT";return o.call(this,e)},remove(e){var t={namespace:e.flexObject.namespace};if(e.parentVersion!==undefined){t.parentVersion=e.parentVersion}e.fileName=e.flexObject.fileName;var n=r.getUrl(this.ROUTES.CHANGES,e,t);delete e.fileName;var s=r.getUrl(this.ROUTES.TOKEN,e);var a=i.getRequestOptions(this.initialConnector,s,undefined,"application/json; charset=utf-8","json");return i.sendRequest(n,"DELETE",a)}});l.initialConnector=n;return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/BtpServiceConnector", ["sap/base/util/merge","sap/ui/fl/Layer","sap/ui/fl/write/_internal/connectors/KeyUserConnector","sap/ui/fl/initial/_internal/connectors/BtpServiceConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(e,n,t,s,i,a){"use strict";const r=e({},t,{layers:[n.CUSTOMER,n.PUBLIC,n.USER],ROUTES:{CONDENSE:`${s.ROOT}/actions/condense`,CHANGES:`${s.ROOT}/changes`,SETTINGS:`${s.ROOT}/settings`,TOKEN:`${s.ROOT}/settings`,VERSIONS:{GET:`${s.ROOT}/versions`,ACTIVATE:`${s.ROOT}/versions/activate`,DISCARD:`${s.ROOT}/versions/draft`,PUBLISH:`${s.ROOT}/versions/publish`},TRANSLATION:{UPLOAD:`${s.ROOT}/translation/texts`,DOWNLOAD:`${s.ROOT}/translation/texts`,GET_SOURCELANGUAGE:`${s.ROOT}/translation/sourcelanguages`},CONTEXTS:`${s.ROOT}/contexts`,SEEN_FEATURES:`${s.ROOT}/seenFeatures`},async getSeenFeatureIds(e){const n=i.getUrl(this.ROUTES.SEEN_FEATURES,e);const t=await i.sendRequest(n,"GET",{initialConnector:s});return t.response?.seenFeatureIds},async setSeenFeatureIds(e){const n={seenFeatureIds:e.seenFeatureIds};const t=i.getUrl(this.ROUTES.SEEN_FEATURES,e);const r=await a.sendRequest(t,"PUT",{tokenUrl:this.ROUTES.TOKEN,initialConnector:s,payload:JSON.stringify(n),dataType:"json",contentType:"application/json; charset=utf-8"});return r.response?.seenFeatureIds},condense(e){const n={};if(e.parentVersion!==undefined){n.parentVersion=e.parentVersion}if(this.isLanguageInfoRequired){i.addLanguageInfo(n)}const t=i.getUrl(this.ROUTES.CONDENSE,e,n);const r=a.getRequestOptions(s,this.ROUTES.TOKEN,e.flexObjects,"application/json; charset=utf-8","json");return a.sendRequest(t,"POST",r)}});r.initialConnector=s;return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/JsObjectConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var r={_itemsStoredAsObjects:true,_items:{},setItem(e,t){r._items[e]=t},removeItem(e){delete r._items[e]},clear(){r._items={}},getItem(e){return r._items[e]},getItems(){return r._items}};var i=e({},t,{storage:r});i.loadFeatures=function(...r){return t.loadFeatures.apply(this,r).then(function(t){return e({isPublicLayerAvailable:true,isVariantAdaptationEnabled:true},t)})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/KeyUserConnector", ["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/Layer","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/KeyUserConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/base/util/restricted/_pick","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox"],function(e,t,n,r,s,i,a,o,u,l,S,c){"use strict";var E="/flex/keyuser";var R=e({},r,{layers:[n.CUSTOMER,n.PUBLIC],ROUTES:{CHANGES:`${E+s.API_VERSION}/changes/`,SETTINGS:`${E+s.API_VERSION}/settings`,TOKEN:`${E+s.API_VERSION}/settings`,VERSIONS:{GET:`${E+s.API_VERSION}/versions/`,ACTIVATE:`${E+s.API_VERSION}/versions/activate/`,DISCARD:`${E+s.API_VERSION}/versions/draft/`,PUBLISH:`${E+s.API_VERSION}/versions/publish/`},TRANSLATION:{UPLOAD:`${E+s.API_VERSION}/translation/texts`,DOWNLOAD:`${E+s.API_VERSION}/translation/texts/`,GET_SOURCELANGUAGE:`${E+s.API_VERSION}/translation/sourcelanguages/`},CONTEXTS:`${E+s.API_VERSION}/contexts/`},isLanguageInfoRequired:true,getContexts(e){var t=["type","$skip","$filter"];var n=o(e,t);var r=i.getUrl(this.ROUTES.CONTEXTS,e,n);return i.sendRequest(r,"GET",{initialConnector:s}).then(function(e){return e.response})},loadContextDescriptions(e){var t={};i.addLanguageInfo(t);T.call(this,e);var n=i.getUrl(this.ROUTES.CONTEXTS,e,t);e.payload=JSON.stringify(e.flexObjects);e.dataType="json";e.contentType="application/json; charset=utf-8";return a.sendRequest(n,"POST",e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},getFlexInfo(e){return u.getByReference(e.reference)}});function T(e){e.initialConnector=s;e.tokenUrl=this.ROUTES.TOKEN}function O(e){var t={title:e.title};e.payload=JSON.stringify(t);e.dataType="json";e.contentType="application/json; charset=utf-8"}function g(e){e.version=e.versionNumber.toString();delete e.versionNumber;return e}R.versions={load(e){T.call(this,e);var t={};i.addLanguageInfo(t);t.limit=e.limit;var n=i.getUrl(this.ROUTES.VERSIONS.GET,e,t);return i.sendRequest(n,"GET",e).then(function(e){return e.response.versions.map(function(e){return g(e)})})},activate(e){T.call(this,e);O(e);var t={version:e.version};i.addLanguageInfo(t);var n=i.getUrl(this.ROUTES.VERSIONS.ACTIVATE,e,t);return a.sendRequest(n,"POST",e).then(function(e){var t=e.response;return g(t)})},discardDraft(e){T.call(this,e);var t=i.getUrl(this.ROUTES.VERSIONS.DISCARD,e);return a.sendRequest(t,"DELETE",e)},publish(e){var n=t.getResourceBundleFor("sap.ui.fl");var r=function(t){l.hide();var r=n.getText("MSG_CF_PUBLISH_ERROR",t?[t.message||t]:undefined);var s=n.getText("HEADER_TRANSPORT_ERROR");S.error(`publish version error${t}`);c.show(r,{icon:c.Icon.ERROR,title:s,styleClass:e.styleClass});return"Error"};T.call(this,e);var s={version:e.version};var o=i.getUrl(this.ROUTES.VERSIONS.PUBLISH,e,s);return a.sendRequest(o,"POST",e).then(function(){l.hide();return n.getText("MSG_CF_PUBLISH_SUCCESS")}).catch(r)}};R.translation={getTexts(e){T.call(this,e);var t=o(e,["sourceLanguage","targetLanguage"]);var n=i.getUrl(this.ROUTES.TRANSLATION.DOWNLOAD,e,t);return i.sendRequest(n,"GET",e).then(function(e){return e.response})},getSourceLanguages(e){T.call(this,e);var t={};var n=i.getUrl(this.ROUTES.TRANSLATION.GET_SOURCELANGUAGE,e,t);return i.sendRequest(n,"GET",e).then(function(e){return e&&e.response&&e.response.sourceLanguages?e.response.sourceLanguages:[]})},postTranslationTexts(e){T.call(this,e);var t=i.getUrl(this.ROUTES.TRANSLATION.UPLOAD,e,{});return i.sendRequest(t,"POST",e)}};R.initialConnector=s;return R});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/LocalStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,a){"use strict";var t=e({},a,{storage:window.localStorage});t.loadFeatures=function(...t){return a.loadFeatures.apply(this,t).then(function(a){return e({isPublicLayerAvailable:true,isPublicFlVariantEnabled:true,isVariantAdaptationEnabled:true,isCondensingEnabled:false},a)})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/LrepConnector", ["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox","sap/base/util/restricted/_pick"],function(e,t,r,n,a,s,i,o,l,u,c,p,f,d,T){"use strict";var g={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",CONDENSE:"/actions/condense/",VARIANTS:"/variants/",TOKEN:"/actions/getcsrftoken/",APPVARIANTS:"/appdescr_variants/",APPVARIANTS_OVERVIEW:"/app_variant_overview/",UI2PERSONALIZATION:"/ui2personalization/",CONTEXTS:"/flex/contexts/",VERSIONS:{GET:"/flex/versions/",ACTIVATE:"/flex/versions/activate/",DISCARD:"/flex/versions/draft/",PUBLISH:"/flex/versions/publish/"},CONTEXT_BASED_ADAPTATION:"/flex/apps/",MANI_FIRST_SUPPORTED:"/sap/bc/ui2/app_index/ui5_app_mani_first_supported",SEEN_FEATURES:"/seen_features/"};var E="/adaptations/";var v=function(e){var t;if(e.isLegacyVariant){t=g.VARIANTS}else if(e.isAppVariant){t=g.APPVARIANTS}else if(e.isContextSharing){t=g.CONTEXTS}else if(e.isCondensingEnabled){t=g.CONDENSE}else if(e.isContextBasedAdaptationEnabled){t=g.CONTEXT_BASED_ADAPTATION+e.appId+E}else{t=g.CHANGES}var r=e.transport?{changelist:e.transport}:{};if(e.skipIam){r.skipIam=e.skipIam}if(e.parentVersion){r.parentVersion=e.parentVersion}a.addSAPLogonLanguageInfo(r);n._addClientInfo(r);if(e.flexObject&&!e.isAppVariant){e.fileName=e.flexObject.fileName}var i=a.getUrl(t,e,r);delete e.reference;delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return s.sendRequest(i,e.method,l)};var O=function(e){var t=e.getDefinition().layer===l.VENDOR?e.getPackage():"";return{package:t,namespace:e.getNamespace(),name:e.getDefinition().fileName,type:e.getDefinition().fileType}};var R=function(e){var t;if(e.transport){t=Promise.resolve({transport:e.transport})}else if(e.isForSmartBusiness){return Promise.resolve()}else{var r=O(e.appVariant);t=(new i).openTransportSelection(r)}return t.then(function(e){if(e==="cancel"){return Promise.reject("cancel")}if(e&&e.transport!==undefined){return e.transport}return Promise.reject(new Error("Transport information could not be determined"))})};function S(e){e.version=e.versionId;delete e.versionId;return e}return e({},r,{initialConnector:n,layers:n.layers,reset(e){p.show(0);var t=[];var r=Promise.resolve();if(e.layer!==l.USER){t=e.changes;r=o.getInstance().then(function(r){if(!r.isProductiveSystem()){return(new i).setTransports(t,c.getComponentById(e.reference)).then(function(){t.some(function(t){if(t.getRequest()){e.changelist=t.getRequest();return true}return false})})}})}return r.then(function(){p.show(0);var t=["reference","layer","changelist","generator"];var r=T(e,t);n._addClientInfo(r);if(e.selectorIds){r.selector=e.selectorIds}if(e.changeTypes){r.changeType=e.changeTypes}delete e.reference;var i=a.getUrl(g.CHANGES,e,r);var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o);return s.sendRequest(i,"DELETE",l).then(function(e){if(e&&e.response){e.response.forEach(function(e){e.fileName=e.name;delete e.name})}p.hide();return e}).catch(function(e){p.hide();return Promise.reject(e)})})},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var n=function(t){p.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error: ${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.transportDialogSettings.styleClass});return"Error"};var a=new i;return a.openTransportSelection(null,e.transportDialogSettings.rootControl,e.transportDialogSettings.styleClass).then(function(t){if(a.checkTransportInfo(t)){p.show(0);var n={reference:e.reference,layer:e.layer};return a._prepareChangesForTransport(t,e.localChanges,e.appVariantDescriptors,n).then(function(){p.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(n)},getFlexInfo(e){var t=["layer"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.FLEX_INFO,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},getContexts(e){var t=["type","$skip","$filter"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.CONTEXTS,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},loadContextDescriptions(e){e.method="POST";e.isContextSharing=true;return v(e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},async getSeenFeatureIds(e){const t={};n._addClientInfo(t);const r=a.getUrl(g.SEEN_FEATURES,e,t);const s=await a.sendRequest(r,"GET",{initialConnector:n});return s.response?.seenFeatureIds||[]},async setSeenFeatureIds(e){const t={seenFeatureIds:e.seenFeatureIds};const r={};n._addClientInfo(r);const i=a.getUrl(g.SEEN_FEATURES,e,r);const o=a.getUrl(g.TOKEN,e);const l=s.getRequestOptions(n,o,t,"application/json; charset=utf-8","json");const u=await s.sendRequest(i,"PUT",l);return u.response?.seenFeatureIds},write(e){e.method="POST";return v(e)},condense(e){const t=e.flexObjects;const r={};function n(e,n,a,s,i){r[n]||={namespace:n,layer:t.layer};r[n][e]||={};r[n][e][a]||=[];if(e==="delete"||e==="reorder"){r[n][e][a].push(s)}else{r[n][e][a].push({[s]:i[s]||i})}}["create","reorder","update","delete"].forEach(r=>{const a=t[r];if(a){Object.keys(a).forEach(t=>{a[t].forEach(a=>{const s=a.fileName||(typeof a==="object"?Object.keys(a)[0]:a);var i=a[s]?.namespace||a[t]?.namespace;if(!i){const t=e.allChanges.find(e=>e.getId()===s);i=t?t.getNamespace():undefined}if(i){n(r,i,t,s,a)}})})}});e.flexObjects=Object.values(r);e.method="POST";e.isCondensingEnabled=true;return v(e)},update(e){if(e.flexObject.fileType==="variant"){e.isLegacyVariant=true}e.method="PUT";return v(e)},remove(e){var t={namespace:e.flexObject.namespace,layer:e.flexObject.layer};if(e.transport){t.changelist=e.transport}if(e.parentVersion){t.parentVersion=e.parentVersion}n._addClientInfo(t);e.fileName=e.flexObject.fileName;var r=e.flexObject.fileType==="variant"?g.VARIANTS:g.CHANGES;var i=a.getUrl(r,e,t);i=decodeURIComponent(i);delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)},appVariant:{getManifirstSupport(e){var t=`${g.MANI_FIRST_SUPPORTED}/?id=${e.appId}`;return a.sendRequest(t,"GET",{initialConnector:n}).then(function(e){return e.response})},getManifest(e){var t=e.appVarUrl;var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},load(e){var t=a.getUrl(g.APPVARIANTS,e);var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},create(e){e.method="POST";e.isAppVariant=true;return v(e)},assignCatalogs(e){var t={};t.action=e.action;delete e.action;t.assignFromAppId=e.assignFromAppId;delete e.assignFromAppId;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},unassignCatalogs(e){var t={};t.action=e.action;delete e.action;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},update(e){return R(e).then(function(t){if(t){e.transport=t}delete e.isForSmartBusiness;e.method="PUT";e.isAppVariant=true;return v(e)})},remove(e){return R(e).then(function(t){var r={};if(t){r.changelist=t}delete e.isForSmartBusiness;var i=a.getUrl(g.APPVARIANTS,e,r);delete e.reference;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)})},list(e){var t={};t.layer=e.layer;t["sap.app/id"]=e.reference;delete e.layer;delete e.reference;var r=a.getUrl(g.APPVARIANTS_OVERVIEW,e,t);var i=s.getRequestOptions(n,undefined,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"GET",i)}},contextBasedAdaptation:{create(e){e.isContextBasedAdaptationEnabled=true;e.method="POST";return v(e)},reorder(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";return v(e)},update(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";e.reference=e.adaptationId;return v(e)},load(e){var t=["version"];var r=T(e,t);n._addClientInfo(r);e.reference=e.appId+E;var s=a.getUrl(g.CONTEXT_BASED_ADAPTATION,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},remove(e){e.isContextBasedAdaptationEnabled=true;e.method="DELETE";e.reference=e.adaptationId;return v(e)}},ui2Personalization:{create(e){e.initialConnector=this.initialConnector;var t=u.getLrepUrl();var r=s.getRequestOptions(n,t+g.TOKEN,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");var a=t+g.UI2PERSONALIZATION;return s.sendRequest(a,"PUT",r)},remove(e){e.initialConnector=this.initialConnector;var t=a.getUrl(g.UI2PERSONALIZATION,{url:u.getLrepUrl()},{reference:e.reference,containerkey:e.containerKey,itemname:e.itemName});return s.sendRequest(t,"DELETE")}},versions:{load(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r={};a.addSAPLogonLanguageInfo(r);r.limit=e.limit;var i=a.getUrl(g.VERSIONS.GET,e,r);return s.sendRequest(i,"GET",t).then(function(e){return e.response.versions.map(function(e){return S(e)})})},activate(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e),{title:e.title},"application/json; charset=utf-8","json");var r={version:e.version};a.addSAPLogonLanguageInfo(r);var i=a.getUrl(g.VERSIONS.ACTIVATE,e,r);return s.sendRequest(i,"POST",t).then(function(e){var t=e.response;return S(t)})},discardDraft(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r=a.getUrl(g.VERSIONS.DISCARD,e);return s.sendRequest(r,"DELETE",t)},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var o=function(t){p.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.styleClass});return"Error"};var l=new i;return l.openTransportSelection(null,e.rootControl,e.styleClass,false).then(function(t){if(l.checkTransportInfo(t)){p.show(0);if(!t.transport){return Promise.reject(new Error("no transport provided as attribute of mParameters"))}if(!e.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}if(!e.version){return Promise.reject(new Error("no version provided as attribute of mParameters"))}var i={transport:t.transport,version:e.version};var o=a.getUrl(g.VERSIONS.PUBLISH,{url:u.getLrepUrl(),reference:e.reference},i);var c=a.getUrl(g.TOKEN,{url:u.getLrepUrl()});var f=s.getRequestOptions(n,c,undefined,"application/json; charset=utf-8","json");return s.sendRequest(o,"POST",f).then(function(){p.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(o)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/NeoLrepConnector", ["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/NeoLrepConnector"],function(e,t,n){"use strict";return e({},t,{initialConnector:n,layers:n.layers,isContextSharingEnabled(){return Promise.resolve(false)},loadContextDescriptions(){return Promise.reject("loadContextsDescriptions is not implemented")},getContexts(){return Promise.reject("getContexts is not implemented")},contextBasedAdaptation:{create(){return Promise.reject("contextBasedAdaptation.create is not implemented")},reorder(){return Promise.reject("contextBasedAdaptation.reorder is not implemented")},load(){return Promise.reject("contextBasedAdaptation.load is not implemented")}}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/ObjectPathConnector", ["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/LoaderExtensions"],function(e,t,r,n){"use strict";var s;return e({},t,{layers:[],setJsonPath(e){s=e},loadFlexData(e){const t=s||e.path;if(t){return n.loadResource({dataType:"json",url:t,async:true}).then(function(e){return{...r.getEmptyFlexDataResponse(),...e}})}return Promise.resolve()},loadFeatures(e){var t=s||e.path;if(t){return n.loadResource({dataType:"json",url:t,async:true}).then(function(e,t){t.componentClassName=e;return t.settings||{}}.bind(null,e.flexReference))}return Promise.resolve({})},loadVariantsAuthors(){return Promise.resolve({})}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/ObjectStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var r=e({},t,{oStorage:undefined});r.storage=r.oStorage;return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/PersonalizationConnector", ["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/PersonalizationConnector"],function(n,e,a){"use strict";var i="/flex/personalization";var r="/v1";var t=n({},e,{layers:a.layers,ROUTES:{CHANGES:`${i+r}/changes/`,TOKEN:`${i+r}/actions/getcsrftoken`}});t.initialConnector=a;return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/SessionStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var a=e({},t,{storage:window.sessionStorage});a.loadFeatures=function(...a){return t.loadFeatures.apply(this,a).then(function(t){return e({isPublicLayerAvailable:true,isPublicFlVariantEnabled:true,isVariantAdaptationEnabled:true},t)})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/controlVariants/ControlVariantWriteUtils", ["sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/flexState/FlexObjectManager"],function(e,n,t){"use strict";const a={};a.deleteVariant=function(a,r,s){if(!n.getInstanceOrUndef()?.isCondensingEnabled()){return[]}const i={reference:a,vmReference:r,vReference:s};const c=e.getVariantManagementChanges(i);const l=e.getControlChangesForVariant({...i,includeReferencedChanges:false});const f=e.getVariant(i).instance;const o=e.getVariantChangesForVariant(i);const g=[f,...c,...o,...l];t.deleteFlexObjects({reference:a,flexObjects:g});return g};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/delegates/ODataV2ReadDelegate", ["sap/ui/model/ListBinding"],function(e){"use strict";function t(e){return!!(e&&e.type&&e.type.toLowerCase().indexOf("edm")!==0)}function n(e,t){if(!e){return false}const n=e.getBindingInfo(t);const o=n&&n.path;if(!o){return false}return o.indexOf("/")===0}function o(e,t,n){let o;if(t){o=e.getBindingInfo(n);if(typeof o.model==="string"&&o.model!==""){o=undefined}}else{o=e.getBindingContext()}return o}function a(t,n,o,a){const i={name:t.name,bindingPath:t.name,entityType:n.name};const r=t["com.sap.vocabularies.Common.v1.Label"];i.label=r&&r.String;const s=t["com.sap.vocabularies.Common.v1.QuickInfo"];i.tooltip=s&&s.String;const c=t["com.sap.vocabularies.UI.v1.Hidden"];i.hideFromReveal=!!c&&c.Bool==="true";if(!i.hideFromReveal){const n=t["com.sap.vocabularies.Common.v1.FieldControl"];if(n&&n.EnumMember){i.hideFromReveal=n.EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden"}else{const t=n&&n.Path;if(t){const n=o.getBinding(a)instanceof e;if(!n){const e=o.getBindingContext().getProperty(t);i.hideFromReveal=e===0}}}}return i}function i(e,n,o,i){const r=e.property.map(e=>e["sap:field-control"]).filter(Boolean);const s=e=>!r.includes(e.name);const c=e.property.map(r=>{const c=a(r,e,o,i);if(t(r)){const t=n.getODataComplexType(r.type);if(t){c.properties=t.property.map(t=>{const n=a(t,e,o,i);n.bindingPath=`${r.name}/${t.name}`;n.referencedComplexPropertyName=c.label||c.name;return n}).filter(s)}}return c});if(e.navigationProperty){const t=e.navigationProperty.map(t=>{const o=n.getODataAssociationEnd(e,t.name)?.type;return{name:t.name,entityType:o,bindingPath:t.name,unsupported:true}});c.push(...t)}return c.filter(s)}function r(e,t,a){if(a?.path){return a?.path}return n(e,t)?o(e,true,t)?.path:o(e,false,t)?.getPath()}async function s(e,t){const n=e.getModel(t?.modelName);if(n&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].includes(n.getMetadata().getName())){const e=n.getMetaModel();await e.loaded();return e}return null}function c(e,t){const n=e.getMetaContext(t);return n.getObject()}function l(e,t,n){const o=e.getMetadata().getAggregation();if(o){const a=e.getBindingInfo(o.name);const i=a&&a.template;if(i){const a=e.getBindingPath(o.name);const i=t.getODataAssociationEnd(n,a);const r=i&&i.type;if(r){const e=t.getODataEntityType(r);n=e}}}return n}async function m(e,t,n){const o=await s(e,n);let a=[];if(o){const s=r(e,t,n);if(s){let n=c(o,s);n=l(e,o,n);a=i(n,o,e,t)}}return a}var u={};u.getPropertyInfo=function(e){return m(e.element,e.aggregationName,e.payload)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate", ["sap/ui/base/Object"],function(e){"use strict";function a(e){if(e&&e.$Type){if(e.$Type.toLowerCase().indexOf("edm")!==0){return true}}return false}function t(e,a){return a.some(function(a){if(e.startsWith(a)){return true}})}function r(r,i,o,n,v,u,s){var l={name:r,bindingPath:r,entityType:n};var d=o["@com.sap.vocabularies.UI.v1.DataFieldDefault"];var p=d&&d.Label||o["@com.sap.vocabularies.Common.v1.Label"];l.label=p||`[LABEL_MISSING: ${r}]`;var c=o["@com.sap.vocabularies.UI.v1.Hidden"];l.hideFromReveal=c;if(c&&c.$Path){l.hideFromReveal=v.getBindingContext().getProperty(c.$Path)}var m;if(!l.hideFromReveal){m=o["@com.sap.vocabularies.Common.v1.FieldControl"];if(m){l.hideFromReveal=m.$EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden"}}m=o["@com.sap.vocabularies.Common.v1.FieldControl"];var f=m&&m.Path;if(f&&!l.hideFromReveal){var g=e.isObjectA(v.getBinding(u),"sap/ui/model/ListBinding");if(!g){var b=v.getBindingContext().getProperty(f);l.hideFromReveal=b===0}}if(d&&(d.$Type==="com.sap.vocabularies.UI.v1.DataFieldForAction"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldForIntentBasedNavigation"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldWithAction"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldWithIntentBasedNavigation")){l.unsupported=true}if(t(r,s)||a(i)){l.unsupported=true}return l}function i(e,a,t,i,o){var n=[];var v="";var u=[];var s;for(v in e){s=e[v];if(s.$kind==="NavigationProperty"){u.push(v)}}for(v in e){s=e[v];if(s.$kind==="Property"){var l=t.getObject(`/${a}/${v}@`);var d=r(v,s,l,a,i,o,u);n.push(d)}}return n}function o(e,a){if(a.path){return a.path}var t=e.getBindingContext();if(t){return t.getPath()}}function n(e,a,t){var r=e.getModel(t.modelName);if(r){if(r.isA("sap.ui.model.odata.v4.ODataModel")){var n=r.getMetaModel();var v=o(e,t);if(v){var u=n.getMetaContext(v);var s=u.getObject();var l=u.getObject(s.$Type);return i(l,s.$Type,n,e,a)}}}return Promise.resolve([])}var v={getPropertyInfo(e){return Promise.resolve().then(function(){return n(e.element,e.aggregationName,e.payload)})}};return v});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/write/_internal/extensionPoint/Processor", ["sap/ui/fl/apply/_internal/extensionPoint/Processor","sap/base/util/merge"],function(n,t){"use strict";function e(i,o){var r=t({defaultContent:[]},i);return n.registerExtensionPoint(r).then(n.createDefaultContent.bind(this,i,o,e,[])).then(n.addDefaultContentToExtensionPointInfo.bind(this,r,o))}var i={applyExtensionPoint(n){return e(n,false)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess", ["sap/ui/util/openWindow","sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory","sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation"],function(n,t,e){"use strict";var i=null;var r=null;function u(){if(!r){return t.getInstance(i).then(function(n){r=n;return n})}return Promise.resolve(r)}var o={};o.getTexts=function(){return u(i).then(function(n){return n.getTexts().then(function(n){return n})})};o.isExtensibilityEnabled=function(n){return u(n).then(function(n){return n.getNavigationUri().then(function(n){return Boolean(n)})})};o.getExtensionData=function(){return u(i).then(function(n){return n.getExtensionData().then(function(n){return n})})};o.onControlSelected=function(n){if(n!==i){i=n;r=null}};o.onTriggerCreateExtensionData=function(t,e,i){return u().then(function(t){return t.getNavigationUri(i).then(function(t){if(t){n(t,"_blank")}})})};o.reset=function(){i=null;r=null};o.isServiceOutdated=function(n){return e.isServiceOutdated(n)};o.setServiceValid=function(n){e.setServiceValid(n)};o.setServiceInvalid=function(n){e.setServiceInvalid(n)};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant", ["sap/ui/base/Object"],function(e){"use strict";var t=e.extend("sap.ui.fl.write._internal.fieldExtensibility.ABAPExtensibilityVariant",{_sServiceUri:null,_mBindingInfo:null,_mServiceInfo:null,constructor:function(e,t,i){this._sServiceUri=e;this._mBindingInfo=i;this._mServiceInfo=t;this._oExtensionDataPromise=this._determineExtensionData()},getExtensionData(){return Promise.resolve(null)},getMetadata(){return this.getMetadata()},getNavigationUri(){return Promise.resolve(null)},getTexts(){return Promise.resolve(null)},isActive(){return Promise.resolve(true)}});t.prototype._determineExtensionData=function(){return Promise.resolve(null)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory", ["sap/base/Log","sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/Utils","sap/ui/fl/write/_internal/fieldExtensibility/UriParser"],function(e,r,t,i,n,a){"use strict";var s={};var u=new r;function o(e){return Promise.all([n.getBoundEntitySet(e),n.getBoundEntityType(e)]).then(function(e){return{entitySetName:e[0],entityTypeName:e[1]}})}function l(r){e.error("Error occurred:");if(r){if(Array.isArray(r.errorMessages)){r.errorMessages.forEach(function(r){e.error(r.text)})}else{e.error(r)}}}function f(e,r){try{var n=a.parseServiceUri(e);var s=new t(e,n,r);var o=new i(e,n,r);return Promise.all([s.isActive(),o.isActive()]).then(function(e){var r=u;if(e[0]===true){r=s}else if(e[1]===true){r=o}return r}).catch(function(e){l(e);return Promise.resolve(u)})}catch(e){l(e);return Promise.resolve(u)}}function c(e,r){if(s[e]){return s[e][r.entityTypeName]}return null}function y(e,r,t){s[e]||={};s[e][r.entityTypeName]=t}function v(e,r){var t=n.getServiceUri(e);var i=c(t,r);if(!i){return f(t,r).then(function(e){y(t,r,e);return Promise.resolve(e)})}return Promise.resolve(i)}var P={};P.getInstance=function(e){if(n.checkControlPrerequisites(e)){return o(e).then(function(r){return v(e,r).then(function(e){return e.getInterface()})}).catch(function(e){l(e);return Promise.resolve(u.getInterface())})}return Promise.resolve(u.getInterface())};P.reset=function(){s={}};return P});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/Utils"],function(t,e){"use strict";var i="/sap/opu/odata/sap/APS_PREDEFINED_FIELD_SRV/GetExtensionDataByResourcePath";var n={semanticObject:"PredefinedCustomField",action:"configure"};var s=t.extend("sap.ui.fl.write._internal.fieldExtensibility.MultiTenantABAPExtensibilityVariant",{getExtensionData(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return this._convertExtensionData(t)}return null}.bind(this))},getNavigationUri(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return e.getNavigationUriForIntent({target:n,params:{businessObjectNodeName:t.BusinessObjectNodeName,cdsEntityName:t.CdsEntityName,serviceVersion:this._mServiceInfo.serviceVersion,serviceName:this._mServiceInfo.serviceName}})}return null}.bind(this))},getTexts(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return{tooltip:e.getText("BTN_ADD_FIELD"),headerText:e.getText("BUSINESS_OBJECT_NODE_TITLE")}}return null}.bind(this))},isActive(){return this._oExtensionDataPromise.then(function(t){return this._containsData(t)}.bind(this))},_containsData(t){return Boolean(t&&t.BusinessObjectNodeName&&t.CdsEntityName)},_convertExtensionData(t){return{extensionData:[{businessContext:t.BusinessObjectNodeName,description:t.BusinessObjectNodeDescription}]}},_determineExtensionData(){return new Promise(function(t,s){e.isNavigationSupportedForIntents([n]).then(function(n){var a=n.some(function(t){return t===true});if(a){e.executeRequest(i,{ResourcePath:this._sServiceUri,EntitySetName:this._mBindingInfo.entitySetName}).then(function(e){if(e.errorOccurred===false){t(this._extractExtensionDataFromResponse(e.result))}else{s(e)}}.bind(this))}else{t(null)}}.bind(this))}.bind(this))},_extractExtensionDataFromResponse(t){return t.GetExtensionDataByResourcePath}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation", ["sap/ui/fl/Utils","sap/ui/util/Storage","sap/ui/fl/write/_internal/fieldExtensibility/UriParser"],function(e,r,t){"use strict";var i={};var n="sap.ui.fl.fieldExt.Access";var u=1*7*24*60*60*1e3;function a(){return Date.now()}function f(){return i.getLocalStorage()}function s(){return f()&&f().isSupported()}function c(){if(!s()){return{}}var e=f().get(n);if(!e){return{}}return JSON.parse(e)}function o(e){return e.expirationDate<=a()}function l(e){return c()[e.serviceKey]||null}function v(e){var r=a()+u;var t=S();var i=p(e);return{serviceKey:t.getName()+t.getClient()+i.serviceName+i.serviceVersion,expirationDate:r}}function p(e){if(typeof e==="string"){return t.parseServiceUri(e)}return e}function g(){return S()}function S(){var r=e.getUshellContainer();return r&&r.getLogonSystem()}function d(e){if(s()){f().put(n,JSON.stringify(e))}}i.getLocalStorage=function(){return new r(r.Type.local)};i.isServiceOutdated=function(e){if(!g()){return false}var r=l(v(e));if(r){if(o(r)){this.setServiceValid(e);return false}return true}return false};i.setServiceValid=function(e){if(g()){var r=c();delete r[v(e).serviceKey];d(r)}};i.setServiceInvalid=function(e){if(g()){var r=c();var t=v(e);r[t.serviceKey]=t;d(r)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/UriParser","sap/ui/fl/write/_internal/fieldExtensibility/Utils"],function(t,e,n){"use strict";const s="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";const i="/sap/opu/odata/sap/ui_sclg_implementation/";const o="sap.ui.fl.write._internal.fieldExtensibility.SingleTenantABAPExtensibilityVariant";const r={CustomField:"CUSTOM_FIELD",CustomLogic:"CUSTOM_LOGIC"};const u={[r.CustomField]:{semanticObject:"CustomField",action:"manage"},[r.CustomLogic]:{semanticObject:"CustomLogic",action:"develop"}};const a={BusinessContextTitle:"BUSINESS_CONTEXT_TITLE",MenuButtonLabel:"BTN_CREATE",MenuButtonTooltip:"BTN_FREP_CCF",MenuCreateCustomField:"BTN_MENU_CREATE_CUSTOM_FIELD",StandaloneCreateCustomField:"BTN_CREATE_CUSTOM_FIELD",MenuCreateCustomLogic:"BTN_MENU_CREATE_CUSTOM_LOGIC",StandaloneCreateCustomLogic:"BTN_CREATE_CUSTOM_LOGIC"};const c=t.extend(o,{async getExtensionData(){const t=await this._oExtensionDataPromise;if(t===null){return null}if(!this._containsExtensionData(t)){return null}const e=[];for(const n of t.businessContexts){const t={description:n.BusinessContextDescription,businessContext:n.BusinessContext};e.push(t)}return{extensionData:e}},async getNavigationUri(t){const e=t??await this._getFallbackNavigationActionKey();if(e===null){return null}const s=await this._oExtensionDataPromise;if(s===null){return null}if(!this._containsExtensionData(s)){return null}const i=s.navigationSupported;if(!i[e]){return null}const o=s.businessContexts;const r=o.map(function(t){return t.BusinessContext});const a=s.businessObjects;const c=a.map(function(t){return t.SAPObjectNodeType});return n.getNavigationUriForIntent({target:u[e],params:{businessContexts:r,businessObjects:c,serviceVersion:this._mServiceInfo.serviceVersion,serviceName:this._mServiceInfo.serviceName,entityType:this._mBindingInfo.entityTypeName}})},async getTexts(){const t=await this._oExtensionDataPromise;if(t===null){return null}if(!this._containsExtensionData(t)){return null}const e=await this._getMenuButtonLabel();const s=await this._getMenuButtonTooltip();const i=await this._getMenuButtonOptions();if(i.length===1){i[0].text=e;i[0].tooltip=s}return{headerText:n.getText(a.BusinessContextTitle),buttonText:e,tooltip:s,options:i}},async isActive(){const t=await this._oExtensionDataPromise;if(t===null){return false}return this._containsExtensionData(t)},_containsExtensionData({businessContexts:t,businessObjects:e}){const n=Array.isArray(t)&&t.length>0;const s=Array.isArray(e)&&e.length>0;return n||s},async _determineExtensionData(){let[t,e]=await n.isNavigationSupportedForIntents([u[r.CustomField],u[r.CustomLogic]]);if(!(t||e)){return null}const s=await this._getBusinessContexts();if(s===null){return null}const i=await this._getBusinessObjects(s);if(i===null){return null}const{supportsStructuralEnhancements:o,supportsLogicEnhancements:a}=this._determineSupportedExtensibilityTypes(s,i);t&&=o;e&&=a;if(!(t||e)){return null}return{businessContexts:s,businessObjects:i,navigationSupported:{[r.CustomField]:t,[r.CustomLogic]:e}}},async _getBusinessContexts(){const t=this._getBusinessContextDataServiceUrl();const s=this._getBusinessContextDataServiceParameters();const i=await n.executeRequest(t,s);if(i.statusCode===404&&this._mServiceInfo.serviceType===e.mServiceType.v4){return null}if(i.errorOccurred!==false){throw i}const o=i.result.results||[];for(const t of o){t.SupportsLogicEnhancements??=true;t.SupportsStructuralEnhancements??=true}return o},async _getBusinessObjects(t){const e=this._getBusinessObjectDataServiceUrl();const s=this._getBusinessObjectDataServiceParameters(t);const i=await n.executeRequest(e,s);if(i.errorOccurred!==false){return[]}return i.result.results||[]},_determineSupportedExtensibilityTypes(t,e){const n=t.some(t=>t.SupportsLogicEnhancements)||e.some(t=>t.SupportsLogicEnhancements);const s=t.some(t=>t.SupportsStructuralEnhancements)||e.some(t=>t.SupportsStructuralEnhancements);return{supportsLogicEnhancements:n,supportsStructuralEnhancements:s}},_getBusinessContextDataServiceParameters(){const t={EntitySetName:"",EntityTypeName:this._mBindingInfo.entityTypeName};if(this._mServiceInfo.serviceType===e.mServiceType.v4){t.ResourcePath=`${e.sODataV4ResourcePathPrefix+this._mServiceInfo.serviceName}/${this._mServiceInfo.serviceVersion}`}else{t.ServiceName=this._mServiceInfo.serviceName;t.ServiceVersion=this._mServiceInfo.serviceVersion}return t},_getBusinessContextDataServiceUrl(){if(this._mServiceInfo.serviceType===e.mServiceType.v4){return`${s}GetBusinessContextsByResourcePath`}return`${s}GetBusinessContextsByEntityType`},_getBusinessObjectDataServiceParameters(t){const e=t.map(t=>t.BusinessContext);return{BusinessContexts:JSON.stringify(e)}},_getBusinessObjectDataServiceUrl(){return`${i}getSONTsFromBusinessContexts`},async _getMenuButtonText(t){const e=await this._oExtensionDataPromise;if(e===null){return undefined}const s=e.navigationSupported;let i=0;for(const t in s){if(!s[t]){continue}i++}if(i>1){return n.getText(t)}if(i===0){return undefined}if(s[r.CustomField]){return n.getText(a.StandaloneCreateCustomField)}if(s[r.CustomLogic]){return n.getText(a.StandaloneCreateCustomLogic)}return undefined},_getMenuButtonLabel(){return this._getMenuButtonText(a.MenuButtonLabel)},_getMenuButtonTooltip(){return this._getMenuButtonText(a.MenuButtonTooltip)},async _getMenuButtonOptions(){const t=await this._oExtensionDataPromise;if(t===null){return[]}const e=t.navigationSupported;const n=[];if(e[r.CustomField]){n.push(this._getFieldsMenuButtonOption())}if(e[r.CustomLogic]){n.push(this._getLogicMenuButtonOption())}return n},_getFieldsMenuButtonOption(){const t=n.getText(a.MenuCreateCustomField);return{actionKey:r.CustomField,text:t,tooltip:t}},_getLogicMenuButtonOption(){const t=n.getText(a.MenuCreateCustomLogic);return{actionKey:r.CustomLogic,text:t,tooltip:t}},async _getFallbackNavigationActionKey(){const t=await this._oExtensionDataPromise;if(t===null){return null}const e=t.navigationSupported;if(!this._containsExtensionData(t)){return null}for(const t in e){if(!e[t]){continue}return t}return null}});return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/UriParser", [],function(){"use strict";var e={v2:"v2",v4:"v4"};function r(r){var i=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var a=/([^;]+);v=(\d{1,4})/i;var s="sap/opu/odata";var t;if(r.toLowerCase().indexOf(s)!==-1){var v=r.match(i);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV2ServiceUri: Malformed service URI (Invalid service name)")}if(v[1].toLowerCase()!=="sap"){t=`/${v[1]}/${v[2]}`}else{[,,t]=v}}else{if(r.length>0&&r.lastIndexOf("/")+1===r.length){r=r.substring(0,r.length-1)}t=r.substring(r.lastIndexOf("/")+1)}if(t.indexOf(";v=")!==-1){var n=t.match(a);if(!n||n.length!==3){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV2ServiceUri: Malformed service URI (Invalid version)")}return{serviceName:n[1],serviceVersion:n[2],serviceType:e.v2}}return{serviceName:t,serviceVersion:"0001",serviceType:e.v2}}function i(r){var i=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var a=r.match(i);if(!a||a.length!==4){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV4ServiceUri: Malformed service URI")}var s=a[1].split("/");s.splice(0,3);var t=/(\d{1,4})/i;var v=a[2].match(t);return{serviceName:s.join("/"),serviceVersion:v[1],serviceType:e.v4}}var a={};a.mServiceType=e;a.sODataV4ResourcePathPrefix="sap/opu/odata4/";a.parseServiceUri=function(e){if(e.toLowerCase().indexOf(this.sODataV4ResourcePathPrefix)!==-1){return i(e)}return r(e)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/Utils", ["sap/base/Log","sap/base/security/encodeURL","sap/ui/core/Lib","sap/ui/fl/Utils","sap/ui/thirdparty/jquery"],function(e,t,r,n,jQuery){"use strict";var a={v2:"v2",v4:"v4"};function i(e){if(e&&e.split){var t=e.split(".");return t[t.length-1]}return null}function u(e){var t=[];try{var r=JSON.parse(e.responseText);if(r&&r.error&&r.error.message&&r.error.message.value){t.push({severity:"error",text:r.error.message.value})}else{t.push({severity:"error",text:e.responseText})}}catch(e){}return t}function o(t){var r=i(v(t));if(!r){var n=t.getBindingContext?t.getBindingContext():null;if(n&&n.getPath){r=n.getPath()}}if(!r){e.warning("Control not bound to a path")}return r}function s(e,t,r){return e.metadataLoaded().then(function(){var n=null;if(r){var a=e.oMetadata._getEntityTypeByName(r);n=e.oMetadata._getEntitySetByType(a)}n||=e.oMetadata._getEntitySetByPath(t);return n?n.name:null})}function l(e,t){var r=e.getMetaModel();var n=r.getMetaPath(t);return r.requestObject(n).then(function(e){var t=r.fetchEntityContainer().getResult();var n=t[t.$EntityContainer];var a=Object.keys(n).filter(function(t){return n[t]===e});return a.length>0&&a[0]})}function c(e,t,r){return e.metadataLoaded().then(function(){var n=null;if(r){n=e.oMetadata._getEntityTypeByName(r)}n||=e.oMetadata._getEntityTypeByPath(t);return n?n.name:null})}function f(e,t){var r=e.getMetaModel();var n=r.getMetaPath(t);return r.requestObject(n).then(function(e){return i(e.$Type)})}function v(e){return e.getEntitySet?e.getEntitySet():null}function g(e){return e.getEntityType?e.getEntityType():null}function d(t){var r=null;if(t&&t.sServiceUrl){r=t.sServiceUrl}if(!r){e.warning("Model has no Service Uri")}return r}function p(e){if(e){if(e.isA("sap.ui.model.odata.v2.ODataModel")){return a.v2}else if(e.isA("sap.ui.model.odata.v4.ODataModel")){return a.v4}}return null}function y(t){if(t){var r=t.getModel?t.getModel():null;if(p(r)){return r}e.warning("Unsupported model type or protocol");return null}e.warning("No Control passed");return null}var h={};h.checkControlPrerequisites=function(t){if(t){var r=y(t);var n=d(r);var a=o(t);var i=g(t);return Boolean(n&&(a||i))}e.warning("No Control passed");return false};h.executeRequest=function(e,t){var r=e+this.getUriParameters(t);return new Promise(function(e){var t={type:"GET",async:true,dataType:"json"};jQuery.ajax(r,t).done(function(t){var r=t&&t.d;e({errorOccurred:false,result:r})}).fail(function(t){e({errorOccurred:true,errorMessages:u(t),statusCode:t.status})})})};h.getBoundEntitySet=function(e){var t=y(e);var r=p(t);if(r===a.v2){return s(t,o(e),g(e))}else if(r===a.v4){return l(t,o(e))}return Promise.resolve(null)};h.getBoundEntityType=function(e){var t=y(e);var r=p(t);if(r===a.v2){return c(t,o(e),g(e))}else if(r===a.v4){return f(t,o(e))}return Promise.resolve(null)};h.getNavigationUriForIntent=async function(e){const t=await n.getUShellService("Navigation");return t?.getHref?.(e)||null};h.getServiceUri=function(e){var t=y(e);return d(t)};h.getText=function(e){return r.getResourceBundleFor("sap.ui.fl").getText(e)};h.getUriParameters=function(e){if(!e){return""}var r=[];Object.keys(e).forEach(function(n){if(n){var a=`'${t(e[n]||"")}'`;r.push(`${t(n)}=${a}`)}});return r.length===0?"":`?${r.join("&")}`};h.isNavigationSupportedForIntents=async function(e){const t=await n.getUShellService("Navigation");if(t?.isNavigationSupported){const r=await t.isNavigationSupported(e);return r.map(e=>e&&e.supported===true)}return e.map(()=>false)};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess", ["sap/ui/core/Lib","sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation","sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog"],function(e,t,i){"use strict";var n=null;var r=null;var a=e.getResourceBundleFor("sap.ui.fl");var o={};o.getTexts=function(){return{headerText:a.getText("BUSINESS_CONTEXT_TITLE"),tooltip:a.getText("BTN_ADD_FIELD")}};o.isExtensibilityEnabled=function(){return true};o.getExtensionData=function(){var e=n.getModel();var t=n.getBindingContext().getPath();if(e.isA("sap.ui.model.odata.v2.ODataModel")){return Promise.reject()}else if(e.isA("sap.ui.model.odata.v4.ODataModel")){var i=e.getMetaModel();var r=i.getMetaPath(t);return i.requestObject(r).then(function(e){var t=i.fetchEntityContainer().getResult();var n=t[t.$EntityContainer];return{boundEntitySet:e,entityTypes:Object.values(n).map(function(e){return e.$Type}).filter(Boolean)}})}return Promise.reject()};o.onControlSelected=function(e){n=e};o.onTriggerCreateExtensionData=function(e,t){r||=new i;r.open(e,t)};o.isServiceOutdated=function(e){return t.isServiceOutdated(e)};o.setServiceValid=function(e){t.setServiceValid(e)};o.setServiceInvalid=function(e){t.setServiceInvalid(e)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/Lib","sap/m/MessageToast","sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig","sap/base/util/ObjectPath","sap/base/util/deepClone","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel"],function(e,t,n,o,i,s,a,l,r){"use strict";const d=n.getResourceBundleFor("sap.ui.fl");function u(e,t,n){const o=e.getContent()[0];o.setJson(a(t));o.setConfig(i(n));return o}function c(e){if(!e||!e.element){return{}}const t=a(e);if(!s.get(["element","@Common.Label"],t)){const e=s.get(["element","name"],t);s.set(["element","@Common.Label"],e,t)}const n=s.get(["element","@assert.range"],t);if(s.get(["element","type"],t)==="cds.String"&&Array.isArray(n)){s.set(["element","enum"],n.reduce(function(e,t){e[t]={};return e},{}),t);s.set(["element","@assert.range"],true,t)}if(t.element.annotations){t.element={...t.element,...t.element.annotations};delete t.element.annotations}const o={extend:t.extend,elements:{}};o.elements[t.element.name]=t.element;return o}const p=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.dialog.CustomFieldCAPDialog",{metadata:{library:"sap.ui.fl",properties:{_dialog:{type:"any",visibility:"hidden"}}}});p.prototype.open=function(e,n){const o={element:{name:"NewField",type:"cds.String"},extend:e.boundEntitySet.$Type};const i=this.getProperty("_dialog");if(i){this._oEditor.setJson(a(o));i.open()}else{t.load({name:"sap.ui.fl.write._internal.fieldExtensibility.cap.dialog.CustomFieldCAPDialog",controller:this}).then(function(t){this._oDialogModel=new r({isValid:true});this._oDialogModel.setDefaultBindingMode("OneWay");t.setModel(this._oDialogModel,"dialog");t.setModel(new l({bundle:d}),"i18n");t.addStyleClass(n);this.setProperty("_dialog",t);this._oJson=a(o);this._oEditor=u(t,this._oJson,{entityTypes:e.entityTypes});this._oEditor.attachJsonChange(function(e){this._oJson=e.getParameter("json")}.bind(this));this._oEditor.attachValidationErrorChange(function(e){const t=e.getParameter("hasError");this._oDialogModel.setData({isValid:!t})}.bind(this));t.open()}.bind(this))}};p.prototype.exit=function(){const e=this.getProperty("_dialog");if(e){e.destroy()}if(this.oEditor){this.oEditor.destroy()}};p.prototype.onSave=function(){const e=c(this._oJson);const t={extensions:[JSON.stringify(e)]};const n=new Promise(function(e,n){const o=new XMLHttpRequest;o.open("POST","/-/cds/extensibility/addExtension");o.setRequestHeader("Content-Type","application/json");o.onload=function(){if(o.status>=200&&o.status<400){e(o.response)}else{n({status:o.status,message:o.statusText})}};o.send(JSON.stringify(t))});n.then(function(){o.show(d.getText("CAP_ADD_FIELD_SUCCESS"))});this.getProperty("_dialog").close()};p.prototype.onCancel=function(){this.getProperty("_dialog").close()};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig", [],function(){"use strict";return function(e){return{context:"/element",properties:{entityType:{tags:["general"],label:"Entity Type",path:"/extend",type:"select",items:(e.entityTypes||[]).map(function(e){return{key:e}}),allowCustomValues:false,validators:{isRequired:{type:"isRequired"}}},name:{tags:["general"],label:"Name",path:"name",type:"string",validators:{isRequired:{type:"isRequired"},namePattern:{type:"pattern",errorMessage:"CAP_ERR_WHITESPACE",config:{pattern:"^\\S+$"}}}},label:{tags:["general"],label:"Label",path:"@Common.Label",type:"string",placeholder:"{/element/name}"},type:{tags:["general"],label:"Type",path:"type",type:"select",items:[{key:"cds.String",title:"String"},{key:"cds.Integer",title:"Integer"},{key:"cds.Decimal",title:"Decimal"},{key:"cds.Date",title:"Date"},{key:"cds.Time",title:"Time"},{key:"cds.DateTime",title:"DateTime"},{key:"cds.Boolean",title:"Boolean"}],allowCustomValues:false,validators:{isRequired:{type:"isRequired"}}},numberPrecision:{tags:["general"],label:"Precision",path:"precision",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.Decimal' }"},numberScale:{tags:["general"],label:"Scale",path:"scale",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.Decimal' }"},stringLength:{tags:["general"],label:"Length",path:"length",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.String' }"},defaultValue:{tags:["general"],label:"Default",path:"default/val",defaultValue:"",type:"{/element/type}"},readonly:{tags:["validation"],label:"Readonly",path:"@readonly",type:"bool"},mandatory:{tags:["validation"],label:"Mandatory",path:"@mandatory",type:"bool"},format:{tags:["validation"],label:"Format",path:"@assert.format",type:"string",defaultValue:"",visible:"{= ${/element/type} === 'cds.String' }"},stringRange:{tags:["validation"],label:"Allowed Values",path:"@assert.range",type:"list",visible:"{= ${/element/type} === 'cds.String' }",active:"{= ${/element/type} === 'cds.String' }"},arrayRange:{tags:["validation"],label:"Range",path:"@assert.range",type:"range",rangeType:"{/element/type}",visible:"{= ${/element/type} === 'cds.Integer' || ${/element/type} === 'cds.Decimal' || ${/element/type} === 'cds.DateTime' || ${/element/type} === 'cds.Date' || ${/element/type} === 'cds.Time'}",active:"{= ${/element/type} === 'cds.Integer' || ${/element/type} === 'cds.Decimal' || ${/element/type} === 'cds.DateTime' || ${/element/type} === 'cds.Date' || ${/element/type} === 'cds.Time'}"},annotations:{tags:["advanced"],label:"Additional Annotations",allowedTypes:["json"],path:"annotations",type:"map",allowTypeChange:false,addItemLabelI18n:"CAP_ADD_FIELD_EDITOR.ANNOTATION",defaultType:"json"}},layout:{form:{groups:[{label:"General",items:[{type:"tag",value:"general"}]},{label:"Input Validation",items:[{type:"tag",value:"validation"}]},{label:"Advanced",items:[{type:"tag",value:"advanced"}]}]}},propertyEditors:{select:"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor",string:"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor",integer:"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor",number:"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor",map:"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor",list:"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor",bool:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor",range:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor",json:"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor","cds.String":"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor","cds.Integer":"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor","cds.Decimal":"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","cds.Date":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","cds.Time":"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor","cds.DateTime":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor","cds.Boolean":"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor"},i18n:"sap/ui/fl/messagebundle.properties",validators:{isRequired:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired"},propertyEditorConfigs:{"cds.Date":{pattern:"YYYY-MM-dd"},"cds.DateTime":{pattern:"YYYY-MM-dd'T'HH:mm:ss'Z'"}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.booleanEditor.BooleanEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.booleanEditor.BooleanEditor",metadata:{library:"sap.ui.fl"},renderer:e.getMetadata().getRenderer().render});t.prototype._onChange=function(e){var t=!!e.getParameter("selected");this.setValue(t)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/model/json/JSONModel"],function(t,e){"use strict";const i=t.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.rangeEditor.RangeEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.rangeEditor.RangeEditor",metadata:{library:"sap.ui.fl"},renderer:t.getMetadata().getRenderer().render});i.configMetadata={...t.configMetadata,rangeType:{defaultValue:"string"}};i.prototype.init=function(...i){t.prototype.init.apply(this,i);this._oContentModel=new e;this._oContentModel.setDefaultBindingMode("OneWay");this.setModel(this._oContentModel,"contentModel")};i.prototype.getExpectedWrapperCount=function(){return 2};i.prototype.setConfig=function(...e){t.prototype.setConfig.apply(this,e);this.setValue(this.getValue())};i.prototype.setValue=function(...e){const[i]=e;t.prototype.setValue.apply(this,e);const o={type:this.getConfig().rangeType};const n=Array.isArray(i)?i:[];this._oContentModel.setData([{value:n[0],config:{index:0,...o}},{value:n[1],config:{index:1,...o}}])};i.prototype._onChange=function(t){const e=t.getParameter("value");const i=t.getSource().getConfig().index;const o=(this.getValue()||[]).slice();o[i]=e;this.setValue(o)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(t,e,r){"use strict";const i=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.timeEditor.TimeEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.timeEditor.TimeEditor",metadata:{library:"sap.ui.fl"},renderer:t.getMetadata().getRenderer().render});i.configMetadata={...e.configMetadata,pattern:{defaultValue:"HH:mm:ss"},utc:{defaultValue:false}};i.prototype.getDefaultValidators=function(){return{...e.prototype.getDefaultValidators.call(this)}};i.prototype.getFormatterInstance=function(t){return r.getTimeInstance(t||{pattern:"HH:mm:ss.SSSS"})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired", [],function(){"use strict";return{async:false,errorMessage:"CAP_ERR_REQUIRED",validate(e){return e===false||e===0||!!e}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState", ["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(e,n,t){"use strict";const o={};o.setPersonalization=async function(n){if(!n||!n.reference||!n.containerKey||!n.itemName||!n.content){throw new Error("not all mandatory properties were provided for the storage of the personalization")}const o=await t.ui2Personalization.create({flexObjects:n});const a=e.getUI2Personalization(o.response.reference);a[o.response.containerKey]||=[];a[o.response.containerKey].push(o.response);e.updateStorageResponse(o.response.reference,[{type:"ui2",newData:a}])};o.deletePersonalization=async function(o,a,r){if(!o||!a||!r){throw new Error("not all mandatory properties were provided for the storage of the personalization")}await t.ui2Personalization.remove({reference:o,containerKey:a,itemName:r});const i=e.getUI2Personalization(o);const s=i[a];const p=n.getPersonalization(o,a,r);const l=s.indexOf(p);s.splice(l,1);e.updateStorageResponse(o,[{type:"ui2",newData:i}])};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/changes/UIChangeManager", ["sap/base/util/restricted/_omit","sap/ui/core/Component","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/flexState/FlexObjectManager"],function(e,t,n,a,l,i,r,p,s){"use strict";const o={};function c(e,a,l){i.addRuntimeChangeToMap(a,l,r.getLiveDependencyMap(e));if(l instanceof t){const t=l.getPropagationListeners().every(e=>!e._bIsSapUiFlFlexControllerApplyChangesOnControl);if(t){const t=n.applyAllChangesForControl.bind(n,l,e);t._bIsSapUiFlFlexControllerApplyChangesOnControl=true;l.addPropagationListener(t)}}}function f(e){return typeof e.isA==="function"&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")?e:a.createFromFileContent(e)}o.addDirtyChanges=function(e,t,n){const a=p.addDirtyFlexObjects(e,t.map(f));a.forEach(t=>{c(e,t,n)});return a};o.restoreDeletedChanges=function(e,t,n){s.restoreDeletedFlexObjects({reference:e,flexObjects:t});const a=t.filter(e=>e.getState()!==l.LifecycleState.PERSISTED);a.forEach(t=>{c(e,t,n)})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/Adaptations", [],function(){"use strict";return{UrlParameter:"sap-ui-fl-adaptation",Type:{Default:"DEFAULT",Baseline:"BASELINE",ContextBased:"CONTEXTBASED"}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/AppVariantWriteAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/_internal/Versions"],function(e,r,t,i,a){"use strict";var n=function(r,i){if(!i.layer){return Promise.reject("Layer must be provided")}i.reference=e.getFlexReferenceForSelector(i.selector);i.url="/sap/bc/lrep";return t.appVariant[r](i)};var s={saveAs(t){if(!t.layer){return Promise.reject("Layer must be provided")}if(!t.id){return Promise.reject("App variant ID must be provided")}t.reference=e.getFlexReferenceForSelector(t.selector);return i.isVersioningEnabled(t.layer).then(function(e){if(e){t.parentVersion=a.getVersionsModel(t).getProperty("/displayedVersion")}return r.saveAs(t)})},deleteAppVariant(t){if(!t.layer){return Promise.reject("Layer must be provided")}t.id=e.getFlexReferenceForSelector(t.selector);return r.deleteAppVariant(t)},listAllAppVariants(e){if(!e.layer){return Promise.reject("Layer must be provided")}return n("list",e)},getManifest(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.appVarUrl){return Promise.reject("appVarUrl must be provided")}return t.appVariant.getManifest(e)},assignCatalogs(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.assignFromAppId){return Promise.reject("assignFromAppId must be provided")}if(!e.action){return Promise.reject("action must be provided")}return n("assignCatalogs",e)},unassignCatalogs(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.action){return Promise.reject("action must be provided")}return n("unassignCatalogs",e)}};return s});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/BusinessNetworkAPI", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/Utils"],(e,a,t,r,n,i,l,c)=>{"use strict";const o={};o.createAndSaveVariant=async function(e){const r={id:e.id,variantManagementReference:e.variantManagementReference,variantReference:e.variantReference||e.variantManagementReference,variantName:e.variantName,layer:e.layer||l.CUSTOMER,user:e.author||a.DEFAULT_AUTHOR,reference:e.reference,generator:e.generator||"BusinessNetworkAPI.createVariant"};const n=[t.createFlVariant(r).convertToFileContent()];const c=await i.write({layer:r.layer,flexObjects:n});return c.response};o.createDefaultVariant=function(a){const i=c.getAppComponentForControl(a.control);const o=r.getFlexReferenceForControl(i);const s=i.getLocalId(a.control.getId())||a.control.getId();const f={id:a.id,variantManagementReference:s,variantReference:a.variantReference||s,variantName:a.variantName,reference:o,layer:a.layer||l.USER,generator:a.generator||"BusinessNetworkAPI.createDefaultVariant"};const u=[t.createFlVariant(f)];u.push(t.createVariantManagementChange({changeType:"setDefault",layer:f.layer,generator:f.generator,reference:o,selector:e.getSelector(a.control,i),content:{defaultVariant:f.variantReference}}));n.addDirtyFlexObjects(o,u);return u};o.save=function(e){return n.saveFlexObjects({selector:e,includeCtrlVariants:true})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ChangesWriteAPI", ["sap/base/util/restricted/_omit","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/write/_internal/controlVariants/ControlVariantWriteUtils","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Utils"],function(e,t,n,a,r,o,i,c,p,l,s,g,f,h,u,d,C,m,y,S,D,v){"use strict";var F={};function T(e){let n;if(e.changeSpecificData.layer){n=e.changeSpecificData.layer;delete e.changeSpecificData.layer}const a={changeType:e.changeSpecificData.changeType,content:e.changeSpecificData.content};if(e.changeSpecificData.texts){a.texts=e.changeSpecificData.texts}if(e.changeSpecificData.support){a.support={compositeCommand:e.changeSpecificData.support.compositeCommand||""}}if(e.changeSpecificData.adaptationId){a.adaptationId=e.changeSpecificData.adaptationId}return C.createDescriptorInlineChange(a).then(t=>(new u).createNew(e.changeSpecificData.reference,t,n,undefined,e.generator)).catch(e=>{t.error("the change could not be created.",e.message);throw e})}async function x(e){const t=await d.getAnnotationChangeHandler({changeType:e.changeSpecificData.changeType});const a=s.createAnnotationChange(e.changeSpecificData);t.completeChangeContent(a,e.changeSpecificData,{modifier:n,appComponent:e.appComponent});return a}function w(e){const a=s.createUIChange(e.changeSpecificData);return d.getChangeHandler(a.getChangeType(),e.controlType,e.selector,n,a.getLayer()).then(r=>{const o={...e.changeSpecificData};if(o.content){Object.keys(o.content).forEach(e=>{if(!o[e]){o[e]=o.content[e]}else{t.warning(`The property '${e}' is defined both in the change specific data and its content.`)}})}return r.completeChangeContent(a,o,{modifier:n,appComponent:e.appComponent,view:v.getViewForControl(e.selector)})}).then(()=>{a.setState(g.LifecycleState.NEW);return a})}F.create=function(e){const{changeSpecificData:t,selector:r}=e;if(t.changeType==="codeExt"){return s.createControllerExtensionChange(t)}e.appComponent=v.getAppComponentForSelector(r.view||r);if(r?.appId||h.getFlexReferenceForControl(e.appComponent)){t.reference=r?.appId||h.getFlexReferenceForControl(e.appComponent)}const o={layer:t.layer,control:e.appComponent,reference:t.reference};if(S.hasAdaptationsModel(o)){t.adaptationId=S.getDisplayedAdaptationId(o)}if(i.getChangeTypes().includes(t.changeType)){return T(e)}if(e.changeSpecificData.changeType==="deactivateChanges"){return s.createFlexObject(e.changeSpecificData)}if(e.annotationChange){return x(e)}if(r instanceof a){return Promise.resolve(s.createUIChange(t))}if(r.name&&r.view){t.selector={name:r.name,viewSelector:n.getSelector(r.view.getId(),e.appComponent)};return w(e)}const c=r.id||r.getId();t.selector||={};Object.assign(t.selector,n.getSelector(c,e.appComponent));e.controlType=r.controlType||v.getControlType(r);return w(e)};F.apply=function(t){if(!(t.element instanceof r)){return Promise.reject("Please provide an Element")}t.appComponent=v.getAppComponentForSelector(t.element);t.modifier||=n;return c.applyChangeOnControl(t.change,t.element,e(t,["element","change"])).then(function(e){var a=f.getOpenDependentChangesForControl(n.getControlIdBySelector(t.change.getSelector(),t.appComponent),t.appComponent);if(a.length>0){return F.revert({change:t.change,element:t.element}).then(function(){var e=o.getResourceBundleFor("sap.ui.fl");var n=a.map(function(e){return e.getId()}).join(", ");throw Error(e.getText("MSG_DEPENDENT_CHANGE_ERROR",[t.change.getId(),n]))})}return e})};F.revert=function(e){var t=v.getAppComponentForSelector(e.element||{});var a=[];var r={modifier:n,appComponent:t};if(!Array.isArray(e.change)){return p.revertChangeOnControl(e.change,e.element,r)}var o=e.change.slice(0).reverse();return o.reduce(function(t,n){return t.then(function(){return p.revertChangeOnControl(n,e.element,r).then(function(e){a.unshift(e)})})},Promise.resolve()).then(function(){return a})};F.getChangeHandler=function(e){var t=e.controlType||e.modifier?.getControlType(e.element);return l.getChangeHandler({changeType:e.changeType,control:e.element,controlType:t,modifier:e.modifier,layer:e.layer,appDescriptorChange:e.appDescriptorChange,annotationChange:e.annotationChange})};F.deleteVariantsAndRelatedObjects=function(e){if(!e.variantManagementControl?.isA("sap.ui.fl.variants.VariantManagement")){throw new Error("Please provide a valid Variant Management control")}const t=e.variantManagementControl;const a=v.getAppComponentForControl(t);const r=n.getSelector(t,a).id;const o=h.getFlexReferenceForControl(a);const i=D.getDraftFilenames({control:t,layer:e.layer});const c=f.getDirtyFlexObjects(o).map(e=>e.getId());const p=e.variants.filter(e=>i.includes(e)||c.includes(e));return p.map(e=>m.deleteVariant(o,r,e)).flat()};F.restoreDeletedFlexObjects=function(e){y.restoreDeletedFlexObjects(e)};return F});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ContextBasedAdaptationsAPI", ["sap/ui/core/Lib","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions","sap/ui/fl/write/api/Adaptations","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel"],function(e,t,r,n,a,i,o,s,l,d,c,p,u,f,v,y,g){"use strict";var h={};var A;var I=[f.VENDOR,f.PARTNER,f.CUSTOMER_BASE,f.CUSTOMER];var x={};function m(e){var t=a.getFlexReferenceForControl(e);if(!t){throw Error("The application ID could not be determined")}return t}function C(e,t,r){if(r){return c.updateModelFromBackend({reference:t.appId,layer:t.layer}).then(function(){return e})}c.onAllChangesSaved({reference:t.appId,layer:t.layer,contextBasedAdaptation:true});return Promise.resolve(e)}x.initialize=function(t){A||=e.getResourceBundleFor("sap.ui.fl");if(!t.layer){return Promise.reject("No layer was provided")}if(!t.control){return Promise.reject("No control was provided")}var r=m(t.control);t.reference=r;var n=t.layer;if(h&&h[r]&&h[r][n]){return Promise.resolve(h[r][n])}var a;return u.isContextBasedAdaptationAvailable(n).then(function(e){a=e;var r=a?x.load(t):Promise.resolve({adaptations:[]});return r}).then(function(e){var r=o.getByReference(t.reference);var n=e.adaptations[0];if(r.adaptationId){n=e.adaptations.find(function(e){return e.id===r.adaptationId})||n}return x.createModel(e.adaptations,n,a)}).then(function(e){h[r]||={};h[r][n]||={};h[r][n]=e;return h[r][n]})};x.createModel=function(e,t,r){if(!Array.isArray(e)){throw Error("Adaptations model can only be initialized with an array of adaptations")}if(r&&!t){throw Error("Invalid call, must pass displayed adaptation")}if(!r&&e.length){throw Error("Invalid call, must not pass adaptations if feature is disabled")}const n=new g({allAdaptations:[],adaptations:[],count:0,displayedAdaptation:{},contextBasedAdaptationsEnabled:r});n.updateAdaptations=function(e){const t=e.filter(function(e,t){e.rank=t+1;return e.type!==p.Type.Default});n.setProperty("/adaptations",t);n.setProperty("/allAdaptations",e);n.setProperty("/count",t.length);let r=n.getProperty("/displayedAdaptation");const a=e.find(function(e){return!!r&&e.id===r.id});if(a){r={...a};n.setProperty("/displayedAdaptation",r)}n.updateBindings(true)};n.insertAdaptation=function(e){const t=n.getProperty("/allAdaptations");t.splice(e.priority,0,e);delete e.priority;n.updateAdaptations(t)};n.deleteAdaptation=function(){const e=n.getProperty("/displayedAdaptation").rank-1;const t=n.getProperty("/adaptations");const r=n.getProperty("/count");let a;if(r>1){a=t[e+(e===r-1?-1:1)].id}t.splice(e,1);const i=n.getProperty("/allAdaptations").pop();t.push(i);n.updateAdaptations(t);return a};n.switchDisplayedAdaptation=function(e){const t=n.getIndexByAdaptationId(e);const r=t?n.getProperty("/allAdaptations")[t]:n.getProperty("/allAdaptations")[0];n.setProperty("/displayedAdaptation",r);n.updateBindings(true)};n.updateAdaptationContent=function(e){const t=n.getProperty("/allAdaptations");const r=t.find(function(t){return e.adaptationId===t.id});r.title=e.title;r.contexts=e.contexts;const a=r.rank-1;if(a!==e.priority){const r=t.splice(a,1);t.splice(e.priority,0,r[0])}n.updateAdaptations(t)};n.getIndexByAdaptationId=function(e){const t=n.getProperty("/allAdaptations");const r=t.findIndex(function(t){return t.id===e});return r>-1?r:undefined};if(e.length>0){n.updateAdaptations(e);n.setProperty("/displayedAdaptation",t)}return n};x.getAdaptationsModel=function(e){if(!e.layer){throw Error("No layer was provided")}if(!e.control){throw Error("No control was provided")}e.reference=m(e.control);var t=e.reference;var r=e.layer;if(!x.hasAdaptationsModel(e)){throw Error(`Adaptations model for reference '${t}' and layer '${r}' were not initialized.`)}return h[t][r]};x.getDisplayedAdaptationId=function(e){var t=this.getAdaptationsModel(e).getProperty("/displayedAdaptation/id");return t!==p.Type.Default?t:undefined};x.hasAdaptationsModel=function(e){var t=e.reference;var r=e.layer;return h[t]&&h[t][r]};x.adaptationExists=function(e){var t=e.reference;var r=e.layer;return this.hasAdaptationsModel({reference:t,layer:r})&&h[t][r].getProperty("/count")>0};x.clearInstances=function(){h={}};x.refreshAdaptationModel=function(e){this.clearInstances();return this.initialize(e).then(function(e){return e.getProperty("/displayedAdaptation/id")})};function P(e,t){return e.get(t)||t}function V(e,t){return d.contextBasedAdaptation.create({layer:e.layer,flexObject:t,appId:e.appId,parentVersion:_(e)}).then(function(r){var n=this.getAdaptationsModel(e);n.insertAdaptation(t);return C(r,e)}.bind(this))}function w(e,t){return d.write({layer:e.layer,flexObjects:t,transport:"",isLegacyVariant:false,parentVersion:_(e)})}function b(e,t,n){if(n.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=t.filter(function(e){return e.getChangeType()==="updateVariant"&&e.getSelector().variantId===n.getId()});var i=n.clone();a.forEach(r.applyChangeOnVariant.bind(r,i));i.removeAllChanges();i.destroy();return i.mProperties}return e.find(function(e){return e.key===n.getId()})}function j(e,t){var r={};var n=[];e.forEach(function(e){var a=t[e.getId()];if(a.visible){var i=true;var o=Object.keys(a.contexts);o.forEach(function(t){var n=Array.from(a.contexts[t]);n.forEach(function(t){i=false;if(r[t]){r[t].variants.push(e)}else{r[t]={contextBasedAdaptationId:y.createDefaultFileName(),variants:[e]}}})});if(i){n.push(e)}}});return{uniqueContexts:r,unrestrictedViews:n}}function O(e,t,r,n){if(e.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=e.getPersistencyKey();e=s.updateVariant({reference:t.appId,persistencyKey:a,id:e.getId(),layer:t.layer,visible:false,adaptationId:r,forceCreate:true});return e.getChanges().reverse()[0].convertToFileContent()}var i=y.getAppComponentForControl(t.control);var o=n.createVariantChange(e.getVariantManagementReference(),{changeType:"setVisible",visible:false,variantReference:e.getId(),layer:t.layer,appComponent:i,adaptationId:r});return o.convertToFileContent()}function E(e,t,r){var n=e.filter(function(e){return r===e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")&&e.getLayer()===t});return n}function F(e){var t=e.getFileType();if(t==="change"){if(e.getSelector().variantId){return e.getSelector().variantId}if(e.getVariantReference()){return e.getVariantReference()}}else if(t==="ctrl_variant_change"){return e.getVariantId()}return undefined}function B(e){if(e.getFileType()==="ctrl_variant_change"&&e.getChangeType()==="setContexts"){return true}return false}function M(e,t){return t.filter(function(t){var r=F(t);if(B(t)){return false}return!r||e.indexOf(r)<0})}function T(e,t){var r=[];var n=[];var a=new Map;e.forEach(function(e){if(e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")){r.push(e)}else{n.push(e)}});var i=N(r,a,t);var o=S(n,a,t);return i.concat(o).map(function(e){return e.convertToFileContent()})}function N(e,r,n){var a=[];e.forEach(function(e){var i=t.createFromFileContent(e.cloneFileContentWithNewId());i.setAdaptationId(n);i.setContexts();r.set(e.getId(),i.getId());a.push(i)});return a}function S(e,r,n){const a=[];e.forEach(function(e){const i=t.createFromFileContent(e.cloneFileContentWithNewId());const o=i.getContent();if(e.getFileType()==="change"){if(e.getSelector().variantId){const e=i.getSelector();e.variantId=P(r,i.getSelector().variantId);i.setSelector(e)}else if(e.getContent().defaultVariantName){o.defaultVariantName=P(r,i.getContent().defaultVariantName);i.setContent(o)}if(e.getVariantReference()){i.setVariantReference(P(r,i.getVariantReference()))}if(e.getChangeType()==="updateVariant"){delete i.getContent().contexts;if(!Object.keys(i.getContent()).length){return}}}else if(e.getFileType()==="ctrl_variant_change"){i.setVariantId(P(r,i.getVariantId()))}else if(e.getFileType()==="ctrl_variant_management_change"&&e.getContent().defaultVariant){o.defaultVariant=P(r,i.getContent().defaultVariant);i.setContent(o)}i.setAdaptationId(n);a.push(i)});return a}function _(e){return c.getVersionsModel({layer:e.layer,reference:e.appId}).getProperty("/persistedVersion")}function R(e,t,r,n,a){var i={contextBasedAdaptations:[],flexObjects:[]};var o={};e.forEach(function(e){o[e.getId()]=b(t,r,e)});var s=j(e,o);var l=s.uniqueContexts;var d=s.unrestrictedViews;Object.entries(l).forEach(function(t){var o=t[0];var s=t[1];s.variants=s.variants.concat(d);var l=s.contextBasedAdaptationId;var c={id:l,title:A.getText("CBA_MIGRATED_ADAPTATION_TITLE",[o]),contexts:{role:[o]},priority:0};i.contextBasedAdaptations.push(c);var p=s.variants.filter(function(e){return e.getLayer()===f.CUSTOMER});var u=new Map;var v=N(p,u,l);v.forEach(function(e){i.flexObjects.push(e.convertToFileContent())});var y=s.variants.map(function(e){return e.getId()});var g=e.map(function(e){return e.getId()}).filter(function(e){return y.indexOf(e)<0});var h=M(g,r);var I=S(h,u,l);I.forEach(function(e){i.flexObjects.push(e.convertToFileContent())});e.forEach(function(e){if(e.getLayer()!==f.CUSTOMER&&y.indexOf(e.getId())<0){i.flexObjects.push(O(e,n,l,a))}})});e.forEach(function(e){var t=o[e.getId()];var r=d.indexOf(e)<0;if(t.visible===true&&r){i.flexObjects.push(O(e,n,undefined,a))}});return i}function D(){return new Promise(function(e){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(t){e(t)})})}x.migrate=async function(e){e.appId=m(e.control);var t=_(e);e.parentVersion=t;var r=[];var i=n.getAllVariants(a.getFlexReferenceForControl(e.control));var o={contextBasedAdaptation:[],flexObjects:[]};const s=await D();return l.getFlexObjects({selector:e.control,includeManifestChanges:true,includeAnnotationChanges:true,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(e){I.forEach(function(t){r.push(E(e,t,true))});r.push(E(e,f.CUSTOMER,false));return Promise.all(r)}).then(function(t){var r=t.pop();var n=t.flat();o=R(n,i,r,e,s);var a=Promise.resolve();o.contextBasedAdaptations.forEach(function(t){a=a.then(V.bind(this,e,t))}.bind(this));return a}.bind(this)).then(function(){if(o.flexObjects.length>0){return w(e,o.flexObjects)}return Promise.resolve()}).then(function(){return this.refreshAdaptationModel({control:e.control,layer:e.layer})}.bind(this))};x.canMigrate=function(e){var t=x.getAdaptationsModel(e);if(t.getProperty("/count")!==0){return Promise.resolve(false)}return l.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(t){var r=[];I.forEach(function(e){r.push(E(t,e,true))});r=r.flat();var i=n.getAllVariants(a.getFlexReferenceForControl(e.control));return r.some(function(e){var r=b(i,t,e);return r.visible===true&&Object.keys(r.contexts).some(function(e){return r.contexts[e].length!==0})})})};x.create=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}e.contextBasedAdaptation.id=y.createDefaultFileName();e.appId=m(e.control);return V.call(this,e,e.contextBasedAdaptation).then(function(){return l.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true,currentLayer:f.CUSTOMER})}).then(function(t){var r=v.filterChangeOrChangeDefinitionsByCurrentLayer(t,f.CUSTOMER);var n=T(r,e.contextBasedAdaptation.id);return w(e,n)})};x.update=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.update({layer:e.layer,flexObject:e.contextBasedAdaptation,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e)})};x.reorder=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.parameters||!e.parameters.priorities){return Promise.reject("No valid priority list was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.reorder({layer:e.layer,flexObjects:e.parameters,appId:e.appId,parentVersion:_(e)}).then(function(t){return C(t,e)})};x.load=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.load({layer:e.layer,appId:e.appId,version:_(e)}).then(function(e){e||={adaptations:[]};return e})};x.remove=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.remove({layer:e.layer,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e,true)})};return x});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ContextSharingAPI", ["sap/ui/core/Component","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/core/ComponentContainer","sap/ui/fl/Layer","sap/ui/fl/registry/Settings"],function(e,t,n,a,r,i){"use strict";let o=Promise.resolve();var s={async isContextSharingEnabled(e){if(e.layer!==r.CUSTOMER){return false}const a=t.getFlexReferenceForControl(e.variantManagementControl);const o=await i.getInstance();const s=o.isContextSharingEnabled()&&!n.adaptationExists({reference:a,layer:r.CUSTOMER});return s},async createComponent(t){if(await this.isContextSharingEnabled(t)){o=o.then(async t=>{if(t&&!t.isDestroyed()){return t}const n=await e.create({name:"sap.ui.fl.variants.context",id:"contextSharing"});n.showMessageStrip(true);n.setSelectedContexts({role:[]});t=new a("contextSharingContainer",{component:n});await n.getRootControl().oAsyncState.promise;return t});return o}return undefined}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ControlPersonalizationWriteAPI", ["sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,t,n,r,o,a,c,l,i,s,p,f,u,g,d,h,m){"use strict";var C={};function y(e,r){if(!e.changeSpecificData){return Promise.reject(new Error("No changeSpecificData available"))}if(!e.changeSpecificData.changeType){return Promise.reject(new Error("No valid changeType"))}if(!(e.selectorControl instanceof n)){return Promise.reject(new Error("No valid selectorControl"))}var o=e.selectorControl.getMetadata().getName();return s.getChangeHandler(e.changeSpecificData.changeType,o,e.selectorControl,t,r)}function v(e,n,r){var a=o.getRelevantVariantManagementControlId(n,[],r);return t.getSelector(a,e).id}function S(t){e.error(t);return Promise.reject(t)}var I={async add(t){if(!t.changes.length){return Promise.resolve([])}const n=t.changes[0].selectorElement||t.changes[0].selectorControl;const r=m.getAppComponentForControl(n);const o=i.getFlexReference({element:n});const a=r.getModel(l.getVariantModelName());const c=h.USER;const s=[];const p={};function d(){const n=[];const l=[];return t.changes.reduce(function(o,i){return o.then(function(){i.selectorControl=i.selectorElement;return y(i,c)}).then(function(){if(!i.transient&&!t.ignoreVariantManagement){if(!i.changeSpecificData.variantReference){let e;const n=i.selectorControl.getId();e=p[n]||v(r,i.selectorControl,t.useStaticArea);if(!e&&!t.useStaticArea){e=v(r,i.selectorControl,true)}if(e){p[n]=e;const t=a.oData[e].currentVariant;i.changeSpecificData.variantReference=t}}}else{delete i.changeSpecificData.variantReference}i.changeSpecificData={...i.changeSpecificData,developerMode:false,layer:c};return g.create({changeSpecificData:i.changeSpecificData,selector:i.selectorControl})}).then(function(e){if(!i.transient){l.push(e)}n.push({changeInstance:e,selectorControl:i.selectorControl})}).catch(function(t){e.error("A Change was not created successfully. Reason: ",t.message)})},Promise.resolve()).then(function(){f.addDirtyChanges(o,l,r);return n}).catch(function(t){e.error("Changes were not added successfully. Reason: ",t.message)})}function S(t){return t.reduce(function(t,n){return t.then(function(){n.changeInstance.setQueuedForApply();return g.apply({change:n.changeInstance,element:n.selectorControl})}).then(function(e){if(e.success){s.push(n.changeInstance)}else{throw e.error||new Error("ChangesWriteAPI.apply failed with unspecified error")}}).catch(function(t){u.deleteFlexObjects({reference:o,flexObjects:[n.changeInstance]});e.error("A Change was not applied successfully. Reason: ",t.message)})},Promise.resolve())}const I=await d();await S(I);(C[o]||[]).forEach(function(e){e(s)});return s},reset(e){if(!e.selectors||e.selectors.length===0){return S("At least one control ID has to be provided as a parameter")}var t=e.selectors[0].appComponent||m.getAppComponentForControl(e.selectors[0]);if(!t){return S("App Component could not be determined")}var n=e.selectors.map(function(e){var n=e.id||e.getId();var r=t.getLocalId(n);return r||n});return u.resetFlexObjects({layer:h.USER,appComponent:t,selectorIds:n,changeTypes:e.changeTypes})},async restore(e){if(!e||!e.selector){return Promise.reject("No selector was provided")}var n=m.getAppComponentForControl(e.selector);if(!n){return Promise.reject("App Component could not be determined")}const o=i.getFlexReference({element:e.selector});if(c.isInitialized({control:n})){const a=u.removeDirtyFlexObjects({reference:o,layers:h.USER,component:n,control:e.selector,generator:e.generator,changeTypes:e.changeTypes});if(a.length!==0){await r.revertMultipleChanges([...a].reverse(),{appComponent:n,modifier:t,reference:o})}}return undefined},hasDirtyFlexObjects(e){if(!e||!e.selector){throw Error("No selector was provided")}var n=m.getAppComponentForControl(e.selector);if(!n){throw Error("App Component could not be determined")}const r=i.getFlexReference({element:e.selector});var o=a.getDirtyFlexObjects(r);return o.some(function(r){if(r.getLayer()!==h.USER){return false}if(e.generator&&r.getSupportInformation().generator!==e.generator){return false}if(e.changeTypes&&e.changeTypes.indexOf(r.getChangeType())===-1){return false}var o=r.getSelector();return e.selector.getId()===t.getControlIdBySelector(o,n)})},save(e){var t=e.selector.appComponent||m.getAppComponentForControl(e.selector);if(!t){return S("App Component could not be determined")}var n=d.createForControl(t);if(c.isInitialized({control:t})){return n.saveSequenceOfDirtyChanges(e.changes,t)}return Promise.resolve()},buildSelectorFromElementIdAndType(e){var t=m.getAppComponentForControl(e.element);if(!t||!e.elementId||!e.elementType){throw new Error("Not enough information given to build selector.")}return{elementId:e.elementId,elementType:e.elementType,appComponent:t,id:e.elementId,controlType:e.elementType}},isCondensingEnabled(){return p.getInstance().then(function(e){return e.isCondensingEnabled(h.USER)})},attachChangeCreation(e,t){var n=i.getFlexReference({element:e});C[n]=(C[n]||[]).concat(t)},detachChangeCreation(e,t){var n=i.getFlexReference({element:e});if(Array.isArray(C[n])){C[n]=C[n].filter(function(e){return e!==t})}},detachAllChangeCreationListeners(e){if(e){var t=i.getFlexReference({element:e});delete C[t]}else{C={}}}};return I});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/FeaturesAPI", ["sap/ui/fl/initial/api/InitialFlexAPI","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,n,t,a,r){"use strict";var s={isPublishAvailable(){return n.getInstance().then(function(e){return e.isPublishAvailable()||!e.isProductiveSystem()&&e.isSystemWithTransports()})},isSaveAsAvailable(e){return Promise.all([n.getInstance(),r.getUShellService("Navigation")]).then(function(n){var t=n[0];var r=n[1];return t.isAppVariantSaveAsEnabled()&&e===a.CUSTOMER&&r!==undefined}).catch(function(){return false})},isContextBasedAdaptationAvailable(e){return n.getInstance().then(function(n){if(n.isContextBasedAdaptationEnabled()&&e===a.CUSTOMER){return true}return false})},isKeyUser(){return e.isKeyUser()},isVersioningEnabled(e){return n.getInstance().then(function(n){return n.isVersioningEnabled(e)})},isKeyUserTranslationEnabled(e){if(e===a.CUSTOMER){return n.getInstance().then(function(e){return e.isKeyUserTranslationEnabled()})}return Promise.resolve(false)},isContextSharingEnabled(e){if(e!==a.CUSTOMER){return Promise.resolve(false)}return n.getInstance().then(function(n){return n.isContextSharingEnabled({layer:e})})},async isSeenFeaturesAvailable(){const e=await n.getInstance();return e.isSeenFeaturesAvailable()},async getSeenFeatureIds(e){if(!await this.isSeenFeaturesAvailable()){return[]}return t.getSeenFeatureIds(e)},async setSeenFeatureIds(e){if(!await this.isSeenFeaturesAvailable()){return Promise.reject("The backend does not support saving seen features.")}return t.setSeenFeatureIds(e)},isVariantAdaptationEnabled(){const e=n.getInstanceOrUndef();return e?.isVariantAdaptationEnabled()},isLocalResetEnabled(){const e=n.getInstanceOrUndef();return e?.isLocalResetEnabled()},areAnnotationChangesEnabled(){const e=n.getInstanceOrUndef();return e?.isAnnotationChangeEnabled()}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/FieldExtensibility", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess","sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess","sap/ui/base/ManagedObject","sap/ui/fl/Utils"],function(e,n,t,i){"use strict";var r={};var a;function s(r){if(!a){if(!(r instanceof t)){return undefined}var s=i.getAppComponentForControl(r);var o=s&&s.getManifestEntry("/sap.ui5/config")||{};var u=new URLSearchParams(window.location.search);if(o.experimentalCAPScenario||u.get("sap-ui-fl-xx-capScenario")==="true"){a=n}else{a=e}}return a}function o(...e){var n=e.shift();var t=s(...e);if(!t){return Promise.reject("Could not determine field extensibility scenario")}return Promise.resolve(t[n].apply(null,e))}r.onControlSelected=function(e){return o("onControlSelected",e)};r.isExtensibilityEnabled=function(e){return o("isExtensibilityEnabled",e)};r.isServiceOutdated=function(e){return o("isServiceOutdated",e)};r.setServiceValid=function(e){return o("setServiceValid",e)};r.getTexts=function(){return o("getTexts")};r.getExtensionData=function(){return o("getExtensionData")};r.onTriggerCreateExtensionData=function(e,n,t){return o("onTriggerCreateExtensionData",e,n,t)};r._resetCurrentScenario=function(){a=null};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/LocalResetAPI", ["sap/base/util/restricted/_union","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/UIChangesState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils"],function(e,t,n,r,a,i,l,o,s){"use strict";var u={};function c(e,t,i){return r.getAllUIChanges(a.getFlexReferenceForControl(e)).filter(function(e){return e.getFileType()==="change"&&e.getLayer()===t&&e.getState()!==n.LifecycleState.DELETED&&e.getVariantReference()===(i||undefined)})}function f(n){var r=s.getAppComponentForControl(n);var a=[];var i=[];function l(t,r){var o=(r||[]).concat(t);if(t===n||a.includes(t)){a=e(a,o);return true}var s=t.getParent();if(i.includes(t)||!s){i=e(i,o);return false}return l(s,o)}function o(e){return e.getDependentSelectorList().map(function(e){return t.bySelector(e,r)}).filter(Boolean).some(function(e){return l(e)})}return o}u.resetChanges=async function(e,n,r){const a=[];const i=e.slice().reverse();if(!r){a.push(...i.map(function(e){const r=t.bySelector(e.getSelector(),n);return function(){e.setQueuedForRevert();return l.revert({change:e,element:r})}}))}await o.remove({flexObjects:i,selector:n});await s.execPromiseQueueSequentially(a)};u.restoreChanges=async function(e,n,r){const o=a.getFlexReferenceForControl(n);i.restoreDeletedChanges(o,e,n);if(!r){const r=e.map(e=>()=>{const r=t.bySelector(e.getSelector(),n);return l.apply({change:e,element:r,modifier:t})});await s.execPromiseQueueSequentially(r)}};u.getNestedUIChangesForControl=function(e,t){var n=c(e,t.layer,t.currentVariant);var r=f(e);return n.filter(r)};u.isResetEnabled=function(e,t){var n=c(e,t.layer,t.currentVariant);var r=f(e);return n.some(r)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/PersistenceWriteAPI", ["sap/base/util/restricted/_omit","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,n,r,s,a,o,i,l,c,f,u,g,p,h,d,y,x,C){"use strict";var b={};function F(e){return e._getMap&&r.getChangeTypes().includes(e._getMap().changeType)||e.getChangeType&&r.getChangeTypes().includes(e.getChangeType())}function m(e){e.includeCtrlVariants=true;return b._getUIChanges(e).then(function(e){return e.length>0})}b.hasDirtyChanges=function(e){return p.hasDirtyFlexObjects(e)};b.hasHigherLayerChanges=function(e){e.upToLayer||=x.getCurrentLayer();return p.getFlexObjects(e).then(function(t){return t.filter(function(t){return x.isOverLayer(t.getLayer(),e.upToLayer)})}).then(function(t){if(t.length===0){return false}return p.filterHiddenFlexObjects(t,e.reference).length>0})};b.save=async function(e){const t=i.getFlexReferenceForControl(e.selector);let n=c.getByReference(t);n.saveChangeKeepSession=true;c.setByReference(n,t);const r=await p.saveFlexObjects(e);if(r?.length>0){await b.updateResetAndPublishInfo(e)}n=c.getByReference(t);delete n.saveChangeKeepSession;c.setByReference(n,t);return r};b.updateResetAndPublishInfo=async function(e){const[n,r]=await Promise.all([m(e),d.isPublishAvailable()]);const s={isResetEnabled:n,isPublishEnabled:false,allContextsProvided:true};const a=e.layer!==y.USER&&e.layer!==y.PUBLIC;if(a){try{const t=await h.getFlexInfo(e);s.allContextsProvided=t.allContextsProvided!==false;s.isResetEnabled=t.isResetEnabled;s.isPublishEnabled=r&&t.isPublishEnabled}catch(e){t.error(`Sending request to flex/info route failed: ${e.message}`)}}const l=i.getFlexReferenceForControl(e.selector);const f=c.getByReference(l);const u={...f,...s};c.setByReference(u,l);o.setAllContextsProvided(l,u.allContextsProvided)};b.getResetAndPublishInfoFromSession=function(e){var t=i.getFlexReferenceForControl(e)||"true";return JSON.parse(window.sessionStorage.getItem(`sap.ui.fl.info.${t}`))};b.reset=function(t){var n=C.getAppComponentForSelector(t.selector);return p.resetFlexObjects({...e(t,"selector"),appComponent:n})};b.add=function(e){const t=C.getAppComponentForSelector(e.selector);const n=i.getFlexReferenceForSelector(e.selector);function r(e){if(F(e)){return e.store()}if(e instanceof a){return g.addDirtyChanges(n,[e],t)?.[0]}return p.addDirtyFlexObjects(n,[e])?.[0]}if(e.change&&e.flexObjects){throw new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property.")}if(e.change){return r(e.change)}const s=e.flexObjects.some(function(e){return F(e)});if(s){return e.flexObjects.map(r)}const o=[];const l=[];e.flexObjects.forEach(e=>{if(e instanceof a){o.push(e)}else{l.push(e)}});const c=p.addDirtyFlexObjects(n,l);const f=g.addDirtyChanges(n,o,t);return e.flexObjects.map(e=>c.find(t=>t===e)||f.find(t=>t===e))};b.remove=function(e){if(e.change&&e.flexObjects){return Promise.reject(new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property."))}if(!e.selector){return Promise.reject(new Error(`An invalid selector was passed so change could not be removed with id: ${e.change.getId()}`))}const t=C.getAppComponentForSelector(e.selector);if(!t){return Promise.reject(new Error(`Invalid application component for selector, change could not be removed with id: ${e.change.getId()}`))}const r=e.change?[e.change]:e.flexObjects;const a=i.getFlexReferenceForSelector(e.selector);r.forEach(function(e){if(e.isValidForDependencyMap()){const r=n.bySelector(e.getSelector(),t);if(r){s.destroyAppliedCustomData(r,e,n)}}});p.deleteFlexObjects({reference:a,flexObjects:r});return Promise.resolve()};b.getChangesWarning=function(e){return this._getUIChanges(e).then(function(e){var t=e.some(function(e){return e.isChangeFromOtherSystem()});var n=f.getInstanceOrUndef();var r=n&&n.isProductiveSystemWithTransports();var s=e.length===0;var a={showWarning:false};if(t){a={showWarning:true,warningType:"mixedChangesWarning"}}if(r&&s){a={showWarning:true,warningType:"noChangesAndPSystemWarning"}}return a})};b._condense=function(e){return Promise.resolve().then(function(){if(!e.selector){throw Error("An invalid selector was passed")}var t=C.getAppComponentForSelector(e.selector);if(!t){throw Error("Invalid application component for selector")}if(!e.changes||e.changes&&!Array.isArray(e.changes)){throw Error("Invalid array of changes")}return u.condense(t,e.changes)})};b._getUIChanges=function(e){if(e.layer){e.currentLayer=e.layer}e.invalidateCache=false;return p.getFlexObjects(e)};b._getAnnotationChanges=function(e){const t=i.getFlexReferenceForControl(e.control);return o.getAnnotationChanges(t)};b._getFlexObjectsForUser=async function(e){const t=l.getUserId();const n=await b._getUIChanges(e);return n.filter(e=>e.getSupportInformation().user===t)};b.setAdaptationLayer=function(e,t){const n=i.getFlexReferenceForControl(t);const r=c.getByReference(n);r.adaptationLayer=e;c.setByReference(r,n)};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ReloadInfoAPI", ["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/api/Version","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(e,r,t,a,n,i,l,o,s,f,c,u){"use strict";function v(e,r){if(t.getByReference(r).version){return Promise.resolve(false)}return i.isVersioningEnabled(e.layer).then(function(r){return r&&o.isDraftAvailable({control:e.selector,layer:e.layer})})}function d(e,r){var a=t.getByReference(r);var n=e.layer===s.USER;if(n||a.maxLayer&&a.maxLayer===e.layer){return Promise.resolve(false)}return l.hasHigherLayerChanges({selector:e.selector,ignoreMaxLayerParameter:e.ignoreMaxLayerParameter,upToLayer:e.layer,includeCtrlVariants:e.includeCtrlVariants,includeDirtyChanges:true}).then(function(r){return r||g(e)})}function g(e){if(f.isOverLayer(s.USER,e.layer)){return n.checkSVMControlsForDirty(r.getFlexReferenceForControl(e.selector))}return false}async function y(r,a){let n=t.getByReference(a);if(n.initialAllContexts){return false}if(n.allContextsProvided===undefined){const e={selector:r.selector,layer:r.layer};await l.updateResetAndPublishInfo(e);n=t.getByReference(a)}else{e.setAllContextsProvided(a,n.allContextsProvided)}n.initialAllContexts=!n.allContextsProvided;t.setByReference(n,a);return!n.allContextsProvided}function h(e,r){if(!c.getInstanceOrUndef()?.isContextSharingEnabled(r)){return false}return t.getByReference(e).allContextsProvided===false}function R(e){return t.getByReference(e).isEndUserAdaptation===false}var A={getReloadReasonsForStart(e){const t=r.getFlexReferenceForControl(e.selector);return Promise.all([d.call(this,e,t),v(e,t),y(e,t)]).then(function(r){[e.hasHigherLayerChanges,e.isDraftAvailable,e.allContexts]=r;return e})},hasVersionStorage(e,a){const n=r.getFlexReferenceForControl(a);var i=t.getByReference(n);return!!(i.version&&i.version===e.value)},removeInfoSessionStorage(e){const a=r.getFlexReferenceForControl(e);t.removeByReference(a)},hasMaxLayerStorage(e,a){const n=r.getFlexReferenceForControl(a);var i=t.getByReference(n);return!!(i.maxLayer&&i.maxLayer===e.value)},handleReloadInfo(e){const n=r.getFlexReferenceForControl(e.selector);var i=false;var l=t.getByReference(n);if(!e.ignoreMaxLayerParameter&&e.hasHigherLayerChanges){delete l.maxLayer;delete l.adaptationLayer;i=true}if(e.versionSwitch&&l.version!==e.version){l.version=e.version;i=true}if(l.version&&e.removeVersionParameter||l.version===a.Number.Draft&&e.removeDraft){delete l.version;i=true}t.setByReference(l,n);return i},handleReloadInfoOnStart(e){const n=r.getFlexReferenceForControl(e.selector);var i=false;var l=t.getByReference(n);if(e.hasHigherLayerChanges){l.maxLayer=e.layer;i=true}if(e.isDraftAvailable){l.version=a.Number.Draft;i=true}t.setByReference(l,n);return i},initialDraftGotActivated(e){if(e.versioningEnabled){var r=this.hasVersionStorage({value:a.Number.Draft},e.selector);return!o.isDraftAvailable({control:e.selector,layer:e.layer})&&r}return false},getReloadMethod(e){const n=r.getFlexReferenceForControl(e.selector);var i={NOT_NEEDED:"NO_RELOAD",RELOAD_PAGE:"HARD_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION"};e.reloadMethod=i.NOT_NEEDED;e.isDraftAvailable||=A.hasVersionStorage({value:a.Number.Draft},e.selector);e.isDraftAvailable||=A.hasVersionStorage({value:a.Number.Draft},e.selector);e.hasVersionStorage=!!t.getByReference(n).version;if(e.activeVersion&&e.activeVersion!==a.Number.Original&&e.hasVersionStorage){e.activeVersionNotSelected=!A.hasVersionStorage({value:e.activeVersion},e.selector)}e.hasHigherLayerChanges=A.hasMaxLayerStorage({value:e.layer},e.selector);e.initialDraftGotActivated=A.initialDraftGotActivated(e);if(e.initialDraftGotActivated){e.isDraftAvailable=false}e.allContexts=h(n,e.layer);e.switchEndUserAdaptation=R(n);if(e.changesNeedReload||e.isDraftAvailable||e.hasHigherLayerChanges||e.initialDraftGotActivated||e.activeVersionNotSelected||e.allContexts||e.switchEndUserAdaptation){e.reloadMethod=i.RELOAD_PAGE;if(!e.changesNeedReload&&u.getUshellContainer()){e.reloadMethod=i.VIA_HASH}}return e}};return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/SACIntegrationUpdateVariant", ["sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/Layer"],function(e,t,r,i,n){"use strict";return a=>{if(!a){return Promise.reject("A property bag must be provided")}if(!a.control){return Promise.reject("variant management control must be provided")}if(!a.id){return Promise.reject("variant ID must be provided")}if(!a.content){return Promise.reject("content must be provided")}a.reference=t.getFlexReferenceForControl(a.control);a.persistencyKey=r.getPersistencyKey(a.control);const o=i.getFlexObjectsDataSelector().get(a);const s=o.find(e=>e.getId()===a.id);if(s?.getFileType()!=="variant"){return Promise.reject("no variant with the ID found")}a.layer=s.getLayer();if(![n.USER,n.PUBLIC].includes(a.layer)){return Promise.reject("only variants in the USER and PUBLIC layer can be updated")}if(!s.isEditEnabled()){return Promise.reject("the user is not authorized to edit the PUBLIC variant (no author nor key user)")}e.updateVariant(a);return e.persist(a)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/SmartBusinessWriteAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/base/util/restricted/_pick"],function(e,r,t,i,a,n,p,s){"use strict";function c(e,t){return r.getInstance().then(function(r){if(r.isAtoEnabled()){t.skipIam=true;t.transport="ATO_NOTIFICATION"}return a[e](t)})}function o(r){if(!r.appId){return Promise.reject("App Variant ID must be provided")}r.selector={appId:r.appId};r.id=e.getFlexReferenceForSelector(r.selector);r.isForSmartBusiness=true;return Promise.resolve(r)}var u={create(r){if(!r.layer){return Promise.reject("Layer must be provided")}if(!r.selector||!r.selector.appId){return Promise.reject("selector.appId must be provided")}if(!r.id){return Promise.reject("App variant ID must be provided")}r.reference=e.getFlexReferenceForSelector(r.selector);r.isForSmartBusiness=true;return c("saveAs",r)},update(e){return o(e).then(c.bind(this,"updateAppVariant"))},remove(e){return o(e).then(c.bind(this,"deleteAppVariant"))},getDesignTimeVariant(e){if(!e.id){return Promise.reject("App Variant ID must be provided")}return t.load(e)},getRunTimeVariant(e){if(!e.appId){return Promise.reject("Reference App ID must be provided")}if(!e.id){return Promise.reject("App Variant ID must be provided")}var r=`/sap/bc/lrep/content/apps/${e.appId}/appVariants/${e.id}/manifest.appdescr_variant`;return i.appVariant.getManifest({appVarUrl:r})},createDescriptorInlineChanges(e){if(!e.appId){return Promise.reject("appId must be provided")}if(!e.changeSpecificData){return Promise.reject("changeSpecificData must be provided")}e.selector={appId:e.appId};return n.create(e)},add(e){if(!e.appId){return Promise.reject("appId must be provided")}if(!e.change){return Promise.reject("Change instance must be provided")}e.selector={appId:e.appId};return p.add(e)},createDescriptorChangeString(e){return this.createDescriptorInlineChanges(e).then(function(e){var r=s(e.getJson(),["changeType","content","texts"]);return Promise.resolve(JSON.stringify(r))})}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/SmartVariantManagementWriteAPI", ["sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings"],function(t,e,a,n,r,i){"use strict";function o(a,n){a.persistencyKey=t.getPersistencyKey(a.control);a.reference||=e.getFlexReferenceForControl(a.control);return n(a)}function c(t){var n=t.layer||t.changeSpecificData&&t.changeSpecificData.layer;if(n){t.changeSpecificData||={};t.reference||=e.getFlexReferenceForControl(t.control);var r={layer:n,control:t.control,reference:t.reference};if(a.hasAdaptationsModel(r)){t.changeSpecificData.adaptationId=a.getDisplayedAdaptationId(r)}}}var s={addVariant(t){c(t);return o(t,n.addVariant)},updateVariant(t){c(t);return o(t,n.updateVariant)},updateVariantContent(t){c(t);t.action=n.updateActionType.UPDATE;return o(t,n.updateVariant)},saveVariantContent(t){t.action=n.updateActionType.SAVE;return o(t,n.updateVariant)},discardVariantContent(t){t.action=n.updateActionType.DISCARD;return o(t,n.discardVariantContent)},updateVariantMetadata(t){c(t);t.action=n.updateActionType.UPDATE_METADATA;return o(t,n.updateVariant)},removeVariant(t){c(t);return o(t,n.removeVariant)},revert(t){return o(t,n.revert)},save(t){return o(t,n.persist)},setDefaultVariantId(t){c(t);return o(t,n.setDefault)},isVariantSharingEnabled(){return i.getInstance().then(function(t){return t.isVariantSharingEnabled()})},isVariantPersonalizationEnabled(){return i.getInstance().then(function(t){return t.isVariantPersonalizationEnabled()})},isVariantAdaptationEnabled(){return i.getInstance().then(function(t){return t.isVariantAdaptationEnabled()})},overrideStandardVariant(t){o(t,n.overrideStandardVariant)},revertSetDefaultVariantId(t){return o(t,n.revertSetDefaultVariantId)},_getTransportSelection(){function t(){var t=new URLSearchParams(window.location.search).get("sap-ui-layer")||"";return!!t}var e=new r;e.selectTransport=function(a,n,i,o,c,s){if(!t()){n(e._createEventObject(a,{transportId:""}));return}r.prototype.selectTransport.call(this,a,n,i,o,c,s)};return e}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/TranslationAPI", ["sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Utils","sap/base/util/isEmptyObject","sap/base/i18n/Localization"],function(e,r,t,n,a,o){"use strict";var i={};i.hasTranslationRelevantDirtyChanges=function(t){return e.getDirtyFlexObjects(r.getFlexReferenceForControl(t.selector)).some(function(e){return!a(e.getTexts())})};i.getTexts=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.sourceLanguage){return Promise.reject("No sourceLanguage was provided")}if(!e.targetLanguage){return Promise.reject("No targetLanguage was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var a=n.getAppComponentForControl(e.selector);e.reference=r.getFlexReferenceForControl(a);return Promise.resolve().then(t.translation.getTexts.bind(undefined,e))};i.getSourceLanguages=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var a=n.getAppComponentForControl(e.selector);e.reference=r.getFlexReferenceForControl(a);return t.translation.getSourceLanguages(e).then(function(r){var t=o.getLanguage();if(!r.includes(t)&&i.hasTranslationRelevantDirtyChanges(e)){r.push(t)}return r})};i.uploadTranslationTexts=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.payload){return Promise.reject("No payload was provided")}return Promise.resolve().then(t.translation.postTranslationTexts.bind(undefined,e))};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/UI2PersonalizationWriteAPI", ["sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/base/util/restricted/_omit"],function(e,t,r){"use strict";var a={async create(a){a.reference=t.getFlexReferenceForSelector(a.selector);if(!a.reference||!a.containerKey||!a.itemName||!a.content||!a.category||!a.containerCategory){throw new Error("not all mandatory properties were provided for the storage of the personalization")}await e.setPersonalization(r(a,["selector"]))},async deletePersonalization(r){r.reference=t.getFlexReferenceForSelector(r.selector);if(!r.reference||!r.containerKey||!r.itemName){throw new Error("not all mandatory properties were provided for the deletion of the personalization")}await e.deletePersonalization(r.reference,r.containerKey,r.itemName)}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/VersionsAPI", ["sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/api/Version","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Versions","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Utils"],function(e,r,t,n,i,o,a,s,l,c){"use strict";function d(e){const r=t.getFlexReferenceForControl(e);if(!r){throw Error("The application ID could not be determined")}return r}function f(r){const t=e.getDirtyFlexObjects(r);return t.length>0}function p(e){if(!e.control){throw Error("No control was provided")}if(!e.layer){throw Error("No layer was provided")}var r=d(e.control);const t=a.getVersionsModel({reference:r,layer:e.layer});if(f(r)){t.updateDraftVersion()}return t}function u(e){var r=d(e.control);var t=s.hasAdaptationsModel({layer:e.layer,reference:r});if(!e.adaptationId&&t){return s.refreshAdaptationModel(e)}else if(e.adaptationId&&t){var n=s.getAdaptationsModel(e);n.switchDisplayedAdaptation(e.adaptationId);return Promise.resolve(e.adaptationId)}return Promise.resolve()}var v={};v.initialize=function(e){if(!e.control){return Promise.reject("No control was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var r=c.getAppComponentForControl(e.control);return a.initialize({reference:d(r),layer:e.layer})};v.clearInstances=function(){a.clearInstances()};v.isDraftAvailable=function(e){var r=p(e);var t=r.getProperty("/versions");var n=t.find(function(e){return e.version===i.Number.Draft});return!!n};v.getDraftFilenames=function(e){const r=p(e);return r.getProperty("/draftFilenames")};v.isOldVersionDisplayed=function(e){var r=p(e);var t=r.getProperty("/displayedVersion");var n=r.getProperty("/activeVersion");return t!==i.Number.Draft&&t!==n};v.loadDraftForApplication=function(e){e.version=i.Number.Draft;return v.loadVersionForApplication(e)};v.loadVersionForApplication=function(e){if(!e.control){return Promise.reject("No control was provided")}if(!e.layer){return Promise.reject("No layer was provided")}const t=p(e);if(t){if(e.version===undefined){e.version=t.getProperty("/activeVersion")}t.setProperty("/displayedVersion",e.version);t.setProperty("/persistedVersion",e.version);if(e.version!==i.Number.Draft&&l.isPublishAvailable()){const r=t.getProperty("/versions");if(r.length){const n=r.find(function(r){return r.version===e.version});if(n){t.setProperty("/publishVersionEnabled",!n.isPublished)}}}}return u(e).then(function(t){const i=c.getAppComponentForControl(e.control);const o=d(i);const a=n.getByReference(o);a.version=e.version;a.displayedAdaptationId=t;n.setByReference(a,o);r.clearState(o)})};v.activate=function(e){if(!e.control){return Promise.reject("No control was provided")}if(!e.layer){return Promise.reject("No layer was provided")}if(!e.title){return Promise.reject("No version title was provided")}const r=d(e.control);if(f(r)){return Promise.reject("Unsaved changes exist")}const t=n.getByReference(r);delete t.version;n.setByReference(t,r);return a.activate({reference:r,layer:e.layer,title:e.title,appComponent:c.getAppComponentForControl(e.control),displayedVersion:e.displayedVersion})};v.discardDraft=function(t){const i=c.getAppComponentForControl(t.control);const l=d(i);function f(){const r=e.getDirtyFlexObjects(l);o.deleteFlexObjects({reference:l,flexObjects:r});return r.length>0}if(!t.control){return Promise.reject("No control was provided")}if(!t.layer){return Promise.reject("No layer was provided")}return a.discardDraft({reference:l,layer:t.layer,discardDraftAndKeepActiveVersion:t.discardDraftAndKeepActiveVersion}).then(function(e){var i=false;if(!t.discardDraftAndKeepActiveVersion){i=f()}e.dirtyChangesDiscarded=i;if(e.backendChangesDiscarded){const i=s.hasAdaptationsModel({layer:t.layer,reference:l});if(i){return s.refreshAdaptationModel(t).then(function(i){const o=n.getByReference(l);o.displayedAdaptationId=i;n.setByReference(o,l);if(!t.discardDraftAndKeepActiveVersion){r.clearState(l)}return e})}}if(!t.discardDraftAndKeepActiveVersion){r.clearState(l)}return e})};v.publish=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.layer){return Promise.reject("No layer was provided")}if(!e.version){return Promise.reject("No version was provided")}e.styleClass||="";e.reference=d(e.selector);return a.publish(e)};return v});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/connectors/FileListBaseConnector", ["sap/base/util/merge","sap/base/util/LoaderExtensions","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/write/connectors/BaseConnector"],function(e,t,n,r){"use strict";return e({},r,{getFileList(){return Promise.reject("not implemented")},layers:[],loadFlexData(e){return this.getFileList(e.reference).then(function(e){return Promise.all(e.map(function(e){return t.loadResource({dataType:"json",url:e,async:true})})).then(function(e){var t=n.getGroupedFlexObjects(e);return n.filterAndSortResponses(t)})})}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/connectors/ObjectStorageConnector", ["sap/base/strings/hash","sap/base/util/restricted/_uniqBy","sap/base/util/each","sap/base/util/merge","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/initial/api/Version","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils"],function(e,t,r,n,i,s,a,o,c,l){"use strict";const f={isKeyUser:true,isVariantSharingEnabled:true,isProductiveSystem:false,isCondensingEnabled:true,isContextSharingEnabled:false,isVersioningEnabled:true,logonUser:"DEFAULT_USER",isVariantAuthorNameAvailable:false,isAnnotationChangeEnabled:true};function u(e){var t=[];return l.forEachObjectInStorage(e,function(e){t.push(e.changeDefinition)}).then(function(){return t})}function d(e,t){var r=true;if(e.selectorIds){if(t.selector){r=e.selectorIds.indexOf(t.selector.id)>-1}else{r=false}}if(r&&e.changeTypes){r=e.changeTypes.indexOf(t.changeType)>-1}return r}function h(e,t){if(!e.creation){var r=Date.now()+t;e.creation=new Date(r).toISOString()}return e}function v(t){return e(t.reduce(function(e,t){return e+new Date(t.creation).getTime()},""))}function g(e,t){r(e,function(e,n){n.forEach(function(e){r(e,function(e,r){t(r,e)})})})}function m(e,t){var r=[];var n=0;g(e,function(e,i){var s=l.createFlexKey(i);var a=t.condensedChanges.find(function(t){return t.getId()===e.fileName});if(!a.getCreation()){var o=Date.now()+n;n++;a.setCreation(new Date(o).toISOString())}r.push({key:s,value:a})});return r}function y(e,t){var r=[];g(e,function(e,n){var i=l.createFlexKey(n);var s;t.some(function(e){if(e.getId()===n){s=e;return true}});r.push({key:i,value:s})});return r}function b(e,t){var n=[];r(e,function(e,r){if(r.length<2){return}var i=t.filter(function(t){return t.getFileType()===e});i.forEach(function(e,t){if(r.indexOf(e.getId())>-1&&t<i.length-1){var s=i[t+1];var a=new Date(e.getCreation());var o=new Date(s.getCreation());if(s&&a>=o){var c=a.getTime()+1;s.setCreation(new Date(c).toISOString());var f=l.createFlexKey(s.getId());n.push({key:f,value:s})}}})});return n}function p(e){var t=[];if(e){Object.values(e).forEach(function(e){e.forEach(function(e){var r=l.createFlexKey(e);t.push(this.storage.removeItem(r))}.bind(this))}.bind(this))}return t}var O=n({},o,{storage:undefined,layers:["ALL"],async loadFlexData(e){const t=await u({storage:this.storage,reference:e.reference});const r=await this.versions.getVersionChain.call(this,e,e.version);const n=t.filter(e=>e.version===undefined||r.includes(e.version));const i=c.sortFlexObjects(n);const s=c.getGroupedFlexObjects(i);const a=c.filterAndSortResponses(s);if(a.length){a[0].cacheKey=v(i)}return a},async write(e){const t=await this.loadFeatures();let r;if(t.isVersioningEnabled&&e.layer===i.CUSTOMER){e.reference=e.flexObjects[0]?.reference;r=await this.versions.getDraftId.call(this,e)}let n=0;const s=[];for(const t of e.flexObjects){if(r){t.version=r}const e=l.createFlexObjectKey(t);const i=h(t,++n);const a=this.storage._itemsStoredAsObjects?i:JSON.stringify(i);await this.storage.setItem(e,a);s.push(i)}return{response:s}},async update(e){var t=e.flexObject;if(f.isVersioningEnabled&&e.layer===i.CUSTOMER){e.reference=t.reference;const r=await this.versions.load.call(this,e);const n=r.find(e=>e.isDraft)?.id;if(n){t.version=n}}var r=l.createFlexObjectKey(e.flexObject);var n=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);var s=this.storage.setItem(r,n);return Promise.resolve(s)},reset(e){return l.forEachObjectInStorage({storage:this.storage,reference:e.reference,layer:e.layer},function(t){if(d(e,t.changeDefinition)){return Promise.resolve(this.storage.removeItem(t.key)).then(function(){return{fileName:t.changeDefinition?.fileName||t.changeDefinition?.id}})}}.bind(this)).then(function(e){return{response:e.filter(function(e){return!!e})}})},remove(e){var t=l.createFlexObjectKey(e.flexObject);this.storage.removeItem(t);var r=this.storage.removeItem(t);return Promise.resolve(r)},loadFeatures(){return Promise.resolve(f)},loadVariantsAuthors(){return Promise.reject("loadVariantsAuthors is not implemented")},getFlexInfo(e){e.storage=this.storage;return l.getAllFlexObjects(e).then(function(e){return{isResetEnabled:e.length>0}})},async condense(e){var r=e.flexObjects;var n=[];n=n.concat(m(r.create,e));n=n.concat(y(r.update,e.condensedChanges));n=n.concat(b(r.reorder,e.condensedChanges));n=t(n,"key");var s=[];var a=[];s=s.concat(p.call(this,r.delete));const o=await this.loadFeatures();let c;if(o.isVersioningEnabled&&e.layer===i.CUSTOMER&&(r.create&&Object.keys(r.create).length!==0||r.update&&Object.keys(r.update).length!==0||r.reorder&&Object.keys(r.reorder).length!==0)){c=await this.versions.getDraftId.call(this,e)}n.forEach(function(e){var t=e.value.convertToFileContent();if(c){t.version=c}a.push(t);var r=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);s.push(this.storage.setItem(e.key,r))}.bind(this));if(o.isVersioningEnabled&&e.layer===i.CUSTOMER&&r.delete&&Object.keys(r.delete).length!==0){const t=await this.versions.load.call(this,e);if(t.length){const n=t.find(e=>e.isDraft);Object.values(r.delete).forEach(function(e){e.forEach(function(e){n.filenames=n.filenames.filter(function(t){return t!==e})})});if(!n.filenames.length){await this.versions.discardDraft.call(this,e)}}}return Promise.all(s).then(function(){return Promise.resolve({response:a})})},versions:{async getDraftId(e){let t=[];if(e.condensedChanges){t=e.condensedChanges.map(e=>e.sId)}else{t=e.flexObjects.map(e=>e.fileName)}const r=await this.versions.load.call(this,e);let n=r.find(e=>e.isDraft);if(n&&e.parentVersion===a.Number.Draft){if(e.condensedChanges){n.filenames=[]}n.filenames=t.concat(n.filenames)}else{if(n&&e.parentVersion!==a.Number.Draft){await this.versions.discardDraft.call(this,e)}n={version:a.Number.Draft,id:s.createDefaultFileName("version"),isDraft:true,activatedAt:"",activatedBy:"",fileType:"version",layer:i.CUSTOMER,title:"",reference:e.reference,filenames:t};if(e.parentVersion!==a.Number.Original){n.parentVersion=e.parentVersion}}const o=l.createFlexKey(`${n.id}`);const c=this.storage._itemsStoredAsObjects?n:JSON.stringify(n);await this.storage.setItem(o,c);return n.id},async getVersionChain(e,t){const r=[];const n=(e,t)=>e===t.version;const i=await this.versions.load.call(this,e);t||=i.find(e=>!e.isDraft)?.id;while(t&&t!==a.Number.Original){const e=i.find(n.bind(undefined,t));r.push(e.id);t=e.parentVersion}return r},async load(e){const t=await u({storage:this.storage,reference:e.reference});return t.filter(e=>e.fileType==="version").sort((e,t)=>{if(e.isDraft){return-1}if(t.isDraft){return 1}return e.activatedAt<t.activatedAt?1:-1})},async activate(e){const t=await this.loadFeatures();const r=await this.versions.load.call(this,e);var n=r.find(t=>t.version===e.version);if(n){if(!n.isDraft){n.id=s.createDefaultFileName("version");n.parentVersion=e.version}}else{const t=s.createDefaultFileName("version");n={version:t,id:t,fileType:"version",layer:i.CUSTOMER,reference:e.reference}}if(e.version!==a.Number.Draft){const t=r.find(e=>e.isDraft);if(t){await this.versions.discardDraft.call(this,e)}}const o=l.createFlexKey(n.id);n.title=e.title;n.activatedAt=new Date(Date.now()).toISOString();n.activatedBy=t.logonUser;n.isDraft=false;n.version=n.id;delete n.filenames;const c=this.storage._itemsStoredAsObjects?n:JSON.stringify(n);this.storage.setItem(o,c);return n},async discardDraft(e){e.storage=this.storage;const t=await this.versions.load.call(this,e);const r=t.find(e=>e.isDraft)?.id;if(!r){return Promise.reject("no version to discard")}const n=await u(e);const i=n.filter(e=>e.version===r);const s=t.find(e=>e.id===r);i.push(s);const a=i.map(e=>{var t=l.createFlexKey(e.fileName||e.id);return this.storage.removeItem(t)});await Promise.all(a)}}});return O});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/connectors/BaseConnector", [],function(){"use strict";var e={layers:[],write(){return Promise.reject("write is not implemented")},condense(){return Promise.reject("condense is not implemented")},update(){return Promise.reject("write is not implemented")},remove(){return Promise.reject("remove is not implemented")},reset(){return Promise.reject("reset is not implemented")},publish(){return Promise.reject("publish is not implemented")},getFlexInfo(){return Promise.resolve({})},getSeenFeatureIds(){return Promise.reject("getSeenFeatureIds is not implemented")},setSeenFeatureIds(){return Promise.reject("setSeenFeatureIds is not implemented")},getContexts(){return Promise.reject("getContexts is not implemented")},loadContextDescriptions(){return Promise.reject("loadContextDescriptions is not implemented")},isContextSharingEnabled(){return Promise.resolve(false)},contextBasedAdaptation:{create(){return Promise.reject("contextBasedAdaptation.create is not implemented")},reorder(){return Promise.reject("contextBasedAdaptation.reorder is not implemented")},load(){return Promise.reject("contextBasedAdaptation.load is not implemented")},update(){return Promise.reject("contextBasedAdaptation.update is not implemented")},remove(){return Promise.reject("contextBasedAdaptation.remove is not implemented")}},versions:{load(){return Promise.reject("versions.load is not implemented")},activate(){return Promise.reject("versions.activate is not implemented")},discardDraft(){return Promise.reject("versions.discardDraft is not implemented")}},translation:{getSourceLanguages(){return Promise.reject("translation.getSourceLanguages is not implemented")},getTexts(){return Promise.reject("translation.getTexts is not implemented")},postTranslationTexts(){return Promise.reject("translation.postTranslationTexts is not implemented")}}};return e});
sap.ui.require.preload({
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:editor="sap.ui.integration.designtime.baseEditor"\n><Dialog\n\t\tclass="sapUiContentPadding"\n\t\ttitle="{i18n>CAP_ADD_FIELD_TITLE}"\n\t\tverticalScrolling="true"\n\t\tresizable="false"\n\t\tdraggable="true"\n\t\tcontentWidth="42rem"\n\t\tcontentHeight="80vh"\n\t><content><editor:BaseEditor layout="form" /></content><beginButton><Button\n\t\t\t\tenabled="{dialog>/isValid}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>CAP_ADD_FIELD_CREATE}"\n\t\t\t\tpress="onSave"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{i18n>CAP_ADD_FIELD_CANCEL}"\n\t\t\t\tpress="onCancel"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n><CheckBox select="_onChange" /></core:FragmentDefinition>',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:baseEditor="sap.ui.integration.designtime.baseEditor"\n><HBox><baseEditor:PropertyEditor\n\t\t\tinit="wrapperInit"\n\t\t\tconfig="{contentModel>/0/config}"\n\t\t\tvalue="{contentModel>/0/value}"\n\t\t\trenderLabel="false"\n\t\t\tvalueChange="_onChange"\n\t\t/><baseEditor:PropertyEditor\n\t\t\tinit="wrapperInit"\n\t\t\tconfig="{contentModel>/1/config}"\n\t\t\tvalue="{contentModel>/1/value}"\n\t\t\trenderLabel="false"\n\t\t\tvalueChange="_onChange"\n\t\t/></HBox></core:FragmentDefinition>',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n><TimePicker\n\t\tvalue="{displayValue}"\n\t\tvalueFormat="HH:mm:ss.SSSS"\n\t\tchange="_onChange"\n\t/></core:FragmentDefinition>'
},"sap/ui/fl/library-preload-write");
//# sourceMappingURL=library-preload-write.js.map
