//@ui5-bundle sap/ui/fl/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/ChangePersistence", ["sap/base/Log","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/LayerUtils"],function(e,t,n,r,a,i,o,s,c,f,l,u,p){"use strict";var h=function(t){this._mComponent=t;if(!this._mComponent||!this._mComponent.name){e.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.")}this._oMessagebundle=undefined};h.prototype._deleteNotSavedChanges=function(e,t,n){e.filter(function(e){return!t.some(function(t){return e.getId()===t.getId()})}).forEach(function(e){if(n){this.removeChange(e);i.updateStorageResponse(this._mComponent.name,[{flexObject:e.convertToFileContent(),type:"delete"}])}else{f.deleteFlexObjects({reference:this._mComponent.name,flexObjects:[e]})}}.bind(this))};function g(e,t){var n=e.map(function(e){return e[t]()});var r=n.filter(function(e,t,n){return n.indexOf(e)===t});return r.length===1}function d(e,t,n){var r=false;if(!e||!g(t,"getLayer")){return false}if(n){r=true}else{var a=t[0].getLayer();if([u.CUSTOMER,u.PUBLIC,u.USER].includes(a)){r=true}}var i=new URLSearchParams(window.location.search);if(i.has("sap-ui-xx-condense-changes")){r=i.get("sap-ui-xx-condense-changes")==="true"}return r}function m(){return s.getInstanceOrUndef()?.isCondensingEnabled()}function y(e,t,n,r){this._massUpdateCacheAndDirtyState(t,n);this._deleteNotSavedChanges(e,t,r)}function S(e,r,a,o,s){if(!e.length&&!a){return[]}const c=i.getFlexObjectsDataSelector().get({reference:s}).filter(function(e){if(e instanceof t){return false}if(e.getFlexObjectMetadata().reference!==s){return false}if(o===u.CUSTOMER&&r){return e.getState()===n.LifecycleState.PERSISTED&&r.includes(e.getId())}return e.getState()===n.LifecycleState.PERSISTED&&p.compareAgainstCurrentLayer(e.getLayer(),o)===0});return c.concat(e)}function C(e){if(e.length){var t=b(e);var n=true;if(s.getInstanceOrUndef()&&s.getInstanceOrUndef().hasPersoConnector()){var r=x(e);n=r.length===1}return t.length===1&&n}return true}function v(e,t,r,a,i,o){let s=Promise.resolve();const c=i.filter(e=>e.getState()===n.LifecycleState.DELETED);const f=o.filter(e=>e.getState()!==n.LifecycleState.DELETED);if(c.length){s=this.saveSequenceOfDirtyChanges(c,a,r)}return s.then(function(){if(f.length){return l.write({layer:e,flexObjects:D(f),transport:t,isLegacyVariant:false,parentVersion:r}).then(function(e){y.call(this,i,f,a);return e}.bind(this))}return this._deleteNotSavedChanges(i,o)}.bind(this))}h.prototype.saveDirtyChanges=function(e,t,n,r,i,o,s){const f=this._mComponent.name;const u=n||a.getDirtyFlexObjects(f);const p=u.length&&u[0].getLayer()||s;const h=S(u,i,o,p,f);const g=m()&&d(e,h,o);const _=g?h:u;const x=_.slice(0);const D=b(u);if(C(u)){const n=d(e,x,o)?c.condense(e,x):Promise.resolve(x);return n.then(function(e){const n=D[0];if(g){return l.condense({allChanges:_,condensedChanges:e,layer:p,transport:n,isLegacyVariant:false,parentVersion:r}).then(function(n){y.call(this,_,e,t,true);return n}.bind(this))}return v.call(this,p,n,r,t,_,e)}.bind(this))}return this.saveSequenceOfDirtyChanges(u,t,r)};h.prototype.saveSequenceOfDirtyChanges=async function(e,t,r){var a;if(r){var o=e.filter(function(e){return e.getState()===n.LifecycleState.NEW});a=[].concat(o).shift()}const s={response:[]};for(const n of e){const e=await _(n,a,r);this._updateCacheAndDirtyState(n,t);if(e?.response){s.response.push(...e.response)}}i.getFlexObjectsDataSelector().checkUpdate({reference:this._mComponent.name});return s};function _(e,t,r){switch(e.getState()){case n.LifecycleState.NEW:if(r!==undefined){r=e===t?r:o.Number.Draft}return l.write({layer:e.getLayer(),flexObjects:[e.convertToFileContent()],transport:e.getRequest(),parentVersion:r});case n.LifecycleState.DELETED:return l.remove({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:r});default:return Promise.resolve()}}h.prototype._updateCacheAndDirtyState=function(e,t){if(!t){switch(e.getState()){case n.LifecycleState.NEW:i.updateStorageResponse(this._mComponent.name,[{type:"add",flexObject:e.convertToFileContent()}]);break;case n.LifecycleState.DELETED:i.updateStorageResponse(this._mComponent.name,[{type:"delete",flexObject:e.convertToFileContent()}]);break;case n.LifecycleState.UPDATED:i.updateStorageResponse(this._mComponent.name,[{type:"update",flexObject:e.convertToFileContent()}]);break;default:}e.setState(n.LifecycleState.PERSISTED)}};h.prototype._massUpdateCacheAndDirtyState=function(e,t){e.forEach(function(e){this._updateCacheAndDirtyState(e,t)},this);i.getFlexObjectsDataSelector().checkUpdate({reference:this._mComponent.name})};function b(e){var t=[];e.forEach(function(e){var n=e.getRequest();if(t.indexOf(n)===-1){t.push(n)}});return t}function x(e){var t=[];e.forEach(function(e){var n=e.getLayer();if(t.indexOf(n)===-1){t.push(n)}});return t}function D(e){var t=[];e.forEach(function(e){t.push(e.convertToFileContent())});return t}h.prototype.removeChange=function(e){i.removeDirtyFlexObjects(this._mComponent.name,[e]);this._deleteChangeInMap(e)};h.prototype._deleteChangeInMap=function(e,t){var n=e.getId();r.removeChangeFromMap(a.getLiveDependencyMap(this._mComponent.name),n);if(!t){r.removeChangeFromDependencies(a.getLiveDependencyMap(this._mComponent.name),n)}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/ChangePersistenceFactory", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/ChangePersistence"],function(e,n){"use strict";var t={};t._instanceCache={};t.getChangePersistenceForComponent=function(e){var r=t._instanceCache[e];if(!r){var a={name:e};r=new n(a);t._instanceCache[e]=r}return r};t.getChangePersistenceForControl=function(n){var r;r=e.getFlexReferenceForControl(n);return t.getChangePersistenceForComponent(r)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FlexController", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Versions","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Layer"],function(e,t,n,r,s,a,i,o,l){"use strict";async function f(n,r,s){if(s.length!==0){await t.revertMultipleChanges([...s].reverse(),{appComponent:n,modifier:e,reference:r})}}var c=function(e){this._oChangePersistence=undefined;this._sComponentName=e||"";if(this._sComponentName){this._oChangePersistence=o.getChangePersistenceForComponent(this._sComponentName)}};c.prototype._removeOtherLayerChanges=async function(e,t,n){if(n&&t){var r=Object.values(l).filter(function(e){return e!==t});const n=this._sComponentName;const s=a.removeDirtyFlexObjects({reference:n,layers:r,component:e});await f(e,n,s);return s}return undefined};c.prototype.saveAll=function(e,t,n,r,s,a){var o;var f;if(n){var c=i.getVersionsModel({reference:this._sComponentName,layer:l.CUSTOMER});o=c.getProperty("/persistedVersion");f=c.getProperty("/draftFilenames")}return this._removeOtherLayerChanges(e,r,s).then(this._oChangePersistence.saveDirtyChanges.bind(this._oChangePersistence,e,t,undefined,o,f,a,r)).then(function(e){if(n){var t={reference:this._sComponentName,layer:l.CUSTOMER};if(e?.response&&e.response.length>0){var r=[];if(Array.isArray(e.response)){e.response.forEach(function(e){r.push(e.fileName)})}t.draftFilenames=r;i.onAllChangesSaved(t)}else{return i.updateModelFromBackend(t)}}return e}.bind(this))};c.prototype.saveSequenceOfDirtyChanges=async function(e,t){const a=e||r.getDirtyFlexObjects(this._sComponentName);const i=await this._oChangePersistence.saveDirtyChanges(t,false,a);if(i?.response?.length){var o=i.response.map(e=>e.fileName);a.forEach(function(e){if(o.includes(e.getId())){e.setState(n.LifecycleState.PERSISTED)}});s.getFlexObjectsDataSelector().checkUpdate({reference:this._sComponentName})}return i};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FlexControllerFactory", ["sap/base/Log","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/FlexController","sap/ui/fl/Utils"],function(e,r,t,n){"use strict";var a={};a._instanceCache={};a.create=function(e){var r=a._instanceCache[e];if(!r){r=new t(e);a._instanceCache[e]=r}return r};a.createForControl=function(t){try{var o=n.getAppComponentForControl(t);var c=r.getFlexReferenceForControl(o||t);return a.create(c)}catch(r){e.error(r.message,undefined,"sap.ui.fl.FlexControllerFactory")}};a.createForSelector=function(e){var t=r.getFlexReferenceForSelector(e);return a.create(t)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Layer", [],function(){"use strict";return{USER:"USER",PUBLIC:"PUBLIC",CUSTOMER:"CUSTOMER",CUSTOMER_BASE:"CUSTOMER_BASE",PARTNER:"PARTNER",VENDOR:"VENDOR",BASE:"BASE"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/LayerUtils", ["sap/ui/thirdparty/hasher","sap/ui/fl/Layer","sap/ui/fl/initial/_internal/FlexInfoSession"],function(e,r,a){"use strict";var t=[r.BASE,r.VENDOR,r.PARTNER,r.CUSTOMER_BASE,r.CUSTOMER,r.PUBLIC,r.USER];var n={};t.forEach(function(e,r){n[e]=r});function i(e){return new URLSearchParams(window.location.search).get(e)}var s={_mLayersIndex:n,_sTopLayer:t[t.length-1],FL_MAX_LAYER_PARAM:"sap-ui-fl-max-layer",isValidLayer(e){return Object.keys(r).some(function(r){return r===e})},isVendorLayer(){return this.getCurrentLayer()===r.VENDOR},isCustomerDependentLayer(e){return[r.PUBLIC,r.CUSTOMER,r.CUSTOMER_BASE].indexOf(e)>-1},isDeveloperLayer(e){return s.compareAgainstCurrentLayer(e,r.CUSTOMER)===-1},doesCurrentLayerRequirePackage(){var e=this.getCurrentLayer();return e===r.VENDOR||e===r.PARTNER||e===r.CUSTOMER_BASE},getMaxLayer(r){var a=s.getMaxLayerTechnicalParameter(e.getHash(),r);return a||i(this.FL_MAX_LAYER_PARAM)||s._sTopLayer},getLayerIndex(e){return this._mLayersIndex[e]},isOverMaxLayer(e,r){return this.isOverLayer(e,this.getMaxLayer(r))},isOverLayer(e,r){return this.getLayerIndex(e)>this.getLayerIndex(r)},compareAgainstCurrentLayer(e,r){var a=r||s.getCurrentLayer();if(this.getLayerIndex(a)>this.getLayerIndex(e)||!e){return-1}else if(this.getLayerIndex(a)===this.getLayerIndex(e)){return 0}return 1},isLayerFilteringRequired(e){var r=a.getByReference(e);var t=r.maxLayer?r.maxLayer:s._sTopLayer;return this._sTopLayer!==t},isSapUiLayerParameterProvided(){return!!i("sap-ui-layer")},getCurrentLayer(){var e=i("sap-ui-layer")||"";return e.toUpperCase()||r.CUSTOMER},filterChangeDefinitionsByMaxLayer(e,r){return e.filter(function(e){return!e.layer||!s.isOverMaxLayer(e.layer,r)})},filterChangeOrChangeDefinitionsByCurrentLayer(e,r){if(!r){return e}return e.filter(function(e){var a=e.getLayer&&e.getLayer()||e.layer;return r===a})},getMaxLayerTechnicalParameter(e,r){if(r){var a=r.parseShellHash(e)||{};if(a.params&&a.params.hasOwnProperty(this.FL_MAX_LAYER_PARAM)){return a.params[this.FL_MAX_LAYER_PARAM][0]}}return undefined}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Scenario", [],function(){"use strict";return{AppVariant:"APP_VARIANT",VersionedAppVariant:"VERSIONED_APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Utils", ["sap/base/i18n/Localization","sap/base/util/isPlainObject","sap/base/util/uid","sap/base/util/restricted/_isEqual","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/base/ManagedObject","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/core/Component","sap/ui/core/Element","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Scenario","sap/ui/thirdparty/hasher","sap/ui/core/mvc/View"],function(e,t,r,n,i,o,a,s,p,u,c,l,f,g){"use strict";function m(e){if(e?.getEntry){return e.getEntry?.("sap.app")?.type}return e?.["sap.app"]?.type}function h(e,t){if(e?.startupParameters&&t&&Array.isArray(e.startupParameters[t])){return e.startupParameters[t][0]}return undefined}const d={isVariantByStartupParameter(e){const t=this.getAppComponentForControl(e);if(t?.getComponentData){return!!h(t.getComponentData(),"sap-app-id")}return false},getAppDescriptor(e){return this.getAppComponentForControl(e)?.getMetadata?.()?.getManifestObject?.().getJson()},isBinding(e,r){let n;try{n=a.bindingParser(e,r)}catch(e){return false}return typeof e==="string"&&!!n||t(e)&&((e.hasOwnProperty("path")||e.hasOwnProperty("parts"))&&!e.hasOwnProperty("ui5object"))},getComponentForControl(e){function t(e){const r=p.getOwnerIdFor(e);if(!r){if(typeof e?.getParent==="function"){const r=e.getParent();if(r){return t(r)}}}return r||""}if(e){const r=t(e);if(r){return p.getComponentById(r)}}return undefined},getAppComponentForControl(e){let t=e instanceof p?e:d.getComponentForControl(e);if(t?.getAppComponent?.()instanceof p){return t.getAppComponent()}if(t?.oComponentData?.appComponent){return t.oComponentData.appComponent}if(t?.getManifestEntry){const e=t.getManifestEntry("sap.app");if(e?.type&&e.type!=="application"){if(t instanceof p){t=d.getComponentForControl(t)}return this.getAppComponentForControl(t)}}return t},getAppComponentForSelector(e){return e.appComponent||d.getAppComponentForControl(e)},getViewForControl(e){if(e instanceof g){return e}if(typeof e?.getParent==="function"){e=e.getParent();return d.getViewForControl(e)}return undefined},getClient(){return new URLSearchParams(window.location.search).get("sap-client")},getConnectors(){const e=c.getFlexibilityServices();return e.map(e=>e?.connector)},getLrepUrl(){const e=c.getFlexibilityServices();const t=e.find(e=>e.connector==="LrepConnector");return t?.url||""},getCurrentLanguage(){const t=e.getLanguage();if(typeof t!=="string"){return""}const r=t.indexOf("-");if(r<0&&t.length<=2){return t.toUpperCase()}if(r>0&&r<=2){return t.substring(0,r).toUpperCase()}return""},getControlType(e){return e?.getMetadata?.()?.getElementName?.()},checkControlId(e,t){if(!t){e=e instanceof a?e:u.getElementById(e);t=d.getAppComponentForControl(e)}return s.checkControlId(e,t)},hasLocalIdSuffix:s.hasLocalIdSuffix,getParsedURLHash(e){return e?.parseShellHash(f.getHash())||{}},getUrlParameter(e){return new URLSearchParams(window.location.search).get(e)},getUshellContainer(){const e=sap.ui.require("sap/ushell/Container");return e?.isInitialized()?e:undefined},createDefaultFileName(e){const t=r().replace(/-/g,"_");return e?`${t}_${e}`:t},createNamespace(e,t){const r=t==="ctrl_variant"?"variants":"changes";const n=e.reference.replace(".Component","");return`apps/${n}/${r}/`},buildLrepRootNamespace(e,t,r){const n="apps";const i="Error in sap.ui.fl.Utils#buildLrepRootNamespace:";if(!e){throw new Error(`${i} for every scenario you need a base ID`)}switch(t){case l.VersionedAppVariant:case l.AppVariant:if(!r){throw new Error(`${i} in the ${t} scenario you additionally need a project ID`)}return`${n}/${e}/appVariants/${r}/`;case l.AdaptationProject:if(!r){throw new Error(`${i} in the ${t} scenario you additionally need a project ID`)}return`${n}/${e}/adapt/${r}/`;case l.FioriElementsFromScratch:case l.UiAdaptation:default:return`${n}/${e}/`}},isApplication(e){return m(e)==="application"},isApplicationComponent(e){return e instanceof p&&d.isApplication(e.getManifestObject())},isEmbeddedComponent(e){const t=d.getAppComponentForControl(e);return!!(e instanceof p&&m(e.getManifestObject())==="component"&&t&&d.isApplicationComponent(t))},indexOfObject(e,t){return e.findIndex(e=>n(e,t))},execPromiseQueueSequentially(e,t,r,n){if(e.length===0){if(r){return Promise.resolve()}return d.FakePromise?new d.FakePromise:Promise.resolve()}const o=e.shift();if(typeof o==="function"){let a;try{a=o()}catch(e){a=Promise.reject(e)}return a.then(function(){if(!r&&a instanceof Promise){r=true}}).catch(function(e){let r="Error during execPromiseQueueSequentially processing occurred";r+=e?`: ${e.message}`:"";i.error(r,e);if(t){if(n){throw new Error(e.message)}else{throw new Error(r)}}}).then(function(){return this.execPromiseQueueSequentially(e,t,r,n)}.bind(this))}i.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(e,t,r,n)},FakePromise:function(e,t,r){d.FakePromise.fakePromiseIdentifier="sap.ui.fl.Utils.FakePromise";this.vValue=e;this.vError=t;this.bContinueWithFakePromise=arguments.length<3||r===d.FakePromise.fakePromiseIdentifier;const n=function(e,t){try{const r=t(e,d.FakePromise.fakePromiseIdentifier);if(o.isThenable(r)){return r}return new d.FakePromise(r)}catch(e){const t=e;return new d.FakePromise(undefined,t)}};d.FakePromise.prototype.then=function(e,t){if(!this.bContinueWithFakePromise){return Promise.resolve(e(this.vValue))}if(!this.vError){return n(this.vValue,e)}else if(t){return n(this.vError,t)}return this};d.FakePromise.prototype.catch=function(e){if(!this.bContinueWithFakePromise){return Promise.reject(e(this.vError))}if(this.vError){return n(this.vError,e)}return this};if(this.vValue instanceof Promise||this.vValue instanceof d.FakePromise){return this.vValue}return undefined},getChangeFromChangesMap(e,t){let r;Object.values(e).some(e=>{r=e.find(e=>e.getId()===t);return r});return r},handleUrlParameters(e,t,r,n){if(d.hasParameterAndValue(t,r,n)){if(e.startsWith("?")){e=e.substr(1,e.length)}const n=e.split("&").filter(e=>e!==`${t}=${r}`);e="";if(n.length>0){e=`?${n.join("&")}`}}else{e+=`${(e.length>0?"&":"?")+t}=${r}`}return e},hasParameterAndValue(e,t,r){return d.getParameter(e,r)===t},getParameter(e,t){return d.getParsedURLHash(t)?.params?.[e]?.[0]||d.getUrlParameter(e)},findAggregation(e,t){return e?.getMetadata?.()?.getAllAggregations?.()?.[t]},getAggregation(e,t){const r=d.findAggregation(e,t);if(r){return e[r._sGetter]()}return undefined},getProperty(e,t){const r=e.getMetadata().getPropertyLikeSetting(t)?._sGetter;return e[r]()},getUShellService(e){if(e){const t=this.getUshellContainer();if(t){return t.getServiceAsync(e)}}return Promise.resolve()},async getUShellServices(e){const t={};for(const r of e){t[r]=await this.getUShellService(r)}return t}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/DelegateMediator", ["sap/base/Log","sap/base/util/restricted/_pick","sap/ui/fl/requireAsync"],function(e,t,r){"use strict";const n={};let o={};let a={};function i(e){const t=e.getModel?.();if(!t){return undefined}return t.getMetadata().getName()}function l(e,t){t||=i(e);const r=o[t];return r}async function c(e,t){const r=await t.getControlMetadata(e);const n=a[r.getName()];return n}function d(t,n,o){return r(o.name).catch(r=>{e.error(`Failed to load the delegate for the control ${n.getId(t)}\n\t\t\t${r.message}`);return undefined})}function s(e,t,r){const n=[];r.forEach(function(r){if(r){n.push(async function(){const n=await d(e,t,r);if(n){r.instance=n||{};return r}return undefined}())}else{n.push(Promise.resolve())}});return Promise.all(n)}n.registerReadDelegate=function(e){if(!(e.modelType&&e.delegate)){throw new Error("'modelType' and 'delegate' properties are required for registration!")}if(o[e.modelType]){throw new Error(`modelType ${e.modelType} is already defined!`)}o[e.modelType]={name:e.delegate,modelType:e.modelType}};n.registerWriteDelegate=function(e){if(!(e.controlType&&e.delegate)){throw new Error("'controlType' and 'delegate' properties are required for registration!")}a[e.controlType]={name:e.delegate,requiredLibraries:e.requiredLibraries,delegateType:e.delegateType,controlType:e.controlType,payload:e.payload}};function u(e){return e?{...e,modelType:e.modelType||e.payload?.modelType,instance:t(e.instance,["getPropertyInfo","getRepresentedProperties"])}:undefined}n.getReadDelegateForControl=async function(e,t,r){let n=l(e,r);let o=t.getFlexDelegate(e);[o,n]=await s(e,t,[o,n]);return o?.instance.getPropertyInfo?u(o):u(n)};function p(e,r){return e?{...e,controlType:e.controlType||r.getMetadata?.().getName(),instance:t(e.instance,["createLabel","createControlForProperty","createLayout"])}:undefined}n.getWriteDelegateForControl=async function(e,t){let r=await c(e,t);let n=t.getFlexDelegate(e);[n,r]=await s(e,t,[n,r]);return n?.instance.createLabel||n?.instance.createLayout?p(n,e):p(r,e)};n.clear=function(){o={};a={}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes", [],function(){"use strict";return{getChangeTypes(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_ovp_changeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_app_addCdsViews","appdescr_app_removeCdsViews","appdescr_flp_setConfig","appdescr_ui5_addNewModelEnhanceWith","appdescr_ui5_removeModel","appdescr_ui5_replaceComponentUsage","appdescr_ui5_setMinUI5Version","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui5_addLibraries","appdescr_ui5_addNewModel","appdescr_app_addAnnotationsToOData","appdescr_ui5_addComponentUsages","appdescr_ui5_setFlexExtensionPointEnabled","appdescr_url_setUri","appdescr_fiori_setRegistrationIds","appdescr_card","appdescr_card_designtime","appdescr_fiori_setAbstract","appdescr_fe_changePageConfiguration","appdescr_ui5_changeModel","appdescr_ui_generic_app_addNewObjectPage","appdescr_ui_generic_app_changePageConfiguration","appdescr_fe_addNewPage"]},getCondensableChangeTypes(){return["appdescr_app_setTitle","appdescr_app_setInfo","appdescr_app_setShortTitle","appdescr_app_setSubTitle","appdescr_app_setDescription","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_fiori_setRegistrationIds","appdescr_smb_changeNamespace"]}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Applier", ["sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/Utils"],function(e,n,t,o,r,a,i,s,c){"use strict";let l=c.FakePromise?new c.FakePromise:Promise.resolve();const p={};const d={};function g(t,o,r,a){const i=n(o.join(" "),r);e[t](i,a||"")}async function f(e,n){const t=e.getSelector&&e.getSelector();if(!t||!t.id&&!t.name){throw Error("No selector in change found or no selector ID.")}function o(e){if(c.indexOfObject(n.failedSelectors,e)>-1){throw Error("A change depending on that control already failed, so the current change is skipped")}}const r=await n.modifier.bySelectorTypeIndependent(t,n.appComponent,n.view);if(!r){throw Error("A flexibility change tries to change a nonexistent control.")}o(t);const a=e.getDependentControlSelectorList();a.forEach(e=>{const t=n.modifier.bySelector(e,n.appComponent,n.view);if(!t){throw new Error("A dependent selector control of the flexibility change is not available.")}o(e)});return r}function u(e){return e.modifier.targets==="xmlTree"}function h(e,n,t,o){const i=a.getControlIfTemplateAffected(n,e,t).control;const c=t.modifier;const l=i&&!!r.getAppliedCustomDataValue(i,n,c);const p=i&&r.hasChangeApplyFinishedCustomData(i,n,c);const d=n.isApplyProcessFinished();if(d&&!p){if(!o){s.copyDependenciesFromCompleteDependencyMap(n,t.appComponent)}n.setInitialApplyState()}else if(!d&&p){if(l){n.setRevertData(r.getParsedRevertDataFromCustomData(i,n,c));n.markSuccessful()}else{n.markFailed()}}else if(d&&p){n.markSuccessful()}}function y(e,n){if(u(n)&&e.getJsOnly()){const n="Change cannot be applied in XML. Retrying in JS.";e.setInitialApplyState();throw Error(n)}}async function m(e,n,o,a){if(o instanceof t){n.control=o}if(n.control){await a.modifier.updateAggregation(n.originalControl,e.getContent().boundAggregation)}await r.addAppliedCustomData(n.control,e,a,u(a));const i={success:true};e.markSuccessful(i);return i}async function C(e,n,t,o){const a=u(o);const i={success:false,error:e};const s=n.getId();const c="Change ''{0}'' could not be applied.";const l=e instanceof Error;const p=r.getCustomDataIdentifier(false,l,a);switch(p){case r.notApplicableChangesCustomDataKey:g("info",[c,e.message],[s]);break;case r.failedChangesCustomDataKeyXml:g("warning",[c,"Merge error detected while processing the XML tree."],[s],e.stack);break;case r.failedChangesCustomDataKeyJs:g("error",[c,"Merge error detected while processing the JS control tree."],[s],e.stack);break;default:}await r.addFailedCustomData(t.control,n,o,p);if(a){n.setInitialApplyState()}else{n.markFailed(i)}return i}function A(n,t){const o=t.getChangeType();const r=t.getSelector().id;const a=`${t.getNamespace()+t.getId()}.${t.getFileType()}`;let i="A flexibility change could not be applied.";i+="\nThe displayed UI might not be displayed as intended.";if(n.message){i+=`\n   occurred error message: '${n.message}'`}i+=`\n   type of change: '${o}'`;i+=`\n   LRep location of the change: ${a}`;i+=`\n   id of targeted control: '${r}'.`;e.warning(i,undefined,"sap.ui.fl.apply._internal.changes.Applier")}function w(e,n,t){const r={appComponent:t,modifier:o};const a=o.bySelector(e.originalSelectorToBeAdjusted,t);let i=n.getBindingInfo(e.getContent().boundAggregation).template;if(a.getParent()){const e=[];let n=a;do{e.push({aggregation:n.sParentAggregationName,index:n.getParent().getAggregation(n.sParentAggregationName).indexOf(n)});n=n.getParent()}while(n.getParent());e.reverse();e.forEach(e=>{i=i.getAggregation(e.aggregation)[e.index]})}e.addDependentControl(i,"originalSelector",r)}function S(e,n,t){let o=e.findIndex(e=>e.handler===n);if(o<0){o=e.length;e.push({handler:n,controls:[]})}if(!e[o].controls.includes(t)){e[o].controls.push(t)}}async function b(e,n,t,o){const r=[];const a=e.getId();const s=t.mChanges[a]||[];let l;if(t.mControlsWithDependencies[a]){i.removeControlsDependencies(t,a);l=true}s.forEach(s=>{if(s.originalSelectorToBeAdjusted){w(s,e,o);delete s.originalSelectorToBeAdjusted}if(s._ignoreOnce){delete s._ignoreOnce}else if(s.isApplyProcessFinished()){i.resolveDependenciesForChange(t,s.getId(),a)}else if(!t.mDependencies[s.getId()]){r.push(async()=>{await d.applyChangeOnControl(s,e,n);i.resolveDependenciesForChange(t,s.getId(),a)})}else{const o=d.applyChangeOnControl.bind(d,s,e,n);i.addChangeApplyCallbackToDependency(t,s.getId(),o)}});if(s.length||l){await c.execPromiseQueueSequentially(r);await i.processDependentQueue(t,o,a)}p[a].shift().resolveFunction()}d.addPreConditionForInitialChangeApplying=function(e){l=l.then(()=>e)};d.applyChangeOnControl=async function(e,n,t){const o=a.getControlIfTemplateAffected(e,n,t);try{const n=t.changeHandler||await a.getChangeHandler({flexObject:e,control:o.control,controlType:o.controlType,modifier:t.modifier});y(e,t);if(e.hasApplyProcessStarted()){const n=await e.addPromiseForApplyProcessing();e.markSuccessful();return n}if(!e.isApplyProcessFinished()){e.startApplying();try{const r=await n.applyChange(e,o.control,t);return m(e,o,r,t)}catch(n){return C(n,e,o,t)}}const r={success:true};e.markSuccessful(r);return r}catch(e){return{success:false,error:e}}};d.applyMultipleChanges=async function(e,n){n.modifier=o;for(const t of e){const e=o.bySelector(t.getSelector(),n.appComponent);const r=s.getLiveDependencyMap(n.reference);if(e){h(e,t,n,true);if(!t.isApplyProcessFinished()){t.setQueuedForApply()}let o;try{o=await d.applyChangeOnControl(t,e,n)}catch(e){o={success:false}}if(o.success){i.addRuntimeChangeToMap(t,n.appComponent,r)}}else{i.addChangeAndUpdateDependencies(t,n.appComponent.getId(),r)}}};d.applyAllChangesForControl=async function(e,n,t){const r=s.getLiveDependencyMap(n);const a=t.getId();const i=r.mChanges[a]||[];const d={modifier:o,appComponent:e,view:c.getViewForControl(t)};if(p[a]?.length){await p[a][p[a].length-1].promise}i.forEach(e=>{h(t,e,d);if(!e.isApplyProcessFinished()&&!e._ignoreOnce){e.setQueuedForApply()}});p[a]||=[];const g={};g.promise=new Promise(e=>{g.resolveFunction=e});p[a].push(g);l=l.then(b.bind(undefined,t,d,r,e));return l};d.applyAllChangesForXMLView=async function(n,t){if(!Array.isArray(t)){const o=`No list of changes was passed for processing the flexibility on view: ${n.view}.`;e.error(o,undefined,"sap.ui.fl.apply._internal.changes.Applier");t=[]}const o=[];n.failedSelectors=[];for(const e of t){try{const t=await f(e,n);const r=a.getControlIfTemplateAffected(e,t,n);n.changeHandler=await a.getChangeHandler({flexObject:e,control:r.control,controlType:r.controlType,modifier:n.modifier});e.setQueuedForApply();h(t,e,n,true);if(!e.isApplyProcessFinished()){if(typeof n.changeHandler.onAfterXMLChangeProcessing==="function"){S(o,n.changeHandler,t)}const r=await d.applyChangeOnControl(e,t,n);if(!r.success){throw Error(r.error)}}}catch(t){e.getDependentSelectorList().forEach(e=>{if(c.indexOfObject(n.failedSelectors,e)===-1){n.failedSelectors.push(e)}});A(t,e)}}delete n.failedSelectors;o.forEach(t=>{t.controls.forEach(o=>{try{t.handler.onAfterXMLChangeProcessing(o,n)}catch(n){e.error("Error during onAfterXMLChangeProcessing",n)}})});return n.view};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/FlexCustomData", ["sap/base/Log","sap/ui/core/CustomData"],function(t){"use strict";const a={};a.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";a.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";a.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";a.notApplicableChangesCustomDataKey="sap.ui.fl.notApplicableChanges";function e(t,a,e,s){const o=s.modifier.getCustomDataInfo(t,a);if(!o.customData){return s.modifier.createAndAddCustomData(t,a,e,s.appComponent)}return Promise.resolve(s.modifier.setProperty(o.customData,"value",e))}function s(t,a){const e=a.getRevertData();if(t&&e!==undefined){return JSON.stringify(e)}return"true"}a.getAppliedCustomDataValue=function(t,e,s){const o=s.getCustomDataInfo(t,a._getCustomDataKey(e,a.appliedChangesCustomDataKey));return o.customDataValue};a.getParsedRevertDataFromCustomData=function(e,s,o){const u=a.getAppliedCustomDataValue(e,s,o);try{return u&&JSON.parse(u)}catch(a){t.error("Could not parse revert data from custom data",u);return undefined}};a.hasChangeApplyFinishedCustomData=function(t,e,s){const o=s.getCustomDataInfo(t,a._getCustomDataKey(e,a.appliedChangesCustomDataKey));if(o.customData){return true}const u=s.getCustomDataInfo(t,a._getCustomDataKey(e,a.failedChangesCustomDataKeyJs));if(u.customData){return true}const n=s.getCustomDataInfo(t,a._getCustomDataKey(e,a.notApplicableChangesCustomDataKey));if(n.customData){return true}return false};a.addAppliedCustomData=function(t,o,u,n){const r=s(n,o);const i=a._getCustomDataKey(o,a.appliedChangesCustomDataKey);return e(t,i,r,u)};a.addFailedCustomData=function(t,s,o,u){const n=a._getCustomDataKey(s,u);return e(t,n,"true",o)};a.destroyAppliedCustomData=function(t,e,s){const o=a._getCustomDataKey(e,a.appliedChangesCustomDataKey);const u=s.getCustomDataInfo(t,o);if(u.customData){s.destroy(u.customData)}};a.getCustomDataIdentifier=function(t,e,s){if(t){return a.appliedChangesCustomDataKey}if(!e){return a.notApplicableChangesCustomDataKey}if(s){return a.failedChangesCustomDataKeyXml}return a.failedChangesCustomDataKeyJs};a._getCustomDataKey=function(t,a){return`${a}.${t.getId()}`};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Reverter", ["sap/base/Log","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/Utils"],function(e,t,r,n,o,a,i){"use strict";const s={};async function l(e){if(!e.isApplyProcessFinished()&&e.hasApplyProcessStarted()){const t=await e.addPromiseForApplyProcessing();if(t&&t.error){e.markRevertFinished(t.error);throw Error(t.error)}}}function c(e,t){const r=e.getId();const n=a.getLiveDependencyMap(t);o.removeChangeFromMap(n,r);o.removeChangeFromDependencies(n,r)}async function p(e,t,n,o){const a=await s.revertChangeOnControl(e,t,n);r.destroyAppliedCustomData(a||t,e,o.modifier);if(a){c(e,o.reference)}}s.revertChangeOnControl=async function(t,r,o){const a=n.getControlIfTemplateAffected(t,r,o);try{const e=await n.getChangeHandler({flexObject:t,control:a.control,controlType:a.controlType,modifier:o.modifier});await l(t);if(t.isSuccessfullyApplied()){t.startReverting()}else{throw Error("Change was never applied")}await e.revertChange(t,a.control,o);a.control=o.modifier.bySelector(t.getSelector(),o.appComponent,o.view);if(a.bTemplateAffected){await o.modifier.updateAggregation(a.control,t.getContent().boundAggregation)}t.markRevertFinished();return a.control}catch(r){const n=`Change could not be reverted: ${r.message}`;e.error(n);t.markRevertFinished(n);return false}};s.revertMultipleChanges=function(e,r){const n=[];e.forEach(e=>{e.setQueuedForRevert();n.push(()=>{const t=e.getSelector&&e.getSelector();const n=r.modifier.bySelector(t,r.appComponent);if(!n){c(e,r.reference);return i.FakePromise?new i.FakePromise:Promise.resolve()}const o={modifier:r.modifier,appComponent:r.appComponent,view:i.getViewForControl(n)};return p(e,n,o,r)})});const o=i.execPromiseQueueSequentially(n);t.addPreConditionForInitialChangeApplying(o);return o};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Utils", ["sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/flexObjects/AnnotationChange","sap/ui/fl/apply/_internal/flexObjects/AppDescriptorChange","sap/ui/fl/apply/_internal/flexObjects/VariantChange","sap/ui/fl/apply/_internal/flexObjects/VariantManagementChange","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/requireAsync","sap/ui/fl/Utils"],function(e,t,n,a,r,i,l,o,c,s){"use strict";function f(e,t){if(t||e.hasApplyProcessStarted()){return false}return true}function g(e){return e.flexObject instanceof r||e.flexObject instanceof i}const p={getControlIfTemplateAffected(e,t,n){const a=n.modifier;const r={originalControl:t};const i=e.getOriginalSelector();if(e.getContent().boundAggregation&&i){r.control=a.bySelector(i,n.appComponent,n.view);r.controlType=a.getControlType(r.control);r.bTemplateAffected=true}else{r.control=t;r.controlType=a.getControlType(t);r.bTemplateAffected=false}return r},async getChangeHandler(t){const r=t.changeType||t.flexObject?.getChangeType();if(t.flexObject instanceof a||t.appDescriptorChange){const n=t.strategy||await e.getRuntimeStrategy();try{const e=await n.registry();return await(e[r]?.())}catch(e){n.handleError(e)}}else if(t.flexObject instanceof n||t.annotationChange){return o.getAnnotationChangeHandler({changeType:r})}else if(g(t)){return l.getChangeInformationProvider(t.flexObject)}else if(t.control){const e=await t.modifier.getLibraryName(t.control);const n=await c("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration");await n.waitForChangeHandlerRegistration(e);const a=t.layer||t.flexObject?.getLayer();return o.getChangeHandler(r,t.controlType,t.control,t.modifier,a)}return undefined},checkIfDependencyIsStillValid(e,n,a,r){const i=s.getChangeFromChangesMap(a.mChanges,r);if(!i){return false}const l=n.bySelector(i.getSelector(),e);if(!l){return true}const o=t.hasChangeApplyFinishedCustomData(l,i,n);return f(i,o)},isChangeInView(e,t){const n=e.modifier;const a=e.appComponent;const r=t.getSelector();if(!r){return false}if(r.viewSelector){const t=n.getControlIdBySelector(r.viewSelector,a);return t===e.viewId}const i=r.id;if(i){let n;if(t.getSelector().idIsLocal){if(a){n=a.getLocalId(e.viewId)}}else{n=e.viewId}let r=0;let l;do{r=i.indexOf("--",r);l=i.slice(0,r);r++}while(l!==n&&r>0);return l===n}return false}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Applier", ["sap/base/util/isEmptyObject","sap/ui/fl/apply/_internal/changes/Utils"],function(t,s){"use strict";const e={async applyChanges(e,n,a){const c=[];for(const t of n){c.push(await s.getChangeHandler({flexObject:t,strategy:a}))}c.forEach(function(s,c){try{const r=n[c];e=s.applyChange(e,r);if(!s.skipPostprocessing&&!t(r.getTexts())){e=a.processTexts(e,r.getTexts())}}catch(t){a.handleError(t)}});return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory", ["sap/ui/fl/requireAsync","sap/base/Log"],function(r,e){"use strict";function t(r,e){const n=Array.isArray(r)?[...r]:{...r};Object.entries(n).forEach(([r,s])=>{if(typeof s==="object"&&s!==null){n[r]=t(s,e)}else if(typeof s==="string"){n[r]=s.replaceAll(/{{.*?}}/g,r=>{const t=r.slice(2,-2);const n=e[t];return n||r})}});return n}var n={registry(){return r("sap/ui/fl/apply/_internal/changes/descriptor/Registration")},handleError(r){e.error(r)},processTexts(r,n){const s={};Object.entries(n).forEach(([r,{value:t}])=>{if(t[""]){s[r]=t[""];return}e.error("Text change has to contain default language")});return t(r,s)}};var s={getRuntimeStrategy(){return n}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/InlineApplier", ["sap/ui/fl/apply/_internal/changes/descriptor/Applier","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory"],function(e,t){"use strict";const n="$sap.ui.fl.changes";function r(e){const r=e&&e.getEntry&&e.getEntry(n)&&e.getEntry(n).descriptor||[];return r.map(function(e){return t.createAppDescriptorChange(e)})}const s={applyChanges(t,s){const p=r(t);const a=t.getJson();delete a[n];return p.length?e.applyChanges(a,p,s):Promise.resolve()}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor", ["sap/ui/fl/apply/_internal/changes/descriptor/Applier","sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/performance/Measurement","sap/ui/fl/Utils"],function(e,t,n,i,a,r){"use strict";var s={preprocessManifest(s,p){if(!r.isApplication(s,true)||!p.id){return Promise.resolve(s)}a.start("flexStateInitialize","Initialization of flex state",["sap.ui.fl"]);const l=p.componentData||{};const o=i.getFlexReference({manifest:s,componentData:l});if(!i.getChangeManifestFromAsyncHints(p.asyncHints,o)){n.initialize({componentData:l,asyncHints:p.asyncHints,rawManifest:s,componentId:p.id,reference:o,partialFlexState:true}).then(a.end.bind(undefined,"flexStateInitialize"));return Promise.resolve(s)}return n.initialize({componentData:l,asyncHints:p.asyncHints,rawManifest:s,componentId:p.id,reference:o,partialFlexState:true}).then(function(){a.end("flexStateInitialize");a.start("flexAppDescriptorMerger","Client side app descriptor merger",["sap.ui.fl"]);const i={...s};const r=n.getAppDescriptorChanges(o);return e.applyChanges(i,r,t.getRuntimeStrategy())}).then(function(e){a.end("flexAppDescriptorMerger");return e})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/controlVariants/URLHandler", ["sap/ui/core/Component","sap/base/Log","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/hasher","sap/ui/fl/apply/_internal/controlVariants/Utils"],function(e,a,t,r,n,o,i,s,l){"use strict";var c={};var m={};function d(e,a){var t=[];return e.reduce(function(e,r){var n=a.getVariantManagementReference(r).variantManagementReference;if(n){if(t.includes(n)){e.updateRequired=true;return e}t.push(n)}if(n&&a.oData[n].currentVariant!==r){e.updateRequired=true;if(a.oData[n].currentVariant!==a.oData[n].defaultVariant){e.parameters.push(a.oData[n].currentVariant)}}else{e.parameters.push(r)}return e},{updateRequired:false,parameters:[]})}function p(e,a){const t=e.getUShellService("URLParsing")?.parseShellHash(a||s.getHash());var r=n.get(["params",l.VARIANT_TECHNICAL_PARAMETER],t);if(Array.isArray(r)&&r.length===1){r=r[0].split(",")}if(r){var o=d(r,e);if(o.updateRequired){m.update({updateURL:!e._bDesignTimeMode,parameters:o.parameters,updateHashEntry:true,model:e})}}}function u(e,t){try{const a=e.getUShellService("URLParsing");if(a){p(e,t)}}catch(e){a.error(e.message)}const r=e.getUShellService("ShellNavigationInternal");return r?.NavigationFilterStatus.Continue}function f(e){const a=e.getUShellService("ShellNavigationInternal");if(!c[e.sFlexReference]){c[e.sFlexReference]=u.bind(null,e);if(a){a.registerNavigationFilter(c[e.sFlexReference])}}}function A(e){const a=e.getUShellService("ShellNavigationInternal");if(a){a.unregisterNavigationFilter(c[e.sFlexReference]);delete c[e.sFlexReference]}}function R(e){const r=e.model;const n=r.getUShellService("URLParsing");const o=r.getUShellService("Navigation");const i=n?.parseShellHash(s.getHash());if(i?.params){const c={...i.params};const m=r.oAppComponent?.getComponentData?.()?.technicalParameters;if(!m){a.warning("Component instance not provided, so technical parameters in component data and browser history remain unchanged")}if(e.parameters.length===0){delete i.params[l.VARIANT_TECHNICAL_PARAMETER];if(m){delete m[l.VARIANT_TECHNICAL_PARAMETER]}}else{i.params[l.VARIANT_TECHNICAL_PARAMETER]=[e.parameters.toString()];if(m){m[l.VARIANT_TECHNICAL_PARAMETER]=[e.parameters.toString()]}}if(e.silent){s.changed.active=false;s.replaceHash(n.constructShellHash(i));s.changed.active=true}else if(!t(c,i.params)){o.navigate({target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false})}}}function h(e){var a={index:-1};var t=e.model;var n=t.getUShellService("URLParsing");var i=n?.parseShellHash(s.getHash()).params;if(i){a.parameters=[];if(t._bDesignTimeMode){i[l.VARIANT_TECHNICAL_PARAMETER]=m.getStoredHashParams(e)}if(Array.isArray(i[l.VARIANT_TECHNICAL_PARAMETER])){if(i[l.VARIANT_TECHNICAL_PARAMETER].length>1){i[l.VARIANT_TECHNICAL_PARAMETER]=i[l.VARIANT_TECHNICAL_PARAMETER].map(decodeURIComponent)}else if(i[l.VARIANT_TECHNICAL_PARAMETER].length===1){const e=i[l.VARIANT_TECHNICAL_PARAMETER][0];const a=e&&decodeURIComponent(e);i[l.VARIANT_TECHNICAL_PARAMETER]=a?a.split(","):[]}i[l.VARIANT_TECHNICAL_PARAMETER].some(function(r,n){if(!o(t.getVariant(r,e.vmReference))){a.index=n;return true}return false})}}return r(a,i&&i[l.VARIANT_TECHNICAL_PARAMETER]&&{parameters:i[l.VARIANT_TECHNICAL_PARAMETER]})}function v(e){var a=e.getUShellService("URLParsing");var t=a?.parseShellHash(s.getHash());return t?.params&&t.params[l.VARIANT_TECHNICAL_PARAMETER]}m.variantTechnicalParameterName="sap-ui-fl-control-variant-id";m.initialize=function(e){var a=e.model;m.attachHandlers(e);a._oHashData={hashParams:[],controlPropertyObservers:[],variantControlIds:[]};p(a)};m.updateVariantInURL=function(e){var a=m.removeURLParameterForVariantManagement(e);if(!a.parameters){return}var t=a.parameters||[];var r=a.index;var n=e.newVReference===e.model.oData[e.vmReference].defaultVariant;if(!n){if(r===-1){t=t.concat([e.newVReference])}else{t=t.slice(0,r).concat([e.newVReference],t.slice(r))}}if(!n||r>-1){m.update({parameters:t,updateURL:!e.model._bDesignTimeMode,updateHashEntry:true,model:e.model})}};m.removeURLParameterForVariantManagement=function(e){var a=h(e);if(a.index>-1){a.parameters.splice(a.index,1)}return a};m.attachHandlers=function(a){function t(){return a.model._oVariantSwitchPromise.then(function(){a.model._oHashData.controlPropertyObservers.forEach(function(e){e.destroy()});A(a.model);a.model.destroy();a.model.oComponentDestroyObserver.unobserve(a.model.oAppComponent,{destroy:true});a.model.oComponentDestroyObserver.destroy()})}f(a.model);if(!a.model.oComponentDestroyObserver&&a.model.oAppComponent instanceof e){a.model.oComponentDestroyObserver=new i(t.bind(null));a.model.oComponentDestroyObserver.observe(a.model.oAppComponent,{destroy:true})}};m.registerControl=function(e){if(e.updateURL){e.model._oHashData.variantControlIds.push(e.vmReference)}};m.update=function(e){if(!Array.isArray(e.parameters)){a.info("Variant URL parameters could not be updated since invalid parameters were received");return}if(e.updateURL){R(e)}if(e.updateHashEntry){e.model._oHashData.hashParams=e.parameters}};m.getStoredHashParams=function(e){return Array.prototype.slice.call(e.model._oHashData.hashParams)};m.handleModelContextChange=function(e){var a="modelContextChange";function t(a,t){var r=t.model.getVariantManagementReferenceForControl(a.getSource());var n=t.model._oHashData.variantControlIds;var o=n.indexOf(r);if(o>-1){n.slice(o).forEach(function(a){if(h({vmReference:a,model:e.model}).index===-1){t.model.switchToDefaultForVariantManagement(a)}})}}var r=new i(function(r){if(r.current===true&&r.old===false){r.object.attachEvent(a,{model:e.model},t)}else if(r.current===false&&r.old===true){r.object.detachEvent(a,t)}});r.observe(e.vmControl,{properties:["resetOnContextChange"]});e.model._oHashData.controlPropertyObservers.push(r);if(e.vmControl.getResetOnContextChange()!==false){e.vmControl.attachEvent(a,{model:e.model},t)}};m.clearAllVariantURLParameters=function(e){if(v(e.model)){m.update({updateURL:true,parameters:[],updateHashEntry:false,model:e.model})}};return m});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/controlVariants/Utils", ["sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/fl/Utils"],function(e,t,r){"use strict";function n(e,t){if(!t){return undefined}if(e.indexOf(t.getId())>-1){return t.getId()}return n(e,t.getParent())}function a(e,n){var a=r.getAppComponentForControl(e);var o=a.getRootControl();var i=[];if(!n&&o.getDomRef()){i=Array.from(o.getDomRef().querySelectorAll(".sapUiFlVarMngmt"))}if(n||i.length===0){i=Array.from(t.getDomRef().querySelectorAll(".sapUiFlVarMngmt"))}return i.map(function(e){return e.id})}var o={DEFAULT_AUTHOR:"SAP",VARIANT_TECHNICAL_PARAMETER:"sap-ui-fl-control-variant-id",compareVariants(e,t){if(e.getName().toLowerCase()<t.getName().toLowerCase()){return-1}else if(e.getName().toLowerCase()>t.getName().toLowerCase()){return 1}return 0},getIndexToSortVariant(e,t){var r=e.length;e.some(function(e,n){if(o.compareVariants(t.instance,e.instance)<0){r=n;return true}});return r},getRelevantVariantManagementControlId(t,r,o){var i={};if(!r||!r.length){r=a(t,o)}var u=r.reduce(function(t,r){var n=e.getElementById(r);if(n){var a=n.getFor();a.forEach(function(e){i[e]=r});t=t.concat(a)}return t},[]);var g=n(u,t);return i[g]},belongsToVariantManagement(e){var t=a(e);return!!o.getRelevantVariantManagementControlId(e,t)},getAllVariantManagementControlIds(e){return a(e)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/extensionPoint/Registry", ["sap/ui/base/ManagedObjectObserver","sap/ui/fl/Utils"],function(e,t){"use strict";var n={};var r={};var a={};var o={};var i={};function g(e){var t=e.object.getId();a[t].forEach(function(e){o[e.view.getId()][e.name].bParentIsDestroyed=true})}function s(e){var n=e.object.getId();a[n].forEach(function(n){var r=n.aggregationName;if(r===e.name){var a=t.getAggregation(e.object,r);var o=[].concat(a||[]).map(function(e){return e.getId()});if(e.mutation==="insert"){if(o.indexOf(e.child.getId())<n.index){n.index++}}else{if(Array.isArray(n.defaultContent)){n.defaultContent=n.defaultContent.filter(function(t){return t.getId()!==e.child.getId()})}if(Array.isArray(n.createdControls)){n.createdControls=n.createdControls.filter(function(t){return t!==e.child.getId()})}if(n.aggregation.indexOf(e.child.getId())<n.index){n.index--}}n.aggregation=o}})}function d(e){if(e.type==="destroy"){g(e)}else{s(e)}}function c(t,n){var a=t.getId();if(!r[a]){var o=new e(d.bind(this));o.observe(t,{aggregations:[n],destroy:true});r[a]={observer:o,aggregations:[n]}}else{var i=r[a].observer.isObserved(t,{aggregations:[n]});if(!i){r[a].aggregations.push(n);r[a].observer.observe(t,{aggregations:r[a].aggregations,destroy:true})}}}function f(e,n,r){var g=r.view.getId();var s=t.getAggregation(e,n);var d=[].concat(s||[]).map(function(e){return e.getId()});var c=e.getId();a[c]||=[];o[g]||={};r.aggregation=d;if(i[g]&&i[g][r.name]){r.createdControls=i[g][r.name];delete i[g][r.name]}a[c].push(r);o[g][r.name]=r}n.registerExtensionPoint=function(e){var t=e.targetControl;var n=e.aggregationName;c(t,n);f(t,n,e)};n.getExtensionPointInfo=function(e,t){return o[t.getId()]&&o[t.getId()][e]};n.getExtensionPointInfoByViewId=function(e){return o[e]||{}};n.getExtensionPointInfoByParentId=function(e){return a[e]||[]};n.clear=function(){Object.keys(r).forEach(function(e){r[e].observer.disconnect();r[e].observer.destroy()});r={};a={};o={}};n.addCreatedControls=function(e,t,n){var r;if(o[t]&&o[t][e]){r=o[t][e].createdControls||[];o[t][e].createdControls=r.concat(n)}else{i[t]||={};r=i[t][e]||[];i[t][e]=r.concat(n)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/AnnotationChange", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(t){"use strict";var e=t.extend("sap.ui.fl.apply._internal.flexObjects.AnnotationChange",{metadata:{properties:{serviceUrl:{type:"string",defaultValue:""}}},constructor:function(...e){t.apply(this,e);this.setFileType("annotation_change")}});e.getMappingInfo=function(){return{...t.getMappingInfo(),serviceUrl:"selector.serviceUrl"}};e.prototype.getMappingInfo=function(){return e.getMappingInfo()};e.prototype.getValue=function(){return this.getText("annotationText")?this.getText("annotationText"):this.getContent().value};e.prototype.getIdForCondensing=function(){return this.getServiceUrl()};e.prototype.canBeCondensed=function(){return true};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/AppDescriptorChange", ["sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(e,t){"use strict";var n=t.extend("sap.ui.fl.apply._internal.flexObjects.AppDescriptorChange",{metadata:{properties:{appDescriptorChange:{type:"boolean",defaultValue:true}}}});n.getMappingInfo=function(){return{...t.getMappingInfo(),appDescriptorChange:"appDescriptorChange"}};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.getIdForCondensing=function(){return`appDescriptor_${this.getFlexObjectMetadata().reference}`};n.prototype.canBeCondensed=function(){return e.getCondensableChangeTypes().includes(this.getChangeType())};n.prototype.getSelector=function(){return{}};n.prototype.isValidForDependencyMap=function(){return false};n.prototype.getVariantReference=function(){return undefined};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/CompVariant", ["sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/Variant","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,r,i,n,a,s){"use strict";var o=r.extend("sap.ui.fl.apply._internal.flexObjects.CompVariant",{metadata:{properties:{persisted:{type:"boolean",defaultValue:true},persistencyKey:{type:"string"}},aggregations:{revertData:{type:"sap.ui.base.ManagedObject",multiple:true,singularName:"revertData"},changes:{type:"sap.ui.base.ManagedObject",multiple:true}}},constructor:function(...t){const[e]=t;r.apply(this,t);this.setFileType("variant");if(e.favorite!==undefined){this.setFavorite(!!e.favorite)}else if(e.layer===n.VENDOR||e.layer===n.CUSTOMER_BASE){this.setFavorite(true)}}});o.STANDARD_VARIANT_ID="*standard*";o.getMappingInfo=function(){return{...r.getMappingInfo(),persistencyKey:"selector.persistencyKey",standardVariant:"standardVariant",variantId:"variantId"}};o.prototype.getMappingInfo=function(){return o.getMappingInfo()};function p(t){var e=a.getInstanceOrUndef();var r=e&&e.getUserId();return!r||!t||r.toUpperCase()===t.toUpperCase()}function u(t,e,r){if(e){return t===e}else if(t===n.USER){return true}var s=a.getInstanceOrUndef();if(i.isSapUiLayerParameterProvided()){e=i.getCurrentLayer()}else{e||=s.isPublicLayerAvailable()?n.PUBLIC:n.CUSTOMER}var o=t===e;var u=s.isKeyUser()||p(r);return o&&u}function l(t){return!t||s.getCurrentLanguage()===t}function c(t,e){var r=a.getInstanceOrUndef();if(!r){return true}if(!t||!e){return true}var i=r.getSystem();var n=r.getClient();return i===t&&e===n}o.prototype.getPackage=function(){return this.getFlexObjectMetadata().packageName};o.prototype.isVariant=function(){return true};o.prototype.isRenameEnabled=function(t){return!this.getStandardVariant()&&this.isEditEnabled(t)&&(!this.isTranslationEnabled()||l(this.getSupportInformation().originalLanguage))};o.prototype.isEditEnabled=function(t){var e=t&&i.isDeveloperLayer(t);var r=c(this.getSupportInformation().sourceSystem,this.getSupportInformation().sourceClient);var n=u(this.getLayer(),t,this.getOwnerId());return e||r&&n};o.prototype.isDeleteEnabled=function(t){var e=c(this.getSupportInformation().sourceSystem,this.getSupportInformation().sourceClient);return e&&u(this.getLayer(),t,this.getOwnerId())&&!this.getStandardVariant()};o.prototype.isTranslationEnabled=function(){return!i.isOverLayer(this.getLayer(),n.CUSTOMER)};o.prototype.storeFavorite=function(t){if(t!==this.getFavorite()){this.setState(e.LifecycleState.UPDATED);this.setFavorite(t)}};o.prototype.storeVisible=function(t){if(t!==this.getVisible()){this.setState(e.LifecycleState.UPDATED);this.setVisible(t)}};o.prototype.getOwnerId=function(){return this.getSupportInformation().user||""};o.prototype.storeContent=function(t){this.setContent(t)};o.prototype.storeExecuteOnSelection=function(t){if(t!==this.getExecuteOnSelection()){this.setState(e.LifecycleState.UPDATED);this.setExecuteOnSelection(t)}};o.prototype.storeName=function(t){this.setName(t)};o.prototype.storeContexts=function(t){this.setContexts(t);this.setState(e.LifecycleState.UPDATED)};o.prototype.cloneFileContentWithNewId=function(...t){var e=r.prototype.cloneFileContentWithNewId.apply(this,t);e.variantId=e.fileName;return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/CompVariantRevertData", ["sap/ui/fl/apply/_internal/flexObjects/RevertData"],function(e){"use strict";return e.extend("sap.ui.fl.apply._internal.flexObjects.CompVariantRevertData",{metadata:{properties:{change:{type:"object"}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/ControllerExtensionChange", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(e){"use strict";var t=e.extend("sap.ui.fl.apply._internal.flexObjects.ControllerExtensionChange",{metadata:{properties:{controllerName:{type:"string"}}}});t.getMappingInfo=function(){return{...e.getMappingInfo(),controllerName:"selector.controllerName"}};t.prototype.getMappingInfo=function(){return t.getMappingInfo()};t.prototype.getSelector=function(){return{controllerName:this.getControllerName()}};t.prototype.getVariantReference=function(){return undefined};t.prototype.isValidForDependencyMap=function(){return false};t.prototype.setInitialApplyState=function(){};t.prototype.getModuleName=function(){return this.getFlexObjectMetadata().moduleName};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlVariant", ["sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/Variant"],function(e,t){"use strict";var n=t.extend("sap.ui.fl.apply._internal.flexObjects.FlVariant",{metadata:{properties:{variantReference:{type:"string"},variantManagementReference:{type:"string"}}},constructor:function(...n){let[i,a]=n;if(typeof i!=="string"&&i!==undefined){a=i;i=a&&a.id}a.fileType="ctrl_variant";if(a.favorite===undefined){a.favorite=true}t.apply(this,n);if(!this.getName()&&a.content&&a.content.title){this.setName(a.content.title)}var r=this.getSupportInformation();if(this.getId()===this.getVariantManagementReference()){this.setStandardVariant(true);if(!r.user){r.user=e.DEFAULT_AUTHOR;this.setSupportInformation(r)}}}});n.getMappingInfo=function(){return{...t.getMappingInfo(),variantReference:"variantReference",variantManagementReference:"variantManagementReference"}};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.cloneFileContentWithNewId=function(...e){var n=t.prototype.cloneFileContentWithNewId.apply(this,e);return n};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlexObject", ["sap/base/util/deepClone","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/util/restricted/_omit","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,n,a,r,o,i,s,p,u){"use strict";var c=o.extend("sap.ui.fl.apply._internal.flexObjects.FlexObject",{metadata:{properties:{adaptationId:{type:"string"},state:{type:"string",defaultValue:i.LifecycleState.NEW},fileType:{type:"string",defaultValue:"change"},layer:{type:"string"},flexObjectMetadata:{type:"object",defaultValue:{}},supportInformation:{type:"object",defaultValue:{}},content:{type:"any",defaultValue:{}},texts:{type:"object",defaultValue:{}}}},constructor:function(...t){o.apply(this,t);var e=this.getFlexObjectMetadata();var n=e.reference;if(n){e.reference=n.endsWith(".Component")?n.replace(/\.Component(?!.*\.Component)/,""):n;e.namespace||=u.createNamespace({reference:n},this.getFileType());e.projectId||=n}this.setFlexObjectMetadata(e);var a=this.getSupportInformation();a.originalLanguage||=u.getCurrentLanguage();this.setSupportInformation(a)}});c.getMappingInfo=function(){return{"flexObjectMetadata.changeType":"changeType","flexObjectMetadata.reference":"reference","flexObjectMetadata.namespace":"namespace","flexObjectMetadata.creation":"creation","flexObjectMetadata.projectId":"projectId","flexObjectMetadata.packageName":"packageName","flexObjectMetadata.moduleName":"moduleName","supportInformation.generator":"support.generator","supportInformation.clonedFrom":"support.clonedFrom","supportInformation.service":"support.service","supportInformation.sourceSystem":"sourceSystem","supportInformation.sourceClient":"sourceClient","supportInformation.user":"support.user","supportInformation.sapui5Version":"support.sapui5Version","supportInformation.sourceChangeFileName":"support.sourceChangeFileName","supportInformation.compositeCommand":"support.compositeCommand","supportInformation.command":"support.command","supportInformation.oDataInformation":"oDataInformation","supportInformation.originalLanguage":"originalLanguage",adaptationId:"adaptationId",layer:"layer",fileType:"fileType",id:"fileName",content:"content",texts:"texts"}};c.prototype.getMappingInfo=function(){return c.getMappingInfo()};c.prototype.setContent=function(t,e){this.setProperty("content",t);if(!e){this.setState(i.LifecycleState.UPDATED)}return this};c.prototype.getFlexObjectMetadata=function(){return{...this.getProperty("flexObjectMetadata")}};c.prototype.getSupportInformation=function(){return{...this.getProperty("supportInformation")}};function f(t,e){if(!Object.values(i.LifecycleState).includes(t)){return false}if(e===i.LifecycleState.NEW&&t===i.LifecycleState.UPDATED){return false}return true}c.prototype.setState=function(t){var e=this.getState();if(e!==t&&f(t,e)){this._sPreviousState=e;this.setProperty("state",t)}return this};c.prototype.isPersisted=function(){return this.getState()===i.LifecycleState.PERSISTED};c.prototype.markForDeletion=function(){this.setState(i.LifecycleState.DELETED)};c.prototype.restorePreviousState=function(){if(this._sPreviousState){this.setState(this._sPreviousState);delete this._sPreviousState}};c.prototype.isChangeFromOtherSystem=function(){var t=this.getSupportInformation().sourceSystem;var e=this.getSupportInformation().sourceClient;if(!t||!e){return false}var n=p.getInstanceOrUndef();if(!n){return true}var a=n.getSystem();var r=n.getClient();if(!a||!r){return false}return t!==a||e!==r};c.prototype.isValidForDependencyMap=function(){return false};c.prototype.getNamespace=function(){return this.getFlexObjectMetadata().namespace};c.prototype.getChangeType=function(){return this.getFlexObjectMetadata().changeType};c.prototype.isUserDependent=function(){return this.getLayer()===s.USER};c.prototype.getText=function(t){var e=this.getTexts()[t]||{};return e.value||""};c.prototype.setText=function(t,e,n,a){const r={...this.getTexts()};const o={value:e};if(n){o.type=n}r[t]={...r[t],...o};this.setTexts(r);if(!a){this.setState(i.LifecycleState.UPDATED)}return this};c.prototype.setRequest=function(t){this._sRequest=t};c.prototype.getRequest=function(){return this._sRequest||""};c.prototype.getDefinition=function(){return this.convertToFileContent()};c.prototype.getCreation=function(){return this.getFlexObjectMetadata().creation};c.prototype.setCreation=function(t){var e=this.getFlexObjectMetadata();e.creation=t;this.setFlexObjectMetadata(e)};function l(t){return t.length?t.charAt(0).toUpperCase()+t.slice(1):t}function g(t){return typeof this[t]==="function"?this[t].bind(this):function(){throw new Error(`${t} is not a valid mutator`)}}function h(e){var n=e.split(".");n[0]=l(n[0]);var r=n.shift();var o=g.call(this,`get${r}`);var i=g.call(this,`set${r}`);return{getValue(){var e=t(o());if(n.length>0){return a.get(n,e)}return e},setValue:function(e){var r=t(o());if(n.length>0){a.set(n,e,r)}else{r=e}i(r);return this}.bind(this)}}c.prototype.convertToFileContent=function(){var t={};Object.entries(this.getMappingInfo()).forEach(function(e){var n=h.call(this,e[0]).getValue();if(n!==undefined){a.set(e[1],n,t)}}.bind(this));return t};function d(t,e){var n=h.call(this,t);var a=n.getValue();if(a!==e){n.setValue(e)}}c.mapFileContent=function(e,a){var r=Object.values(a);var o={};var i=function(t,e,s){var p=s?`${s}.${t}`:t;var u=r.indexOf(p);if(u>=0){var c=Object.keys(a)[u];o[c]=e}else if(n(e)){Object.entries(e).forEach(function(t){i(t[0],t[1],p)})}};Object.entries(t(e,15)).forEach(function(t){i(t[0],t[1])});return o};c.prototype.update=function(t){var e=r(t,["fileName"]);var n=c.mapFileContent(e,this.getMappingInfo());Object.entries(n).forEach(function(t){d.call(this,t[0],t[1])}.bind(this))};c.prototype.setResponse=function(t){if(!t||e(t)){return}this.update(t);this.setState(i.LifecycleState.PERSISTED)};c.prototype.cloneFileContentWithNewId=function(){var t=this.convertToFileContent();t.fileName=u.createDefaultFileName(t.fileName.split("_").pop());t.support.clonedFrom=this.getId();return t};c.prototype.getIdForCondensing=function(){throw new Error("Method getIdForCondensing must be implemented")};c.prototype.canBeCondensed=function(){return false};c.prototype.canBeVisualized=function(){return false};return c});
/* !
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory", ["sap/base/util/restricted/_pick","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/ui/fl/apply/_internal/flexObjects/AnnotationChange","sap/ui/fl/apply/_internal/flexObjects/AppDescriptorChange","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/ControllerExtensionChange","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/FlVariant","sap/ui/fl/apply/_internal/flexObjects/getVariantAuthor","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/apply/_internal/flexObjects/UpdatableChange","sap/ui/fl/apply/_internal/flexObjects/VariantChange","sap/ui/fl/apply/_internal/flexObjects/VariantManagementChange","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,n,a,r,i,c,o,s,l,p,u,f,g,m,y,C,O,N){"use strict";const _={COMP_VARIANT_OBJECT:i,FL_VARIANT_OBJECT:s,CONTROLLER_EXTENSION:c,APP_DESCRIPTOR_CHANGE:r,ANNOTATION_CHANGE:a,UI_CHANGE:u,UPDATABLE_CHANGE:f,VARIANT_CHANGE:g,VARIANT_MANAGEMENT_CHANGE:m,FLEX_OBJECT:o};function T(e){return t(e)?{...e}:e}function d(e){if(e.fileType==="variant"){return _.COMP_VARIANT_OBJECT}else if(e.fileType==="ctrl_variant"){return _.FL_VARIANT_OBJECT}else if(e.changeType==="codeExt"){return _.CONTROLLER_EXTENSION}else if(e.appDescriptorChange){return _.APP_DESCRIPTOR_CHANGE}else if(e.fileType==="annotation_change"){return _.ANNOTATION_CHANGE}else if(e.fileType==="change"&&e.changeType==="defaultVariant"){return _.UPDATABLE_CHANGE}else if(e.fileType==="ctrl_variant_change"){return _.VARIANT_CHANGE}else if(e.fileType==="ctrl_variant_management_change"){return _.VARIANT_MANAGEMENT_CHANGE}else if(e.changeType==="deactivateChanges"){return _.FLEX_OBJECT}return _.UI_CHANGE}function A(e){const t=T(e);const n=t.type||t.changeType;let a=t.fileName||t.id;if(!a){a=N.createDefaultFileName(n);if(a.length>64){throw Error(`File name '${a}' must not exceed 64 characters`)}}const r=t.user||(!O.isDeveloperLayer(t.layer)?y.getInstanceOrUndef()&&y.getInstanceOrUndef().getUserId():undefined);return{id:a,adaptationId:t.adaptationId,layer:t.layer,content:T(t.content),texts:T(t.texts),supportInformation:{service:t.ODataService,oDataInformation:T(t.oDataInformation),command:t.command,compositeCommand:t.compositeCommand,generator:t.generator,sourceChangeFileName:t.support&&t.support.sourceChangeFileName,sourceSystem:t.sourceSystem,sourceClient:t.sourceClient,originalLanguage:t.originalLanguage,user:r},flexObjectMetadata:{changeType:n,reference:t.reference,packageName:t.packageName,projectId:t.projectId}}}const E={};E.createFromFileContent=function(e,t,a){const r={...e};var i=t||d(r);if(!i){throw new Error("Unknown file type")}r.support={generator:"FlexObjectFactory.createFromFileContent",...r.support||{}};const c=i.getMappingInfo();const s=o.mapFileContent(r,c);const l=Object.entries(s).reduce(function(e,t){n.set(t[0].split("."),t[1],e);return e},{});const u=new i(l);if(a){u.setProperty("state",p.LifecycleState.PERSISTED)}return u};E.createFlexObject=function(e){const t=A({...e,...{packageName:e.packageName||"$TMP"}});return new o(t)};E.createUIChange=function(e){e.packageName||="$TMP";const t=A(e);t.layer||=e.isUserDependent?C.USER:O.getCurrentLayer();t.selector=e.selector;t.jsOnly=e.jsOnly;t.variantReference=e.variantReference;t.isChangeOnStandardVariant=e.isChangeOnStandardVariant;t.fileType=e.fileType||"change";return new u(t)};E.createVariantChange=function(e){e.packageName||="$TMP";const t=A(e);t.variantId=e.variantId||e.selector?.id;t.fileType=e.fileType||"ctrl_variant_change";return new g(t)};E.createVariantManagementChange=function(e){e.packageName||="$TMP";const t=A(e);t.selector=e.selector;t.fileType=e.fileType||"ctrl_variant_management_change";return new m(t)};E.createAppDescriptorChange=function(e){e.compositeCommand||=e.support&&e.support.compositeCommand;if(!(e.fileName||e.id)){const t=e.type||e.changeType;e.fileName=N.createDefaultFileName(t).substring(0,64)}const t=A(e);return new r(t)};E.createAnnotationChange=function(e){e.compositeCommand||=e.support&&e.support.compositeCommand;const t=A(e);t.serviceUrl=e.serviceUrl;return new a(t)};E.createControllerExtensionChange=function(e){e.generator||="FlexObjectFactory.createControllerExtensionChange";e.changeType="codeExt";e.content={codeRef:e.codeRef};const t=A(e);t.flexObjectMetadata.moduleName=e.moduleName;t.controllerName=e.controllerName;return new c(t)};E.createFlVariant=function(e){const t=T(e);t.generator||="FlexObjectFactory.createFlVariant";const n=A(t);n.variantManagementReference=t.variantManagementReference;n.variantReference=t.variantReference;n.contexts=t.contexts;n.executeOnSelection=t.executeOnSelection;n.texts={variantName:{value:t.variantName,type:"XFLD"}};n.author=l(n.supportInformation.user,n.layer,t.authors);return new s(n)};E.createCompVariant=function(e,t){const a=T(e);a.generator||="FlexObjectFactory.createCompVariant";a.user=n.get("support.user",a);const r=A(a);r.variantId=a.variantId||r.id;r.contexts=a.contexts;r.favorite=a.favorite;r.persisted=a.persisted;r.persistencyKey=a.persistencyKey||n.get("selector.persistencyKey",a);if(a.layer===C.VENDOR||a.layer===C.CUSTOMER_BASE){r.favorite=true}if(a.executeOnSelection!==undefined){r.executeOnSelection=a.executeOnSelection}else{r.executeOnSelection=r.content&&(r.content.executeOnSelect||r.content.executeOnSelection)}r.author=l(r.supportInformation.user,r.layer,t);return new i(r)};return E});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/RevertData", ["sap/ui/base/ManagedObject"],function(e){"use strict";return e.extend("sap.ui.fl.apply._internal.flexObjects.RevertData",{metadata:{properties:{type:{type:"string"},content:{type:"object"}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/States", [],function(){"use strict";return{LifecycleState:{NEW:"NEW",PERSISTED:"PERSISTED",DELETED:"DELETED",DIRTY:"UPDATED",UPDATED:"UPDATED"},ApplyState:{INITIAL:"initial",APPLYING:"applying",REVERTING:"reverting",REVERT_FINISHED:"revert finished",APPLY_SUCCESSFUL:"apply successful",APPLY_FAILED:"apply failed"},Operations:{APPLY:"apply",REVERT:"revert"}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/UIChange", ["sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Utils"],function(e,t,s,r,o,n){"use strict";var i=r.extend("sap.ui.fl.apply._internal.flexObjects.UIChange",{metadata:{properties:{selector:{type:"object",defaultValue:{}},dependentSelectors:{type:"object",defaultValue:{}},applyState:{type:"string",defaultValue:o.ApplyState.NEW},jsOnly:{type:"boolean"},variantReference:{type:"string"},isChangeOnStandardVariant:{type:"boolean"},savedToVariant:{type:"boolean"},revertData:{type:"any",defaultValue:null}},aggregations:{},associations:{},events:{}},constructor:function(...e){r.apply(this,e);this._oChangeProcessingPromises={};this.setInitialApplyState()}});i.getMappingInfo=function(){return{...r.getMappingInfo(),selector:"selector",dependentSelectors:"dependentSelector",jsOnly:"jsOnly",variantReference:"variantReference",isChangeOnStandardVariant:"isChangeOnStandardVariant"}};i.prototype.getMappingInfo=function(){return i.getMappingInfo()};i.prototype.setQueuedForRevert=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==o.Operations.REVERT){this._aQueuedProcesses.unshift(o.Operations.REVERT)}};i.prototype.isQueuedForRevert=function(){return this._aQueuedProcesses.indexOf(o.Operations.REVERT)>-1};i.prototype.setQueuedForApply=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==o.Operations.APPLY){this._aQueuedProcesses.unshift(o.Operations.APPLY)}};i.prototype.isQueuedForApply=function(){return this._aQueuedProcesses.indexOf(o.Operations.APPLY)>-1};i.prototype.setInitialApplyState=function(){this._aQueuedProcesses=[];delete this._ignoreOnce;this.setApplyState(o.ApplyState.INITIAL);this._oChangeProcessedPromise={};this._oChangeProcessedPromise.promise=new Promise(function(e){this._oChangeProcessedPromise.resolveFunction={resolve:e}}.bind(this))};i.prototype.isInInitialState=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()===o.ApplyState.INITIAL};i.prototype.isValidForDependencyMap=function(){return!!this.getSelector().id};i.prototype.startApplying=function(){this.setApplyState(o.ApplyState.APPLYING)};i.prototype.markFinished=function(e,t){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(o.Operations.APPLY,e);var s=t!==false?o.ApplyState.APPLY_SUCCESSFUL:o.ApplyState.APPLY_FAILED;this.setApplyState(s)};i.prototype.markSuccessful=function(e){this.markFinished(e,true)};i.prototype.markFailed=function(e){this.markFinished(e,false)};i.prototype.startReverting=function(){this.setApplyState(o.ApplyState.REVERTING)};i.prototype.markRevertFinished=function(e){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(o.Operations.REVERT,e);this.setApplyState(o.ApplyState.REVERT_FINISHED)};i.prototype.hasApplyProcessStarted=function(){return this.getApplyState()===o.ApplyState.APPLYING};i.prototype.isSuccessfullyApplied=function(){return this.getApplyState()===o.ApplyState.APPLY_SUCCESSFUL};i.prototype.hasApplyProcessFailed=function(){return this.getApplyState()===o.ApplyState.APPLY_FAILED};i.prototype.isApplyProcessFinished=function(){return this.isSuccessfullyApplied()||this.hasApplyProcessFailed()};i.prototype.hasRevertProcessStarted=function(){return this.getApplyState()===o.ApplyState.REVERTING};i.prototype.isRevertProcessFinished=function(){return this.getApplyState()===o.ApplyState.REVERT_FINISHED};i.prototype.isCurrentProcessFinished=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()!==o.ApplyState.INITIAL};i.prototype.addChangeProcessingPromise=function(e){if(!this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e]={};this._oChangeProcessingPromises[e].promise=new Promise(function(t){this._oChangeProcessingPromises[e].resolveFunction={resolve:t}}.bind(this))}return this._oChangeProcessingPromises[e].promise};i.prototype.addChangeProcessingPromises=function(){var e=[];if(this.getApplyState()===o.ApplyState.INITIAL&&this._oChangeProcessedPromise){e.push(this._oChangeProcessedPromise.promise)}this._aQueuedProcesses.forEach(function(t){e.push(this.addChangeProcessingPromise(t))},this);return e};i.prototype.addPromiseForApplyProcessing=function(){return this.addChangeProcessingPromise(o.Operations.APPLY)};i.prototype._resolveChangeProcessingPromiseWithError=function(e,t){if(this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e].resolveFunction.resolve(t);delete this._oChangeProcessingPromises[e]}if(this._oChangeProcessedPromise){this._oChangeProcessedPromise.resolveFunction.resolve(t);this._oChangeProcessedPromise=null}};i.prototype.hasRevertData=function(){return this.getRevertData()!==null};i.prototype.resetRevertData=function(){this.setRevertData(null)};i.prototype.setDependentSelectors=function(e){this.setProperty("dependentSelectors",e);delete this._aDependentSelectorList};i.prototype.addDependentControl=function(t,s,r,o){if(!t){throw new Error("Parameter vControl is mandatory")}if(!s){throw new Error("Parameter sAlias is mandatory")}if(!r||e(r)){throw new Error("Parameter mPropertyBag is mandatory")}var n={...this.getDependentSelectors()};if(n[s]){throw new Error(`Alias '${s}' already exists in the change.`)}var i=r.modifier;var a=r.appComponent;if(Array.isArray(t)){var p=[];t.forEach(function(e){p.push(i.getSelector(e,a,o))});n[s]=p}else{n[s]=i.getSelector(t,a,o)}this.setDependentSelectors(n);delete this._aDependentSelectorList};i.prototype.getDependentControl=function(e,t){var s=[];if(!e){throw new Error("Parameter sAlias is mandatory")}if(!t){throw new Error("Parameter mPropertyBag is mandatory")}var r=t.modifier;var o=t.appComponent;var n=this.getDependentSelectors()[e];if(Array.isArray(n)){n.forEach(function(e){s.push(r.bySelector(e,o,t.view))});return s}return r.bySelector(n,o,t.view)};i.prototype.getDependentSelectorList=function(){var e=[this.getSelector()];if(!this._aDependentSelectorList){if(!this.getOriginalSelector()){Object.entries(this.getDependentSelectors()).some(function(t){var s=t[1];if(!Array.isArray(s)){s=[s]}s.forEach(function(t){if(t&&n.indexOfObject(e,t)===-1){e.push(t)}})})}this._aDependentSelectorList=e}return this._aDependentSelectorList};i.prototype.getDependentControlSelectorList=function(){var e=this.getDependentSelectorList().concat();if(e.length>0){var t=this.getSelector();var s=n.indexOfObject(e,t);if(s>-1){e.splice(s,1)}}return e};i.prototype.getOriginalSelector=function(){return this.getDependentSelectors().originalSelector};i.prototype.setExtensionPointInfo=function(e){this._oExtensionPointInfo=e};i.prototype.getExtensionPointInfo=function(){if(t(this._oExtensionPointInfo)){return{...this._oExtensionPointInfo}}return this._oExtensionPointInfo};i.prototype.getIdForCondensing=function(e,t){return e!==undefined?e.affectedControl:s.getControlIdBySelector(this.getSelector(),t)};i.prototype.canBeCondensed=function(){return this.isSuccessfullyApplied()};i.prototype.canBeVisualized=function(){return this.getSelector()&&!e(this.getSelector())};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/UpdatableChange", ["sap/ui/fl/apply/_internal/flexObjects/UIChange"],function(e){"use strict";var t=e.extend("sap.ui.fl.apply._internal.flexObjects.UpdatableChange",{metadata:{aggregations:{revertInfo:{type:"sap.ui.base.ManagedObject",multiple:true,singularName:"revertInfo"}}}});t.getMappingInfo=function(){return{...e.getMappingInfo()}};t.prototype.popLatestRevertInfo=function(){var e=this.getRevertInfo().pop();this.removeRevertInfo(e);return e};t.prototype.canBeCondensed=function(){return false};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/Variant", ["sap/ui/fl/apply/_internal/flexObjects/getVariantAuthor","sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(t,e){"use strict";var n=e.extend("sap.ui.fl.apply._internal.flexObjects.Variant",{metadata:{properties:{favorite:{type:"boolean",defaultValue:false},visible:{type:"boolean",defaultValue:true},executeOnSelection:{type:"boolean",defaultValue:false},standardVariant:{type:"boolean",defaultValue:false},contexts:{type:"object",defaultValue:{}},variantId:{type:"string"},author:{type:"string"}}},constructor:function(...n){e.apply(this,n);if(!this.getVariantId()){this.setVariantId(this.getId())}if(!this.getAuthor()){this.setAuthor(t(this.getSupportInformation().user,this.getLayer(),{}))}}});n.getMappingInfo=function(){return{...e.getMappingInfo(),favorite:"favorite",executeOnSelection:"executeOnSelection",contexts:"contexts"}};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.getName=function(){return this.getText("variantName")};n.prototype.setName=function(t,e){this.setText("variantName",t,"XFLD",e)};n.prototype.hasContexts=function(){var t=this.getContexts();var e=Object.keys(t);return e.some(function(e){return t[e].length>0})};n.prototype.canBeCondensed=function(){return false};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/VariantChange", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(t){"use strict";const n=t.extend("sap.ui.fl.apply._internal.flexObjects.VariantChange",{metadata:{properties:{variantId:{type:"string"}}},constructor:function(...n){t.apply(this,n);this.setFileType("ctrl_variant_change")}});n.getMappingInfo=function(){return{...t.getMappingInfo(),variantId:"selector.id"}};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.getIdForCondensing=function(){return this.getVariantId()};n.prototype.canBeCondensed=function(){return true};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/VariantManagementChange", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(e,t){"use strict";const n=t.extend("sap.ui.fl.apply._internal.flexObjects.VariantManagementChange",{metadata:{properties:{selector:{type:"object",defaultValue:{}}}},constructor:function(...e){t.apply(this,e);this.setFileType("ctrl_variant_management_change")}});n.getMappingInfo=function(){return{...t.getMappingInfo(),selector:"selector"}};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.getIdForCondensing=function(t,n){return e.getControlIdBySelector(this.getSelector(),n)};n.prototype.canBeCondensed=function(){return true};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/getVariantAuthor", ["sap/ui/core/Lib","sap/ui/fl/Layer","sap/ui/fl/registry/Settings"],function(e,t,r){"use strict";return(n,s,i)=>{const u=n||"";const c=r.getInstanceOrUndef();if(s===t.USER||u===c?.getUserId()){return e.getResourceBundleFor("sap.ui.fl").getText("VARIANT_SELF_OWNER_NAME")}if(![t.PUBLIC,t.CUSTOMER].includes(s)){return u}return i?.[u]||u}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/DataSelector", ["sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/base/ManagedObject"],function(e,t,i){"use strict";var a=i.extend("sap.ui.fl.apply._internal.flexState.DataSelector",{metadata:{properties:{parentDataSelector:{type:"object"},cachedResult:{type:"any"},parameterKey:{type:"string"},initFunction:{type:"function"},executeFunction:{type:"function"},updateListeners:{type:"function[]",defaultValue:[]},checkInvalidation:{type:"function",defaultValue(){return true}}}},constructor:function(...e){i.apply(this,e);this._mInitialized={};if(this.getParameterKey()){this.setCachedResult({})}var t=this.getParentDataSelector();if(t){this.onParentSelectorUpdate=this.checkUpdate.bind(this);t.addUpdateListener(this.onParentSelectorUpdate)}}});const n="DataSelector_no_parameter";function r(e,t){const i=[];function a(e){const i=e.getParameterKey();if(!i){return n}return t?.[i]}let r=e;do{const t=a(r);if(t||r!==e){if(t===undefined){throw new Error(`Parameter '${r.getParameterKey()}' is missing`)}i.unshift(t)}r=r.getParentDataSelector()}while(r);return i}a.prototype.addUpdateListener=function(e){var t=this.getUpdateListeners();if(!t.includes(e)){this.setUpdateListeners([].concat(t,e))}};a.prototype.removeUpdateListener=function(e){var t=this.getUpdateListeners();this.setUpdateListeners(t.filter(function(t){return t!==e}))};a.prototype.exit=function(){var e=this.getParentDataSelector();if(e){e.removeUpdateListener(this.onParentSelectorUpdate)}};a.prototype._getParameterizedCachedResult=function(e){const i=r(this,e);if(i.length===0){return this.getCachedResult()}return t.get(i,this.getCachedResult())};a.prototype._setParameterizedCachedResult=function(i,a){const n=r(this,i);const s={};if(n.length===0){Object.assign(s,a)}else{t.set(n,a,s)}return this.setCachedResult(e({},this.getCachedResult(),s))};a.prototype._clearCache=function(e,t){const i=[];const a=this.getParameterKey();if(!a){this.setCachedResult(null);i.push(e)}else if(Object.keys(e||{}).includes(a)){if(this._getParameterizedCachedResult(e)!==undefined){this._setParameterizedCachedResult(e,null);i.push(e)}}else{const t=this._getParameterizedCachedResult(e);Object.keys(t||{}).forEach(t=>{i.push({...e,[a]:t})});this.setCachedResult({})}this.getUpdateListeners().forEach(function(e){i.forEach(i=>{e(i,t)})})};a.prototype.clearCachedResult=function(e){this._clearCache(e)};a.prototype.get=function(e){var t=this.getParameterKey();if(t&&!(e||{})[t]){throw new Error(`Parameter '${t}' is missing`)}var i=this._getParameterizedCachedResult(e);if(i!==null&&i!==undefined){return i}var a=this.getParentDataSelector();var n=a&&a.get(e);var r=(e||{})[t];if(!this._mInitialized[r]&&this.getInitFunction()){this.getInitFunction()(n,r);this._mInitialized[r]=true}var s=this.getExecuteFunction()(n,e);this._setParameterizedCachedResult(e,s);return s};function s(e,t,i){if(i){return i.some(i=>e(t,i))}return true}a.prototype.checkUpdate=function(e,t){const i=this.getParameterKey();if(i!==undefined&&!Object.keys(e||{}).includes(i)){const a=this._getParameterizedCachedResult(e);const n=Object.keys(a&&typeof a==="object"?a:{});n.forEach(a=>{const n={...e,[i]:a};const r=s(this.getCheckInvalidation(),n,t);if(r){this._clearCache(n,t)}return!r})}else{const i=s(this.getCheckInvalidation(),e,t);if(i){this._clearCache(e,t)}}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/FlexObjectState", ["sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/changes/UIChangesState","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/Utils"],function(e,n,t,c,s,a,o,i,r,l,p,g,d){"use strict";const f={};const u=new l({id:"allDirtyFlexObjects",parentDataSelector:p.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(e=>e.getState()!==a.LifecycleState.PERSISTED)}});function h(e,n){const t=f.getCompleteDependencyMap(n).mDependencies;return t[e.getId()]&&{...t[e.getId()]}}function y(e,n,c,s,a){const o=[];const i=f.getLiveDependencyMap(a);const r={...e};e.controlsDependencies.forEach(e=>{if(!t.bySelector(e,c)){const n=t.getControlIdBySelector(e,c);o.push(e);i.mControlsWithDependencies[n]||=[];if(!i.mControlsWithDependencies[n].includes(s.getId())){i.mControlsWithDependencies[n].push(s.getId())}}});r.dependencies=n;r.controlsDependencies=o;if(n.length||o.length){i.mDependencies[s.getId()]=r}return r}function D(e,n){const c=e.getDependentControlSelectorList();c.push(e.getSelector());return!c.some(e=>!t.bySelector(e,n))}function C(e,n,t,c,s){let a=D(e,c);if(!a){return[]}s.push(e);const o=e.getId();const i=n[o]&&n[o].dependencies||[];for(let e=0,r=i.length;e<r;e++){const r=d.getChangeFromChangesMap(t,i[e]);a=C(r,n,t,c,s);if(a.length===0){s=[];break}delete n[o]}return s}f.getAllApplicableUIChanges=function(e){const n=i.getVariantIndependentUIChanges(e);return n.concat(r.getInitialUIChanges({reference:e}))};f.getCompleteDependencyMap=function(n){const t=i.getVMIndependentCompleteDependencyMap(n);const c=r.getDependencyMap(n);const s=e({},t);e(s.mDependencies,c.mDependencies);e(s.mDependentChangesOnMe,c.mDependentChangesOnMe);s.aChanges=s.aChanges.concat(c.aChanges);["mChanges","mControlsWithDependencies"].forEach(e=>{Object.entries(c[e]).forEach(([n,t])=>{if(Object.keys(s[e]).includes(n)){s[e][n]=s[e][n].concat(t)}else{s[e][n]=t}})});return s};f.getLiveDependencyMap=function(e){return p.getRuntimeOnlyData(e).liveDependencyMap||o.createEmptyDependencyMap()};f.getOpenDependentChangesForControl=function(e,n){const c=g.getFlexReferenceForControl(n);return o.getOpenDependentChangesForControl(f.getLiveDependencyMap(c),t.getControlIdBySelector(e,n),n)};f.copyDependenciesFromCompleteDependencyMap=function(e,n){const c=g.getFlexReferenceForControl(n);let a=h(e,c);if(a){const o=f.getLiveDependencyMap(c);const i=[];a.dependencies.forEach(function(c){if(s.checkIfDependencyIsStillValid(n,t,o,c)){o.mDependentChangesOnMe[c]||=[];o.mDependentChangesOnMe[c].push(e.getId());i.push(c)}});a=y(a,i,n,e,c)}};f.waitForFlexObjectsToBeApplied=async function(e){const n=d.getAppComponentForSelector(e[0].selector);if(!n){return}const t=g.getFlexReferenceForControl(n);await r.getVariantSwitchPromise(t);await Promise.all(e.map(e=>{const s=e.selector.id&&c.getElementById(e.selector.id)||e.selector;e.changeTypes||=[];const a=f.getLiveDependencyMap(t);let o=[];const i={...a.mDependencies};const{mChanges:r}=a;const l=r[s.getId()]||[];const p=l.filter(n=>!n.isCurrentProcessFinished()&&(e.changeTypes.length===0||e.changeTypes.includes(n.getChangeType())));const g=[];p.forEach(e=>{const t=C(e,i,a.mChanges,n,[]);t.forEach(e=>{if(g.indexOf(e)===-1){g.push(e)}})});g.forEach(e=>{o=o.concat(e.addChangeProcessingPromises())});return Promise.all(o)}))};function m(e){const n=[];const t=p.getCompVariantsMap(e);for(const e in t){const c=t[e];for(const e in c.byId){n.push(c.byId[e])}}return n}function S(e){return!(e.getState()===a.LifecycleState.DELETED&&e._sPreviousState===a.LifecycleState.NEW)}f.getDirtyFlexObjects=function(e){const n=m(e);return u.get({reference:e}).concat(n.filter(e=>e.getState()!==a.LifecycleState.PERSISTED)).filter(e=>S(e))};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/FlexState", ["sap/base/util/restricted/_omit","sap/base/util/Deferred","sap/base/util/each","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/Component","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/compVariants/prepareCompVariantsMap","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/InitialPrepareFunctions","sap/ui/fl/apply/_internal/flexState/Loader","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/LayerUtils"],function(e,t,n,r,a,i,c,s,o,f,l,p,u,d,m,g,x){"use strict";const h="sap.ui.fl.apply._internal.flexObjects.AppDescriptorChange";const b="sap.ui.fl.apply._internal.flexObjects.AnnotationChange";var v={};var O={};var j={};var R={appDescriptorChanges:{pathInResponse:[]},annotationChanges:{pathInResponse:[]},changes:{initialPreparationFunctionName:"uiChanges",pathInResponse:["changes"]},variants:{initialPreparationFunctionName:"variants",pathInResponse:["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"]},compVariants:{prepareFunction:f,pathInResponse:["comp.variants","comp.standardVariants","comp.defaultVariants","comp.changes"]}};var y={compVariants:{},flexObjects:{}};function I(e,t){var n={comp(){return Object.values(t).reduce(function(e,t){return e.concat(t)},[])},variants(){return t.map(function(e){var n=e.variantReference===e.variantManagementReference||t.some(function(t){return t.variantManagementReference===e.variantManagementReference&&t.fileName===e.variantReference});if(!n){return{...e,variantReference:e.variantManagementReference}}return e})}}[e];if(n){return n()}return Array.isArray(t)?t:[]}function F(e){var t=c.getComponentById(e.componentId);e.componentData||=t&&t.getComponentData()||{};e.manifest||=e.rawManifest||t&&t.getManifestObject()||{};e.reference||=d.getFlexReference(e);const n=m.getByReference(e.reference);e.version||=n.version;e.adaptationId||=n.displayedAdaptationId;e.allContextsProvided||=n.allContextsProvided}function S(e){var t=[];n(e.changes,function(e,n){I(e,n).forEach(function(e){t.push(s.createFromFileContent(e,null,true))})});return t}function C(e,t){var n=R[e].initialPreparationFunctionName;var r=p[n];if(r){return r(t)}return undefined}function D(e,t,n){t.reference=n;var r=C(e,t);if(r){z(n,r)}}var P=new l({id:"flexObjects",parameterKey:"reference",executeFunction(e,t){if(!O[t.reference]){return[]}var n=O[t.reference].runtimePersistence;return n.flexObjects.concat(n.runtimeOnlyData.flexObjects||[],y.flexObjects[t.reference][O[t.reference].componentId]||[])}});const w=new l({id:"appDescriptorChanges",parentDataSelector:P,executeFunction(e){return e.filter(e=>e.isA(h))},checkInvalidation(e,t){const n=["addFlexObject","removeFlexObject"].includes(t.type);return n&&t.updatedObject?.isA(h)}});const _=new l({id:"annotationChanges",parentDataSelector:P,executeFunction(e){return e.filter(e=>e.isA(b))},checkInvalidation(e,t){const n=["addFlexObject","removeFlexObject"].includes(t.type);return n&&t.updatedObject?.isA(b)}});function V(e,t){if(!O[e]){q(e)}if(!O[e].preparedMaps[t]){var n={unfilteredStorageResponse:O[e].unfilteredStorageResponse,storageResponse:O[e].storageResponse,componentId:O[e].componentId,componentData:O[e].componentData,reference:e,runtimePersistence:O[e].runtimePersistence};O[e].preparedMaps[t]=v.callPrepareFunction(t,n);D(t,n,e)}return O[e].preparedMaps[t]}function z(e,t){O[e]=r(O[e],t);P.checkUpdate({reference:e})}function E(e,t){const n=e.storageResponse;var a={flexObjects:S(n),runtimeOnlyData:{flexObjects:[]}};if(!e.componentId){return a}Object.keys(R).forEach(function(i){var c=C(i,{storageResponse:n,externalData:t,flexObjects:a.flexObjects,componentId:e.componentId});if(c){a=r(a,c)}});return a}function k(e,t,r){const a=r.flexObjects.slice();const c=a.length;const f=[];let l;n(t.changes,function(e,t){I(e,t).forEach(function(e){f.push(e)})});O[e].runtimePersistence={...r,flexObjects:f.map(function(e){let t;const n=a.find(function(n,r){t=r;return n.getId()===e.fileName});if(n){a.splice(t,1);if(n.getState()!==o.LifecycleState.PERSISTED){n.setResponse(e);l=true}return n}if(e.fileType==="ctrl_variant_change"&&e.fileName.endsWith("flVariant_contextFiltering_setVisible")){return s.createFromFileContent(e,null,true)}const r="Error updating runtime persistence: storage returned unknown flex objects";i.error(r);throw new Error(r)})};if(c!==O[e].runtimePersistence.flexObjects.length){l=true}return l}function M(e){var t=e.reference;var n=false;if(!O[t].componentData&&e.componentId){var r=c.getComponentById(e.componentId);O[t].componentData=r?r.getComponentData():e.componentData;n=true}if(!O[t].storageResponse){O[t].storageResponse=L(t,O[t].unfilteredStorageResponse);delete O[t].runtimePersistence;n=true}if(!a.get(["flexObjects",t,e.componentId],y)){a.set(["flexObjects",t,e.componentId],[],y)}if(!O[t].runtimePersistence){O[t].runtimePersistence=E(O[t],y.flexObjects[t][e.componentId]||[]);n=true}if(n){P.checkUpdate({reference:t})}}function L(e,t){const i=r({},t);i.changes={...g.getEmptyFlexDataResponse(),...i.changes};const c=i.changes;const s=m.getByReference(e);if(x.isLayerFilteringRequired(e)){n(R,function(e,t){t.pathInResponse.forEach(function(e){const t=a.get(e,c).filter(function(e){return!e.layer||!x.isOverLayer(e.layer,s.maxLayer)});a.set(e,t,c)})})}O[e].maxLayer=s.maxLayer;return i}async function N(e){const t=await u.loadFlexData(e);if(!e.partialFlexState){t.authors=await u.loadVariantsAuthors(e.reference)}U(e.reference,t);return t}function A(e,t){O[t.reference]=r({},{unfilteredStorageResponse:e,preparedMaps:{},componentId:t.componentId,componentData:t.componentData,partialFlexState:t.partialFlexState,version:t.version,allContextsProvided:t.allContextsProvided});Object.freeze(O[t.reference].storageResponse);Object.freeze(O[t.reference].unfilteredStorageResponse)}function U(e,t){var n=t&&t.changes||{};var r=m.getByReference(e);if(n.info!==undefined){r={...r,...n.info}}m.setByReference(r,e)}function B(e){var t=O[e.reference];if(t.partialFlexState===true&&e.partialFlexState!==true){t.partialFlexState=false;e.partialFlexData=r({},t.unfilteredStorageResponse.changes);e.reInitialize=true}}function T(e){var t=O[e.reference].componentId;if(!e.reInitialize&&t!==e.componentId){e.reInitialize=true}}function K(e){var t=O[e.reference].version;if(!e.reInitialize&&t!==e.version){e.reInitialize=true}const n=O[e.reference].allContextsProvided;if(!e.reInitialize&&n!==e.allContextsProvided){e.reInitialize=true}}function W(e){if(O[e]?.maxLayer!==m.getByReference(e).maxLayer){v.rebuildFilteredResponse(e)}}function q(e){O[e]={unfilteredStorageResponse:{changes:g.getEmptyFlexDataResponse()},storageResponse:{changes:g.getEmptyFlexDataResponse()},preparedMaps:{},emptyState:true,reInitialize:true,componentId:""};const n=new t;j[e]=n;n.resolve();M({reference:e})}v.getRuntimeOnlyData=function(e){if(!O[e]){q(e)}return O[e].runtimePersistence.runtimeOnlyData};v.initialize=async function(e){const n=r({},e);F(n);const a=n.reference;const i=j[a];const c=new t;j[a]=c;if(i){await i.promise;B(n);T(n);K(n);if(n.reInitialize){const e=await N(n);A(e,n)}else{W(e.reference)}}else{const e=await N(n);A(e,n)}M(n);c.resolve()};v.waitForInitialization=function(e){const t=j[e]?.promise;if(!t){i.error("FlexState.waitForInitialization was called before FlexState.initialize");return Promise.resolve()}return t};v.isInitialized=function(e){var t=e.reference?e.reference:d.getFlexReferenceForControl(e.control);return!!O[t]};v.updateWithDataProvided=function(e){if(!O[e.reference]){q(e.reference)}const t=O[e.reference];Object.entries(e.newData).forEach(([e,n])=>{t.unfilteredStorageResponse.changes[e].push(...n)});t.storageResponse=L(e.reference,t.unfilteredStorageResponse);t.runtimePersistence.flexObjects=[...t.runtimePersistence.flexObjects,...S(L(e.reference,{changes:e.newData}))];P.checkUpdate({reference:e.reference})};v.update=async function(e){F(e);const n=e.reference;const r=O[n].runtimePersistence;const a=j[n].promise;const i=new t;j[n]=i;await a;const c=await N(e);A(c,e);O[n].storageResponse=L(n,O[n].unfilteredStorageResponse);const s=k(n,O[n].storageResponse,r);if(s){P.checkUpdate({reference:n})}i.resolve()};function G(e){switch(e.fileType){case"change":if(e.selector&&e.selector.persistencyKey){return["comp","changes"]}if(e.variantReference){return"variantDependentControlChanges"}return"changes";case"ctrl_variant":return"variants";case"ctrl_variant_change":return"variantChanges";case"ctrl_variant_management_change":return"variantManagementChanges";case"variant":return["comp","variants"];case"annotation_change":return"annotationChanges";default:return""}}v.updateStorageResponse=function(e,t){const n=[];t.forEach(t=>{if(t.type==="ui2"){O[e].unfilteredStorageResponse.changes.ui2personalization=t.newData}else{const r=G(t.flexObject);const i=t.flexObject.fileName;const c=a.get(r,O[e].unfilteredStorageResponse.changes);const s=a.get(r,O[e].storageResponse.changes);const f=O[e].runtimePersistence.flexObjects.findIndex(e=>e.getId()===i);const l=O[e].runtimePersistence.flexObjects[f];switch(t.type){case"add":c.push(t.flexObject);s.push(t.flexObject);if(f<0){throw new Error("Flex response includes unknown flex object")}break;case"delete":s.splice(s.findIndex(e=>e.fileName===i),1);c.splice(c.findIndex(e=>e.fileName===i),1);if(f>=0){O[e].runtimePersistence.flexObjects.splice(f,1);n.push({type:"removeFlexObject",updatedObject:l})}break;case"update":s.splice(s.findIndex(e=>e.fileName===i),1,t.flexObject);c.splice(c.findIndex(e=>e.fileName===i),1,t.flexObject);if(l&&l.getState()!==o.LifecycleState.PERSISTED){l.setResponse(t.flexObject);n.push({type:"updateFlexObject",updatedObject:l})}break;default:}}});if(n.length>0){P.checkUpdate({reference:e},n)}};v.clearState=function(e){if(e){delete O[e];delete j[e];P.clearCachedResult({reference:e})}else{O={};j={};P.clearCachedResult()}};v.setInitialNonFlCompVariantData=function(e,t,n,r,a){y.compVariants[e]||={};y.compVariants[e][t]={};y.compVariants[e][t].standardVariant=n;y.compVariants[e][t].variants=r;y.compVariants[e][t].controlId=a};v.getInitialNonFlCompVariantData=function(e){return y.compVariants[e]};v.resetInitialNonFlCompVariantData=function(e){delete y.compVariants[e]};v.addRuntimeSteadyObject=function(e,t,n){n.setState(o.LifecycleState.PERSISTED);y.flexObjects[e]||={};y.flexObjects[e][t]||=[];y.flexObjects[e][t].push(n);P.checkUpdate({reference:e},[{type:"addFlexObject",updatedObject:n}])};v.clearRuntimeSteadyObjects=function(e,t){if(y.flexObjects[e]){delete y.flexObjects[e][t];P.clearCachedResult({reference:e})}};v.rebuildFilteredResponse=function(e){if(O[e]){O[e].preparedMaps={};O[e].storageResponse=L(e,O[e].unfilteredStorageResponse);O[e].runtimePersistence=E(O[e],y.flexObjects[e][O[e].componentId]||[]);P.checkUpdate({reference:e})}};v.addDirtyFlexObjects=function(e,t){if(!O[e]){q(e)}const n=m.getByReference(e).adaptationLayer;const r=t.filter(e=>!n||!x.isOverLayer(e.getLayer(),n)).filter(t=>!O[e].runtimePersistence.flexObjects.some(e=>e.getId()===t.getId()));if(r.length>0){O[e].runtimePersistence.flexObjects=O[e].runtimePersistence.flexObjects.concat(r);P.checkUpdate({reference:e},r.map(function(e){return{type:"addFlexObject",updatedObject:e}}))}return r};v.removeDirtyFlexObjects=function(e,t){const n=[];if(O[e]&&t.length>0){const r=O[e].runtimePersistence.flexObjects;t.forEach(function(e){const t=r.indexOf(e);if(t>=0){n.push(e);r.splice(t,1)}});if(n.length>0){P.checkUpdate({reference:e},t.map(function(e){return{type:"removeFlexObject",updatedObject:e}}))}}return n};v.getComponentIdForReference=function(e){return O[e]?.componentId};v.getFlexObjectsDataSelector=function(){return P};v.getAppDescriptorChanges=function(e){return w.get({reference:e})};v.getAnnotationChanges=function(e){return _.get({reference:e})};v.getUI2Personalization=function(e){return r({},O[e].unfilteredStorageResponse.changes.ui2personalization)};v.getCompVariantsMap=function(e){return V(e,"compVariants")};v.callPrepareFunction=function(e,t){return R[e].prepareFunction(t)};v.getStorageResponse=function(e){if(j[e]){return j[e].promise.then(function(){return O[e].unfilteredStorageResponse})}return Promise.resolve()};v.getComponentData=function(e){return O[e]&&O[e].componentData};v.setAllContextsProvided=function(e,t){if(O[e]&&O[e].allContextsProvided===undefined){O[e].allContextsProvided=t}};return v});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/InitialPrepareFunctions", ["sap/ui/core/Lib","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/getVariantAuthor","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/Layer"],function(e,a,n,t,r,i,s){"use strict";const c={};c.variants=function(i){i.flexObjects.forEach(e=>{if(e.getFileType()==="ctrl_variant"){e.setAuthor(t(e.getSupportInformation().user,e.getLayer(),i.storageResponse.authors))}});const c=(i.storageResponse.changes.variants||[]).map(function(e){return e.fileName}).concat(i.externalData.filter(function(e){return e.getFileType()==="ctrl_variant"}).map(function(e){return e.getId()}));var l={runtimeOnlyData:{flexObjects:[]}};var f=i.storageResponse.changes.variants;var p=i.storageResponse.changes.variantDependentControlChanges.filter(function(e){var a=e.isChangeOnStandardVariant;if(a!==undefined&&a!==null){return a}return!/id_\d{13}_\d*_flVariant/.test(e.variantReference)});var u=f.concat(p);u.forEach(function(t){var i=t.fileType==="ctrl_variant"?t.variantManagementReference:t.variantReference;if(i&&!c.includes(i)){var f=e.getResourceBundleFor("sap.ui.fl");var p=n.createFlVariant({id:i,variantManagementReference:i,variantName:f.getText("STANDARD_VARIANT_TITLE"),layer:s.BASE,user:a.DEFAULT_AUTHOR,reference:t.reference});p.setState(r.LifecycleState.PERSISTED);l.runtimeOnlyData.flexObjects.push(p);c.push(i)}});return l};c.uiChanges=function(e){const a=i.createEmptyDependencyMap();e.flexObjects.forEach(n=>{if(n.isA("sap.ui.fl.apply._internal.flexObjects.UIChange")&&!n.getVariantReference()){i.addChangeAndUpdateDependencies(n,e.componentId,a)}});return{runtimeOnlyData:{liveDependencyMap:a}}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/Loader", ["sap/base/util/ObjectPath","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/Storage","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/registry/Settings"],function(e,t,n,a,r,i){"use strict";function s(e){if(typeof e==="string"){e={id:e}}e.idIsLocal=true;return e}function c(e,t){if(e){[t.changes,t.variantChanges,t.variantDependentControlChanges,t.variantManagementChanges].flat().filter(e=>e.selector&&!e.selector.idIsLocal).forEach(function(e){e.selector=s(e.selector);if(e.dependentSelector){Object.keys(e.dependentSelector).forEach(t=>{const n=e.dependentSelector[t];if(Array.isArray(n)){e.dependentSelector[t]=n.map(s)}else{e.dependentSelector[t]=s(n)}})}})}return t}function o(n){r.getAllFlexObjectNamespaces().forEach(function(a){const r=e.get(a,n);if(r){e.set(a,r.filter(e=>{let n;try{n=new t(e.fileName)}catch(e){return false}n.destroy();return true}),n)}});return n}function l(e){return e&&!!n.getOvpEntry(e)}function f(e){return{changes:e,cacheKey:e.cacheKey}}function p(e){if(e?.startupParameters&&Array.isArray(e.startupParameters.hcpApplicationId)){return e.startupParameters.hcpApplicationId[0]}}function u(t){const n="deactivateChanges";const a=t.changes.map(e=>{if(e.changeType===n){return[e.fileName,...e.content.changeIds]}}).flat().filter(Boolean);if(a.length){r.getAllFlexObjectNamespaces().forEach(function(n){const r=e.get(n,t);if(r.length){e.set(n,r.filter(e=>!a.includes(e.fileName)),t)}})}return t}return{loadFlexData(e){var t=n.getBaseComponentNameFromManifest(e.manifest);if(e.partialFlexData){return a.completeFlexData({reference:e.reference,componentName:t,partialFlexData:e.partialFlexData}).then(f)}var r=e.reInitialize?undefined:n.getCacheKeyFromAsyncHints(e.reference,e.asyncHints);return a.loadFlexData({preview:n.getPreviewSectionFromAsyncHints(e.asyncHints),reference:e.reference,componentName:t,cacheKey:r,siteId:p(e.componentData),appDescriptor:e.manifest.getRawJson?e.manifest.getRawJson():e.manifest,version:e.version,allContexts:e.allContexts,adaptationId:e.adaptationId}).then(u.bind()).then(o.bind()).then(c.bind(undefined,l(e.manifest))).then(f)},loadVariantsAuthors(e){const t=i.getInstanceOrUndef();return t?.isVariantAuthorNameAvailable()?a.loadVariantsAuthors(e):Promise.resolve({})}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/ManifestUtils", ["sap/ui/fl/Utils"],function(e){"use strict";function t(e,t){if(e&&e.requests&&Array.isArray(e.requests)){return e.requests.find(function(e){return e.name==="sap.ui.fl.changes"&&(!t||e.reference===t)})}}function r(e){var t=e.manifest;var r=e.componentData||{};if(r.startupParameters){if(Array.isArray(r.startupParameters["sap-app-id"])){return r.startupParameters["sap-app-id"][0]}}var a=t.getEntry?t.getEntry("sap.ui5"):t["sap.ui5"];if(a){if(a.appVariantId){return a.appVariantId}if(a.componentName){return a.componentName}}return n(t)}function n(e){if(e){var t="${pro"+"ject.art"+"ifactId}";var r=e.getEntry?e.getEntry("sap.app"):e["sap.app"];var n=r&&r.id;if(n===t){if(e.getComponentName){return e.getComponentName()}if(e.name){return e.name}}return n}throw new Error("No Manifest received, descriptor changes are not possible")}function a(e){if(e){var t=e.getEntry?e.getEntry("sap.app"):e["sap.app"];var r=t.applicationVersion?.version;return r}return undefined}var i={getAppIdFromManifest:n,getAppVersionFromManifest:a,getFlexReference:r,getFlexReferenceForControl(t){var n=e.getAppComponentForControl(t);return n&&r({manifest:n.getManifestObject(),componentData:n.getComponentData()})},getFlexReferenceForSelector(e){if(e.appId){return e.appId}return i.getFlexReferenceForControl(e.appComponent||e)},getOvpEntry(e){return e.getEntry?e.getEntry("sap.ovp"):e["sap.ovp"]},getCacheKeyFromAsyncHints(e,r){const n=t(r,e);if(n){return n.cachebusterToken||"<NO CHANGES>"}},getPreviewSectionFromAsyncHints(e){var r=t(e);if(r){return r.preview}},getChangeManifestFromAsyncHints(e,r){const n=r&&t(e,r);return!!(!n||n.cachebusterToken)},getBaseComponentNameFromManifest(e){var t=e.getEntry?e.getEntry("sap.ui5"):e["sap.ui5"];return t&&t.componentName||n(e)},isFlexExtensionPointHandlingEnabled(t){var r=e.getAppComponentForControl(t);return!!(r&&r.getManifestEntry("sap.ui5")&&r.getManifestEntry("sap.ui5").flexExtensionPointEnabled)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(e,n){"use strict";var t="sap.ui.fl:PendingChange";var d={};function i(n,t){return e.getControlIdBySelector(n,t)}function c(e){return{changeObject:e,dependencies:[],controlsDependencies:[],dependentIds:[]}}function s(e,n,t){r(t,n,e);o(t,n)}function o(e,n){if(!e.aChanges.includes(n)){e.aChanges.push(n)}}function r(e,n,t){e.mChanges[t]||=[];if(!e.mChanges[t].includes(n)){e.mChanges[t].push(n)}}function a(e,n,t){var d=e.getSelector();if(d){if(d.id){s(i(d,n),e,t)}else{o(t,e)}}return t.aChanges}function p(e,n){return e.some(function(e){return e.id===n.id&&e.idIsLocal===n.idIsLocal})}function u(e,n,t,d,c,s,o){var r=t.getDependentSelectorList();n.some(function(n){if(p(r,n)){var a=i(n,c);var u=d&&s.indexOf(e)<s.indexOf(t);if(u){l(t,e,a,o,true)}else{l(e,t,a,o)}return true}return false})}function f(e,n,t,d){if(e.isValidForDependencyMap()){var i=e.getDependentSelectorList();h(e,i,n,d);var c=t.indexOf(e);var s=c<t.length-1;var o=t.slice();o.splice(c,1);o.reverse().forEach(function(c){if(c.isValidForDependencyMap()){u(e,i,c,s,n,t,d)}})}}function h(e,n,t,d){if(n.length){var s=n.map(function(e){return i(e,t)});if(!d.mDependencies[e.getId()]){d.mDependencies[e.getId()]=c(e)}d.mDependencies[e.getId()].controlsDependencies=s;s.forEach(function(n){d.mControlsWithDependencies[n]||=[];d.mControlsWithDependencies[n].push(e.getId())})}}function l(e,n,t,d,i){if(g(e,n,t,d,i)){d.mDependencies[e.getId()].dependencies.push(n.getId());if(!d.mDependencies[e.getId()].dependentIds.includes(t)){d.mDependencies[e.getId()].dependentIds.push(t)}if(!d.mDependentChangesOnMe[n.getId()]){d.mDependentChangesOnMe[n.getId()]=[]}d.mDependentChangesOnMe[n.getId()].push(e.getId())}}function g(e,n,t,d,i){var c=!i&&d.mDependencies[e.getId()].dependentIds.includes(t);var s=false;if(d.mDependentChangesOnMe[n.getId()]){d.mDependentChangesOnMe[n.getId()].some(function(n){s=d.mDependencies[e.getId()].dependencies.includes(n);return s})}return!c&&!s}function m(e,n){const t=e.aChanges.findIndex(e=>e.getId()===n);if(t!==-1){e.aChanges.splice(t,1)}}function D(e,i){var c=[];var s=[];var o=[];if(e.dependencyRemovedInLastBatch[i]){e.dependencyRemovedInLastBatch[i].forEach(function(n){var d=e.mDependencies[n];if(d&&d.dependencies.length===0&&!(d.controlsDependencies&&d.controlsDependencies.length)){s.push(n);c.push(d.changeObject.getId());if(d[t]){o.push(function(){return d[t]()})}}})}return n.execPromiseQueueSequentially(o).then(function(n,t,i){delete e.dependencyRemovedInLastBatch[i];t.forEach(function(n){delete e.mDependencies[n]});n.forEach(function(n){d.resolveDependenciesForChange(e,n,i)});return!!n.length}.bind(undefined,c,s,i))}d.createEmptyDependencyMap=function(){return{aChanges:[],mChanges:{},mDependencies:{},mDependentChangesOnMe:{},mControlsWithDependencies:{},dependencyRemovedInLastBatch:{}}};d.addChangeAndUpdateDependencies=function(e,n,t){var d=a(e,n,t);f(e,n,d,t)};d.insertChange=function(e,n,t){var d=n&&n.aChanges&&n.aChanges.indexOf(t);if(d>-1){n.aChanges.splice(d+1,0,e)}};d.addRuntimeChangeToMap=function(e,n,t){a(e,n,t)};d.processDependentQueue=function(e,n,t){return D(e,t).then(function(t,i){if(i){return d.processDependentQueue(e,n,t)}return undefined}.bind(undefined,t))};d.addChangeApplyCallbackToDependency=function(e,n,d){e.mDependencies[n][t]=d};d.removeControlsDependencies=function(e,n){var t=e.mControlsWithDependencies[n];if(t){t.forEach(function(t){var d=e.mDependencies[t];if(d&&d.controlsDependencies&&d.controlsDependencies.length){var i=d.controlsDependencies.indexOf(n);if(i>-1){d.controlsDependencies.splice(i,1);delete e.mControlsWithDependencies[n];e.dependencyRemovedInLastBatch[n]||=[];if(!e.dependencyRemovedInLastBatch[n].includes(t)){e.dependencyRemovedInLastBatch[n].push(t)}}}});delete e.mControlsWithDependencies[n]}};d.resolveDependenciesForChange=function(e,n,t){var d=e.mDependentChangesOnMe[n];if(d){d.forEach(function(d){var i=e.mDependencies[d];var c=i?i.dependencies.indexOf(n):-1;if(c>-1){i.dependencies.splice(c,1);e.dependencyRemovedInLastBatch[t]||=[];if(!e.dependencyRemovedInLastBatch[t].includes(d)){e.dependencyRemovedInLastBatch[t].push(d)}}});delete e.mDependentChangesOnMe[n]}m(e,n)};d.removeChangeFromMap=function(e,n){Object.keys(e.mChanges).some(function(t){var d=e.mChanges[t];var i=d.map(function(e){return e.getId()}).indexOf(n);if(i!==-1){d.splice(i,1);return true}return false});m(e,n)};d.removeChangeFromDependencies=function(e,n,t){d.resolveDependenciesForChange(e,n,t);delete e.mDependencies[n]};d.getOpenDependentChangesForControl=function(n,t,d){var i=[];Object.keys(n.mDependencies).forEach(function(c){n.mDependencies[c].changeObject.getDependentSelectorList().forEach(function(s){if(e.getControlIdBySelector(s,d)===t){i.push(n.mDependencies[c].changeObject)}})});return i};return d});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/UIChangesState", ["sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/FlexState"],(e,t,n)=>{"use strict";const a="sap.ui.fl.apply._internal.flexObjects.UIChange";const c={};const r=new t({id:"allUIChanges",parentDataSelector:n.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(e=>e.isA(a))},checkInvalidation(e,t){const n=["addFlexObject","removeFlexObject"].includes(t.type);return n&&t.updatedObject?.isA(a)}});const l=new t({id:"vmIndependentUIChanges",parentDataSelector:r,executeFunction(e){return e.filter(e=>!e.getVariantReference()&&!e.getSelector().persistencyKey&&e.getFileType()!=="ctrl_variant_management_change"&&e.getFileType()!=="ctrl_variant_change")},checkInvalidation(e,t){const n=["addFlexObject","removeFlexObject"].includes(t.type);return n&&t.updatedObject?.isA(a)&&!t.updatedObject.getVariantReference()&&!t.updatedObject.getSelector().persistencyKey&&t.updatedObject.getFileType()!=="ctrl_variant_management_change"&&t.updatedObject.getFileType()!=="ctrl_variant_change"}});const p=new t({id:"vmIndependentCompleteDependencyMap",parentDataSelector:l,executeFunction(t,a){const c=e.createEmptyDependencyMap();const r=n.getComponentIdForReference(a.reference);t.forEach(t=>{e.addChangeAndUpdateDependencies(t,r,c)});return c}});c.getVMIndependentCompleteDependencyMap=function(e){return p.get({reference:e})};c.getVariantIndependentUIChanges=function(e){return l.get({reference:e})};c.getAllUIChanges=function(e){return r.get({reference:e})};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/communication/FLPAboutInfo", ["sap/ui/core/Lib","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/Utils"],function(t,e,a,n,i){"use strict";let o={};function s(t,e,a,n){const i={info:{customProperties:{[n]:{label:e,value:a,showInAbout:true}}}};t.setAppInfo(i)}function c(t){if(t.homePage||t.applicationType!=="UI5"){return false}return true}async function p(i,o){if(c(o)){const c=o.componentInstance;const p=a.getFlexReference({componentData:c.getComponentData(),manifest:c.getManifest()});const r={reference:p,componentId:c.getId(),manifest:c.getManifestObject(),componentData:c.getComponentData(),asyncHints:c._componentConfig.asyncHints};await e.initialize(r);const l=n.getContextBasedAdaptationId(r);if(l==="DEFAULT"||!l){return}const u=n.getContextBasedAdaptationTitle(r);const f=t.getResourceBundleFor("sap.ui.fl").getText("CBA_ABOUT_INFO_DIALOG_LABEL");const d=`${u} (${l})`;s(i,f,d,"ui5.flex.adaptation")}}async function r(){const t=await i.getUShellService("AppLifeCycle");const e=t.getCurrentApplication();if(e){await p(t,e)}t.attachAppLoaded(t,o.onAppLoadedListener)}function l(){return new Promise(t=>{sap.ui.require(["sap/ushell/api/BootstrapObserver"],async function(e){await e.ready();t()})})}function u(){return new Promise(e=>{t.attachLibraryChanged(t=>{if(t.getParameter("operation")==="add"&&t.getParameter("metadata").sName==="sap.ushell"){e()}})})}async function f(){if(!t.isLoaded("sap.ushell")){await u()}await l()}o={async initialize(){await f();await r()},async onAppLoadedListener(t,e){const a=t.getParameters();await p(e,a)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantManagementState", ["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexObjects/CompVariant"],function(e,t,n){"use strict";const a={};const r="sap.ui.fl.apply._internal.flexObjects.UpdatableChange";const s=e=>e?.isA(r)&&e.getFileType()==="change"&&e.getChangeType()==="defaultVariant";const i=new t({id:"compSetDefault",parameterKey:"persistencyKey",parentDataSelector:e.getFlexObjectsDataSelector(),executeFunction(e,t){return e.filter(e=>s(e)&&String(e.getSelector()?.persistencyKey)===t.persistencyKey)},checkInvalidation(e,t){const n=["addFlexObject","removeFlexObject"].includes(t.type);return n&&s(t.updatedObject)}});a.getSetDefaultDataSelector=function(){return i};a.getDefaultVariantId=e=>{const t=e.variants;const a=t.map(e=>e.getVariantId());a.push(n.STANDARD_VARIANT_ID);e.persistencyKey=String(e.persistencyKey);const r=[...i.get(e)].reverse();const s=r.map(e=>e.getContent().defaultVariantName);return s.find(e=>a.includes(e))||""};a.getDefaultChanges=e=>{e.persistencyKey=String(e.persistencyKey);return i.get(e)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger", ["sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/base/Log"],function(e,t,a,n,i){"use strict";var r={addFavorite(e){e.setFavorite(true)},removeFavorite(e){e.setFavorite(false)},updateVariant(e,t){var a=t.getContent();if(a.executeOnSelection!==undefined){e.setExecuteOnSelection(a.executeOnSelection)}if(a.favorite!==undefined){e.setFavorite(a.favorite)}if(a.contexts){e.setContexts(a.contexts)}if(a.visible!==undefined){e.setVisible(a.visible)}if(a.variantContent){e.setContent(a.variantContent,true)}var n=t.getText("variantName");if(n){e.setName(n,true)}},standardVariant(e,t){e.setExecuteOnSelection(t.getContent().executeOnSelect)}};function o(e){var t={};e.changes.forEach(function(e){var a=e.getSelector().variantId||e.getContent().key;t[a]||=[];t[a].push(e)});return t}function d(e,t){i.error(`No change handler for change with the ID '${t.getId()}' and type '${t.getChangeType()}' defined.\n\t\t\tThe variant '${e.getId()}'was not modified'`)}function s(a,n,i){var r={fileName:n.fileName,variantId:n.id||e.STANDARD_VARIANT_ID,persisted:n.persisted,content:n.content||{},texts:{variantName:{value:n.name||""}},selector:{persistencyKey:a}};if(n.favorite!==undefined){r.favorite=n.favorite}if(n.executeOnSelection!==undefined){r.executeOnSelection=n.executeOnSelection}if(n.adaptationId!==undefined){r.adaptationId=n.adaptationId}return t.createCompVariant(r,i)}function f(e,t){var a=r[t.getChangeType()]||d;a(e,t);e.addChange(t)}function c(e,t){var a=t.getVariantId();if(e[a]){e[a].forEach(function(e){f(t,e)})}}return{merge(e,t,i){var r=t.nonPersistedVariants.concat(t.variants);var d=o(t);var f;r.forEach(function(e){if(e.getContent()&&e.getContent().standardvariant){f=e}});if(!f){f=s(e,i)}else{r=r.filter(function(e){return!e.getContent()||!e.getContent().standardvariant})}t.nonPersistedVariants.concat([f]).forEach(e=>{e.setState(a.LifecycleState.PERSISTED)});r.forEach(c.bind(undefined,d));r=r.filter(function(e){var a=e.getVisible();if(!a){var n=e.getId();delete d[n];delete t.byId[n]}return a});f.setFavorite(true);f.setStandardVariant(true);t.byId[f.getVariantId()]=f;var u=t.standardVariantChange;if(u){d[f.getVariantId()]=d[f.getVariantId()]||[];d[f.getVariantId()].push(u);d[f.getVariantId()].sort(function(e,t){if(e.getCreation()<t.getCreation()){return-1}if(e.getCreation()>t.getCreation()){return 1}return 0})}c(d,f);t.standardVariant=f;const l=n.getDefaultVariantId(t);r.some(e=>{if(!e.getFavorite()&&e.getId()===l){e.setFavorite(true)}});return{standardVariant:f,variants:r}},createVariant(e,t,a){return s(e,t,a)},applyChangeOnVariant:f}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/Utils", [],function(){"use strict";var e={};e.getPersistencyKey=e=>{if(e){var t=e.getVariantManagement?.()||e;if(t.getPersonalizableControlPersistencyKey){return t.getPersonalizableControlPersistencyKey()}return t.getPersistencyKey&&t.getPersistencyKey()}return undefined};e.getDefaultVariantId=e=>{const t=e.defaultVariants;const n=[...t].reverse().find(t=>{if(t?.getContent().defaultVariantName==="*standard*"){return true}return Object.keys(e.byId).some(e=>t?.getContent().defaultVariantName===e)});return n?.getContent().defaultVariantName||""};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/prepareCompVariantsMap", ["sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UpdatableChange","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger"],function(e,t,n,a){"use strict";function s(e,t){e[t]||={byId:{},variants:[],nonPersistedVariants:[],changes:[],defaultVariants:[],standardVariantChange:undefined,standardVariant:undefined};return e[t]}function r(e,t,n,r,i){r||=[];const c=s(e,n);c.controlId=i;c.nonPersistedVariants.forEach(function(e){delete c.byId[e.getId()]});c.nonPersistedVariants=r.map(function(e){const s=a.createVariant(n,{id:e.id,persisted:false,...e},t);c.byId[e.id]=s;return s});return c}function i(a,r,i,c){const o=a[r].map(function(a){const s=r==="variants"?e.createCompVariant(a,c):e.createFromFileContent(a,n);s.setState(t.LifecycleState.PERSISTED);return s});o.forEach(function(e){const t=e.getPersistencyKey?e.getPersistencyKey():e.getSelector().persistencyKey;s(i,t).byId[e.getId()]=e;switch(r){case"standardVariants":s(i,t).standardVariantChange=e;break;default:s(i,t)[r].push(e)}})}return function(e){const t={};t._getOrCreate=s.bind(undefined,t);t._initialize=r.bind(undefined,t,e.storageResponse.authors);if(e.storageResponse.changes.comp){["variants","changes","defaultVariants","standardVariants"].forEach(function(n){i(e.storageResponse.changes.comp,n,t,e.storageResponse.authors)})}return t}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher", ["sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState"],function(e,a,r,n){"use strict";function t(a){const r=n.getControlChangesForVariant({...e(a,["vmReference","variantsMap","reference"]),vReference:a.currentVReference});var t=n.getControlChangesForVariant({...e(a,["vmReference","variantsMap","reference"]),vReference:a.newVReference});var i=[];if(t.length>0){i=r.slice();r.some(function(e){if(t[0]&&e.getId()===t[0].getId()){t.shift();i.shift()}else{return true}})}else{i=r}var s={changesToBeReverted:i.reverse(),changesToBeApplied:t};return s}var i={async switchVariant(e){var i=t(e);await r.revertMultipleChanges(i.changesToBeReverted,e);await a.applyMultipleChanges(i.changesToBeApplied,e);n.setCurrentVariant(e)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState", ["sap/base/util/restricted/_omit","sap/base/util/restricted/_pick","sap/base/util/ObjectPath","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/initial/_internal/Storage","sap/ui/fl/LayerUtils"],function(e,t,n,a,r,c,i,s,f,o,u){"use strict";const l={ctrl_variant_change:{getCondenserInfo(e){return{classification:f.LastOneWins,uniqueKey:e.getVariantId()+e.getChangeType()}}},ctrl_variant_management_change:{getCondenserInfo(e,t){return{classification:f.LastOneWins,uniqueKey:t.modifier.getControlIdBySelector(e.getSelector(),t.appComponent)}}}};var g={};const v={};const d={};function h(e,t,r){var c=s.getComponentData(e);var i=n.get(["technicalParameters",a.VARIANT_TECHNICAL_PARAMETER],c)||[];var f=r.filter(e=>e.visible).map(e=>e.key);if(i.length===1){i=i[0].split(",")}var o=f.find(e=>i.includes(e));if(o){return o}return t.slice().reverse().map(e=>e.getContent().defaultVariant).find(e=>f.includes(e))}function p(e,t,n){var a=(v[t]||{})[n];return{defaultVariant:n,currentVariant:a,variants:[],variantManagementChanges:e.filter(function(e){return e.getSelector().id===n})}}function m(e,t){return e.find(e=>e.getId()===t)}function V(e,t){const n=[];let a=t;let r;do{r=m(e,a.getVariantReference());if(r){n.push(r);a=r}}while(r);return n.map(e=>e.getId())}function C(e,t){const n=V(e.variants,t);return{instance:t,variantChanges:e.variantChanges.filter(function(e){return e.getVariantId()===t.getId()}),controlChanges:e.changes.filter(function(e){var a=e.isA("sap.ui.fl.apply._internal.flexObjects.UIChange");if(!a){return false}var r=e.getVariantReference()===t.getId();var c=n.indexOf(e.getVariantReference())>-1;var i=u.compareAgainstCurrentLayer(e.getLayer(),t.getLayer())===-1;return r||c&&i}),key:t.getId(),title:t.getName(),layer:t.getLayer(),favorite:t.getFavorite(),executeOnSelect:t.getExecuteOnSelection(),visible:t.getVisible(),author:t.getAuthor(),contexts:t.getContexts(),isStandardVariant:t.getStandardVariant()}}function y(e,t){switch(t.getChangeType()){case"setTitle":e.title=t.getText("title");break;case"setFavorite":e.favorite=t.getContent().favorite;break;case"setExecuteOnSelect":e.executeOnSelect=t.getContent().executeOnSelect;break;case"setVisible":e.visible=t.getContent().visible;break;case"setContexts":e.contexts=t.getContent().contexts;break;default:throw Error("Unknown ctrl_variant_change type")}}function b(e,t){var n=t.getContent().defaultVariant;e.variants.forEach(t=>{if(t.key===n&&t.visible){e.defaultVariant=n}})}function R(e){const t={variants:[],variantManagementChanges:[],changes:[],variantChanges:[]};e.forEach(e=>{switch(e.getFileType()){case"ctrl_variant":t.variants.push(e);break;case"ctrl_variant_management_change":t.variantManagementChanges.push(e);break;case"change":t.changes.push(e);break;case"ctrl_variant_change":t.variantChanges.push(e);break;default:break}});return t}function O(e){const t=R(e);const a=e[0]?.getFlexObjectMetadata().reference;const r={};t.variants.forEach(e=>{var n=e.getVariantManagementReference();r[n]||=p(t.variantManagementChanges,a,n);r[n].variants.push(C(t,e))});t.variantChanges.forEach(e=>{const t=x(r,e);if(t){y(t,e,a,r)}});t.variantManagementChanges.forEach(e=>{const t=r[e.getSelector().id];if(t){b(t,e)}});Object.keys(r).forEach(e=>{const c=r[e];if(!c.currentVariant||!c.variants.some(e=>e.key===c.currentVariant)){const r=h(a,t.variantManagementChanges,c.variants)||e;c.currentVariant=r;n.set([a,e],r,v)}c.variants.sort((e,t)=>{if(e.isStandardVariant){return-1}if(t.isStandardVariant){return 1}return e.title.toLowerCase()<t.title.toLowerCase()?-1:1});var i=c.variants.find(e=>e.key===c.currentVariant).controlChanges;c.modified=i.some(e=>!e.isPersisted()&&!e.getSavedToVariant());c.variants.some(e=>{if(!e.favorite&&e.key===c.defaultVariant){e.favorite=true;return true}return false})});return r}function x(e,t){var n;Object.values(e).some(function(e){return e.variants.some(function(e){if(t.getVariantId()===e.key){n=e;return true}return false})});return n}var S=new i({id:"variantManagementMap",parentDataSelector:s.getFlexObjectsDataSelector(),executeFunction:O,checkInvalidation(e,t){if(t.type==="switchVariant"){return true}const n=["addFlexObject","updateFlexObject","removeFlexObject"];const a=n.includes(t.type);const r=["ctrl_variant","ctrl_variant_change","ctrl_variant_management_change"];const c=r.includes(t.updatedObject?.getFileType?.());const i=t.updatedObject?.getVariantReference?.();return a&&(c||i)}});var _=new i({id:"variantManagements",parameterKey:"variantManagementReference",parentDataSelector:S,executeFunction(e,t){return e[t.variantManagementReference]}});var j=new i({id:"variants",parameterKey:"variantReference",parentDataSelector:_,executeFunction(e,t){return e.variants.find(e=>e.instance.getId()===t.variantReference)}});const F=new i({id:"vmDependentDependencyMap",parentDataSelector:S,executeFunction(e,t){let n=[];Object.entries(e).forEach(([e,a])=>{n=n.concat(g.getControlChangesForVariant({vmReference:e,vReference:a.currentVariant,reference:t.reference}))});const a=c.createEmptyDependencyMap();const r=s.getComponentIdForReference(t.reference);n.forEach(e=>{c.addChangeAndUpdateDependencies(e,r,a)});return a},checkInvalidation(e,t){if(t.type==="switchVariant"){return true}const n=["addFlexObject","removeFlexObject"].includes(t.type);const a=t.updatedObject.getFileType()==="change";const r=Object.values(v[e.reference]||{});return a&&n&&r.includes(t.updatedObject.getVariantReference())}});var k=new i({id:"variantDependentFlexObjects",parentDataSelector:s.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(function(e){const t=e.getVariantReference?.();const n=["ctrl_variant","ctrl_variant_change","ctrl_variant_management_change"].indexOf(e.getFileType())>-1;return n||t})}});g.getDependencyMap=function(e){return F.get({reference:e})};g.getVariantDependentFlexObjects=function(e){return k.get({reference:e})};g.getChangeInformationProvider=function(e){return l[e.getFileType()]};g.resetCurrentVariantReference=function(e){delete v[e];S.checkUpdate({reference:e})};g.getVariantManagementMap=function(){return S};g.addRuntimeSteadyObject=function(e,t,n){s.addRuntimeSteadyObject(e,t,n)};g.clearRuntimeSteadyObjects=function(e,t){s.clearRuntimeSteadyObjects(e,t)};g.addRuntimeOnlyFlexObjects=function(e,t){t.forEach(t=>s.getRuntimeOnlyData(e).flexObjects.push(t));s.getFlexObjectsDataSelector().clearCachedResult({reference:e})};g.loadVariant=async function(e){const t=await o.loadFlVariant({variantReference:e.variantReference,reference:e.reference});s.updateWithDataProvided({reference:e.reference,newData:t})};g.getControlChangesForVariant=function(e){const t=g.getVariant(e);if(t){return t.controlChanges.filter(function(t){const n=t.getState()!==r.LifecycleState.PERSISTED;const a=t.getVariantReference()!==e.vReference;return(e.includeDirtyChanges!==false||!n)&&(e.includeReferencedChanges!==false||!a)})}return[]};g.getVariantChangesForVariant=function(e){var t=g.getVariant(e);return t&&t.variantChanges||{}};g.getVariant=function(e){var t=e.vReference||_.get({variantManagementReference:e.vmReference,reference:e.reference}).defaultVariant;return j.get({variantManagementReference:e.vmReference,variantReference:t,reference:e.reference})};g.getCurrentVariantReference=function(e){var t=_.get({variantManagementReference:e.vmReference,reference:e.reference});return t.currentVariant};g.getAllCurrentVariants=function(e){const t=S.get({reference:e});return Object.entries(t).map(t=>{const n=g.getVariant({vmReference:t[0],vReference:t[1].currentVariant,reference:e}).instance;return n})};g.getVariantManagementReferences=function(e){var t=S.get({reference:e});return Object.keys(t)};g.getAllVariants=function(e){var t=S.get({reference:e});return Object.keys(t).reduce(function(e,n){return e.concat(t[n].variants)},[])};g.getVariantManagementChanges=function(e){const t=S.get({reference:e.reference});const n=Object.values(t).map(e=>e.variantManagementChanges).flat();if(!e.vReference){return n}return n.filter(t=>e.vReference===t.getContent().defaultVariant)};g.getInitialUIChanges=function(e){const t=S.get({reference:e.reference});e.includeDirtyChanges=!!e.includeDirtyChanges;return Object.keys(t).reduce(function(n,a){if(e.vmReference&&e.vmReference===a||!e.vmReference){const r={...e,vmReference:a,vReference:t[a].currentVariant};return n.concat(g.getControlChangesForVariant(r))}return n},[])};g.getAllCurrentFlexObjects=function(e){const t=S.get({reference:e.reference});return Object.keys(t).reduce(function(n,a){if(e.vmReference&&e.vmReference===a||!e.vmReference){const r={...e,vmReference:a,vReference:t[a].currentVariant};const c=g.getVariant(r);return n.concat(c.variantChanges).concat(c.controlChanges).concat(t[a].variantManagementChanges).concat(t[a].variants.map(e=>e.instance))}return n},[])};g.filterHiddenFlexObjects=function(e,t){const n=S.get({reference:t});const a=[];Object.values(n).forEach(e=>{e.variants.forEach(e=>{if(e.visible===false){a.push(e.key)}})});return e.filter(e=>{const t={ctrl_variant:()=>e.getVariantId(),ctrl_variant_change:()=>e.getVariantId(),change:()=>e.getVariantReference()}[e.getFileType()]?.();return!a.includes(t)})};g.setCurrentVariant=function(e){n.set([e.reference,e.vmReference],e.newVReference,v);S.checkUpdate({reference:e.reference},[{type:"switchVariant"}])};g.setVariantSwitchPromise=function(e,t){d[e]=t};g.getVariantSwitchPromise=function(e){return d[e]};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/ComponentLifecycleHooks", ["sap/base/Log","sap/ui/core/Component","sap/ui/core/Lib","sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/changes/descriptor/InlineApplier","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration","sap/ui/fl/variants/VariantModel","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/model/odata/ODataUtils","sap/ui/performance/Measurement"],function(e,t,n,o,a,i,r,s,l,c,p,g,d,f,u,m,h){"use strict";var C={};C._componentInstantiationPromises=new WeakMap;var y={};function v(t){if(f.getUshellContainer()){return Promise.resolve()}var o=window.sessionStorage.getItem(`sap.ui.rta.restart.${d.CUSTOMER}`);if(o){var a=s.getFlexReferenceForControl(t);if(o!==a&&o!=="true"){e.error(`an application component was started which does not match the component for which the restart was triggered:\n\t\t\t\t\tTriggering component: ${o}\n\t\t\t\t\tStarted component: ${a}`);return Promise.resolve()}return new Promise(function(e,o){Promise.all([n.load({name:"sap.ui.rta"}),t.rootControlLoaded()]).then(function(){sap.ui.require(["sap/ui/rta/api/startKeyUserAdaptation"],function(n){n({rootControl:t});e()})}).catch(function(e){o(e)})})}return Promise.resolve()}function M(e){const t=s.getFlexReferenceForControl(e);const n=r.getStorageResponse(t);if(n.messagebundle&&!e.getModel("i18nFlexVendor")&&n.changes?.changes?.some(e=>e.layer===d.VENDOR)){e.setModel(new u(n.messagebundle),"i18nFlexVendor")}}async function w(e){var t=g.createForControl(e);const n=s.getFlexReferenceForControl(e);var o;var a=i.applyAllChangesForControl.bind(i,e,n);a._bIsSapUiFlFlexControllerApplyChangesOnControl=true;e.addPropagationListener(a);o=C._createVariantModel(t,e);await o.initialize();h.end("flexProcessing");e.setModel(o,l.getVariantModelName());await v(e)}function F(e,t){if(f.isApplicationComponent(e)){var n=e.getId();var o=r.initialize({componentId:n,asyncHints:t.asyncHints}).then(w.bind(this,e)).then(M.bind(this,e)).then(function(){if(y[n]){y[n].forEach(function(t){var n=e.getModel(l.getVariantModelName());t.setModel(n,l.getVariantModelName())});delete y[n]}});C._componentInstantiationPromises.set(e,o);return o}else if(f.isEmbeddedComponent(e)){var a=f.getAppComponentForControl(e);if(C._componentInstantiationPromises.has(a)){return C._componentInstantiationPromises.get(a).then(function(){var t=a.getModel(l.getVariantModelName());e.setModel(t,l.getVariantModelName())})}y[a.getId()]=y[a.getId()]||[];y[a.getId()].push(e);return Promise.resolve()}return Promise.resolve()}function P(e,t){if(!f.isApplication(t)||!e.id){return Promise.resolve()}r.initialize({componentData:e.componentData||e.settings&&e.settings.componentData,asyncHints:e.asyncHints,manifest:t,componentId:e.id});return a.applyChanges(t,o.getRuntimeStrategy())}C._createVariantModel=function(e,t){return new p({},{flexController:e,appComponent:t})};C.instanceCreatedHook=function(...e){return F(...e)};C.componentLoadedHook=function(...e){return P(...e)};async function A(n){const o=n.owner&&t.get(n.owner.id);const a=n.owner?.id||n.factoryConfig.id||n.factoryConfig.settings?.id;const i=o?.getComponentData()||n.factoryConfig.componentData||n.factoryConfig.settings?.componentData;const l=s.getFlexReference({manifest:o?.getManifest()||n.manifest,componentData:i});try{await r.initialize({componentData:i,asyncHints:n.owner?.config.asyncHints||n.factoryConfig.asyncHints,componentId:a,reference:l,partialFlexState:true});const e=m.removeOriginSegmentParameters(n.model.getServiceUrl());const t=r.getAnnotationChanges(l).filter(t=>t.getServiceUrl()===e);const o=[];for(const e of t){const t=await c.getAnnotationChangeHandler({changeType:e.getChangeType()});o.push(await t.applyChange(e));e._appliedOnModel=true}return o}catch(t){e.error("Annotation changes could not be applied.",t);return[]}}C.modelCreatedHook=function(e){e.model.setAnnotationChangePromise(A(e))};return C});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/ControllerExtension", ["sap/base/Log","sap/ui/core/Component","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/Utils"],function(e,t,n,r,o){"use strict";var i=function(){};function u(e){return e.getChangeType()==="codeExt"}function a(e){if(!e.startsWith("module:")){return`module:${e.replace(/\./g,"/")}.controller`}return e}function l(e,t){var n=a(t.getSelector().controllerName);return n===a(e)}function s(t){return new Promise(function(n){sap.ui.require(t,function(...e){n(e)},function(t){e.error("Code Extension not found",t.message);n([])})})}i.prototype.getControllerExtensions=function(e,i,a){if(a){if(!i){return Promise.resolve([])}var f=t.getComponentById(i);var c=o.getAppComponentForControl(f);if(!c){return Promise.resolve([])}if(!o.isApplication(c.getManifestObject())){return Promise.resolve([])}var p=r.getFlexReferenceForControl(c);return n.waitForInitialization(p).then(()=>{const t=n.getFlexObjectsDataSelector().get({reference:p});var r=t.filter(function(t){return u(t)&&l(e,t)}).map(function(e){return e.getModuleName()});return s(r)})}return[]};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/RegistrationDelegator", ["sap/ui/core/mvc/ControllerExtensionProvider","sap/ui/core/mvc/XMLView","sap/ui/core/ComponentHooks","sap/ui/core/ExtensionPoint","sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor","sap/ui/fl/apply/_internal/flexState/communication/FLPAboutInfo","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/preprocessors/ComponentLifecycleHooks","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/fl/changeHandler/ChangeAnnotation","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration","sap/ui/base/DesignTime","sap/ui/fl/apply/_internal/preprocessors/ControllerExtension","sap/ui/fl/apply/_internal/preprocessors/XmlPreprocessor"],function(e,n,a,r,i,t,o,s,l,p,d,u){"use strict";var c={};function f(){a.onInstanceCreated.register(s.instanceCreatedHook)}function g(){d.registerPredefinedChangeHandlers();d.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();d.registerAnnotationChangeHandler({changeHandler:p,isDefaultChangeHandler:true})}function m(){a.onModelCreated.register(s.modelCreatedHook)}function P(){a.onComponentLoaded.register(s.componentLoadedHook)}function C(){e.registerExtensionProvider("sap/ui/fl/apply/_internal/preprocessors/ControllerExtension")}function D(){if(n.registerPreprocessor){n.registerPreprocessor("viewxml","sap.ui.fl.apply._internal.preprocessors.XmlPreprocessor")}}function y(){a.onPreprocessManifest.register(i.preprocessManifest)}function H(e){if(o.isFlexExtensionPointHandlingEnabled(e)){return"sap/ui/fl/apply/_internal/extensionPoint/Processor"}if(u.isDesignModeEnabled()){return"sap/ui/fl/write/_internal/extensionPoint/Processor"}return undefined}function _(){r.registerExtensionProvider(H)}function x(){l.registerReadDelegate({modelType:"sap.ui.model.odata.v4.ODataModel",delegate:"sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate"});l.registerReadDelegate({modelType:"sap.ui.model.odata.v2.ODataModel",delegate:"sap/ui/fl/write/_internal/delegates/ODataV2ReadDelegate"});l.registerReadDelegate({modelType:"sap.ui.model.odata.ODataModel",delegate:"sap/ui/fl/write/_internal/delegates/ODataV2ReadDelegate"})}function h(){t.initialize()}c.registerAll=function(){g();P();C();f();D();y();_();x();m();h()};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/XmlPreprocessor", ["sap/base/util/merge","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/Utils","sap/base/Log"],function(e,t,n,a,i,r,o,l,p,s,c){"use strict";var f=function(){};f.NOTAG="<NoTag>";function u(e){const t=o.getAllApplicableUIChanges(e.reference);return t.filter(i.isChangeInView.bind(undefined,e))}f.process=async function(i,r){try{r.viewId=r.id;var o=n.getComponentById(r.componentId);if(!o){c.warning("View is generated without a component. Flexibility features are not possible.");return i}var f=s.getAppComponentForControl(o);if(!s.isApplication(f.getManifestObject())){return i}const g=p.getFlexReferenceForControl(f);await l.waitForInitialization(g);const d=e({appComponent:f,modifier:t,view:i,reference:g},r);const y=u(d);await a.applyAllChangesForXMLView(d,y);c.debug(`flex processing view ${r.id} finished`);return i}catch(e){var g=`view ${r.id}: ${e}`;c.info(g);return i}};function g(e,t){if(!t){return e}return e.concat("-",t)}function d(e){return e.replace(/(^W\/|")/g,"")}f.getCacheKey=async function(e){const t=n.getComponentById(e.componentId);const a=s.getAppComponentForControl(t);if(s.isVariantByStartupParameter(a)){return undefined}const i=p.getFlexReferenceForControl(a);let o=f.NOTAG;if(i){const e=await l.getStorageResponse(i);if(e?.cacheKey){o=d(e.cacheKey);const t=r.getAllCurrentVariants(i).filter(e=>!e.getStandardVariant()).map(e=>e.getId());o=g(o,t.join("-"))}}return o};return f},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/ControlVariantApplyAPI", ["sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/Utils"],function(e,t,n,a,r,o){"use strict";var i="$FlexVariants";function l(e){var t=e.getModel(i);if(t){return Promise.resolve(t)}return new Promise(function(n){function a(){t=e.getModel(i);if(t){e.detachModelContextChange(a);n(t)}}e.attachModelContextChange(a)})}var c={getVariantModelName(){return i},getVariantModel(e){return l(e)},clearVariantParameterInURL(t){var n;var r=o.getAppComponentForControl(t.control);var l=r&&r.getModel(i);if(!l){e.error("Variant model could not be found on the provided control");return}if(t.control.isA("sap.ui.fl.variants.VariantManagement")){var c=l.getLocalId(t.control.getId(),r);var d=a.removeURLParameterForVariantManagement({model:l,vmReference:c});n=d.parameters}a.update({parameters:n||[],updateURL:true,updateHashEntry:!!l,model:l||{},silent:!l})},async activateVariant(a){function l(t){e.error(t);return Promise.reject(t)}let c;if(typeof a.element==="string"){c=t.getComponentById(a.element);if(!(c instanceof t)){c=n.getElementById(a.element);if(!(c instanceof n)){return l(Error("No valid component or control found for the provided ID"))}}}else if(a.element instanceof t||a.element instanceof n){c=a.element}const d=o.getAppComponentForControl(c);if(!d){return l(Error("A valid variant management control or component (instance or ID) should be passed as parameter"))}const s=d.getModel(i);if(!s){return l(Error("No variant management model found for the passed control or application component"))}if(a.standardVariant&&!c.isA("sap.ui.fl.variants.VariantManagement")){return l(Error("With using standardVariant and no variantReference, a variant management control must be passed as element"))}const m=a.standardVariant?s.getVariantManagementReferenceForControl(a.element):a.variantReference;if(!s.getVariantManagementReference(m).variantManagementReference){try{await r.loadVariant({reference:s.sFlexReference,variantReference:m})}catch(e){return l(Error(`Variant with reference '${m}' could not be found`))}}const p=s.getVariantManagementReference(m).variantManagementReference;if(!p){return l(Error("A valid control or component, and a valid variant/ID combination are required"))}await s.waitForVMControlInit(p);try{return s.updateCurrentVariant({variantManagementReference:p,newVariantReference:m,appComponent:d})}catch(t){e.error(t);throw t}},attachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var a=o.getAppComponentForControl(t);l(a).then(function(n){n.attachVariantApplied({vmControlId:e.vmControlId,control:t,callback:e.callback,callAfterInitialVariant:e.callAfterInitialVariant})})},detachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var a=o.getAppComponentForControl(t);l(a).then(function(n){n.detachVariantApplied(e.vmControlId,t.getId())})}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/DelegateMediatorAPI", ["sap/ui/fl/apply/_internal/DelegateMediator"],function(e){"use strict";const t={registerReadDelegate(t){e.registerReadDelegate(t)},registerWriteDelegate(t){e.registerWriteDelegate(t)},getReadDelegateForControl(t){return e.getReadDelegateForControl(t.control,t.modifier,t.modelType,t.supportsDefault)},getWriteDelegateForControl(t){return e.getWriteDelegateForControl(t.control,t.modifier)}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/ExtensionPointRegistryAPI", ["sap/ui/fl/apply/_internal/extensionPoint/Registry"],function(n){"use strict";var e={getExtensionPointInfo(e){return n.getExtensionPointInfo(e.name,e.view)},getExtensionPointInfoByViewId(e){return n.getExtensionPointInfoByViewId(e.viewId)},getExtensionPointInfoByParentId(e){return n.getExtensionPointInfoByParentId(e.parentId)},addCreatedControlsToExtensionPointInfo(e){n.addCreatedControls(e.name,e.viewId,e.createdControlsIds)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/FlexRuntimeInfoAPI", ["sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/api/InitialFlexAPI","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/VersionInfo"],function(e,t,n,r,o,i,s,a,l,c,p,u,f){"use strict";var g={isPersonalized(n){function r(t){e.error(t);return Promise.reject(t)}function s(e){return e.getLayer()===p.USER}function a(e){return e.getFileType()==="change"}function l(e,n,r){var o=n.map(function(e){return e.id||e.getId()});var i=r.getSelector();var s=t.getControlIdBySelector(i,e);return o.includes(s)}function c(e,t){return Array.isArray(e)&&e.length>0?e.includes(t.getChangeType()):true}if(!n.selectors||n.selectors.length===0){return r("At least one control ID has to be provided as a parameter")}var f=n.selectors[0].appComponent||u.getAppComponentForControl(n.selectors[0]);if(!f){return r("App Component could not be determined")}const g=i.getFlexReferenceForControl(f);const d=o.getFlexObjectsDataSelector().get({reference:g}).filter(a).filter(s).filter(l.bind(this,f,n.selectors)).filter(c.bind(this,n.changeTypes));return Promise.resolve(d.length>0)},waitForChanges(e){let t;if(e.element){t=[{selector:e.element}]}else if(e.selectors){t=e.selectors.map(function(e){return{selector:e}})}else if(e.complexSelectors){t=e.complexSelectors}return r.waitForFlexObjectsToBeApplied(t)},isFlexSupported(e){return!!u.getAppComponentForControl(e.element)},hasVariantManagement(e){return n.belongsToVariantManagement(e.element)},getFlexReference(e){return i.getFlexReferenceForControl(e.element)},getConfiguredFlexServices(){return s.getFlexibilityServices()},getFlexVersion(e){return l.getFlexVersion(e)},getContextBasedAdaptationId(e){return a.getByReference(e.reference)?.adaptationId},getContextBasedAdaptationTitle(e){return a.getByReference(e.reference)?.adaptationTitle},async getFeedbackInformation(e){const t=this.getConfiguredFlexServices()[0].connector;const n=u.getAppDescriptor(e.rootControl);const r=await f.load();const o=i.getAppIdFromManifest(n);const s=i.getAppVersionFromManifest(n);return{appId:o,appVersion:s,connector:t,version:r.version}},isCustomerSystem(){return c.getInstanceOrUndef()?.isCustomerSystem()},isAtoEnabled(){return c.getInstanceOrUndef()?.isAtoEnabled()},getSystem(){return c.getInstanceOrUndef()?.getSystem()},getUserId(){return c.getInstanceOrUndef()?.getUserId()}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddIFrame", ["sap/ui/fl/changeHandler/common/revertAddedControls","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n,o){"use strict";const a={};a.applyChange=async function(e,o,a){const r=a.modifier;const g=e.getContent();const i=a.view;const c=g.targetAggregation;const s=await r.findAggregation(o,c);if(!s){throw new Error(`The given Aggregation is not available in the given control: ${r.getId(o)}`)}const f=await t(e,o,a);const l=await n(e,a,g.selector);await r.insertAggregation(o,c,l,f,i);e.setRevertData([r.getId(l)])};a.revertChange=e;a.completeChangeContent=function(e,t,n){const o=n.modifier;const a=n.appComponent;["targetAggregation","baseId","url"].forEach(function(e){if(!Object.hasOwn(t.content,e)){throw new Error(`Attribute missing from the change specific content '${e}'`)}});const r={...t.content};r.selector=o.getSelector(r.baseId,a);e.setContent(r)};a.getChangeVisualizationInfo=function(e){return{affectedControls:[e.getContent().selector]}};a.getCondenserInfo=function(e){const t=e.getContent();return{classification:o.Create,uniqueKey:"iFrame",affectedControl:t.selector,targetContainer:e.getSelector(),targetAggregation:t.targetAggregation,setTargetIndex(e,t){e.getContent().index=t},getTargetIndex(e){return e.getContent().index},update(e,t){Object.assign(e.getContent(),t)}}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddXML", ["sap/ui/fl/changeHandler/BaseAddXml"],function(e){"use strict";var t={};t.applyChange=function(t,n,r){var g=t.getContent();var a={aggregationName:g.targetAggregation,index:g.index};return e.applyChange(t,n,r,a)};t.revertChange=e.revertChange;t.completeChangeContent=function(t,n){const r=n.content||n;const g={};if(!r.targetAggregation){e._throwMissingAttributeError("targetAggregation")}else{g.targetAggregation=r.targetAggregation}if(r.index===undefined){e._throwMissingAttributeError("index")}else{g.index=r.index}e.completeChangeContent(t,n,g)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddXMLAtExtensionPoint", ["sap/ui/fl/apply/api/ExtensionPointRegistryAPI","sap/ui/fl/changeHandler/BaseAddXml"],function(e,n){"use strict";const t={};function i(e){let n=e.index;if(e.referencedExtensionPoint){n+=i(e.referencedExtensionPoint)}return n}t.applyChange=async function(t,o,a){const r=a.view;const s=a.modifier;const d=a.viewId||s.getId(r);const f=t.getSelector();const c=t.getExtensionPointInfo&&t.getExtensionPointInfo()||await s.getExtensionPointInfo(f.name,r);if(!c){throw new Error(`AddXMLAtExtensionPoint-Error: Either no Extension-Point found by name '${f&&f.name}' or multiple Extension-Points available with the given name in the view (view.id='${d}'). Multiple Extension-points with the same name in one view are not supported!`)}(c.defaultContent||[]).forEach(function(e){if(e){s.destroy(e)}});c.defaultContent=[];c.index=i(c);if(s.targets==="xmlTree"){c.skipAdjustIndex=true}const l=await n.applyChange(t,o,a,c);if(c.ready){c.ready(l)}e.addCreatedControlsToExtensionPointInfo({name:f.name,viewId:d,createdControlsIds:l.map(e=>s.getId(e))})};t.revertChange=n.revertChange;t.completeChangeContent=function(e,t){n.completeChangeContent(e,t)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/Base", ["sap/base/util/LoaderExtensions"],function(t){"use strict";const e={setTextInChange(t,e,n,o){t.texts||={};t.texts[e]||={};t.texts[e].value=n;t.texts[e].type=o},async instantiateFragment(e,n){const o=e.getFlexObjectMetadata();const s=o.moduleName;if(!s){return Promise.reject(new Error("The module name of the fragment is not set. This should happen in the backend"))}const a=n.viewId?`${n.viewId}--`:"";const i=o.projectId||"";const r=e.getExtensionPointInfo&&e.getExtensionPointInfo()&&e.getExtensionPointInfo().fragmentId||"";const c=i&&r?".":"";const d=a+i+c+r;const m=n.modifier;const u=n.view;const g=t.loadResource(s,{dataType:"text"});try{return await m.instantiateFragment(g,d,u)}catch(t){throw new Error(`The following XML Fragment could not be instantiated: ${g} Reason: ${t.message}`)}},markAsNotApplicable(t,e){const n={message:t};if(!e){throw n}return Promise.reject(n)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseAddViaDelegate", ["sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/Base","sap/ui/fl/requireAsync","sap/base/util/merge","sap/base/util/ObjectPath"],function(e,t,n,o,r){"use strict";function a(e){return typeof e==="function"}const i={createAddViaDelegateChangeHandler(i){function c(e){return e+i.fieldSuffix}function l(e,t){if(a(i[t])){return!!i[t](e)}return!!i[t]}function d(e){return l(e,"skipCreateLabel")}function s(e){return l(e,"skipCreateLayout")}async function f(e,t){const o=t.modifier.bySelector(e.getSelector(),t.appComponent);const r=await n("sap/ui/fl/apply/api/DelegateMediatorAPI");const i=await r.getWriteDelegateForControl({control:o,modifier:t.modifier});const c=!a(i.instance.createLayout);return c||s(e.getSupportInformation().oDataInformation)}async function g(e,t,n){const r=o({},t);r.fieldSelector.id=c(r.fieldSelector.id);const a=await n.createControlForProperty(r);if(d(e)){return a}const i=t.modifier.getId(a.control);t.labelFor=i;const l=await n.createLabel(t);return{label:l,control:a.control,valueHelp:a.valueHelp}}async function p(e,t,n,c){if(!t){return undefined}const l=o({aggregationName:i.aggregationName,payload:t.payload||{},parentSelector:e.parentId},n);const d=t.instance;let f;if(a(d.createLayout)&&!s(c)){f=await d.createLayout(l)}if(r.get("control",f)){f.layoutControl=true;return f}return g(c,l,d)}return{async applyChange(e,r,a){const c=a.appComponent;const l=e.getContent();const d=e.getSupportInformation().oDataInformation;const s=l.newFieldSelector;const f={appComponent:a.appComponent,view:a.view,fieldSelector:s,bindingPath:l.bindingPath,modifier:a.modifier,element:r};if(a.modifier.bySelector(s,c,a.view)){await t.markAsNotApplicable(`Control to be created already exists:${s.id||s}`,true);return}const g={newFieldSelector:s};e.setRevertData(g);const u=await n("sap/ui/fl/apply/api/DelegateMediatorAPI");const C=await u.getWriteDelegateForControl({control:r,modifier:a.modifier});if(!C){t.markAsNotApplicable(`No delegate found for control ${a.modifier.getId(r)}`,false)}const m=await p(l,C,f,d);const w=o({},{control:r,innerControls:m,change:e},a);await i.addProperty(w);if(m.valueHelp){const t=a.modifier.getSelector(a.modifier.getId(m.valueHelp),c);const n=e.getRevertData();n.valueHelpSelector=t;e.setRevertData(n)}if(m.layoutControl){const t=e.getRevertData();t.newFieldSelector=a.modifier.getSelector(a.modifier.getId(m.control),c);e.setRevertData(t)}},async revertChange(e,t,n){const r=n.appComponent;const c=n.modifier;const l=e.getRevertData().newFieldSelector;const d=e.getRevertData().valueHelpSelector;const s=c.bySelector(l,r);const f=e.getDependentControl(i.parentAlias,n)||t;await c.removeAggregation(f,i.aggregationName,s);await c.destroy(s);if(d){const e=c.bySelector(d,r);await c.removeAggregation(f,"dependents",e);await c.destroy(e)}const g=o({},{control:t,change:e},n);if(a(i.revertAdditionalControls)){await i.revertAdditionalControls(g);e.resetRevertData()}},completeChangeContent(e,t,n){const o=n.appComponent;const r=t.content||t;const c={};if(r.parentId){if(a(i.mapParentIdIntoChange)){i.mapParentIdIntoChange(e,r,n)}else{e.addDependentControl(r.parentId,i.parentAlias,n)}try{c.parentId=n.modifier.getSelector(r.parentId,o)}catch(e){}}else{throw new Error("mSpecificChangeInfo.content.parentId attribute required")}if(r.bindingPath){c.bindingPath=r.bindingPath}else{throw new Error("mSpecificChangeInfo.content.bindingPath attribute required")}if(r.newControlId){c.newFieldSelector=n.modifier.getSelector(r.newControlId,o)}else{throw new Error("mSpecificChangeInfo.content.newControlId attribute required")}if(r.index===undefined){throw new Error("mSpecificChangeInfo.content.targetIndex attribute required")}else{c.newFieldIndex=r.index}if(r.oDataServiceVersion){c.oDataServiceVersion=r.oDataServiceVersion}e.setContent(c)},getChangeVisualizationInfo(e){const t=e.getRevertData();if(t&&t.labelSelector){return{affectedControls:[t.labelSelector]}}return{affectedControls:[e.getContent().newFieldSelector]}},async getCondenserInfo(t,n){const o=await f(t,n);if(!o){return undefined}if(!t.getContent().newFieldSelector||!t.getContent().parentId||!i.aggregationName){return undefined}return{affectedControl:t.getContent().newFieldSelector,classification:e.Create,targetContainer:t.getContent().parentId,targetAggregation:i.aggregationName,setTargetIndex(e,t){const n=e.getContent();n.newFieldIndex=t;e.setContent(n)},getTargetIndex(e){return e.getContent().newFieldIndex}}}}}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseAddXml", ["sap/ui/fl/changeHandler/Base","sap/base/util/LoaderExtensions","sap/ui/fl/changeHandler/common/revertAddedControls"],function(t,e,n){"use strict";const a={};a.applyChange=async function(n,o,r,i){const s=r.modifier;const g=i.aggregationName;const c=n.getFlexObjectMetadata().moduleName;const f=await s.findAggregation(o,g);if(!f){throw Error(`The given Aggregation is not available in the given control: ${s.getId(o)}`)}const d=await e.loadResource(c,{dataType:"text"});const h=await t.instantiateFragment(n,r);let l=0;for(const t of h){const e=await s.validateType(t,f,o,d,l);l++;if(!e){a._destroyArrayOfControls(h);throw Error(`The content of the xml fragment does not match the type of the targetAggregation: ${f.type}`)}}const m=[];let u=0;for(const t of h){await s.insertAggregation(o,g,t,i.index+u,r.view,i.skipAdjustIndex);u++;m.push({id:s.getId(t),aggregationName:g})}n.setRevertData(m);return h};a.revertChange=n;a._throwMissingAttributeError=function(t){throw new Error(`Attribute missing from the change specific content '${t}'`)};a._destroyArrayOfControls=function(t){t.forEach(function(t){if(t.destroy){t.destroy()}})};a.completeChangeContent=function(t,e,n){n||={};const o=e.content||e;if(!o.fragmentPath){a._throwMissingAttributeError("fragmentPath")}n.fragmentPath??=o.fragmentPath;t.setContent(n);let r=t.getFlexObjectMetadata().reference.replace(/\.Component/g,"").replace(/\./g,"/");r+="/changes/";r+=n.fragmentPath;const i=t.getFlexObjectMetadata();i.moduleName=r;t.setFlexObjectMetadata(i)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseRename", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";const t={createRenameChangeHandler(t){t.changePropertyName||="newText";return{async applyChange(e,r,n){const o=n.modifier;const a=t.propertyName;const i=e.getText(t.changePropertyName);if(i){const t=await o.getPropertyBindingOrProperty(r,a);e.setRevertData(t);await o.setPropertyBindingOrProperty(r,a,i)}},revertChange(e,r,n){const o=n.modifier;const a=t.propertyName;const i=e.getRevertData();if(i||i===""){o.setPropertyBindingOrProperty(r,a,i);e.resetRevertData();return}throw new Error("Change without sufficient information to be reverted. It probably didn't go through applyChange.")},async completeChangeContent(e,r,n){const o=t.changePropertyName;const a=t.translationTextType;const i=await n.modifier.bySelector(e.getSelector(),n.appComponent);e.setContent({originalControlType:n.modifier.getControlType(i)});const s=r.content||r;if(typeof s.value==="string"){e.setText(o,s.value,a)}else{throw new Error("oSpecificChangeInfo.value attribute required")}},getCondenserInfo(r){return{affectedControl:r.getSelector(),classification:e.LastOneWins,uniqueKey:t.propertyName||t.changePropertyName}},getChangeVisualizationInfo(e){const r=e.getTexts()&&e.getTexts()[t.changePropertyName];return{descriptionPayload:{originalLabel:e.getRevertData(),newLabel:r&&r.value}}}}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/ChangeAnnotation", ["sap/ui/fl/changeHandler/condenser/Classification"],function(t){"use strict";const n={};n.applyChange=function(t){const n=t.getContent();const e={path:n.annotationPath};const o=t.getText("annotationText")||n.value;const a=n.objectTemplateInfo;if(a){e.value=JSON.parse(a.templateAsString.replace(a.placeholder,o))}else{e.value=o}return e};n.revertChange=function(){};n.completeChangeContent=function(t,n){const e={annotationPath:n.content.annotationPath};if(n.content.objectTemplateInfo){e.objectTemplateInfo=n.content.objectTemplateInfo}if(n.content.text){t.setText("annotationText",n.content.text)}else{e.value=n.content.value}t.setContent(e)};n.getCondenserInfo=function(n,e){return{affectedControl:e.appComponent,classification:t.LastOneWins,uniqueKey:`${n.getContent().annotationPath}_${n.getChangeType()}`}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/HideControl", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t,n){"use strict";const i="visible";const o={};o.applyChange=async function(e,t,n){const i=n.modifier;const o=await i.getVisible(t);e.setRevertData({originalValue:o});i.setVisible(t,false)};o.revertChange=function(t,n,i){const o=t.getRevertData();if(o){i.modifier.setVisible(n,o.originalValue);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}};o.completeChangeContent=function(){};o.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.Reverse,uniqueKey:i}};o.getChangeVisualizationInfo=function(e,t){const i=e.getSelector();const o=n.bySelector(i,t);const r={affectedControls:[i],updateRequired:true};function a(e){if(!e){return null}if(e.getVisible?.()){return e}return a(e.getParent())}const s=a(o);if(s){r.displayControls=[s.getId()]}return r};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/MoveControls", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";const o={};o.SOURCE_ALIAS="source";o.TARGET_ALIAS="target";o.MOVED_ELEMENTS_ALIAS="movedElements";function r(e,t,o,r){if(!e){throw new Error("No change instance")}const n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!n.source||!n.source.selector){throw new Error("No source supplied for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.source.selector,r,o)){throw new Error("Move source parent not found")}if(!t.bySelector(n.target.selector,r,o)){throw new Error("Move target parent not found")}if(!n.source.selector.aggregation){throw new Error("No source aggregation supplied for move")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function n(e,t,o,r){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}const n=await t.bySelector(e.selector||e.id,o,r);if(!n){throw new Error(`Control to move was not found. Id: '${e.selector.id}'`)}return n}function a(e){if(!e.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required")}if(e.movedElements.length===0){throw new Error("MovedElements array is empty")}e.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute")}if(typeof e.sourceIndex!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number")}if(typeof e.targetIndex!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number")}})}async function s(e,t,o){delete t.source.publicAggregation;delete t.target.publicAggregation;const r=t.source.parent||await e.bySelector(t.source.id,o);const n=t.target.parent||await e.bySelector(t.target.id,o);const a=t.source.aggregation;const s=t.target.aggregation;const g={aggregation:t.source.aggregation,type:e.getControlType(r)};const c={aggregation:t.target.aggregation,type:e.getControlType(n)};const i={source:{id:r.getId(),aggregation:a,type:g.type,selector:e.getSelector(t.source.id,o,g)},target:{id:n.getId(),aggregation:s,type:c.type,selector:e.getSelector(t.target.id,o,c)},movedElements:t.movedElements};return i}o.applyChange=async function(e,t,o){const a=o.modifier;const s=o.view;const g=o.appComponent;const c=e.getContent();const i=[];let l=false;r(e,a,s,g);for(const e of c.movedElements){const t=await n(e,a,g,s);let r=a.getParent(t);let d=o.sourceAggregation||await a.getParentAggregationName(t,r);const u=await a.bySelector(c.target.selector,g,s);const m=o.targetAggregation||c.target.selector.aggregation;let f=await a.findIndexInParentAggregation(t);const E=e.targetIndex;if(f>-1){if(f===E&&d===m&&a.getParent(t)===u){f=e.sourceIndex;d=o.sourceAggregation||c.source.selector.aggregation;l=true;r=await a.bySelector(c.source.selector,g,s)||r}}if(f>-1){i.unshift({index:f,aggregation:d,sourceParent:a.getSelector(r,g)})}if(!l){await a.moveAggregation(r,d,u,m,t,E,s)}}e.setRevertData(i)};o.revertChange=async function(e,t,o){const a=o.modifier;const s=o.view;const g=o.appComponent;const c=e.getContent();r(e,a,s,g);let i=await a.bySelector(c.source.selector,g,s);const l=await a.bySelector(c.target.selector,g,s);let d=c.source.selector.aggregation;const u=c.target.selector.aggregation;const m=e.getRevertData();c.movedElements.reverse();let f=0;for(const e of c.movedElements){const t=await n(e,a,g,s);if(!t){throw new Error("Element to move not found")}let o=e.sourceIndex;if(m){const e=m[f];d=e.aggregation;o=e.index;i=await a.bySelector(e.sourceParent,g,s)||i}await a.moveAggregation(l,u,i,d,t,o,s);f++}e.resetRevertData()};o.completeChangeContent=async function(e,t,r){const n=r.modifier;const g=r.appComponent;const c=t.content||t;a(c);const i=await s(n,c,g);const l={movedElements:[],source:{selector:i.source.selector},target:{selector:i.target.selector}};for(const t of i.movedElements){const a=t.element||await n.bySelector(t.id,g);l.movedElements.push({selector:n.getSelector(a,g),sourceIndex:t.sourceIndex,targetIndex:t.targetIndex});e.addDependentControl(i.source.id,o.SOURCE_ALIAS,r);e.addDependentControl(i.target.id,o.TARGET_ALIAS,r);e.addDependentControl(i.movedElements.map(function(e){return e.id}),o.MOVED_ELEMENTS_ALIAS,r)}e.setContent(l)};o.getCondenserInfo=function(e){const o=e.getContent();const r=e.getRevertData()[0];return{affectedControl:o.movedElements[0].selector,classification:t.Move,sourceContainer:r.sourceParent,targetContainer:o.target.selector,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:o.target.selector.aggregation,setTargetIndex(e,t){const o=e.getContent();o.movedElements[0].targetIndex=t;e.setContent(o)},getTargetIndex(e){return e.getContent().movedElements[0].targetIndex},setIndexInRevertData(e,t){const o=e.getRevertData();o[0].index=t;e.setRevertData(o)}}};o.getChangeVisualizationInfo=function(e){const t=e.getContent();const o=e.getRevertData()[0];return{affectedControls:[t.movedElements[0].selector],dependentControls:[t.source.selector],descriptionPayload:{sourceContainer:o.sourceParent,targetContainer:t.target.selector}}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/MoveElements", [],function(){"use strict";var e={};e.CHANGE_TYPE="moveElements";function t(e,t,r,o){if(!e){throw new Error("No change instance")}var n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!e.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.target.selector,o,r)){throw new Error("Move target parent not found")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function r(e,t,r,o){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}return await t.bySelector(e.selector||e.id,r,o)}e.applyChange=async function(e,o,n){var a=n.modifier;var g=n.view;var i=n.appComponent;var s=e.getContent();t(e,a,g,i);const c=e.getSelector().aggregation;const l=s.target.selector.aggregation;const d=await a.bySelector(s.target.selector,i,g);for(const e of s.movedElements){const t=await r(e,a,i,g);if(!t){throw new Error("Element to move not found")}await a.moveAggregation(o,c,d,l,t,e.targetIndex,g)}};e.completeChangeContent=function(){throw new Error("Using deprecated change handler. Please consider using 'MoveControls' instead")};e.getSpecificChangeInfo=function(e,t){var r=t.source.parent||e.bySelector(t.source.id);var o=t.target.parent||e.bySelector(t.target.id);var n=t.source.aggregation;var a=t.target.aggregation;var g={source:{id:r.getId(),aggregation:n,type:e.getControlType(r)},target:{id:o.getId(),aggregation:a,type:e.getControlType(o)},movedElements:t.movedElements};return g};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/PropertyBindingChange", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var n={};n.applyChange=function(e,t,n){var r=e.getContent();var i=r.property;var o=r.newBinding;var a=n.modifier;return Promise.resolve().then(a.getPropertyBindingOrProperty.bind(a,t,i)).then(function(n){e.setRevertData({originalValue:n});a.setPropertyBinding(t,i,o)})};n.revertChange=function(t,n,r){var i=t.getRevertData();if(i){var o=t.getContent();var a=o.property;var s=i.originalValue;var p=r.modifier;p.setPropertyBindingOrProperty(n,a,s);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}};n.completeChangeContent=function(e,t){if(!t.content){throw new Error("oSpecificChangeInfo attribute required")}e.setContent(t.content)};n.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.LastOneWins,uniqueKey:e.getContent().property}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/PropertyChange", ["sap/ui/fl/Utils","sap/ui/fl/changeHandler/condenser/Classification","sap/base/Log","sap/base/util/isPlainObject"],function(e,t,n,r){"use strict";var i={};function a(t){return e.isBinding(t)||r(t)}function o(e,t,n,r){try{if(a(n)){r.setPropertyBinding(e,t,n)}else{r.setProperty(e,t,n)}}catch(e){throw new Error(`Applying property changes failed: ${e}`)}}i.applyChange=function(e,t,n){var r=e.getContent();var i=r.property;var a=r.newValue;var s=n.modifier;return Promise.resolve().then(s.getPropertyBindingOrProperty.bind(s,t,i)).then(function(n){e.setRevertData({originalValue:n});o(t,i,a,s)})};i.revertChange=function(e,t,r){var i=e.getRevertData();if(i){var a=e.getContent();var s=a.property;var c=i.originalValue;var p=r.modifier;o(t,s,c,p);e.resetRevertData()}else{n.error("Attempt to revert an unapplied change.")}};i.completeChangeContent=function(e,t){if(!t.content){throw new Error("oSpecificChangeInfo attribute required")}e.setContent(t.content)};i.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.LastOneWins,uniqueKey:e.getContent().property}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/StashControl", ["sap/ui/fl/LayerUtils","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t,n){"use strict";const a={};a.applyChange=async function(t,n,a){const i=a.modifier;const o=await i.getStashed(n);const r=await i.findIndexInParentAggregation(n);this.setChangeRevertData(t,o,r);if(e.isDeveloperLayer(t.getLayer())){return i.setStashed(n,true)}return i.setVisible(n,false)};a.revertChange=async function(t,n,a){const i=t.getRevertData();const o=a.modifier;if(e.isDeveloperLayer(t.getLayer())){const e=await o.setStashed(n,i.originalValue,a.appComponent);if(e){const t=await o.findIndexInParentAggregation(e);if(t!==i.originalIndex){const t=o.getParent(e);const n=await o.getParentAggregationName(e);await o.moveAggregation(t,n,t,n,e,i.originalIndex)}}}o.setVisible(n,!i.originalValue);t.resetRevertData()};a.completeChangeContent=function(){};a.setChangeRevertData=function(e,t,n){e.setRevertData({originalValue:t,originalIndex:n})};a.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.Reverse,uniqueKey:"stashed"}};a.getChangeVisualizationInfo=function(e,t){const a=e.getSelector();const i=n.bySelector(a,t);return{affectedControls:[a],displayControls:[i.getParent().getId()]}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UnhideControl", ["sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n){"use strict";const i="visible";const r={};r.applyChange=async function(e,t,n){const r=n.modifier;const o=await r.getProperty(t,i);e.setRevertData({originalValue:o});n.modifier.setVisible(t,true)};r.revertChange=function(t,n,i){const r=t.getRevertData();if(r){i.modifier.setVisible(n,r.originalValue);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}};r.completeChangeContent=function(){};r.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:n.Reverse,uniqueKey:i}};r.getChangeVisualizationInfo=function(e,n){const i=e.getSelector();const r=t.bySelector(i,n);const o={updateRequired:true};function a(e){if(!e){return null}if(e.getVisible?.()){return e}return a(e.getParent())}if(!r.getVisible()){const e=a(r.getParent());if(e){o.displayControls=[e.getId()]}}return o};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UnstashControl", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";const t={};t.applyChange=async function(e,t,n){const a=e.getContent();const o=n.modifier;const i=await o.getStashed(t);e.setRevertData({originalValue:i});const s=await o.setStashed(t,false,n.appComponent)||t;if(a.parentAggregationName){const e=a.parentAggregationName;const t=o.getParent(s);await o.moveAggregation(t,e,t,e,s,a.index,n.view)}return s};t.revertChange=async function(e,t,n){const a=e.getRevertData();await n.modifier.setStashed(t,a.originalValue);e.resetRevertData()};t.completeChangeContent=function(e,t){if(t.content){e.setContent(t.content)}};t.getCondenserInfo=function(t){return{affectedControl:t.getSelector(),classification:e.Reverse,uniqueKey:"stashed"}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UpdateIFrame", ["sap/base/util/extend","sap/ui/fl/changeHandler/condenser/Classification"],function(t,e){"use strict";const n={};const i=["width","height","url","_settings","advancedSettings"];async function r(t,e){const n={};for(const r of i){const i=await t.getProperty(e,r);n[r]=i}return n}function o(e,n,i){const r=t({_settings:i},i);return e.applySettings(n,r)}n.applyChange=async function(t,e,n){const i=n.modifier;const a=await i.getControlMetadata(e);if(a.getName()!=="sap.ui.fl.util.IFrame"){throw Error("UpdateIFrame only for sap.ui.fl.util.IFrame")}const s=await r(i,e);t.setRevertData({originalSettings:s});return o(i,e,t.getContent())};n.revertChange=async function(t,e,n){const i=t.getRevertData();if(i){if(i.originalSettings._settings&&i.originalSettings._settings.url){i.originalSettings.url=i.originalSettings._settings.url}await o(n.modifier,e,i.originalSettings);t.resetRevertData()}else{throw Error("Attempt to revert an unapplied change.")}};n.completeChangeContent=function(t,e){if(!e.content||!Object.keys(e.content).some(function(t){return i.indexOf(t)!==-1})){throw new Error("oSpecificChangeInfo attribute required")}t.setContent(e.content)};n.getCondenserInfo=function(t){return{classification:e.Update,affectedControl:t.getSelector(),uniqueKey:"iFrame",updateContent:t.getContent()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/ChangeCategories", [],function(){"use strict";return{ADD:"add",MOVE:"move",RENAME:"rename",COMBINESPLIT:"combinesplit",REMOVE:"remove",OTHER:"other"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/createIFrame", ["sap/ui/fl/util/IFrame"],function(){"use strict";return function(t,n,e,i){const s=n.modifier;const a=t.getContent();const o=n.view;const c=n.appComponent;const r={_settings:{}};["url","width","height"].forEach(function(t){const n=a[t];r[t]=n;r._settings[t]=n});if(a?.advancedSettings){r.advancedSettings=a.advancedSettings;r._settings.advancedSettings=a?.advancedSettings}if(i){r.renameInfo=i;r.asContainer=true}return s.createControl("sap.ui.fl.util.IFrame",c,o,e,r,false)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/getTargetAggregationIndex", [],function(){"use strict";return async function(n,t,e){const i=e.modifier;const o=n.getContent();const r=o.targetAggregation;const g=o.index;if(g===undefined){const n=await i.getAggregation(t,r);return n.length}return g}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/revertAddedControls", ["sap/ui/fl/Utils"],function(e){"use strict";return async function(t,o,n){const r=n.modifier;let i=t.getContent().targetAggregation;const a=n.view||e.getViewForControl(o);const s=n.appComponent;const c=t.getRevertData()||[];for(const e of c){let t;if(typeof e==="string"){t=e}else{t=e.id;i||=e.aggregationName}const n=r.bySelector(t,s,a)||a?.createId&&r.bySelector(a.createId(t));if(n.destroy){n.destroy()}await r.removeAggregation(o,i,n)}t.resetRevertData()}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/condenser/Classification", [],function(){"use strict";return{LastOneWins:"lastOneWins",Reverse:"reverse",Move:"move",Create:"create",Destroy:"destroy",Update:"update"}});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/FlexConfiguration", ["sap/base/config"],e=>{"use strict";const i=e.getWritableInstance();const t={getFlexibilityServices(){const e=[{url:"/sap/bc/lrep",connector:"LrepConnector"}];const t=i.get({name:"sapUiFlexibilityServices",type:i=>{if(typeof i==="string"){if(i===""){return[]}if(i[0]==="/"){e[0].url=i;i=e}else{i=JSON.parse(i)}}return i||[]},defaultValue:e,external:false});return t},setFlexibilityServices(e){i.set("sapUiFlexibilityServices",e.slice())}};return t});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/FlexInfoSession", [],()=>{"use strict";var e={};var n="sap.ui.fl.info.";function t(e){return n+(e||"true")}e.getByReference=function(e){return JSON.parse(window.sessionStorage.getItem(t(e)))||{}};e.setByReference=function(e,n){if(e){window.sessionStorage.setItem(t(n),JSON.stringify(e))}};e.removeByReference=function(e){window.sessionStorage.removeItem(t(e))};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/Storage", ["sap/base/util/restricted/_merge","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/_internal/storageResultDisassemble","sap/ui/fl/initial/_internal/StorageFeaturesMerger","sap/ui/fl/initial/_internal/StorageResultMerger","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Layer"],function(e,n,t,r,a,o,s){"use strict";function i(e,t){const r=t.map(function(t){const r={...e,url:t.url,path:t.path};const a=n.getByReference(e.reference);if(!t.layers||t.layers[0]!=="ALL"&&t.layers.indexOf(s.CUSTOMER)===-1){delete r.version}else{if(a.initialAllContexts){r.allContexts=true}if(!r.version&&a.version){r.version=a.version}}const i=!!Object.keys(window.sessionStorage).filter(e=>e.startsWith("sap.ui.rta.restart.")).length;if(!i&&!a.saveChangeKeepSession){n.removeByReference(e.reference)}if(r.version){delete r.cacheKey}return t.loadConnectorModule.loadFlexData(r).then(function(e){return e||o.getEmptyFlexDataResponse()}).catch(o.logAndResolveDefault.bind(undefined,o.getEmptyFlexDataResponse(),t,"loadFlexData"))});return Promise.all(r)}function l(e){var n=[];e.forEach(function(e){if(Array.isArray(e)){n=n.concat(e)}else{n.push(e)}});return n}function u(e){return e.map(function(e){return t(e)})}function c(e){return Promise.resolve(e).then(l).then(u).then(l).then(a.merge)}function f(e){return o.getStaticFileConnector().then(i.bind(this,e))}function d(e){var n=e.map(function(e){if(!e?.loadConnectorModule?.loadFeatures){return Promise.resolve(o.logAndResolveDefault({features:{},layers:e.layers},e,"loadFeatures"))}return e.loadConnectorModule.loadFeatures({url:e.url}).then(function(n){return{features:n,layers:e.layers}}).catch(o.logAndResolveDefault.bind(null,{features:{},layers:e.layers},e,"loadFeatures"))});return Promise.all(n)}async function h(n,t){const r=await Promise.all(t.map(function(e){if(!e?.loadConnectorModule?.loadVariantsAuthors){return Promise.resolve(o.logAndResolveDefault({},e,"loadVariantsAuthors"))}const t={reference:n,url:e.url};return e.loadConnectorModule.loadVariantsAuthors(t).then(e=>e||{}).catch(o.logAndResolveDefault.bind(undefined,{},e,"loadVariantsAuthors"))}));return e({},...r)}var p={};p.loadFeatures=function(){return o.getLoadConnectors().then(d).then(r.mergeResults)};p.completeFlexData=function(e){if(!e||!e.reference){return Promise.reject("No reference was provided")}return Promise.all([f(e),e.partialFlexData]).then(c)};p.loadFlexData=function(e){if(!e||!e.reference){return Promise.reject("No reference was provided")}return o.getLoadConnectors().then(i.bind(this,e)).then(c)};p.loadVariantsAuthors=function(e){if(!e){return Promise.reject("No reference was provided")}return o.getLoadConnectors().then(h.bind(this,e))};p.loadFlVariant=async function(e){const n=await o.getLoadConnectors();const t=[];for(const r of n){if(r?.loadConnectorModule?.loadFlVariant){const n={...e,url:r.url,layers:r.layers};try{t.push(await r.loadConnectorModule.loadFlVariant(n))}catch(e){t.push({})}}}const r=["variants","variantChanges","variantDependentControlChanges"];return t.reduce((e,n)=>{r.forEach(t=>{if(n[t]){e[t]=[...e[t]||[],...n[t]]}});return e},{})};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/StorageFeaturesMerger", ["sap/base/util/merge","sap/ui/fl/Layer"],function(e,a){"use strict";var i={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isPublicFlVariantEnabled:false,isVariantPersonalizationEnabled:true,isContextSharingEnabled:true,isAtoAvailable:false,isAtoEnabled:false,versioning:{},isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isZeroDowntimeUpgradeRunning:false,isVariantAuthorNameAvailable:false,system:"",client:""};function n(e){var i={};var n=!!e.features.isVersioningEnabled;if(e?.layers&&(e.layers.includes(a.CUSTOMER)||e.layers.includes("ALL"))){i[a.CUSTOMER]=n}return i}return{mergeResults(a){var s=i;a.forEach(function(a){Object.keys(a.features).forEach(function(e){if(e!=="isVersioningEnabled"){s[e]=a.features[e]}});s.versioning=e(s.versioning,n(a));if(a.isContextSharingEnabled!==undefined){s.isContextSharingEnabled=a.isContextSharingEnabled}});return s}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/StorageResultMerger", ["sap/base/util/merge","sap/base/util/ObjectPath"],function(n,a){"use strict";var e={};function t(n,e){var t=n.reduce(function(n,t){if(a.get(e,t)){return n.concat(a.get(e,t))}return n},[]);var r=[];return t.filter(function(n){var a=n.fileName;var e=r.indexOf(a)!==-1;if(e){return false}r.push(a);return true})}function r(a){return a.reduce(function(a,e){return n({},a,e.ui2personalization)},{})}function i(n){return n.reduce(function(n,a){return a.cacheKey?n+=a.cacheKey:n},"")||null}e.merge=function(n){var a={appDescriptorChanges:t(n,"appDescriptorChanges"),annotationChanges:t(n,"annotationChanges"),changes:t(n,"changes"),ui2personalization:r(n),comp:{variants:t(n,"comp.variants"),changes:t(n,"comp.changes"),defaultVariants:t(n,"comp.defaultVariants"),standardVariants:t(n,"comp.standardVariants")},variants:t(n,"variants"),variantChanges:t(n,"variantChanges"),variantDependentControlChanges:t(n,"variantDependentControlChanges"),variantManagementChanges:t(n,"variantManagementChanges"),cacheKey:i(n)};var e=t(n,"info");if(e.length>0){[a.info]=e}return a};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/StorageUtils", ["sap/base/Log","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/isEmptyObject"],function(n,e,t,r,a){"use strict";const o={};var i={load:{LrepConnector:"sap/ui/fl/initial/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/initial/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/initial/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/initial/_internal/connectors/KeyUserConnector",BtpServiceConnector:"sap/ui/fl/initial/_internal/connectors/BtpServiceConnector",StaticFileConnector:"sap/ui/fl/initial/_internal/connectors/StaticFileConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"},write:{LrepConnector:"sap/ui/fl/write/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/write/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/write/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/write/_internal/connectors/KeyUserConnector",BtpServiceConnector:"sap/ui/fl/write/_internal/connectors/BtpServiceConnector",StaticFileConnector:"sap/ui/fl/write/_internal/connectors/StaticFileConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"}};var c="sap/ui/fl/initial/_internal/connectors/";var s={connector:"StaticFileConnector"};function l(n,e){var t=[];if(!n){t=e}else{t=n.filter(function(n){return e.indexOf(n)!==-1||e[0]==="ALL"})}return t}function p(n,e,t){return t.map(function(n){var t=n.connector;var r;if(!n.loadConnector&&!n.applyConnector&&!n.loadConnector){r=e?i.load[t]:i.write[t]}else if(e){r=n.loadConnector||n.applyConnector}else{r=n.writeConnector||"sap/ui/fl/write/connectors/BaseConnector"}return r})}o.requireConnectors=function(n){return new Promise(function(e){sap.ui.require(n,function(...n){e(n)})})};async function u(n,e,t){var r=p(n,e,t);const a=await o.requireConnectors(r,e,t);a.forEach(function(n,r){if(!t[r].layers){t[r].layers=n.layers}else{t[r].layers=l(t[r].layers,n.layers)}if(e){t[r].loadConnectorModule=n}else{t[r].writeConnectorModule=n}});return t}o.getConnectors=function(n,t){var r=e.getFlexibilityServices();var a=[];if(t){a=[s]}a=a.concat(r);return u(n,t,a)};o.getLoadConnectors=function(){return this.getConnectors(c,true)};o.getStaticFileConnector=function(){return u(c,true,[s])};o.logAndResolveDefault=function(e,t,r,a){n.error(`Connector (${t.connector}) failed call '${r}': ${a}\n\t\t\tApplication startup continues without data from this storage.`);return e};o.filterAndSortResponses=function(n){var e=[];Object.keys(n).forEach(function(t){e.push(n[t])});e=e.filter(function(n){return n.changes.length>0||n.appDescriptorChanges.length>0||n.variants.length>0||n.variantChanges.length>0||n.variantManagementChanges.length>0||n.variantDependentControlChanges.length>0||n.comp.variants.length>0||n.comp.changes.length>0||n.comp.defaultVariants.length>0||n.comp.standardVariants.length>0||n.annotationChanges.length>0});e.sort(function(n,e){return n.index-e.index});return e};o.sortFlexObjects=function(n){const e=n.filter(n=>n.creation);const t=n.filter(n=>!n.creation);e.sort(function(n,e){return Date.parse(n.creation)-Date.parse(e.creation)});return t.concat(e)};o.getGroupedFlexObjects=function(n){const e=this.sortFlexObjects(n);var a={};Object.keys(t).forEach(function(n){a[n]=this.getEmptyFlexDataResponse();a[n].index=r.getLayerIndex(n)}.bind(this));e.forEach(function(n){var e=n.layer;if(n.fileType==="annotation_change"){a[e].annotationChanges.push(n)}else if(n.fileType==="ctrl_variant"&&n.variantManagementReference){a[e].variants.push(n)}else if(n.fileType==="ctrl_variant_change"){a[e].variantChanges.push(n)}else if(n.fileType==="ctrl_variant_management_change"){a[e].variantManagementChanges.push(n)}else if(n.fileType==="variant"){a[e].comp.variants.push(n)}else if(n.fileType==="change"){if(n.variantReference){a[e].variantDependentControlChanges.push(n)}else if(n.appDescriptorChange){a[e].appDescriptorChanges.push(n)}else{switch(n.changeType){case"addFavorite":case"removeFavorite":case"updateVariant":a[e].comp.changes.push(n);break;case"defaultVariant":a[e].comp.defaultVariants.push(n);break;case"standardVariant":a[e].comp.standardVariants.push(n);break;default:a[e].changes.push(n)}}}});return a};o.getEmptyFlexDataResponse=function(){return{appDescriptorChanges:[],annotationChanges:[],changes:[],comp:{variants:[],changes:[],defaultVariants:[],standardVariants:[]},variants:[],variantChanges:[],variantDependentControlChanges:[],variantManagementChanges:[],ui2personalization:{}}};o.getAllFlexObjectNamespaces=function(){return["appDescriptorChanges","annotationChanges","changes","comp.changes","comp.changes","comp.defaultVariants","comp.standardVariants","variants","variantChanges","variantDependentControlChanges","variantManagementChanges"]};o.isStorageResponseFilled=function(n){return Object.keys(n||{}).some(function(e){if(Array.isArray(n[e])){return n[e].length!==0}return!a(n[e])})};return o});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration", ["sap/ui/core/Lib","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/changeHandler/AddXML","sap/ui/fl/changeHandler/AddXMLAtExtensionPoint","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/UnstashControl"],function(e,n,a,r,t,i,o,s,l,d,g,h){"use strict";var u={hideControl:t,moveElements:o,moveControls:i,stashControl:d,unhideControl:g,unstashControl:h};var f={addXML:a,addXMLAtExtensionPoint:r,propertyBindingChange:s,propertyChange:l};var c={};function C(e,n){c[e]=n;n.catch(function(){}).then(function(){delete c[e]})}function H(e){return n.registerChangeHandlersForLibrary(e)}function p(e){if(e.getParameter("operation")==="add"){var n=e.getParameter("metadata");var a=n.sName;var r=n&&n.extensions&&n.extensions.flChangeHandlers;if(r){var t=H(r);C(a,t)}}}var v={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs(){var n=e.all();e.attachLibraryChanged(p);var a=[];Object.values(n).forEach(function(e){if(e.extensions&&e.extensions.flChangeHandlers){a.push(H(e.extensions.flChangeHandlers))}});return Promise.all(a)},waitForChangeHandlerRegistration(e){if(c[e]){return c[e].catch(function(){})}return Promise.resolve()},registerPredefinedChangeHandlers(){n.registerPredefinedChangeHandlers(u,f)},registerAnnotationChangeHandler(e){n.registerAnnotationChangeHandler(e)},getAnnotationChangeHandler(e){return n.getAnnotationChangeHandler(e)}};return v});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage", ["sap/base/util/each","sap/base/util/ObjectPath","sap/base/Log","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/requireAsync"],function(e,n,r,t,a,o){"use strict";const i={};let l={};let s={};let c={};let u={};const f="defaultForAll";function g(e){if(!e.changeHandler){r.error("sap.ui.fl.registry.ChangeRegistryStorage: changeHandler required");return false}return true}async function h(e){if(typeof e.changeHandler==="string"){const n=await o(e.changeHandler.replace(/\./g,"/"));e.changeHandler=n}return e.changeHandler}function d(e,n){let r={};if(!n||!n.changeHandler){r.changeHandler=n}else{r=n}if(r.changeHandler==="default"){r.changeHandler=c.defaultChangeHandlers[e]}else if(Object.keys(c.developerChangeHandlers||{}).includes(e)){throw Error(`You can't use a custom change handler for the following Developer Mode change type: ${e}. Please use 'default' instead.`)}return r}function y(n){s={};e(n,function(e,n){const r={controlType:"defaultActiveForAll",changeHandler:n,layers:a.getDeveloperModeLayerPermissions(),changeType:e};s[e]=r})}function p(n,r,t){t=d(r,t);const o={...a.getDefaultLayerPermissions()};if(t.layers){e(t.layers,function(e,n){if(o[e]===undefined){throw Error(`The Layer '${e}' is not supported. Please only use supported layers`)}o[e]=n})}const i={controlType:n,changeHandler:t.changeHandler,layers:o,changeType:r};return g(i)?i:undefined}function C(e,n,r){const t=p(e,n,r);if(t){l[e]||={};l[e][n]=t}}function H(n,t){let a=Promise.resolve(t);const i="ChangeHandlerStorage.registerChangeHandlersForControl.skip_next_then";if(typeof t==="string"){a=o(`${t}.flexibility`).catch(function(e){r.error(`Flexibility change handler registration failed.\nControlType: ${n}\n${e.message}`);return Promise.resolve(i)})}return a.then(function(r){if(r!==i){e(r,function(e,r){C(n,e,r)})}}).catch(function(e){r.error(e.message)})}function m(e,n,r){const a=l[e]&&l[e][n]||s[n];if(!a){throw Error("No Change handler registered for the Control and Change type")}r=r===t.PUBLIC?t.USER:r;if(!a.layers[r]){throw Error(`Change type ${n} not enabled for layer ${r}`)}return a}function P(e,n,t,a){const i=a.getChangeHandlerModulePath(t);if(typeof i!=="string"){return Promise.resolve(undefined)}return o(i).then(function(r){const t=r[e];if(t){return p(n,e,t)}}).catch(function(e){r.error(`Flexibility registration for control ${a.getId(t)} failed to load module ${i}\n${e.message}`)})}i.getChangeHandler=function(e,n,r,t,a){return P(e,n,r,t).then(function(r){const t=r||m(n,e,a);return h(t)}).then(function(e){if(typeof e.completeChangeContent!=="function"||typeof e.applyChange!=="function"||typeof e.revertChange!=="function"){throw new Error("The ChangeHandler is either not available or does not have all required functions")}return e})};i.registerPredefinedChangeHandlers=function(e,n){c.defaultChangeHandlers=e;c.developerChangeHandlers=n;y(n)};i.registerChangeHandlersForLibrary=function(n){const r=[];e(n,function(e,n){r.push(H(e,n))});return Promise.all(r)};i.clearAll=function(){l={};s={};c={};u={}};i.registerChangeHandlersForControl=function(e,n){return H(e,n)};i.registerAnnotationChangeHandler=function(e){const n=e.isDefaultChangeHandler?f:e.changeType;u[n]={changeHandler:e.changeHandler}};i.getAnnotationChangeHandler=function(e){const n=u[e.changeType]||u[f];if(!n){throw Error("No Annotation Change handler registered for the Change type and Model type")}return h(n)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/BackendConnector", ["sap/base/util/merge","sap/base/util/restricted/_pick","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/interfaces/BaseLoadConnector"],function(e,t,n,s){"use strict";const i=e({},s,{xsrfToken:undefined,settings:undefined,sendRequest(e){var s=t(e,["version","allContexts"]);if(this.isLanguageInfoRequired){n.addLanguageInfo(s)}var i=n.getUrl(this.ROUTES.DATA,e,s);return n.sendRequest(i,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,cacheable:e.cacheable}).then(function(e){var t=e.response;if(e.etag){t.cacheKey=e.etag}if(t.settings){this.settings=t.settings}return t}.bind(this))},loadFeatures(e){if(this.settings){return Promise.resolve({response:this.settings})}var t=n.getUrl(this.ROUTES.SETTINGS,e);return n.sendRequest(t,"GET",{initialConnector:this}).then(function(e){return e.response})},loadFlexData(e){e.cacheable=true;return this.sendRequest(e).then(function(e){e.changes=e.changes.concat(e.compVariants||[]);return e})}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/BtpServiceConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/KeyUserConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/Layer"],function(n,e,t,i){"use strict";var a="/flex/all";var s="/v3";const r=`${a}${s}`;const o=n({},e,{layers:[i.CUSTOMER,i.PUBLIC,i.USER],ROOT:r,ROUTES:{DATA:`${r}/data`,VARIANTDATA:`${r}/variantdata`,SETTINGS:`${r}/settings`},loadFeatures(n){return e.loadFeatures.call(this,n).then(function(n){n.isCondensingEnabled=n.isCondensingEnabledOnBtp;delete n.isCondensingEnabledOnBtp;return n})},loadFlVariant(n){const e={id:n.variantReference,version:n.version};if(this.isLanguageInfoRequired){t.addLanguageInfo(e)}const i=t.getUrl(this.ROUTES.VARIANTDATA,n,e);return t.sendRequest(i,"GET",{initialConnector:this}).then(function(n){return n.response})}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/KeyUserConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(e,n,t){"use strict";var a="/flex/keyuser";var r="/v2";var s=e({},n,{layers:[t.CUSTOMER,t.PUBLIC],API_VERSION:r,ROUTES:{DATA:`${a+r}/data/`,SETTINGS:`${a+r}/settings`},isLanguageInfoRequired:true,loadFeatures(e){return n.loadFeatures.call(this,e).then(function(e){e.isContextSharingEnabled=true;return e})},loadFlexData(e){e.cacheable=true;return n.sendRequest.call(this,e).then(function(e){e.contents.map(function(e,n,t){t[n].changes=(e.changes||[]).concat(e.compVariants)});e.contents[0].cacheKey=e.cacheKey;return e.contents})}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/LrepConnector", ["sap/base/util/merge","sap/base/util/restricted/_pick","sap/ui/dom/includeScript","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/interfaces/BaseLoadConnector","sap/ui/fl/Utils"],function(e,t,s,i,n,a,r){"use strict";const o={DATA:"/flex/data/",MODULES:"/flex/modules/",SETTINGS:"/flex/settings",VARIANTS_AUTHORS:"/variants/authors/"};let l={};return e({},a,{layers:["ALL"],xsrfToken:undefined,settings:undefined,_loadModules(e){return new Promise(function(t,i){s(e,undefined,t,i)})},_addClientInfo(e){var t=r.getUrlParameter("sap-client");if(!e&&t){e={}}if(t){e["sap-client"]=t}},loadFeatures(e){if(this.settings){return Promise.resolve(this.settings)}var t={};this._addClientInfo(t);var s=i.getUrl(o.SETTINGS,e,t);return i.sendRequest(s,"GET",{initialConnector:this}).then(function(e){e.response.isVariantAdaptationEnabled=!!e.response.isPublicLayerAvailable;e.response.isContextSharingEnabled=true;e.response.isLocalResetEnabled=true;return e.response})},loadFlexData(e){if(e.cacheKey==="<NO CHANGES>"){return Promise.resolve({...n.getEmptyFlexDataResponse()})}var s=t(e,["version","allContexts","adaptationId"]);this._addClientInfo(s);i.addSAPLogonLanguageInfo(s);var a;if(e.appDescriptor&&e.appDescriptor["sap.app"]){a=e.appDescriptor["sap.app"].id}if(e.preview){e.reference=e.preview.reference;s.upToLayerType=e.preview.maxLayer}l=s;var r=i.getUrl(o.DATA,e,s);return i.sendRequest(r,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,siteId:e.siteId,cacheable:true,sAppDescriptorId:a}).then(function(t){var n=t.response;if(t.etag){n.cacheKey=t.etag}else if(e.cacheKey){n.cacheKey=e.cacheKey}n.changes=n.changes.concat(n.compVariants||[]);if(n.settings){this.settings=n.settings;this.settings.isVariantAdaptationEnabled=!!this.settings.isPublicLayerAvailable;this.settings.isContextSharingEnabled=true;this.settings.isLocalResetEnabled=true}if(!n.loadModules){return n}var a=i.getUrl(o.MODULES,e,s);return this._loadModules(a).then(function(){return n})}.bind(this))},loadVariantsAuthors(e){const t=i.getUrl(o.VARIANTS_AUTHORS,e,l);return i.sendRequest(t,"GET",{initialConnector:this}).then(function(e){return e.response})}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/NeoLrepConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils"],function(e,n,t){"use strict";var s={SETTINGS:"/flex/settings"};return e({},n,{loadFeatures(e){if(this.settings){return Promise.resolve(this.settings)}var n={};var i=t.getUrl(s.SETTINGS,e,n);return t.sendRequest(i,"GET",{initialConnector:this}).then(function(e){e.response.isContextSharingEnabled=false;e.response.isAnnotationChangeEnabled=false;return e.response})},loadVariantsAuthors(){return Promise.reject("loadVariantsAuthors is not implemented")}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/PersonalizationConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(e,r,a){"use strict";var t="/flex/personalization";var n="/v1";var s={isProductiveSystem:true,hasPersoConnector:true};var i=e({},r,{layers:[a.USER],ROUTES:{DATA:`${t+n}/data/`},loadFeatures(){return Promise.resolve(s)}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/StaticFileConnector", ["sap/base/Log","sap/base/util/LoaderExtensions","sap/base/util/merge","sap/ui/core/Component","sap/ui/core/Supportability","sap/ui/fl/interfaces/BaseLoadConnector"],function(e,r,a,o,n,s){"use strict";function t(a,s){var t=`${a.replace(/\./g,"/")}/changes/${s}.json`;var i=!!sap.ui.loader._.getModuleState(t);if(i||n.isDebugModeEnabled()||o.getComponentPreloadMode()==="off"){try{return r.loadResource(t)}catch(r){if(r.name.includes("SyntaxError")){e.error(r)}e.warning(`flexibility did not find a ${s}.json for the application: ${a}`)}}}const i=a({},s,{loadFlexData(e){var r=e.componentName;r||=e.reference.replace(/.Component/g,"");var a=t(r,"flexibility-bundle");if(a){a.changes=a.changes.concat(a.compVariants);delete a.compVariants;return Promise.resolve(a)}var o=t(r,"changes-bundle");if(o){return Promise.resolve({changes:o})}return Promise.resolve()},loadFeatures(){return Promise.resolve({})},loadVariantsAuthors(){return Promise.resolve({})}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/Utils", ["sap/ui/core/Lib","sap/base/i18n/Localization","sap/base/security/encodeURLParameters"],function(e,s,t){"use strict";var r=2e4;var n=function(e,s){var t=new Error(e.statusText);t.status=e.status;t.userMessage=s;return t};var a=function(s){return e.getResourceBundleFor("sap.ui.fl").getText(s)};const o=(e,s)=>{if(e.slice(-1)!=="/"&&s.charAt(0)!=="/"){e+="/"}return e+s};return{addLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getLanguage()},addSAPLogonLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getSAPLogonLanguage()},getUrl(e,s,r){if(!e||!s.url){throw new Error("Not all necessary parameters were passed")}let n=o(s.url,e);if(s.cacheKey){n=o(n,`~${s.cacheKey}~`)}if(s.reference){n=o(n,s.reference)}else if(s.fileName){n=o(n,s.fileName)}if(r){Object.keys(r).forEach(function(e){if(r[e]===undefined){delete r[e]}});var a=t(r);if(a.length>0){n+=`?${a}`}}return n},sendRequest(e,s,t){s||="GET";s=s.toUpperCase();return new Promise(function(o,i){var p=new XMLHttpRequest;p.open(s,e);p.timeout=r;if((s==="GET"||s==="HEAD")&&(!t||(!t.initialConnector||!t.initialConnector.xsrfToken)&&!t.cacheable)){p.setRequestHeader("X-CSRF-Token","fetch")}if((s==="POST"||s==="PUT"||s==="DELETE")&&t&&t.initialConnector&&t.initialConnector.xsrfToken){p.setRequestHeader("X-CSRF-Token",t.initialConnector.xsrfToken)}if(t&&t.contentType){p.setRequestHeader("Content-Type",t.contentType)}if(t&&t.siteId){p.setRequestHeader("X-LRep-Site-Id",t.siteId)}if(t&&t.sAppDescriptorId){p.setRequestHeader("X-LRep-AppDescriptor-Id",t.sAppDescriptorId)}if(t&&t.dataType){p.responseType=t.dataType}p.onload=function(){if(p.status>=200&&p.status<400){try{var e={};if(p.status!==204&&p.status!==205){if(!p.response&&p.responseText){p.response=p.responseText}e.response=p.response;if(e.response&&typeof e.response==="string"&&p.getResponseHeader("content-type")&&p.getResponseHeader("content-type").indexOf("json")>0){e.response=JSON.parse(e.response)}}e.status=p.status;if(p.getResponseHeader("X-CSRF-Token")){e.xsrfToken=p.getResponseHeader("X-CSRF-Token");if(t&&t.initialConnector){t.initialConnector.xsrfToken=e.xsrfToken}}if(p.getResponseHeader("Etag")){e.etag=p.getResponseHeader("Etag")}o(e)}catch(e){e.userMessage=a("MSG_LOADING_SERVER_RESPONSE_ERROR");i(e)}}else{var s="";try{var r=typeof p.response==="string"?JSON.parse(p.response):p.response;if(Array.isArray(r.messages)&&r.messages.length){s=r.messages.reduce(function(e,s){return e.concat(s.severity==="Error"?`${s.text}\n`:"")},s)}}catch(e){}i(n(p,s))}};p.ontimeout=function(){i(n(p,a("MSG_CONNECTION_TIMEOUT_ERROR")))};p.onerror=function(){i(n(p,a("MSG_NETWORK_ERROR")))};p.addEventListener("error",function(){i(n(p,a("MSG_NETWORK_ERROR")))});if(t&&t.payload){p.send(t.payload)}else{p.send()}})}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/storageResultDisassemble", ["sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/merge","sap/base/util/isEmptyObject"],function(a,e,n){"use strict";function t(a,e){if(e.content.fileName!==e.content.variantManagementReference){a.push(e.content)}e.controlChanges.forEach(function(e){a.push(e)});for(var n in e.variantChanges){a=a.concat(e.variantChanges[n])}return a}function r(a){var e=true;if(a){Object.keys(a).some(function(n){if(a[n].length){e=false;return true}})}return e}return function(i){var s;if(!n(i.variantSection)){s=i.changes||[];for(var c in i.variantSection){var o=i.variantSection[c];for(var u in o.variantManagementChanges){s=s.concat(o.variantManagementChanges[u])}s=o.variants.reduce(t,s)}var f=a.getGroupedFlexObjects(s);var v=a.filterAndSortResponses(f);delete i.changes;delete i.variantSection;e(v[0]||{},i);return v}if(r(i.comp)){s=i.changes||[];i.comp={variants:[],changes:[],defaultVariants:[],standardVariants:[]};s.slice().reverse().forEach(function(a,e,n){var t=false;if(a.fileType==="variant"){i.comp.variants.unshift(a);t=true}else{switch(a.changeType){case"addFavorite":case"removeFavorite":case"updateVariant":i.comp.changes.unshift(a);t=true;break;case"defaultVariant":i.comp.defaultVariants.unshift(a);t=true;break;case"standardVariant":i.comp.standardVariants.unshift(a);t=true;break;default:break}}if(t){var r=n.length-1-e;i.changes.splice(r,1)}})}return[i]}});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/api/InitialFlexAPI", ["sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/registry/Settings"],function(e,n){"use strict";var i={};i.isKeyUser=async function(){const e=await n.getInstance();return e.isKeyUser()};i.getFlexVersion=function(n){return e.getByReference(n.reference)?.version};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/api/Version", [],function(){"use strict";return{Number:{Original:"-1",Draft:"0"},Type:{Active:"active",Draft:"draft",Inactive:"inactive"}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/interfaces/BaseLoadConnector", [],function(){"use strict";var e={loadFlexData(){return Promise.reject("loadFlexData is not implemented")},loadFeatures(){return Promise.reject("loadFeatures is not implemented")},loadVariantsAuthors(){return Promise.reject("loadVariantsAuthors is not implemented")},loadFlVariant(){return Promise.reject("loadFlVariant is not implemented")}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/interfaces/Delegate", [],function(){"use strict";return{getPropertyInfo(){return Promise.reject("not implemented")},getRepresentedProperties(){return Promise.reject("not implemented")},createLabel(){return Promise.reject("not implemented")},createControlForProperty(){return Promise.reject("not implemented")},createLayout(){return Promise.reject("not implemented")}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/library", ["sap/ui/core/Lib","sap/ui/fl/apply/_internal/preprocessors/RegistrationDelegator","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/Scenario","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/library","sap/m/library"],function(i,e,a,r,n,s,l){"use strict";var t=i.init({apiVersion:2,name:"sap.ui.fl",version:"1.136.0",controls:["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{flChangeHandlers:{"sap.ui.fl.util.IFrame":"sap/ui/fl/util/IFrame"},"sap.ui.support":{publicRules:true}}});t.condenser={Classification:l};t.Scenario=s;e.registerAll();function o(){var i=r.getUshellContainer();if(i){return i.getLogonSystem().isTrial()}return false}if(o()){a.setFlexibilityServices([{connector:"LrepConnector",url:"/sap/bc/lrep",layers:[]},{connector:"LocalStorageConnector",layers:[n.CUSTOMER,n.PUBLIC,n.USER]}])}return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/registry/Settings", ["sap/ui/fl/initial/_internal/Storage","sap/ui/fl/Utils","sap/base/Log"],function(e,t,n){"use strict";function o(e){if(e&&e.logonUser){return Promise.resolve(e.logonUser)}var o=t.getUshellContainer();if(o){return t.getUShellService("UserInfo").then(function(e){var t=e.getUser();return t&&t.getId()}).catch(function(e){n.error(`Error getting service from Unified Shell: ${e.message}`)})}return Promise.resolve()}var r=function(e){if(!e){throw new Error("no flex settings provided")}this._oSettings=e};r.attachEvent=function(e,t){r._oEventProvider.attachEvent(e,t)};r.detachEvent=function(e,t){r._oEventProvider.detachEvent(e,t)};r.getInstance=function(){if(r._instance){return Promise.resolve(r._instance)}if(r._oLoadSettingsPromise){return r._oLoadSettingsPromise}return r._loadSettings()};r._loadSettings=function(){var t;var i=e.loadFeatures().then(function(e){t=e;return o(t)}).then(function(e){if(!t){n.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");t={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isVariantPersonalizationEnabled:true,isAnnotationChangeEnabled:true,isAtoAvailable:false,isAtoEnabled:false,isAppVariantSaveAsEnabled:false,isContextSharingEnabled:true,isContextBasedAdaptationEnabled:false,isCondensingEnabled:false,isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isVariantAdaptationEnabled:false,isVariantAuthorNameAvailable:false,isSeenFeaturesAvailable:false,versioning:{},_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false}}t.userId=e;return r._storeInstance(t)});r._oLoadSettingsPromise=i;return i};r._storeInstance=function(e){r._instance||=new r(e);return r._instance};r.getInstanceOrUndef=function(){return r._instance};r.getDefaultLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,PUBLIC:false,USER:false}};r.getDeveloperModeLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,PUBLIC:false,USER:false}};r.prototype._getBooleanProperty=function(e){return this._oSettings[e]||false};r.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser")};r.prototype.isKeyUserTranslationEnabled=function(){return this._getBooleanProperty("isKeyUserTranslationEnabled")};r.prototype.isPublicLayerAvailable=function(){return this._getBooleanProperty("isPublicLayerAvailable")};r.prototype.isVariantAdaptationEnabled=function(){return this._getBooleanProperty("isVariantAdaptationEnabled")};r.prototype.isAppVariantSaveAsEnabled=function(){return!this.isContextBasedAdaptationEnabled()&&this._getBooleanProperty("isAppVariantSaveAsEnabled")};r.prototype.isContextBasedAdaptationEnabled=function(){var e=new URLSearchParams(window.location.search);var t=e.get("sap-ui-xx-rta-adaptations");return t==="true"||this._getBooleanProperty("isContextBasedAdaptationEnabled")};r.prototype.isVersioningEnabled=function(e){return!!(this._oSettings.versioning[e]||this._oSettings.versioning.ALL)};r.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable")};r.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled")};r.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable")};r.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem")};r.prototype.isVariantSharingEnabled=function(){return this._getBooleanProperty("isVariantSharingEnabled")};r.prototype.isPublicFlVariantEnabled=function(){return this._getBooleanProperty("isPublicFlVariantEnabled")};r.prototype.isContextSharingEnabled=function(){return this._getBooleanProperty("isContextSharingEnabled")};r.prototype.isVariantPersonalizationEnabled=function(){return this._getBooleanProperty("isVariantPersonalizationEnabled")};r.prototype.isVariantAuthorNameAvailable=function(){return this._getBooleanProperty("isVariantAuthorNameAvailable")};r.prototype.isCondensingEnabled=function(){return this._getBooleanProperty("isCondensingEnabled")};r.prototype.hasPersoConnector=function(){return this._getBooleanProperty("hasPersoConnector")};r.prototype.isSystemWithTransports=function(){return!!(this._oSettings.system&&this._oSettings.client)};r.prototype.isPublishAvailable=function(){return!!this._oSettings.isPublishAvailable};r.prototype.isProductiveSystemWithTransports=function(){return this.isProductiveSystem()&&this.isSystemWithTransports()};r.prototype.isLocalResetEnabled=function(){return this._getBooleanProperty("isLocalResetEnabled")};r.prototype.isSeenFeaturesAvailable=function(){return this._getBooleanProperty("isSeenFeaturesAvailable")};r.prototype.isAnnotationChangeEnabled=function(){return this._getBooleanProperty("isAnnotationChangeEnabled")};r.prototype.getSystem=function(){return this._oSettings.system};r.prototype.getClient=function(){return this._oSettings.client};r.prototype._getHostname=function(){return document.location.hostname};r.prototype.isCustomerSystem=function(){var e=this._oSettings.systemType;var t={CUSTOMER:true,SAP:false}[e];var n=this._getHostname();return t!==undefined?t:!(n==="localhost"||n==="127.0.0.1")};r.prototype.getUserId=function(){return this._oSettings.userId};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/requireAsync", [],function(){"use strict";return function(e){var i=sap.ui.require(e);if(i){return Promise.resolve(i)}return new Promise(function(i,n){sap.ui.require([e],function(e){i(e)},function(e){n(e)})})}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrame", ["sap/base/util/uid","sap/ui/core/Control","sap/ui/model/json/JSONModel","./getContainerUserInfo","sap/base/security/URLListValidator","sap/base/Log","./IFrameRenderer","../library","sap/ui/core/library"],function(e,t,r,i,o,s,n){"use strict";function a(e){if(e.parts&&e.formatter){return e.formatter.apply(null,e.parts.map(function(e){if(e.model){return`{${e.model}>${e.path}}`}return`{${e.path}}`}))}return e}var l=t.extend("sap.ui.fl.util.IFrame",{metadata:{library:"sap.ui.fl",properties:{url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"50vh"},title:{type:"string",group:"Misc",defaultValue:undefined},asContainer:{type:"boolean",group:"Misc",defaultValue:undefined},renameInfo:{type:"object",group:"Data",defaultValue:null},advancedSettings:{type:"object",defaultValue:{allowForms:true,allowPopups:true,allowScripts:true,allowModals:true,allowSameOrigin:true,additionalSandboxParameters:[]}},_settings:{type:"object",group:"Data",defaultValue:null}},designtime:"sap/ui/fl/designtime/util/IFrame.designtime"},init(...e){if(t.prototype.init){t.prototype.init.apply(this,e)}this._oInitializePromise=i().then(function(e){this._oUserModel=new r(e);this.setModel(this._oUserModel,"$user")}.bind(this))},waitForInit(){return this._oInitializePromise?this._oInitializePromise:Promise.reject()},setUrl(t){var r=decodeURI(t)===t?encodeURI(t):t;if(l.isValidUrl(r).result){const t=l._toUrl(r);const i=l._toUrl(this.getUrl()||"about:blank");if(i.searchParams.has("sap-ui-xx-fl-forceEmbeddedContentRefresh")){t.searchParams.set("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}else if(i.origin===t.origin&&i.pathname===t.pathname&&i.search===t.search&&i.hash!==t.hash){t.searchParams.append("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}this.setProperty("url",t.toString())}else{s.error("Provided URL is not valid as an IFrame src")}return this},_replaceIframeLocation(e){this.getDomRef().contentWindow.location.replace(e)},onAfterRendering(){this._replaceIframeLocation(this.getUrl());this._oLastContentWindow=this.getDomRef().contentWindow;this.getDomRef().addEventListener("load",()=>{if(!this.getDomRef()){return}if(this._oLastContentWindow!==this.getDomRef().contentWindow){this._oLastContentWindow=this.getDomRef().contentWindow;this._replaceIframeLocation(this.getUrl())}})},applySettings(e,...r){const{url:i,...o}=e||{};t.prototype.applySettings.apply(this,[o,...r]);t.prototype.applySettings.apply(this,[{url:i},...r]);if(e){let t={...this.getProperty("_settings")||{}};if(e._settings){t={...t,...e._settings}}else{Object.keys(e).filter(function(t){return e[t]!==undefined}).forEach(function(r){t[r]=a(e[r])})}this.setProperty("_settings",{...t})}},exit(){if(this._oUserModel){this._oUserModel.destroy();delete this._oUserModel}},renderer:n});l._getDocumentLocation=function(){return document.location};l._toUrl=function(e){const t=l._getDocumentLocation();return new URL(e,t.href)};l.VALIDATION_ERROR={UNSAFE_PROTOCOL:"unsafeProtocol",MIXED_CONTENT:"mixedContent",FORBIDDEN_URL:"forbiddenUrl",INVALID_URL:"invalidUrl"};l.isValidUrl=function(e){try{const t=l._toUrl(e);if(/javascript/i.test(t.protocol)){return{result:false,error:l.VALIDATION_ERROR.UNSAFE_PROTOCOL}}if(/http(?!s)/.test(t.protocol)&&!/http(?!s)/.test(l._getDocumentLocation().protocol)){return{result:false,error:l.VALIDATION_ERROR.MIXED_CONTENT}}if(!o.validate(e)){return{result:false,error:l.VALIDATION_ERROR.FORBIDDEN_URL}}return{result:true}}catch{return{result:false,error:l.VALIDATION_ERROR.INVALID_URL}}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrameRenderer", [],function(){"use strict";function t(t,e,n){if(n!==""||n.toLowerCase()==="auto"){t.style(e,n)}}function e(t){return Object.keys(t).filter(e=>t[e]).map(t=>t.replace(/[A-Z]/g,"-$&").toLowerCase()).join(" ")}var n={apiVersion:2};n.render=function(n,o){n.openStart("iframe",o);t(n,"width",o.getWidth());t(n,"height",o.getHeight());n.style("display","block");n.style("border","none");const i=o.getAdvancedSettings();const{additionalSandboxParameters:r,...a}=i;const s=r?.join(" ");const c=e(a);const d=s?`${c} ${s}`:c;n.attr("sandbox",d);n.attr("src","about:blank");var l=o.getTitle();if(l){n.attr("title",l)}n.openEnd();n.close("iframe")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/ManagedObjectModel", ["sap/ui/core/Element","sap/ui/model/base/ManagedObjectModel"],function(e,t){"use strict";function a(e){return e.charAt(0).toUpperCase()+e.slice(1)}var o=e.extend("sap.ui.fl.util.ManagedObjectModel",{metadata:{library:"sap.ui.fl",properties:{data:{type:"object"},name:{type:"string",defaultValue:"$sap.ui.fl.ManagedObjectModel"}},associations:{object:{type:"sap.ui.core.Element"}}},constructor:function(...o){e.apply(this,o);this._oManagedObjectModel=new t(e.getElementById(this.getObject()),this.getData());["data","name","object"].forEach(function(e){this[`set${a(e)}`]=function(){throw new Error(`sap.ui.fl.util.ManagedObjectModel: Can't change the value of \`${e}\` after the object is `+"initialized. Please recreate the object with correct values in the constructor.")}},this)}});o.prototype.setParent=function(...t){const[a]=t;const o=this.getParent();if(o){o.setModel(null,this.getName())}if(a){a.setModel(this._oManagedObjectModel,this.getName())}e.prototype.setParent.apply(this,t)};o.prototype.exit=function(){this._oManagedObjectModel.destroy()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/getContainerUserInfo", ["sap/ui/fl/Utils","sap/base/Log"],function(e,r){"use strict";function t(e){if(!e){return""}return e}return function(){var n=e.getUshellContainer();if(n){return e.getUShellService("UserInfo").then(function(e){if(!e){return{}}var r=e.getUser();if(!r){return{}}var n=t(r.getEmail());var i;if(n){i=t(/@(.*)/.exec(n)[1])}else{i=""}return{fullName:t(r.getFullName()),firstName:t(r.getFirstName()),lastName:t(r.getLastName()),email:n,domain:i}}).catch(function(e){r.error(`Unexpected exception when reading shell user info: ${e.toString()}`);return{}})}return Promise.resolve({})}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/VariantManagement", ["sap/ui/model/Context","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VariantItem","sap/m/VariantManagement","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/registry/Settings","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/base/Log"],function(t,e,a,n,i,o,r,s,l,h,p){"use strict";var{TitleLevel:c}=h;var d=s.extend("sap.ui.fl.variants.VariantManagement",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false},displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:""},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},events:{initialized:{},save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},public:{type:"boolean"},def:{type:"boolean"},contexts:{type:"object[]"},tile:{type:"boolean"}}},cancel:{},manage:{parameters:{renamed:{type:"object[]"},deleted:{type:"string[]"},exe:{type:"object[]"},fav:{type:"object[]"},def:{type:"string"},contexts:{type:"object[]"}}},select:{parameters:{key:{type:"string"}}}},associations:{for:{type:"sap.ui.core.Control",multiple:true}},aggregations:{_embeddedVM:{type:"sap.m.VariantManagement",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2,render(t,e){t.openStart("div",e);t.style("max-width",e.getMaxWidth());t.openEnd();t.renderControl(e._oVM);t.close("div")}}});d.prototype.init=function(){s.prototype.init.apply(this);this.addStyleClass("sapUiFlVarMngmt");this._oRb=l.getResourceBundleFor("sap.ui.fl");this.setModelName(o.getVariantModelName());this.attachModelContextChange(this._setModel,this);this._oVM=new i(`${this.getId()}-vm`);this.setAggregation("_embeddedVM",this._oVM,true);this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[];this._oVM.attachManage(this._fireManage,this);this._oVM.attachCancel(this._fireCancel,this);this._oVM.attachSave(this._fireSave,this);this._oVM.attachSelect(this._fireSelect,this);this._updateWithSettingsInfo()};d.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]}};d.prototype.attachCancel=function(t,e,a){this.attachEvent("cancel",t,e,a);return this};d.prototype._findCallback=function(t,e,a){var n=-1;t.some(function(t,i){if(t.fCallback===e&&t.oObj===a){n=i}return n>=0});return n};d.prototype.detachCancel=function(t,e){var a=this._findCallback(this._aCancelEventHandlers,t,e);if(a>=0){this.detachEvent("cancel",t,e);this._aCancelEventHandlers.splice(a,1)}return this};d.prototype.fireManage=function(t){this._oVM.fireManage(t)};d.prototype.fireSave=function(t){this._oVM.fireSave(t)};d.prototype._fireCancel=function(t){for(var e=0;e<this._aCancelEventHandlers.length;e++){t.oSource=this;this._aCancelEventHandlers[e].fCallbackBound(t,this._aCancelEventHandlers[e].mProps)}};d.prototype.attachSave=function(t,e,a){this.attachEvent("save",t,e,a);return this};d.prototype.detachSave=function(t,e){var a=this._findCallback(this._aSaveEventHandlers,t,e);if(a>-1){this.detachEvent("save",t,e);this._aSaveEventHandlers.splice(a,1)}return this};d.prototype._fireSave=function(t){this._handleAllListeners(t,this._aSaveEventHandlers)};d.prototype.hasListeners=function(...t){const[e]=t;const a=["save","select","cancel","manage"];if(a.indexOf(e)>-1){var n=null;if(e==="select"){n=this._aSelectEventHandlers}else if(e==="save"){n=this._aSaveEventHandlers}else if(e==="manage"){n=this._aManageEventHandlers}else if(e==="cancel"){n=this._aCancelEventHandlers}return n.length>0}return s.prototype.hasListeners.apply(this,t)};d.prototype.attachEvent=function(...t){const[e,,a]=t;let[,n,,i]=t;const o=["save","select","cancel","manage"];if(o.indexOf(e)>-1){var r=null;var l=a;if(typeof n==="function"){l=n;i=a;n=undefined}i=i===this?undefined:i;if(e==="select"){r=this._aSelectEventHandlers}else if(e==="save"){r=this._aSaveEventHandlers}else if(e==="manage"){r=this._aManageEventHandlers}else if(e==="cancel"){r=this._aCancelEventHandlers}r.push({fCallback:l,fCallbackBound:i?l.bind(i):l,oObj:i,mProps:n})}else{s.prototype.attachEvent.apply(this,t)}};d.prototype.attachEventOnce=function(...t){const[e,a,n,i]=t;var o;if(e==="manage"){o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1&&this._aManageEventHandlers[o].bOnce){this._aManageEventHandlers.splice(o,1)}this.attachManage(a,n,i);o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1){this._aManageEventHandlers[o].bOnce=true}}else if(e==="save"){o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1&&this._aSaveEventHandlers[o].bOnce){this._aSaveEventHandlers.splice(o,1)}this.attachSave(a,n,i);o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1){this._aSaveEventHandlers[o].bOnce=true}}else if(e==="select"){o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1&&this._aSelectEventHandlers[o].bOnce){this._aSelectEventHandlers.splice(o,1)}this.attachSelect(a,n,i);o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1){this._aSelectEventHandlers[o].bOnce=true}}else{s.prototype.attachEventOnce.apply(this,t)}};d.prototype.attachManage=function(t,e,a){this.attachEvent("manage",t,e,a);return this};d.prototype._handleAllListeners=function(t,e){var a=0;var n=[];while(a<e.length){t.oSource=this;e[a].fCallbackBound(t,e[a].mProps);if(e[a]){if(e[a].hasOwnProperty("bOnce")&&e[a].bOnce){n.push(a)}a+=1}}for(a=n.length-1;a>-1;a--){e.splice(n[a],1)}};d.prototype._fireManage=function(t){this._handleAllListeners(t,this._aManageEventHandlers)};d.prototype.detachManage=function(t,e){var a=this._findCallback(this._aManageEventHandlers,t,e);if(a>-1){this.detachEvent("manage",t,e);this._aManageEventHandlers.splice(a,1)}return this};d.prototype.attachSelect=function(t,e,a){this.attachEvent("select",t,e,a);return this};d.prototype._fireSelect=function(t){this._handleAllListeners(t,this._aSelectEventHandlers)};d.prototype.detachSelect=function(t,e){var a=this._findCallback(this._aSelectEventHandlers,t,e);if(a>-1){this.detachEvent("select",t,e);this._aSelectEventHandlers.splice(a,1)}return this};d.prototype._createSaveAsDialog=function(){this._oVM._createSaveAsDialog()};d.prototype._handleVariantSaveAs=function(t){this._oVM._handleVariantSaveAs(t)};d.prototype.getFocusDomRef=function(){if(this._oVM){return this._oVM.oVariantPopoverTrigger.getFocusDomRef()}return null};d.prototype.getManageDialog=function(){if(this._oVM){return this._oVM.oManagementDialog}return null};d.prototype.getVariants=function(){return this._oVM?this._oVM.getItems():[]};d.prototype.getVariantByKey=function(t){return this._oVM?this._oVM._getItemByKey(t):null};d.prototype.getTitle=function(){return this._oVM.getTitle()};d.prototype.refreshTitle=function(){this._oVM.refreshTitle()};d.prototype.setPopoverTitle=function(t){this._oVM.setPopoverTitle(t);return this};d.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);this._oVM.setLevel(t);return this};d.prototype.setTitleStyle=function(t){this.setProperty("titleStyle",t);this._oVM.setTitleStyle(t);return this};d.prototype.setShowAsText=function(t){this._oVM.setShowAsText(t);return this};d.prototype.getShowAsText=function(){return this._oVM.getShowAsText()};d.prototype.setEditable=function(t){this.setProperty("editable",t);this._oVM.setShowFooter(t);return this};d.prototype.setShowExecuteOnSelection=function(t){this._oVM.setSupportApplyAutomatically(t);return this};d.prototype.setShowSetAsDefault=function(t){this.setProperty("showSetAsDefault",t);this._oVM.setSupportDefault(t);return this};d.prototype.setDisplayTextForExecuteOnSelectionForStandardVariant=function(t){this.setProperty("displayTextForExecuteOnSelectionForStandardVariant",t);this._oVM.setDisplayTextForExecuteOnSelectionForStandardVariant(t);return this};d.prototype.setInErrorState=function(t){this.setProperty("inErrorState",t);this._oVM.setInErrorState(t);return this};d.prototype._setStandardVariantKey=function(t){this._oVM.setStandardVariantKey(t)};d.prototype.openManagementDialog=function(t,e,a){this._oVM.openManagementDialog(t,e,a)};d.prototype.openSaveAsDialogForKeyUser=function(t,e){this._oVM.openSaveAsDialog(t,e)};d.prototype.setEditable=function(t){this._oVM.setProperty("showFooter",t);return this};d.prototype.setCurrentVariantKey=function(t){this._oVM.setCurrentVariantKey(t)};d.prototype.getCurrentVariantKey=function(){return this._oVM.getSelectedKey()};d.prototype.setDefaultVariantKey=function(t){this._oVM.setDefaultKey(t)};d.prototype.getDefaultVariantKey=function(){return this._oVM.getDefaultKey()};d.prototype.enteringDesignMode=function(){this._oVM.setDesignMode(true)};d.prototype.leavingDesignMode=function(){this._oVM.setDesignMode(false)};d.prototype.getModified=function(){return this._oVM.getModified()};d.prototype.setModified=function(t){this._oVM.setModified(t)};d.prototype.getStandardVariantKey=function(){return this._oVM.getStandardVariantKey()};d.prototype._getEmbeddedVM=function(){return this._oVM};d.prototype._updateWithSettingsInfo=function(){r.getInstance().then(function(t){if(this._oVM){this._oVM.setShowSaveAs(t.isVariantPersonalizationEnabled());this._oVM.setSupportPublic(t.isPublicFlVariantEnabled())}}.bind(this)).catch(function(t){p.error(t)})};d.prototype.getModelName=function(){return this.getProperty("modelName")};d.prototype.setModelName=function(t){if(this.getModelName()){this.oContext=null;this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[]}this.setProperty("modelName",t);return this};d.prototype._setModel=function(){this._setBindingContext()};d.prototype._setBindingContext=function(){var e;var a;var n=this.getModelName();if(!this.oContext){e=this.getModel(n);if(e){a=this._getLocalId(e);if(a){this.oContext=new t(e,`/${a}`);this.setBindingContext(this.oContext,n);if(e.registerToModel){e.registerToModel(this)}this.fireInitialized();this._oVM.setModel(e,n);this._oVM.setSupportDefault(true);this._createItemsModel(n);this._oVM.bindProperty("selectedKey",{path:`${this.oContext}/currentVariant`,model:n});this._oVM.bindProperty("defaultKey",{path:`${this.oContext}/defaultVariant`,model:n});this._oVM.bindProperty("modified",{path:`${this.oContext}/modified`,model:n});this._oVM.bindProperty("supportFavorites",{path:`${this.oContext}/showFavorites`,model:n});this._oVM.bindProperty("supportApplyAutomatically",{path:`${this.oContext}/showExecuteOnSelection`,model:n});this._oVM.bindProperty("showFooter",{path:`${this.oContext}/variantsEditable`,model:n});this._oVM.setPopoverTitle(this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS"));this._setStandardVariantKey(a)}}}};d.prototype._createItemsModel=function(t){this._oItemsTemplate=new n({key:`{${t}>key}`,title:`{${t}>title}`,sharing:`{${t}>sharing}`,remove:`{${t}>remove}`,favorite:`{${t}>favorite}`,executeOnSelect:`{${t}>executeOnSelect}`,rename:`{${t}>rename}`,visible:`{${t}>visible}`,changeable:`{${t}>change}`,author:`{${t}>author}`,contexts:`{${t}>contexts}`});this._oVM.bindAggregation("items",{path:`${this.oContext}/variants`,model:t,template:this._oItemsTemplate,filters:new e({path:"visible",operator:a.EQ,value1:true})})};d.prototype._getLocalId=function(t){var e=this.getModelName();if(!e){return null}if(e!==o.getVariantModelName()){return this.getId()}return t.getVariantManagementReferenceForControl(this)};d.prototype._getInnerItems=function(){var t=[];if(this.oContext&&this.oContext.getObject()){t=this.oContext.getObject().variants.filter(function(t){if(!t.hasOwnProperty("visible")){return true}return t.visible})}return t};d.prototype._getInnerItemByKey=function(t){var e=null;var a=this._getInnerItems();a.some(function(a){if(a.key===t){e=a}return e!==null});return e};d.prototype.registerApplyAutomaticallyOnStandardVariant=function(t){this._fRegisteredApplyAutomaticallyOnStandardVariant=t;return this};d.prototype.getApplyAutomaticallyOnVariant=function(t){var e=false;if(t){e=t.executeOnSelect;if(this._fRegisteredApplyAutomaticallyOnStandardVariant&&this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&t.key===this._oVM.getStandardVariantKey()){try{e=this._fRegisteredApplyAutomaticallyOnStandardVariant(t)}catch(t){p.error("callback for determination of apply automatically on standard variant failed")}}}return e};d.prototype.exit=function(...t){this._oVM.detachManage(this._fireManage,this);this._oVM.detachCancel(this._fireCancel,this);this._oVM.detachSelect(this._fireSelect,this);this._oVM.detachSave(this._fireSave,this);if(this._oVM){this._oVM.destroy();this._oVM=undefined}if(this._oItemsTemplate){this._oItemsTemplate.destroy();this._oItemsTemplate=undefined}this._fRegisteredApplyAutomaticallyOnStandardVariant=null;this.oContext=undefined;this._oRb=undefined;this._aCancelEventHandlers=undefined;this._aSaveEventHandlers=undefined;this._aManageEventHandlers=undefined;this._aSelectEventHandlers=undefined;s.prototype.exit.apply(this,t)};d.prototype.addFor=function(t){this.addAssociation("for",t);return this};d.prototype._getToolbarInteractive=function(){return true};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/VariantModel", ["sap/base/util/restricted/_difference","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode"],function(e,t,a,n,r,i,s,o,c,l,f,u,h,p,d,g,m,v,V,R,y,C,D,S,b,x){"use strict";var F={};function M(e,t){t._oVariantSwitchPromise=t._oVariantSwitchPromise.catch(function(){}).then(e);v.setVariantSwitchPromise(t.sFlexReference,t._oVariantSwitchPromise);return t._oVariantSwitchPromise}function I(e,t){F[e]=t}function E(e,t){return m.switchVariant(e).then(function(){if(this.oData[e.vmReference].updateVariantInURL){u.updateVariantInURL({vmReference:e.vmReference,newVReference:e.newVReference,model:this})}this.callVariantSwitchListeners(e.vmReference,e.newVReference,undefined,t)}.bind(this))}function U(e){var t=y.getInstanceOrUndef();if(t&&!t.isVariantPersonalizationEnabled()){e.remove=false;e.rename=false;e.change=false}}function _(e){var t=y.getInstanceOrUndef();var a=t&&(t.isKeyUser()||!t.getUserId()||t.isPublicFlVariantEnabled()&&t.getUserId().toUpperCase()===e.instance.getSupportInformation().user.toUpperCase());e.remove=a;e.rename=a;e.change=a}function P(e,t,a){var n=a?D.getCurrentLayer():C.USER;if(e.layer===n&&e.key!==t){return true}return false}function L(e){return new Promise(function(t){if(e.getDomRef()){t()}else{e.addEventDelegate({onAfterRendering(){t()}})}})}function O(){var e=S.getUshellContainer();if(e){var t=[S.getUShellService("UserInfo"),S.getUShellService("URLParsing"),S.getUShellService("Navigation"),S.getUShellService("ShellNavigationInternal")];return Promise.all(t).then(function(e){I("UserInfo",e[0]);I("URLParsing",e[1]);I("Navigation",e[2]);I("ShellNavigationInternal",e[3])}).catch(function(e){throw new Error(`Error getting service from Unified Shell: ${e}`)})}return undefined}function w(e,t){return i({},e.find(function(e){return e.key===t}))}function T(e){const t=v.getInitialUIChanges({vmReference:e.vmReference,reference:e.reference});const a=t.reduce((t,a)=>{const n=a.getSelector();const r=o.bySelector(n,e.appComponent);if(r&&S.indexOfObject(t,{selector:r})===-1){t.push({selector:r})}return t},[]);return a.length?V.waitForFlexObjectsToBeApplied(a):Promise.resolve()}var A=b.extend("sap.ui.fl.variants.VariantModel",{constructor:function(e,t){this.pSequentialImportCompleted=Promise.resolve();b.apply(this,[e]);this.sharing={PRIVATE:"private",PUBLIC:"public"};this.oFlexController=t.flexController;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=R.getFlexReferenceForControl(t.appComponent);this.oAppComponent=t.appComponent;this._oResourceBundle=f.getResourceBundleFor("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};this.fnUpdateListener=this.updateData.bind(this);this.oDataSelector=v.getVariantManagementMap();this.oDataSelector.addUpdateListener(this.fnUpdateListener);this.updateData();const a=V.getLiveDependencyMap(this.sFlexReference);v.getInitialUIChanges({reference:this.sFlexReference},this.oAppComponent.getId(),this.sFlexReference).forEach(e=>{g.addChangeAndUpdateDependencies(e,this.oAppComponent.getId(),a)});this.setDefaultBindingMode(x.OneWay)}});A.prototype.updateData=function(){const e=this.oDataSelector.get({reference:this.sFlexReference});const t={...this.getData()};Object.entries(e).forEach(function(e){const a=e[0];const n={...e[1]};t[a]||={};t[a].variants=n.variants.map(function(e){const n=(t[a].variants||[]).find(function(t){return t.key===e.key});return{...n||{},...e}});t[a].currentVariant=n.currentVariant;t[a].defaultVariant=n.defaultVariant;t[a].modified=n.modified});this.setData(t);this.refresh(true)};A.prototype.invalidateMap=function(){this.oDataSelector.checkUpdate({reference:this.sFlexReference})};A.prototype.initialize=function(){return Promise.all([y.getInstance(),O()]).then(function(){u.initialize({model:this})}.bind(this))};A.prototype.updateCurrentVariant=function(e){var t={vmReference:e.variantManagementReference,currentVReference:this.getCurrentVariantReference(e.variantManagementReference),newVReference:e.newVariantReference,appComponent:e.appComponent||this.oAppComponent,modifier:o,reference:this.sFlexReference};if(e.internallyCalled){return E.call(this,t,e.scenario)}return M(E.bind(this,t,e.scenario),this)};A.prototype.getCurrentVariantReference=function(e){return this.oData[e].currentVariant};A.prototype.getVariantManagementReference=function(e){var t="";var a=-1;Object.keys(this.oData).some(function(n){return this.oData[n].variants.some(function(r,i){if(r.key===e){t=n;a=i;return true}})}.bind(this));return{variantManagementReference:t,variantIndex:a}};A.prototype.getVariant=function(e,t){var a=t||this.getVariantManagementReference(e).variantManagementReference;return w(this.oData[a].variants,e)};A.prototype.getVariantTitle=function(e,t){return w(this.oData[t].variants,e).title};function k(e,t){var a=v.getVariantChangesForVariant({vmReference:e,reference:this.sFlexReference});var n=this.oData[e].defaultVariant;if(t.getExecuteOnSelectionForStandardDefault()&&n===e&&!a.setExecuteOnSelect){var r=w(this.oData[e].variants,e);r.instance.setExecuteOnSelection(true);this.oData[e].variants[0].executeOnSelect=true;return true}return false}A.prototype.attachVariantApplied=function(e){var t=l.getElementById(e.vmControlId);var a=this.getVariantManagementReferenceForControl(t);return this.waitForVMControlInit(a).then(function(e,a){this._oVariantAppliedListeners[e]||={};var n=k.call(this,e,t);if(a.callAfterInitialVariant||n){var r={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:e};T(r).then(function(){var t=this.oData[e].currentVariant;this.callVariantSwitchListeners(e,t,a.callback)}.bind(this))}return L(a.control).then(function(){if(h.getRelevantVariantManagementControlId(a.control,this.getVariantManagementControlIds())===a.vmControlId){this.oData[e].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[e][a.control.getId()]=a.callback}else{s.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the "+"responsible VariantManagement control")}}.bind(this))}.bind(this,a,e))};A.prototype.callVariantSwitchListeners=function(e,t,a,r){if(this._oVariantAppliedListeners[e]){var i=w(this.oData[e].variants,t);if(r){i.createScenario=r}if(a){a(i)}else{n(this._oVariantAppliedListeners[e],function(e,t){t(i)})}}};A.prototype.detachVariantApplied=function(e,t){var a=this.getVariantManagementReferenceForControl(l.getElementById(e));if(this._oVariantAppliedListeners[a]){delete this._oVariantAppliedListeners[a][t]}};A.prototype._getVariantTitleCount=function(e,t){var a=this.getData();return a[t].variants.reduce(function(t,a){if(e.toLowerCase()===a.title.toLowerCase()&&a.visible){t++}return t},0)};function j(e,t){var a={id:t.newVariantReference,variantName:t.title,contexts:t.contexts,layer:t.layer,adaptationId:t.adaptationId,reference:e.getFlexObjectMetadata().reference,generator:t.generator,variantManagementReference:t.variantManagementReference,executeOnSelection:t.executeOnSelection};if(t.layer===C.VENDOR){a.user="SAP"}if(t.currentVariantComparison===1){if(t.sourceVariantSource.instance.getLayer()===t.layer){a.variantReference=t.sourceVariantSource.instance.getVariantReference()}else{a.variantReference=e.getVariantReference()}}else if(t.currentVariantComparison===0){a.variantReference=e.getVariantReference()}else if(t.currentVariantComparison===-1){a.variantReference=t.sourceVariantReference}return p.createFlVariant(a)}A.prototype._duplicateVariant=function(e){var t=e.sourceVariantReference;var a=e.variantManagementReference;var n=this.getVariant(t);var r=v.getControlChangesForVariant({vmReference:a,vReference:t,reference:this.sFlexReference}).map(function(e){return e.convertToFileContent()});e.currentVariantComparison=D.compareAgainstCurrentLayer(n.instance.getLayer(),e.layer);if(e.currentVariantComparison===1){e.sourceVariantSource=this.getVariant(n.instance.getVariantReference())}var s={instance:j(n.instance,e),controlChanges:r,variantChanges:{}};r=s.controlChanges.slice();var o={};s.controlChanges=r.reduce(function(t,a){if(D.compareAgainstCurrentLayer(a.layer,e.layer)>=0){o=i({},a);o.layer=e.layer;o.variantReference=s.instance.getId();o.support||={};o.support.sourceChangeFileName=a.fileName;o.packageName="$TMP";o.fileName=S.createDefaultFileName(o.changeType);t.push(p.createFromFileContent(o))}return t},[]);return s};A.prototype._collectModelChanges=function(e,t,a){const n=this.getData()[e];const r=n.variants;const i=[];const s=y.getInstanceOrUndef();const o=[];const c=e=>r.find(t=>t.key===e);const l=(e,a,n)=>{const r=["setTitle","setExecuteOnSelect","setVisible"].includes(a);const o=r&&s?.isPublicFlVariantEnabled()&&e.layer===C.PUBLIC?C.PUBLIC:t;i.push({variantReference:e.key,changeType:a,layer:o,...n})};a.getParameter("renamed")?.forEach(({key:e,name:t})=>{const a=c(e);l(a,"setTitle",{title:t,originalTitle:a.title})});a.getParameter("fav")?.forEach(({key:e,visible:t})=>{const a=c(e);l(a,"setFavorite",{favorite:t,originalFavorite:a.favorite})});a.getParameter("exe")?.forEach(({key:e,exe:t})=>{const a=c(e);l(a,"setExecuteOnSelect",{executeOnSelect:t,originalExecuteOnSelect:a.executeOnSelect})});a.getParameter("deleted")?.forEach(e=>{const t=c(e);l(t,"setVisible",{visible:false});o.push(e)});a.getParameter("contexts")?.forEach(({key:e,contexts:t})=>{const a=c(e);l(a,"setContexts",{contexts:t,originalContexts:a.contexts})});const f=a.getParameter("def");if(f){i.push({variantManagementReference:e,changeType:"setDefault",defaultVariant:f,originalDefaultVariant:n.defaultVariant,layer:t})}return{changes:i,variantsToBeDeleted:o}};A.prototype.setVariantProperties=function(e,t){var a=this.getData();var n=this.getVariant(t.variantReference,e).instance;var r={};switch(t.changeType){case"setTitle":n.setName(t.title,true);break;case"setFavorite":r.favorite=t.favorite;n.setFavorite(t.favorite);break;case"setExecuteOnSelect":r.executeOnSelect=t.executeOnSelect;n.setExecuteOnSelection(t.executeOnSelect);break;case"setVisible":r.visible=t.visible;r.createdByReset=false;n.setVisible(t.visible);break;case"setContexts":r.contexts=t.contexts;n.setContexts(t.contexts);break;case"setDefault":r.defaultVariant=t.defaultVariant;var i=u.getStoredHashParams({model:this});if(i&&this.oData[e].updateVariantInURL){if(a[e].defaultVariant!==a[e].currentVariant&&i.indexOf(a[e].currentVariant)===-1){u.update({parameters:i.concat(a[e].currentVariant),updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this})}else if(a[e].defaultVariant===a[e].currentVariant&&i.indexOf(a[e].currentVariant)>-1){i.splice(i.indexOf(a[e].currentVariant),1);u.update({parameters:i,updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this})}}break;default:break}return r};A.prototype._ensureStandardVariantExists=function(e){var t=this.getData();var n=t[e]||{};var i=a(n,["initPromise"]);if(!t[e]||r(i)){var s=p.createFlVariant({id:e,variantManagementReference:e,variantName:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),user:h.DEFAULT_AUTHOR,layer:C.BASE,reference:this.sFlexReference});v.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),s);this._aCreatedStandardVariantsFor||=[];this._aCreatedStandardVariantsFor.push(e)}};A.prototype.setModelPropertiesForControl=function(e,t,a){this.oData[e].showFavorites=true;var n=this._bDesignTimeMode;if(n!==t){this._bDesignTimeMode=t;if(t){u.clearAllVariantURLParameters({model:this})}else if(n&&this.oData[e].updateVariantInURL){u.update({parameters:u.getStoredHashParams({model:this}),updateURL:true,updateHashEntry:false,model:this})}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents()}a.detachManage(this.fnManageClick,this);if(t&&this.oData[e]._isEditable){this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(a){a.rename=true;a.change=true;a.sharing=this.sharing.PUBLIC;a.remove=P(a,e,t)}.bind(this))}else if(this.oData[e]._isEditable){a.attachManage({variantManagementReference:e},this.fnManageClick,this);this.oData[e].variantsEditable=true;this.oData[e].variants.forEach(function(a){a.remove=P(a,e,t);switch(a.layer){case C.USER:a.rename=true;a.change=true;a.sharing=this.sharing.PRIVATE;U(a);break;case C.PUBLIC:a.sharing=this.sharing.PUBLIC;_(a);break;default:a.rename=false;a.change=false;a.sharing=this.sharing.PUBLIC}}.bind(this))}else{this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(e){e.remove=false;e.rename=false;e.change=false})}};A.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,t){const a=this._collectModelChanges(t.variantManagementReference,t.layer,e);t.resolve(a)};this.fnManageClick=function(e,t){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(a){a.handleManageEvent(e,t,this)}.bind(this))}};A.prototype._handleSaveEvent=function(e){if(!this._bDesignTimeMode){var t=e.getSource();var a=e.getParameters();sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(e){e.handleSaveEvent(t,a,this)}.bind(this))}};function B(e,t){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(a){a.handleSelectVariant(e,t)})}A.prototype.getLocalId=function(e,t){return o.getSelector(e,t).id};A.prototype.getVariantManagementReferenceForControl=function(e){var t=e.getId();var a=S.getAppComponentForControl(e);return a&&a.getLocalId(t)||t};A.prototype.switchToDefaultForVariantManagement=function(e){if(this.oData[e].currentVariant!==this.oData[e].defaultVariant){c.show(200);this.updateCurrentVariant({variantManagementReference:e,newVariantReference:this.oData[e].defaultVariant}).then(function(){c.hide()})}};A.prototype.switchToDefaultForVariant=function(e){Object.keys(this.oData).forEach(function(t){if(!e||this.oData[t].currentVariant===e){this.switchToDefaultForVariantManagement(t)}}.bind(this))};function N(e,t){this.oData[t].variants.forEach(function(a){const n=a.title&&a.title.match(/{(\w+)>(\w.+)}/);if(n){const[,r,i]=n;const s=e.getModel(r);if(s){const e=s.getResourceBundle().getText(i);const t={reference:this.sFlexReference,changeType:"setTitle",layer:a.layer,fileType:"ctrl_variant_change",variantId:a.key};const n=p.createVariantChange(t);n.setText("title",e,"XFLD");a.instance.setName(e,true);v.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),n)}else{e.attachEventOnce("modelContextChange",N.bind(this,e,t))}}}.bind(this))}A.prototype.registerToModel=function(e){const t=this.getVariantManagementReferenceForControl(e);this._ensureStandardVariantExists(t);this.oData[t]._isEditable=e.getEditable();this.oData[t].showExecuteOnSelection=false;N.call(this,e,t);e.attachEvent("select",{vmReference:t,model:this},B);e.attachSave(this._handleSaveEvent,this);this.setModelPropertiesForControl(t,false,e);const a=e.getUpdateVariantInURL();this.oData[t].updateVariantInURL=a;if(a){u.registerControl({vmReference:t,updateURL:true,model:this});u.handleModelContextChange({model:this,vmControl:e})}if(this.oData[t].initPromise){this.oData[t].initPromise.resolveFunction();delete this.oData[t].initPromise}this.oData[t].init=true;const n={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:t};this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(T.bind(undefined,n))};A.prototype.waitForVMControlInit=function(e){if(!this.oData[e]){this.oData[e]={}}else if(this.oData[e].init){return Promise.resolve()}this.oData[e].initPromise={};this.oData[e].initPromise.promise=new Promise(function(t){this.oData[e].initPromise.resolveFunction=t}.bind(this));return this.oData[e].initPromise.promise};A.prototype._getDirtyChangesFromVariantChanges=function(e){var t=e.map(function(e){return e.getId()});return V.getDirtyFlexObjects(this.sFlexReference).filter(function(e){return t.includes(e.getId())&&!e.getSavedToVariant()})};A.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(e,t){return e.concat([this.oData[t].currentVariant])}.bind(this),[])};A.prototype.getVariantManagementControlIds=function(){var e;return Object.keys(this.oData||{}).reduce(function(t,a){if(this.oAppComponent.byId(a)){e=this.oAppComponent.createId(a)}else{e=a}t.push(e);return t}.bind(this),[])};A.prototype.destroy=function(){const e=this.oDataSelector.get({reference:this.sFlexReference});const t=Object.entries(e).map(([e,t])=>{const a=v.getVariant({vmReference:e,vReference:t.currentVariant,reference:this.sFlexReference});return a.controlChanges}).flat();const a=V.getLiveDependencyMap(this.sFlexReference);t.forEach(e=>{g.removeChangeFromMap(a,e.getId());g.removeChangeFromDependencies(a,e.getId())});this.oDataSelector.removeUpdateListener(this.fnUpdateListener);const n=[];(this._aCreatedStandardVariantsFor||[]).forEach(t=>{if(e[t]?.variants.length>1||e[t]?.variants[0].controlChanges.length){n.push(e[t].variants[0].instance)}});if(n.length){v.addRuntimeOnlyFlexObjects(this.sFlexReference,n)}v.clearRuntimeSteadyObjects(this.sFlexReference,this.oAppComponent.getId());v.resetCurrentVariantReference(this.sFlexReference);b.prototype.destroy.apply(this)};A.prototype.getUShellService=function(e){return S.getUshellContainer()&&F[e]};return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/Storage", ["sap/base/util/ObjectPath","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/VersionInfo"],function(e,t,n,r){"use strict";var a="sap/ui/fl/write/_internal/connectors/";function i(){return n.getConnectors(a,false)}function o(e,t){var n=t.filter(function(t){return t.layers.indexOf("ALL")!==-1||t.layers.indexOf(e)!==-1});if(n.length===1){return n[0]}if(n.length===0){throw new Error(`No Connector configuration could be found to write into layer: ${e}`)}if(n.length>1){throw new Error("sap.ui.core.Configuration 'flexibilityServices' has a misconfiguration: Multiple "+`Connector configurations were found to write into layer: ${e}`)}return undefined}function s(e){if(!e){return Promise.reject("No layer was provided")}return i().then(o.bind(this,e))}function u(e){if(e.draft){return new Promise(function(t,n){sap.ui.require(["sap/ui/fl/write/api/FeaturesAPI"],function(r){r.isVersioningEnabled(e.layer).then(function(r){if(r){t()}else{n(`Draft is not supported for the given layer: ${e.layer}`)}})})})}return Promise.resolve()}function c(e,n){var r=n.filter(function(n){return n.getState()===t.LifecycleState.NEW&&n.getFileType()===e.getFileType()});var a=r.findIndex(function(t){return t.getId()===e.getId()});return a}async function d(e){var n;if(e.allChanges&&e.allChanges.length&&e.condensedChanges){await l(e.condensedChanges);n={namespace:e.allChanges[0].convertToFileContent().namespace,layer:e.layer};var r=0;var a=false;e.reference||=e.allChanges[0].convertToFileContent().reference;e.allChanges.forEach(function(i,o){var s=i.getFileType();var u=c(i,e.condensedChanges);if(i.condenserState){var d=false;if(i.condenserState==="delete"){if(i.getState()===t.LifecycleState.PERSISTED||i.getState()===t.LifecycleState.DELETED){n.delete||={};n.delete[s]||=[];n.delete[s].push(i.getId())}r++}else if(e.condensedChanges.length){d=e.allChanges[o].getId()!==e.condensedChanges[o-r].getId()}if((i.condenserState==="select"&&i.getState()!==t.LifecycleState.NEW||i.condenserState==="update")&&d&&!a){var l=e.condensedChanges.slice(o-r).map(function(e){return e.getId()});n.reorder||={};n.reorder[s]||=[];n.reorder[s]=l;a=true}if(i.condenserState==="select"&&i.getState()===t.LifecycleState.NEW){n.create||={};n.create[s]||=[];n.create[s][u]={};n.create[s][u][i.getId()]=i.convertToFileContent()}else if(i.condenserState==="update"){n.update||={};n.update[s]||=[];var f=n.update[s].length;n.update[s][f]={};n.update[s][f][i.getId()]={content:i.getContent()}}delete i.condenserState}else if(i.getState()===t.LifecycleState.NEW){n.create||={};n.create[s]||=[];n.create[s][u]={};n.create[s][u][i.getId()]=i.convertToFileContent()}})}return n}async function l(e){const t=await r.load();const n=t.version;e.forEach(e=>{if(e.isA&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")){const t=e.getSupportInformation();t.sapui5Version||=n;e.setSupportInformation(t)}else{e.support||={};e.support.sapui5Version||=n}})}function f(t,n){return u(n).then(s.bind(undefined,n.layer)).then(function(r){n.url=r.url;var a=e.get(t,r.writeConnectorModule);return a.call(r.writeConnectorModule,n)})}var p={};p.write=async function(e){await l(e.flexObjects);return f("write",e)};p.condense=async function(e){const t={...e};const n=await d(t);if(!n){return Promise.reject("No changes were provided")}if(n.create||n.reorder||n.update||n.delete){let e=[];if(n.create){e=(n.create.change?n.create.change:[]).concat(n.create.ctrl_variant?n.create.ctrl_variant:[])}t.flexObjects=n;const r=await f("condense",t);if(r&&r.status&&r.status===205&&e.length){const t=e.map(function(e){return Object.values(e).pop()});r.response=t}else if(r&&r.status&&r.status===200){r.response=r.response.flexObjects}return r}return undefined};p.remove=function(e){return f("remove",e)};p.update=function(e){return f("update",e)};p.reset=function(e){return f("reset",e)};p.getFlexInfo=function(e){return f("getFlexInfo",e)};p.getSeenFeatureIds=function(e){return f("getSeenFeatureIds",e)};p.setSeenFeatureIds=function(e){return f("setSeenFeatureIds",e)};p.getContexts=function(e){return f("getContexts",e)};p.loadContextDescriptions=function(e){return f("loadContextDescriptions",e)};p.isContextSharingEnabled=function(e){return f("isContextSharingEnabled",e)};p.publish=function(e){return f("publish",e)};p.contextBasedAdaptation={create(e){return i().then(f.bind(undefined,"contextBasedAdaptation.create",e))},reorder(e){return i().then(f.bind(undefined,"contextBasedAdaptation.reorder",e))},update(e){return i().then(f.bind(undefined,"contextBasedAdaptation.update",e))},load(e){return i().then(f.bind(undefined,"contextBasedAdaptation.load",e))},remove(e){return i().then(f.bind(undefined,"contextBasedAdaptation.remove",e))}};p.versions={load(e){return i().then(f.bind(undefined,"versions.load",e))},activate(e){return i().then(f.bind(undefined,"versions.activate",e))},discardDraft(e){return i().then(f.bind(undefined,"versions.discardDraft",e))},publish(e){return i().then(f.bind(undefined,"versions.publish",e))}};p.translation={getSourceLanguages(e){return i().then(f.bind(undefined,"translation.getSourceLanguages",e))},getTexts(e){return i().then(f.bind(undefined,"translation.getTexts",e))},postTranslationTexts(e){return i().then(f.bind(undefined,"translation.postTranslationTexts",e))}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/Versions", ["sap/ui/fl/initial/api/Version","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/Storage","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode"],function(e,r,t,i,n,s){"use strict";var a={};var o=9;var l=o+1;function d(r){var t=v(r);t.setDefaultBindingMode(s.OneWay);t.setSizeLimit(o);t.setDirtyChanges=function(e){t.setProperty("/dirtyChanges",e);t.updateDraftVersion();t.updateBindings(true)};t.updateDraftVersion=function(){var r=t.getProperty("/versions");var i=t.getProperty("/versioningEnabled");var n=t.getProperty("/dirtyChanges");var s=t.getProperty("/backendDraft");var a=i&&(n||s);t.setProperty("/draftAvailable",a);if(n){t.setProperty("/displayedVersion",e.Number.Draft)}if(!u(r)&&a){r.splice(0,0,{version:e.Number.Draft,type:e.Type.Draft,filenames:[],isPublished:false})}if(u(r)&&!a){r.shift();t.setProperty("/displayedVersion",t.getProperty("/persistedVersion"))}var o=t.getProperty("/displayedVersion")!==t.getProperty("/activeVersion");t.setProperty("/activateEnabled",o)};return t}function f(r,t){if(t!==e.Number.Original&&t!==e.Number.Draft){return r.some(function(e){return e.version===t&&e.isPublished===false})}return false}function v(t){var i;var s=e.Number.Original;var a=t.versions;var o=t.versionsModel;var l=u(a);var d=[];if(a.length>0){i=a[0].version}else{i=e.Number.Original}a.forEach(function(r){if(r.version===e.Number.Draft){r.type=e.Type.Draft;r.isPublished=false;d=r.filenames}else if(s===e.Number.Original){r.type=e.Type.Active;s=r.version}else{r.type=e.Type.Inactive}});if(o){o.setProperty("/publishVersionEnabled",f(a,i));o.setProperty("/versioningEnabled",t.versioningEnabled);o.setProperty("/versions",a);o.setProperty("/backendDraft",l);o.setProperty("/dirtyChanges",false);o.setProperty("/draftAvailable",l);o.setProperty("/activateEnabled",l);o.setProperty("/activeVersion",s);o.setProperty("/persistedVersion",i);o.setProperty("/displayedVersion",i);o.setProperty("/draftFilenames",d);o.updateBindings(true)}else{var v=r.getByReference(t.reference);return new n({publishVersionEnabled:f(a,v.version||i),versioningEnabled:t.versioningEnabled,versions:a,backendDraft:l,dirtyChanges:false,draftAvailable:l,activateEnabled:l,activeVersion:s,persistedVersion:v.version||i,displayedVersion:v.version||i,draftFilenames:d})}return o}function u(r){return r.some(function(r){return r.version===e.Number.Draft})}function p(e,r){e.setProperty("/backendDraft",false);e.setProperty("/dirtyChanges",false);e.setProperty("/draftAvailable",false);e.setProperty("/activateEnabled",false);e.setProperty("/displayedVersion",r);e.setProperty("/persistedVersion",r);e.updateBindings(true)}var y={};y.initialize=function(e){var r=e.reference;var n=e.layer;e.limit=l;return t.getInstance().then(function(t){var s=t.isVersioningEnabled(n);if(a&&a[r]&&a[r][n]){return a[r][n]}var o=s?i.versions.load(e):Promise.resolve([]);return o.then(function(r){e.versioningEnabled=s;e.versions=r;return d(e)}).then(function(e){a[r]||={};a[r][n]||={};a[r][n]=e;return a[r][n]})})};y.getVersionsModel=function(e){var r=e.reference;var t=e.layer;if(!y.hasVersionsModel(e)){throw Error(`Versions Model for reference '${r}' and layer '${t}' were not initialized.`)}return a[r][t]};y.hasVersionsModel=function(e){var r=e.reference;var t=e.layer;return!!(a[r]&&a[r][t])};y.clearInstances=function(){a={}};y.updateModelFromBackend=function(e){if(y.hasVersionsModel(e)&&y.getVersionsModel(e).getProperty("/versioningEnabled")){e.limit=l;return i.versions.load(e).then(function(r){var t=y.getVersionsModel(e);e.versioningEnabled=t.getProperty("/versioningEnabled");e.versions=r;e.versionsModel=t;return v(e)})}return undefined};y.onAllChangesSaved=function(r){var t=y.getVersionsModel(r);var i=t.getProperty("/versioningEnabled");var n=t.getProperty("/dirtyChanges");var s=t.getProperty("/draftFilenames");t.setProperty("/draftFilenames",s.concat(r.draftFilenames));t.setProperty("/dirtyChanges",true);t.setProperty("/backendDraft",i&&n||!!r.contextBasedAdaptation);t.updateDraftVersion();t.setProperty("/persistedVersion",e.Number.Draft);t.updateBindings(true)};y.activate=function(r){var t=y.getVersionsModel(r);var n=t.getProperty("/versions");var s=u(n);var a=t.getProperty("/activeVersion");if(r.displayedVersion===a){return Promise.reject("Version is already active")}r.version=r.displayedVersion;return i.versions.activate(r).then(function(r){n.forEach(function(r){r.type=e.Type.Inactive});r.type=e.Type.Active;r.isPublished=false;if(s){n.shift()}n.splice(0,0,r);t.setProperty("/activeVersion",r.version);t.setProperty("/publishVersionEnabled",true);t.setProperty("/draftFilenames",[]);p(t,r.version)})};y.discardDraft=function(e){var r=y.getVersionsModel(e);var t=r.getProperty("/backendDraft");var n=t?i.versions.discardDraft(e):Promise.resolve();return n.then(function(){var i=r.getProperty("/versions");i.shift();let n=r.getProperty("/activeVersion");if(e.discardDraftAndKeepActiveVersion){n=r.getProperty("/displayedVersion")}p(r,n);return{backendChangesDiscarded:t}})};y.publish=function(e){var r=y.getVersionsModel({reference:e.reference,layer:e.layer});return i.versions.publish(e).then(function(t){if(t!=="Error"&&t!=="Cancel"){r.setProperty("/publishVersionEnabled",false);var i=r.getProperty("/versions");var n=false;i.forEach(function(r){if(r.isPublished){return}if(r.version===e.version){n=true}if(n&&!r.isPublished){r.isPublished=true}})}return t})};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/Condenser", ["sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/write/_internal/condenser/classifications/LastOneWins","sap/ui/fl/write/_internal/condenser/classifications/Reverse","sap/ui/fl/write/_internal/condenser/classifications/Update","sap/ui/fl/write/_internal/condenser/UIReconstruction","sap/ui/fl/write/_internal/condenser/Utils","sap/ui/fl/Utils","sap/ui/performance/Measurement"],function(e,t,n,a,s,o,r,i,c,f,l,d,u,p,g,C,h,E,y){"use strict";const _={};const S="unclassified";const I={lastOneWins:u,reverse:p,update:g};const O=["affectedControl","sourceContainer","targetContainer","updateControl"];function N(e,t){const n=e[d.Move];return t.classification===d.Create&&n&&n[n.length-1].targetContainer===t.targetContainer}function D(e,t){return t.classification===d.Move&&e[d.Destroy]}function T(e,t){return t.classification===d.Create&&e[d.Destroy]}async function v(e,t,n,a){if(!D(e,n)&&!T(e,n)){const t=n.classification;if(!e[t]){n.change=a;a.condenserState="select";e[t]=[n]}else{a.condenserState="delete"}e[t][0].updateChange=a}else{a.condenserState="delete"}if(N(e,n)||T(e,n)){if(e[d.Move]){e[d.Move].forEach(e=>{e.change.condenserState="delete"});delete e[d.Move]}if(e[d.Destroy]){e[d.Destroy].forEach(e=>{e.change.condenserState="delete"});delete e[d.Destroy]}}await C.addChange(t,n)}function m(e,t,n){e[t.classification]||={};const a=e[t.classification];I[t.classification].addToChangesMap(a,t,n)}async function A(e,t,n,a,s){e[a.type]||={};const o=e[a.type];if(a.type===h.NOT_INDEX_RELEVANT){m(o,a,s)}else{n.push(s);o[a.targetAggregation]||={};await v(o[a.targetAggregation],t,a,s)}}function R(e,t,n){e[t]||=[];e[t].push(n);n.condenserState="select"}async function w(e,t){let n;let a=false;const s={modifier:o,appComponent:e};try{if(t instanceof l){const c=o.getControlIdBySelector(t.getSelector(),e);const f=r.getElementById(c);if(f){s.view=E.getViewForControl(f);const e=i.getControlIfTemplateAffected(t,f,s);a=e.bTemplateAffected;n=await i.getChangeHandler({flexObject:t,control:e.control,controlType:e.controlType,modifier:s.modifier})}}else{n=await i.getChangeHandler({flexObject:t})}if(typeof n.getCondenserInfo==="function"){const e=await n.getCondenserInfo(t,s);if(e&&a){x(e,t)}return e}}catch(e){return undefined}return undefined}function x(e,t){const n=t.getOriginalSelector();const a=t.getSelector();O.forEach(t=>{if(e[t]&&e[t]===a){e[t]=n}})}function b(e,t,n,s){const o=n.getIdForCondensing(t,s);e[o]||={};if(t&&t.updateControl){const n=t.updateControl;const s=[h.NOT_INDEX_RELEVANT,d.Update,t.uniqueKey];const r=a.get(s,e[n]);if(r){a.set(s,r,e[o]);delete e[n][h.NOT_INDEX_RELEVANT][d.Update][t.uniqueKey]}}return e[o]}async function L(e,t,n,a,s){for(const o of s){await U(e,t,n,a,o)}}async function U(e,t,n,a,s){const o=await w(e,s);j(o,e);const r=b(t,o,s,e);if(o!==undefined){M(o);await A(r,n,a,o,s);if(o.update){V(r,o,s)}}else{R(r,S,s);t[S]=true}}function M(e){if(I[e.classification]){e.type=h.NOT_INDEX_RELEVANT}else{e.type=h.INDEX_RELEVANT}}function j(e,t){O.forEach(n=>{if(e&&e[n]){e[n]=o.getControlIdBySelector(e[n],t)}})}function V(e,t,n){const s=[h.NOT_INDEX_RELEVANT,d.Update,t.uniqueKey];const o=a.get(s,e);if(o){o.change.condenserState="delete";if(n.condenserState==="delete"){return}if(n.isPersisted()){n.condenserState="update"}t.update(n,o.updateContent);n.setState(f.LifecycleState.UPDATED);delete e[h.NOT_INDEX_RELEVANT][d.Update][t.uniqueKey]}}function X(e,a){t(e,(t,s)=>{if(I[t]&&I[t].getChangesFromMap){I[t].getChangesFromMap(e,t).forEach(e=>{a.push(e)})}else if(n(s)){return X(s,a)}else if(Array.isArray(s)){s.forEach(e=>{if(e instanceof c){a.push(e)}else{a.push(e.change)}})}});return a}function q(e){return X(e,[])}function F(e,t){Object.values(e).forEach(e=>{if(n(e)){F(e,t)}else if(Array.isArray(e)){e.forEach(e=>{if(!(e instanceof c)){t.push(e)}})}});return t}function P(e,t){t.sort((t,n)=>e.indexOf(t)-e.indexOf(n))}function B(e,t){t.sort((t,n)=>e.indexOf(t.change)-e.indexOf(n.change))}function K(e,t){const n=e.map(e=>e.getId());t.forEach(t=>{if(n.indexOf(t.getId())===-1){e.push(t)}})}function W(e){for(const t in e){for(const n of["lastOneWins","update"]){const s=a.get([t,h.NOT_INDEX_RELEVANT,n],e);if(s){for(const e of Object.values(s)){if(e.oldestChange?.getRevertData){e.change.setRevertData(e.oldestChange.getRevertData())}}}}}}function H(t,n,a){t.forEach(t=>{const s=t.updateChange;if(s&&!e(s.getContent(),t.change.getContent())&&s.getState()!==f.LifecycleState.NEW){const e=t.change;if(s.getId()!==e.getId()){const t=e.getContent();s.setContent(t);s.setRevertData(e.getRevertData());e.condenserState="delete";n=n.map(t=>{if(t.getId()===e.getId()){return s}return t});const o=t=>{if(t.getId()===e.getId()){return s}return t};a.forEach((e,t)=>{a[t]=e.map(o)})}else{s.setState(f.LifecycleState.UPDATED)}s.condenserState="update"}});return n}_.condense=async function(e,t){y.start("Condenser_overall","Condenser overall - CondenserClass",["sap.ui.fl","Condenser"]);const n={};const a={};const o=[];const r=[];const i=[];t.slice(0).reverse().forEach(e=>{if(e.getState()===f.LifecycleState.DELETED){e.condenserState="delete"}else if(e.canBeCondensed()){i.push(e)}else{r.push(e)}});y.start("Condenser_defineMaps","defining of maps - CondenserClass",["sap.ui.fl","Condenser"]);await L(e,n,a,o,i);y.end("Condenser_defineMaps");W(n);const c=n[S];if(!c){C.compareAndUpdate(n,a)}let l=q(n);if(c){o.forEach(e=>{if(e.condenserState!=="update"){e.condenserState="select"}});K(l,o)}l=l.concat(r);P(t,l);if(!c){y.start("Condenser_handleIndexRelatedChanges","handle index related changes - CondenserClass",["sap.ui.fl","Condenser"]);let e=true;let r=F(n,[]);B(t,r);let i;try{y.start("Condenser_sort","sort index related changes - CondenserClass",["sap.ui.fl","Condenser"]);i=C.sortIndexRelatedChanges(a,r)}catch(t){s.error(`Error during Condensing: ${t.message}`,"No Condensing performed for index-relevant changes.");e=false}y.end("Condenser_sort");if(e){l=l.filter(e=>e.condenserState!=="delete");r=r.filter(e=>e.change.condenserState!=="delete");l=H(r,l,i);P(t,l);i.forEach(e=>{C.swapChanges(e,l)})}else{o.forEach(e=>{e.condenserState="select"});K(l,o);P(t,l)}y.end("Condenser_handleIndexRelatedChanges")}y.end("Condenser_overall");return l};return _});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/UIReconstruction", ["sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/ObjectPath","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/write/_internal/condenser/classifications/Create","sap/ui/fl/write/_internal/condenser/classifications/Destroy","sap/ui/fl/write/_internal/condenser/classifications/Move","sap/ui/fl/write/_internal/condenser/Utils"],function(e,n,t,s,i,c,o,r){"use strict";const a={};const f={create:i,destroy:c,move:o};function l(e,t){n(e,(e,s)=>{n(s,(n,i)=>{t(s,e,i,n)})})}function u(e,n,t){e.splice(t,0,e.splice(n,1)[0])}function h(e,n){const t={};l(e,(e,s,i,c)=>{const o=i[r.TARGET_UI];const a=i[r.INITIAL_UI];n.forEach(e=>{const n=o.indexOf(e.affectedControl)>-1||a.indexOf(e.affectedControl)>-1;if(c===e.targetAggregation&&n){t[s]||={};const n=t[s];n[c]||=[];const i=n[c];i.push(e)}})});return t}function d(e){return!e.some(e=>e.classification!==s.Create)}function g(e){return!e.some(e=>r.isUnknown(e))}function I(e){return e.getTargetIndex(e.change)}function E(e){e.sort((e,n)=>{const t=I(e);const s=I(n);return t-s})}function T(e){return!e.some(e=>!r.isUnknown(e))}function p(n,t){let s;if(n.length<t.length){s=t.slice(n.length);if(!T(s)){return false}t=t.slice(0,n.length)}else if(n.length>t.length){s=n.slice(t.length,n.length);if(!T(s)){return false}n=n.slice(0,t.length)}return e(n,t)}function _(e,n,t,s,i){const c={};i.forEach(e=>{const s=e.targetContainer;c[s]||={};const i=c[s];i[n]||=r.initializeArrayWithPlaceholders(0,t.length-1);f[e.classification].simulate(i[n],e,t)});const o=c[e][n];if(p(s,o)){i.forEach(e=>{if(e.sameIndex){e.change.condenserState="delete"}});return true}return false}function A(e,n){function t(e,n){if(I(n)!==e){const t=n.change.getState();n.setTargetIndex(n.change,e);n.change.setState(t);if(n.change.isPersisted()){n.change.condenserState="update"}}}function i(n,i,c){c[r.TARGET_UI].forEach((n,i)=>{if(!r.isUnknown(n)){const c=e[n];const o=c[r.INDEX_RELEVANT];l(o,(e,n,c,o)=>{if(o!==s.Destroy){c.forEach(t.bind(this,i))}})}})}l(n,i)}function U(e,n){l(n,(n,t,s,i)=>{const c=s[r.INITIAL_UI];const o=s[r.TARGET_UI];if(p(c,o)){o.forEach(n=>{const t=e[n];if(t!==undefined){l(t[r.INDEX_RELEVANT],(e,n,t)=>{t.forEach(e=>{e.change.condenserState="delete"})});delete t[r.INDEX_RELEVANT]}});delete n[i]}})}function x(e,n){l(n,(n,s,i,c)=>{const o=i[r.INITIAL_UI];const a=i[r.TARGET_UI];o.forEach((n,s)=>{const i=e[n];if(!i||!t.get([r.INDEX_RELEVANT,c],i)){const e=r.PLACEHOLDER+s;const t=a.indexOf(n);if(t>=0){a[t]=e}}})})}a.swapChanges=function(e,n){const t=e.map(e=>n.indexOf(e)).sort();e.forEach(e=>{n[t.shift()]=e})};a.sortIndexRelatedChanges=function(e,n){const t=[];const s=h(e,n);l(s,(n,s,i,c)=>{const o=e[s][c][r.TARGET_UI];const a=e[s][c][r.INITIAL_UI];let f=true;if(g(o)||d(i)){E(i);f=_(s,c,a,o,i)}else if(!_(s,c,a,o,i)){f=false;let e=i.length;while(e!==0&&!f){let n=0;let t=1;while(t<i.length&&!f){u(i,n,t);f=_(s,c,a,o,i);n++;t++}e--}}if(!f){throw Error(`no correct sorting found for the container: ${s}`)}i=i.filter(e=>e.change.condenserState!=="delete");t.push(i.map(e=>{if(e.revertIndex>-1){e.setIndexInRevertData(e.change,e.revertIndex);e.sourceIndex=e.revertIndex}return e.change}))});return t};a.addChange=async function(e,n){await f[n.classification].addToReconstructionMap(e,n)};a.compareAndUpdate=function(e,n){U(e,n);x(e,n);A(e,n)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/Utils", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element"],function(e,n){"use strict";const t={};t.TARGET_UI="targetUI";t.INITIAL_UI="initialUI";t.PLACEHOLDER="X";t.INDEX_RELEVANT="indexRelevant";t.NOT_INDEX_RELEVANT="notIndexRelevant";function i(e,n){return(Math.max(e,n)||0)+1}t.getInitialUIContainerElementIds=function(e,n,i,r){e[n]||={};const l=e[n];l[i]||={};const s=l[i];s[t.TARGET_UI]||=r;s[t.INITIAL_UI]||=r.slice(0);return s[t.INITIAL_UI]};t.getContainerElementIds=async function(t,i,r,l){const s=n.getElementById(t);const o=r||await e.getAggregation(s,i);return o.map(e=>l?e[l]:e.getId())};t.initializeArrayWithPlaceholders=function(e,n){const r=i(n,e);return Array(r).fill(t.PLACEHOLDER).map((e,n)=>e+n)};t.extendArrayWithPlaceholders=function(e,n,r){const l=i(n,r);if(e.length<l){let n;for(let i=e.length;i<=l;i++){n=t.PLACEHOLDER+e.length;e.splice(e.length,0,n)}}};t.extendElementsArray=function(e,n,i,r){t.extendArrayWithPlaceholders(e,n,i);const l=e.indexOf(r);const s=e.indexOf(t.PLACEHOLDER+n);if(l!==n&&n!==undefined){if(l>=0){t.shiftElement(e,l,n)}else if(s>-1){e[s]=r}else if(t.isUnknown(e[n])){e[n]=r}}};t.shiftElement=function(e,n,t){e.splice(t,0,e.splice(n,1)[0])};t.isUnknown=function(e){if(e!==undefined&&e.indexOf(t.PLACEHOLDER)===0){const n=e.slice(1,e.length);const t=parseInt(n);if(isNaN(t)){return false}return true}return false};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Create", ["sap/ui/core/Element","sap/ui/fl/write/_internal/condenser/Utils"],function(t,e){"use strict";return{async addToReconstructionMap(n,a){const o=t.getElementById(a.affectedControl);const r=a.targetAggregation||o&&o.sParentAggregationName;const i=await e.getContainerElementIds(a.targetContainer,r,a.customAggregation,a.affectedControlIdProperty);const g=e.getInitialUIContainerElementIds(n,a.targetContainer,a.targetAggregation,i);const s=g.indexOf(a.affectedControl);if(s>-1){g.splice(s,1)}},simulate(t,e){t.splice(e.getTargetIndex(e.change),0,e.affectedControl)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Destroy", ["sap/ui/fl/write/_internal/condenser/Utils"],function(e){"use strict";return{async addToReconstructionMap(t,n){const o=await e.getContainerElementIds(n.targetContainer,n.targetAggregation,n.customAggregation,n.affectedControlIdProperty);const r=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,o);if(r.length-1<n.sourceIndex){while(r.length-1<n.sourceIndex){const t=r.length;r.splice(r.length,0,e.PLACEHOLDER+t)}r[n.sourceIndex]=n.affectedControl}else{r.splice(n.sourceIndex,0,n.affectedControl)}},simulate(t,n,o){let r=t.indexOf(n.affectedControl);if(r===-1){const i=e.PLACEHOLDER+o.indexOf(n.affectedControl);r=t.indexOf(i)}n.revertIndex=r;if(r>-1){t.splice(r,1)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/LastOneWins", [],function(){"use strict";return{addToChangesMap(e,n,t){if(!e[n.uniqueKey]){n.change=t;e[n.uniqueKey]=n;t.condenserState="select"}else{e[n.uniqueKey].oldestChange=t;t.condenserState="delete"}},getChangesFromMap(e,n){return Object.values(e[n]).map(e=>e.change)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Move", ["sap/ui/fl/write/_internal/condenser/Utils"],function(e){"use strict";return{async addToReconstructionMap(t,n){const[r,o]=await Promise.all([e.getContainerElementIds(n.sourceContainer,n.sourceAggregation,n.customAggregation,n.affectedControlIdProperty),e.getContainerElementIds(n.targetContainer,n.targetAggregation,n.customAggregation,n.affectedControlIdProperty)]);let a;let i;if(n.targetContainer===n.sourceContainer&&n.targetAggregation===n.sourceAggregation){a=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,o);i=a.indexOf(n.affectedControl);e.shiftElement(a,i,n.sourceIndex)}else{a=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,o);i=a.indexOf(n.affectedControl);a.splice(i,1);a=e.getInitialUIContainerElementIds(t,n.sourceContainer,n.sourceAggregation,r);a.splice(n.sourceIndex,0,n.affectedControl)}},simulate(t,n,r){const o=n.affectedControl;const a=r.indexOf(o);e.extendElementsArray(t,a,undefined,o);const i=t.indexOf(o);const g=n.getTargetIndex(n.change);if(a===-1){t.splice(g,0,o)}else{t.splice(g,0,t.splice(i,1)[0])}n.sameIndex=i===g;n.revertIndex=i}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Reverse", ["sap/base/util/each"],function(e){"use strict";return{addToChangesMap(e,n,t){e[n.uniqueKey]||=[];e[n.uniqueKey].push(t)},getChangesFromMap(n,t){var a=[];e(n[t],function(e,n){n.reverse();var t;n.forEach(function(e,a){if(t&&t.getChangeType()!==e.getChangeType()){t=null;n[a].condenserState="delete";n[a-1].condenserState="delete"}else{t=e;if(a>0){n[a-1].condenserState="delete"}n[a].condenserState="select"}});if(t){a.push(t)}});return a}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Update", [],function(){"use strict";return{addToChangesMap(e,n,t){if(!e[n.uniqueKey]){n.change=t;e[n.uniqueKey]=n;t.condenserState="select"}else{e[n.uniqueKey].oldestChange=t;t.condenserState="delete"}},getChangesFromMap(e,n){return Object.values(e[n]).map(e=>e.change)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/FlexObjectManager", ["sap/base/util/restricted/_omit","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/changes/UIChangesState","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions","sap/ui/fl/LayerUtils","sap/ui/fl/requireAsync","sap/ui/fl/Utils"],function(e,t,n,r,a,c,i,l,s,o,f,p,u,g,y,d,F,x){"use strict";const h={};function C(e){const t=[];const n=f.getCompVariantsMap(e.reference);for(const e in n){const r=n[e];for(const e in r.byId){t.push(r.byId[e])}}return d.filterChangeOrChangeDefinitionsByCurrentLayer(t,e.currentLayer)}function O(e){const t=f.getCompVariantsMap(e.reference);const n=f.getInitialNonFlCompVariantData(e.reference);if(n){Object.keys(n).forEach(function(e){t._initialize(e,n[e].variants,n[e].controlId);l.merge(e,t[e],n[e].standardVariant)})}}function b(e){var t=p.getFlexReferenceForControl(e.selector);return u.persistAll(t)}function j(e,t){if(t.isValidForDependencyMap()){c.removeChangeFromMap(o.getLiveDependencyMap(e),t.getId());c.removeChangeFromDependencies(o.getLiveDependencyMap(e),t.getId())}}async function S(e,t){const n=await F("sap/ui/fl/FlexControllerFactory");var r=n.createForSelector(e.selector);return r.saveAll(t,e.skipUpdateCache,e.draft,e.layer,e.removeOtherLayerChanges,e.condenseAnyLayer)}function m(e){return typeof e.isA==="function"&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")?e:r.createFromFileContent(e)}h.filterHiddenFlexObjects=function(e,t){const n=s.filterHiddenFlexObjects(e,t);return u.filterHiddenFlexObjects(n,t)};h.getFlexObjects=async function(e){e.reference=p.getFlexReferenceForControl(e.selector);if(e.invalidateCache){await f.update(e);O(e)}let t=i.getVariantIndependentUIChanges(e.reference);if(!e.includeCtrlVariants){t=t.concat(s.getInitialUIChanges({reference:e.reference,includeDirtyChanges:true}))}else if(!e.onlyCurrentVariants){t=t.concat(s.getVariantDependentFlexObjects(e.reference))}else{t=t.concat(s.getAllCurrentFlexObjects({reference:e.reference}))}if(e.includeManifestChanges){t=t.concat(f.getAppDescriptorChanges(e.reference))}if(e.includeAnnotationChanges){t=t.concat(f.getAnnotationChanges(e.reference))}if(e.currentLayer){t=t.filter(t=>t.getLayer()===e.currentLayer)}return t.concat(C(e))};h.hasDirtyFlexObjects=function(e){var t=p.getFlexReferenceForSelector(e.selector);return o.getDirtyFlexObjects(t).length>0||u.hasDirtyChanges(t)};h.addDirtyFlexObjects=function(e,t){return f.addDirtyFlexObjects(e,t.map(m))};h.removeDirtyFlexObjects=function(e){const n=[].concat(e.layers||[]);const r=o.getDirtyFlexObjects(e.reference);const a=r.filter(r=>{let a=true;if(n.length&&!n.includes(r.getLayer())){return false}if(e.generator&&r.getSupportInformation().generator!==e.generator){return false}if(e.control){const n=t.getControlIdBySelector(r.getSelector(),e.component);a=e.control.getId()===n}if(e.changeTypes){a&&=e.changeTypes.includes(r.getChangeType())}return a});return f.removeDirtyFlexObjects(e.reference,a)};h.saveFlexObjects=async function(t){var n=x.getAppComponentForSelector(t.selector);t.reference=p.getFlexReferenceForControl(t.selector);await b(t);await S(t,n);if(t.version!==undefined&&y.hasVersionsModel(t)){var r=y.getVersionsModel(t);t.version=r.getProperty("/displayedVersion")}if(t.layer){t.currentLayer=t.layer}t.componentId=n.getId();t.invalidateCache=true;return h.getFlexObjects(e(t,"skipUpdateCache"))};h.deleteFlexObjects=function(e){const t=o.getDirtyFlexObjects(e.reference);const n=[];const r=[];e.flexObjects.forEach(function(c){if(t.indexOf(c)>-1&&c.getState()===a.LifecycleState.NEW){r.push(c)}else{c.markForDeletion();n.push(c)}j(e.reference,c)});f.removeDirtyFlexObjects(e.reference,r);const c=h.addDirtyFlexObjects(e.reference,n);if(!r.length&&!c.length){const t=f.getFlexObjectsDataSelector();t.checkUpdate({reference:e.reference})}};h.restoreDeletedFlexObjects=function(e){const t=e.flexObjects.filter(e=>e.getState()===a.LifecycleState.DELETED||e.getState()===a.LifecycleState.NEW);t.forEach(e=>{e.restorePreviousState()});const n=t.filter(e=>e.getState()!==a.LifecycleState.PERSISTED);h.addDirtyFlexObjects(e.reference,n)};h.resetFlexObjects=async function(e){const r=p.getFlexReferenceForControl(e.appComponent);const a=await h.getFlexObjects({selector:e.appComponent,currentLayer:e.layer,includeCtrlVariants:true});const c={reference:r,layer:e.layer,changes:a};if(e.generator){c.generator=e.generator}if(e.selectorIds){c.selectorIds=e.selectorIds}if(e.changeTypes){c.changeTypes=e.changeTypes}const i=await g.reset(c);if(e.selectorIds||e.changeTypes||e.generator){const c=[];if(i?.response?.length>0){i.response.forEach(function(e){c.push(e.fileName)})}const l=a.filter(function(e){return c.indexOf(e.getId())!==-1});f.updateStorageResponse(r,l.map(e=>({flexObject:e.convertToFileContent(),type:"delete"})));if(l.length){await n.revertMultipleChanges([...l].reverse(),{appComponent:e.appComponent,modifier:t,reference:r})}}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState", ["sap/base/util/restricted/_omit","sap/base/util/restricted/_pick","sap/ui/core/Element","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/CompVariantRevertData","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/RevertData","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UpdatableChange","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions"],function(e,t,n,a,r,i,o,s,c,p,f,u,l,d,g,v,y,C){"use strict";function S(e,t){var n=h("/draftFilenames",t);if(n){return e.getState()===p.LifecycleState.NEW||n.includes(e.getId())}return true}function h(e,t){var t={reference:t.reference,layer:t.layer};if(C.hasVersionsModel(t)){return C.getVersionsModel(t).getProperty(e)}return undefined}function m(e,t){var n=e.getFlexObjectMetadata?e.getFlexObjectMetadata().changeType:e.getChangeType();if(!["defaultVariant","updateVariant"].includes(n)){return false}var a=e.getLayer()===t.layer;var r=e.getFlexObjectMetadata().packageName;var i=!r||r==="$TMP";return a&&i&&S(e,t)}function V(e,t){if(t.isVariant&&t.isVariant()){return e.variants}var n=t.getChangeType();switch(n){case"defaultVariant":return e.defaultVariants;case"standardVariant":return e.standardVariants;default:return e.changes}}function x(e,t){for(var n=0;n<e.length;n++){if(e[n].fileName===t.fileName){e.splice(n,1,t);break}}}function O(e,t,n,a){return y.update({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:n}).then(function(t){if(t&&t.response){e.setResponse(t.response);if(n){C.onAllChangesSaved({reference:t.response.reference,layer:t.response.layer,draftFilenames:t.response.fileName})}}else{e.setState(p.LifecycleState.PERSISTED)}}).then(function(){var n=V(t.changes.comp,e);var r=e.convertToFileContent();d.getFlexObjectsDataSelector().checkUpdate({reference:a});x(n,r);return r})}function I(e,t){for(var n=e.length-1;n>=0;n--){var a=e[n].fileName||e[n].getId()&&e[n].getId();if((a||e[n].getId())===t){e.splice(n,1);break}}}function D(e,t){delete t.byId[e.getId()];if(e.getChangeType()==="standardVariant"){t.standardVariantChange=undefined}else{I(V(t,e),e.getId())}}function b(e,t,n,a,r){var i=e.convertToFileContent();return y.remove({flexObject:i,layer:e.getLayer(),transport:e.getRequest(),parentVersion:a}).then(function(){D(e,t)}).then(C.updateModelFromBackend.bind(this,{reference:i.reference,layer:i.layer})).then(function(){I(V(n.changes.comp,e),i.fileName);d.getFlexObjectsDataSelector().checkUpdate({reference:r});return i})}function T(e){var t={};if(typeof e.texts==="object"){Object.keys(e.texts).forEach(function(n){t[n]={value:e.texts[n],type:"XFLD"}})}return t}function E(e){return e&&[p.LifecycleState.NEW,p.LifecycleState.UPDATED,p.LifecycleState.DELETED].includes(e.getState())}function U(e){return e.variants.concat(e.changes).concat(e.defaultVariants).concat(e.standardVariantChange)}function F(e){if(e.layer){return e.layer}if(e.isUserDependent){return a.USER}var t=new URLSearchParams(window.location.search).get("sap-ui-layer")||"";t=t.toUpperCase();if(t){return t}if(!e.fileType==="variant"){return a.CUSTOMER}var n=v.getInstanceOrUndef().isPublicLayerAvailable();return n?a.PUBLIC:a.CUSTOMER}function L(e){var t=d.getCompVariantsMap(e.reference)._getOrCreate(e.persistencyKey);return t.byId[e.id]}function R(e){if(e instanceof i){e.removeAllRevertData()}}function N(e,t){e.storeExecuteOnSelection(t.executeOnSelection);e.storeFavorite(t.favorite);e.storeContexts(t.contexts);e.storeName(t.name);e.storeContent(t.content||e.getContent());return e}function A(e,t){e.setExecuteOnSelection(t.executeOnSelection);e.setFavorite(t.favorite);e.setContexts(t.contexts);e.setName(t.name);e.setContent(t.content||e.getContent());return e}function M(e){if(e&&e.getRevertData().length){let t;e.getRevertData().reverse().some(e=>{t=e.getContent();return t.previousAction===w.updateActionType.SAVE});N(e,{name:t.previousName,content:t.previousContent,favorite:t.previousFavorite,executeOnSelection:t.previousExecuteOnSelection,contexts:t.previousContexts});e.setState(t.previousState)}}function j(e){if(e.layer===a.VENDOR){e.support={user:"SAP"}}else if(v.getInstanceOrUndef()&&v.getInstanceOrUndef().getUserId()){e.support={user:v.getInstanceOrUndef().getUserId()}}}function _(e){const t=d.getCompVariantsMap(e);const a=[];if(t){Object.values(t).forEach(function(e){const t=e.controlId&&n.getElementById(e.controlId);if(t){a.push(t)}})}return a}var w={};w.checkSVMControlsForDirty=function(e){return _(e).some(e=>e.getModified())};w.setDefault=function(e){var t={defaultVariantName:e.defaultVariantId};e.layer||=new URLSearchParams(window.location.search).get("sap-ui-layer")||a.USER;let n=l.getDefaultChanges(e).slice(-1)[0];if(!n||!m(n,e)){var i=d.getCompVariantsMap(e.reference)._getOrCreate(e.persistencyKey);var o="defaultVariant";var p={fileName:r.createDefaultFileName(o),fileType:"change",changeType:o,layer:e.layer,content:t,namespace:r.createNamespace(e,"changes"),reference:e.reference,selector:{persistencyKey:e.persistencyKey},support:e.support||{}};p.adaptationId=e.changeSpecificData?.adaptationId;p.support.generator||=`CompVariantState.${o}`;n=s.createFromFileContent(p,f);i.byId[n.getId()]=n;n.addRevertInfo(new c({type:w.operationType.NewChange}));d.addDirtyFlexObjects(e.reference,[n])}else{n.addRevertInfo(new c({type:w.operationType.ContentUpdate,content:{previousState:n.getState(),previousContent:n.getContent()}}));n.setContent(t)}return n};w.revertSetDefaultVariantId=function(e){const t=l.getDefaultChanges(e);const n=t?.slice(-1)[0];const a=n.popLatestRevertInfo();if(a.getType()===w.operationType.ContentUpdate){n.setContent(a.getContent().previousContent);n.setState(a.getContent().previousState)}else{n.setState(p.LifecycleState.DELETED);t.pop()}};w.addVariant=function(t){if(!t){return undefined}const n=t.changeSpecificData;n.layer=F(n);n.changeType=n.type;n.texts=T(n);j(n);const r={...n,...e(t,"changeSpecificData")};const i=s.createCompVariant(r);const o=d.getCompVariantsMap(t.reference);const c=o._getOrCreate(t.persistencyKey);c.variants.push(i);c.byId[i.getId()]=i;d.addDirtyFlexObjects(t.reference,[i]);if(n.layer!==a.USER&&n.layer!==a.PUBLIC){t.id=t.control.getCurrentVariantId();M(L(t))}return i};w.updateVariant=function(e){function n(t,n){var a=t.getLayer()===n;var r=t.getFlexObjectMetadata().packageName;var i=!r||r==="$TMP";var o=t.getChanges().some(function(e){return e.getLayer()===n});return t.getPersisted()&&a&&i&&!o&&S(t,e)}function r(t){return t.getChanges().reverse().find(function(t){return t.getChangeType()==="updateVariant"&&m(t,e)})}function i(e,t,n,a){var r={type:n,change:a,content:{previousState:t.getState(),previousContent:t.getContent(),previousFavorite:t.getFavorite(),previousVisible:t.getVisible(),previousExecuteOnSelection:t.getExecuteOnSelection(),previousContexts:t.getContexts(),previousName:t.getName(),previousAction:e.action}};t.addRevertData(new o(r))}function c(e,t){i(e,t,w.operationType.ContentUpdate);if(e.executeOnSelection!==undefined){t.storeExecuteOnSelection(e.executeOnSelection)}if(e.layer===a.PUBLIC){t.storeFavorite(false)}else if(e.favorite!==undefined){t.storeFavorite(e.favorite)}if(e.visible!==undefined){t.storeVisible(e.visible)}if(e.contexts){t.storeContexts(e.contexts)}if(e.name){t.storeName(e.name)}if(e.transportId){t.setRequest(e.transportId)}t.storeContent(e.content||t.getContent())}function p(e,n,a){const r=a.getRevertData()||[];const o={...a.getContent()};const s={previousContent:{...o},previousState:a.getState(),change:t(e,["favorite","visible","executeOnSelection","contexts","content","name"])};r.push(s);a.setRevertData(r);if(e.executeOnSelection!==undefined){o.executeOnSelection=e.executeOnSelection}if(e.favorite!==undefined){o.favorite=e.favorite}if(e.visible!==undefined){o.visible=e.visible}if(e.contexts){o.contexts=e.contexts}if(e.content){o.variantContent=e.content}if(e.adaptationId){a.setAdaptationId(e.adaptationId)}if(e.name){a.setText("variantName",e.name)}a.setContent(o);if(e.transportId){a.setRequest(e.transportId)}i(e,n,w.operationType.UpdateVariantViaChangeUpdate,a);u.applyChangeOnVariant(n,a)}function f(e,t){function n(t){var n=d.getCompVariantsMap(e.reference);var a=t.getSelector().persistencyKey;n[a].changes.push(t);n[a].byId[t.getId()]=t;d.addDirtyFlexObjects(e.reference,[t])}var a={};["favorite","visible","executeOnSelection","contexts"].forEach(function(t){if(e[t]!==undefined){a[t]=e[t]}});if(e.content!==undefined){a.variantContent=e.content}var r=s.createUIChange({changeType:"updateVariant",layer:g,fileType:"change",reference:e.reference,packageName:e.packageName,content:a,selector:{persistencyKey:e.persistencyKey,variantId:t.getVariantId()}});const o=e.adaptationId||e?.changeSpecificData?.adaptationId;if(o){r.setAdaptationId(o)}if(e.name){r.setText("variantName",e.name,"XFLD",true)}if(e.transportId){r.setRequest(e.transportId)}n(r);i(e,t,w.operationType.NewChange,r);u.applyChangeOnVariant(t,r)}var l=L(e);var g=F(e);e.layer||=g;if(e.forceCreate){f(e,l)}else if(n(l,g)){c(e,l)}else{var v=r(l);if(v){p(e,l,v)}else{f(e,l)}}return l};w.discardVariantContent=function(e){var t=L(e);var n=t.getRevertData();if(n.length!==0){var a=n.slice().reverse().some(function(t){e.layer=t.getChange()?.getLayer();if(t.getContent().previousAction===w.updateActionType.SAVE){e.content=t.getContent().previousContent;e.action=w.updateActionType.DISCARD;return true}});if(!a){e.content=n[0].getContent().previousContent;e.action=w.updateActionType.DISCARD}w.updateVariant(e)}return t};w.updateActionType={UPDATE:"update",SAVE:"save",DISCARD:"discard",UPDATE_METADATA:"update_metadata"};w.operationType={StateUpdate:"StateUpdate",ContentUpdate:"ContentUpdate",NewChange:"NewChange",UpdateVariantViaChange:"UpdateVariantViaChange",UpdateVariantViaChangeUpdate:"UpdateVariantViaChangeUpdate"};w.removeVariant=function(e){var t=L(e);var n=t.getState();if(!e.revert){var a=new o({type:w.operationType.StateUpdate,content:{previousState:n}});t.addRevertData(a)}t.markForDeletion();return t};w.revert=function(e){function n(t){var n=t.getSelector().persistencyKey;var a=d.getCompVariantsMap(e.reference);delete a[n].byId[t.getId()];a[n].changes=a[n].changes.filter(function(e){return e!==t});d.removeDirtyFlexObjects(e.reference,[t])}var a=L(e);var r=a.getRevertData().pop();a.removeRevertData(r);var i=r.getContent();var o;switch(r.getType()){case w.operationType.ContentUpdate:N(a,{name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts,...t(e,["reference","persistencyKey","id"])});break;case w.operationType.NewChange:o=r.getChange();a.removeChange(o);n(o);A(a,{name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts,...t(e,["reference","persistencyKey","id"])});break;case w.operationType.UpdateVariantViaChangeUpdate:o=r.getChange();A(a,{...{name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts},...t(e,["reference","persistencyKey","id"])});var s=o.getRevertData().pop();o.setContent(s.previousContent);o.setState(s.previousState);break;case w.operationType.StateUpdate:default:break}a.setState(i.previousState);return a};w.overrideStandardVariant=function(e){var t=d.getCompVariantsMap(e.reference)[e.persistencyKey];var n=t.byId[t.standardVariant.getVariantId()];n.setExecuteOnSelection(!!e.executeOnSelection);var a=n.getChanges();n.removeAllChanges();a.forEach(function(e){u.applyChangeOnVariant(n,e)})};w.persist=async function(e){function t(t,n,r){if(t.getLayer()===a.PUBLIC){t.setFavorite(false)}return y.write({flexObjects:[t.convertToFileContent()],layer:t.getLayer(),transport:t.getRequest(),isLegacyVariant:t.isVariant&&t.isVariant(),parentVersion:r}).then(function(e){if(e&&e.response&&e.response[0]){t.setResponse(e.response[0]);if(r){C.onAllChangesSaved({reference:e.response[0].reference,layer:e.response[0].layer,draftFilenames:[e.response[0].fileName]})}}else{t.setState(p.LifecycleState.PERSISTED)}}).then(function(){const a=t.convertToFileContent();V(n.changes.comp,t).push(a);d.getFlexObjectsDataSelector().checkUpdate({reference:e.reference});return a})}function n(n,a,r,i){switch(n.getState()){case p.LifecycleState.NEW:R(n);return t(n,r,i);case p.LifecycleState.UPDATED:R(n);return O(n,r,i,e.reference);case p.LifecycleState.DELETED:if(n._sPreviousState!==p.LifecycleState.NEW){R(n);return b(n,a,r,i,e.reference)}return Promise.resolve();default:return undefined}}const r=e.reference;const i=e.persistencyKey;const o=d.getCompVariantsMap(r);const s=o._getOrCreate(i);const c=l.getDefaultChanges({reference:e.reference,persistencyKey:e.persistencyKey});const f=[...U(s),...c];const u=await d.getStorageResponse(r);const v=f.filter(E);const S=v.map(function(e,t){if(t===0){const t=h("/persistedVersion",{layer:e.getLayer(),reference:e.getFlexObjectMetadata().reference});return n(e,s,u,t).then(function(){const e=v.map(function(e,a){if(a!==0){const a=t?g.Number.Draft:undefined;return n(e,s,u,a)}return undefined});return Promise.all(e)})}return undefined});return Promise.all(S)};w.persistAll=async function(t){const n=e(d.getCompVariantsMap(t),"_getOrCreate","_initialize");const a=[];const r=_(t);for(const e of Object.keys(n)){const n=await w.persist({reference:t,persistencyKey:e});a.push(n)}r.forEach(e=>{e.setModified(false)});return a};w.hasDirtyChanges=function(e){var t=d.getCompVariantsMap(e);var n=[];for(var a in t){var r=t[a];for(var i in r.byId){n.push(r.byId[i])}}return n.some(function(e){return e.getLayer()&&e.getState()!==p.LifecycleState.PERSISTED&&e.getVariantId?.()!=="*standard*"&&e.getState()!==p.LifecycleState.DELETED})};w.filterHiddenFlexObjects=function(t,n){const a=e(d.getCompVariantsMap(n),"_getOrCreate","_initialize");const r=[];for(const e in a){a[e].variants.forEach(e=>r.push(e.getId()))}return t.filter(e=>{if(e.getFileType()==="change"){if(e.getChangeType()==="updateVariant"){return r.includes(e.getSelector().variantId)}if(e.getChangeType()==="defaultVariant"){return!e.getContent().defaultVariantName||r.includes(e.getContent().defaultVariantName)}}return true})};return w});
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser","variants/context"],"applicationVersion":{"version":"1.136.0"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.136","libs":{"sap.ui.core":{"minVersion":"1.136.0"},"sap.m":{"minVersion":"1.136.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"],"elements":[],"types":[],"interfaces":[]}}}}'
},"sap/ui/fl/library-preload");
sap.ui.loader.config({bundlesUI5:{
"sap/ui/fl/library-preload-apply.js":['sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil.js','sap/ui/fl/apply/_internal/changes/descriptor/Registration.js','sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewDataSource.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewOutbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddTechnicalAttributes.js','sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource.js','sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeOutbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne.js','sap/ui/fl/apply/_internal/changes/descriptor/app/SetAch.js','sap/ui/fl/apply/_internal/changes/descriptor/app/SetDescription.js','sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle.js','sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract.js','sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetCloudDevAdaptationStatus.js','sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/ChangeModel.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version.js','sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector.js','sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils.js','sap/ui/fl/apply/_internal/extensionPoint/Processor.js','sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState.js','sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState.js','sap/ui/fl/apply/api/AnnotationChangeHandlerAPI.js','sap/ui/fl/apply/api/SmartVariantManagementApplyAPI.js','sap/ui/fl/apply/api/UI2PersonalizationApplyAPI.js','sap/ui/fl/transport/TransportDialog.js','sap/ui/fl/transport/TransportSelection.js','sap/ui/fl/util/DescriptorChangeCheck.js','sap/ui/fl/util/IFrame.flexibility.js','sap/ui/fl/util/changePropertyValueByPath.js','sap/ui/fl/write/_internal/connectors/Utils.js','sap/ui/fl/write/_internal/transport/TransportDialog.js','sap/ui/fl/write/_internal/transport/TransportSelection.js','sap/ui/fl/write/_internal/transport/Transports.js'],
"sap/ui/fl/library-preload-write.js":['sap/ui/fl/FakeLrepConnector.js','sap/ui/fl/FakeLrepConnectorLocalStorage.js','sap/ui/fl/FakeLrepConnectorSessionStorage.js','sap/ui/fl/FakeLrepLocalStorage.js','sap/ui/fl/descriptorRelated/Utils.js','sap/ui/fl/descriptorRelated/api/DescriptorChange.js','sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory.js','sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory.js','sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory.js','sap/ui/fl/util/resolveBinding.js','sap/ui/fl/variants/VariantManager.js','sap/ui/fl/write/_internal/SaveAs.js','sap/ui/fl/write/_internal/appVariant/AppVariant.js','sap/ui/fl/write/_internal/appVariant/AppVariantFactory.js','sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange.js','sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory.js','sap/ui/fl/write/_internal/connectors/BackendConnector.js','sap/ui/fl/write/_internal/connectors/BtpServiceConnector.js','sap/ui/fl/write/_internal/connectors/JsObjectConnector.js','sap/ui/fl/write/_internal/connectors/KeyUserConnector.js','sap/ui/fl/write/_internal/connectors/LocalStorageConnector.js','sap/ui/fl/write/_internal/connectors/LrepConnector.js','sap/ui/fl/write/_internal/connectors/NeoLrepConnector.js','sap/ui/fl/write/_internal/connectors/ObjectPathConnector.js','sap/ui/fl/write/_internal/connectors/ObjectStorageConnector.js','sap/ui/fl/write/_internal/connectors/PersonalizationConnector.js','sap/ui/fl/write/_internal/connectors/SessionStorageConnector.js','sap/ui/fl/write/_internal/controlVariants/ControlVariantWriteUtils.js','sap/ui/fl/write/_internal/delegates/ODataV2ReadDelegate.js','sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate.js','sap/ui/fl/write/_internal/extensionPoint/Processor.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory.js','sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation.js','sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/UriParser.js','sap/ui/fl/write/_internal/fieldExtensibility/Utils.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired.js','sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState.js','sap/ui/fl/write/_internal/flexState/changes/UIChangeManager.js','sap/ui/fl/write/api/Adaptations.js','sap/ui/fl/write/api/AppVariantWriteAPI.js','sap/ui/fl/write/api/BusinessNetworkAPI.js','sap/ui/fl/write/api/ChangesWriteAPI.js','sap/ui/fl/write/api/ContextBasedAdaptationsAPI.js','sap/ui/fl/write/api/ContextSharingAPI.js','sap/ui/fl/write/api/ControlPersonalizationWriteAPI.js','sap/ui/fl/write/api/FeaturesAPI.js','sap/ui/fl/write/api/FieldExtensibility.js','sap/ui/fl/write/api/LocalResetAPI.js','sap/ui/fl/write/api/PersistenceWriteAPI.js','sap/ui/fl/write/api/ReloadInfoAPI.js','sap/ui/fl/write/api/SACIntegrationUpdateVariant.js','sap/ui/fl/write/api/SmartBusinessWriteAPI.js','sap/ui/fl/write/api/SmartVariantManagementWriteAPI.js','sap/ui/fl/write/api/TranslationAPI.js','sap/ui/fl/write/api/UI2PersonalizationWriteAPI.js','sap/ui/fl/write/api/VersionsAPI.js','sap/ui/fl/write/api/connectors/FileListBaseConnector.js','sap/ui/fl/write/api/connectors/ObjectStorageConnector.js','sap/ui/fl/write/connectors/BaseConnector.js']
}});
//# sourceMappingURL=library-preload.js.map
