/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/initial/_internal/Storage","sap/ui/fl/Utils","sap/base/Log"],function(e,t,n){"use strict";function o(e){if(e&&e.logonUser){return Promise.resolve(e.logonUser)}var o=t.getUshellContainer();if(o){return t.getUShellService("UserInfo").then(function(e){var t=e.getUser();return t&&t.getId()}).catch(function(e){n.error(`Error getting service from Unified Shell: ${e.message}`)})}return Promise.resolve()}var r=function(e){if(!e){throw new Error("no flex settings provided")}this._oSettings=e};r.attachEvent=function(e,t){r._oEventProvider.attachEvent(e,t)};r.detachEvent=function(e,t){r._oEventProvider.detachEvent(e,t)};r.getInstance=function(){if(r._instance){return Promise.resolve(r._instance)}if(r._oLoadSettingsPromise){return r._oLoadSettingsPromise}return r._loadSettings()};r._loadSettings=function(){var t;var i=e.loadFeatures().then(function(e){t=e;return o(t)}).then(function(e){if(!t){n.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");t={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isVariantPersonalizationEnabled:true,isAnnotationChangeEnabled:true,isAtoAvailable:false,isAtoEnabled:false,isAppVariantSaveAsEnabled:false,isContextSharingEnabled:true,isContextBasedAdaptationEnabled:false,isCondensingEnabled:false,isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isVariantAdaptationEnabled:false,isVariantAuthorNameAvailable:false,isSeenFeaturesAvailable:false,versioning:{},_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false}}t.userId=e;return r._storeInstance(t)});r._oLoadSettingsPromise=i;return i};r._storeInstance=function(e){r._instance||=new r(e);return r._instance};r.getInstanceOrUndef=function(){return r._instance};r.getDefaultLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,PUBLIC:false,USER:false}};r.getDeveloperModeLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,PUBLIC:false,USER:false}};r.prototype._getBooleanProperty=function(e){return this._oSettings[e]||false};r.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser")};r.prototype.isKeyUserTranslationEnabled=function(){return this._getBooleanProperty("isKeyUserTranslationEnabled")};r.prototype.isPublicLayerAvailable=function(){return this._getBooleanProperty("isPublicLayerAvailable")};r.prototype.isVariantAdaptationEnabled=function(){return this._getBooleanProperty("isVariantAdaptationEnabled")};r.prototype.isAppVariantSaveAsEnabled=function(){return!this.isContextBasedAdaptationEnabled()&&this._getBooleanProperty("isAppVariantSaveAsEnabled")};r.prototype.isContextBasedAdaptationEnabled=function(){var e=new URLSearchParams(window.location.search);var t=e.get("sap-ui-xx-rta-adaptations");return t==="true"||this._getBooleanProperty("isContextBasedAdaptationEnabled")};r.prototype.isVersioningEnabled=function(e){return!!(this._oSettings.versioning[e]||this._oSettings.versioning.ALL)};r.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable")};r.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled")};r.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable")};r.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem")};r.prototype.isVariantSharingEnabled=function(){return this._getBooleanProperty("isVariantSharingEnabled")};r.prototype.isPublicFlVariantEnabled=function(){return this._getBooleanProperty("isPublicFlVariantEnabled")};r.prototype.isContextSharingEnabled=function(){return this._getBooleanProperty("isContextSharingEnabled")};r.prototype.isVariantPersonalizationEnabled=function(){return this._getBooleanProperty("isVariantPersonalizationEnabled")};r.prototype.isVariantAuthorNameAvailable=function(){return this._getBooleanProperty("isVariantAuthorNameAvailable")};r.prototype.isCondensingEnabled=function(){return this._getBooleanProperty("isCondensingEnabled")};r.prototype.hasPersoConnector=function(){return this._getBooleanProperty("hasPersoConnector")};r.prototype.isSystemWithTransports=function(){return!!(this._oSettings.system&&this._oSettings.client)};r.prototype.isPublishAvailable=function(){return!!this._oSettings.isPublishAvailable};r.prototype.isProductiveSystemWithTransports=function(){return this.isProductiveSystem()&&this.isSystemWithTransports()};r.prototype.isLocalResetEnabled=function(){return this._getBooleanProperty("isLocalResetEnabled")};r.prototype.isSeenFeaturesAvailable=function(){return this._getBooleanProperty("isSeenFeaturesAvailable")};r.prototype.isAnnotationChangeEnabled=function(){return this._getBooleanProperty("isAnnotationChangeEnabled")};r.prototype.getSystem=function(){return this._oSettings.system};r.prototype.getClient=function(){return this._oSettings.client};r.prototype._getHostname=function(){return document.location.hostname};r.prototype.isCustomerSystem=function(){var e=this._oSettings.systemType;var t={CUSTOMER:true,SAP:false}[e];var n=this._getHostname();return t!==undefined?t:!(n==="localhost"||n==="127.0.0.1")};r.prototype.getUserId=function(){return this._oSettings.userId};return r},true);
//# sourceMappingURL=Settings.js.map