/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/uid","sap/ui/core/Control","sap/ui/model/json/JSONModel","./getContainerUserInfo","sap/base/security/URLListValidator","sap/base/Log","./IFrameRenderer","../library","sap/ui/core/library"],function(e,t,r,i,o,s,n){"use strict";function a(e){if(e.parts&&e.formatter){return e.formatter.apply(null,e.parts.map(function(e){if(e.model){return`{${e.model}>${e.path}}`}return`{${e.path}}`}))}return e}var l=t.extend("sap.ui.fl.util.IFrame",{metadata:{library:"sap.ui.fl",properties:{url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"50vh"},title:{type:"string",group:"Misc",defaultValue:undefined},asContainer:{type:"boolean",group:"Misc",defaultValue:undefined},renameInfo:{type:"object",group:"Data",defaultValue:null},advancedSettings:{type:"object",defaultValue:{allowForms:true,allowPopups:true,allowScripts:true,allowModals:true,allowSameOrigin:true,additionalSandboxParameters:[]}},_settings:{type:"object",group:"Data",defaultValue:null}},designtime:"sap/ui/fl/designtime/util/IFrame.designtime"},init(...e){if(t.prototype.init){t.prototype.init.apply(this,e)}this._oInitializePromise=i().then(function(e){this._oUserModel=new r(e);this.setModel(this._oUserModel,"$user")}.bind(this))},waitForInit(){return this._oInitializePromise?this._oInitializePromise:Promise.reject()},setUrl(t){var r=decodeURI(t)===t?encodeURI(t):t;if(l.isValidUrl(r).result){const t=l._toUrl(r);const i=l._toUrl(this.getUrl()||"about:blank");if(i.searchParams.has("sap-ui-xx-fl-forceEmbeddedContentRefresh")){t.searchParams.set("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}else if(i.origin===t.origin&&i.pathname===t.pathname&&i.search===t.search&&i.hash!==t.hash){t.searchParams.append("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}this.setProperty("url",t.toString())}else{s.error("Provided URL is not valid as an IFrame src")}return this},_replaceIframeLocation(e){this.getDomRef().contentWindow.location.replace(e)},onAfterRendering(){this._replaceIframeLocation(this.getUrl());this._oLastContentWindow=this.getDomRef().contentWindow;this.getDomRef().addEventListener("load",()=>{if(!this.getDomRef()){return}if(this._oLastContentWindow!==this.getDomRef().contentWindow){this._oLastContentWindow=this.getDomRef().contentWindow;this._replaceIframeLocation(this.getUrl())}})},applySettings(e,...r){const{url:i,...o}=e||{};t.prototype.applySettings.apply(this,[o,...r]);t.prototype.applySettings.apply(this,[{url:i},...r]);if(e){let t={...this.getProperty("_settings")||{}};if(e._settings){t={...t,...e._settings}}else{Object.keys(e).filter(function(t){return e[t]!==undefined}).forEach(function(r){t[r]=a(e[r])})}this.setProperty("_settings",{...t})}},exit(){if(this._oUserModel){this._oUserModel.destroy();delete this._oUserModel}},renderer:n});l._getDocumentLocation=function(){return document.location};l._toUrl=function(e){const t=l._getDocumentLocation();return new URL(e,t.href)};l.VALIDATION_ERROR={UNSAFE_PROTOCOL:"unsafeProtocol",MIXED_CONTENT:"mixedContent",FORBIDDEN_URL:"forbiddenUrl",INVALID_URL:"invalidUrl"};l.isValidUrl=function(e){try{const t=l._toUrl(e);if(/javascript/i.test(t.protocol)){return{result:false,error:l.VALIDATION_ERROR.UNSAFE_PROTOCOL}}if(/http(?!s)/.test(t.protocol)&&!/http(?!s)/.test(l._getDocumentLocation().protocol)){return{result:false,error:l.VALIDATION_ERROR.MIXED_CONTENT}}if(!o.validate(e)){return{result:false,error:l.VALIDATION_ERROR.FORBIDDEN_URL}}return{result:true}}catch{return{result:false,error:l.VALIDATION_ERROR.INVALID_URL}}};return l});
//# sourceMappingURL=IFrame.js.map