/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_difference","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode"],function(e,t,a,n,r,i,s,o,c,l,f,u,h,p,d,g,m,v,V,R,y,C,D,S,b,x){"use strict";var F={};function M(e,t){t._oVariantSwitchPromise=t._oVariantSwitchPromise.catch(function(){}).then(e);v.setVariantSwitchPromise(t.sFlexReference,t._oVariantSwitchPromise);return t._oVariantSwitchPromise}function I(e,t){F[e]=t}function E(e,t){return m.switchVariant(e).then(function(){if(this.oData[e.vmReference].updateVariantInURL){u.updateVariantInURL({vmReference:e.vmReference,newVReference:e.newVReference,model:this})}this.callVariantSwitchListeners(e.vmReference,e.newVReference,undefined,t)}.bind(this))}function U(e){var t=y.getInstanceOrUndef();if(t&&!t.isVariantPersonalizationEnabled()){e.remove=false;e.rename=false;e.change=false}}function _(e){var t=y.getInstanceOrUndef();var a=t&&(t.isKeyUser()||!t.getUserId()||t.isPublicFlVariantEnabled()&&t.getUserId().toUpperCase()===e.instance.getSupportInformation().user.toUpperCase());e.remove=a;e.rename=a;e.change=a}function P(e,t,a){var n=a?D.getCurrentLayer():C.USER;if(e.layer===n&&e.key!==t){return true}return false}function L(e){return new Promise(function(t){if(e.getDomRef()){t()}else{e.addEventDelegate({onAfterRendering(){t()}})}})}function O(){var e=S.getUshellContainer();if(e){var t=[S.getUShellService("UserInfo"),S.getUShellService("URLParsing"),S.getUShellService("Navigation"),S.getUShellService("ShellNavigationInternal")];return Promise.all(t).then(function(e){I("UserInfo",e[0]);I("URLParsing",e[1]);I("Navigation",e[2]);I("ShellNavigationInternal",e[3])}).catch(function(e){throw new Error(`Error getting service from Unified Shell: ${e}`)})}return undefined}function w(e,t){return i({},e.find(function(e){return e.key===t}))}function T(e){const t=v.getInitialUIChanges({vmReference:e.vmReference,reference:e.reference});const a=t.reduce((t,a)=>{const n=a.getSelector();const r=o.bySelector(n,e.appComponent);if(r&&S.indexOfObject(t,{selector:r})===-1){t.push({selector:r})}return t},[]);return a.length?V.waitForFlexObjectsToBeApplied(a):Promise.resolve()}var A=b.extend("sap.ui.fl.variants.VariantModel",{constructor:function(e,t){this.pSequentialImportCompleted=Promise.resolve();b.apply(this,[e]);this.sharing={PRIVATE:"private",PUBLIC:"public"};this.oFlexController=t.flexController;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=R.getFlexReferenceForControl(t.appComponent);this.oAppComponent=t.appComponent;this._oResourceBundle=f.getResourceBundleFor("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};this.fnUpdateListener=this.updateData.bind(this);this.oDataSelector=v.getVariantManagementMap();this.oDataSelector.addUpdateListener(this.fnUpdateListener);this.updateData();const a=V.getLiveDependencyMap(this.sFlexReference);v.getInitialUIChanges({reference:this.sFlexReference},this.oAppComponent.getId(),this.sFlexReference).forEach(e=>{g.addChangeAndUpdateDependencies(e,this.oAppComponent.getId(),a)});this.setDefaultBindingMode(x.OneWay)}});A.prototype.updateData=function(){const e=this.oDataSelector.get({reference:this.sFlexReference});const t={...this.getData()};Object.entries(e).forEach(function(e){const a=e[0];const n={...e[1]};t[a]||={};t[a].variants=n.variants.map(function(e){const n=(t[a].variants||[]).find(function(t){return t.key===e.key});return{...n||{},...e}});t[a].currentVariant=n.currentVariant;t[a].defaultVariant=n.defaultVariant;t[a].modified=n.modified});this.setData(t);this.refresh(true)};A.prototype.invalidateMap=function(){this.oDataSelector.checkUpdate({reference:this.sFlexReference})};A.prototype.initialize=function(){return Promise.all([y.getInstance(),O()]).then(function(){u.initialize({model:this})}.bind(this))};A.prototype.updateCurrentVariant=function(e){var t={vmReference:e.variantManagementReference,currentVReference:this.getCurrentVariantReference(e.variantManagementReference),newVReference:e.newVariantReference,appComponent:e.appComponent||this.oAppComponent,modifier:o,reference:this.sFlexReference};if(e.internallyCalled){return E.call(this,t,e.scenario)}return M(E.bind(this,t,e.scenario),this)};A.prototype.getCurrentVariantReference=function(e){return this.oData[e].currentVariant};A.prototype.getVariantManagementReference=function(e){var t="";var a=-1;Object.keys(this.oData).some(function(n){return this.oData[n].variants.some(function(r,i){if(r.key===e){t=n;a=i;return true}})}.bind(this));return{variantManagementReference:t,variantIndex:a}};A.prototype.getVariant=function(e,t){var a=t||this.getVariantManagementReference(e).variantManagementReference;return w(this.oData[a].variants,e)};A.prototype.getVariantTitle=function(e,t){return w(this.oData[t].variants,e).title};function k(e,t){var a=v.getVariantChangesForVariant({vmReference:e,reference:this.sFlexReference});var n=this.oData[e].defaultVariant;if(t.getExecuteOnSelectionForStandardDefault()&&n===e&&!a.setExecuteOnSelect){var r=w(this.oData[e].variants,e);r.instance.setExecuteOnSelection(true);this.oData[e].variants[0].executeOnSelect=true;return true}return false}A.prototype.attachVariantApplied=function(e){var t=l.getElementById(e.vmControlId);var a=this.getVariantManagementReferenceForControl(t);return this.waitForVMControlInit(a).then(function(e,a){this._oVariantAppliedListeners[e]||={};var n=k.call(this,e,t);if(a.callAfterInitialVariant||n){var r={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:e};T(r).then(function(){var t=this.oData[e].currentVariant;this.callVariantSwitchListeners(e,t,a.callback)}.bind(this))}return L(a.control).then(function(){if(h.getRelevantVariantManagementControlId(a.control,this.getVariantManagementControlIds())===a.vmControlId){this.oData[e].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[e][a.control.getId()]=a.callback}else{s.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the "+"responsible VariantManagement control")}}.bind(this))}.bind(this,a,e))};A.prototype.callVariantSwitchListeners=function(e,t,a,r){if(this._oVariantAppliedListeners[e]){var i=w(this.oData[e].variants,t);if(r){i.createScenario=r}if(a){a(i)}else{n(this._oVariantAppliedListeners[e],function(e,t){t(i)})}}};A.prototype.detachVariantApplied=function(e,t){var a=this.getVariantManagementReferenceForControl(l.getElementById(e));if(this._oVariantAppliedListeners[a]){delete this._oVariantAppliedListeners[a][t]}};A.prototype._getVariantTitleCount=function(e,t){var a=this.getData();return a[t].variants.reduce(function(t,a){if(e.toLowerCase()===a.title.toLowerCase()&&a.visible){t++}return t},0)};function j(e,t){var a={id:t.newVariantReference,variantName:t.title,contexts:t.contexts,layer:t.layer,adaptationId:t.adaptationId,reference:e.getFlexObjectMetadata().reference,generator:t.generator,variantManagementReference:t.variantManagementReference,executeOnSelection:t.executeOnSelection};if(t.layer===C.VENDOR){a.user="SAP"}if(t.currentVariantComparison===1){if(t.sourceVariantSource.instance.getLayer()===t.layer){a.variantReference=t.sourceVariantSource.instance.getVariantReference()}else{a.variantReference=e.getVariantReference()}}else if(t.currentVariantComparison===0){a.variantReference=e.getVariantReference()}else if(t.currentVariantComparison===-1){a.variantReference=t.sourceVariantReference}return p.createFlVariant(a)}A.prototype._duplicateVariant=function(e){var t=e.sourceVariantReference;var a=e.variantManagementReference;var n=this.getVariant(t);var r=v.getControlChangesForVariant({vmReference:a,vReference:t,reference:this.sFlexReference}).map(function(e){return e.convertToFileContent()});e.currentVariantComparison=D.compareAgainstCurrentLayer(n.instance.getLayer(),e.layer);if(e.currentVariantComparison===1){e.sourceVariantSource=this.getVariant(n.instance.getVariantReference())}var s={instance:j(n.instance,e),controlChanges:r,variantChanges:{}};r=s.controlChanges.slice();var o={};s.controlChanges=r.reduce(function(t,a){if(D.compareAgainstCurrentLayer(a.layer,e.layer)>=0){o=i({},a);o.layer=e.layer;o.variantReference=s.instance.getId();o.support||={};o.support.sourceChangeFileName=a.fileName;o.packageName="$TMP";o.fileName=S.createDefaultFileName(o.changeType);t.push(p.createFromFileContent(o))}return t},[]);return s};A.prototype._collectModelChanges=function(e,t,a){const n=this.getData()[e];const r=n.variants;const i=[];const s=y.getInstanceOrUndef();const o=[];const c=e=>r.find(t=>t.key===e);const l=(e,a,n)=>{const r=["setTitle","setExecuteOnSelect","setVisible"].includes(a);const o=r&&s?.isPublicFlVariantEnabled()&&e.layer===C.PUBLIC?C.PUBLIC:t;i.push({variantReference:e.key,changeType:a,layer:o,...n})};a.getParameter("renamed")?.forEach(({key:e,name:t})=>{const a=c(e);l(a,"setTitle",{title:t,originalTitle:a.title})});a.getParameter("fav")?.forEach(({key:e,visible:t})=>{const a=c(e);l(a,"setFavorite",{favorite:t,originalFavorite:a.favorite})});a.getParameter("exe")?.forEach(({key:e,exe:t})=>{const a=c(e);l(a,"setExecuteOnSelect",{executeOnSelect:t,originalExecuteOnSelect:a.executeOnSelect})});a.getParameter("deleted")?.forEach(e=>{const t=c(e);l(t,"setVisible",{visible:false});o.push(e)});a.getParameter("contexts")?.forEach(({key:e,contexts:t})=>{const a=c(e);l(a,"setContexts",{contexts:t,originalContexts:a.contexts})});const f=a.getParameter("def");if(f){i.push({variantManagementReference:e,changeType:"setDefault",defaultVariant:f,originalDefaultVariant:n.defaultVariant,layer:t})}return{changes:i,variantsToBeDeleted:o}};A.prototype.setVariantProperties=function(e,t){var a=this.getData();var n=this.getVariant(t.variantReference,e).instance;var r={};switch(t.changeType){case"setTitle":n.setName(t.title,true);break;case"setFavorite":r.favorite=t.favorite;n.setFavorite(t.favorite);break;case"setExecuteOnSelect":r.executeOnSelect=t.executeOnSelect;n.setExecuteOnSelection(t.executeOnSelect);break;case"setVisible":r.visible=t.visible;r.createdByReset=false;n.setVisible(t.visible);break;case"setContexts":r.contexts=t.contexts;n.setContexts(t.contexts);break;case"setDefault":r.defaultVariant=t.defaultVariant;var i=u.getStoredHashParams({model:this});if(i&&this.oData[e].updateVariantInURL){if(a[e].defaultVariant!==a[e].currentVariant&&i.indexOf(a[e].currentVariant)===-1){u.update({parameters:i.concat(a[e].currentVariant),updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this})}else if(a[e].defaultVariant===a[e].currentVariant&&i.indexOf(a[e].currentVariant)>-1){i.splice(i.indexOf(a[e].currentVariant),1);u.update({parameters:i,updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this})}}break;default:break}return r};A.prototype._ensureStandardVariantExists=function(e){var t=this.getData();var n=t[e]||{};var i=a(n,["initPromise"]);if(!t[e]||r(i)){var s=p.createFlVariant({id:e,variantManagementReference:e,variantName:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),user:h.DEFAULT_AUTHOR,layer:C.BASE,reference:this.sFlexReference});v.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),s);this._aCreatedStandardVariantsFor||=[];this._aCreatedStandardVariantsFor.push(e)}};A.prototype.setModelPropertiesForControl=function(e,t,a){this.oData[e].showFavorites=true;var n=this._bDesignTimeMode;if(n!==t){this._bDesignTimeMode=t;if(t){u.clearAllVariantURLParameters({model:this})}else if(n&&this.oData[e].updateVariantInURL){u.update({parameters:u.getStoredHashParams({model:this}),updateURL:true,updateHashEntry:false,model:this})}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents()}a.detachManage(this.fnManageClick,this);if(t&&this.oData[e]._isEditable){this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(a){a.rename=true;a.change=true;a.sharing=this.sharing.PUBLIC;a.remove=P(a,e,t)}.bind(this))}else if(this.oData[e]._isEditable){a.attachManage({variantManagementReference:e},this.fnManageClick,this);this.oData[e].variantsEditable=true;this.oData[e].variants.forEach(function(a){a.remove=P(a,e,t);switch(a.layer){case C.USER:a.rename=true;a.change=true;a.sharing=this.sharing.PRIVATE;U(a);break;case C.PUBLIC:a.sharing=this.sharing.PUBLIC;_(a);break;default:a.rename=false;a.change=false;a.sharing=this.sharing.PUBLIC}}.bind(this))}else{this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(e){e.remove=false;e.rename=false;e.change=false})}};A.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,t){const a=this._collectModelChanges(t.variantManagementReference,t.layer,e);t.resolve(a)};this.fnManageClick=function(e,t){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(a){a.handleManageEvent(e,t,this)}.bind(this))}};A.prototype._handleSaveEvent=function(e){if(!this._bDesignTimeMode){var t=e.getSource();var a=e.getParameters();sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(e){e.handleSaveEvent(t,a,this)}.bind(this))}};function B(e,t){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(a){a.handleSelectVariant(e,t)})}A.prototype.getLocalId=function(e,t){return o.getSelector(e,t).id};A.prototype.getVariantManagementReferenceForControl=function(e){var t=e.getId();var a=S.getAppComponentForControl(e);return a&&a.getLocalId(t)||t};A.prototype.switchToDefaultForVariantManagement=function(e){if(this.oData[e].currentVariant!==this.oData[e].defaultVariant){c.show(200);this.updateCurrentVariant({variantManagementReference:e,newVariantReference:this.oData[e].defaultVariant}).then(function(){c.hide()})}};A.prototype.switchToDefaultForVariant=function(e){Object.keys(this.oData).forEach(function(t){if(!e||this.oData[t].currentVariant===e){this.switchToDefaultForVariantManagement(t)}}.bind(this))};function N(e,t){this.oData[t].variants.forEach(function(a){const n=a.title&&a.title.match(/{(\w+)>(\w.+)}/);if(n){const[,r,i]=n;const s=e.getModel(r);if(s){const e=s.getResourceBundle().getText(i);const t={reference:this.sFlexReference,changeType:"setTitle",layer:a.layer,fileType:"ctrl_variant_change",variantId:a.key};const n=p.createVariantChange(t);n.setText("title",e,"XFLD");a.instance.setName(e,true);v.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),n)}else{e.attachEventOnce("modelContextChange",N.bind(this,e,t))}}}.bind(this))}A.prototype.registerToModel=function(e){const t=this.getVariantManagementReferenceForControl(e);this._ensureStandardVariantExists(t);this.oData[t]._isEditable=e.getEditable();this.oData[t].showExecuteOnSelection=false;N.call(this,e,t);e.attachEvent("select",{vmReference:t,model:this},B);e.attachSave(this._handleSaveEvent,this);this.setModelPropertiesForControl(t,false,e);const a=e.getUpdateVariantInURL();this.oData[t].updateVariantInURL=a;if(a){u.registerControl({vmReference:t,updateURL:true,model:this});u.handleModelContextChange({model:this,vmControl:e})}if(this.oData[t].initPromise){this.oData[t].initPromise.resolveFunction();delete this.oData[t].initPromise}this.oData[t].init=true;const n={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:t};this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(T.bind(undefined,n))};A.prototype.waitForVMControlInit=function(e){if(!this.oData[e]){this.oData[e]={}}else if(this.oData[e].init){return Promise.resolve()}this.oData[e].initPromise={};this.oData[e].initPromise.promise=new Promise(function(t){this.oData[e].initPromise.resolveFunction=t}.bind(this));return this.oData[e].initPromise.promise};A.prototype._getDirtyChangesFromVariantChanges=function(e){var t=e.map(function(e){return e.getId()});return V.getDirtyFlexObjects(this.sFlexReference).filter(function(e){return t.includes(e.getId())&&!e.getSavedToVariant()})};A.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(e,t){return e.concat([this.oData[t].currentVariant])}.bind(this),[])};A.prototype.getVariantManagementControlIds=function(){var e;return Object.keys(this.oData||{}).reduce(function(t,a){if(this.oAppComponent.byId(a)){e=this.oAppComponent.createId(a)}else{e=a}t.push(e);return t}.bind(this),[])};A.prototype.destroy=function(){const e=this.oDataSelector.get({reference:this.sFlexReference});const t=Object.entries(e).map(([e,t])=>{const a=v.getVariant({vmReference:e,vReference:t.currentVariant,reference:this.sFlexReference});return a.controlChanges}).flat();const a=V.getLiveDependencyMap(this.sFlexReference);t.forEach(e=>{g.removeChangeFromMap(a,e.getId());g.removeChangeFromDependencies(a,e.getId())});this.oDataSelector.removeUpdateListener(this.fnUpdateListener);const n=[];(this._aCreatedStandardVariantsFor||[]).forEach(t=>{if(e[t]?.variants.length>1||e[t]?.variants[0].controlChanges.length){n.push(e[t].variants[0].instance)}});if(n.length){v.addRuntimeOnlyFlexObjects(this.sFlexReference,n)}v.clearRuntimeSteadyObjects(this.sFlexReference,this.oAppComponent.getId());v.resetCurrentVariantReference(this.sFlexReference);b.prototype.destroy.apply(this)};A.prototype.getUShellService=function(e){return S.getUshellContainer()&&F[e]};return A});
//# sourceMappingURL=VariantModel.js.map