/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/descriptorRelated/Utils","sap/ui/fl/Utils","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange"],function(e,t,n){"use strict";function r(e){if(!e.texts){e.texts={"":e.content};e.content={}}}function c(e){var t=new n(e);return Promise.resolve(t)}var a={};a.createNew=function(e){var t=new n(e);return Promise.resolve(t)};a.createDescriptorInlineChange=function(e){var t=e.changeType.replace("appdescr","create");if(!this[t]){throw new Error(`Change type '${e.changeType}' is not supported`)}return this[t](e)};a.create_ovp_addNewCard=function(t){e.checkParameterAndType(t.content,"card","object");return c(t)};a.create_ovp_removeCard=function(t){e.checkParameterAndType(t.content,"cardId","string");return c(t)};a.create_ovp_changeCard=function(t){e.checkParameterAndType(t.content,"cardId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewInbound=function(t){e.checkParameterAndType(t.content,"inbound","object");return c(t)};a.create_app_removeInbound=function(t){e.checkParameterAndType(t.content,"inboundId","string");return c(t)};a.create_app_removeAllInboundsExceptOne=function(t){e.checkParameterAndType(t.content,"inboundId","string");return c(t)};a.create_app_changeInbound=function(t){e.checkParameterAndType(t.content,"inboundId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewOutbound=function(t){e.checkParameterAndType(t.content,"outbound","object");return c(t)};a.create_app_removeOutbound=function(t){e.checkParameterAndType(t.content,"outboundId","string");return c(t)};a.create_app_changeOutbound=function(t){e.checkParameterAndType(t.content,"outboundId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_app_addNewDataSource=function(t){e.checkParameterAndType(t.content,"dataSource","object");return c(t)};a.create_app_removeDataSource=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");return c(t)};a.create_app_changeDataSource=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");e.checkEntityPropertyChange(t.content);return c(t)};var o={BEGINNING:"BEGINNING",END:"END"};a.create_app_addAnnotationsToOData=function(t){e.checkParameterAndType(t.content,"dataSourceId","string");e.checkParameterAndType(t.content,"annotations","array");e.checkParameterAndType(t.content,"dataSource","object");return c(t)};a.create_app_setTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.title");return e})};a.create_app_setSubTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.subTitle");return e})};a.create_app_setShortTitle=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.shortTitle");return e})};a.create_app_setDescription=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.description");return e})};a.create_app_setInfo=function(e){r(e);return c(e).then(function(e){e.setHostingIdSuffix("_sap.app.info");return e})};a.create_app_setAch=function(t){e.checkParameterAndType(t.content,"ach","string");return c(t)};a.create_app_setDestination=function(t){e.checkParameterAndType(t.content,"destination","object");return c(t)};a.create_app_setKeywords=function(t){e.checkParameterAndType(t.content,"keywords","array");return c(t)};a.create_app_addTechnicalAttributes=function(t){e.checkParameterAndType(t.content,"technicalAttributes","array");return c(t)};a.create_app_removeTechnicalAttributes=function(t){e.checkParameterAndType(t.content,"technicalAttributes","array");return c(t)};a.create_app_addCdsViews=function(t){e.checkParameterAndType(t.content,"cdsViews","array");return c(t)};a.create_app_removeCdsViews=function(t){e.checkParameterAndType(t.content,"cdsViews","array");return c(t)};a.create_flp_setConfig=function(t){e.checkParameterAndType(t.content,"config","object");return c(t)};a.create_ui5_addNewModel=function(t){e.checkParameterAndType(t.content,"model","object");return c(t)};a.create_ui5_removeModel=function(t){e.checkParameterAndType(t.content,"modelId","string");return c(t)};a.create_ui5_addNewModelEnhanceWith=function(t){e.checkParameterAndType(t.content,"modelId","string");return c(t)};a.create_ui5_replaceComponentUsage=function(t){e.checkParameterAndType(t.content,"componentUsageId","string");e.checkParameterAndType(t.content,"componentUsage","object");return c(t)};a.create_ui5_addLibraries=function(t){e.checkParameterAndType(t.content,"libraries","object");return c(t)};a.create_ui5_addComponentUsages=function(t){e.checkParameterAndType(t.content,"componentUsages","object");return c(t)};a.create_ui5_setMinUI5Version=function(t){e.checkParameterAndType(t.content,"minUI5Version",["string","array"]);return c(t)};a.create_smb_addNamespace=function(t){e.checkParameterAndType(t.content,"smartBusinessApp","object");return c(t)};a.create_smb_changeNamespace=function(t){e.checkParameterAndType(t.content,"smartBusinessApp","object");return c(t)};a.create_ui_generic_app_setMainPage=function(t){e.checkParameterAndType(t.content,"page","object");return c(t)};a.create_ui_setIcon=function(t){e.checkParameterAndType(t.content,"icon","string");return c(t)};a.create_ui_setDeviceTypes=function(t){e.checkParameterAndType(t.content,"deviceTypes","object");return c(t)};a.create_url_setUri=function(t){e.checkParameterAndType(t.content,"uri","string");return c(t)};a.create_fiori_setRegistrationIds=function(t){e.checkParameterAndType(t.content,"registrationIds","array");return c(t)};a.create_ui5_setFlexExtensionPointEnabled=function(t){e.checkParameterAndType(t.content,"flexExtensionPointEnabled","boolean");e.checkParameterAndType(t,"changeType","string");return c(t)};a.create_ui5_changeModel=function(t){e.checkParameterAndType(t.content,"modelId","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_fiori_setAbstract=function(t){e.checkParameterAndType(t.content,"abstract","boolean");e.checkParameterAndType(t,"changeType","string");return c(t)};a.create_fe_changePageConfiguration=function(t){e.checkParameterAndType(t.content,"page","string");e.checkEntityPropertyChange(t.content);return c(t)};a.create_fe_addNewPage=function(t){e.checkParameterAndType(t.content.sourcePage,"id","string");e.checkParameterAndType(t.content.sourcePage,"navigationSource","string");e.checkParameterAndType(t.content.targetPage,"id","string");e.checkParameterAndType(t.content.targetPage,"type","string");e.checkParameterAndType(t.content.targetPage,"name","string");e.checkParameterAndType(t.content.targetPage,"routePattern","string");e.checkParameterAndType(t.content.targetPage,"settings","object");e.checkParameterAndType(t.content.targetPage.settings,"contextPath","string");e.checkParameterAndType(t.content.targetPage.settings,"pageLayout","string");e.checkParameterAndType(t.content.targetPage.settings,"controlConfiguration","object");return c(t)};a.create_ui_generic_app_changePageConfiguration=function(n){e.checkParameterAndType(n.content,"parentPage","object");e.checkEntityPropertyChange(n.content);return c(n).then(function(e){e.fileName=t.createDefaultFileName("appdescr_ui_gen_app_changePageConfig");return Promise.resolve(e)})};a.create_ui_generic_app_addNewObjectPage=function(t){e.checkParameterAndType(t.content,"parentPage","object");e.checkChildPageChange(t.content);return c(t)};return a});
//# sourceMappingURL=AppVariantInlineChangeFactory.js.map