/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox","sap/base/util/restricted/_pick"],function(e,t,r,n,a,s,i,o,l,u,c,p,f,d,T){"use strict";var g={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",CONDENSE:"/actions/condense/",VARIANTS:"/variants/",TOKEN:"/actions/getcsrftoken/",APPVARIANTS:"/appdescr_variants/",APPVARIANTS_OVERVIEW:"/app_variant_overview/",UI2PERSONALIZATION:"/ui2personalization/",CONTEXTS:"/flex/contexts/",VERSIONS:{GET:"/flex/versions/",ACTIVATE:"/flex/versions/activate/",DISCARD:"/flex/versions/draft/",PUBLISH:"/flex/versions/publish/"},CONTEXT_BASED_ADAPTATION:"/flex/apps/",MANI_FIRST_SUPPORTED:"/sap/bc/ui2/app_index/ui5_app_mani_first_supported",SEEN_FEATURES:"/seen_features/"};var E="/adaptations/";var v=function(e){var t;if(e.isLegacyVariant){t=g.VARIANTS}else if(e.isAppVariant){t=g.APPVARIANTS}else if(e.isContextSharing){t=g.CONTEXTS}else if(e.isCondensingEnabled){t=g.CONDENSE}else if(e.isContextBasedAdaptationEnabled){t=g.CONTEXT_BASED_ADAPTATION+e.appId+E}else{t=g.CHANGES}var r=e.transport?{changelist:e.transport}:{};if(e.skipIam){r.skipIam=e.skipIam}if(e.parentVersion){r.parentVersion=e.parentVersion}a.addSAPLogonLanguageInfo(r);n._addClientInfo(r);if(e.flexObject&&!e.isAppVariant){e.fileName=e.flexObject.fileName}var i=a.getUrl(t,e,r);delete e.reference;delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return s.sendRequest(i,e.method,l)};var O=function(e){var t=e.getDefinition().layer===l.VENDOR?e.getPackage():"";return{package:t,namespace:e.getNamespace(),name:e.getDefinition().fileName,type:e.getDefinition().fileType}};var R=function(e){var t;if(e.transport){t=Promise.resolve({transport:e.transport})}else if(e.isForSmartBusiness){return Promise.resolve()}else{var r=O(e.appVariant);t=(new i).openTransportSelection(r)}return t.then(function(e){if(e==="cancel"){return Promise.reject("cancel")}if(e&&e.transport!==undefined){return e.transport}return Promise.reject(new Error("Transport information could not be determined"))})};function S(e){e.version=e.versionId;delete e.versionId;return e}return e({},r,{initialConnector:n,layers:n.layers,reset(e){p.show(0);var t=[];var r=Promise.resolve();if(e.layer!==l.USER){t=e.changes;r=o.getInstance().then(function(r){if(!r.isProductiveSystem()){return(new i).setTransports(t,c.getComponentById(e.reference)).then(function(){t.some(function(t){if(t.getRequest()){e.changelist=t.getRequest();return true}return false})})}})}return r.then(function(){p.show(0);var t=["reference","layer","changelist","generator"];var r=T(e,t);n._addClientInfo(r);if(e.selectorIds){r.selector=e.selectorIds}if(e.changeTypes){r.changeType=e.changeTypes}delete e.reference;var i=a.getUrl(g.CHANGES,e,r);var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o);return s.sendRequest(i,"DELETE",l).then(function(e){if(e&&e.response){e.response.forEach(function(e){e.fileName=e.name;delete e.name})}p.hide();return e}).catch(function(e){p.hide();return Promise.reject(e)})})},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var n=function(t){p.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error: ${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.transportDialogSettings.styleClass});return"Error"};var a=new i;return a.openTransportSelection(null,e.transportDialogSettings.rootControl,e.transportDialogSettings.styleClass).then(function(t){if(a.checkTransportInfo(t)){p.show(0);var n={reference:e.reference,layer:e.layer};return a._prepareChangesForTransport(t,e.localChanges,e.appVariantDescriptors,n).then(function(){p.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(n)},getFlexInfo(e){var t=["layer"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.FLEX_INFO,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},getContexts(e){var t=["type","$skip","$filter"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.CONTEXTS,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},loadContextDescriptions(e){e.method="POST";e.isContextSharing=true;return v(e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},async getSeenFeatureIds(e){const t={};n._addClientInfo(t);const r=a.getUrl(g.SEEN_FEATURES,e,t);const s=await a.sendRequest(r,"GET",{initialConnector:n});return s.response?.seenFeatureIds||[]},async setSeenFeatureIds(e){const t={seenFeatureIds:e.seenFeatureIds};const r={};n._addClientInfo(r);const i=a.getUrl(g.SEEN_FEATURES,e,r);const o=a.getUrl(g.TOKEN,e);const l=s.getRequestOptions(n,o,t,"application/json; charset=utf-8","json");const u=await s.sendRequest(i,"PUT",l);return u.response?.seenFeatureIds},write(e){e.method="POST";return v(e)},condense(e){const t=e.flexObjects;const r={};function n(e,n,a,s,i){r[n]||={namespace:n,layer:t.layer};r[n][e]||={};r[n][e][a]||=[];if(e==="delete"||e==="reorder"){r[n][e][a].push(s)}else{r[n][e][a].push({[s]:i[s]||i})}}["create","reorder","update","delete"].forEach(r=>{const a=t[r];if(a){Object.keys(a).forEach(t=>{a[t].forEach(a=>{const s=a.fileName||(typeof a==="object"?Object.keys(a)[0]:a);var i=a[s]?.namespace||a[t]?.namespace;if(!i){const t=e.allChanges.find(e=>e.getId()===s);i=t?t.getNamespace():undefined}if(i){n(r,i,t,s,a)}})})}});e.flexObjects=Object.values(r);e.method="POST";e.isCondensingEnabled=true;return v(e)},update(e){if(e.flexObject.fileType==="variant"){e.isLegacyVariant=true}e.method="PUT";return v(e)},remove(e){var t={namespace:e.flexObject.namespace,layer:e.flexObject.layer};if(e.transport){t.changelist=e.transport}if(e.parentVersion){t.parentVersion=e.parentVersion}n._addClientInfo(t);e.fileName=e.flexObject.fileName;var r=e.flexObject.fileType==="variant"?g.VARIANTS:g.CHANGES;var i=a.getUrl(r,e,t);i=decodeURIComponent(i);delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)},appVariant:{getManifirstSupport(e){var t=`${g.MANI_FIRST_SUPPORTED}/?id=${e.appId}`;return a.sendRequest(t,"GET",{initialConnector:n}).then(function(e){return e.response})},getManifest(e){var t=e.appVarUrl;var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},load(e){var t=a.getUrl(g.APPVARIANTS,e);var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},create(e){e.method="POST";e.isAppVariant=true;return v(e)},assignCatalogs(e){var t={};t.action=e.action;delete e.action;t.assignFromAppId=e.assignFromAppId;delete e.assignFromAppId;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},unassignCatalogs(e){var t={};t.action=e.action;delete e.action;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},update(e){return R(e).then(function(t){if(t){e.transport=t}delete e.isForSmartBusiness;e.method="PUT";e.isAppVariant=true;return v(e)})},remove(e){return R(e).then(function(t){var r={};if(t){r.changelist=t}delete e.isForSmartBusiness;var i=a.getUrl(g.APPVARIANTS,e,r);delete e.reference;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)})},list(e){var t={};t.layer=e.layer;t["sap.app/id"]=e.reference;delete e.layer;delete e.reference;var r=a.getUrl(g.APPVARIANTS_OVERVIEW,e,t);var i=s.getRequestOptions(n,undefined,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"GET",i)}},contextBasedAdaptation:{create(e){e.isContextBasedAdaptationEnabled=true;e.method="POST";return v(e)},reorder(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";return v(e)},update(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";e.reference=e.adaptationId;return v(e)},load(e){var t=["version"];var r=T(e,t);n._addClientInfo(r);e.reference=e.appId+E;var s=a.getUrl(g.CONTEXT_BASED_ADAPTATION,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},remove(e){e.isContextBasedAdaptationEnabled=true;e.method="DELETE";e.reference=e.adaptationId;return v(e)}},ui2Personalization:{create(e){e.initialConnector=this.initialConnector;var t=u.getLrepUrl();var r=s.getRequestOptions(n,t+g.TOKEN,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");var a=t+g.UI2PERSONALIZATION;return s.sendRequest(a,"PUT",r)},remove(e){e.initialConnector=this.initialConnector;var t=a.getUrl(g.UI2PERSONALIZATION,{url:u.getLrepUrl()},{reference:e.reference,containerkey:e.containerKey,itemname:e.itemName});return s.sendRequest(t,"DELETE")}},versions:{load(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r={};a.addSAPLogonLanguageInfo(r);r.limit=e.limit;var i=a.getUrl(g.VERSIONS.GET,e,r);return s.sendRequest(i,"GET",t).then(function(e){return e.response.versions.map(function(e){return S(e)})})},activate(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e),{title:e.title},"application/json; charset=utf-8","json");var r={version:e.version};a.addSAPLogonLanguageInfo(r);var i=a.getUrl(g.VERSIONS.ACTIVATE,e,r);return s.sendRequest(i,"POST",t).then(function(e){var t=e.response;return S(t)})},discardDraft(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r=a.getUrl(g.VERSIONS.DISCARD,e);return s.sendRequest(r,"DELETE",t)},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var o=function(t){p.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.styleClass});return"Error"};var l=new i;return l.openTransportSelection(null,e.rootControl,e.styleClass,false).then(function(t){if(l.checkTransportInfo(t)){p.show(0);if(!t.transport){return Promise.reject(new Error("no transport provided as attribute of mParameters"))}if(!e.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}if(!e.version){return Promise.reject(new Error("no version provided as attribute of mParameters"))}var i={transport:t.transport,version:e.version};var o=a.getUrl(g.VERSIONS.PUBLISH,{url:u.getLrepUrl(),reference:e.reference},i);var c=a.getUrl(g.TOKEN,{url:u.getLrepUrl()});var f=s.getRequestOptions(n,c,undefined,"application/json; charset=utf-8","json");return s.sendRequest(o,"POST",f).then(function(){p.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(o)}}})});
//# sourceMappingURL=LrepConnector.js.map