/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/UriParser","sap/ui/fl/write/_internal/fieldExtensibility/Utils"],function(t,e,n){"use strict";const s="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";const i="/sap/opu/odata/sap/ui_sclg_implementation/";const o="sap.ui.fl.write._internal.fieldExtensibility.SingleTenantABAPExtensibilityVariant";const r={CustomField:"CUSTOM_FIELD",CustomLogic:"CUSTOM_LOGIC"};const u={[r.CustomField]:{semanticObject:"CustomField",action:"manage"},[r.CustomLogic]:{semanticObject:"CustomLogic",action:"develop"}};const a={BusinessContextTitle:"BUSINESS_CONTEXT_TITLE",MenuButtonLabel:"BTN_CREATE",MenuButtonTooltip:"BTN_FREP_CCF",MenuCreateCustomField:"BTN_MENU_CREATE_CUSTOM_FIELD",StandaloneCreateCustomField:"BTN_CREATE_CUSTOM_FIELD",MenuCreateCustomLogic:"BTN_MENU_CREATE_CUSTOM_LOGIC",StandaloneCreateCustomLogic:"BTN_CREATE_CUSTOM_LOGIC"};const c=t.extend(o,{async getExtensionData(){const t=await this._oExtensionDataPromise;if(t===null){return null}if(!this._containsExtensionData(t)){return null}const e=[];for(const n of t.businessContexts){const t={description:n.BusinessContextDescription,businessContext:n.BusinessContext};e.push(t)}return{extensionData:e}},async getNavigationUri(t){const e=t??await this._getFallbackNavigationActionKey();if(e===null){return null}const s=await this._oExtensionDataPromise;if(s===null){return null}if(!this._containsExtensionData(s)){return null}const i=s.navigationSupported;if(!i[e]){return null}const o=s.businessContexts;const r=o.map(function(t){return t.BusinessContext});const a=s.businessObjects;const c=a.map(function(t){return t.SAPObjectNodeType});return n.getNavigationUriForIntent({target:u[e],params:{businessContexts:r,businessObjects:c,serviceVersion:this._mServiceInfo.serviceVersion,serviceName:this._mServiceInfo.serviceName,entityType:this._mBindingInfo.entityTypeName}})},async getTexts(){const t=await this._oExtensionDataPromise;if(t===null){return null}if(!this._containsExtensionData(t)){return null}const e=await this._getMenuButtonLabel();const s=await this._getMenuButtonTooltip();const i=await this._getMenuButtonOptions();if(i.length===1){i[0].text=e;i[0].tooltip=s}return{headerText:n.getText(a.BusinessContextTitle),buttonText:e,tooltip:s,options:i}},async isActive(){const t=await this._oExtensionDataPromise;if(t===null){return false}return this._containsExtensionData(t)},_containsExtensionData({businessContexts:t,businessObjects:e}){const n=Array.isArray(t)&&t.length>0;const s=Array.isArray(e)&&e.length>0;return n||s},async _determineExtensionData(){let[t,e]=await n.isNavigationSupportedForIntents([u[r.CustomField],u[r.CustomLogic]]);if(!(t||e)){return null}const s=await this._getBusinessContexts();if(s===null){return null}const i=await this._getBusinessObjects(s);if(i===null){return null}const{supportsStructuralEnhancements:o,supportsLogicEnhancements:a}=this._determineSupportedExtensibilityTypes(s,i);t&&=o;e&&=a;if(!(t||e)){return null}return{businessContexts:s,businessObjects:i,navigationSupported:{[r.CustomField]:t,[r.CustomLogic]:e}}},async _getBusinessContexts(){const t=this._getBusinessContextDataServiceUrl();const s=this._getBusinessContextDataServiceParameters();const i=await n.executeRequest(t,s);if(i.statusCode===404&&this._mServiceInfo.serviceType===e.mServiceType.v4){return null}if(i.errorOccurred!==false){throw i}const o=i.result.results||[];for(const t of o){t.SupportsLogicEnhancements??=true;t.SupportsStructuralEnhancements??=true}return o},async _getBusinessObjects(t){const e=this._getBusinessObjectDataServiceUrl();const s=this._getBusinessObjectDataServiceParameters(t);const i=await n.executeRequest(e,s);if(i.errorOccurred!==false){return[]}return i.result.results||[]},_determineSupportedExtensibilityTypes(t,e){const n=t.some(t=>t.SupportsLogicEnhancements)||e.some(t=>t.SupportsLogicEnhancements);const s=t.some(t=>t.SupportsStructuralEnhancements)||e.some(t=>t.SupportsStructuralEnhancements);return{supportsLogicEnhancements:n,supportsStructuralEnhancements:s}},_getBusinessContextDataServiceParameters(){const t={EntitySetName:"",EntityTypeName:this._mBindingInfo.entityTypeName};if(this._mServiceInfo.serviceType===e.mServiceType.v4){t.ResourcePath=`${e.sODataV4ResourcePathPrefix+this._mServiceInfo.serviceName}/${this._mServiceInfo.serviceVersion}`}else{t.ServiceName=this._mServiceInfo.serviceName;t.ServiceVersion=this._mServiceInfo.serviceVersion}return t},_getBusinessContextDataServiceUrl(){if(this._mServiceInfo.serviceType===e.mServiceType.v4){return`${s}GetBusinessContextsByResourcePath`}return`${s}GetBusinessContextsByEntityType`},_getBusinessObjectDataServiceParameters(t){const e=t.map(t=>t.BusinessContext);return{BusinessContexts:JSON.stringify(e)}},_getBusinessObjectDataServiceUrl(){return`${i}getSONTsFromBusinessContexts`},async _getMenuButtonText(t){const e=await this._oExtensionDataPromise;if(e===null){return undefined}const s=e.navigationSupported;let i=0;for(const t in s){if(!s[t]){continue}i++}if(i>1){return n.getText(t)}if(i===0){return undefined}if(s[r.CustomField]){return n.getText(a.StandaloneCreateCustomField)}if(s[r.CustomLogic]){return n.getText(a.StandaloneCreateCustomLogic)}return undefined},_getMenuButtonLabel(){return this._getMenuButtonText(a.MenuButtonLabel)},_getMenuButtonTooltip(){return this._getMenuButtonText(a.MenuButtonTooltip)},async _getMenuButtonOptions(){const t=await this._oExtensionDataPromise;if(t===null){return[]}const e=t.navigationSupported;const n=[];if(e[r.CustomField]){n.push(this._getFieldsMenuButtonOption())}if(e[r.CustomLogic]){n.push(this._getLogicMenuButtonOption())}return n},_getFieldsMenuButtonOption(){const t=n.getText(a.MenuCreateCustomField);return{actionKey:r.CustomField,text:t,tooltip:t}},_getLogicMenuButtonOption(){const t=n.getText(a.MenuCreateCustomLogic);return{actionKey:r.CustomLogic,text:t,tooltip:t}},async _getFallbackNavigationActionKey(){const t=await this._oExtensionDataPromise;if(t===null){return null}const e=t.navigationSupported;if(!this._containsExtensionData(t)){return null}for(const t in e){if(!e[t]){continue}return t}return null}});return c});
//# sourceMappingURL=SingleTenantABAPExtensibilityVariant.js.map