/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions","sap/ui/fl/write/api/Adaptations","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel"],function(e,t,r,n,a,i,o,s,l,d,c,p,u,f,v,y,g){"use strict";var h={};var A;var I=[f.VENDOR,f.PARTNER,f.CUSTOMER_BASE,f.CUSTOMER];var x={};function m(e){var t=a.getFlexReferenceForControl(e);if(!t){throw Error("The application ID could not be determined")}return t}function C(e,t,r){if(r){return c.updateModelFromBackend({reference:t.appId,layer:t.layer}).then(function(){return e})}c.onAllChangesSaved({reference:t.appId,layer:t.layer,contextBasedAdaptation:true});return Promise.resolve(e)}x.initialize=function(t){A||=e.getResourceBundleFor("sap.ui.fl");if(!t.layer){return Promise.reject("No layer was provided")}if(!t.control){return Promise.reject("No control was provided")}var r=m(t.control);t.reference=r;var n=t.layer;if(h&&h[r]&&h[r][n]){return Promise.resolve(h[r][n])}var a;return u.isContextBasedAdaptationAvailable(n).then(function(e){a=e;var r=a?x.load(t):Promise.resolve({adaptations:[]});return r}).then(function(e){var r=o.getByReference(t.reference);var n=e.adaptations[0];if(r.adaptationId){n=e.adaptations.find(function(e){return e.id===r.adaptationId})||n}return x.createModel(e.adaptations,n,a)}).then(function(e){h[r]||={};h[r][n]||={};h[r][n]=e;return h[r][n]})};x.createModel=function(e,t,r){if(!Array.isArray(e)){throw Error("Adaptations model can only be initialized with an array of adaptations")}if(r&&!t){throw Error("Invalid call, must pass displayed adaptation")}if(!r&&e.length){throw Error("Invalid call, must not pass adaptations if feature is disabled")}const n=new g({allAdaptations:[],adaptations:[],count:0,displayedAdaptation:{},contextBasedAdaptationsEnabled:r});n.updateAdaptations=function(e){const t=e.filter(function(e,t){e.rank=t+1;return e.type!==p.Type.Default});n.setProperty("/adaptations",t);n.setProperty("/allAdaptations",e);n.setProperty("/count",t.length);let r=n.getProperty("/displayedAdaptation");const a=e.find(function(e){return!!r&&e.id===r.id});if(a){r={...a};n.setProperty("/displayedAdaptation",r)}n.updateBindings(true)};n.insertAdaptation=function(e){const t=n.getProperty("/allAdaptations");t.splice(e.priority,0,e);delete e.priority;n.updateAdaptations(t)};n.deleteAdaptation=function(){const e=n.getProperty("/displayedAdaptation").rank-1;const t=n.getProperty("/adaptations");const r=n.getProperty("/count");let a;if(r>1){a=t[e+(e===r-1?-1:1)].id}t.splice(e,1);const i=n.getProperty("/allAdaptations").pop();t.push(i);n.updateAdaptations(t);return a};n.switchDisplayedAdaptation=function(e){const t=n.getIndexByAdaptationId(e);const r=t?n.getProperty("/allAdaptations")[t]:n.getProperty("/allAdaptations")[0];n.setProperty("/displayedAdaptation",r);n.updateBindings(true)};n.updateAdaptationContent=function(e){const t=n.getProperty("/allAdaptations");const r=t.find(function(t){return e.adaptationId===t.id});r.title=e.title;r.contexts=e.contexts;const a=r.rank-1;if(a!==e.priority){const r=t.splice(a,1);t.splice(e.priority,0,r[0])}n.updateAdaptations(t)};n.getIndexByAdaptationId=function(e){const t=n.getProperty("/allAdaptations");const r=t.findIndex(function(t){return t.id===e});return r>-1?r:undefined};if(e.length>0){n.updateAdaptations(e);n.setProperty("/displayedAdaptation",t)}return n};x.getAdaptationsModel=function(e){if(!e.layer){throw Error("No layer was provided")}if(!e.control){throw Error("No control was provided")}e.reference=m(e.control);var t=e.reference;var r=e.layer;if(!x.hasAdaptationsModel(e)){throw Error(`Adaptations model for reference '${t}' and layer '${r}' were not initialized.`)}return h[t][r]};x.getDisplayedAdaptationId=function(e){var t=this.getAdaptationsModel(e).getProperty("/displayedAdaptation/id");return t!==p.Type.Default?t:undefined};x.hasAdaptationsModel=function(e){var t=e.reference;var r=e.layer;return h[t]&&h[t][r]};x.adaptationExists=function(e){var t=e.reference;var r=e.layer;return this.hasAdaptationsModel({reference:t,layer:r})&&h[t][r].getProperty("/count")>0};x.clearInstances=function(){h={}};x.refreshAdaptationModel=function(e){this.clearInstances();return this.initialize(e).then(function(e){return e.getProperty("/displayedAdaptation/id")})};function P(e,t){return e.get(t)||t}function V(e,t){return d.contextBasedAdaptation.create({layer:e.layer,flexObject:t,appId:e.appId,parentVersion:_(e)}).then(function(r){var n=this.getAdaptationsModel(e);n.insertAdaptation(t);return C(r,e)}.bind(this))}function w(e,t){return d.write({layer:e.layer,flexObjects:t,transport:"",isLegacyVariant:false,parentVersion:_(e)})}function b(e,t,n){if(n.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=t.filter(function(e){return e.getChangeType()==="updateVariant"&&e.getSelector().variantId===n.getId()});var i=n.clone();a.forEach(r.applyChangeOnVariant.bind(r,i));i.removeAllChanges();i.destroy();return i.mProperties}return e.find(function(e){return e.key===n.getId()})}function j(e,t){var r={};var n=[];e.forEach(function(e){var a=t[e.getId()];if(a.visible){var i=true;var o=Object.keys(a.contexts);o.forEach(function(t){var n=Array.from(a.contexts[t]);n.forEach(function(t){i=false;if(r[t]){r[t].variants.push(e)}else{r[t]={contextBasedAdaptationId:y.createDefaultFileName(),variants:[e]}}})});if(i){n.push(e)}}});return{uniqueContexts:r,unrestrictedViews:n}}function O(e,t,r,n){if(e.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=e.getPersistencyKey();e=s.updateVariant({reference:t.appId,persistencyKey:a,id:e.getId(),layer:t.layer,visible:false,adaptationId:r,forceCreate:true});return e.getChanges().reverse()[0].convertToFileContent()}var i=y.getAppComponentForControl(t.control);var o=n.createVariantChange(e.getVariantManagementReference(),{changeType:"setVisible",visible:false,variantReference:e.getId(),layer:t.layer,appComponent:i,adaptationId:r});return o.convertToFileContent()}function E(e,t,r){var n=e.filter(function(e){return r===e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")&&e.getLayer()===t});return n}function F(e){var t=e.getFileType();if(t==="change"){if(e.getSelector().variantId){return e.getSelector().variantId}if(e.getVariantReference()){return e.getVariantReference()}}else if(t==="ctrl_variant_change"){return e.getVariantId()}return undefined}function B(e){if(e.getFileType()==="ctrl_variant_change"&&e.getChangeType()==="setContexts"){return true}return false}function M(e,t){return t.filter(function(t){var r=F(t);if(B(t)){return false}return!r||e.indexOf(r)<0})}function T(e,t){var r=[];var n=[];var a=new Map;e.forEach(function(e){if(e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")){r.push(e)}else{n.push(e)}});var i=N(r,a,t);var o=S(n,a,t);return i.concat(o).map(function(e){return e.convertToFileContent()})}function N(e,r,n){var a=[];e.forEach(function(e){var i=t.createFromFileContent(e.cloneFileContentWithNewId());i.setAdaptationId(n);i.setContexts();r.set(e.getId(),i.getId());a.push(i)});return a}function S(e,r,n){const a=[];e.forEach(function(e){const i=t.createFromFileContent(e.cloneFileContentWithNewId());const o=i.getContent();if(e.getFileType()==="change"){if(e.getSelector().variantId){const e=i.getSelector();e.variantId=P(r,i.getSelector().variantId);i.setSelector(e)}else if(e.getContent().defaultVariantName){o.defaultVariantName=P(r,i.getContent().defaultVariantName);i.setContent(o)}if(e.getVariantReference()){i.setVariantReference(P(r,i.getVariantReference()))}if(e.getChangeType()==="updateVariant"){delete i.getContent().contexts;if(!Object.keys(i.getContent()).length){return}}}else if(e.getFileType()==="ctrl_variant_change"){i.setVariantId(P(r,i.getVariantId()))}else if(e.getFileType()==="ctrl_variant_management_change"&&e.getContent().defaultVariant){o.defaultVariant=P(r,i.getContent().defaultVariant);i.setContent(o)}i.setAdaptationId(n);a.push(i)});return a}function _(e){return c.getVersionsModel({layer:e.layer,reference:e.appId}).getProperty("/persistedVersion")}function R(e,t,r,n,a){var i={contextBasedAdaptations:[],flexObjects:[]};var o={};e.forEach(function(e){o[e.getId()]=b(t,r,e)});var s=j(e,o);var l=s.uniqueContexts;var d=s.unrestrictedViews;Object.entries(l).forEach(function(t){var o=t[0];var s=t[1];s.variants=s.variants.concat(d);var l=s.contextBasedAdaptationId;var c={id:l,title:A.getText("CBA_MIGRATED_ADAPTATION_TITLE",[o]),contexts:{role:[o]},priority:0};i.contextBasedAdaptations.push(c);var p=s.variants.filter(function(e){return e.getLayer()===f.CUSTOMER});var u=new Map;var v=N(p,u,l);v.forEach(function(e){i.flexObjects.push(e.convertToFileContent())});var y=s.variants.map(function(e){return e.getId()});var g=e.map(function(e){return e.getId()}).filter(function(e){return y.indexOf(e)<0});var h=M(g,r);var I=S(h,u,l);I.forEach(function(e){i.flexObjects.push(e.convertToFileContent())});e.forEach(function(e){if(e.getLayer()!==f.CUSTOMER&&y.indexOf(e.getId())<0){i.flexObjects.push(O(e,n,l,a))}})});e.forEach(function(e){var t=o[e.getId()];var r=d.indexOf(e)<0;if(t.visible===true&&r){i.flexObjects.push(O(e,n,undefined,a))}});return i}function D(){return new Promise(function(e){sap.ui.require(["sap/ui/fl/variants/VariantManager"],function(t){e(t)})})}x.migrate=async function(e){e.appId=m(e.control);var t=_(e);e.parentVersion=t;var r=[];var i=n.getAllVariants(a.getFlexReferenceForControl(e.control));var o={contextBasedAdaptation:[],flexObjects:[]};const s=await D();return l.getFlexObjects({selector:e.control,includeManifestChanges:true,includeAnnotationChanges:true,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(e){I.forEach(function(t){r.push(E(e,t,true))});r.push(E(e,f.CUSTOMER,false));return Promise.all(r)}).then(function(t){var r=t.pop();var n=t.flat();o=R(n,i,r,e,s);var a=Promise.resolve();o.contextBasedAdaptations.forEach(function(t){a=a.then(V.bind(this,e,t))}.bind(this));return a}.bind(this)).then(function(){if(o.flexObjects.length>0){return w(e,o.flexObjects)}return Promise.resolve()}).then(function(){return this.refreshAdaptationModel({control:e.control,layer:e.layer})}.bind(this))};x.canMigrate=function(e){var t=x.getAdaptationsModel(e);if(t.getProperty("/count")!==0){return Promise.resolve(false)}return l.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(t){var r=[];I.forEach(function(e){r.push(E(t,e,true))});r=r.flat();var i=n.getAllVariants(a.getFlexReferenceForControl(e.control));return r.some(function(e){var r=b(i,t,e);return r.visible===true&&Object.keys(r.contexts).some(function(e){return r.contexts[e].length!==0})})})};x.create=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}e.contextBasedAdaptation.id=y.createDefaultFileName();e.appId=m(e.control);return V.call(this,e,e.contextBasedAdaptation).then(function(){return l.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true,currentLayer:f.CUSTOMER})}).then(function(t){var r=v.filterChangeOrChangeDefinitionsByCurrentLayer(t,f.CUSTOMER);var n=T(r,e.contextBasedAdaptation.id);return w(e,n)})};x.update=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.update({layer:e.layer,flexObject:e.contextBasedAdaptation,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e)})};x.reorder=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.parameters||!e.parameters.priorities){return Promise.reject("No valid priority list was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.reorder({layer:e.layer,flexObjects:e.parameters,appId:e.appId,parentVersion:_(e)}).then(function(t){return C(t,e)})};x.load=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.load({layer:e.layer,appId:e.appId,version:_(e)}).then(function(e){e||={adaptations:[]};return e})};x.remove=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return d.contextBasedAdaptation.remove({layer:e.layer,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e,true)})};return x});
//# sourceMappingURL=ContextBasedAdaptationsAPI.js.map