/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_omit","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/flexState/changes/UIChangeManager","sap/ui/fl/write/_internal/flexState/FlexObjectManager","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,n,r,s,a,o,i,l,c,f,u,g,p,h,d,y,x,C){"use strict";var b={};function F(e){return e._getMap&&r.getChangeTypes().includes(e._getMap().changeType)||e.getChangeType&&r.getChangeTypes().includes(e.getChangeType())}function m(e){e.includeCtrlVariants=true;return b._getUIChanges(e).then(function(e){return e.length>0})}b.hasDirtyChanges=function(e){return p.hasDirtyFlexObjects(e)};b.hasHigherLayerChanges=function(e){e.upToLayer||=x.getCurrentLayer();return p.getFlexObjects(e).then(function(t){return t.filter(function(t){return x.isOverLayer(t.getLayer(),e.upToLayer)})}).then(function(t){if(t.length===0){return false}return p.filterHiddenFlexObjects(t,e.reference).length>0})};b.save=async function(e){const t=i.getFlexReferenceForControl(e.selector);let n=c.getByReference(t);n.saveChangeKeepSession=true;c.setByReference(n,t);const r=await p.saveFlexObjects(e);if(r?.length>0){await b.updateResetAndPublishInfo(e)}n=c.getByReference(t);delete n.saveChangeKeepSession;c.setByReference(n,t);return r};b.updateResetAndPublishInfo=async function(e){const[n,r]=await Promise.all([m(e),d.isPublishAvailable()]);const s={isResetEnabled:n,isPublishEnabled:false,allContextsProvided:true};const a=e.layer!==y.USER&&e.layer!==y.PUBLIC;if(a){try{const t=await h.getFlexInfo(e);s.allContextsProvided=t.allContextsProvided!==false;s.isResetEnabled=t.isResetEnabled;s.isPublishEnabled=r&&t.isPublishEnabled}catch(e){t.error(`Sending request to flex/info route failed: ${e.message}`)}}const l=i.getFlexReferenceForControl(e.selector);const f=c.getByReference(l);const u={...f,...s};c.setByReference(u,l);o.setAllContextsProvided(l,u.allContextsProvided)};b.getResetAndPublishInfoFromSession=function(e){var t=i.getFlexReferenceForControl(e)||"true";return JSON.parse(window.sessionStorage.getItem(`sap.ui.fl.info.${t}`))};b.reset=function(t){var n=C.getAppComponentForSelector(t.selector);return p.resetFlexObjects({...e(t,"selector"),appComponent:n})};b.add=function(e){const t=C.getAppComponentForSelector(e.selector);const n=i.getFlexReferenceForSelector(e.selector);function r(e){if(F(e)){return e.store()}if(e instanceof a){return g.addDirtyChanges(n,[e],t)?.[0]}return p.addDirtyFlexObjects(n,[e])?.[0]}if(e.change&&e.flexObjects){throw new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property.")}if(e.change){return r(e.change)}const s=e.flexObjects.some(function(e){return F(e)});if(s){return e.flexObjects.map(r)}const o=[];const l=[];e.flexObjects.forEach(e=>{if(e instanceof a){o.push(e)}else{l.push(e)}});const c=p.addDirtyFlexObjects(n,l);const f=g.addDirtyChanges(n,o,t);return e.flexObjects.map(e=>c.find(t=>t===e)||f.find(t=>t===e))};b.remove=function(e){if(e.change&&e.flexObjects){return Promise.reject(new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property."))}if(!e.selector){return Promise.reject(new Error(`An invalid selector was passed so change could not be removed with id: ${e.change.getId()}`))}const t=C.getAppComponentForSelector(e.selector);if(!t){return Promise.reject(new Error(`Invalid application component for selector, change could not be removed with id: ${e.change.getId()}`))}const r=e.change?[e.change]:e.flexObjects;const a=i.getFlexReferenceForSelector(e.selector);r.forEach(function(e){if(e.isValidForDependencyMap()){const r=n.bySelector(e.getSelector(),t);if(r){s.destroyAppliedCustomData(r,e,n)}}});p.deleteFlexObjects({reference:a,flexObjects:r});return Promise.resolve()};b.getChangesWarning=function(e){return this._getUIChanges(e).then(function(e){var t=e.some(function(e){return e.isChangeFromOtherSystem()});var n=f.getInstanceOrUndef();var r=n&&n.isProductiveSystemWithTransports();var s=e.length===0;var a={showWarning:false};if(t){a={showWarning:true,warningType:"mixedChangesWarning"}}if(r&&s){a={showWarning:true,warningType:"noChangesAndPSystemWarning"}}return a})};b._condense=function(e){return Promise.resolve().then(function(){if(!e.selector){throw Error("An invalid selector was passed")}var t=C.getAppComponentForSelector(e.selector);if(!t){throw Error("Invalid application component for selector")}if(!e.changes||e.changes&&!Array.isArray(e.changes)){throw Error("Invalid array of changes")}return u.condense(t,e.changes)})};b._getUIChanges=function(e){if(e.layer){e.currentLayer=e.layer}e.invalidateCache=false;return p.getFlexObjects(e)};b._getAnnotationChanges=function(e){const t=i.getFlexReferenceForControl(e.control);return o.getAnnotationChanges(t)};b._getFlexObjectsForUser=async function(e){const t=l.getUserId();const n=await b._getUIChanges(e);return n.filter(e=>e.getSupportInformation().user===t)};b.setAdaptationLayer=function(e,t){const n=i.getFlexReferenceForControl(t);const r=c.getByReference(n);r.adaptationLayer=e;c.setByReference(r,n)};return b});
//# sourceMappingURL=PersistenceWriteAPI.js.map