/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/hash","sap/base/util/restricted/_uniqBy","sap/base/util/each","sap/base/util/merge","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/initial/api/Version","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils"],function(e,t,r,n,i,s,a,o,c,l){"use strict";const f={isKeyUser:true,isVariantSharingEnabled:true,isProductiveSystem:false,isCondensingEnabled:true,isContextSharingEnabled:false,isVersioningEnabled:true,logonUser:"DEFAULT_USER",isVariantAuthorNameAvailable:false,isAnnotationChangeEnabled:true};function u(e){var t=[];return l.forEachObjectInStorage(e,function(e){t.push(e.changeDefinition)}).then(function(){return t})}function d(e,t){var r=true;if(e.selectorIds){if(t.selector){r=e.selectorIds.indexOf(t.selector.id)>-1}else{r=false}}if(r&&e.changeTypes){r=e.changeTypes.indexOf(t.changeType)>-1}return r}function h(e,t){if(!e.creation){var r=Date.now()+t;e.creation=new Date(r).toISOString()}return e}function v(t){return e(t.reduce(function(e,t){return e+new Date(t.creation).getTime()},""))}function g(e,t){r(e,function(e,n){n.forEach(function(e){r(e,function(e,r){t(r,e)})})})}function m(e,t){var r=[];var n=0;g(e,function(e,i){var s=l.createFlexKey(i);var a=t.condensedChanges.find(function(t){return t.getId()===e.fileName});if(!a.getCreation()){var o=Date.now()+n;n++;a.setCreation(new Date(o).toISOString())}r.push({key:s,value:a})});return r}function y(e,t){var r=[];g(e,function(e,n){var i=l.createFlexKey(n);var s;t.some(function(e){if(e.getId()===n){s=e;return true}});r.push({key:i,value:s})});return r}function b(e,t){var n=[];r(e,function(e,r){if(r.length<2){return}var i=t.filter(function(t){return t.getFileType()===e});i.forEach(function(e,t){if(r.indexOf(e.getId())>-1&&t<i.length-1){var s=i[t+1];var a=new Date(e.getCreation());var o=new Date(s.getCreation());if(s&&a>=o){var c=a.getTime()+1;s.setCreation(new Date(c).toISOString());var f=l.createFlexKey(s.getId());n.push({key:f,value:s})}}})});return n}function p(e){var t=[];if(e){Object.values(e).forEach(function(e){e.forEach(function(e){var r=l.createFlexKey(e);t.push(this.storage.removeItem(r))}.bind(this))}.bind(this))}return t}var O=n({},o,{storage:undefined,layers:["ALL"],async loadFlexData(e){const t=await u({storage:this.storage,reference:e.reference});const r=await this.versions.getVersionChain.call(this,e,e.version);const n=t.filter(e=>e.version===undefined||r.includes(e.version));const i=c.sortFlexObjects(n);const s=c.getGroupedFlexObjects(i);const a=c.filterAndSortResponses(s);if(a.length){a[0].cacheKey=v(i)}return a},async write(e){const t=await this.loadFeatures();let r;if(t.isVersioningEnabled&&e.layer===i.CUSTOMER){e.reference=e.flexObjects[0]?.reference;r=await this.versions.getDraftId.call(this,e)}let n=0;const s=[];for(const t of e.flexObjects){if(r){t.version=r}const e=l.createFlexObjectKey(t);const i=h(t,++n);const a=this.storage._itemsStoredAsObjects?i:JSON.stringify(i);await this.storage.setItem(e,a);s.push(i)}return{response:s}},async update(e){var t=e.flexObject;if(f.isVersioningEnabled&&e.layer===i.CUSTOMER){e.reference=t.reference;const r=await this.versions.load.call(this,e);const n=r.find(e=>e.isDraft)?.id;if(n){t.version=n}}var r=l.createFlexObjectKey(e.flexObject);var n=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);var s=this.storage.setItem(r,n);return Promise.resolve(s)},reset(e){return l.forEachObjectInStorage({storage:this.storage,reference:e.reference,layer:e.layer},function(t){if(d(e,t.changeDefinition)){return Promise.resolve(this.storage.removeItem(t.key)).then(function(){return{fileName:t.changeDefinition?.fileName||t.changeDefinition?.id}})}}.bind(this)).then(function(e){return{response:e.filter(function(e){return!!e})}})},remove(e){var t=l.createFlexObjectKey(e.flexObject);this.storage.removeItem(t);var r=this.storage.removeItem(t);return Promise.resolve(r)},loadFeatures(){return Promise.resolve(f)},loadVariantsAuthors(){return Promise.reject("loadVariantsAuthors is not implemented")},getFlexInfo(e){e.storage=this.storage;return l.getAllFlexObjects(e).then(function(e){return{isResetEnabled:e.length>0}})},async condense(e){var r=e.flexObjects;var n=[];n=n.concat(m(r.create,e));n=n.concat(y(r.update,e.condensedChanges));n=n.concat(b(r.reorder,e.condensedChanges));n=t(n,"key");var s=[];var a=[];s=s.concat(p.call(this,r.delete));const o=await this.loadFeatures();let c;if(o.isVersioningEnabled&&e.layer===i.CUSTOMER&&(r.create&&Object.keys(r.create).length!==0||r.update&&Object.keys(r.update).length!==0||r.reorder&&Object.keys(r.reorder).length!==0)){c=await this.versions.getDraftId.call(this,e)}n.forEach(function(e){var t=e.value.convertToFileContent();if(c){t.version=c}a.push(t);var r=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);s.push(this.storage.setItem(e.key,r))}.bind(this));if(o.isVersioningEnabled&&e.layer===i.CUSTOMER&&r.delete&&Object.keys(r.delete).length!==0){const t=await this.versions.load.call(this,e);if(t.length){const n=t.find(e=>e.isDraft);Object.values(r.delete).forEach(function(e){e.forEach(function(e){n.filenames=n.filenames.filter(function(t){return t!==e})})});if(!n.filenames.length){await this.versions.discardDraft.call(this,e)}}}return Promise.all(s).then(function(){return Promise.resolve({response:a})})},versions:{async getDraftId(e){let t=[];if(e.condensedChanges){t=e.condensedChanges.map(e=>e.sId)}else{t=e.flexObjects.map(e=>e.fileName)}const r=await this.versions.load.call(this,e);let n=r.find(e=>e.isDraft);if(n&&e.parentVersion===a.Number.Draft){if(e.condensedChanges){n.filenames=[]}n.filenames=t.concat(n.filenames)}else{if(n&&e.parentVersion!==a.Number.Draft){await this.versions.discardDraft.call(this,e)}n={version:a.Number.Draft,id:s.createDefaultFileName("version"),isDraft:true,activatedAt:"",activatedBy:"",fileType:"version",layer:i.CUSTOMER,title:"",reference:e.reference,filenames:t};if(e.parentVersion!==a.Number.Original){n.parentVersion=e.parentVersion}}const o=l.createFlexKey(`${n.id}`);const c=this.storage._itemsStoredAsObjects?n:JSON.stringify(n);await this.storage.setItem(o,c);return n.id},async getVersionChain(e,t){const r=[];const n=(e,t)=>e===t.version;const i=await this.versions.load.call(this,e);t||=i.find(e=>!e.isDraft)?.id;while(t&&t!==a.Number.Original){const e=i.find(n.bind(undefined,t));r.push(e.id);t=e.parentVersion}return r},async load(e){const t=await u({storage:this.storage,reference:e.reference});return t.filter(e=>e.fileType==="version").sort((e,t)=>{if(e.isDraft){return-1}if(t.isDraft){return 1}return e.activatedAt<t.activatedAt?1:-1})},async activate(e){const t=await this.loadFeatures();const r=await this.versions.load.call(this,e);var n=r.find(t=>t.version===e.version);if(n){if(!n.isDraft){n.id=s.createDefaultFileName("version");n.parentVersion=e.version}}else{const t=s.createDefaultFileName("version");n={version:t,id:t,fileType:"version",layer:i.CUSTOMER,reference:e.reference}}if(e.version!==a.Number.Draft){const t=r.find(e=>e.isDraft);if(t){await this.versions.discardDraft.call(this,e)}}const o=l.createFlexKey(n.id);n.title=e.title;n.activatedAt=new Date(Date.now()).toISOString();n.activatedBy=t.logonUser;n.isDraft=false;n.version=n.id;delete n.filenames;const c=this.storage._itemsStoredAsObjects?n:JSON.stringify(n);this.storage.setItem(o,c);return n},async discardDraft(e){e.storage=this.storage;const t=await this.versions.load.call(this,e);const r=t.find(e=>e.isDraft)?.id;if(!r){return Promise.reject("no version to discard")}const n=await u(e);const i=n.filter(e=>e.version===r);const s=t.find(e=>e.id===r);i.push(s);const a=i.map(e=>{var t=l.createFlexKey(e.fileName||e.id);return this.storage.removeItem(t)});await Promise.all(a)}}});return O});
//# sourceMappingURL=ObjectStorageConnector.js.map