/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/ui/core/Element","sap/ui/core/Supportability","sap/base/util/fetch"],function(e,t,r,o){"use strict";var i=t.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"},card:{type:"sap.ui.integration.widgets.Card"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},formData:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},cardConfigurationChange:{parameters:{card:{type:"sap.ui.core.Control"},changes:{type:"object"}}},cardStateChanged:{parameters:{card:{type:"sap.ui.core.Control"}}},cardInitialized:{parameters:{card:{type:"sap.ui.core.Control"}}},message:{parameters:{data:{type:"object"}}}}}});i.prototype.init=function(){this._handlePostMessageBound=this._handlePostMessage.bind(this)};i.prototype.getDestination=function(e,t){var r=this.getResolveDestination(),o;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+e+"'. There is no 'resolveDestination' callback function configured in the host.")}o=r(e,t);if(o===null||o===undefined){return Promise.reject("Destination '"+e+"' could not be resolved by the host.")}if(o instanceof Promise){return o}return Promise.resolve(o)};i.prototype.getCsrfToken=function(e){return Promise.resolve()};i.prototype.csrfTokenFetched=function(e,t){};i.prototype.csrfTokenExpired=function(e){};i.prototype.getContextValue=function(e){if(!e){return Promise.resolve(null)}return Promise.resolve(null)};i.prototype.getDestinations=function(){return Promise.resolve([])};i.prototype.getContexts=function(){return Promise.resolve({})};i.prototype.useExperimentalCaching=function(){this.bUseExperimentalCaching=true;this.subscribeForMessages()};i.prototype.stopUsingExperimentalCaching=function(){this.bUseExperimentalCaching=false;this.unsubscribeForMessages()};i.prototype.modifyRequestHeaders=function(e,t,r){return e};i.prototype.modifyRequest=function(e,t,r){return e};i.prototype.fetch=function(e,t,i,a){if(r.isStatisticsEnabled()){e=this._addStatisticsParameter(e)}if(this.bUseExperimentalCaching){this._addCacheHeaders(t.headers,i)}return o(e,t)};i.prototype.getAnalyticsCloudWidgetSrc=function(){};i.prototype._addStatisticsParameter=function(e){var t=new URL(e,window.location.href);t.searchParams.set("sap-statistics","true");return t.href};i.prototype._addCacheHeaders=function(e,t){var r=t.cache,o=[];if(r.enabled===false){o.push("max-age=0");o.push("no-store")}else{o.push("max-age="+parseInt(r.maxAge||0));if(r.staleWhileRevalidate){o.push("x-stale-while-revalidate")}}if(o.length){e.set("Cache-Control",o.join(", "))}e.set("x-sap-card","true");e.set("x-use-cryptocache","true")};i.prototype.subscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.addEventListener("message",this._handlePostMessageBound)};i.prototype.unsubscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.removeEventListener("message",this._handlePostMessageBound)};i.prototype._handlePostMessage=function(e){this.fireMessage({data:e.data})};return i});
//# sourceMappingURL=Host.js.map