/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalContentRenderer","./BaseContent","sap/f/cards/loading/AnalyticalPlaceholder","sap/m/IllustratedMessageType","sap/ui/core/Lib","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/base/util/merge"],function(t,e,a,i,n,o,r,s,p){"use strict";var l=o.CardActionArea;var c,u,d,g,h,v;var f={Top:"top",Bottom:"bottom",Left:"left",Right:"right"};var y={TopLeft:"topLeft",Center:"center"};var m={Left:"left",Center:"center",Right:"right"};var _={Line:"line",StackedColumn:"stacked_column",StackedBar:"stacked_bar",Donut:"donut"};var A={Chart:"Chart",Full:"Full"};var C=e.extend("sap.ui.integration.cards.AnalyticalContent",{metadata:{library:"sap.ui.integration"},renderer:t});C.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oPopover){this._oPopover.destroy()}};C.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();if(!t){return}this._createChart()};C.prototype.createLoadingPlaceholder=function(e){return new a({chartType:e.chartType,minHeight:this.getOverflowWithShowMore()?0:t.getMinHeight(e)})};C.prototype.loadDependencies=function(t){return new Promise(function(t,e){n.load("sap.viz").then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/controls/Popover","sap/viz/ui5/data/FlattenedDataset","sap/viz/ui5/data/MeasureDefinition","sap/viz/ui5/data/DimensionDefinition"],function(e,a,i,n,o,r){c=e;u=a;g=i;d=n;h=o;v=r;t()},function(t){e(t)})}).catch(function(){e("Analytical content type is not available with this distribution.")})})};C.prototype.onDataChanged=function(){this._updateChart();var t=this.getAggregation("_content");if(t){var e=t._getVizDataset(),a=e&&e._FlatTableD&&e._FlatTableD._data&&Array.isArray(e._FlatTableD._data)&&e._FlatTableD._data.length;if(a){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:i.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}}};C.prototype._createChart=function(){var t=this.getParsedConfiguration();if(!t.chartType){s.error('"sap.card".content.chartType is mandatory property.',null,"sap.ui.integration.widgets.Card");return}var e=r.resolveValue(t,this,"/");var a=new c({uiConfig:{applicationSet:"fiori"},height:"100%",width:"100%",vizType:_[e.chartType]||e.chartType});this.setAggregation("_content",a);this._attachActions(t);if(e.popover&&e.popover.active){this._attachPopover()}};C.prototype._supportsOverflow=function(){return false};C.prototype._updateChart=function(){var t=this.getParsedConfiguration();var e=this.getAggregation("_content");var a=r.resolveValue(t,this,"/");if(!e){return}e.destroyDataset().destroyFeeds();e.applySettings({vizProperties:this._getVizProperties(a),dataset:this._getDataset(t,a),feeds:this._getFeeds(a),vizType:_[a.chartType]||a.chartType})};C.prototype._attachActions=function(t){var e={area:l.Content,actions:t.actions,control:this};if(t.actionableArea===A.Chart){e.eventName="selectData";e.actionControl=this.getAggregation("_content");this._oActions.setBindingPathResolver(t=>{const e=this._getContextPath(t);return e})}else{e.eventName="press"}this._oActions.attach(e)};C.prototype._attachPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=new g;this._oPopover.connect(this.getAggregation("_content").getVizUid());const t=this.getParsedConfiguration();const e=t.popover.actionsStrip;if(e&&e[0]?.actions?.length){const t=e[0];const a=this.getAggregation("_content");a.attachSelectData(e=>{const i=this._getContextPath(e);const n=r.resolveValue(t,this,i);this._oPopover.setActionItems([{type:"action",text:n.text,press:()=>{this._oActions.fireAction(a,n.actions[0].type,n.actions[0].parameters)}}])})}};C.prototype._getVizProperties=function(t){if(!t){return null}var e=t.title,a=t.legend,i=t.plotArea;var n={title:{style:{fontWeight:"normal"},layout:{respectPlotPosition:false}},legend:{},legendGroup:{layout:{}},plotArea:{window:{start:"firstDataPoint",end:"lastDataPoint"}},categoryAxis:{title:{}},valueAxis:{title:{}},interaction:{noninteractiveMode:true}};if(t.actions||t.popover){var o=t.actionableArea===A.Chart||t.popover&&t.popover.active;n.interaction.noninteractiveMode=!o}if(e){n.title.text=e.text;n.title.visible=e.visible;n.title.alignment=m[e.alignment];s.warning('"sap.card".content.title is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(a){n.legend.visible=a.visible;n.legendGroup.layout.position=f[a.position];n.legendGroup.layout.alignment=y[a.alignment];s.warning('"sap.card".content.legend is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(i){if(i.dataLabel){n.plotArea.dataLabel=i.dataLabel}if(i.categoryAxisText){n.categoryAxis.title.visible=i.categoryAxisText.visible}if(i.valueAxisText){n.valueAxis.title.visible=i.valueAxisText.visible}s.warning('"sap.card".content.plotArea is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}p(n,t.chartProperties);return n};C.prototype._getDataset=function(t,e){var a,i;if(t.dimensions){i=t.dimensions.map(function(t,a){return new v({name:e.dimensions[a].name||e.dimensions[a].label,value:t.value,displayValue:t.displayValue,dataType:t.dataType})})}if(t.measures){a=t.measures.map(function(t,a){return new h({name:e.measures[a].name||e.measures[a].label,value:t.value})})}return new d({measures:a,dimensions:i,data:{path:this.getBindingContext().getPath()}})};C.prototype._getFeeds=function(t){var e=t.feeds;if(t.measureAxis||t.dimensionAxis){s.warning('"sap.card".content.measureAxis and "sap.card".content.dimensionAxis are deprecated. Use "sap.card".content.feeds instead',null,"sap.ui.integration.widgets.Card");e=[{uid:t.measureAxis,type:"Measure",values:t.measures.map(function(t){return t.label})},{uid:t.dimensionAxis,type:"Dimension",values:t.dimensions.map(function(t){return t.label})}]}return e.map(function(t){return new u(t)})};C.prototype._getContextPath=function(t){const e=t.getParameter("data")[0].data._context_row_number;const a=this.getBindingContext().getPath();return a!=="/"?a+"/"+e:a+e};C.prototype.getFocusDomRef=function(){return this.getAggregation("_content").getDomRef().querySelector(".v-info")||this.getDomRef()};return C});
//# sourceMappingURL=AnalyticalContent.js.map