/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/base/Log","sap/base/util/deepClone","sap/ui/integration/util/AnalyticsCloudHelper"],function(t,e,n,i,o,s,r,a){"use strict";var d=e.extend("sap.ui.integration.cards.AnalyticsCloudContent",{metadata:{library:"sap.ui.integration"},renderer:t});d.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=this.getId()+"-widgetContainer";this._oWidgetContainer=new n(t,{content:"<div id="+t+" class='sapUiIntAnalyticsCloudContentContainer'></div>"});this.setAggregation("_content",this._oWidgetContainer)};d.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oWidgetContainer){this._oWidgetContainer.destroy();this._oWidgetContainer=null}};d.prototype.loadDependencies=function(t){return a.loadWidget(this.getCardInstance()?.getHostInstance())};d.prototype.applyConfiguration=function(){this.fireEvent("_actionContentReady")};d.prototype.getStaticConfiguration=function(){return this._getResolvedConfiguration()};d.prototype.onAfterRendering=function(){if(this.getAggregation("_blockingMessage")){return}this._renderWidget()};d.prototype._supportsOverflow=function(){return false};d.prototype._renderWidget=function(){if(this._bIsBeingDestroyed){return}const t=this.getCardInstance();if(!t.isReady()){t.attachEventOnce("_ready",()=>{this.invalidate()});return}if(!sap?.sac?.api?.widget){this._showError("Object sap.sac.api.widget not found on the page.");return}const e=this._getResolvedConfiguration();if(!e.sacTenantDestination){this._showError("Required configuration /sap.card/content/sacTenantDestination was not found or is empty.");return}const n=this._oWidgetContainer.getId();const i=e?.widget;const o=e?.interpretation;const s=this._getOptions(e);if(i){sap.sac.api.widget.renderWidget(n,{proxy:e.sacTenantDestination},i.storyId,i.widgetId,s)}else if(o){sap.sac.api.widget.renderWidgetForJustAsk(n,{proxy:e.sacTenantDestination},o,s)}else{this._showError("Required configuration /sap.card/content/widget or /sap.card/content/interpretation was not found or is empty.")}};d.prototype._getResolvedConfiguration=function(){return i.resolveValue(this.getParsedConfiguration(),this,this.getBindingContext()?.getPath()||"/")};d.prototype._getOptions=function(t){const e=r(t.options)||{};const n={enableInteraction:false,enableUndoRedo:false,enableMenus:false,showHeader:false,showFooter:false};e.attributes=Object.assign({},n,e.attributes);e.renderComplete={onSuccess:this._onWidgetSuccess.bind(this),onFailure:this._onWidgetFailure.bind(this)};return e};d.prototype._onWidgetSuccess=function(){const t=this._getResolvedConfiguration()?.widget?.widgetId||"interpretation";s.info(`Widget rendered successfully: ${t}`,this);this._updateWidgetInfo()};d.prototype._onWidgetFailure=function(t){const e=this._getResolvedConfiguration()?.widget;const n=e?.storyId||"interpretation";const i=e?.widgetId||"interpretation";let o=`There was a failure in sap.sac.api.widget.renderWidget with storyId ${n} and widgetId ${i}.`;if(t instanceof Error){o+=" "+t.toString();s.error(t.stack)}else if(typeof t==="object"){o+=" "+JSON.stringify(t)}else if(t){o+=" "+t}s.error(o,this);this._updateWidgetInfo()};d.prototype._updateWidgetInfo=async function(){const t=this.getCardInstance();const e=this._oWidgetContainer.getId();let n={};try{n=await sap.sac.api.widget.getWidgetInfo(e)}catch(t){s.error("Call to sap.sac.api.widget.getWidgetInfo failed.",this)}t.getModel("widgetInfo").setData(n);t.scheduleFireStateChanged()};d.prototype._showError=function(t){const e=this.getCardInstance();s.error(t,this);this.handleError({illustrationType:o.ErrorScreen,title:e.getTranslatedText("CARD_ERROR_ANALYTICS_CLOUD_TITLE"),description:e.getTranslatedText("CARD_ERROR_ANALYTICS_CLOUD_DESCRIPTION")})};return d});
//# sourceMappingURL=AnalyticsCloudContent.js.map