/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContentRenderer","sap/f/cards/loading/GenericPlaceholder","sap/m/MessageStrip","sap/m/VBox","sap/m/library","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/integration/controls/BlockingMessage","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/delegate/OverflowHandler","sap/base/util/merge","sap/ui/integration/library","sap/ui/core/message/MessageType"],function(t,e,i,n,a,o,s,r,d,g,h,l,p,c,u,f,y,v,_,C,m){"use strict";const D=h.InvisibleMessageMode;const P=C.CardDesign;const b=C.CardBlockingMessageType;const M=C.CardMessageType;const A=C.CardPreviewMode;var w=r.extend("sap.ui.integration.cards.BaseContent",{metadata:{library:"sap.ui.integration",properties:{design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:P.Solid},configuration:{type:"object"},noDataConfiguration:{type:"object"},overflowWithShowMore:{type:"boolean",defaultValue:false}},aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_loadingPlaceholder:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_messageContainer:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},_blockingMessage:{type:"sap.ui.integration.controls.BlockingMessage",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{parameters:{originalEvent:{type:"object"}}},ready:{}}},renderer:t});w.prototype.init=function(){this._oAwaitedEvents=new Set;this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new u);this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady")};w.prototype.onBeforeRendering=function(){const t=this.getCardInstance();if(!t){return}const e=this.getParsedConfiguration();let i=this.getAggregation("_loadingPlaceholder");if(!i&&e){this.setAggregation("_loadingPlaceholder",this.createLoadingPlaceholder(e));i=this.getAggregation("_loadingPlaceholder")}if(i){i.setRenderTooltip(t.getPreviewMode()!==A.Abstract);if(typeof this._getTable==="function"){i.setHasContent(this._getTable().getColumns().length>0)}}if(!this._oOverflowHandler&&this.getOverflowWithShowMore()&&this._supportsOverflow()){this._oOverflowHandler=new v(this);this._oOverflowHandler.attach()}};w.prototype.ontap=function(t){if(!t.isMarked()){this.firePress({originalEvent:t})}};w.prototype.exit=function(){this.hideLoadingPlaceholders();this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(t){this._mObservers[t].disconnect();delete this._mObservers[t]},this)}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}this._sContentBindingPath=null;if(this._oOverflowHandler){this._oOverflowHandler.destroy();this._oOverflowHandler=null}};w.prototype.createLoadingPlaceholder=function(t){return new e};w.prototype.loadDependencies=function(t){return Promise.resolve()};w.prototype.applyConfiguration=function(){};w.prototype.setLoadDependenciesPromise=function(t){this._pLoadDependencies=t;this.awaitEvent("_loadDependencies");this._pLoadDependencies.then(function(){this.fireEvent("_loadDependencies")}.bind(this))};w.prototype.getLoadDependenciesPromise=function(){return this._pLoadDependencies};w.prototype.getActions=function(){return this._oActions};w.prototype.setActions=function(t){this._oActions=t};w.prototype.awaitEvent=function(t){if(this._oAwaitedEvents.has(t)){return}this._bReady=false;this._oAwaitedEvents.add(t);this.showLoadingPlaceholders(true);this.attachEventOnce(t,function(){this._oAwaitedEvents.delete(t);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady()}}.bind(this))};w.prototype._supportsOverflow=function(){return true};w.prototype._forceCompleteAwaitedEvents=function(){this._oAwaitedEvents.forEach(function(t){this.fireEvent(t)}.bind(this))};w.prototype.getParsedConfiguration=function(){var t=_({},this.getConfiguration()),e=t.data;delete t.data;t=f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces());if(e){t.data=e}return t};w.prototype.getStaticConfiguration=function(){return this.getConfiguration()};w.prototype.showMessage=function(t,e,n){const a=this._getMessageContainer();this.hideMessage();if(e===M.Loading){n=false;this.addStyleClass("sapFCardBaseContentHasMessageLoading");this.setBusyIndicatorDelay(0);this.setBusy(true)}if(e===M.Toast){n=n??true}const o=e===M.Loading||e===M.Toast;const s=new i({text:f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces()),type:o?m.Information:e,showCloseButton:true,showIcon:e===M.Loading?false:true,close:function(){this.hideMessage()}.bind(this)});s.addStyleClass("sapFCardContentMessage");s.addStyleClass("sapFCardContentMessage"+e);const r=t=>{s.addStyleClass(t.animationName+"Finished")};s.addEventDelegate({onBeforeRendering:()=>{const t=s.getDomRef();t?.removeEventListener("animationend",r);t?.removeEventListener("animationcancel",r)},onAfterRendering:()=>{const t=s.getDomRef();t.addEventListener("animationend",r);t.addEventListener("animationcancel",r)}});a.addItem(s);if(n){const e=t?Math.max(t.split(" ").length*250,3e3):3e3;setTimeout(()=>{s.close()},e+400);setTimeout(()=>{s.addStyleClass("sapFCardContentMessageClosing")},e)}const d=this.getDomRef();if(d&&d.contains(document.activeElement)){g.getInstance().announce(t,D.Assertive)}else{g.getInstance().announce(t,D.Polite)}};w.prototype.hideMessage=function(){var t=this._getMessageContainer();t.destroyItems();if(this.hasStyleClass("sapFCardBaseContentHasMessageLoading")){this.removeStyleClass("sapFCardBaseContentHasMessageLoading");this.setBusy(false)}};w.prototype.showBlockingMessage=function(t){this.destroyAggregation("_blockingMessage");this.setAggregation("_blockingMessage",l.create(t,this.getCardInstance()));this._forceCompleteAwaitedEvents()};w.prototype.hideBlockingMessage=function(){this.destroyAggregation("_blockingMessage")};w.prototype.getBlockingMessage=function(){var t=this.getAggregation("_blockingMessage");if(t){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription(),imageSrc:t.getImageSrc(),httpResponse:t.getHttpResponse(),additionalContent:t.getAdditionalContent()}}return null};w.prototype.getBlockingMessageStaticConfiguration=function(){return this.getAggregation("_blockingMessage")?.getStaticConfiguration()};w.prototype.showNoDataMessage=function(t){var e=this.getNoDataConfiguration()||{};e=y.resolveValue(e,this.getCardInstance());var i={type:b.NoData,illustrationType:o[e.type]||e.type||t.illustrationType,illustrationSize:s[e.size]||t.illustrationSize,title:e.title||t.title,description:e.description||t.description};this.showBlockingMessage(i)};w.prototype.hideNoDataMessage=function(){this.hideBlockingMessage()};w.prototype.setDataConfiguration=function(t){var e=this.getCardInstance(),i;if(!t){this._sContentBindingPath=null;this.fireEvent("_dataReady");return}this._sContentBindingPath=y.resolveValue(t.path||"/",this.getCardInstance());this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){i=e.getModel(t.name)}else if(this._oDataProvider){i=new p;i.setSizeLimit(e.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged();this.onDataRequestComplete()}}.bind(this))}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested()}.bind(this));this._oDataProvider.attachDataChanged(function(t){var e=t.getParameter("data");this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.setModelData(e,i)}}.bind(this))}.bind(this));this._oDataProvider.attachError(function(t){this.handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};w.prototype.onDataRequested=function(){this.awaitEvent("_dataReady")};w.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();this.fireEvent("_dataReady");if(t){t._fireContentDataChange()}};w.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};w.prototype.showLoadingPlaceholders=function(t){if(!t&&this._isDataProviderJson()){return}var e=this.getAggregation("_loadingProvider"),i=this.getCardInstance();e.setLoading(true);if(i){i.addActiveLoadingProvider(e)}};w.prototype.hideLoadingPlaceholders=function(){var t=this.getAggregation("_loadingProvider"),e=this.getCardInstance();if(!t.getLoading()){return}t.setLoading(false);if(e){e.removeActiveLoadingProvider(t)}};w.prototype.onDataChanged=function(){};w.prototype.onCardDataChanged=function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged()}}.bind(this))};w.prototype.setModelData=function(t,e){e.setData(t)};w.prototype._bindAggregationToControl=function(t,e,i){var n;if(!i){return}if(!i.path){i.path=this._sContentBindingPath}if(!i.path){n=this.getCardInstance().getBindingContext();i.path=n&&n.getPath()}if(!i.path){return}this._observeAggregation(t,e);e.bindAggregation(t,i)};w.prototype._observeAggregation=function(t,e){var i=this.getCardInstance().getModel("parameters"),n;if(this._mObservers[t]){return}n=new c(function(n){var a;if(n.name!==t){return}if(!(n.mutation==="insert"||n.mutation==="remove")){return}a=e.getMetadata().getAggregation(t).get(e);var o=a.length;a.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){o-=1}});i.setProperty("/visibleItems",o)});i.setProperty("/visibleItems",0);n.observe(e,{aggregations:[t]});this._mObservers[t]=n};w.prototype.isReady=function(){return this._bReady};w.prototype.handleError=function(t){this.fireEvent("_error",{errorInfo:t})};w.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};w.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};w.prototype.setIconFormatter=function(t){this._oIconFormatter=t;return this};w.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};w.prototype.attachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");r.prototype.attachEvent.apply(this,t);this.invalidate();return this};w.prototype.detachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");r.prototype.detachEvent.apply(this,t);this.invalidate();return this};w.prototype.onActionSubmitStart=function(t){};w.prototype.onActionSubmitEnd=function(t,e){};w.prototype.validateControls=function(t,e){};w.prototype.getCardInstance=function(){return d.getElementById(this.getCard())};w.prototype.isSkeleton=function(){var t=this.getCardInstance();return t&&t.isSkeleton()};w.prototype.getDataLength=function(){return 0};w.prototype._getMessageContainer=function(){var t=this.getAggregation("_messageContainer");if(!t){t=new n({renderType:a.FlexRendertype.Bare,alignItems:a.FlexAlignItems.Center}).addStyleClass("sapFCardContentMessageContainer");this.setAggregation("_messageContainer",t)}return t};w.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};w.prototype.getHeaderTitleId=function(){var t=this.getCardInstance();if(!t){return undefined}return t.getId()+"-header-title"};w.prototype.isInteractive=function(){return this.hasListeners("press")};return w});
//# sourceMappingURL=BaseContent.js.map