/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContent","./BaseListContentRenderer","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/base/Log"],function(t,e,i,n,o,s){"use strict";var a=t.extend("sap.ui.integration.cards.BaseListContent",{metadata:{library:"sap.ui.integration"},renderer:e});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oAwaitingPromise=null;this._fMinHeight=0};a.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oAwaitingPromise=null};a.prototype.onAfterRendering=function(){if(this.isReady()&&this.getCardInstance()?.isReady()){this._keepHeight()}};a.prototype.onDataChanged=function(){if(this.hasData()){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:n.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}this.getPaginator()?.onDataChanged(this)};a.prototype.setModelData=function(e,i){const n=this.getPaginator();if(n?.isLoadingMore()){n.setModelData(e,i)}else{t.prototype.setModelData.apply(this,arguments)}};a.prototype._keepHeight=function(){if(!this.getDomRef()){return}const t=this.getDomRef().getBoundingClientRect().height;if(t>this._fMinHeight){this._fMinHeight=t}const e=this.getCardInstance()?.getDomRef("contentSection");const i=e?.getBoundingClientRect().height;if(i&&this._fMinHeight>i){this._fMinHeight=i}if(this._fMinHeight){this.getDomRef().style.minHeight=this._fMinHeight+"px"}this._keepPlaceholderMinItems()};a.prototype._keepPlaceholderMinItems=function(){var t=this.getAggregation("_loadingPlaceholder"),e=!!this.getAggregation("_content"),i,n;if(!t||!t.getMinItems||!e){return}i=this.getItemsLength();n=Math.max(t.getMinItems(),i);t.setMinItems(n)};a.prototype.applyConfiguration=function(){const t=this.getParsedConfiguration();const e=this.getInnerList();if(!t||!e){return}this._fMinHeight=0;const n=this.getPaginator();if(n?.getActive()){return}let o=i.resolveValue(t.maxItems,this);o=parseInt(o);if(n&&(Number.isNaN(o)||!o)){o=n.getPageSize()}if(o){e.applySettings({growing:true,growingThreshold:o});e.addStyleClass("sapFCardMaxItems")}};a.prototype.getInnerList=function(){return null};a.prototype.getItemsLength=function(){return 0};a.prototype.setPaginator=function(t){this._oPaginator=t};a.prototype.getPaginator=function(){return this._oPaginator};a.prototype._checkHiddenNavigationItems=function(t){if(!t.actions){return}if(!this.getInnerList()){return}var e=this.getInnerList(),n=this.isA("sap.ui.integration.cards.TimelineContent")?e.getContent():e.getItems(),o=[],a=t.actions[0],r,g=0;if(!a||!a.service||a.type!=="Navigation"){return}if(a.service==="object"){r=a.service.name}else{r=a.service}n.forEach(function(t){var e=i.resolveValue(a.parameters,this,t.getBindingContext().getPath());o.push(this._oServiceManager.getService(r).then(function(t){if(!t.hidden){return false}return t.hidden({parameters:e})}).then(function(e){t.setVisible(!e);if(!e){g++}}).catch(function(t){s.error(t)}))}.bind(this));this.awaitEvent("_filterNavItemsReady");var h=this._oAwaitingPromise=Promise.all(o).then(function(){if(this._oAwaitingPromise===h){if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",g)}this.fireEvent("_filterNavItemsReady")}}.bind(this))};a.prototype.hasData=function(){var t=this.getInnerList(),e=t.getBinding(t.getMetadata().getDefaultAggregationName()),i=e.getModel(),n=e.getPath(),o=i.getProperty(n);if(o&&o.length){return true}return false};a.prototype.getDataLength=function(){var t=this.getModel().getProperty(this.getInnerList().getBindingContext().getPath());if(Array.isArray(t)){return t.length}return Object.getOwnPropertyNames(t).length};a.prototype.ontap=function(t){t.stopPropagation()};a.prototype.onsapenter=function(t){t.stopPropagation()};a.prototype.onsapspace=function(t){t.stopPropagation()};return a});
//# sourceMappingURL=BaseListContent.js.map