/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/base/util/merge","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/openCardShowMore","sap/m/library","sap/m/Button"],function(t,e,o,i,n,s,r,a,u){"use strict";const g=a.ButtonType;var l=t.extend("sap.ui.integration.cards.Footer",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},showMoreButton:{type:"boolean"},showCloseButton:{type:"boolean"},detectVisibility:{type:"boolean"}},aggregations:{actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},_showMore:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapFCardFooter");if(e.getCardInstance().isLoading()&&e._hasBinding()){t.class("sapFCardFooterLoading")}t.openEnd();const o=e.getActionsStrip();if(o){t.renderControl(o)}const i=e.getAggregation("_showMore");if(i){t.renderControl(i)}const n=e.getAggregation("_closeButton");if(n){t.renderControl(n)}t.close("div")}}});l.create=function({card:t,configuration:e,paginator:o,showCloseButton:i,detectVisibility:r}){const a=i||l._shouldShowCloseButton(t);const u=!e||Object.keys(e).length===1&&e.closeButton&&e.closeButton.visible===false;if(u&&!a&&!r){return null}const g=new l({configuration:s.createBindingInfos(e,t.getBindingNamespaces()),card:t,showCloseButton:a,detectVisibility:r,actionsStrip:n.create(e?.actionsStrip,t,true),visible:e?.visible});g.setPaginator(o);return g};l._shouldShowCloseButton=function(t){const e=t._oCardManifest.get("/sap.card/footer");const o=t._oCardManifest.get("/sap.card/header");const i=!!t.getOpener();if(!i){return false}if(e?.closeButton&&"visible"in e.closeButton){return e.closeButton.visible}if(o?.closeButton&&"visible"in o.closeButton){return o.closeButton.visible}return true};l.prototype.onBeforeRendering=function(){if(this._shouldCreateShowMoreButton()){this._createShowMore()}else{this.destroyAggregation("_showMore")}if(this.getShowCloseButton()){this._createCloseButton()}else{this.destroyAggregation("_closeButton")}if(this.getDetectVisibility()){const t=this.hasVisibleItems();this.setVisible(t);this.getCardInstance().toggleStyleClass("sapUiIntCardFooterInvisible",!t)}};l.prototype.onDataChanged=function(){if(this.getActionsStrip()){this.getActionsStrip().onDataChanged()}};l.prototype.getFirstFocusableItem=function(){const t=this.getActionsStrip()?.getFirstFocusableItem();if(t){return t}const e=this.getAggregation("_showMore");if(e?.getVisible()){return e}const o=this.getAggregation("_closeButton");if(o?.getVisible()){return o}return false};l.prototype.hasVisibleItems=function(){if(this.getActionsStrip()?.hasVisibleItems()){return true}const t=this.getAggregation("_showMore");if(t?.getVisible()){return true}const e=this.getAggregation("_closeButton");if(e?.getVisible()){return true}return false};l.prototype._hasBinding=function(){var t=s.createBindingInfos(this.getConfiguration(),this.getCardInstance().getBindingNamespaces());return(t?.actionsStrip||[]).some(function(t){for(var e in t){if(s.isBindingInfo(t[e])){return true}}return false})};l.prototype.getCardInstance=function(){return o.getElementById(this.getCard())};l.prototype.setEnabled=function(t){var e=this.getActionsStrip();if(!e){return}if(t){e.enableItems()}else{e.disableItems()}};l.prototype.getStaticConfiguration=function(){var t=e({},this.getConfiguration());if(this._oPaginator){t.paginator=this._oPaginator.getStaticConfiguration()}return t};l.prototype.setPaginator=function(t){this._oPaginator=t};l.prototype._shouldCreateShowMoreButton=function(){if(this.getShowMoreButton()){return true}const t=this._oPaginator;if(t&&!t.getActive()){return true}return false};l.prototype._shouldShowMoreButtonBeVisible=function(){let t=this._shouldCreateShowMoreButton();const e=this._oPaginator;if(e){t=t&&e.getPageCount()>1}return t};l.prototype._createShowMore=function(){let t=this.getAggregation("_showMore");if(!t){const e=this._oPaginator;let o=false;t=new u(`${this.getId()}-showMore`,{text:i.getResourceBundleFor("sap.ui.integration").getText("CARD_FOOTER_SHOW_MORE"),type:g.Transparent,press:()=>{if(o){return}let t;if(e){t=e.openDialog()}else{t=r(this.getCardInstance())}o=true;t.attachAfterOpen(()=>{o=false})},visible:this._shouldShowMoreButtonBeVisible()}).addStyleClass("sapFCardFooterShowMoreButton");e?.attachEvent("_ready",()=>{t.setVisible(this._shouldShowMoreButtonBeVisible())});this.setAggregation("_showMore",t)}return t};l.prototype._createCloseButton=function(){let t=this.getAggregation("_closeButton");if(!t){t=new u(`${this.getId()}-closeBtn`,{text:i.getResourceBundleFor("sap.ui.integration").getText("CARD_DIALOG_CLOSE_BUTTON"),type:g.Emphasized,press:this.getCardInstance().hide.bind(this.getCardInstance())});this.setAggregation("_closeButton",t)}return t};return l});
//# sourceMappingURL=Footer.js.map