/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/m/Text","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/Utils","sap/ui/integration/formatters/IconFormatter"],function(t,e,i,a,r,o,n,s,d,c,u,h){"use strict";var l=o.AvatarColor;var p=a.extend("sap.ui.integration.cards.Header",{metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:r});p.create=function(t,e,i,a){e=e||{};var r={title:e.title,titleMaxLines:e.titleMaxLines,subtitle:e.subTitle,subtitleMaxLines:e.subTitleMaxLines,dataTimestamp:e.dataTimestamp,visible:e.visible,wrappingType:e.wrappingType};if(e.status&&e.status.text&&!e.status.text.format){r.statusText=e.status.text;r.statusVisible=e.status.visible}if(e.icon){var o=e.icon.initials||e.icon.text;var d=e.icon.backgroundColor||(o?l.Accent6:l.Transparent);r.iconSrc=e.icon.src;r.iconDisplayShape=e.icon.shape;r.iconInitials=o;r.iconAlt=e.icon.alt;r.iconBackgroundColor=d;r.iconVisible=e.icon.visible;r.iconFitType=e.icon.fitType}if(r.iconSrc){r.iconSrc=s.formattedProperty(r.iconSrc,function(t){return a.formatSrc(t)})}if(e.banner){r.bannerLines=e.banner.map(function(t){var e=new n({text:t.text,visible:t.visible});if(t.diminished){e.addStyleClass("sapFCardHeaderBannerLineDiminished")}return e})}r.toolbar=i;const c=new p(t,r);c._oConfiguration=e;c._oIconFormatter=a;return c};p.prototype.init=function(){a.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new c);this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};p.prototype.exit=function(){a.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};p.prototype.shouldShowIcon=function(){return this.getIconVisible()&&this.getIconSrc()!==h.SRC_FOR_HIDDEN_ICON};p.prototype.isInteractive=function(){return this.getInteractive()};p.prototype.isReady=function(){return this._bReady};p.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};p.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};p.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};p.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};p.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};p.prototype.getStaticConfiguration=function(){var t=i({},this._oConfiguration),e=u.getNestedPropertyValue(t,"/status/text/format"),a;if(e){a=u.getStatusTextBindingInfo(e)}if(a){t.status.text=a}if(t.icon&&t.icon.src){t.icon.src=this._oIconFormatter.formatSrc(d.resolveValue(t.icon.src,this))}return t};p.prototype._setDataConfiguration=function(t){var i=this.getCardInstance(),a="/",r;if(t&&t.path){a=d.resolveValue(t.path,this.getCardInstance())}this.bindObject(a);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){r=i.getModel(t.name)}else if(this._oDataProvider){r=new e;this.setModel(r)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){r.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();if(t){t._fireDataChange()}this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};p.prototype.getCardInstance=function(){return t.getElementById(this.getCard())};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
//# sourceMappingURL=Header.js.map