/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/f/cards/loading/ListPlaceholder","sap/ui/integration/controls/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/cards/list/MicrochartsResizeHelper","sap/ui/integration/util/SorterHelper"],function(t,i,e,n,o,s,r,a,c,h,l,p,g,u,d,f){"use strict";var m=n.AvatarColor;var I=n.ListType;var v=n.ListSeparators;var y=a.CardActionArea;var _=n.EmptyIndicatorMode;var b="_legendColorsLoad";var S=t.extend("sap.ui.integration.cards.ListContent",{metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:i});S.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getList().setBackgroundDesign(this.getDesign())};S.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null}if(this._oMicrochartsResizeHelper){this._oMicrochartsResizeHelper.destroy();this._oMicrochartsResizeHelper=null}};S.prototype.createLoadingPlaceholder=function(t){var e=this.getCardInstance(),n=e.getContentMinItems(t);const o=h.resolveValue(t.item,this);const r=g.getPlaceholderInfo(o);return new s({minItems:n!==null?n:2,hasIcon:r.hasIcon,attributesLength:r.attributesLength,hasChart:r.hasChart,hasActionsStrip:r.hasActionsStrip,hasDescription:r.hasDescription,itemHeight:i.getItemMinHeight(t,this)+"rem"})};S.prototype.loadDependencies=function(t){if(!this.isSkeleton()&&t.get("/sap.card/content/item/chart")){return l.loadDependencies()}return Promise.resolve()};S.prototype.applyConfiguration=function(){t.prototype.applyConfiguration.apply(this,arguments);var i=this.getParsedConfiguration();if(!i){return}if(i.items){this._setStaticItems(i.items);return}if(i.item){this._setItem(i)}};S.prototype.getStaticConfiguration=function(){var t=this.getInnerList().getItems(),i=this.getParsedConfiguration(),e=t[0]&&t[0].isA("sap.m.GroupHeaderListItem"),n=[],o=[],s;t.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){if(s){o.push(s)}n=[];s={title:t.getTitle(),items:n}}else{var e=h.resolveValue(i.item,this,t.getBindingContext().getPath());if(e.icon&&e.icon.src){e.icon.src=this._oIconFormatter.formatSrc(e.icon.src)}n.push(e)}}.bind(this));if(s){o.push(s)}var r={};if(e){r.groups=o}else{r.groups=[{items:n}]}return r};S.prototype.getItemsLength=function(){return this._getList().getItems().filter(t=>!t.isA("sap.m.GroupHeaderListItem")).length};S.prototype.onDataChanged=function(){t.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item);this._getList().getItems().forEach(t=>{if(t.getActionsStrip&&t.getActionsStrip()){t.getActionsStrip().onDataChanged()}})};S.prototype._getList=function(){if(this._bIsBeingDestroyed){return null}if(!this._oList){this._oList=new o({id:this.getId()+"-list",growing:false,showNoData:false,ariaLabelledBy:this.getHeaderTitleId(),updateFinished:function(){if(this._iVisibleItems){var t=this._oList.getItems();for(var i=this._iVisibleItems+1;i<t.length;i++){t[i].setVisible(false)}}}.bind(this)});this._oList.addEventDelegate({onfocusin:function(t){if(!(t.srcControl instanceof g)){return}var i=t.target.getBoundingClientRect().bottom;var e=this.getDomRef().getBoundingClientRect().bottom;var n=Math.abs(i-e);var o=10;if(n<o){t.srcControl.addStyleClass("sapUiIntLCIRoundedCorners")}}},this);this.setAggregation("_content",this._oList)}return this._oList};S.prototype._setItem=function(t){var i=t.item,e=this._getList(),n=this.isSkeleton(),o,s={title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),descriptionVisible:i.description?i.description.visible:undefined,highlight:i.highlight,highlightText:i.highlightText,hasInfo:!!i.info,info:i.info&&i.info.value,infoState:i.info&&i.info.state,infoVisible:i.info&&i.info.visible,showInfoStateIcon:i.info&&i.info.showStateIcon,customInfoStatusIcon:i.info&&i.info.customStateIcon,infoStateInverted:i.info&&i.info.inverted,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconFitType=i.icon.fitType;s.iconInitials=i.icon.initials||i.icon.text;s.iconVisible=i.icon.visible;if(i.icon.size){s.iconSize=i.icon.size}s.iconBackgroundColor=i.icon.backgroundColor||(s.iconInitials?undefined:m.Transparent)}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType}if(i.attributes){i.attributes.forEach(function(t){o=new r({text:t.value,state:t.state,emptyIndicatorMode:_.On,visible:t.visible,showStateIcon:t.showStateIcon,customIcon:t.customStateIcon,inverted:t.inverted});s.attributes.push(o)})}if(!n){if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart)}if(i.actionsStrip){s.actionsStrip=u.create(i.actionsStrip,this.getCardInstance());e.setShowSeparators(v.All)}else{e.setShowSeparators(v.None)}}this._oItemTemplate=new g(s);this._oActions.attach({area:y.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:I.Active,disabledPropertyValue:I.Inactive});var a=t.group;if(a){this._oSorter=f.getGroupSorter(a)}var h={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",e,h)};S.prototype._createChartAndAddLegend=function(t){var i=l.create(t);this.destroyAggregation("_legend");if(t.type==="StackedBar"){var e=new p({chart:i.getChart(),colorsLoad:function(){this.fireEvent(b)}.bind(this),visible:t.visible});e.initItemsTitles(t.bars,this.getBindingContext().getPath());this.setAggregation("_legend",e);this.awaitEvent(b)}this._oMicrochartsResizeHelper=new d(this._oList);return i};S.prototype._setStaticItems=function(t){var i=this._getList();t.forEach(function(t){var n=new g({title:t.title?t.title:"",description:t.description?t.description:"",icon:t.icon?t.icon:"",infoState:t.infoState?t.infoState:"None",info:t.info?t.info:"",highlight:t.highlight?t.highlight:"None",highlightText:t.highlightText?t.highlightText:""});if(t.action){n.setType("Navigation");if(t.action.url){n.attachPress(function(){e(t.action.url,t.target||"_blank")})}}i.addItem(n)});this.fireEvent("_actionContentReady")};S.prototype.getInnerList=function(){return this._getList()};return S});
//# sourceMappingURL=ListContent.js.map