/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/extend","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/f/cards/NumericSideIndicator","sap/m/library","sap/m/Text","sap/ui/core/Element","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/controls/Microchart"],function(t,e,i,a,r,n,o,s,d,c,l,u){"use strict";var h=r.AvatarColor;var p=e.extend("sap.ui.integration.cards.NumericHeader",{metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:i});p.create=function(e,i,r,o){i=i||{};var d={title:i.title,titleMaxLines:i.titleMaxLines,subtitle:i.subTitle,subtitleMaxLines:i.subTitleMaxLines,dataTimestamp:i.dataTimestamp,visible:i.visible,wrappingType:i.wrappingType};if(i.status&&i.status.text&&!i.status.text.format){d.statusText=i.status.text;d.statusVisible=i.status.visible}if(i.icon){var c=i.icon.initials||i.icon.text;var l=i.icon.backgroundColor||(c?h.Accent6:h.Transparent);d.iconSrc=i.icon.src;d.iconDisplayShape=i.icon.shape;d.iconInitials=c;d.iconAlt=i.icon.alt;d.iconBackgroundColor=l;d.iconVisible=i.icon.visible;d.iconFitType=i.icon.fitType}if(d.iconSrc){d.iconSrc=s.formattedProperty(d.iconSrc,function(t){return o.formatSrc(t)})}t(d,{unitOfMeasurement:i.unitOfMeasurement,details:i.details?.text??i.details,detailsMaxLines:i.details?.maxLines||i.detailsMaxLines,sideIndicatorsAlignment:i.sideIndicatorsAlignment});if(i.details?.state){d.detailsState=i.details.state}if(i.mainIndicator){d.number=i.mainIndicator.number;d.scale=i.mainIndicator.unit;d.trend=i.mainIndicator.trend;d.state=i.mainIndicator.state;d.numberVisible=i.mainIndicator.visible}if(i.sideIndicators){d.sideIndicators=i.sideIndicators.map(function(t){return new a(t)})}if(i.banner){d.bannerLines=i.banner.map(function(t){var e=new n({text:t.text,visible:t.visible});if(t.diminished){e.addStyleClass("sapFCardHeaderBannerLineDiminished")}return e})}d.toolbar=r;const g=new p(e,d);if(i.chart){u.loadDependencies().then(()=>{g.setMicroChart(u.create(i.chart,true))});if(i.sideIndicators){g.addStyleClass("sapFCardNumericHeaderSIMC")}else{g.addStyleClass("sapFCardNumericHeaderMC")}}return g};p.prototype.init=function(){e.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new l);this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};p.prototype.exit=function(){e.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};p.prototype.isInteractive=function(){return this.getInteractive()};p.prototype.isReady=function(){return this._bReady};p.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};p.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};p.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};p.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};p.prototype._setDataConfiguration=function(t){var e=this.getCardInstance(),i="/",a;if(t&&t.path){i=c.resolveValue(t.path,this.getCardInstance())}this.bindObject(i);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){a=e.getModel(t.name)}else if(this._oDataProvider){a=new d;this.setModel(a)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){a.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};p.prototype.getCardInstance=function(){return o.getElementById(this.getCard())};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
//# sourceMappingURL=NumericHeader.js.map