/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./TimelineContentRenderer","sap/f/cards/loading/TimelinePlaceholder","sap/ui/core/Lib","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver"],function(e,t,i,n,o,r,a){"use strict";var s=o.CardActionArea;var m,c;var l=e.extend("sap.ui.integration.cards.TimelineContent",{metadata:{library:"sap.ui.integration"},renderer:t});l.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null}};l.prototype.createLoadingPlaceholder=function(e){var n=this.getCardInstance(),o=n.getContentMinItems(e);return new i({minItems:o!==null?o:2,item:e.item,itemHeight:t.getItemMinHeight(e,this)+"rem"})};l.prototype.loadDependencies=function(e){return new Promise(function(e,t){n.load("sap.suite.ui.commons").then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(t,i){m=t;c=i;e()},function(e){t(e)})}).catch(function(){t("Timeline content type is not available with this distribution.")})})};l.prototype._getTimeline=function(){var e=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null}if(!e){e=new m({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false,growingThreshold:0,ariaLabelledBy:this.getHeaderTitleId()});this.setAggregation("_content",e)}return e};l.prototype.applyConfiguration=function(){e.prototype.applyConfiguration.apply(this,arguments);var t=this.getParsedConfiguration();if(!t){return}if(t.items){this._setStaticItems(t.items);return}if(t.item){this._setItem(t.item)}};l.prototype.getItemsLength=function(){return this._getTimeline().getContent().length};l.prototype.onDataChanged=function(){e.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item)};l.prototype._setItem=function(e){var t={userNameClickable:false,title:e.title&&e.title.value,text:e.description&&e.description.value,dateTime:e.dateTime&&e.dateTime.value,userName:e.owner&&e.owner.value,icon:e.icon&&e.icon.src};if(e.ownerImage&&e.ownerImage.value){t.userPicture=r.formattedProperty(e.ownerImage.value,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this))}this._oTimeLineItemTemplate=new c(t);this._oActions.attach({area:s.ContentItem,actions:e.actions,control:this,actionControl:this._oTimeLineItemTemplate,eventName:"select"});var i={template:this._oTimeLineItemTemplate};this._bindAggregationToControl("content",this._getTimeline(),i);return this};l.prototype._setStaticItems=function(e){var t=this._getTimeline(),i;e.forEach(function(e){i=new c({title:e.title,text:e.description,userPicture:e.ownerImage,dateTime:e.dateTime,userName:e.owner,icon:e.icon});t.addContent(i)})};l.prototype.getInnerList=function(){return this._getTimeline()};l.prototype.getStaticConfiguration=function(){var e=this.getInnerList().getContent(),t=this.getParsedConfiguration(),i=[];e.forEach(function(e){var n=a.resolveValue(t.item,this,e.getBindingContext().getPath());if(n.icon&&n.icon.src){n.icon.src=this._oIconFormatter.formatSrc(n.icon.src)}if(n.ownerImage&&n.ownerImage.value){n.ownerImage.value=this._oIconFormatter.formatSrc(n.ownerImage.value)}i.push(n)}.bind(this));var n={items:i};return n};return l});
//# sourceMappingURL=TimelineContent.js.map