/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContent","./WebPageContentRenderer","sap/ui/util/isCrossOriginURL","sap/m/IllustratedMessageType","sap/ui/integration/util/BindingHelper"],function(e,t,i,r,a){"use strict";var n="_frameLoaded";var o=15*1e3;var s=e.extend("sap.ui.integration.cards.WebPageContent",{metadata:{properties:{minHeight:{type:"sap.ui.core.CSSSize",defaultValue:t.MIN_WEB_PAGE_CONTENT_HEIGHT,bindable:true},src:{type:"sap.ui.core.URI",bindable:true},sandbox:{type:"string",defaultValue:"",bindable:true},allow:{type:"string",bindable:true},allowFullscreen:{type:"boolean",defaultValue:false,bindable:true},omitSandbox:{type:"boolean",defaultValue:false,bindable:true}},library:"sap.ui.integration"},renderer:t});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this._onFrameLoadedBound=this._onFrameLoaded.bind(this);this._sPrevSrc=this.getSrc();this.attachEventOnce("_dataReady",()=>{this._bDataReady=true})};s.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout)}};s.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this.getDomRef("frame")){this.getDomRef("frame").removeEventListener("load",this._onFrameLoadedBound)}const t=this.getSrc();if(this._isDataReady()&&t!==undefined&&this._sPrevSrc!==t){this._sPrevSrc=t;if(this._checkSrc()){this._bSrcChecked=true;this._raceFrameLoad()}}};s.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);if(this.getDomRef("frame")){this.getDomRef("frame").addEventListener("load",this._onFrameLoadedBound)}};s.prototype.applyConfiguration=function(){const e=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!e){return}this.applySettings({src:a.formattedProperty(e.src,e=>this._oIconFormatter.formatSrc(e)),sandbox:e.sandbox,minHeight:e.minHeight,allow:e.allow,allowFullscreen:e.allowFullscreen||e.allowfullscreen,omitSandbox:e.omitSandbox})};s.prototype._supportsOverflow=function(){return false};s.prototype._isDataReady=function(){if(!this.getCardInstance()){return this._bDataReady}return this._bDataReady&&this.getCardInstance().isDataReady()};s.prototype._checkSrc=function(){const e=this.getCardInstance(),t=this.getSrc();if(!e){return false}if(!t){this.handleError({illustrationType:r.ErrorScreen,title:e.getTranslatedText("CARD_WEB_PAGE_EMPTY_URL_ERROR"),description:e.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION")});return false}if(i(t)&&!t.startsWith("https")){this.handleError({illustrationType:r.ErrorScreen,title:e.getTranslatedText("CARD_WEB_PAGE_HTTPS_URL_ERROR"),description:e.getTranslatedText("CARD_ERROR_REQUEST_ACCESS_DENIED_DESCRIPTION")});return false}return true};s.prototype._raceFrameLoad=function(){this.awaitEvent(n);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout)}this._iLoadTimeout=setTimeout(function(){this.fireEvent(n);var e=o/1e3,t=this.getCardInstance();this.handleError({illustrationType:r.ReloadScreen,title:t.getTranslatedText("CARD_WEB_PAGE_TIMEOUT_ERROR",[e]),details:"Failed to load '"+this.getSrc()+"' after "+e+" seconds."})}.bind(this),o)};s.prototype._onFrameLoaded=function(){this.fireEvent(n);clearTimeout(this._iLoadTimeout)};return s});
//# sourceMappingURL=WebPageContent.js.map