/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/integration/cards/actions/CustomAction","sap/ui/integration/cards/actions/DateChangeAction","sap/ui/integration/cards/actions/MonthChangeAction","sap/ui/integration/cards/actions/SubmitAction","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/base/strings/capitalize","sap/base/util/deepClone","sap/ui/integration/cards/actions/ShowCardAction","sap/ui/integration/cards/actions/HideCardAction"],function(e,t,a,n,i,r,o,s,c,l,u,d,f,p){"use strict";function g(e){if(e&&typeof e==="object"){return e.name}return e}var h=e.CardActionArea,v=e.CardActionType;var b=a.extend("sap.ui.integration.cards.actions.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});b.prototype.attach=function(e){var t=e.control,a=e.area;e.actionControl=e.actionControl||e.control;e.enabledPropertyValue=e.enabledPropertyValue!==undefined?e.enabledPropertyValue:true;e.disabledPropertyValue=e.disabledPropertyValue||false;e.eventName=e.eventName||"press";if(!e.actions){this._fireActionReady(t,a);return}var n=e.actions[0];if(n&&n.type){e.action=n;this._attachAction(e)}else{this._fireActionReady(t,a)}};b.prototype._attachAction=function(e){var t=e.action,a=e.area,n=e.control,i=e.enabledPropertyName,r=true,o=this._isSingleAction(a),s=true;if(i){r=false;if(t.service&&!o){this._setControlEnabledStateUsingService(e)}else{this._setControlEnabledState(e)}}if(t.service&&o){this._getSingleActionEnabledState(t,n).then(function(t){if(t){this._attachEventListener(e)}this._fireActionReady(n,a)}.bind(this));return}if(r){s=t.enabled!==false&&t.enabled!=="false"}if(s){this._attachEventListener(e)}this._fireActionReady(n,a)};b.prototype._setControlEnabledStateUsingService=function(e){var t=e.action,n=e.control,i=e.actionControl,r=e.enabledPropertyName,o=e.enabledPropertyValue,s=e.disabledPropertyValue,c=a.bindingParser("{path:''}");c.formatter=function(e){var a=this.getBindingContext(),i,r;if(a){i=a.getPath()}r=l.resolveValue(t.parameters,n,i);if(e.__resolved){if(!e.__enabled||e.__enabled==="false"){return s}return o}if(!e.__promise){e.__promise=true;n._oServiceManager.getService(g(t.service)).then(function(t){if(t){t.enabled({parameters:r}).then(function(t){e.__resolved=true;e.__enabled=t;n.getModel().checkUpdate(true)}).catch(function(){e.__resolved=true;e.__enabled=false})}else{e.__resolved=true;e.__enabled=false}})}return s};i.bindProperty(r,c)};b.prototype._setControlEnabledState=function(e){var t=e.action,a=e.actionControl,n=e.enabledPropertyName,i=e.enabledPropertyValue,r=e.disabledPropertyValue,o,s;if(typeof t.enabled==="object"){o=c.formattedProperty(t.enabled,function(e){if(!e||e==="false"){return r}return i})}if(o){a.bindProperty(n,o)}else{s=t.enabled===false||t.enabled==="false"?r:i;a.setProperty(n,s)}};b.prototype._getSingleActionEnabledState=function(e,t){var a=t.getBindingContext(),n,i;if(a){i=a.getPath()}n=l.resolveValue(e.parameters,t,i);return new Promise(function(a){t._oServiceManager.getService(g(e.service)).then(function(e){if(e){e.enabled({parameters:n}).then(function(e){a(e)}).catch(function(){a(false)})}else{a(false)}}).catch(function(){a(false)})})};b.prototype._fireActionReady=function(e,t){var a=t===h.Header;var n=a?"_actionHeaderReady":"_actionContentReady";e.fireEvent(n)};b.prototype._resolveBindingPath=function(e){var t=e.getSource().getBindingContext(),a;if(this.getBindingPathResolver()){a=this.getBindingPathResolver()(e)}else if(t){a=t.getPath()}return a};b.prototype._handleServiceAction=function(e,a,n){var i=e.getSource();var r=this._resolveBindingPath(e);n._oServiceManager.getService(g(a.service)).then(function(e){if(e){e.navigate({parameters:l.resolveValue(a.parameters,i,r)})}}).catch(function(e){t.error("Navigation service unavailable",e)}).finally(function(){this._processAction(i,a,r)}.bind(this))};b.prototype._attachEventListener=function(e){var t=e.action;e.actionControl["attach"+u(e.eventName)](function(a){const n=a.getSource();const i=a.getParameter("originalEvent");if(i){i.stopPropagation();if(e.actionControl.getFocusDomRef()?.matches(":has(:focus-within)")){return}}if(t.service){this._handleServiceAction(a,t,e.control)}else{this._processAction(n,t,this._resolveBindingPath(a))}}.bind(this))};b.prototype._processAction=function(e,t,a){var n=this._getHostInstance(),i=this.getCard();b.fireAction({card:i,host:n,action:t,parameters:l.resolveValue(t.parameters,e,a),source:e})};b.prototype._getHostInstance=function(){var e=this.getCard();if(e){return e.getHostInstance()}return null};b.prototype.fireAction=function(e,t,a){b.fireAction({card:this.getCard(),host:this._getHostInstance(),action:{type:t},parameters:a,source:e})};b.fireAction=function(e){var t=e.host,a=e.card,n=a.getAggregation("_extension"),i=e.action.type,r=d(e.parameters,100)||{},o={type:i,card:a,actionSource:e.source},s,c=true;if(i===v.Submit||i===v.Custom){o.formData=a.getModel("form").getData()}if(i===v.Submit){r.data=r.data??a.getModel("form").getData()}o.parameters=r;s=Object.assign({},o,{manifestParameters:r});if(n){c=n.fireAction(o)}if(!c){return false}c=a.fireAction(s);if(!c){return false}if(t){c=t.fireAction(o)}if(!c){return false}var l=b._createHandler(e);if(l){l.execute();l.destroy()}return true};b.prototype._isSingleAction=function(e){return[h.Header,h.Content,h.ContentItemDetail,h.ActionsStrip].indexOf(e)>-1};b._createHandler=function(e){var a=null;switch(e.action.type){case v.Custom:a=n;break;case v.DateChange:a=i;break;case v.HideCard:a=p;break;case v.MonthChange:a=r;break;case v.Navigation:a=s;break;case v.ShowCard:a=f;break;case v.Submit:a=o;break;default:t.error("Unknown action type '"+e.action.type+"'. Expected one of "+Object.values(v).join(", "),null,"sap.ui.integration.widgets.Card")}if(a){return new a({config:e.action,parameters:e.parameters,actionHandler:e.card.getManifestEntry("/sap.card/configuration/actionHandlers/"+e.action.type.toLowerCase()),card:e.card,source:e.source})}return null};return b});
//# sourceMappingURL=CardActions.js.map