/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/base/Log","sap/base/util/merge","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/core/Lib","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper"],function(e,t,i,a,r,o,n,s,d,l,g,u){"use strict";var p=e.extend("sap.ui.integration.cards.filters.BaseFilter",{metadata:{abstract:true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_label:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_error:{type:"sap.m.HBox",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{change:{parameters:{key:{type:"string"},value:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){const i=t.getAggregation("_error");e.openStart("div",t).class("sapFCardFilter");if(t.isLoading()){e.class("sapFCardFilterLoading")}e.openEnd();if(i){e.renderControl(i)}else{e.renderControl(t.getField())}e.close("div")}}});p.prototype.init=function(){this.setAggregation("_loadingProvider",new g);this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready")})};p.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}};p.prototype.isLoading=function(){var e=this.getAggregation("_loadingProvider");return e.getLoading()};p.prototype.getField=function(){return null};p.prototype.createLabel=function(e){if(e.label){this.setAggregation("_label",new i({text:e.label}).toStatic());return this.getAggregation("_label")}return null};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataChanged=function(){};p.prototype.setValueFromOutside=function(e){};p.prototype.getValueForModel=function(){};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.getCardInstance=function(){return t.getElementById(this.getCard())};p.prototype.getParsedConfiguration=function(){var e=r({},this.getConfig()),t=e.data;delete e.data;e=u.createBindingInfos(e,this.getCardInstance().getBindingNamespaces());if(t){e.data=t}return e};p.prototype.writeValueToConfiguration=function(e){};p.prototype._showError=function(){var e=d.getResourceBundleFor("sap.ui.integration").getText("CARD_FILTER_DATA_LOAD_ERROR");this.destroyAggregation("_error");this.setAggregation("_error",new n({justifyContent:"Center",alignItems:"Center",items:[new o({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new s({text:e})]}))};p.prototype._handleError=function(e){a.error(e);this._showError()};p.prototype._onDataRequestComplete=function(){this.hideLoadingPlaceholders()};p.prototype._setDataConfiguration=function(e){var t=this.getCardInstance(),i;if(!e){this.fireEvent("_dataReady");return}if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=t.getDataProviderFactory().create(e,null,true);if(e.name){i=t.getModel(e.name)}else if(this._oDataProvider){i=new l;i.setSizeLimit(t.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",()=>{this.onDataChanged();setTimeout(()=>{this.fireEvent("_dataReady")},0)});if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(e){i.setData(e.getParameter("data"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this._onDataRequestComplete();this.fireEvent("_dataReady")}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype._syncValue=function(){const e=this.getValueForModel();this.setValue(e);this.fireChange({key:this.getKey(),value:e.value})};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
//# sourceMappingURL=BaseFilter.js.map