/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["../library","sap/m/library","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/Link","sap/m/OverflowToolbarButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Label"],function(t,e,o,i,n,a,r,s,l,p,c,u,b,g,f,d){"use strict";const m=e.ToolbarStyle;const y=e.ToolbarDesign;const h=o.aria.HasPopup;const _=t.CardActionArea;const C=t.CardActionType;var I=i.extend("sap.ui.integration.controls.ActionsStrip",{metadata:{library:"sap.ui.integration",properties:{disableItemsInitially:{type:"boolean",defaultValue:false},configuration:{type:"object"},cardActions:{type:"object"}},aggregations:{_toolbar:{type:"sap.m.OverflowToolbar",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapUiIntActionsStrip").openEnd();t.renderControl(e._getToolbar());t.close("div")}}});I.prototype.onDataChanged=function(){if(this.getConfiguration()?.item){this._updateToolbar(this._createItemsFromTemplate(this.getBindingContext().getProperty(this.getConfiguration().item?.path)))}};I.prototype.getFirstFocusableItem=function(){const t=this._getToolbar();return t.getContent().find(t=>{if(!(t.isA("sap.m.Button")||t.isA("sap.m.Link"))){return false}if(!(t.getVisible()&&t.getEnabled())){return false}return true})};I.prototype._getToolbar=function(){var t=this.getAggregation("_toolbar");if(!t){t=new b({style:m.Clear,design:y.Transparent});this.setAggregation("_toolbar",t)}return t};I.prototype._updateToolbar=function(t){if(!t||!t.length){return}const e=this._getToolbar();t.forEach(t=>{e.addContent(this._createItem(t))});const o=e.getContent().find(t=>t instanceof f);if(!o){e.insertContent(new f,0)}};I.prototype._createItems=function(t){if(!t||!t.length){return null}const e=n.getElementById(this.getCard());t=r.createBindingInfos(t,e.getBindingNamespaces());return t};I.prototype._createItemsFromTemplate=function(t){if(!t||!t.length){return null}const e=this.getConfiguration().item;let o=e.path+"/";if(!r.isAbsolutePath(o)){o=this.getBindingContext().getPath();if(o!=="/"){o+="/"}o+=e.path+"/"}const i=this.getBindingContext().getProperty();this.setModel(new l(i),"parent");return t.map((t,i)=>s.resolveValue(e.template,this,o+i))};I.prototype._createItem=function(t){let e;switch(t.type){case"Label":e=this._createLabel(t);break;case"ToolbarSpacer":return new f;case"Link":e=this._createLink(t);break;case"Button":default:e=this._createButton(t)}e.setLayoutData(new g({group:t.overflowGroup,priority:t.overflowPriority}));const o={area:_.ActionsStrip,control:e,actions:t.actions,enabledPropertyName:"enabled"};if(this.getDisableItemsInitially()){o.enabledPropertyValue=false;e._mActionsConfig=o;e._bIsDisabled=true}if(t.type!=="Label"){this.getCardActions().attach(o)}return e};I.prototype.disableItems=function(){var t=this._getToolbar().getContent();t.forEach(function(t){if(t.setEnabled&&!t._bIsDisabled&&t.getEnabled()){t.setEnabled(false);t._bIsDisabled=true}})};I.prototype.enableItems=function(){var t=this._getToolbar().getContent(),e;t.forEach(t=>{if(t.setEnabled&&t._bIsDisabled){e=t._mActionsConfig;if(e?.action){e.enabledPropertyValue=true;this.getCardActions()._setControlEnabledState(e)}else{t.setEnabled(true)}delete t._bIsDisabled}})};I.prototype._createLabel=function(t){var e=new d({text:t.text,visible:t.visible});return e};I.prototype._createLink=function(t){var e=new c({icon:t.icon,text:t.text,tooltip:t.tooltip,ariaHasPopup:t.ariaHasPopup??this._getAriaHasPopup(t),emphasized:t.emphasized,visible:t.visible});return e};I.prototype._createButton=function(t){const e=t.ariaHasPopup??this._getAriaHasPopup(t);const o={icon:t.icon,text:t.text,tooltip:t.tooltip,type:t.buttonType,ariaHasPopup:e,visible:t.visible};if(t.icon&&(t.preferIcon||!t.text)){o.text=t.text||t.tooltip;o.tooltip=t.tooltip||t.text;return new u(o)}return new p(o)};I.prototype._getAriaHasPopup=function(t){const e=t.actions;if(e?.length>0&&e[0].type===C.ShowCard){return h.Dialog}return null};I.create=function(t,e,o){if(!t){return null}const i=new I({card:e,configuration:t,cardActions:new a({card:e}),disableItemsInitially:o});if(Array.isArray(t)){i._updateToolbar(i._createItems(t))}return i};I.hasVisibleTemplateItems=function(t,e){const o=t;if(!Array.isArray(o)){return false}const i=s.resolveValue(o,e);return i.some(t=>!t.hasOwnProperty("visible")||!!t.visible)};I.prototype.hasVisibleItems=function(){const t=this._getToolbar(),e=t.getContent();return e.some(t=>!(t instanceof f)&&t.getVisible())};return I});
//# sourceMappingURL=ActionsStrip.js.map