/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./ActionsToolbarRenderer","sap/base/strings/capitalize","sap/ui/core/Control","sap/m/library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/m/Button","sap/ui/base/ManagedObjectObserver","sap/ui/integration/cards/actions/CardActions","sap/m/Menu","sap/m/MenuItem"],function(t,e,i,n,s,o,r,a,c,u,g,p){"use strict";var h=n.ButtonType;var l=r.aria.HasPopup;function f(t,e,i,n){return new Promise(function(s){var o;if(typeof i==="function"){o=i(n);if(o instanceof Promise){o.then(function(i){t.setProperty(e,i);s()});return}}else{o=i}t.setProperty(e,o);s()})}var b=i.extend("sap.ui.integration.controls.ActionsToolbar",{metadata:{library:"sap.ui.integration",properties:{},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true},_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_actionsMenu:{type:"sap.m.Menu",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:t});b.prototype.init=function(){var t=o.getResourceBundleFor("sap.ui.integration");this.setAggregation("_actionsMenu",new g({title:t.getText("CARD_ACTIONS")}));this._aActions=[];this._mActionObservers=new Map;this._oObserver=new c(this._observeActionsAggregation.bind(this));this._oObserver.observe(this,{aggregations:["actionDefinitions"]})};b.prototype.exit=function(){this._aActions=null;this._oObserver.disconnect();this._oObserver=null;this._mActionObservers.clear();this._mActionObservers=null};b.prototype.onBeforeRendering=function(){this._updateVisibility()};b.prototype.initializeContent=function(t){var e=this,i,n=[],s=[],o=this.getAggregation("_actionsMenu"),r=t.getHostInstance(),a=t.getAggregation("_extension");if(r){s=s.concat(r.getActions()||[])}if(a){s=s.concat(a.getActions()||[])}this._aActions=s;s.forEach(function(t){i=e._createActionMenuItem(t,false);n.push(i)});if(this._aMenuItems){this._aMenuItems.forEach(function(t){t.destroy()})}n.forEach(o.addItem,o);this._aMenuItems=n;this._refreshMenuItems().then(this._updateVisibility.bind(this))};b.prototype._open=function(){this._refreshMenuItems().then(function(){this.getAggregation("_actionsMenu").openBy(this._getToolbar())}.bind(this))};b.prototype._getToolbar=function(){var t=o.getResourceBundleFor("sap.ui.integration");var e=this.getAggregation("_toolbar");if(!e){e=new a({id:this.getId()+"-overflowButton",icon:"sap-icon://overflow",type:h.Transparent,ariaHasPopup:l.Menu,tooltip:t.getText("CARD_ACTIONS_OVERFLOW_BUTTON_TOOLTIP"),press:function(t){this._open()}.bind(this)});this.setAggregation("_toolbar",e)}return e};b.prototype._refreshMenuItems=function(){const t=[];this._refreshRecursiveMenuItems(this._aActions,this._aMenuItems,t);return Promise.all(t)};b.prototype._refreshRecursiveMenuItems=function(t,e,i){const n=this.getCardInstance();if(!t||!e){return}t.forEach((t,s)=>{const o=e[s];i.push(f(o,"enabled",t.enabled,n));i.push(f(o,"visible",t.visible,n));this._refreshRecursiveMenuItems(t.actions,o.getItems(),i)})};b.prototype._createActionMenuItem=function(t,e){var i=e?this._getActionConfig(t):t;const n=[];const s=e?i.actionDefinitions:i.actions;if(s){s.forEach(t=>{n.push(this._createActionMenuItem(t,e))})}var o=new p({icon:i.icon,text:i.text,tooltip:i.tooltip,startsSection:i.startsSection,visible:e?i.visible:false,items:n,press:function(i){var n=e?this._getActionConfig(t):t;if(n.actionDefinitions?.length>0||n.actions?.length>0){return}u.fireAction({card:this.getCardInstance(),host:this.getCardInstance().getHostInstance(),action:n,parameters:n.parameters,source:i.getSource()})}.bind(this)});if(e){o.setEnabled(i.enabled);t.setAssociation("_menuItem",o);this._attachObservers(t)}return o};b.prototype._updateVisibility=function(){var t=this.getAggregation("_actionsMenu").getItems().some(function(t){return t.getVisible()});this.setVisible(t)};b.prototype.updateVisibility=function(){this._updateVisibility()};b.prototype._getActionConfig=function(t){var i=["visible","enabled","icon","text","tooltip","parameters","type","actionDefinitions","startsSection"].reduce(function(i,n){i[n]=t["get"+e(n)]();return i},{});i.action=function(){t.firePress()};return i};b.prototype._observeActionsAggregation=function(t){const e=t.child,i=t.object;if(t.mutation==="insert"){const t=this._createActionMenuItem(e,true),n=i.indexOfActionDefinition(e);let o;if(i.isA("sap.ui.integration.ActionDefinition")){o=s.getElementById(i.getAssociation("_menuItem"))}else{o=this.getAggregation("_actionsMenu")}o.insertItem(t,n);this._updateVisibility()}else if(t.mutation==="remove"){s.getElementById(e.getAssociation("_menuItem")).destroy();this._detachObservers(e)}};b.prototype._attachObservers=function(t){this._oObserver.observe(t,{aggregations:["actionDefinitions"]});var e=new c(this._observeSingleAction.bind(this));e.observe(t,{properties:true,aggregations:["tooltip"]});this._mActionObservers.set(t.getId(),e)};b.prototype._detachObservers=function(t){this._oObserver.unobserve(t);this._mActionObservers.get(t.getId()).disconnect();this._mActionObservers.delete(t.getId())};b.prototype._observeSingleAction=function(t){var i=t.object,n=t.name,o=s.getElementById(i.getAssociation("_menuItem")),r=t.current;if(["type","parameters"].indexOf(n)!==-1){return}if(t.type==="aggregation"&&n!=="actionDefinitions"){r=t.child}o["set"+e(n)](r);this._updateVisibility()};b.prototype.setEnabled=function(t){var e=this._getToolbar();if(t){e.setEnabled(true)}else{this.getAggregation("_actionsMenu").close();e.setEnabled(false)}};b.prototype.getCardInstance=function(){return s.getElementById(this.getCard())};return b});
//# sourceMappingURL=ActionsToolbar.js.map